/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import kafka.catalog.InMemoryLocalStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InMemoryLocalStoreTest {
    private InMemoryLocalStore store;
    String tenant1 = "lkc-abcde";
    String tenant2 = "lkc-efghi";
    String topic1 = this.tenant1 + "_my-topic";
    String topic2 = this.tenant1 + "_my-topic2";
    String topic3 = this.tenant2 + "_other-topic";
    MetadataEvent event1 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic1)).build();
    MetadataEvent event2 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic2)).build();
    MetadataEvent event3 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic3)).build();

    @BeforeEach
    void setup() {
        this.store = new InMemoryLocalStore();
    }

    @Test
    void TestStoreAdd() {
        this.store.addMetadataEvent(this.tenant1, this.topic1, this.event1);
        this.store.addMetadataEvent(this.tenant2, this.topic3, this.event3);
        Assertions.assertTrue((boolean)this.store.logicalClusters().contains(this.tenant1));
        Assertions.assertTrue((boolean)this.store.topics(this.tenant1).contains(this.topic1));
        Assertions.assertEquals((Object)this.event1, (Object)this.store.metadataEvent(this.topic1));
        Assertions.assertEquals((int)2, (int)this.store.logicalClusters().size());
        Assertions.assertTrue((boolean)this.store.logicalClusters().contains(this.tenant2));
        Assertions.assertTrue((boolean)this.store.topics(this.tenant2).contains(this.topic3));
        Assertions.assertEquals((Object)this.event3, (Object)this.store.metadataEvent(this.topic3));
    }

    @Test
    void TestStoreDelete() {
        this.store.addMetadataEvent(this.tenant1, this.topic1, this.event1);
        this.store.addMetadataEvent(this.tenant1, this.topic2, this.event2);
        this.store.removeMetadataEvent(this.tenant1, this.topic1);
        Assertions.assertEquals((int)1, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)1, (int)this.store.topics(this.tenant1).size());
        Assertions.assertNull((Object)this.store.metadataEvent(this.topic1));
        this.store.removeMetadataEvent(this.tenant1, this.topic2);
        Assertions.assertNull((Object)this.store.metadataEvent(this.topic2));
        Assertions.assertTrue((boolean)this.store.logicalClusters().isEmpty());
        Assertions.assertEquals((int)0, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant1).size());
    }

    @Test
    void TestStoreClear() {
        this.store.addMetadataEvent(this.tenant1, this.topic1, this.event1);
        this.store.addMetadataEvent(this.tenant2, this.topic3, this.event3);
        this.store.clear();
        Assertions.assertEquals((int)0, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant1).size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant2).size());
    }

    @Test
    void TestStoreInvalidInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addMetadataEvent("lkc-abc", "topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addMetadataEvent("lkc-abc", "lkc-cdf_topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addMetadataEvent("lkc-abc", "lkc-abc-topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeMetadataEvent("lkc-abc", "topic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeMetadataEvent("lkc-abc", "lkc-cdf_topic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeMetadataEvent("lkc-abc", "lkc-abc-topic"));
        Assertions.assertEquals((int)0, (int)this.store.topics("doesn't exist").size());
        Assertions.assertNull((Object)this.store.metadataEvent("topic doesn't exist"));
    }
}

