/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.log.LogConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.JavaConverters;

public class MetadataEventUtilsTest {
    String tenant = "lkc-12345";
    String tenantPrefix = "lkc-12345_";

    private MetadataEvent getTestMetadataEvent(Uuid topicId) {
        Properties logProps = new Properties();
        logProps.setProperty(LogConfig.RetentionMsProp(), "100");
        logProps.setProperty(LogConfig.RetentionBytesProp(), "-1");
        logProps.setProperty("confluent.schema.registry.url", "foo");
        logProps.setProperty("confluent.schema.validator.interceptor.class", InterceptorUtils.MockRecordInterceptor.class.getName());
        logProps.setProperty(LogConfig.KeySchemaValidationEnableProp(), "false");
        logProps.setProperty(LogConfig.ValueSchemaValidationEnableProp(), "true");
        logProps.setProperty(LogConfig.CleanupPolicyProp(), String.format("%s, %s", LogConfig.Delete(), LogConfig.Compact()));
        Set override = Collections.emptySet();
        LogConfig logConfig = LogConfig.apply((Map)logProps, (scala.collection.immutable.Set)JavaConverters.asScalaSet(override).toSet());
        return MetadataEventUtils.topicMetadataEventFromLogConfig((LogConfig)logConfig, (String)(this.tenantPrefix + topicId), (Uuid)topicId, (int)1, (int)2, null, null);
    }

    @Test
    public void testBuildTopicMetadataEventFromLogConfig() {
        Uuid topicId = Uuid.randomUuid();
        MetadataEvent event = this.getTestMetadataEvent(topicId);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
    }

    @Test
    public void testBuildMetadataChange() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestMetadataEvent(topicId1);
        MetadataEvent event2 = this.getTestMetadataEvent(topicId2);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Assertions.assertEquals((Object)OpType.SNAPSHOT, (Object)change.getOp());
        Assertions.assertEquals((int)2, (int)change.getEventsCount());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
        Assertions.assertEquals((Object)topicId2.toString(), (Object)change.getEvents(1).getTopicMetadata().getTopicId());
        change = MetadataEventUtils.topicCreateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.CREATE, (Object)change.getOp());
        change = MetadataEventUtils.topicUpdateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.UPDATE, (Object)change.getOp());
        change = MetadataEventUtils.topicDeleteEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.DELETE, (Object)change.getOp());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
    }

    @Test
    public void testBuildCloudEvent() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestMetadataEvent(topicId1);
        MetadataEvent event2 = this.getTestMetadataEvent(topicId2);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Event snapshotCloudEvent = MetadataEventUtils.topicMetadataSnapshotCloudEvent((MetadataChange)change, (int)0, (String)"_catalog_kafka_topic", (int)0, (int)1);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)"crn://confluent.cloud/kafka=lkc-12345/topics", (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"catalog-topic-metadata-exporter", (Object)snapshotCloudEvent.subject());
        Assertions.assertEquals((Object)"TOPIC_SNAPSHOT", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"_catalog_kafka_topic", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertEquals((Object)"1", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.total.name()));
        change = MetadataEventUtils.topicCreateEvent((String)this.tenant, (MetadataEvent)event1);
        snapshotCloudEvent = MetadataEventUtils.topicMetadataDeltaCloudEvent((MetadataChange)change, (int)1, null);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)("crn://confluent.cloud/kafka=lkc-12345/topic=" + this.tenantPrefix + topicId1), (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"TOPIC_DELTA", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"1", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.total.name()));
    }

    @Test
    public void testPaginationInput() {
        Assertions.assertTrue((boolean)MetadataEventUtils.checkIsPagination((int)0, (int)1));
        Assertions.assertTrue((boolean)MetadataEventUtils.checkIsPagination((int)1, (int)10));
        Assertions.assertFalse((boolean)MetadataEventUtils.checkIsPagination((int)-1, (int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)2, (int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)10, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)0, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)1, (int)1));
    }
}

