/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kafka.catalog.MetadataEventUtils;
import kafka.controller.KafkaController;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ZK, brokers=3)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\r\u001a\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006Y\u0001!\t!\f\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u00191\u0004\u0001)A\u0005g!)q\u0007\u0001C\u0001q!)1\t\u0001C\u0001q!)\u0011\u000b\u0001C\u0001q!)a\f\u0001C\u0001q!)q\r\u0001C\u0001q!)Q\u000e\u0001C\u0005]\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002\"CA6\u0001E\u0005I\u0011BA7\u0011%\t\t\tAI\u0001\n\u0013\t\u0019\tC\u0005\u0002\b\u0002\t\n\u0011\"\u0003\u0002\n\"I\u0011Q\u0012\u0001\u0012\u0002\u0013%\u0011q\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011%\t\u0019\u000bAI\u0001\n\u0013\ty\tC\u0004\u0002&\u0002!I!a*\t\u0013\u0005]\u0006!%A\u0005\n\u0005%\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\u0007\u00033\u0004A\u0011\u0002\u001d\t\r\u0005m\u0007\u0001\"\u00039\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\u0014!EW&NKR\fG-\u0019;b\u0007>dG.Z2u_JLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u000e\u001c\u0003\u001d\u0019\u0017\r^1m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\t9#&D\u0001)\u0015\tI3$\u0001\u0003uKN$\u0018BA\u0016)\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u00023!)QE\u0001a\u0001M\u0005Q\u0011JT%U?\u0016\u0003vj\u0011%\u0016\u0003M\u0002\"\u0001\t\u001b\n\u0005U\n#aA%oi\u0006Y\u0011JT%U?\u0016\u0003vj\u0011%!\u0003u!Xm\u001d;NKR\fG-\u0019;b\u0007>dG.Z2u_J$\u0015n]1cY\u0016$G#A\u001d\u0011\u0005\u0001R\u0014BA\u001e\"\u0005\u0011)f.\u001b;)\u0005\u0015i\u0004C\u0001 B\u001b\u0005y$B\u0001!)\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0005~\u00121b\u00117vgR,'\u000fV3ti\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G\u000e\\3di>\u0014XI\\1cY\u0016$\u0007\u0006\u0002\u0004>\u000b\u001a\u000b\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u0003\u001d[S\u0001S&M\u001d>\u0003\"AP%\n\u0005){$!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018%A'\u0002E\r|gN\u001a7vK:$hfY1uC2|wML2pY2,7\r^8s]\u0015t\u0017M\u00197f\u0003\u00151\u0018\r\\;fC\u0005\u0001\u0016\u0001\u0002;sk\u0016\fA\u0003^3tiR{\u0007/[2EK2$\u0018-\u0012<f]R\u001c\b\u0006B\u0004>\u000bNc3a\u0012+ZW\u0015A5*\u0016(XC\u00051\u0016aM2p]\u001adW/\u001a8u]\r\fG/\u00197pO:\u001aw\u000e\u001c7fGR|'OL:oCB\u001c\bn\u001c;/S:LGO\f3fY\u0006Lhf]3dC\u0005A\u0016AA\u001a1W\u0015A5J\u0017(]C\u0005Y\u0016\u0001E7fiJL7M\f:fa>\u0014H/\u001a:tC\u0005i\u0016aI6bM.\fg\u0006^3ti:junY6Fm\u0016tG/R7jiR,'\u000f\u0015:pm&$WM]\u0001\u0018i\u0016\u001cH\u000fV8qS\u000e\u001cf.\u00199tQ>$XI^3oiNDC\u0001C\u001fFA2\"q)\u00193ZW\u0015A5*\u0016(cC\u0005\u0019\u0017!\u0001\u001a,\u000b![UM\u00142\"\u0003\u0019\f\u0011gY8oM2,XM\u001c;/G\u0006$\u0018\r\\8h]\r|G\u000e\\3di>\u0014hf\u001d8baNDw\u000e\u001e\u0018j]R,'O^1m]M,7-A\u000buKN$X*\u001e7uSR+g.\u00198u\u000bZ,g\u000e^:)\t%iT)\u001b\u0017\u0005\u000f*$\u0017lK\u0003I\u0017Vs5.I\u0001m\u0003\u0005\u0001\u0014aD4fi2\u000b7\u000f\u001e(fo\u00163XM\u001c;\u0015\u000f=\f\t!a\u0003\u00026A\u0019\u0001\u0005\u001d:\n\u0005E\f#AB(qi&|g\u000e\u0005\u0002t}6\tAO\u0003\u0002vm\u00061QM^3oiNT!a\u001e=\u0002\u0007\u0005\u0004\u0018N\u0003\u0002zu\u0006IA/\u001a7f[\u0016$(/\u001f\u0006\u0003wr\f\u0011bY8oM2,XM\u001c;\u000b\u0003u\f!![8\n\u0005}$(!B#wK:$\bbBA\u0002\u0015\u0001\u0007\u0011QA\u0001\u0011[>\u001c7.\u0012<f]R,U.\u001b;uKJ\u00042a]A\u0004\u0013\r\tI\u0001\u001e\u0002\r\u000bZ,g\u000e^#nSR$XM\u001d\u0005\b\u0003\u001bQ\u0001\u0019AA\b\u0003!)g/\u001a8u\u0013\u0012\u001c\bCBA\t\u00037\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u001diW\u000f^1cY\u0016T1!!\u0007\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\t\u0019BA\u0002TKR\u0004B!!\t\u000209!\u00111EA\u0016!\r\t)#I\u0007\u0003\u0003OQ1!!\u000b\u001e\u0003\u0019a$o\\8u}%\u0019\u0011QF\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\ti#\t\u0005\b\u0003oQ\u0001\u0019AA\u0010\u0003%)g/\u001a8u)f\u0004X-\u0001\twKJLg-\u001f#fYR\fWI^3oiRy\u0011(!\u0010\u0002B\u0005\u0015\u0013\u0011JA(\u00037\n9\u0007\u0003\u0004\u0002@-\u0001\rA]\u0001\u0006KZ,g\u000e\u001e\u0005\b\u0003\u0007Z\u0001\u0019AA\u0010\u0003\u0019!XM\\1oi\"9\u0011qI\u0006A\u0002\u0005}\u0011!\u0003;pa&\u001cg*Y7f\u0011%\tYe\u0003I\u0001\u0002\u0004\ti%A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004AA\u001c\u0004\"CA)\u0017A\u0005\t\u0019AA*\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\t\u0005AA\f)\u0006E\u0002!\u0003/J1!!\u0017\"\u0005\u0015\u0019\u0006n\u001c:u\u0011%\tif\u0003I\u0001\u0002\u0004\ty&A\u0005sKR,g\u000e^5p]B!\u0001\u0005]A1!\r\u0001\u00131M\u0005\u0004\u0003K\n#\u0001\u0002'p]\u001eD\u0001\"!\u001b\f!\u0003\u0005\raM\u0001\u0006KB|7\r[\u0001\u001bm\u0016\u0014\u0018NZ=EK2$\u0018-\u0012<f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003_RC!!\u0014\u0002r-\u0012\u00111\u000f\t\u0005\u0003k\ni(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003%)hn\u00195fG.,GM\u0003\u0002AC%!\u0011qPA<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bm\u0016\u0014\u0018NZ=EK2$\u0018-\u0012<f]R$C-\u001a4bk2$H%N\u000b\u0003\u0003\u000bSC!a\u0015\u0002r\u0005Qb/\u001a:jMf$U\r\u001c;b\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u0012\u0016\u0005\u0003?\n\t(\u0001\u000ewKJLg-\u001f#fYR\fWI^3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u0002\u0012*\u001a1'!\u001d\u0002'Y,'/\u001b4z':\f\u0007o\u001d5pi\u00163XM\u001c;\u0015\u001be\n9*!'\u0002\u001c\u0006u\u0015qTAQ\u0011\u0019\ty\u0004\u0005a\u0001e\"9\u00111\t\tA\u0002\u0005}\u0001bBA$!\u0001\u0007\u0011q\u0004\u0005\u0007\u0003\u0017\u0002\u0002\u0019A\u001a\t\u000f\u0005E\u0003\u00031\u0001\u0002V!A\u0011\u0011\u000e\t\u0011\u0002\u0003\u00071'A\u000fwKJLg-_*oCB\u001c\bn\u001c;Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-1XM]5gs\u00163XM\u001c;\u0015\u001fe\nI+a+\u0002.\u0006=\u0016\u0011WAZ\u0003kCa!a\u0010\u0013\u0001\u0004\u0011\bbBA\"%\u0001\u0007\u0011q\u0004\u0005\b\u0003\u000f\u0012\u0002\u0019AA\u0010\u0011\u0019\tIG\u0005a\u0001g!9\u00111\n\nA\u0002\u00055\u0003bBA)%\u0001\u0007\u00111\u000b\u0005\n\u0003;\u0012\u0002\u0013!a\u0001\u0003?\nQC^3sS\u001aLXI^3oi\u0012\"WMZ1vYR$s'A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0005\u0003{\u000bI\r\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019mG\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BAd\u0003\u0003\u0014qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\b\u0003\u0017$\u0002\u0019AAg\u0003\u0019\u0011'o\\6feB!\u0011qZAk\u001b\t\t\tNC\u0002\u0002Tn\taa]3sm\u0016\u0014\u0018\u0002BAl\u0003#\u00141bS1gW\u0006\u0014%o\\6fe\u0006\u00112m\u001c8ue>dG.\u001a:GC&dwN^3s\u0003q1XM]5gs>sG._(oK\u0006\u001bG/\u001b<f\u0007>dG.Z2u_J\fQc]3ukBlunY6Fm\u0016tG/R7jiR,'\u000f\u0006\u0002\u0002\u0006!2\u0001!a9O\u0003s\u0004B!!:\u0002v6\u0011\u0011q\u001d\u0006\u0004o\u0006%(\u0002BAv\u0003[\fqA[;qSR,'O\u0003\u0003\u0002p\u0006E\u0018!\u00026v]&$(BAAz\u0003\ry'oZ\u0005\u0005\u0003o\f9OA\u0002UC\u001e\f#!a?\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\f\u0001\u0005}(Q\u0001B\u0004\u0005#\u0011\u0019\u0002E\u0002?\u0005\u0003I1Aa\u0001@\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0005\t%\u0011\u0002\u0002B\u0006\u0005\u001b\t!AW&\u000b\u0007\t=q(\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0007!2\u0001Aa\u0006O\u0005G\u0001BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0005\u0005;\t9/A\u0005fqR,gn]5p]&!!\u0011\u0005B\u000e\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u0005K\u0019#Aa\n\u0011\t\t%\"QF\u0007\u0003\u0005WQ1!a<)\u0013\u0011\u0011yCa\u000b\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\u0002")
public class ZKMetadataCollectorIntegrationTest {
    private final ClusterInstance cluster;
    private final int INIT_EPOCH;

    public int INIT_EPOCH() {
        return this.INIT_EPOCH;
    }

    @ClusterTest
    public void testMetadataCollectorDisabled() {
        this.cluster.waitForReadyBrokers();
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).map((Function1 & Serializable & scala.Serializable)broker -> ZKMetadataCollectorIntegrationTest.getController$1(broker), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)controller -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMetadataCollectorDisabled$2(controller);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true")})
    public void testMetadataCollectorEnabled() {
        this.cluster.waitForReadyBrokers();
        this.verifyOnlyOneActiveCollector();
        this.controllerFailover();
        this.verifyOnlyOneActiveCollector();
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="30"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicDeltaEvents() {
        this.cluster.waitForReadyBrokers();
        Set eventIds = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 2;
        short replicationFactor = 2;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName, numPartitions, replicationFactor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$1(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event topicCreationEvent = (Event)((Option)lastNewEvent.elem).get();
        this.verifyDeltaEvent(topicCreationEvent, tenant, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), this.verifyDeltaEvent$default$6(), this.verifyDeltaEvent$default$7());
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fullTopicName), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionsMap).asJava()).values().get(fullTopicName)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$3(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event partitionsChangeEvent = (Event)((Option)lastNewEvent.elem).get();
        this.verifyDeltaEvent(partitionsChangeEvent, tenant, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), this.verifyDeltaEvent$default$6(), this.verifyDeltaEvent$default$7());
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, fullTopicName);
        long newRetention = 100000L;
        ConfigEntry retentionEntry = new ConfigEntry("retention.ms", Long.toString(newRetention));
        AlterConfigOp op = new AlterConfigOp(retentionEntry, AlterConfigOp.OpType.SET);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJava())}));
        ((KafkaFuture)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)configs).asJava()).values().get(resource)).get();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$5(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event retentionChangeEvent = (Event)((Option)lastNewEvent.elem).get();
        this.verifyDeltaEvent(retentionChangeEvent, tenant, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newNumPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newRetention)), this.verifyDeltaEvent$default$7());
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        adminClient.deleteTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)fullTopicName, (List)Nil$.MODULE$)).asJava()).all().get();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$7(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicDeltaEvents$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event topicDeletionEvent = (Event)((Option)lastNewEvent.elem).get();
        this.verifyDeltaEvent(topicDeletionEvent, tenant, topic, this.verifyDeltaEvent$default$4(), this.verifyDeltaEvent$default$5(), this.verifyDeltaEvent$default$6(), this.verifyDeltaEvent$default$7());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="2"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testTopicSnapshotEvents() {
        this.cluster.waitForReadyBrokers();
        Set eventIds = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef lastNewEvent = ObjectRef.create((Object)None$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant = "lkc-t1";
        String topic = "topic1";
        String fullTopicName = new StringBuilder(1).append(tenant).append("_").append(topic).toString();
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName, numPartitions, replicationFactor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$1(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent = (Event)((Option)lastNewEvent.elem).get();
        this.verifySnapshotEvent(snapshotEvent, tenant, topic, numPartitions, replicationFactor, this.verifySnapshotEvent$default$6());
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        int newNumPartitions = 3;
        scala.collection.immutable.Map partitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fullTopicName), (Object)NewPartitions.increaseTo((int)newNumPartitions))}));
        ((KafkaFuture)adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionsMap).asJava()).values().get(fullTopicName)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$3(this, lastNewEvent, mockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent2 = (Event)((Option)lastNewEvent.elem).get();
        this.verifySnapshotEvent(snapshotEvent2, tenant, topic, newNumPartitions, replicationFactor, this.verifySnapshotEvent$default$6());
        Mockito.mockingDetails((Object)mockEventEmitter).getInvocations().clear();
        this.controllerFailover();
        int newEpoch = this.INIT_EPOCH() + 1;
        EventEmitter newMockEventEmitter = (EventEmitter)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).map((Function1 & Serializable & scala.Serializable)broker -> this.getController((KafkaBroker)broker), Iterable$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isActive())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.metadataCollector()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.eventEmitter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)newMockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$10(this, lastNewEvent, newMockEventEmitter, eventIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testTopicSnapshotEvents$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Event snapshotEvent3 = (Event)((Option)lastNewEvent.elem).get();
        this.verifySnapshotEvent(snapshotEvent3, tenant, topic, newNumPartitions, replicationFactor, newEpoch);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.init.delay.sec", value="0"), @ClusterConfigProperty(key="confluent.catalog.collector.snapshot.interval.sec", value="2"), @ClusterConfigProperty(key="metric.reporters", value="kafka.test.MockEventEmitterProvider")})
    public void testMultiTenantEvents() {
        this.cluster.waitForReadyBrokers();
        Set eventIds = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set newEvents = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        EventEmitter mockEventEmitter = this.setupMockEventEmitter();
        String tenant1 = "lkc-t1";
        String tenant2 = "lkc-t2";
        String topic1 = "topic1";
        String fullTopicName1 = new StringBuilder(1).append(tenant1).append("_").append(topic1).toString();
        String topic2 = "topic2";
        String fullTopicName2 = new StringBuilder(1).append(tenant1).append("_").append(topic2).toString();
        String topic3 = "topic3";
        String fullTopicName3 = new StringBuilder(1).append(tenant2).append("_").append(topic3).toString();
        scala.collection.mutable.Map mapping = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant1), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant2), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic3})))}));
        int numPartitions = 1;
        short replicationFactor = 1;
        Admin adminClient = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName1, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName2, numPartitions, replicationFactor);
        IntegrationTestUtils$.MODULE$.createTopic(adminClient, fullTopicName3, numPartitions, replicationFactor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$1(this, mockEventEmitter, eventIds, newEvents)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableLike)newEvents.map((Function1 & Serializable & scala.Serializable)event -> MetadataChange.parseFrom((byte[])((byte[])event.data().get())), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)change -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$4(mapping, change);
            return BoxedUnit.UNIT;
        });
        mapping.values().foreach((Function1 & Serializable & scala.Serializable)pendingTopics -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$testMultiTenantEvents$7(pendingTopics);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Event> getLastNewEvent(EventEmitter mockEventEmitter, Set<String> eventIds, String eventType) {
        return ((IterableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(Mockito.mockingDetails((Object)mockEventEmitter).getInvocations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Event)x$6.getArgument(0), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZKMetadataCollectorIntegrationTest.$anonfun$getLastNewEvent$2(eventType, x$7)))).find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)eventIds.add((Object)e.id())));
    }

    private void verifyDeltaEvent(Event event, String tenant, String topicName, Option<Object> numPartitions, Option<Object> replicationFactor, Option<Object> retention, int epoch) {
        Assertions.assertEquals((Object)"TOPIC_DELTA", (Object)event.type(), (String)"Event type mismatched");
        Assertions.assertEquals((Object)MetadataEventUtils.deltaSourceUrl((String)tenant, (String)topicName), (Object)event.source().toString(), (String)"Event source mismatched");
        this.verifyEvent(event, tenant, topicName, epoch, numPartitions, replicationFactor, retention);
    }

    private Option<Object> verifyDeltaEvent$default$4() {
        return None$.MODULE$;
    }

    private Option<Object> verifyDeltaEvent$default$5() {
        return None$.MODULE$;
    }

    private Option<Object> verifyDeltaEvent$default$6() {
        return None$.MODULE$;
    }

    private int verifyDeltaEvent$default$7() {
        return this.INIT_EPOCH();
    }

    private void verifySnapshotEvent(Event event, String tenant, String topicName, int numPartitions, short replicationFactor, int epoch) {
        Assertions.assertEquals((Object)"TOPIC_SNAPSHOT", (Object)event.type(), (String)"Event type mismatched");
        Assertions.assertEquals((Object)MetadataEventUtils.snapshotSourceUrl((String)tenant), (Object)event.source().toString(), (String)"Event source mismatched");
        this.verifyEvent(event, tenant, topicName, epoch, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)replicationFactor)), this.verifyEvent$default$7());
    }

    private int verifySnapshotEvent$default$6() {
        return this.INIT_EPOCH();
    }

    private void verifyEvent(Event event, String tenant, String topicName, int epoch, Option<Object> numPartitions, Option<Object> replicationFactor, Option<Object> retention) {
        Assertions.assertEquals((Object)"catalog-topic-metadata-exporter", (Object)event.subject(), (String)"Event subject mismatched");
        Assertions.assertEquals((Object)"application/protobuf", (Object)event.dataContentType(), (String)"Event data content type mismatched");
        Assertions.assertEquals((Object)"telemetry.events.data_catalog_source", (Object)event.extension(MetadataEventUtils.Extensions.route.name()), (String)"Event route extension mismatched");
        Assertions.assertEquals((Object)tenant, (Object)event.extension(MetadataEventUtils.Extensions.partitionkey.name()), (String)"Event partition key extension mismatched");
        Assertions.assertEquals((Object)Integer.toString(epoch), (Object)event.extension(MetadataEventUtils.Extensions.epoch.name()), (String)"Event epoch extension mismatched");
        MetadataChange change = MetadataChange.parseFrom((byte[])((byte[])event.data().get()));
        Assertions.assertEquals((int)1, (int)change.getEventsCount(), (String)"MetadataChange count mismatched");
        Assertions.assertEquals((Object)topicName, (Object)change.getEvents(0).getTopicMetadata().getTopicName(), (String)"MetadataChange topic name mismatched");
        numPartitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> Assertions.assertEquals((int)x$8, (int)change.getEvents(0).getTopicMetadata().getPartitionsCount(), (String)"MetadataChange partition count mismatched"));
        replicationFactor.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$verifyEvent$2(change, BoxesRunTime.unboxToShort((Object)x$9));
            return BoxedUnit.UNIT;
        });
        retention.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$10 -> Assertions.assertEquals((long)x$10, (long)change.getEvents(0).getTopicMetadata().getRetentionMs(), (String)"MetadataChange retention mismatched"));
    }

    private Option<Object> verifyEvent$default$7() {
        return None$.MODULE$;
    }

    private KafkaController getController(KafkaBroker broker) {
        return ((KafkaServer)broker).kafkaController();
    }

    private void controllerFailover() {
        int activeControllerBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ZKMetadataCollectorIntegrationTest.$anonfun$controllerFailover$1(this, broker))).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ZKMetadataCollectorIntegrationTest.$anonfun$controllerFailover$2(x$11))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("No controller leader found, should not have happened");
        }));
        this.cluster.shutdownBroker(activeControllerBrokerId);
        this.cluster.startBroker(activeControllerBrokerId);
    }

    private void verifyOnlyOneActiveCollector() {
        IntRef activeCount = IntRef.create((int)0);
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).map((Function1 & Serializable & scala.Serializable)broker -> this.getController((KafkaBroker)broker), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)controller -> {
            ZKMetadataCollectorIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$2(activeCount, controller);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)activeCount.elem, (String)"Should have exactly one active collector");
    }

    /*
     * WARNING - void declaration
     */
    private EventEmitter setupMockEventEmitter() {
        void var1_1;
        EventEmitter mockEventEmitter = (EventEmitter)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).map((Function1 & Serializable & scala.Serializable)broker -> this.getController((KafkaBroker)broker), Iterable$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isActive())).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.metadataCollector()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.eventEmitter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("No event emitter found, should not have happened");
        });
        Mockito.when((Object)mockEventEmitter.emit((Event)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        return var1_1;
    }

    private static final KafkaController getController$1(KafkaBroker broker) {
        return ((KafkaServer)broker).kafkaController();
    }

    public static final /* synthetic */ void $anonfun$testMetadataCollectorDisabled$2(KafkaController controller) {
        Assertions.assertFalse((boolean)controller.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActive())));
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$1(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, Set eventIds$1) {
        lastNewEvent$1.elem = $this.getLastNewEvent(mockEventEmitter$1, (Set<String>)eventIds$1, "TOPIC_DELTA");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$3(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, Set eventIds$1) {
        lastNewEvent$1.elem = $this.getLastNewEvent(mockEventEmitter$1, (Set<String>)eventIds$1, "TOPIC_DELTA");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$5(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, Set eventIds$1) {
        lastNewEvent$1.elem = $this.getLastNewEvent(mockEventEmitter$1, (Set<String>)eventIds$1, "TOPIC_DELTA");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$6() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeltaEvents$7(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$1, EventEmitter mockEventEmitter$1, Set eventIds$1) {
        lastNewEvent$1.elem = $this.getLastNewEvent(mockEventEmitter$1, (Set<String>)eventIds$1, "TOPIC_DELTA");
        return ((Option)lastNewEvent$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeltaEvents$8() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$1(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, Set eventIds$2) {
        lastNewEvent$2.elem = $this.getLastNewEvent(mockEventEmitter$2, (Set<String>)eventIds$2, "TOPIC_SNAPSHOT");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$2() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$3(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$2, EventEmitter mockEventEmitter$2, Set eventIds$2) {
        lastNewEvent$2.elem = $this.getLastNewEvent(mockEventEmitter$2, (Set<String>)eventIds$2, "TOPIC_SNAPSHOT");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$4() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicSnapshotEvents$10(ZKMetadataCollectorIntegrationTest $this, ObjectRef lastNewEvent$2, EventEmitter newMockEventEmitter$1, Set eventIds$2) {
        lastNewEvent$2.elem = $this.getLastNewEvent(newMockEventEmitter$1, (Set<String>)eventIds$2, "TOPIC_SNAPSHOT");
        return ((Option)lastNewEvent$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicSnapshotEvents$11() {
        return "No events emitted";
    }

    public static final /* synthetic */ boolean $anonfun$testMultiTenantEvents$1(ZKMetadataCollectorIntegrationTest $this, EventEmitter mockEventEmitter$3, Set eventIds$3, Set newEvents$1) {
        Option<Event> lastEvent = $this.getLastNewEvent(mockEventEmitter$3, (Set<String>)eventIds$3, "TOPIC_SNAPSHOT");
        if (lastEvent.isDefined()) {
            newEvents$1.add(lastEvent.get());
        }
        return newEvents$1.size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testMultiTenantEvents$2() {
        return "Not enough events emitted";
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$4(scala.collection.mutable.Map mapping$1, MetadataChange change) {
        Set topics = (Set)mapping$1.apply((Object)change.getSource());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(change.getEventsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTopicMetadata().getTopicName(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)topics.remove((Object)elem)));
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantEvents$7(Set pendingTopics) {
        Assertions.assertTrue((boolean)pendingTopics.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$getLastNewEvent$2(String eventType$1, Event x$7) {
        return x$7.type().equals(eventType$1);
    }

    public static final /* synthetic */ void $anonfun$verifyEvent$2(MetadataChange change$1, short x$9) {
        Assertions.assertEquals((int)x$9, (int)change$1.getEvents(0).getTopicMetadata().getReplicationFactor(), (String)"MetadataChange replication factor mismatched");
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$1(ZKMetadataCollectorIntegrationTest $this, KafkaBroker broker) {
        return $this.getController(broker).isActive();
    }

    public static final /* synthetic */ int $anonfun$controllerFailover$2(KafkaBroker x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyOneActiveCollector$2(IntRef activeCount$1, KafkaController controller) {
        if (controller.isActive()) {
            Assertions.assertTrue((boolean)controller.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isActive())));
            ++activeCount$1.elem;
            return;
        }
        Assertions.assertFalse((boolean)controller.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isActive())));
    }

    public ZKMetadataCollectorIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.INIT_EPOCH = 1;
    }
}

