/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.Collections;
import java.util.Optional;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorConfig;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.CollectorStartupEvent;
import kafka.catalog.event.CollectorStopEvent;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.event.TopicConfigChangeEvent;
import kafka.catalog.event.TopicCreationEvent;
import kafka.catalog.event.TopicDeletionEvent;
import kafka.catalog.event.TopicPartitionChangeEvent;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;

public class ZKTopicMetadataCollectorTest {
    @Mock
    private ZKTopicMetadataCollectorConfig mockConfig;
    @Mock
    private KafkaConfig mockKafkaConfig;
    @Mock
    private KafkaZkClient mockZkClient;
    @Mock
    private MetadataCollectorEventQueue mockEventQueue;
    @Mock
    private Logger mockLogger;
    private ZKTopicMetadataCollectorContext context;
    private ZKTopicMetadataCollector collector;
    private ArgumentCaptor<MetadataCollectorEvent> submittedEvent;
    private Metrics metrics;
    private Time time;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.context = new ZKTopicMetadataCollectorContext(this.mockConfig, Collections.emptyMap(), this.mockEventQueue, this.metrics, this.mockZkClient, this.mockKafkaConfig, 0, this.time);
        this.submittedEvent = ArgumentCaptor.forClass(MetadataCollectorEvent.class);
        this.collector = new ZKTopicMetadataCollector(this.mockKafkaConfig, this.mockConfig, this.mockZkClient, this.metrics, this.mockLogger, this.mockEventQueue, Optional.of(this.context), this.time);
    }

    @Test
    public void testCollectorStart() {
        this.metrics = new Metrics();
        this.collector = new ZKTopicMetadataCollector(this.mockKafkaConfig, this.mockConfig, this.mockZkClient, this.metrics, this.mockLogger, this.mockEventQueue, Optional.empty(), this.time);
        this.collector.start(Collections.singletonMap("lkc-abc_topic1", new TopicInfo("lkc-abc_topic1", Uuid.randomUuid(), 1, 1)), 0);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(CollectorStartupEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorStop() {
        this.collector.stop();
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(CollectorStopEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicCreate() {
        this.collector.onTopicCreate(Collections.singletonMap("lkc-123_topic1", new TopicInfo("lkc-123_topic1", Uuid.randomUuid(), 1, 1)));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicCreationEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicDelete() {
        this.collector.onTopicDelete(Collections.singleton("lkc-123_topic1"));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicDeletionEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicConfigChange() {
        this.collector.onTopicConfigChange("lkc-123_topic1", null);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicConfigChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicPartitionChange() {
        this.collector.onTopicPartitionChange("lkc-123_topic1", 1);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicPartitionChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }
}

