/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManager$;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\req!\u0002(P\u0011\u0003!f!\u0002,P\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006b\u00021\u0002\u0005\u0004%\t!\u0019\u0005\u0007K\u0006\u0001\u000b\u0011\u00022\u0007\tY{\u0005A\u001a\u0005\u0006=\u0016!\ta\u001a\u0005\bA\u0016\u0011\r\u0011\"\u0001b\u0011\u0019)W\u0001)A\u0005E\"9\u0011.\u0002b\u0001\n\u0003\t\u0007B\u00026\u0006A\u0003%!\rC\u0004l\u000b\t\u0007I\u0011\u00017\t\ra,\u0001\u0015!\u0003n\u0011\u001dIXA1A\u0005\u0002iDq!a\u0001\u0006A\u0003%1\u0010C\u0006\u0002\u0006\u0015\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0001bCA\r\u000b\u0001\u0007\t\u0019!C\u0001\u00037A1\"a\n\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Y\u0011\u0011F\u0003A\u0002\u0003\u0007I\u0011AA\u0004\u0011-\tY#\u0002a\u0001\u0002\u0004%\t!!\f\t\u0017\u0005ER\u00011A\u0001B\u0003&\u0011\u0011\u0002\u0005\f\u0003g)\u0001\u0019!a\u0001\n\u0003\t9\u0001C\u0006\u00026\u0015\u0001\r\u00111A\u0005\u0002\u0005]\u0002bCA\u001e\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0013A1\"!\u0010\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\b!Y\u0011qH\u0003A\u0002\u0003\u0007I\u0011AA!\u0011-\t)%\u0002a\u0001\u0002\u0003\u0006K!!\u0003\t\u0017\u0005\u001dS\u00011AA\u0002\u0013\u0005\u0011\u0011\n\u0005\f\u0003/*\u0001\u0019!a\u0001\n\u0003\tI\u0006C\u0006\u0002^\u0015\u0001\r\u0011!Q!\n\u0005-\u0003bCA0\u000b\u0001\u0007\t\u0019!C\u0001\u0003CB1\"a \u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0002\"Y\u0011QQ\u0003A\u0002\u0003\u0005\u000b\u0015BA2\u0011-\t9)\u0002a\u0001\u0002\u0004%\t!!#\t\u0017\u0005EU\u00011AA\u0002\u0013\u0005\u00111\u0013\u0005\f\u0003/+\u0001\u0019!A!B\u0013\tY\tC\u0006\u0002\u001a\u0016\u0001\r\u00111A\u0005\u0002\u0005m\u0005bCAR\u000b\u0001\u0007\t\u0019!C\u0001\u0003KC1\"!+\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e\"Y\u00111V\u0003A\u0002\u0003\u0007I\u0011AAW\u0011-\ty,\u0002a\u0001\u0002\u0004%\t!!1\t\u0017\u0005\u0015W\u00011A\u0001B\u0003&\u0011q\u0016\u0005\n\u0003\u000f,!\u0019!C\u0001\u0003\u0013D\u0001\"!5\u0006A\u0003%\u00111\u001a\u0005\n\u0003',!\u0019!C\u0001\u0003+D\u0001\"a8\u0006A\u0003%\u0011q\u001b\u0005\n\u0003C,!\u0019!C\u0001\u0003GD\u0001\"!=\u0006A\u0003%\u0011Q\u001d\u0005\f\u0003g,\u0001\u0019!a\u0001\n\u0003\t)\u0010C\u0006\u0002~\u0016\u0001\r\u00111A\u0005\u0002\u0005}\bb\u0003B\u0002\u000b\u0001\u0007\t\u0011)Q\u0005\u0003oD\u0001B!\u0002\u0006\u0005\u0004%\t\u0001\u001c\u0005\b\u0005\u000f)\u0001\u0015!\u0003n\u0011%\u0011I!\u0002b\u0001\n\u0003\u0011Y\u0001\u0003\u0005\u0003\u001a\u0015\u0001\u000b\u0011\u0002B\u0007\u0011-\u0011Y\"\u0002a\u0001\u0002\u0004%\t!!\u0013\t\u0017\tuQ\u00011AA\u0002\u0013\u0005!q\u0004\u0005\f\u0005G)\u0001\u0019!A!B\u0013\tY\u0005C\u0005\u0003&\u0015\u0011\r\u0011\"\u0001\u0003(!A!qF\u0003!\u0002\u0013\u0011I\u0003C\u0005\u00032\u0015\u0011\r\u0011\"\u0001\u00034!A!1H\u0003!\u0002\u0013\u0011)\u0004C\u0005\u0003>\u0015\u0011\r\u0011\"\u0001\u0003@!A!QJ\u0003!\u0002\u0013\u0011\t\u0005C\u0005\u0003P\u0015\u0011\r\u0011\"\u0001\u0003R!A!qL\u0003!\u0002\u0013\u0011\u0019\u0006C\u0006\u0003b\u0015\u0001\r\u00111A\u0005\u0002\u0005m\u0005b\u0003B2\u000b\u0001\u0007\t\u0019!C\u0001\u0005KB1B!\u001b\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e\"9!1N\u0003\u0005\u0002\t5\u0004b\u0002BC\u000b\u0011\u0005!q\u0011\u0005\n\u0005g+\u0011\u0013!C\u0001\u0005kC\u0011Ba3\u0006#\u0003%\tA!4\t\u0013\tEW!%A\u0005\u0002\tM\u0007b\u0002BF\u000b\u0011E!q\u001b\u0005\b\u00053,A\u0011\u0001Bn\u0011\u001d\u0011i0\u0002C\u0001\u0005[Bqaa\u0002\u0006\t#\u0019I!A\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005A\u000b\u0016aB2mkN$XM\u001d\u0006\u0002%\u0006)1.\u00194lC\u000e\u0001\u0001CA+\u0002\u001b\u0005y%!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f^\n\u0003\u0003a\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001U\u0003!\u0011'o\\6fe&#W#\u00012\u0011\u0005e\u001b\u0017B\u00013[\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\u001a\"!\u0002-\u0015\u0003!\u0004\"!V\u0003\u0002\u001fI,Wn\u001c;f%\u0016\u0004H.[2b\u0013\u0012\f\u0001C]3n_R,'+\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\u000e\u0005\u0002om6\tqN\u0003\u0002qc\u000611m\\7n_:T!A\u0015:\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0005\u0003o>\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0011!\u0018.\\3\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT!A`)\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0005\u0005QP\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019!X\u000e\u001d#jeV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\tIwN\u0003\u0002\u0002\u0014\u0005!!.\u0019<b\u0013\u0011\t9\"!\u0004\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fH\u0003BA\u000f\u0003G\u00012!WA\u0010\u0013\r\t\tC\u0017\u0002\u0005+:LG\u000fC\u0005\u0002&A\t\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010J\u0019\u0002\u000fQl\u0007\u000fR5sA\u00059An\\4ESJ\f\u0014a\u00037pO\u0012K'/M0%KF$B!!\b\u00020!I\u0011QE\n\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\tY><G)\u001b:2A\u00059An\\4ESJ\u0014\u0014a\u00037pO\u0012K'OM0%KF$B!!\b\u0002:!I\u0011Q\u0005\f\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\tY><G)\u001b:3A\u00059An\\4ESJ\u001c\u0014a\u00037pO\u0012K'oM0%KF$B!!\b\u0002D!I\u0011QE\r\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\tY><G)\u001b:4A\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u0013+A\u0002m_\u001eLA!!\u0016\u0002P\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u0011QDA.\u0011%\t)\u0003HA\u0001\u0002\u0004\tY%A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!F1mi\u0016\u0014\b+\u0019:uSRLwN\\'b]\u0006<WM]\u000b\u0003\u0003G\u0002B!!\u001a\u0002z9!\u0011qMA;\u001d\u0011\tI'a\u001d\u000f\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001cT\u0003\u0019a$o\\8u}%\t!+\u0003\u0002\u007f#&\u0019\u0011qO?\u0002\u0013Q+7\u000f^+uS2\u001c\u0018\u0002BA>\u0003{\u0012\u0011$T8dW\u0006cG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4fe*\u0019\u0011qO?\u00023\u0005dG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003;\t\u0019\tC\u0005\u0002&}\t\t\u00111\u0001\u0002d\u00051\u0012\r\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\b%\u0001\fbYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s+\t\tY\t\u0005\u0003\u0002f\u00055\u0015\u0002BAH\u0003{\u0012!$T8dW\u0006cG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ\f!$\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]0%KF$B!!\b\u0002\u0016\"I\u0011Q\u0005\u0012\u0002\u0002\u0003\u0007\u00111R\u0001\u0018C2$XM\u001d)beRLG/[8o\u0019&\u001cH/\u001a8fe\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u0005u\u0005\u0003BA'\u0003?KA!!)\u0002P\tIAj\\4D_:4\u0017nZ\u0001\u000eY><7i\u001c8gS\u001e|F%Z9\u0015\t\u0005u\u0011q\u0015\u0005\n\u0003K)\u0013\u0011!a\u0001\u0003;\u000b!\u0002\\8h\u0007>tg-[4!\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0006\u0002\u00020B!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016\u0001C7fi\u0006$\u0017\r^1\u000b\u0007\u0005e\u0016+\u0001\u0004tKJ4XM]\u0005\u0005\u0003{\u000b\u0019L\u0001\u000bN_\u000e\\7i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0015G>tg-[4SKB|7/\u001b;pef|F%Z9\u0015\t\u0005u\u00111\u0019\u0005\n\u0003KA\u0013\u0011!a\u0001\u0003_\u000b\u0011cY8oM&<'+\u001a9pg&$xN]=!\u0003E!W\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003\u0017\u00042!VAg\u0013\r\tym\u0014\u0002\u0012\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\u0018A\u00053fY\u0006LX\rZ(qKJ\fG/[8og\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",WCAAl!\u0011\tI.a7\u000e\u0005\u0005]\u0016\u0002BAo\u0003o\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0012_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001cXCAAs!\u0011\t9/!<\u000e\u0005\u0005%(\u0002BAv\u0003o\u000b1b\u00195fG.\u0004x.\u001b8ug&!\u0011q^Au\u0005EyeMZ:fi\u000eCWmY6q_&tGo]\u0001\u0013_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\b%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011q\u001f\t\u0004+\u0006e\u0018bAA~\u001f\nI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\u0005u!\u0011\u0001\u0005\n\u0003K\t\u0014\u0011!a\u0001\u0003o\f!\u0002]1si&$\u0018n\u001c8!\u0003Q!\u0018.\u001a:fIR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)B/[3sK\u0012$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0006;jKJ,G\rV8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0005\t5\u0001\u0003\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tM\u0011+\u0001\u0003uS\u0016\u0014\u0018\u0002\u0002B\f\u0005#\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002/QLWM]3e)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013!\u0006;jKJ,e.\u00192mK\u0012dunZ'b]\u0006<WM]\u0001\u001ai&,'/\u00128bE2,G\rT8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\t\u0005\u0002\"CA\u0013q\u0005\u0005\t\u0019AA&\u0003Y!\u0018.\u001a:F]\u0006\u0014G.\u001a3M_\u001el\u0015M\\1hKJ\u0004\u0013A\u0005;jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ,\"A!\u000b\u0011\t\t=!1F\u0005\u0005\u0005[\u0011\tB\u0001\nUS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0005;jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013!\u0005;jKJdunZ\"p[B|g.\u001a8ugV\u0011!Q\u0007\t\u0005\u0003\u001b\u00129$\u0003\u0003\u0003:\u0005=#!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006\u0011B/[3s\u0019><7i\\7q_:,g\u000e^:!\u00035\u0019G.^:uKJd\u0015N\\6JIV\u0011!\u0011\t\t\u0005\u0005\u0007\u0012I%\u0004\u0002\u0003F)!!qIA\t\u0003\u0011)H/\u001b7\n\t\t-#Q\t\u0002\u0005+VKE)\u0001\bdYV\u001cH/\u001a:MS:\\\u0017\n\u001a\u0011\u0002\u0011\u0015DXmY;u_J,\"Aa\u0015\u0011\t\tU#1L\u0007\u0003\u0005/RAA!\u0017\u0003F\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tu#q\u000b\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006IQ\r_3dkR|'\u000fI\u0001\u0010i&,'/\u001a3M_\u001e\u001cuN\u001c4jO\u0006\u0019B/[3sK\u0012dunZ\"p]\u001aLwm\u0018\u0013fcR!\u0011Q\u0004B4\u0011%\t)cQA\u0001\u0002\u0004\ti*\u0001\tuS\u0016\u0014X\r\u001a'pO\u000e{gNZ5hA\u0005)1/\u001a;vaR\u0011\u0011Q\u0004\u0015\u0004\u000b\nE\u0004\u0003\u0002B:\u0005\u0003k!A!\u001e\u000b\t\t]$\u0011P\u0001\u0004CBL'\u0002\u0002B>\u0005{\nqA[;qSR,'OC\u0002\u0003\u0000Q\fQA[;oSRLAAa!\u0003v\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002'5\f7.\u001a+jKJ,G\rU1si&$\u0018n\u001c8\u0015\u0011\u0005](\u0011\u0012BM\u0005SC\u0011Ba#G!\u0003\u0005\rA!$\u00025%tG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\t\t=%QS\u0007\u0003\u0005#S1\u0001\u001dBJ\u0015\r\tI,]\u0005\u0005\u0005/\u0013\tJA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0011%\u0011YJ\u0012I\u0001\u0002\u0004\u0011i*\u0001\u0005{W\u000ec\u0017.\u001a8u!\u0011\u0011yJ!*\u000e\u0005\t\u0005&b\u0001BR#\u0006\u0011!p[\u0005\u0005\u0005O\u0013\tKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\n\u0005W3\u0005\u0013!a\u0001\u0005[\u000b\u0011b]2iK\u0012,H.\u001a:\u0011\u0007q\u0014y+C\u0002\u00032v\u0014abS1gW\u0006\u001c6\r[3ek2,'/A\u000fnC.,G+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119L\u000b\u0003\u0003\u000e\ne6F\u0001B^!\u0011\u0011iLa2\u000e\u0005\t}&\u0002\u0002Ba\u0005\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015',\u0001\u0006b]:|G/\u0019;j_:LAA!3\u0003@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;5\f7.\u001a+jKJ,G\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"Aa4+\t\tu%\u0011X\u0001\u001e[\u0006\\W\rV5fe\u0016$\u0007+\u0019:uSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u001b\u0016\u0005\u0005[\u0013I,\u0006\u0002\u0003\u000e\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!!Q\u001cBr!\u0011\u0011\u0019Ea8\n\t\t\u0005(Q\t\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002Bs\u0017\u0002\u0007!q]\u0001\n_Z,'O]5eKN\u0004\u0002B!;\u0003r\n](q\u001f\b\u0005\u0005W\u0014i\u000fE\u0002\u0002liK1Aa<[\u0003\u0019\u0001&/\u001a3fM&!!1\u001fB{\u0005\ri\u0015\r\u001d\u0006\u0004\u0005_T\u0006\u0003\u0002Bu\u0005sLAAa?\u0003v\n11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u0019\u000e\u0005\u0001\u0003\u0002B:\u0007\u0007IAa!\u0002\u0003v\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$b!a>\u0004\f\r=\u0001BBB\u0007\u001b\u0002\u0007!-A\u0006mK\u0006$WM]#q_\u000eD\u0007bBB\t\u001b\u0002\u000711C\u0001\tSNdU-\u00193feB\u0019\u0011l!\u0006\n\u0007\r]!LA\u0004C_>dW-\u00198")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private File logDir3;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;
    private final TopicPartition tieredTopicPartition = new TopicPartition("tiered-test-topic", 0);
    private final TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("tiered-test-topic", UUID.randomUUID(), 0);
    private LogManager tierEnabledLogManager;
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final UUID clusterLinkId = UUID.randomUUID();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private LogConfig tieredLogConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public File logDir3() {
        return this.logDir3;
    }

    public void logDir3_$eq(File x$1) {
        this.logDir3 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition tieredTopicPartition() {
        return this.tieredTopicPartition;
    }

    public TopicIdPartition tieredTopicIdPartition() {
        return this.tieredTopicIdPartition;
    }

    public LogManager tierEnabledLogManager() {
        return this.tierEnabledLogManager;
    }

    public void tierEnabledLogManager_$eq(LogManager x$1) {
        this.tierEnabledLogManager = x$1;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public UUID clusterLinkId() {
        return this.clusterLinkId;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public LogConfig tieredLogConfig() {
        return this.tieredLogConfig;
    }

    public void tieredLogConfig_$eq(LogConfig x$1) {
        this.tieredLogConfig = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$12 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$13 = this.logConfig();
        MockConfigRepository x$14 = this.configRepository();
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        boolean x$11 = CleanerConfig$.MODULE$.apply$default$11();
        CleanerConfig x$15 = new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10, x$11);
        MockTime x$16 = this.time();
        MetadataVersion x$17 = this.interBrokerProtocolVersion();
        SegmentDeletionThrottlerConfig x$18 = TestUtils$.MODULE$.createLogManager$default$6();
        int x$19 = TestUtils$.MODULE$.createLogManager$default$8();
        TierLogComponents x$20 = TestUtils$.MODULE$.createLogManager$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$13, x$14, x$15, x$16, x$18, x$17, x$19, x$20));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterPartitionManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.alterPartitionListener_$eq(TestUtils$.MODULE$.createIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, (AlterPartitionManager)this.alterPartitionManager(), (Option)None$.MODULE$, Partition$.MODULE$.$lessinit$greater$default$15(), Partition$.MODULE$.$lessinit$greater$default$16()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Properties tieredLogProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TierEnableProp()), (Object)"true")}))));
        this.tieredLogConfig_$eq(new LogConfig((Map)tieredLogProps, LogConfig$.MODULE$.apply$default$2()));
        this.logDir3_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$32 = new .colon.colon((Object)this.logDir3(), (List)Nil$.MODULE$);
        LogConfig x$33 = this.tieredLogConfig();
        MockConfigRepository x$34 = this.configRepository();
        boolean x$21 = false;
        int x$22 = CleanerConfig$.MODULE$.apply$default$1();
        long x$23 = CleanerConfig$.MODULE$.apply$default$2();
        double x$24 = CleanerConfig$.MODULE$.apply$default$3();
        int x$25 = CleanerConfig$.MODULE$.apply$default$4();
        int x$26 = CleanerConfig$.MODULE$.apply$default$5();
        double x$27 = CleanerConfig$.MODULE$.apply$default$6();
        long x$28 = CleanerConfig$.MODULE$.apply$default$7();
        int x$29 = CleanerConfig$.MODULE$.apply$default$9();
        String x$30 = CleanerConfig$.MODULE$.apply$default$10();
        boolean x$31 = CleanerConfig$.MODULE$.apply$default$11();
        CleanerConfig x$35 = new CleanerConfig(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$21, x$29, x$30, x$31);
        MockTime x$36 = this.time();
        TierLogComponents x$37 = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, new TierPartitionStateFactory(true, false, true, TierPartitionStateCleanupConfig.EMPTY), (Option)None$.MODULE$);
        SegmentDeletionThrottlerConfig x$38 = TestUtils$.MODULE$.createLogManager$default$6();
        MetadataVersion x$39 = TestUtils$.MODULE$.createLogManager$default$7();
        int x$40 = TestUtils$.MODULE$.createLogManager$default$8();
        this.tierEnabledLogManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$32, x$33, x$34, x$35, x$36, x$38, x$39, x$40, x$37));
        this.tierEnabledLogManager().startup((Set)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.tieredTopicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public Partition makeTieredPartition(MetadataVersion interBrokerProtocolVersion, KafkaZkClient zkClient, KafkaScheduler scheduler) {
        TestUtils.MockAlterPartitionManager partitionManager;
        if (interBrokerProtocolVersion.isAtLeast(MetadataVersion.IBP_2_7_IV0)) {
            partitionManager = this.alterPartitionManager();
        } else {
            Predef$.MODULE$.assert(zkClient != null && scheduler != null);
            partitionManager = AlterPartitionManager$.MODULE$.apply((Scheduler)scheduler, (Time)this.time(), zkClient);
        }
        return new Partition(this.tieredTopicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), interBrokerProtocolVersion, this.brokerId(), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.tierEnabledLogManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)new Some((Object)this.executor()), (AlterPartitionManager)partitionManager, (Option)None$.MODULE$, Partition$.MODULE$.$lessinit$greater$default$15(), Partition$.MODULE$.$lessinit$greater$default$16());
    }

    public MetadataVersion makeTieredPartition$default$1() {
        return MetadataVersion.latest();
    }

    public KafkaZkClient makeTieredPartition$default$2() {
        return null;
    }

    public KafkaScheduler makeTieredPartition$default$3() {
        return null;
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }
}

