/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.cluster.RequiredReplicaCountsAndEligibleBrokers;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004e\u0001\u0001\u0006Ia\u0017\u0005\bK\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013Q\u0006B\u00025\u0001A\u0003%1\fC\u0004j\u0001\t\u0007I\u0011\u0002.\t\r)\u0004\u0001\u0015!\u0003\\\u0011\u001dY\u0007A1A\u0005\niCa\u0001\u001c\u0001!\u0002\u0013Y\u0006bB7\u0001\u0005\u0004%IA\u001c\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003p\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\r\u0001\t\u0003\ty\u0001C\u0004\u00026\u0001!\t!a\u0004\t\u000f\u0005e\u0002\u0001\"\u0001\u0002\u0010!9\u0011Q\b\u0001\u0005\u0002\u0005=\u0001bBA!\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u000b\u0002A\u0011AA\b\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u001fAq!!\u0014\u0001\t\u0003\ty\u0001C\u0004\u0002R\u0001!\t!a\u0004\t\u000f\u0005U\u0003\u0001\"\u0001\u0002\u0010!9\u0011\u0011\f\u0001\u0005\u0002\u0005=\u0001bBA/\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003C\u0002A\u0011AA\b\u0011\u001d\t)\u0007\u0001C\u0001\u0003\u001fAq!!\u001b\u0001\t\u0003\ty\u0001C\u0004\u0002n\u0001!\t!a\u0004\t\u000f\u0005E\u0004\u0001\"\u0001\u0002\u0010!9\u0011Q\u000f\u0001\u0005\u0002\u0005=\u0001bBA=\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003{\u0002A\u0011AA\b\u0011\u001d\t\t\t\u0001C\u0001\u0003\u001fA\u0001\"!\"\u0001A\u0013%\u0011q\u0011\u0005\b\u0003c\u0003A\u0011AA\b\u0011\u001d\t)\f\u0001C\u0001\u0003\u001fAq!!/\u0001\t\u0003\ty\u0001C\u0004\u0002>\u0002!\t!a\u0004\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002\u0010!9\u0011Q\u0019\u0001\u0005\u0002\u0005=\u0001bBAe\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u001b\u0004A\u0011AA\b\u0011\u001d\t\t\u000e\u0001C\u0001\u0003\u001fAq!!6\u0001\t\u0003\ty\u0001C\u0004\u0002Z\u0002!\t!a\u0004\t\u000f\u0005u\u0007\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u001d\u0001\u0005\u0002\u0005=\u0001bBAs\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003S\u0004A\u0011AA\b\u0011\u001d\ti\u000f\u0001C\u0001\u0003\u001fAq!!=\u0001\t\u0003\ty\u0001C\u0004\u0002v\u0002!\t!a\u0004\t\u000f\u0005e\b\u0001\"\u0001\u0002\u0010!9\u0011Q \u0001\u0005\u0002\u0005=\u0001b\u0002B\u0001\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0005\u000b\u0001A\u0011AA\b\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003\u001fAqA!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0003\u0012\u0001!\t!a\u0004\t\u000f\tU\u0001\u0001\"\u0001\u0002\u0010!9!\u0011\u0004\u0001\u0005\u0002\u0005=\u0001b\u0002B\u000f\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0005C\u0001A\u0011AA\b\u0011\u001d\u0011)\u0003\u0001C\u0001\u0003\u001fAqA!\u000b\u0001\t\u0003\ty\u0001C\u0004\u0003.\u0001!\t!a\u0004\t\u000f\tE\u0002\u0001\"\u0001\u0002\u0010!9!Q\u0007\u0001\u0005\u0002\u0005=\u0001b\u0002B\u001d\u0001\u0011\u0005\u0011q\u0002\u0002\r\u001f\n\u001cXM\u001d<feR+7\u000f\u001e\u0006\u0003\u0015.\u000bqa\u00197vgR,'OC\u0001M\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u000b\u0005\u0002Y\u00015\t\u0011*\u0001\u0013u_BL7mV5uQ>\u00137/\u001a:wKJ\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u+\u0005Y\u0006c\u0001)]=&\u0011Q,\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\\\u0015AB2p[6|g.\u0003\u0002dA\nqAk\u001c9jGBc\u0017mY3nK:$\u0018!\n;pa&\u001cw+\u001b;i\u001f\n\u001cXM\u001d<feBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;!\u0003m\"x\u000e]5d/&$\bn\u00142tKJ4XM\u001d)mC\u000e,W.\u001a8u\u001f:\u001c\u0016-\\3SC\u000e\\\u0017i]*z]\u000e\u0014V\r\u001d7jG\u0006\u001cuN\\:ue\u0006Lg\u000e^\u0001=i>\u0004\u0018nY,ji\"|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^(o'\u0006lWMU1dW\u0006\u001b8+\u001f8d%\u0016\u0004H.[2b\u0007>t7\u000f\u001e:bS:$\b%A\u0014u_BL7mV5uQR;xn\u00142tKJ4XM\u001d)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\u0018\u0001\u000b;pa&\u001cw+\u001b;i)^|wJY:feZ,'\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004\u0013\u0001\u000e;pa&\u001cw+\u001b;i)^|wJY:feZ,'/\u00118e%\u0006\u001c7.T5yS:<\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi\u0006)Do\u001c9jG^KG\u000f\u001b+x_>\u00137/\u001a:wKJ\fe\u000e\u001a*bG.l\u0015\u000e_5oOBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;!\u0003}!x\u000e]5d/&$\bn\\;u\u001f\n\u001cXM\u001d<feN\u001cuN\\:ue\u0006Lg\u000e^\u0001!i>\u0004\u0018nY,ji\"|W\u000f^(cg\u0016\u0014h/\u001a:t\u0007>t7\u000f\u001e:bS:$\b%\u0001\u000bbY2\u0014%o\\6feN\fE\u000f\u001e:jEV$Xm]\u000b\u0002_B!\u0001/^<{\u001b\u0005\t(B\u0001:t\u0003%IW.\\;uC\ndWM\u0003\u0002u#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\f(aA'baB\u0011\u0001\u000b_\u0005\u0003sF\u00131!\u00138u!\u0011YH0`?\u000e\u0003ML!A^:\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\rM#(/\u001b8h\u0003U\tG\u000e\u001c\"s_.,'o]!uiJL'-\u001e;fg\u0002\nq\u0005^3tiBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;Qe\u0016$\u0017nY1uKN+8mY3tgR\u0011\u0011\u0011\u0003\t\u0004!\u0006M\u0011bAA\u000b#\n!QK\\5uQ\rq\u0011\u0011\u0004\t\u0005\u00037\ti#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\r\t\u0007/\u001b\u0006\u0005\u0003G\t)#A\u0004kkBLG/\u001a:\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003W\t1a\u001c:h\u0013\u0011\ty#!\b\u0003\tQ+7\u000f^\u00014i\u0016\u001cH\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R<\u0016\u000e\u001e5SC\u000e\\G+\u001f9f!J,G-[2bi\u0016\u001cVoY2fgND3aDA\r\u0003\u001d\"Xm\u001d;QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG\u000f\u0015:fI&\u001c\u0017\r^3GC&dWO]3)\u0007A\tI\"A\u001auKN$\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi^KG\u000f\u001b*bG.$\u0016\u0010]3Qe\u0016$\u0017nY1uK\u001a\u000b\u0017\u000e\\;sK\"\u001a\u0011#!\u0007\u0002[Q,7\u000f\u001e)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\bK]3eS\u000e\fG/\u001a(p\u0007>t7\u000f\u001e:bS:$8\u000fK\u0002\u0013\u00033\t\u0011\b^3tiBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;Qe\u0016$\u0017nY1uK^KG\u000f\u001b*bG.$\u0016\u0010]3O_\u000e{gn\u001d;sC&tGo\u001d\u0015\u0004'\u0005e\u0011\u0001\f;fgR\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u!J,G-[2bi\u0016tuN\u0011:pW\u0016\u0014(+Y2lQ\r!\u0012\u0011D\u00019i\u0016\u001cH\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004&/\u001a3jG\u0006$XmV5uQJ\u000b7m\u001b+za\u0016tuN\u0011:pW\u0016\u0014(+Y2lQ\r)\u0012\u0011D\u0001\u0016i\u0016\u001cH/T3sO\u0016$\u0015n\u001d6pS:$X*\u00199tQ\r1\u0012\u0011D\u0001\u0012i\u0016\u001cH/T3sO\u0016,U\u000e\u001d;z\u001b\u0006\u0004\bfA\f\u0002\u001a\u0005)B/Z:u\u001b\u0016\u0014x-Z'baZ\u000bG.^3TC6,\u0007f\u0001\r\u0002\u001a\u0005\u0019B/Z:u\u001b\u0016\u0014x-Z'ba.+\u0017pU1nK\"\u001a\u0011$!\u0007\u00025Q,7\u000f^'fe\u001e,G)[:k_&tGoU3rk\u0016t7-Z:)\u0007i\tI\"A\fuKN$X*\u001a:hK\u0016k\u0007\u000f^=TKF,XM\\2fg\"\u001a1$!\u0007\u000235,'oZ3O_:$\u0015n\u001d6pS:$8+Z9vK:\u001cWm\u001d\u0015\u00049\u0005e\u0011\u0001\t;fgR\u0004\u0016M\u001d;ji&|gN\u0011:pW\u0016\u00148OQ=D_:\u001cHO]1j]RD3!HA\r\u0003U\"Xm\u001d;QCJ$\u0018\u000e^5p]\n\u0013xn[3sg\nK8i\u001c8tiJ\f\u0017N\u001c;XSRD'+Y2l\u001b&D\u0018N\\4TkB\u0004xN\u001d;)\u0007y\tI\"\u0001*uKN$\b+\u0019:uSRLwN\u001c\"s_.,'o],ji\"|e/\u001a:mCB\u0004X\r\u001a*bG.\u001cuN\\:ue\u0006Lg\u000e^:Cs\u000e{gn\u001d;sC&tGoV5uQJ\u000b7m['jq&twmU;qa>\u0014H\u000fK\u0002 \u00033\tA\u0006^3tiB\u000b'\u000f^5uS>t'I]8lKJ\u001c()_\"p]N$(/Y5oi&sg/\u00197jI\u000e{WO\u001c;)\u0007\u0001\nI\"A#uKN$()^5mIJ+\u0017/^5sK\u0012\u0014V\r\u001d7jG\u0006\u001cu.\u001e8ug\u0006sG-\u00127jO&\u0014G.\u001a\"s_.,'o],ji\"\u0014\u0016mY6NSbLgnZ*vaB|'\u000f\u001e\u0015\u0004C\u0005e\u0011\u0001\f;fgR\u0014\u0016mY6V]\u0006<\u0018M]3O_\u000e{gn\u001d;sC&tGOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\r\u0011\u0013\u0011D\u0001?i\u0016\u001cHOU1dWVs\u0017m^1sKJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tGoV5uQBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;NSN\u001c\u0018N\\4)\u0007\r\nI\"\u0001\u0013wC2LG-\u0019;f%\u0006\u001c7.\u00168bo\u0006\u0014XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0019\t\t\"!#\u0002 \"9\u00111\u0012\u0013A\u0002\u00055\u0015a\u00022s_.,'o\u001d\t\u0006a\u0006=\u00151S\u0005\u0004\u0003#\u000b(AC%oI\u0016DX\rZ*fcB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a.\u000bQ!\u00193nS:LA!!(\u0002\u0018\nq!I]8lKJlU\r^1eCR\f\u0007bBAQI\u0001\u0007\u00111U\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000fE\u0003|y^\f)\u000b\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYkS\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BAX\u0003S\u0013\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0003)\"Xm\u001d;SC\u000e\\\u0017i^1sK:{7i\u001c8tiJ\f\u0017N\u001c;SKBd\u0017nY1BgNLwM\\7f]RD3!JA\r\u00039\"Xm\u001d;HKR\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e%b]\u0012dWm]'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0007\u0019\nI\"\u0001\u001euKN$(+Y2l\u0003^\f'/Z,ji\"\u001cuN\\:ue\u0006Lg\u000e\u001e*fa2L7-Y!tg&<g.\\3oi^KG\u000f\u001b*bG.l\u0015\u000e_5oO\"\u001aq%!\u0007\u0002YQ,7\u000f\u001e*bG.\fu/\u0019:f/&$\bnQ8ogR\u0014\u0018-\u001b8u%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u0015\u0002\u001a\u0005QD/Z:u%\u0006\u001c7.Q<be\u0016<\u0016\u000e\u001e5D_:\u001cHO]1j]R\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^,ji\"\u001cF/\u0019:u\u0013:$W\r\u001f\u0015\u0004S\u0005e\u0011a\u0007<bY&$\u0017\r^3QCJ$\u0018\u000e^5p]&twmU;dG\u0016\u001c8\u000fK\u0002+\u00033\t1D^1mS\u0012\fG/\u001a)beRLG/[8oS:<g)Y5mkJ,\u0007fA\u0016\u0002\u001a\u0005\u0011e/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8j]\u001e4\u0015-\u001b7ve\u0016lU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:XSRD'+Y2l\u001b&D\u0018N\\4TkB\u0004xN\u001d;)\u00071\nI\"A\u0015uKN$h+\u00197jI\u0006$XMU3qY&\u001c\u0017m\u001d(p!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e\u0015\u0004[\u0005e\u0011a\b;fgR4\u0016\r\\5eCR,wJY:feZ,'o]\"p]N$(/Y5oi\"\u001aa&!\u0007\u0002\u000bR,7\u000f\u001e,bY&$\u0017\r^3PEN,'O^3sg\u000e{gn\u001d;sC&tGoV5uQNKhn\u0019*fa2L7-Y:B]\u0012|%m]3sm\u0016\u00148o\u00148TC6,'+Y2lQ\ry\u0013\u0011D\u0001&i\u0016\u001cHOV1mS\u0012\fG/\u001a*fa2L7-Y:NCR\u001c\u0007.Z:D_:\u001cHO]1j]RD3\u0001MA\r\u0003\u001d\"Xm\u001d;WC2LG-\u0019;f%\u0016\u0004H.[2bg>3XM]\"p]N$(/Y5oi\u000e{WO\u001c;)\u0007E\nI\"\u0001\u0015uKN$h+\u00197jI\u0006$XMU3qY&\u001c\u0017m]+oI\u0016\u00148i\u001c8tiJ\f\u0017N\u001c;D_VtG\u000fK\u00023\u00033\t\u0001\u0007^3tiJ+\u0007\u000f\\5dC&sG-\u001b<jIV\fGnQ8ogR\u0014\u0018-\u001b8u\u0007>,h\u000e\u001e(piN\u000bG/[:gS\u0016$\u0007fA\u001a\u0002\u001a\u0005iB/Z:u\u001f\n\u001cXM\u001d<fe6\u000bGo\u00195fg\u000e{gn\u001d;sC&tG\u000fK\u00025\u00033\t1\t^3ti>\u00137/\u001a:wKJl\u0015\r^2iKN\u001cuN\\:ue\u0006Lg\u000e^,ji\"\u001c\u0016P\\2SKBd\u0017nY1t\u0003:$wJY:feZ,'o](o'\u0006lWMU1dW\"\u001aQ'!\u0007\u0002-R,7\u000f\u001e*fa2L7-Y%oI&4\u0018\u000eZ;bY\u000e{gn\u001d;sC&tGoQ8v]Rtu\u000e^*bi&\u001ch-[3e/&$\bnU=oGJ+\u0007\u000f\\5dCN\fe\u000eZ(cg\u0016\u0014h/\u001a:t\u001f:\u001c\u0016-\\3SC\u000e\\\u0007f\u0001\u001c\u0002\u001a\u0005AB/Z:u\u0013:4\u0018\r\\5e\u001f\n\u001cXM\u001d<fe\u000e{WO\u001c;)\u0007]\nI\"\u0001 uKN$\u0018J\u001c<bY&$wJY:feZ,'oQ8v]R<\u0016\u000e\u001e5Ts:\u001c'+\u001a9mS\u000e\f7/\u00118e\u001f\n\u001cXM\u001d<feN|enU1nKJ\u000b7m\u001b\u0015\u0004q\u0005e\u0011\u0001\b;fgRLeN^1mS\u0012|%m]3sm\u0016\u0014\u0018\t\u001e;sS\n,H/\u001a\u0015\u0004s\u0005e\u0011a\b;fgR\u0014V\r\u001d7jG\u0006\u001c\b*Y:PEN,'O^3s\u0003N\u001cVO\u001a4jq\"\u001a!(!\u0007\u0002+Q,7\u000f\u001e(p\tV\u0004H.[2b%\u0016\u0004H.[2bg\"\u001a1(!\u0007\u00021Q,7\u000f\u001e(p\u001d\u0016<\u0017\r^5wKJ+\u0007\u000f\\5dC&#7\u000fK\u0002=\u00033\ta\u0005^3tiZ\u000bG.\u001b3SK\u0006\u001c8/[4o[\u0016tGOT8PM\u001ad\u0017N\\3PEN,'O^3sQ\ri\u0014\u0011D\u0001Mi\u0016\u001cHOV1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u001d>|eM\u001a7j]\u0016|%m]3sm\u0016\u0014x+\u001b;i'ft7MU3qY&\u001c\u0017m]!oI>\u00137/\u001a:wKJ\u001cxJ\\*b[\u0016\u0014\u0016mY6)\u0007y\nI\"A2uKN$h+\u00197jIJ+\u0017m]:jO:lWM\u001c;SKR,(O\\:FeJ|'o\u00165f]\u000e{gn\u001d;sC&tGOT8u\u001b\u0016$xJY:feZ,'oV5uQNKhn\u0019*fa2L7-Y:B]\u0012|%m]3sm\u0016\u00148o\u00148TC6,'+Y2lQ\ry\u0014\u0011D\u0001(i\u0016\u001cHOV1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u00032dwJ\u001a4mS:,wJY:feZ,'\u000fK\u0002A\u00033\tq\u0005^3tiZ\u000bG.\u001b3SK\u0006\u001c8/[4o[\u0016tGo\u00148f\u001f\u001a4G.\u001b8f\u001f\n\u001cXM\u001d<fe\"\u001a\u0011)!\u0007\u0002SQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fCN\u001c\u0018n\u001a8nK:$h*Z<PM\u001ad\u0017N\\3PEN,'O^3sQ\r\u0011\u0015\u0011D\u0001#i\u0016\u001cH/\u00138wC2LGMU3bgNLwM\\7f]R|eM\u001a7j]\u0016\u001c\u0016P\\2)\u0007\r\u000bI\"A\u001buKN$h+\u00197jI\u0006$X\rV8qS\u000e\u0004F.Y2f[\u0016tG/\u00169eCR,w+\u001b;i%\u0006\u001c7.T5yS:<7+^2dKN\u001c\bf\u0001#\u0002\u001a\u0005)D/Z:u-\u0006d\u0017\u000eZ1uKR{\u0007/[2QY\u0006\u001cW-\\3oiV\u0003H-\u0019;f/&$\bNU1dW6K\u00070\u001b8h\r\u0006LG.\u001e:fQ\r)\u0015\u0011D\u00019i\u0016\u001cHOV1mS\u0012\fG/\u001a+pa&\u001c\u0007\u000b\\1dK6,g\u000e^+qI\u0006$XmV5uQ>,HOU1dW6K\u00070\u001b8h'V\u001c7-Z:tQ\r1\u0015\u0011D\u00019i\u0016\u001cHOV1mS\u0012\fG/\u001a+pa&\u001c\u0007\u000b\\1dK6,g\u000e^+qI\u0006$XmV5uQ>,HOU1dW6K\u00070\u001b8h\r\u0006LG.\u001e:fQ\r9\u0015\u0011\u0004")
public class ObserverTest {
    private final Option<TopicPlacement> topicWithObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint;
    private final Option<TopicPlacement> topicWithTwoObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithTwoObserverAndRackMixingPlacementConstraint;
    private final Option<TopicPlacement> topicWithoutObserversConstraint;
    private final scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes;

    private Option<TopicPlacement> topicWithObserverPlacementConstraint() {
        return this.topicWithObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint() {
        return this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint;
    }

    private Option<TopicPlacement> topicWithTwoObserverPlacementConstraint() {
        return this.topicWithTwoObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithTwoObserverAndRackMixingPlacementConstraint() {
        return this.topicWithTwoObserverAndRackMixingPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithoutObserversConstraint() {
        return this.topicWithoutObserversConstraint;
    }

    private scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes() {
        return this.allBrokersAttributes;
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"));
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateSuccess$1(replicaBroker, observerBroker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintWithRackTypePredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"));
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintWithRackTypePredicateSuccess$1(replicaBroker, observerBroker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateFailure$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintWithRackTypePredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintWithRackTypePredicateFailure$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    @Test
    public void testPlacementConstraintPredicateWithRackTypeNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$);
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateNoBrokerRack$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateWithRackTypeNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$);
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateWithRackTypeNoBrokerRack$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMergeDisjointMaps() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        scala.collection.mutable.Map mergedMap = Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap);
        Assertions.assertEquals((Object)firstMap.$plus$plus((GenTraversableOnce)secondMap), (Object)mergedMap);
    }

    @Test
    public void testMergeEmptyMap() {
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(assignmentMap, (Map)Map$.MODULE$.empty()));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)assignmentMap));
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty()));
    }

    @Test
    public void testMergeMapValueSame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeMapKeySame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}));
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}))), (Object)Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20);
        Assertions.assertEquals((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testMergeEmptySequences() {
        Range.Inclusive testSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)testSeq, (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Nil$.MODULE$, (Seq)testSeq));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$));
    }

    @Test
    public void mergeNonDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 15);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testPartitionBrokersByConstraint() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$1 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)x$2 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$2(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(21), 30).map((Function1 & Serializable & scala.Serializable)x$3 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$3(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
        Seq replicasTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, seq);
        Seq replicas = (Seq)replicasTuple.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Seq replica = (Seq)x0$1._2();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom()), (Object)replicas);
        Seq replicaCount = (Seq)replicasTuple.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$6(x0$2)), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicaCount);
        seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala();
        Seq observersTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, seq);
        Seq observers = (Seq)observersTuple.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            void var1_1;
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            Seq observer = (Seq)x0$3._2();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)west1Brokers, (Object)observers);
        Seq observersCount = (Seq)observersTuple.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$8(x0$4)), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)observersCount);
    }

    @Test
    public void testPartitionBrokersByConstraintWithRackMixingSupport() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$4 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)x$5 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(21), 30).map((Function1 & Serializable & scala.Serializable)x$6 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$3(BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq requiredReplicaCountsAndEligibleBrokers = Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers);
        Assertions.assertEquals((int)3, (int)requiredReplicaCountsAndEligibleBrokers.size());
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(3, 0, (Seq)east1Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(0));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(2, 0, (Seq)east2Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(1));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(0, 3, (Seq)west1Brokers, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (Object)requiredReplicaCountsAndEligibleBrokers.apply(2));
    }

    @Test
    public void testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$7 -> ObserverTest.$anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)x$8 -> ObserverTest.$anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq requiredReplicaCountsAndEligibleBrokers = Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers);
        Assertions.assertEquals((int)2, (int)requiredReplicaCountsAndEligibleBrokers.size());
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(3, 3, (Seq)east1Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (Object)requiredReplicaCountsAndEligibleBrokers.apply(0));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(2, 0, (Seq)east2Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(1));
    }

    @Test
    public void testPartitionBrokersByConstraintInvalidCount() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$9 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$1(BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 13).map((Function1 & Serializable & scala.Serializable)x$10 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$2(BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(14), 20).map((Function1 & Serializable & scala.Serializable)x$11 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$3(BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Function1 & Serializable & scala.Serializable partitionFunction = (Function1 & Serializable & scala.Serializable)constraints -> Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, constraints);
        Seq seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala();
        Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, constraints);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> partitionFunction.apply(CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala()));
    }

    @Test
    public void testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-3\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$12 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$12)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 13).map((Function1 & Serializable & scala.Serializable)x$13 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$13)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(14), 20).map((Function1 & Serializable & scala.Serializable)x$14 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$3(BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        InvalidConfigurationException exception = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers));
        Assertions.assertEquals((Object)"Failed to satisfy the topic placement: for constraint Map(rack -> east-3) there are 0 matching brokers but the topic placement requires 1 sync replicas and 0 observers, for constraint Map(rack -> east-2) there are 3 matching brokers but the topic placement requires 5 sync replicas and 0 observers", (Object)exception.getMessage());
    }

    @Test
    public void testRackUnawareNoConstraintReplicaAssignment() {
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackUnawareNoConstraintReplicaAssignment$1(this, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testRackUnawareReplicaAssignmentWithPlacementConstraintMissing() {
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(this, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    private void validateRackUnawareReplicaAssignment(IndexedSeq<BrokerMetadata> brokers2, Map<Object, ReplicaAssignment> assignments) {
        ((Iterable)((GenericTraversableTemplate)assignments.values().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$2(assignedPartitions);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)assignments.values().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)brokers -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$6(brokers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareNoConstraintReplicaAssignment() {
        int numPartitions = 9;
        short replicationFactor = 3;
        IndexedSeq racks = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).flatMap((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq brokers = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).zip((GenIterable)racks, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int id = x0$1._1$mcI$sp();
            String rack = (String)x0$1._2();
            BrokerMetadata brokerMetadata = new BrokerMetadata(id, (Option)new Some((Object)rack));
            return brokerMetadata;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$4(brokers, numPartitions, replicationFactor, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testGetReplicaAssignmentHandlesMetadataVersion() {
        String placementJsonWithSyncReplicasAndObserversOnSameRack = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        String placementJsonWithoutSyncReplicasAndObserversOnSameRack = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack3\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testGetReplicaAssignmentHandlesMetadataVersion$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> ObserverTest.$anonfun$testGetReplicaAssignmentHandlesMetadataVersion$2(brokers, placementJsonWithSyncReplicasAndObserversOnSameRack, placementJsonWithoutSyncReplicasAndObserversOnSameRack, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport)));
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithRackMixing() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 24).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack2\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |         \"rack\": \"rack3\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack4\"\n                           |       }\n                           |     },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack5\"\n                           |       }\n                           |    }\n                           |  ],\n                           |  \"observers\": [\n                           |  {\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack1\"\n                           |    }\n                           |   },\n                           |   {\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack2\"\n                           |    }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack3\"\n                           |     }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack4\"\n                           |     }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack5\"\n                           |     }\n                           |   }\n                           |  ]\n                           |}")).stripMargin();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, false, Observer$.MODULE$.getReplicaAssignment$default$6(), Observer$.MODULE$.getReplicaAssignment$default$7()));
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, true, 0, 0);
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$4(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.observers(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$16(observers);
            return BoxedUnit.UNIT;
        });
        ((Iterable)((GenericTraversableTemplate)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$23(assignedPartitions);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignment() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack3\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$2(brokers, placementJson, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithStartIndex() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 4,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 3,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}")).stripMargin();
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(brokers, placementJson, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void validatePartitioningSuccess() {
        IndexedSeq partitionedBrokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable & scala.Serializable)partitionNumber -> ObserverTest.$anonfun$validatePartitioningSuccess$1(BoxesRunTime.unboxToInt((Object)partitionNumber)), IndexedSeq$.MODULE$.canBuildFrom());
        Observer$.MODULE$.validatePartitioning((Seq)partitionedBrokers);
    }

    @Test
    public void validatePartitioningFailure() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        .colon.colon partitionedBrokers = new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailure$1((Seq)partitionedBrokers));
    }

    @Test
    public void validatePartitioningFailureMultiplePartitionsWithRackMixingSupport() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        .colon.colon brokers = new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(5, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$)));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailureMultiplePartitionsWithRackMixingSupport$1((Seq)brokers));
    }

    @Test
    public void testValidateReplicasNoPlacementConstraint() {
        Observer$.MODULE$.validateAssignment((Option)None$.MODULE$, new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
    }

    @Test
    public void testValidateObserversConstraint() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.error()));
    }

    @Test
    public void testValidateObserversConstraintWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.error()));
    }

    @Test
    public void testValidateReplicasMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
    }

    @Test
    public void testValidateReplicasOverConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.error()));
    }

    @Test
    public void testValidateReplicasUnderConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.error()));
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfied() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 5, 6, 7})), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.error()));
    }

    @Test
    public void testObserverMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6)), this.allBrokersAttributes());
    }

    @Test
    public void testObserverMatchesConstraintWithSyncReplicasAndObserversOnSameRack() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), this.allBrokersAttributes());
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfiedWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.error()));
    }

    @Test
    public void testInvalidObserverCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7)), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.error()));
    }

    @Test
    public void testInvalidObserverCountWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.error()));
    }

    @Test
    public void testInvalidObserverAttribute() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 9}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.error()));
    }

    @Test
    public void testReplicasHasObserverAsSuffix() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.error()));
    }

    @Test
    public void testNoDuplicaReplicas() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 1})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$41 -> x$41.error()));
    }

    @Test
    public void testNoNegativeReplicaIds() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, -2})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.error()));
    }

    @Test
    public void testValidReassignmentNoOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$43 -> x$43.error()));
    }

    @Test
    public void testValidReassignmentNoOfflineObserverWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverAndRackMixingPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))).reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$44 -> x$44.error()));
    }

    @Test
    public void testValidReassignmentReturnsErrorWhenConstraintNotMetObserverWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverAndRackMixingPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))).reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 4, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.error()));
    }

    @Test
    public void testValidReassignmentAllOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus$minus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$46 -> x$46.error()));
    }

    @Test
    public void testValidReassignmentOneOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$47 -> x$47.error()));
    }

    @Test
    public void testInvalidReassignmentNewOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$48 -> x$48.error()));
    }

    @Test
    public void testInvalidReassignmentOfflineSync() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.error()));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithRackMixingSuccess() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin(), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1$adapted((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithRackMixingFailure() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 3,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [\n        |  {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |  },\n        |  {\n        |    \"count\": 1,\n        |     \"constraints\": {\n        |       \"rack\": \"rack-1\"\n        |    }\n        |  }\n        |]\n        |}")).stripMargin(), (List)Nil$.MODULE$)))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingFailure$1((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithoutRackMixingSuccess() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-2")), (List)Nil$.MODULE$));
        new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin(), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1$adapted((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithoutRackMixingFailure() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-2")), (List)Nil$.MODULE$));
        new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")).stripMargin(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("{\n          | \"version\": 1,\n          |  \"replicas\": [{\n          |      \"count\": 3,\n          |      \"constraints\": {\n          |        \"rack\": \"rack-1\"\n          |      }\n          |    }\n          |  ]\n          |}")).stripMargin(), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingFailure$1((List)brokers, arg_0));
    }

    public static final /* synthetic */ Tuple2 $anonfun$allBrokersAttributes$1(int id) {
        switch (id) {
            default: 
        }
        String rack = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).contains(id) ? "east-1" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 4).contains(id) ? "east-2" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7).contains(id) ? "west-1" : "west-2"));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), (Object)rack)})));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateSuccess$1(BrokerMetadata replicaBroker$1, BrokerMetadata observerBroker$1, TopicPlacement topicPlacement) {
        Buffer replicaConstraints = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)replicaConstraints.head()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)((IterableLike)replicaConstraints.tail()).head()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(observerBroker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintWithRackTypePredicateSuccess$1(BrokerMetadata replicaBroker$2, BrokerMetadata observerBroker$2, TopicPlacement topicPlacement) {
        Buffer replicaConstraints = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$2, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)replicaConstraints.head()).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$2, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)((IterableLike)replicaConstraints.tail()).head()).constraints()).asScala()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(observerBroker$2, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateFailure$1(BrokerMetadata broker$1, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintWithRackTypePredicateFailure$1(BrokerMetadata broker$2, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateNoBrokerRack$1(BrokerMetadata broker$3, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$3, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$3, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateWithRackTypeNoBrokerRack$1(BrokerMetadata broker$4, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$4, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$4, (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$1(int x$1) {
        return new BrokerMetadata(x$1, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$2(int x$2) {
        return new BrokerMetadata(x$2, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$3(int x$3) {
        return new BrokerMetadata(x$3, (Option)new Some((Object)"west-1"));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$6(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int count = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$8(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        int count = x0$4._1$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$1(int x$4) {
        return new BrokerMetadata(x$4, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$2(int x$5) {
        return new BrokerMetadata(x$5, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$3(int x$6) {
        return new BrokerMetadata(x$6, (Option)new Some((Object)"west-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$1(int x$7) {
        return new BrokerMetadata(x$7, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$2(int x$8) {
        return new BrokerMetadata(x$8, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$1(int x$9) {
        return new BrokerMetadata(x$9, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$2(int x$10) {
        return new BrokerMetadata(x$10, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$3(int x$11) {
        return new BrokerMetadata(x$11, (Option)new Some((Object)"west-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$1(int x$12) {
        return new BrokerMetadata(x$12, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$2(int x$13) {
        return new BrokerMetadata(x$13, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$3(int x$14) {
        return new BrokerMetadata(x$14, (Option)new Some((Object)"west-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareNoConstraintReplicaAssignment$2(int x$15) {
        return new BrokerMetadata(x$15, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testRackUnawareNoConstraintReplicaAssignment$1(ObserverTest $this, IntRef assignmentFuncsProcessed$1, boolean rackMixingSupport) {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$15 -> ObserverTest.$anonfun$testRackUnawareNoConstraintReplicaAssignment$2(BoxesRunTime.unboxToInt((Object)x$15)), IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, rackMixingSupport, Observer$.MODULE$.getReplicaAssignment$default$6(), Observer$.MODULE$.getReplicaAssignment$default$7());
        $this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
        ++assignmentFuncsProcessed$1.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$2(int x$16) {
        return new BrokerMetadata(x$16, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(ObserverTest $this, IntRef assignmentFuncsProcessed$2, boolean rackMixingSupport) {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$16 -> ObserverTest.$anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$2(BoxesRunTime.unboxToInt((Object)x$16)), IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)"{\"version\":1, \"replicas\":[{\"count\":3}]}"))), numPartitions, replicationFactor, rackMixingSupport, Observer$.MODULE$.getReplicaAssignment$default$6(), Observer$.MODULE$.getReplicaAssignment$default$7());
        $this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
        ++assignmentFuncsProcessed$2.elem;
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$4(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$2(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable & scala.Serializable)brokerIds -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$4(brokerIds);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)10, (int)assignedPartitions.size());
        Assertions.assertEquals((int)5, (int)assignedPartitions.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$6(Seq brokers) {
        Assertions.assertEquals((int)3, (int)brokers.size());
    }

    public static final /* synthetic */ List $anonfun$testRackAwareNoConstraintReplicaAssignment$1(int id) {
        return (List)List$.MODULE$.fill(3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append("rack").append(id).toString());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$6(Seq assignedBrokers) {
        Assertions.assertEquals((int)3, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$8(Iterable assignedBrokers) {
        Assertions.assertEquals((int)9, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$4(IndexedSeq brokers$1, int numPartitions$1, short replicationFactor$1, IntRef assignmentFuncsProcessed$3, boolean rackMixingSupport) {
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$1, (Option)None$.MODULE$, numPartitions$1, (int)replicationFactor$1, rackMixingSupport, Observer$.MODULE$.getReplicaAssignment$default$6(), Observer$.MODULE$.getReplicaAssignment$default$7());
        ((IterableLike)assignments.values().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$6(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((GenericTraversableTemplate)assignments.values().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$8(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$3.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testGetReplicaAssignmentHandlesMetadataVersion$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ Map $anonfun$testGetReplicaAssignmentHandlesMetadataVersion$2(IndexedSeq brokers$2, String placementJsonWithSyncReplicasAndObserversOnSameRack$1, String placementJsonWithoutSyncReplicasAndObserversOnSameRack$1, boolean rackMixingSupport) {
        if (rackMixingSupport) {
            Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, Observer$.MODULE$.getReplicaAssignment$default$7());
            return Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, Observer$.MODULE$.getReplicaAssignment$default$7());
        }
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, Observer$.MODULE$.getReplicaAssignment$default$7()));
        return Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, Observer$.MODULE$.getReplicaAssignment$default$7());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$4(Seq assignedBrokers) {
        Assertions.assertEquals((int)20, (int)assignedBrokers.toSet().size());
        ((IterableLike)assignedBrokers.take(2)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(2, 4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(4, 6)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(6, 8)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(8, 10)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(10, 12)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(12, 14)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(14, 16)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(16, 18)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(18, 20)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
        Assertions.assertEquals((int)assignedBrokers.size(), (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$16(Seq observers) {
        ((IterableLike)observers.take(2)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)observers.slice(2, 4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableLike)observers.slice(4, 6)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableLike)observers.slice(6, 8)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableLike)observers.slice(8, 10)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$25(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$23(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable & scala.Serializable)brokerIds -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$25(brokerIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignment$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$4(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableLike)assignedBrokers.take(3)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(3, 5)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$9(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$14(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$12(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable & scala.Serializable)brokerIds -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$14(brokerIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$2(IndexedSeq brokers$4, String placementJson$2, IntRef assignmentFuncsProcessed$4, boolean rackMixingSupport) {
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$4, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson$2))), 10, 3, rackMixingSupport, Observer$.MODULE$.getReplicaAssignment$default$6(), Observer$.MODULE$.getReplicaAssignment$default$7());
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$4(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.observers(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$9(observers);
            return BoxedUnit.UNIT;
        });
        ((Iterable)((GenericTraversableTemplate)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$12(assignedPartitions);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$4.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ boolean $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$3(Seq expectedObservers$1, ReplicaAssignment x$27) {
        return x$27.observers().equals((Object)expectedObservers$1);
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$6(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableLike)assignedBrokers.take(4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$10(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(IndexedSeq brokers$5, String placementJson$3, IntRef assignmentFuncsProcessed$5, boolean rackMixingSupport) {
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$5, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson$3))), 15, 3, rackMixingSupport, 2, 3);
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 11, 13}));
        Set matchingAssignment = ((TraversableOnce)partitionAssignment.values().filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$3(expectedObservers, x$27)))).toSet();
        Assertions.assertTrue((boolean)matchingAssignment.nonEmpty(), (String)new StringBuilder(14).append(expectedObservers).append(" not found in ").append(partitionAssignment.values()).toString());
        Set matchingReplicas = (Set)matchingAssignment.map((Function1 & Serializable & scala.Serializable)x$28 -> (Seq)x$28.replicas().slice(0, 4), Set$.MODULE$.canBuildFrom());
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3, 4}));
        Assertions.assertTrue((boolean)matchingReplicas.contains((Object)expectedReplicas), (String)new StringBuilder(14).append(expectedReplicas).append(" not found in ").append(matchingAssignment).toString());
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$6(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.observers(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$10(observers);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$5.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$validatePartitioningSuccess$2(int partitionNumber$1, int brokerId) {
        return new BrokerMetadata(partitionNumber$1 * 5 + brokerId, (Option)new Some((Object)"rack"));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$validatePartitioningSuccess$1(int partitionNumber) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> ObserverTest.$anonfun$validatePartitioningSuccess$2(partitionNumber, BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailure$1(Seq partitionedBrokers$1) {
        Observer$.MODULE$.validatePartitioning(partitionedBrokers$1);
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailureMultiplePartitionsWithRackMixingSupport$1(Seq brokers$6) {
        Observer$.MODULE$.validatePartitioning(brokers$6);
    }

    public static final /* synthetic */ void $anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1(List brokers$7, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$7);
    }

    public static final /* synthetic */ InvalidConfigurationException $anonfun$testValidateTopicPlacementUpdateWithRackMixingFailure$1(List brokers$8, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$8));
    }

    public static final /* synthetic */ void $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1(List brokers$9, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$9);
    }

    public static final /* synthetic */ InvalidConfigurationException $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingFailure$1(List brokers$10, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$10));
    }

    public ObserverTest() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"observers\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("\n                          |{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson2)));
        String placementJson3 = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"observers\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"replicas\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithTwoObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson3)));
        String placementJson4 = new StringOps(Predef$.MODULE$.augmentString("\n                          |{\n                          |  \"version\": 1,\n                          |  \"observers\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"replicas\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        this.topicWithTwoObserverAndRackMixingPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson4)));
        String placementJsonWithoutObservers = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"west-1\"\n      |      }\n      |    }\n      |  ]\n      |}")).stripMargin();
        this.topicWithoutObserversConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutObservers)));
        this.allBrokersAttributes = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$allBrokersAttributes$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Object $anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1$adapted(List brokers$7, String placement) {
        ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1(brokers$7, placement);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1$adapted(List brokers$9, String placement) {
        ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1(brokers$9, placement);
        return BoxedUnit.UNIT;
    }
}

