/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogTestUtils;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.MetadataCache;
import kafka.server.PartitionFetchMetadata;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.TierFetchDataInfo;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetTieredException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u00181\u0001UBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001H\u0011\u0019i\u0005\u0001)A\u0005\u0011\"9a\n\u0001b\u0001\n\u00039\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011A)\t\rU\u0003\u0001\u0015!\u0003S\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\ta\u0016\u0005\u0007E\u0002\u0001\u000b\u0011\u0002-\t\u000f\r\u0004!\u0019!C\u0001I\"1Q\u000e\u0001Q\u0001\n\u0015DqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0001p\u0011\u0019)\b\u0001)A\u0005a\"9a\u000f\u0001b\u0001\n\u00039\bB\u0002@\u0001A\u0003%\u0001\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\ty\u0001\u0001Q\u0001\n\u0005\r\u0001bCA\t\u0001\u0001\u0007\t\u0019!C\u0001\u0003'A1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001e!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011-\tY\u0003\u0001a\u0001\u0002\u0004%\t!!\f\t\u0017\u0005U\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0007\u0005\f\u0003w\u0001\u0001\u0019!A!B\u0013\ty\u0003C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@!A\u0011q\u000b\u0001!\u0002\u0013\t\t\u0005C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\\!9\u0011Q\u0010\u0001\u0005\u0002\u0005m\u0003bBAD\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u0017\u0003A\u0011AA.\u0011\u001d\ti\n\u0001C\u0001\u00037Bq!!)\u0001\t\u0013\tY\u0006C\u0004\u0002$\u0002!I!a\u0017\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\bbBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003T\u0001!IA!\u0016\u0003#A\u000b'\u000f^5uS>tGj\\2l)\u0016\u001cHO\u0003\u00022e\u000591\r\\;ti\u0016\u0014(\"A\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\ti\u0004)D\u0001?\u0015\ty$'A\u0003vi&d7/\u0003\u0002B}\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001E!\t)\u0005!D\u00011\u0003IqW/\u001c*fa2L7-\u0019$fi\u000eDWM]:\u0016\u0003!\u0003\"aN%\n\u0005)C$aA%oi\u0006\u0019b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:tA\u0005aa.^7Qe>$WoY3sg\u0006ia.^7Qe>$WoY3sg\u0002\nQC\\;n%\u0016\u001cwN\u001d3t!\u0016\u0014\bK]8ek\u000e,'/\u0001\fok6\u0014VmY8sIN\u0004VM\u001d)s_\u0012,8-\u001a:!\u0003!iwnY6US6,W#\u0001*\u0011\u0005u\u001a\u0016B\u0001+?\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u0019!X\u000e\u001d#jeV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0011\u0011n\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&L\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005yQ\r_3dkR|'oU3sm&\u001cW-F\u0001f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\u001b/\u0002\tU$\u0018\u000e\\\u0005\u0003Y\u001e\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0011Kb,7-\u001e;peN+'O^5dK\u0002\nq\"\u00199qK:$7+Z7ba\"|'/Z\u000b\u0002aB\u0011a-]\u0005\u0003e\u001e\u0014\u0011bU3nCBDwN]3\u0002!\u0005\u0004\b/\u001a8e'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013AE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\f1c\u001d5sS:\\\u0017j\u001d:TK6\f\u0007\u000f[8sK\u0002\n\u0011\u0003^5fe2{wmQ8na>tWM\u001c;t+\u0005A\bCA=}\u001b\u0005Q(BA>3\u0003\rawnZ\u0005\u0003{j\u0014\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0003I!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u0011\u0002%QLWM\u001d*fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0011\u0014\u0001\u0002;jKJLA!!\u0004\u0002\b\t\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003M!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:!\u0003)awnZ'b]\u0006<WM]\u000b\u0003\u0003+\u00012!_A\f\u0013\r\tIB\u001f\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003?\t)\u0003E\u00028\u0003CI1!a\t9\u0005\u0011)f.\u001b;\t\u0013\u0005\u001d\u0012$!AA\u0002\u0005U\u0011a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u00020A\u0019Q)!\r\n\u0007\u0005M\u0002GA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!a\b\u0002:!I\u0011q\u0005\u000f\u0002\u0002\u0003\u0007\u0011qF\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002T5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004d_6lwN\u001c\u0006\u0004g\u0005-#\u0002BA'\u0003\u001f\na!\u00199bG\",'BAA)\u0003\ry'oZ\u0005\u0005\u0003+\n)E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQa]3u+B$\"!a\b)\u0007\u0001\ny\u0006\u0005\u0003\u0002b\u0005=TBAA2\u0015\u0011\t)'a\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002j\u0005-\u0014a\u00026va&$XM\u001d\u0006\u0005\u0003[\ny%A\u0003kk:LG/\u0003\u0003\u0002r\u0005\r$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\"\u0003o\u0002B!!\u0019\u0002z%!\u00111PA2\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0013uKN$hj\u001c'pG.\u001cuN\u001c;f]RLwN\\,ji\"|W\u000f^%teV\u0003H-\u0019;fQ\r\u0011\u0013\u0011\u0011\t\u0005\u0003C\n\u0019)\u0003\u0003\u0002\u0006\u0006\r$\u0001\u0002+fgR\fA\u0007^3ti\u0006\u0003\b/\u001a8e%\u0016\u0004H.[2b\r\u0016$8\r[,ji\"\u001c6\r[3ek2,'o\u00115fG.4uN]*ie&t7.S:sQ\r\u0019\u0013\u0011Q\u0001$i\u0016\u001cH/\u00119qK:$'+\u001a9mS\u000e\fg)\u001a;dQ^KG\u000f[+qI\u0006$X-S:sQ\u001d!\u0013qRAK\u0003/\u0003B!!\u0019\u0002\u0012&!\u00111SA2\u0005!!\u0015n]1cY\u0016$\u0017!\u0002<bYV,\u0017EAAM\u0003-YUIT$J\u001d\u0016k\u0013'\u000f\u001a)\u0007\u0011\n\t)\u0001\u0015uKN$x)\u001a;SKBd\u0017nY1XSRDW\u000b\u001d3bi\u0016\f5o]5h]6,g\u000e^!oI&\u001b(\u000fK\u0002&\u0003\u0003\u000baeY8oGV\u0014(/\u001a8u!J|G-^2f\r\u0016$8\r[,ji\"\u0014V-\u00193M_\u000e\\wJ\u001c7z\u0003\r\u001awN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a$fi\u000eDw+\u001b;i/JLG/\u001a'pG.\fqb]2iK\u0012,H.Z!qa\u0016tGm\u001d\u000b\u0003\u0003S\u0003b!a+\u0002<\u0006\u0005g\u0002BAW\u0003osA!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003g#\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\r\tI\fO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti,a0\u0003\u0007M+\u0017OC\u0002\u0002:b\u0002D!a1\u0002NB)a-!2\u0002J&\u0019\u0011qY4\u0003\r\u0019+H/\u001e:f!\u0011\tY-!4\r\u0001\u0011Y\u0011q\u001a\u0015\u0002\u0002\u0003\u0005)\u0011AAi\u0005\ryF%M\t\u0005\u0003'\fI\u000eE\u00028\u0003+L1!a69\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aNAn\u0013\r\ti\u000e\u000f\u0002\u0004\u0003:L\u0018aF:dQ\u0016$W\u000f\\3G_2dwn^3s\r\u0016$8\r[3t)\u0019\t\u0019/a<\u0002tB1\u00111VA^\u0003K\u0004D!a:\u0002lB)a-!2\u0002jB!\u00111ZAv\t-\ti/KA\u0001\u0002\u0003\u0015\t!!5\u0003\u0007}##\u0007\u0003\u0004\u0002r&\u0002\r\u0001S\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u0002v&\u0002\r\u0001S\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018!E:dQ\u0016$W\u000f\\3TQJLgn[%teR1\u00111 B\u0003\u0005+\u0001D!!@\u0003\u0002A)a-!2\u0002\u0000B!\u00111\u001aB\u0001\t-\u0011\u0019AKA\u0001\u0002\u0003\u0015\t!!5\u0003\u0007}#3\u0007C\u0004\u0003\b)\u0002\rA!\u0003\u0002\u0015\u0005\u001cG/\u001b<f\r2\fw\r\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011yaZ\u0001\u0007CR|W.[2\n\t\tM!Q\u0002\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000f\t]!\u00061\u0001\u0003\u001a\u0005yQn\\2l)&lWm\u00157fKBl5\u000fE\u00028\u00057I1A!\b9\u0005\u0011auN\\4\u0002/M,G/\u001e9QCJ$\u0018\u000e^5p]^KG\u000f['pG.\u001cH\u0003BA\u0018\u0005GAq!!\u0005,\u0001\u0004\t)\"A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003*\tE\u0002\u0003\u0002B\u0016\u0005[i\u0011![\u0005\u0004\u0005_I'A\u0003)s_B,'\u000f^5fg\"9!1\u0007\u0017A\u0002\tU\u0012!C8wKJ\u0014\u0018\u000eZ3t!!\u00119Da\u0010\u0003F\t\u0015c\u0002\u0002B\u001d\u0005w\u00012!a,9\u0013\r\u0011i\u0004O\u0001\u0007!J,G-\u001a4\n\t\t\u0005#1\t\u0002\u0004\u001b\u0006\u0004(b\u0001B\u001fqA!!q\u0007B$\u0013\u0011\u0011IEa\u0011\u0003\rM#(/\u001b8h\u0003\u0019\t\u0007\u000f]3oIR1\u0011q\u0004B(\u0005#Bq!a\u000b.\u0001\u0004\ty\u0003\u0003\u0004\u0002v6\u0002\r\u0001S\u0001\u000eM\u0016$8\r\u001b$pY2|w/\u001a:\u0015\u0015\u0005}!q\u000bB-\u0005;\u0012y\u0006C\u0004\u0002,9\u0002\r!a\f\t\r\tmc\u00061\u0001I\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003ct\u0003\u0019\u0001%\t\r\u0005Uh\u00061\u0001I\u0001")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime;
    private final File tmpDir;
    private final File logDir;
    private final ExecutorService executorService;
    private final Semaphore appendSemaphore;
    private final Semaphore shrinkIsrSemaphore;
    private final TierLogComponents tierLogComponents;
    private final TierReplicaManager tierReplicaManager;
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        boolean x$11 = CleanerConfig$.MODULE$.apply$default$11();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10, x$11), this.mockTime(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7(), TestUtils$.MODULE$.createLogManager$default$8(), TestUtils$.MODULE$.createLogManager$default$9()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled(value="KENGINE-192")
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints, (Option)None$.MODULE$);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(15L, TimeUnit.SECONDS));
    }

    private Seq<Future<?>> scheduleAppends() {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable & scala.Serializable)x$8 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener alterPartitionListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, alterPartitionListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public AbstractLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                AbstractLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, topicId);
                return new LogTestUtils.SlowAppendAsLeaderLog((MergedLog)log, this.$outer.tierLogComponents(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latest(), brokerId$1, (Time)$outer.mockTime(), alterPartitionListener$1, delayedOperations$1, metadataCache$1, logManager$1, (Option)new Some((Object)$outer.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, alterIsrManager$1, (Option)None$.MODULE$, Partition$.MODULE$.$lessinit$greater$default$15(), Partition$.MODULE$.$lessinit$greater$default$16());
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)partition.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), this.kafka$cluster$PartitionLockTest$$topicPartition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$2(brokerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)x$9 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$9)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), followerId, 0L, 1, maxBytes, (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
            FullPartitionFetchMetadata fetchPartitionData = new FullPartitionFetchMetadata(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, (PartitionFetchMetadata)fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((boolean)logReadInfo.divergingEpoch().isEmpty());
            AbstractFetchDataInfo abstractFetchDataInfo = logReadInfo.fetchedData();
            if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                if (abstractFetchDataInfo instanceof TierFetchDataInfo) {
                    throw new OffsetTieredException(new StringBuilder(34).append("Unexpected tiered fetch at offset ").append(fetchOffset).toString());
                }
                throw new MatchError((Object)abstractFetchDataInfo);
            }
            FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
            Iterable iterable = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().batches()).asScala();
            if (!iterable.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)iterable.size());
            RecordBatch batch = (RecordBatch)iterable.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$8) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$2(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$9) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        return partition$1.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal$1, partition$1.appendRecordsToLeader$default$5());
    }

    public PartitionLockTest() {
        Logging.$init$((Logging)this);
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        this.mockTime = new MockTime();
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
        this.appendSemaphore = new Semaphore(0);
        this.shrinkIsrSemaphore = new Semaphore(0);
        this.tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        this.tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
        this.kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    }
}

