/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.MergedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ut!\u0002\u0013&\u0011\u0003Qc!\u0002\u0017&\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007w\u0005\u0001\u000b\u0011\u0002\u001d\t\u000fq\n!\u0019!C\u0001{!1\u0011*\u0001Q\u0001\nyBqAS\u0001C\u0002\u0013\u00051\n\u0003\u0004P\u0003\u0001\u0006I\u0001\u0014\u0004\u0005Y\u0015\u0002\u0001\u000bC\u00035\u0013\u0011\u0005\u0011\u000bC\u0004T\u0013\t\u0007I\u0011\u0001+\t\rmK\u0001\u0015!\u0003V\u0011%a\u0016\u00021AA\u0002\u0013\u0005Q\fC\u0005b\u0013\u0001\u0007\t\u0019!C\u0001E\"I\u0001.\u0003a\u0001\u0002\u0003\u0006KA\u0018\u0005\u0006S&!\tA\u001b\u0005\u0006m&!Ia\u001e\u0005\b\u0003\u000bIA\u0011AA\u0004\u0011\u001d\t\u0019\"\u0003C\u0005\u0003+Aq!a\t\n\t\u0013\t)\u0003C\u0004\u00028%!I!!\u000f\t\u000f\u0005u\u0012\u0002\"\u0003\u0002@!1\u00111I\u0005\u0005\u0002)Da!!\u0014\n\t\u0003Q\u0007BBA)\u0013\u0011\u0005!\u000e\u0003\u0004\u0002V%!\tA\u001b\u0005\u0007\u00033JA\u0011\u00016\t\r\u0005u\u0013\u0002\"\u0001k\u0011\u0019\t\t'\u0003C\u0001U\"1\u0011QM\u0005\u0005\u0002)Da!!\u001b\n\t\u0003Q\u0007BBA7\u0013\u0011\u0005!\u000e\u0003\u0004\u0002r%!\tA\u001b\u0005\u0007\u0003kJA\u0011\u00016\t\r\u0005e\u0014\u0002\"\u0001k\u0003-\u0011V\r\u001d7jG\u0006$Vm\u001d;\u000b\u0005\u0019:\u0013aB2mkN$XM\u001d\u0006\u0002Q\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0016\u0002\u001b\u0005)#a\u0003*fa2L7-\u0019+fgR\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!&\u0001\u0005Ce>\\WM]%e+\u0005A\u0004CA\u0018:\u0013\tQ\u0004GA\u0002J]R\f\u0011B\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0013A\u000b'\u000f^5uS>tW#\u0001 \u0011\u0005}:U\"\u0001!\u000b\u0005\u0005\u0013\u0015AB2p[6|gN\u0003\u0002)\u0007*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tA\u0005I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\u000b'\u000f^5uS>t\u0007%A\nSKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5/F\u0001M!\tyS*\u0003\u0002Oa\t!Aj\u001c8h\u0003Q\u0011V\r\u001d7jG\u0006d\u0015m\u001a+j[\u0016l\u0015\r_'tAM\u0011\u0011B\f\u000b\u0002%B\u00111&C\u0001\u0005i&lW-F\u0001V!\t1\u0016,D\u0001X\u0015\tAv%A\u0003vi&d7/\u0003\u0002[/\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004sKBd\u0017nY1\u0016\u0003y\u0003\"aK0\n\u0005\u0001,#a\u0002*fa2L7-Y\u0001\fe\u0016\u0004H.[2b?\u0012*\u0017\u000f\u0006\u0002dMB\u0011q\u0006Z\u0005\u0003KB\u0012A!\u00168ji\"9qMDA\u0001\u0002\u0004q\u0016a\u0001=%c\u0005A!/\u001a9mS\u000e\f\u0007%A\u0003tKR,\b\u000fF\u0001dQ\t\u0001B\u000e\u0005\u0002ni6\taN\u0003\u0002pa\u0006\u0019\u0011\r]5\u000b\u0005E\u0014\u0018a\u00026va&$XM\u001d\u0006\u0003g\u0016\u000bQA[;oSRL!!\u001e8\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\nbgN,'\u000f\u001e*fa2L7-Y*uCR,GcB2yurt\u0018\u0011\u0001\u0005\u0006sF\u0001\r\u0001T\u0001\u000fY><7\u000b^1si>3gm]3u\u0011\u0015Y\u0018\u00031\u0001M\u00031awnZ#oI>3gm]3u\u0011\u0015i\u0018\u00031\u0001M\u0003Ia\u0017m\u001d;DCV<\u0007\u000e^+q)&lW-T:\t\u000b}\f\u0002\u0019\u0001'\u000271\f7\u000f\u001e$fi\u000eDG*Z1eKJdunZ#oI>3gm]3u\u0011\u0019\t\u0019!\u0005a\u0001\u0019\u0006yA.Y:u\r\u0016$8\r\u001b+j[\u0016l5/A\u0010bgN,'\u000f\u001e*fa2L7-Y*uCR,Gi\\3t\u001d>$8\t[1oO\u0016$2aYA\u0005\u0011!\tYA\u0005CA\u0002\u00055\u0011AA8q!\u0011y\u0013qB2\n\u0007\u0005E\u0001G\u0001\u0005=Eft\u0017-\\3?\u0003A)\b\u000fZ1uK\u001a+Go\u00195Ti\u0006$X\rF\u0004M\u0003/\tY\"a\b\t\r\u0005e1\u00031\u0001M\u0003M1w\u000e\u001c7po\u0016\u0014h)\u001a;dQ>3gm]3u\u0011\u0019\tib\u0005a\u0001\u0019\u0006\u0019bm\u001c7m_^,'o\u0015;beR|eMZ:fi\"1\u0011\u0011E\nA\u00021\u000bq\u0002\\3bI\u0016\u0014XI\u001c3PM\u001a\u001cX\r^\u0001\u0012e\u0016\u001cX\r\u001e*fa2L7-Y*uCR,Gc\u0002'\u0002(\u0005%\u00121\u0007\u0005\u0007\u0003C!\u0002\u0019\u0001'\t\u000f\u0005-B\u00031\u0001\u0002.\u0005Y\u0011n\u001d(fo2+\u0017\rZ3s!\ry\u0013qF\u0005\u0004\u0003c\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003k!\u0002\u0019AA\u0017\u0003AI7OR8mY><XM]%o'ft7-\u0001\u000enCf\u0014WMU3tKRd\u0015m\u001d;DCV<\u0007\u000e^+q)&lW\rF\u0002M\u0003wAa!!\t\u0016\u0001\u0004a\u0015AC5t\u0007\u0006,x\r\u001b;VaR!\u0011QFA!\u0011\u0019\t\tC\u0006a\u0001\u0019\u0006\u0001B/Z:u\u0013:LG/[1m'R\fG/\u001a\u0015\u0004/\u0005\u001d\u0003cA7\u0002J%\u0019\u00111\n8\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH/\u00169eCR,g)\u001a;dQN#\u0018\r^3)\u0007a\t9%\u0001\u001fuKN$(+Z:fiJ+\u0007\u000f\\5dCN#\u0018\r^3XQ\u0016tG*Z1eKJL5OU3fY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5/\u00138Ts:\u001c\u0007fA\r\u0002H\u0005yD/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u0019\u0016\fG-\u001a:JgJ+W\r\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1Jg:{G/\u00138Ts:\u001c\u0007f\u0001\u000e\u0002H\u0005iD/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u001d\u0016<H*Z1eKJL5/\u00127fGR,G-\u00118e%\u0016\u0004H.[2b\u0013NLenU=oG\"\u001a1$a\u0012\u0002\u0001R,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c(fo2+\u0017\rZ3s\u0013N,E.Z2uK\u0012\fe\u000e\u001a*fa2L7-Y%t\u001d>$\u0018J\\*z]\u000eD3\u0001HA$\u0003e!Xm\u001d;SKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3)\u0007u\t9%A$uKN$(+Z:fi2\u000b7\u000f^\"bk\u001eDG/\u00169US6,\u0017j\u001d(piJ+7/\u001a;BMR,'\u000fT3bI\u0016\u0014X\t\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1O_RLe.S:sQ\rq\u0012qI\u0001Hi\u0016\u001cH\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Jg:{GOU3tKR<\u0006.\u001a8Va\u0012\fG/\u001a$fi\u000eD7\u000b^1uK^KG\u000f[*uC2,Gj\\4F]\u0012|eMZ:fi\"\u001aq$a\u0012\u0002qQ,7\u000f\u001e*fa2L7-Y*i_VdGMT8u\u0005\u0016\u001c\u0015-^4iiV\u0003x\u000b[3o+NLgnZ*uC2,Gj\\4F]\u0012|eMZ:fi\"\u001a\u0001%a\u0012\u0002WQ,7\u000f^%t\u0007\u0006,x\r\u001b;Va^CWM\u001c*fa2L7-Y%t\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D3!IA$\u00039\"Xm\u001d;Jg\u000e\u000bWo\u001a5u+B<\u0006.\u001a8SKBd\u0017nY1Jg:{GoQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0007\t\n9%A&uKN$\u0018j]\"bk\u001eDG/\u00169US6,\u0017j\u001d(pi\u0006cw/Y=t%\u0016\u001cX\r^,iK:4u\u000e\u001c7po\u0016\u0014\u0018j]\"bk\u001eDG/\u00169U_N#\u0018\r\\3M_\u001e,e\u000eZ(gMN,G\u000fK\u0002$\u0003\u000f\u0002")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition()));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs());
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchState(new LogOffsetMetadata(followerFetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), followerStartOffset, currentTimeMs, leaderEndOffset);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    /*
     * WARNING - void declaration
     */
    private long maybeResetLastCaughtUpTime(long leaderEndOffset) {
        void var3_2;
        long currentTimeMs = this.time().milliseconds();
        this.replica().maybeResetLastCaughtUpTime(currentTimeMs, leaderEndOffset);
        return (long)var3_2;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L);
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1);
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2);
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), resetTimeMs1, MergedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, MergedLog$.MODULE$.UnknownOffset(), 0L);
    }

    @Test
    public void testResetLastCaughtUpTime() {
        this.updateFetchState(5L, 1L, 10L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(15L));
        this.time().sleep(1000L);
        this.updateFetchState(10L, 1L, 15L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        this.time().sleep(1000L);
        this.updateFetchState(16L, 1L, 16L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(17L);
        this.assertReplicaState(1L, 16L, resetTimeMs1, 17L, resetTimeMs1);
    }

    @Test
    public void testResetLastCaughtUpTimeIsNotResetAfterLeaderElectedAndReplicaNotInIsr() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(10L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 10L, 0L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
    }

    @Test
    public void testLastCaughtUpTimeIsNotResetWhenUpdateFetchStateWithStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
    }

    @Test
    public void testReplicaShouldNotBeCaughtUpWhenUsingStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(0L, 0L, 10L);
        this.assertReplicaState(0L, 0L, 0L, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.maybeResetLastCaughtUpTime(12L));
        this.updateFetchState(10L, 1L, 10L);
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(12L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @Test
    public void testIsCaughtUpTimeIsNotAlwaysResetWhenFollowerIsCaughtUpToStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1);
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(11L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(12L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(12L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(13L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1);
        Assertions.assertTrue((boolean)this.isCaughtUp(13L));
        this.time().sleep(1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(13L));
    }
}

