/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.TenantHelpers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TenantHelpersTest {
    @Test
    public void testIsTenantPrefixed() {
        Assertions.assertTrue((boolean)TenantHelpers.isTenantPrefixed((String)"lkc-8vgl6g2_console-consumer"));
        Assertions.assertTrue((boolean)TenantHelpers.isTenantPrefixed((String)"lkc-8vgl6g2_bla"));
        Assertions.assertFalse((boolean)TenantHelpers.isTenantPrefixed((String)"lkc-8vg"));
        Assertions.assertFalse((boolean)TenantHelpers.isTenantPrefixed((String)"bla"));
    }

    @Test
    public void testExtractTenantPrefix() {
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vgl6g2_console-consumer"));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vgl6g2_bla"));
        Assertions.assertNull((Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vg"));
        Assertions.assertNull((Object)TenantHelpers.extractTenantPrefix((String)"not_a_tenant"));
        Assertions.assertEquals((Object)"lkc-8vgl6g2", (Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vgl6g2_console-consumer", (boolean)false));
        Assertions.assertEquals((Object)"lkc-8vgl6g2", (Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vgl6g2_bla", (boolean)false));
        Assertions.assertNull((Object)TenantHelpers.extractTenantPrefix((String)"lkc-8vg", (boolean)false));
        Assertions.assertNull((Object)TenantHelpers.extractTenantPrefix((String)"not_a_tenant", (boolean)false));
    }

    @Test
    public void testExtractLogicalName() {
        Assertions.assertEquals((Object)"group-1", (Object)TenantHelpers.extractLogicalName((String)"lkc-8vgl6g2_group-1"));
        Assertions.assertEquals((Object)"topic-1", (Object)TenantHelpers.extractLogicalName((String)"lkc-8vgl6g2_topic-1"));
        Assertions.assertEquals((Object)"__consumer_offsets", (Object)TenantHelpers.extractLogicalName((String)"__consumer_offsets"));
        Assertions.assertNull((Object)TenantHelpers.extractLogicalName((String)"lkc-8vg"));
    }
}

