/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.AlterReplicaExclusionsResult;
import kafka.common.BrokerReplicaExclusion;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.DataBalanceManager;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.KafkaControllerTest$;
import kafka.controller.KafkaControllerTest$SuccessfulAlterLeadershipScenario$;
import kafka.controller.KafkaControllerTest$SuccessfulExclusionScenario$;
import kafka.server.BrokerFeatures;
import kafka.server.DelegationTokenManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ZkFinalizedFeatureCache;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r%f\u0001B&M\u0001ECQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013\u0005Q\f\u0003\u0004l\u0001\u0001\u0006IA\u0018\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u0019I\b\u0001)A\u0005]\"9!\u0010\u0001b\u0001\n\u0003Y\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0001\u0002\u0004!I\u0011\u0011\u0003\u0001A\u0002\u0013\u0005\u00111\u0003\u0005\t\u0003?\u0001\u0001\u0015)\u0003\u0002\u0006!I\u0011\u0011\u0005\u0001A\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003c\u0001\u0001\u0019!C\u0001\u0003gA\u0001\"a\u000e\u0001A\u0003&\u0011Q\u0005\u0005\n\u0003s\u0001\u0001\u0019!C\u0001\u0003wA\u0011\"a\u0012\u0001\u0001\u0004%\t!!\u0013\t\u0011\u00055\u0003\u0001)Q\u0005\u0003{A\u0011\"a\u0014\u0001\u0001\u0004%\t!!\u0015\t\u0013\u0005e\u0003\u00011A\u0005\u0002\u0005m\u0003\u0002CA0\u0001\u0001\u0006K!a\u0015\t\u0013\u0005\u0005\u0004\u00011A\u0005\u0002\u0005\r\u0004\"CA6\u0001\u0001\u0007I\u0011AA7\u0011!\t\t\b\u0001Q!\n\u0005\u0015\u0004\"CA:\u0001\u0001\u0007I\u0011AA;\u0011%\tY\n\u0001a\u0001\n\u0003\ti\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BA<\u0011%\t\u0019\u000b\u0001a\u0001\n\u0003\t)\u000bC\u0005\u0002.\u0002\u0001\r\u0011\"\u0001\u00020\"A\u00111\u0017\u0001!B\u0013\t9\u000bC\u0005\u00026\u0002\u0001\r\u0011\"\u0001\u00028\"I\u0011Q\u0019\u0001A\u0002\u0013\u0005\u0011q\u0019\u0005\t\u0003\u0017\u0004\u0001\u0015)\u0003\u0002:\"I\u0011Q\u001a\u0001A\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/\u0004\u0001\u0019!C\u0001\u00033D\u0001\"!8\u0001A\u0003&\u0011\u0011\u001b\u0005\f\u0003?\u0004\u0001\u0019!a\u0001\n\u0003\t\t\u000fC\u0006\u0002j\u0002\u0001\r\u00111A\u0005\u0002\u0005-\bbCAx\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GD\u0011\"!=\u0001\u0005\u0004%\t!a=\t\u0011\u0005m\b\u0001)A\u0005\u0003kD1\"!@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0000\"Y!1\u0002\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0007\u0011-\u0011\t\u0002\u0001a\u0001\u0002\u0003\u0006KA!\u0001\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!Q\u0006\u0001\u0005\u0002\tU\u0001b\u0002B\u001c\u0001\u0011\u0005!Q\u0003\u0005\b\u0005\u0003\u0002A\u0011\u0001B\u000b\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005+AqA!\u0013\u0001\t\u0003\u0011)\u0002C\u0004\u0003N\u0001!\tA!\u0006\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!Q\u000b\u0001\u0005\u0002\tU\u0001b\u0002B-\u0001\u0011\u0005!Q\u0003\u0005\b\u0005;\u0002A\u0011\u0001B\u000b\u000f\u001d\u0011\t\u0007\u0001E\u0001\u0005G2qAa\u001a\u0001\u0011\u0003\u0011I\u0007\u0003\u0004Yo\u0011\u0005!1\u000e\u0005\b\u0005[:D\u0011\u0001B8\u000f\u001d\u00119\u000e\u0001E\u0001\u000534qAa7\u0001\u0011\u0003\u0011i\u000e\u0003\u0004Yw\u0011\u0005!q\u001c\u0005\n\u0005C\\$\u0019!C\u0001\u0005GD\u0001Ba=<A\u0003%!Q\u001d\u0005\b\u0005k\\D\u0011\u0001B\u000b\u0011\u001d\u00119p\u000fC\u0001\u0005sDqaa\u0006\u0001\t\u0003\u0011)\u0002C\u0004\u0004\u001c\u0001!Ia!\b\t\u000f\r-\u0003\u0001\"\u0003\u0004N!911\n\u0001\u0005\n\r]\u0004bBB@\u0001\u0011%1\u0011Q\u0004\b\u0007\u001bc\u0005\u0012ABH\r\u0019YE\n#\u0001\u0004\u0012\"1\u0001l\u0012C\u0001\u0007'Cqa!&H\t\u0003\u0011)\u0002C\u0004\u0004 \u001e#\tA!\u0006\u0003'-\u000bgm[1D_:$(o\u001c7mKJ$Vm\u001d;\u000b\u00055s\u0015AC2p]R\u0014x\u000e\u001c7fe*\tq*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025B\u00111\fA\u0007\u0002\u0019\u0006!A/[7f+\u0005q\u0006CA0j\u001b\u0005\u0001'BA1c\u0003\u0015)H/\u001b7t\u0015\t\u0019G-\u0001\u0004d_6lwN\u001c\u0006\u0003\u001f\u0016T!AZ4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0017aA8sO&\u0011!\u000e\u0019\u0002\u0005)&lW-A\u0003uS6,\u0007%A\nuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe>\u0003H/F\u0001o!\r\u0019v.]\u0005\u0003aR\u0013aa\u00149uS>t\u0007C\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0015!x\u000e]5d\u0015\t1h*\u0001\u0003uS\u0016\u0014\u0018B\u0001=t\u0005A!\u0016.\u001a:U_BL7-T1oC\u001e,'/\u0001\u000buS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe>\u0003H\u000fI\u0001\u0013S:LG/[1m\u0005J|7.\u001a:Fa>\u001c\u0007.F\u0001}!\t\u0019V0\u0003\u0002\u007f)\n!Aj\u001c8h\u0003MIg.\u001b;jC2\u0014%o\\6fe\u0016\u0003xn\u00195!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002(\u0002\rM,'O^3s\u0013\u0011\ty!!\u0003\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u000b\u00037\u00012aUA\f\u0013\r\tI\u0002\u0016\u0002\u0005+:LG\u000fC\u0005\u0002\u001e%\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,9\u000b!A_6\n\t\u0005=\u0012\u0011\u0006\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0019i\\7\t\\5f]R|F%Z9\u0015\t\u0005U\u0011Q\u0007\u0005\n\u0003;a\u0011\u0011!a\u0001\u0003K\t\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u000f5,GO]5dgV\u0011\u0011Q\b\t\u0005\u0003\u007f\t\u0019%\u0004\u0002\u0002B)\u0019\u0011\u0011\b2\n\t\u0005\u0015\u0013\u0011\t\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005U\u00111\n\u0005\n\u0003;y\u0011\u0011!a\u0001\u0003{\t\u0001\"\\3ue&\u001c7\u000fI\u0001\u0012S:LG/[1m\u0005J|7.\u001a:J]\u001a|WCAA*!\u0011\t9#!\u0016\n\t\u0005]\u0013\u0011\u0006\u0002\u000b\u0005J|7.\u001a:J]\u001a|\u0017!F5oSRL\u0017\r\u001c\"s_.,'/\u00138g_~#S-\u001d\u000b\u0005\u0003+\ti\u0006C\u0005\u0002\u001eI\t\t\u00111\u0001\u0002T\u0005\u0011\u0012N\\5uS\u0006d'I]8lKJLeNZ8!\u00031!xn[3o\u001b\u0006t\u0017mZ3s+\t\t)\u0007\u0005\u0003\u0002\b\u0005\u001d\u0014\u0002BA5\u0003\u0013\u0011a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u0011i>\\WM\\'b]\u0006<WM]0%KF$B!!\u0006\u0002p!I\u0011QD\u000b\u0002\u0002\u0003\u0007\u0011QM\u0001\u000ei>\\WM\\'b]\u0006<WM\u001d\u0011\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u0016:!\u00111PAH\u001d\u0011\ti(a#\u000f\t\u0005}\u0014\u0011\u0012\b\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011)\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0015bAA\u0006\u001d&!\u0011QRA\u0005\u0003\u0011a\u0017N\\6\n\t\u0005E\u00151S\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u0018P\u0003\u0003\u0002\u000e\u0006%\u0011\u0002BAL\u00033\u00131\u0002T5oW6\u000bg.Y4fe*!\u0011\u0011SAJ\u0003Y\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:`I\u0015\fH\u0003BA\u000b\u0003?C\u0011\"!\b\u0019\u0003\u0003\u0005\r!a\u001e\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002\u001d\t\u0014xn[3s\r\u0016\fG/\u001e:fgV\u0011\u0011q\u0015\t\u0005\u0003\u000f\tI+\u0003\u0003\u0002,\u0006%!A\u0004\"s_.,'OR3biV\u0014Xm]\u0001\u0013EJ|7.\u001a:GK\u0006$XO]3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005E\u0006\"CA\u000f7\u0005\u0005\t\u0019AAT\u0003=\u0011'o\\6fe\u001a+\u0017\r^;sKN\u0004\u0013\u0001\u00044fCR,(/Z\"bG\",WCAA]!\u0011\tY,!1\u000e\u0005\u0005u&\u0002BA`\u0003\u0013\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u0007\fiLA\f[W\u001aKg.\u00197ju\u0016$g)Z1ukJ,7)Y2iK\u0006\u0001b-Z1ukJ,7)Y2iK~#S-\u001d\u000b\u0005\u0003+\tI\rC\u0005\u0002\u001ey\t\t\u00111\u0001\u0002:\u0006ia-Z1ukJ,7)Y2iK\u0002\nqb[1gW\u0006\u001cuN\u001c;s_2dWM]\u000b\u0003\u0003#\u00042aWAj\u0013\r\t)\u000e\u0014\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006\u00192.\u00194lC\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u0011QCAn\u0011%\ti\"IA\u0001\u0002\u0004\t\t.\u0001\tlC\u001a\\\u0017mQ8oiJ|G\u000e\\3sA\u0005\u0019\"-\u00197b]\u000e,'/T1oC\u001e,'/T8dWV\u0011\u00111\u001d\t\u00047\u0006\u0015\u0018bAAt\u0019\n\u0011B)\u0019;b\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s\u0003]\u0011\u0017\r\\1oG\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u00055\b\"CA\u000fI\u0005\u0005\t\u0019AAr\u0003Q\u0011\u0017\r\\1oG\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2lA\u0005qQ\r]8dQj[g+\u001a:tS>tWCAA{!\r\u0019\u0016q_\u0005\u0004\u0003s$&aA%oi\u0006yQ\r]8dQj[g+\u001a:tS>t\u0007%\u0001\bfq\u000edWo]5p]\u000e\u000b7\r[3\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u000fi!A!\u0002\u000b\u0005\rt\u0015\u0002\u0002B\u0005\u0005\u000b\u0011QCU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8DC\u000eDW-\u0001\nfq\u000edWo]5p]\u000e\u000b7\r[3`I\u0015\fH\u0003BA\u000b\u0005\u001fA\u0011\"!\b*\u0003\u0003\u0005\rA!\u0001\u0002\u001f\u0015D8\r\\;tS>t7)Y2iK\u0002\nQa]3u+B$\"!!\u0006)\u0007-\u0012I\u0002\u0005\u0003\u0003\u001c\t%RB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003$\t\u0015\u0012a\u00026va&$XM\u001d\u0006\u0004\u0005O9\u0017!\u00026v]&$\u0018\u0002\u0002B\u0016\u0005;\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0017\u00032A!!1\u0004B\u001a\u0013\u0011\u0011)D!\b\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0015;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c8i\\7qY\u0016$Xm]\"bY2\u0014\u0017mY6XSRDWK\\6o_^t7+\u001a:wKJ,\u0005pY3qi&|gn\u00148[\u0017\u0016C8-\u001a9uS>t\u0007fA\u0017\u0003<A!!1\u0004B\u001f\u0013\u0011\u0011yD!\b\u0003\tQ+7\u000f^\u0001Ci\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u001d*fiV\u0014hn]%om\u0006d\u0017\u000eZ#yG2,8/[8o\u001f:,f\u000e[1oI2,Gm\u00149UsB,\u0007f\u0001\u0018\u0003<\u0005QB/Z:u\u00032$XM\u001d*fa2L7-Y#yG2,8/[8og\"\u001aqFa\u000f\u0002wQ,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:E_\u0016\u001ch\u000e\u001e)feNL7\u000f^(o\tV\u0004H.[2bi\u0016,\u0005p\u00197vg&|g\u000eK\u00021\u0005w\t\u0011\t^3ti\u0006cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N<vN]6t\u0013\u001a$\u0015\r^1CC2\fgnY3s)\"\u0014xn^:P]:{G/\u001b4jG\u0006$\u0018n\u001c8)\u0007E\u0012Y$A\u0011ti\u0006\u0014HoQ8oiJ|G\u000e\\3s/&$\b.\u0011#f[>$X\r\u001a\"s_.,'\u000f\u0006\u0002\u0002v\u0006YB/Z:u\u00032$XM\u001d'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jifD3a\rB\u001e\u0003=\"Xm\u001d;BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5us&3G)\u0019;bE\u0006d\u0017M\\2feRC'o\\<tQ\r!$1H\u00013i\u0016\u001cH/\u00117uKJdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=XQ\u0016tG)Z7pi&twMQ3z_:$G*[7ji\"\u001aQGa\u000f\u0002CM+8mY3tg\u001a,H.\u00117uKJdU-\u00193feND\u0017\u000e]*dK:\f'/[8\u0011\u0007\t\u0015t'D\u0001\u0001\u0005\u0005\u001aVoY2fgN4W\u000f\\!mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9TG\u0016t\u0017M]5p'\t9$\u000b\u0006\u0002\u0003d\u0005yb/\u001a:jMfdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=SKN,H\u000e^:\u0015\u0011\u0005U!\u0011\u000fBX\u0005gCqAa\u001d:\u0001\u0004\u0011)(A\rmK\u0006$WM]:iSB\u0004&/[8sSRL(+Z:vYR\u001c\b\u0003B*p\u0005o\u0002bA!\u001f\u0003\u0004\n%e\u0002\u0002B>\u0005\u007frA!!!\u0003~%\tQ+C\u0002\u0003\u0002R\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0006\n\u001d%\u0001\u0002'jgRT1A!!U!\u0011\u0011YI!+\u000f\t\t5%1\u0015\b\u0005\u0005\u001f\u0013yJ\u0004\u0003\u0003\u0012\nue\u0002\u0002BJ\u00057sAA!&\u0003\u001a:!\u0011\u0011\u0011BL\u0013\u0005A\u0017B\u00014h\u0013\tyU-\u0003\u0002dI&\u0019!\u0011\u00152\u0002\u000f5,7o]1hK&!!Q\u0015BT\u0003\r\nE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3ta>t7/\u001a#bi\u0006T1A!)c\u0013\u0011\u0011YK!,\u0003=\t\u0013xn[3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3tk2$(\u0002\u0002BS\u0005OCqA!-:\u0001\u0004\t)0\u0001\fok6tUm\u001e7z\t\u0016lw\u000e^3e\u0005J|7.\u001a:t\u0011\u001d\u0011),\u000fa\u0001\u0005o\u000b\u0001\u0003Z3n_R,GM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\r\te&\u0011\u0019Bd\u001d\u0011\u0011YL!0\u0011\u0007\u0005\u0005E+C\u0002\u0003@R\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002Bb\u0005\u000b\u00141aU3u\u0015\r\u0011y\f\u0016\t\u0005\u0005\u0013\u0014\u0019.\u0004\u0002\u0003L*!!Q\u001aBh\u0003\u0011a\u0017M\\4\u000b\u0005\tE\u0017\u0001\u00026bm\u0006LAA!6\u0003L\n9\u0011J\u001c;fO\u0016\u0014\u0018aG*vG\u000e,7o\u001d4vY\u0016C8\r\\;tS>t7kY3oCJLw\u000eE\u0002\u0003fm\u00121dU;dG\u0016\u001c8OZ;m\u000bb\u001cG.^:j_:\u001c6-\u001a8be&|7CA\u001eS)\t\u0011I.\u0001\u0007fq\u000edWo]5p]>\u00038/\u0006\u0002\u0003fB1!\u0011\u0018Ba\u0005O\u0004BA!;\u0003p6\u0011!1\u001e\u0006\u0004G\n5(bAA\u0006I&!!\u0011\u001fBv\u0005]\tE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:|\u0005/A\u0007fq\u000edWo]5p]>\u00038\u000fI\u0001\u0005i\u0016\u001cH/A\u0011bgN,'\u000f^*vG\u000e,7o\u001d4vY\u0016C8\r\\;tS>t7)\u00197mE\u0006\u001c7\u000e\u0006\u0003\u0002\u0016\tm\bb\u0002B\u007f\u0001\u0002\u0007!q`\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0011\te4\u0011AB\u0003\u0007#IAaa\u0001\u0003\b\n1Q)\u001b;iKJ\u0004Baa\u0002\u0004\u000e5\u00111\u0011\u0002\u0006\u0004\u0007\u0017\u0011\u0017\u0001\u0003:fcV,7\u000f^:\n\t\r=1\u0011\u0002\u0002\t\u0003BLWI\u001d:peB!!1AB\n\u0013\u0011\u0019)B!\u0002\u00039\u0005cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N\u0014Vm];mi\u0006AB/Z:u\u00032Lg/\u001a\"s_.,'o]*oCB\u001c\bn\u001c;)\u0007\u0005\u0013Y$A\u0010bgN,'\u000f^*vG\u000e,7o\u001d4vY\u0016C8\r\\;tS>t'+Z:vYR$\u0002\"!\u0006\u0004 \r-2q\u0006\u0005\b\u0007C\u0011\u0005\u0019AB\u0012\u0003=\u0011XmY3jm\u0016$'+Z:vYR\u001c\bC\u0002B]\u0005\u0003\u001c)\u0003\u0005\u0003\u0003j\u000e\u001d\u0012\u0002BB\u0015\u0005W\u0014AD\u0011:pW\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\u001c*fgVdG\u000fC\u0004\u0004.\t\u0003\r!!>\u0002!\u0015D\b/Z2uK\u0012\u0014%o\\6fe&#\u0007bBB\u0019\u0005\u0002\u000711G\u0001\u000fKb\u0004Xm\u0019;fI>\u0003H+\u001f9f!\u0011\u0019)d!\u0012\u000f\t\r]2\u0011I\u0007\u0003\u0007sQAaa\u000f\u0004>\u0005)\u0011\rZ7j]*\u00191q\b3\u0002\u000f\rd\u0017.\u001a8ug&!11IB\u001d\u0003-)\u0005p\u00197vg&|gn\u00149\n\t\r\u001d3\u0011\n\u0002\u0007\u001fB$\u0016\u0010]3\u000b\t\r\r3\u0011H\u0001\u0012m\u0016\u0014\u0018NZ=NKR\u0014\u0018n\u0019,bYV,G\u0003CA\u000b\u0007\u001f\u001aIga\u001d\t\u000f\rE3\t1\u0001\u0004T\u0005yQ.\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010\u0005\u0003\u0004V\r\u0015TBAB,\u0015\u0011\u0019Ifa\u0017\u0002\t\r|'/\u001a\u0006\u0005\u0003s\u0019iF\u0003\u0003\u0004`\r\u0005\u0014AB=b[6,'O\u0003\u0002\u0004d\u0005\u00191m\\7\n\t\r\u001d4q\u000b\u0002\u0010\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\"911N\"A\u0002\r5\u0014\u0001E7fiJL7mU5na2,g*Y7f!\u0011\u0011Ila\u001c\n\t\rE$Q\u0019\u0002\u0007'R\u0014\u0018N\\4\t\u000f\rU4\t1\u0001\u0003H\u0006iQ\r\u001f9fGR,GMV1mk\u0016$\u0002\"!\u0006\u0004z\rm4Q\u0010\u0005\b\u0007#\"\u0005\u0019AB*\u0011\u001d\u0019Y\u0007\u0012a\u0001\u0007[Bqa!\u001eE\u0001\u0004\u0019i'\u0001\u0004nKR\u0014\u0018n\u0019\u000b\u0007\u0007\u0007\u001bIia#\u0011\t\rU3QQ\u0005\u0005\u0007\u000f\u001b9F\u0001\u0004NKR\u0014\u0018n\u0019\u0005\b\u0007#*\u0005\u0019AB*\u0011\u001d\u0019Y'\u0012a\u0001\u0007[\n1cS1gW\u0006\u001cuN\u001c;s_2dWM\u001d+fgR\u0004\"aW$\u0014\u0005\u001d\u0013FCABH\u0003)\u0019X\r^+q\u00072\f7o\u001d\u0015\u0004\u0013\u000ee\u0005\u0003\u0002B\u000e\u00077KAa!(\u0003\u001e\tI!)\u001a4pe\u0016\fE\u000e\\\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\u0007)\u001b\u0019\u000b\u0005\u0003\u0003\u001c\r\u0015\u0016\u0002BBT\u0005;\u0011\u0001\"\u00114uKJ\fE\u000e\u001c")
public class KafkaControllerTest {
    private volatile KafkaControllerTest$SuccessfulAlterLeadershipScenario$ SuccessfulAlterLeadershipScenario$module;
    private volatile KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario$module;
    private final Time time = new MockTime();
    private final Option<TierTopicManager> tierTopicManagerOpt = None$.MODULE$;
    private final long initialBrokerEpoch;
    private KafkaConfig config = null;
    private KafkaZkClient zkClient = null;
    private Metrics metrics = null;
    private BrokerInfo initialBrokerInfo = null;
    private DelegationTokenManager tokenManager = null;
    private ClusterLinkFactory.LinkManager clusterLinkManager = null;
    private BrokerFeatures brokerFeatures = null;
    private ZkFinalizedFeatureCache featureCache = null;
    private KafkaController kafkaController = null;
    private DataBalanceManager balancerManagerMock;
    private final int epochZkVersion;
    private ReplicaExclusionCache exclusionCache;

    @AfterAll
    public static void tearDownClass() {
        KafkaControllerTest$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        KafkaControllerTest$.MODULE$.setUpClass();
    }

    public KafkaControllerTest$SuccessfulAlterLeadershipScenario$ SuccessfulAlterLeadershipScenario() {
        if (this.SuccessfulAlterLeadershipScenario$module == null) {
            this.SuccessfulAlterLeadershipScenario$lzycompute$1();
        }
        return this.SuccessfulAlterLeadershipScenario$module;
    }

    public KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario() {
        if (this.SuccessfulExclusionScenario$module == null) {
            this.SuccessfulExclusionScenario$lzycompute$1();
        }
        return this.SuccessfulExclusionScenario$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public long initialBrokerEpoch() {
        return this.initialBrokerEpoch;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void initialBrokerInfo_$eq(BrokerInfo x$1) {
        this.initialBrokerInfo = x$1;
    }

    public DelegationTokenManager tokenManager() {
        return this.tokenManager;
    }

    public void tokenManager_$eq(DelegationTokenManager x$1) {
        this.tokenManager = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    public BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    public void brokerFeatures_$eq(BrokerFeatures x$1) {
        this.brokerFeatures = x$1;
    }

    public ZkFinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    public void featureCache_$eq(ZkFinalizedFeatureCache x$1) {
        this.featureCache = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public DataBalanceManager balancerManagerMock() {
        return this.balancerManagerMock;
    }

    public void balancerManagerMock_$eq(DataBalanceManager x$1) {
        this.balancerManagerMock = x$1;
    }

    public int epochZkVersion() {
        return this.epochZkVersion;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public void exclusionCache_$eq(ReplicaExclusionCache x$1) {
        this.exclusionCache = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        props.put(KafkaConfig$.MODULE$.AlterLeadershipPriorityMaxDemotedBrokersProp(), "2");
        this.config_$eq(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2()));
        this.zkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.metrics_$eq(new Metrics());
        this.initialBrokerInfo_$eq((BrokerInfo)Mockito.mock(BrokerInfo.class));
        this.tokenManager_$eq((DelegationTokenManager)Mockito.mock(DelegationTokenManager.class));
        this.clusterLinkManager_$eq((ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
        this.brokerFeatures_$eq((BrokerFeatures)Mockito.mock(BrokerFeatures.class));
        this.featureCache_$eq((ZkFinalizedFeatureCache)Mockito.mock(ZkFinalizedFeatureCache.class));
        this.balancerManagerMock_$eq((DataBalanceManager)Mockito.mock(DataBalanceManager.class));
        this.exclusionCache_$eq(new ReplicaExclusionCache());
        TestUtils$.MODULE$.clearYammerMetrics();
        KafkaYammerMetrics.defaultRegistry().shutdown();
        this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.time(), this.metrics(), this.initialBrokerInfo(), this.initialBrokerEpoch(), this.tokenManager(), this.tierTopicManagerOpt(), this.clusterLinkManager(), this.brokerFeatures(), this.featureCache(), this.exclusionCache(), false, KafkaController$.MODULE$.$lessinit$greater$default$14(), KafkaController$.MODULE$.$lessinit$greater$default$15()));
        this.kafkaController().dataBalancer_$eq(this.balancerManagerMock());
    }

    @AfterEach
    public void tearDown() {
        if (this.kafkaController().eventManager().thread().isRunning()) {
            this.kafkaController().shutdown();
        }
    }

    @Test
    public void testAlterReplicaExclusionsCompletesCallbackWithUnknownServerExceptionOnZKException() {
        AlterReplicaExclusionOp exclusionOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.SET);
        this.zkClient().setOrCreateReplicaExclusions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(exclusionOp.brokerId(), exclusionOp.reason())})), this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)"replica_exclusions");
        });
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{exclusionOp})), (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$1(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusionsReturnsInvalidExclusionOnUnhandledOpType() {
        AlterReplicaExclusionOp unknownOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.UNKNOWN);
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{unknownOp})), (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$2(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusions() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusions$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusions$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(1, "maintenance")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusions$3(x$2);
            return BoxedUnit.UNIT;
        });
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "delete")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(x$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set exclusionOps = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{new AlterReplicaExclusionOp(1, "", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(2, "excluded", ExclusionOp.OpType.SET)}));
        this.kafkaController().alterBrokerReplicaExclusions((Set)exclusionOps, (Function1 & Serializable & scala.Serializable)result -> {
            this.callback$3(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        ((ClusterBalanceManager)Mockito.verify((Object)this.balancerManagerMock(), (VerificationMode)Mockito.never())).onAlteredExclusions((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{1}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{2}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.balancerManagerMock().onAlteredExclusions((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            throw new Exception("test!");
        });
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    public int startControllerWithADemotedBroker() {
        void var1_1;
        int demotedBrokerId = 1;
        this.kafkaController().controllerContext().setDemotedReasons(demotedBrokerId, (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$startControllerWithADemotedBroker$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$startControllerWithADemotedBroker$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map expectedLeadershipPriorityInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)demotedBrokerId)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"demoted for test"})))}));
        this.zkClient().setLeadershipPriorityState(expectedLeadershipPriorityInfo);
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            KafkaControllerTest.$anonfun$startControllerWithADemotedBroker$3(x$5);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(demotedBrokerId));
        return (int)var1_1;
    }

    @Test
    public void testAlterLeadershipPriority() {
        int initiallyDemotedBrokerId = this.startControllerWithADemotedBroker();
        ObjectRef leadershipPriorityResults = ObjectRef.create((Object)None$.MODULE$);
        int demotedBrokerId = 2;
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{demotedBrokerId})), true, false, (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$4(result, leadershipPriorityResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterLeadershipScenario().verifyLeadershipPriorityResults((Option<List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>>)((Option)leadershipPriorityResults.elem), 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDemotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerId)}))));
    }

    @Test
    public void testAlterLeadershipPriorityIfDatabalancerThrows() {
        int initiallyDemotedBrokerId = this.startControllerWithADemotedBroker();
        ObjectRef leadershipPriorityResults = ObjectRef.create((Object)None$.MODULE$);
        this.balancerManagerMock().onBrokerLeadershipPriorityChange((AliveBrokersMetadata)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            throw new Exception("test!");
        });
        int demotedBrokerId = 2;
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{demotedBrokerId})), true, true, (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$5(result, leadershipPriorityResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(2));
        this.SuccessfulAlterLeadershipScenario().verifyLeadershipPriorityResults((Option<List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>>)((Option)leadershipPriorityResults.elem), 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDemotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerId)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterLeadershipPriorityWhenDemotingBeyondLimit() {
        int initiallyDemotedBrokerId = this.startControllerWithADemotedBroker();
        ObjectRef leadershipPriorityResults = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef requestError = ObjectRef.create((Object)None$.MODULE$);
        int demotedBrokerId = 2;
        int demotedBrokerIdBeyondLimit = 3;
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{demotedBrokerId, demotedBrokerIdBeyondLimit})), true, false, (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$6(result, leadershipPriorityResults, requestError);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(1));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$4(requestError)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)Errors.DEMOTION_LIMIT_REACHED, (Object)((Option)requestError.elem).get());
        this.kafkaController().alterLeadershipPriority("demotion test", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{demotedBrokerId, demotedBrokerIdBeyondLimit})), true, true, (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$6(result, leadershipPriorityResults, requestError);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDemotedLeadershipPriorityCount", Predef$.MODULE$.int2Integer(3));
        this.SuccessfulAlterLeadershipScenario().verifyLeadershipPriorityResults((Option<List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>>)((Option)leadershipPriorityResults.elem), 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDemotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerIdBeyondLimit)}))));
    }

    @Test
    public void testAliveBrokersSnapshot() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.exclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"reason")}))).asJava());
        this.kafkaController().controllerContext().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        Assertions.assertEquals((Object)new AliveBrokersSnapshot((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)3L))}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava()), (Object)this.kafkaController().aliveBrokersSnapshot());
    }

    public void kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult(scala.collection.immutable.Set<BrokerReplicaExclusionResult> receivedResults, int expectedBrokerId, ExclusionOp.OpType expectedOpType) {
        Option findOpt = receivedResults.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KafkaControllerTest.$anonfun$assertSuccessfulExclusionResult$1(expectedBrokerId, p)));
        Assertions.assertFalse((boolean)findOpt.isEmpty(), (String)new StringBuilder(34).append("Could not find broker ").append(expectedBrokerId).append(" in results ").append(receivedResults).toString());
        BrokerReplicaExclusionResult exclusion = (BrokerReplicaExclusionResult)findOpt.get();
        Assertions.assertEquals((int)expectedBrokerId, (int)exclusion.brokerId());
        Assertions.assertEquals((Object)expectedOpType, (Object)exclusion.opType());
        Assertions.assertTrue((!exclusion.apiErrorOptional().isPresent() ? 1 : 0) != 0, (String)new StringBuilder(51).append("Expected exclusion for broker ").append(expectedBrokerId).append(" to not have an error").toString());
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, String expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$3(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$4(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        java.util.Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.controller", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    private final void SuccessfulAlterLeadershipScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulAlterLeadershipScenario$module == null) {
                this.SuccessfulAlterLeadershipScenario$module = new KafkaControllerTest$SuccessfulAlterLeadershipScenario$(this);
            }
            return;
        }
    }

    private final void SuccessfulExclusionScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulExclusionScenario$module == null) {
                this.SuccessfulExclusionScenario$module = new KafkaControllerTest$SuccessfulExclusionScenario$(this);
            }
            return;
        }
    }

    private static final void callback$1(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error.error());
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected an error while processing exclusions");
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$2(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertFalse((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to not be successful");
            Assertions.assertEquals((int)1, (int)result2.brokerReplicaExclusionResults().size());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.INVALID_REPLICA_EXCLUSION})), (Object)((SetLike)((TraversableLike)result2.brokerReplicaExclusionResults().map((Function1 & Serializable & scala.Serializable)r -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.apiErrorOptional())), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.isDefined()))).map((Function1 & Serializable & scala.Serializable)e -> ((ApiError)e.get()).error(), scala.collection.immutable.Set$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusions$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusions$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusions$3(InvocationOnMock x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(InvocationOnMock x$3) {
    }

    private final void callback$3(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertTrue((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to be successful");
            Assertions.assertEquals((int)2, (int)result2.brokerReplicaExclusionResults().size());
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 1, ExclusionOp.OpType.DELETE);
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 2, ExclusionOp.OpType.SET);
            java.util.Map exclusions = this.kafkaController().replicaExclusionCache().exclusions();
            Assertions.assertEquals((int)1, (int)exclusions.size());
            Assertions.assertTrue((boolean)exclusions.containsKey(BoxesRunTime.boxToInteger((int)1)), (String)"Expected exclusion for broker 1 to be present");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$startControllerWithADemotedBroker$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$startControllerWithADemotedBroker$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$startControllerWithADemotedBroker$3(InvocationOnMock x$5) {
    }

    private static final void callback$4(Either result, ObjectRef leadershipPriorityResults$1) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            leadershipPriorityResults$1.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$5(Either result, ObjectRef leadershipPriorityResults$2) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            leadershipPriorityResults$2.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$6(Either result, ObjectRef leadershipPriorityResults$3, ObjectRef requestError$1) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            leadershipPriorityResults$3.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            ApiError error = (ApiError)((Right)result).value();
            requestError$1.elem = new Some((Object)error.error());
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$2(KafkaControllerTest $this) {
        return $this.kafkaController().eventManager().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$3() {
        return "Request was not handled.";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$4(ObjectRef requestError$1) {
        return ((Option)requestError$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterLeadershipPriorityWhenDemotingBeyondLimit$5() {
        return "Request callback not called, or did not have error.";
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulExclusionResult$1(int expectedBrokerId$1, BrokerReplicaExclusionResult p) {
        return p.brokerId() == expectedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(KafkaControllerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$3(KafkaControllerTest $this, MetricsRegistry metricsRegistry$2, String metricSimpleName$2, AtomicReference lastSeenValue$2, String expectedValue$2) {
        String value = (String)((Gauge)$this.metric(metricsRegistry$2, metricSimpleName$2)).value();
        lastSeenValue$2.set(value);
        String string = expectedValue$2;
        return !(string != null ? !string.equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$4(String metricSimpleName$2, String expectedValue$2, AtomicReference lastSeenValue$2) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$2).append(" to be ").append(expectedValue$2).append(" but instead was ").append(lastSeenValue$2.get()).toString();
    }

    public KafkaControllerTest() {
        this.initialBrokerEpoch = 0L;
        this.epochZkVersion = 0;
    }
}

