/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.controller.Block$;
import kafka.controller.Continue$;
import kafka.controller.ContinueMerged$;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0003BB\u0013\u0001A\u0003%!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u00039\u0001\u0011\u0005q\u0005C\u0003;\u0001\u0011\u0005q\u0005C\u0003=\u0001\u0011\u0005q\u0005C\u0003?\u0001\u0011\u0005q\u0005C\u0003A\u0001\u0011\u0005q\u0005C\u0003C\u0001\u0011\u0005q\u0005C\u0003E\u0001\u0011\u0005q\u0005C\u0003G\u0001\u0011\u0005q\u0005C\u0003G\u0001\u0011\u0005\u0001\nC\u0003O\u0001\u0011\u0005qJ\u0001\u000bTi>\u0004(+\u001a9mS\u000e\f')\u0019;dQR+7\u000f\u001e\u0006\u0003#I\t!bY8oiJ|G\u000e\\3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0011\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002EA\u0011qdI\u0005\u0003IA\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002'Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\\:\u0015\u0003!\u0002\"aF\u0015\n\u0005)B\"\u0001B+oSRD#\u0001\u0002\u0017\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014aA1qS*\u0011\u0011GM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019D'A\u0003kk:LGOC\u00016\u0003\ry'oZ\u0005\u0003o9\u0012A\u0001V3ti\u0006qA/Z:u\u0003\u0012$Gk\u001c9jG&#\u0007FA\u0003-\u0003U!Xm\u001d;BI\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D#A\u0002\u0017\u00029Q,7\u000f^%om\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>t7\u000b^1uK\"\u0012q\u0001L\u0001 i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8oV5uQN#x\u000e\u001d*fa2L7-\u0019\"bi\u000eD\u0007F\u0001\u0005-\u0003\u0001\"Xm\u001d;Qe>\u001cWm]:XSRDG*Z1eKJ\fe\u000eZ%te\n\u000bGo\u00195)\u0005%a\u0013A\t;fgR\u0004&o\\2fgN<\u0016\u000e\u001e5Va\u0012\fG/Z'fi\u0006$\u0017\r^1CCR\u001c\u0007\u000e\u000b\u0002\u000bY\u0005\u0011C/Z:u!J|7-Z:t/&$\b.\u00138d_:\u001c\u0018n\u001d;f]R$v\u000e]5d\u0013\u0012D#a\u0003\u0017\u0002#Q,7\u000f\u001e\"vS2$'+Z9vKN$8\u000f\u000b\u0002\rYQ\u0011\u0001&\u0013\u0005\u0006\u00156\u0001\raS\u0001\bm\u0016\u00148/[8o!\t9B*\u0003\u0002N1\t)1\u000b[8si\u0006\u0011R.Y6f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\u00016\u000e\u001d:\u0011\u0005ECgB\u0001*f\u001d\t\u0019&M\u0004\u0002U?:\u0011Q+\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014B\u0001/5\u0003\u0019\t\u0007/Y2iK&\u00111C\u0018\u0006\u00039RJ!\u0001Y1\u0002\r\r|W.\\8o\u0015\t\u0019b,\u0003\u0002dI\u00069Q.Z:tC\u001e,'B\u00011b\u0013\t1w-\u0001\fTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$H)\u0019;b\u0015\t\u0019G-\u0003\u0002jU\nI2\u000b^8q%\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\t1w\rC\u0003m\u001d\u0001\u0007Q.\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=\u0011\u0005]q\u0017BA8\u0019\u0005\rIe\u000e\u001e\u0005\u0006c:\u0001\r!\\\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0003t\u001d\u0001\u0007A/A\beK2,G/\u001a)beRLG/[8o!\t9R/\u0003\u0002w1\t9!i\\8mK\u0006t\u0007")
public class StopReplicaBatchTest {
    private final StateChangeLogger stateChangeLogger = new StateChangeLogger(0, true, (Option)None$.MODULE$);

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    @Test
    public void testBasicOperations() {
        StopReplicaBatch batch = new StopReplicaBatch(0);
        Assertions.assertEquals((short)ApiKeys.STOP_REPLICA.latestVersion(), (short)batch.version());
        Assertions.assertEquals((int)0, (int)batch.controllerId());
        Assertions.assertEquals((int)0, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)0L, (long)batch.brokerEpoch());
        Assertions.assertTrue((boolean)batch.partitions().isEmpty());
        Assertions.assertTrue((boolean)batch.isEmpty());
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        StopReplicaRequestData.StopReplicaPartitionState tpState = new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setLeaderEpoch(1).setDeletePartition(true);
        batch.setVersion(ApiKeys.STOP_REPLICA.oldestVersion()).setControllerId(1).setControllerEpoch(2).setBrokerEpoch(3L).addPartitionState(tp, tpState).addTopicId(tp.topic(), topicId);
        Assertions.assertEquals((short)ApiKeys.STOP_REPLICA.oldestVersion(), (short)batch.version());
        Assertions.assertEquals((int)1, (int)batch.controllerId());
        Assertions.assertEquals((int)2, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)3L, (long)batch.brokerEpoch());
        Assertions.assertFalse((boolean)batch.partitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)tpState)})), (Object)batch.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicId)})), (Object)batch.topicIds());
        Assertions.assertFalse((boolean)batch.isEmpty());
    }

    @Test
    public void testAddTopicId() {
        StopReplicaBatch batch = new StopReplicaBatch(0);
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        String topic = "topic";
        batch.addTopicId(topic, topicId0);
        batch.addTopicId(topic, topicId0);
        Assertions.assertThrows(IllegalStateException.class, () -> batch.addTopicId(topic, topicId1));
    }

    @Test
    public void testAddPartitionState() {
        StopReplicaBatch batch = new StopReplicaBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(0, 0, false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.addPartitionState(tp, this.makePartitionState(0, 0, true));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertTrue((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.addPartitionState(tp, this.makePartitionState(0, 0, false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertTrue((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.addPartitionState(tp, this.makePartitionState(0, 1, false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.addPartitionState(tp, this.makePartitionState(0, 0, false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.addPartitionState(tp, this.makePartitionState(0, LeaderAndIsr$.MODULE$.EpochDuringDelete(), false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)LeaderAndIsr$.MODULE$.EpochDuringDelete(), (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
    }

    @Test
    public void testInvalidatePartitionState() {
        StopReplicaBatch batch = new StopReplicaBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(0, 5, false));
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.maybeInvalidatePartitionState(tp, 4);
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.maybeInvalidatePartitionState(tp, 5);
        Assertions.assertEquals((int)0, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).partitionIndex());
        Assertions.assertEquals((int)5, (int)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        Assertions.assertFalse((boolean)((StopReplicaRequestData.StopReplicaPartitionState)batch.partitions().apply((Object)tp)).deletePartition());
        batch.maybeInvalidatePartitionState(tp, 6);
        Assertions.assertNull((Object)batch.partitions().get((Object)tp).orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testProcessWithStopReplicaBatch() {
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        StopReplicaBatch batch1 = new StopReplicaBatch(0).setVersion((short)(ApiKeys.STOP_REPLICA.latestVersion() - 1)).setControllerId(0).setControllerEpoch(0).setBrokerEpoch(0L).addPartitionState(tp0, this.makePartitionState(0, 1, false)).addTopicId(tp0.topic(), topicId0);
        StopReplicaBatch batch2 = new StopReplicaBatch(0).setVersion(ApiKeys.STOP_REPLICA.latestVersion()).setControllerId(1).setControllerEpoch(1).setBrokerEpoch(1L).addPartitionState(tp0, this.makePartitionState(0, 2, true)).addPartitionState(tp1, this.makePartitionState(1, 1, false)).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1);
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertEquals((short)ApiKeys.STOP_REPLICA.latestVersion(), (short)batch1.version());
        Assertions.assertEquals((int)1, (int)batch1.controllerId());
        Assertions.assertEquals((int)1, (int)batch1.controllerEpoch());
        Assertions.assertEquals((long)1L, (long)batch1.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(0, 2, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(1, 1, false))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)batch1.topicIds());
    }

    @Test
    public void testProcessWithLeaderAndIsrBatch() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        StopReplicaBatch stopReplicaBatch = new StopReplicaBatch(0).addPartitionState(tp0, this.makePartitionState(0, 2, true)).addPartitionState(tp1, this.makePartitionState(1, 3, false));
        LeaderAndIsrBatch leaderAndIsrBatch = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(3));
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)stopReplicaBatch.process((ControlMetadataBatch)leaderAndIsrBatch));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(1, 3, false))})), (Object)stopReplicaBatch.partitions());
    }

    @Test
    public void testProcessWithUpdateMetadataBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new StopReplicaBatch(0).process((ControlMetadataBatch)new UpdateMetadataBatch(0)));
    }

    @Test
    public void testProcessWithInconsistentTopicId() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid())));
    }

    @Test
    public void testBuildRequests() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.STOP_REPLICA.oldestVersion()), (int)ApiKeys.STOP_REPLICA.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> this.testBuildRequests((short)version));
    }

    public void testBuildRequests(short version) {
        int controllerId = 0;
        int controllerEpoch = 1;
        int brokerEpoch = 2;
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        StopReplicaRequestData.StopReplicaPartitionState state0 = this.makePartitionState(0, 2, true);
        StopReplicaRequestData.StopReplicaPartitionState state1 = this.makePartitionState(1, 3, false);
        Seq requests = new StopReplicaBatch(0).setVersion(version).setControllerId(controllerId).setControllerEpoch(controllerEpoch).setBrokerEpoch((long)brokerEpoch).addPartitionState(tp0, state0).addPartitionState(tp1, state1).requests(this.stateChangeLogger());
        if (version >= 3) {
            Assertions.assertEquals((int)1, (int)requests.size());
            StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)((AbstractRequest.Builder)requests.head()).build();
            Assertions.assertEquals((short)version, (short)stopReplicaRequest.version());
            Assertions.assertEquals((int)controllerId, (int)stopReplicaRequest.controllerId());
            Assertions.assertEquals((int)controllerEpoch, (int)stopReplicaRequest.controllerEpoch());
            Assertions.assertEquals((long)brokerEpoch, (long)stopReplicaRequest.brokerEpoch());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)state0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)state1)})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaRequest.partitionStates()).asScala());
            return;
        }
        Assertions.assertEquals((int)2, (int)requests.size());
        StopReplicaRequest stopReplicaRequestWithDelete = (StopReplicaRequest)((AbstractRequest.Builder)requests.apply(0)).build();
        Assertions.assertEquals((short)version, (short)stopReplicaRequestWithDelete.version());
        Assertions.assertEquals((int)controllerId, (int)stopReplicaRequestWithDelete.controllerId());
        Assertions.assertEquals((int)controllerEpoch, (int)stopReplicaRequestWithDelete.controllerEpoch());
        Assertions.assertEquals((long)brokerEpoch, (long)stopReplicaRequestWithDelete.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(0, -1, true))})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaRequestWithDelete.partitionStates()).asScala());
        StopReplicaRequest stopReplicaRequestWithoutDelete = (StopReplicaRequest)((AbstractRequest.Builder)requests.apply(1)).build();
        Assertions.assertEquals((short)version, (short)stopReplicaRequestWithoutDelete.version());
        Assertions.assertEquals((int)controllerId, (int)stopReplicaRequestWithoutDelete.controllerId());
        Assertions.assertEquals((int)controllerEpoch, (int)stopReplicaRequestWithoutDelete.controllerEpoch());
        Assertions.assertEquals((long)brokerEpoch, (long)stopReplicaRequestWithoutDelete.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(1, -1, false))})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaRequestWithoutDelete.partitionStates()).asScala());
    }

    public StopReplicaRequestData.StopReplicaPartitionState makePartitionState(int partitionIndex, int leaderEpoch, boolean deletePartition) {
        return new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(partitionIndex).setLeaderEpoch(leaderEpoch).setDeletePartition(deletePartition);
    }
}

