/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorTest;
import kafka.log.AppendOrigin;
import kafka.server.Defaults$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001\u0002\u0007\u000e\u0001QAQ!\u0007\u0001\u0005\u0002iAq\u0001\b\u0001C\u0002\u0013\u0005S\u0004\u0003\u0004%\u0001\u0001\u0006IA\b\u0005\u0006K\u0001!\tA\n\u0005\u0006o\u0001!\tA\n\u0005\u0006s\u0001!\tA\n\u0005\u0006w\u0001!\tA\n\u0005\u0006{\u0001!IA\u0010\u0005\u0006K\u0002!IA\u001a\u0005\n\u00033\u0001\u0011\u0013!C\u0005\u00037Aq!!\r\u0001\t\u0013\t\u0019DA\u0012He>,\boQ8pe\u0012Lg.\u0019;pe\n\u000bGo\u00195j]\u001e|eMZ:fiN$Vm\u001d;\u000b\u00059y\u0011!B4s_V\u0004(B\u0001\t\u0012\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u0015\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003U)g.\u00192mK>3gm]3ug\n\u000bGo\u00195j]\u001e,\u0012A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b\u0005>|G.Z1o\u0003Y)g.\u00192mK>3gm]3ug\n\u000bGo\u00195j]\u001e\u0004\u0013A\b;fgR\u001cu.\\7ji>3gm]3ug&s7+\u001b8hY\u0016\u0014\u0015\r^2i)\u00059\u0003CA\u0010)\u0013\tI\u0003E\u0001\u0003V]&$\bF\u0001\u0003,!\taS'D\u0001.\u0015\tqs&A\u0002ba&T!\u0001M\u0019\u0002\u000f),\b/\u001b;fe*\u0011!gM\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002i\u0005\u0019qN]4\n\u0005Yj#\u0001\u0002+fgR\f1\u0005^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;t\u000fJ,\u0017\r^3s)\"\fg.T:h'&TX\r\u000b\u0002\u0006W\u0005\tD/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:Nk2$\u0018\u000e\u001d7f\u000fJ|W\u000f]:B]\u0012lU\u000f\u001c;ja2,')\u0019;dQ\u0016\u001c\bF\u0001\u0004,\u0003\t\"Xm\u001d;D_6l\u0017\u000e^(gMN,Go]#yG\u0016\u0004H/[8o%\u0016\u001cwN^3ss\"\u0012qaK\u0001\u001cm\u0006d\u0017\u000eZ1uK>3gm]3u\u0007>lW.\u001b;GkR,(/Z:\u0015\t\u001dz\u0014+\u0018\u0005\u0006\u0001\"\u0001\r!Q\u0001\u0014G>lW.\u001b;PM\u001a\u001cX\r\u001e$viV\u0014Xm\u001d\t\u0004\u0005\u0016;U\"A\"\u000b\u0005\u0011\u0003\u0013AC2pY2,7\r^5p]&\u0011ai\u0011\u0002\u0004'\u0016\f\bc\u0001%L\u001b6\t\u0011J\u0003\u0002KA\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00051K%A\u0002$viV\u0014X\r\u0005\u0002O\u001f6\t\u0001!\u0003\u0002Q/\tQ2i\\7nSR|eMZ:fi\u000e\u000bG\u000e\u001c2bG.\u0004\u0016M]1ng\")!\u000b\u0003a\u0001'\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0002C\u000bR\u0003\"!V.\u000e\u0003YS!a\u0016-\u0002\r\r|W.\\8o\u0015\t\u0011\u0012L\u0003\u0002[g\u00051\u0011\r]1dQ\u0016L!\u0001\u0018,\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")a\f\u0003a\u0001?\u0006)QM\u001d:peB\u0011\u0001mY\u0007\u0002C*\u0011!MV\u0001\taJ|Go\\2pY&\u0011A-\u0019\u0002\u0007\u000bJ\u0014xN]:\u0002%\r|W.\\5u\u001f\u001a47/\u001a;t\u0005\u0006$8\r\u001b\u000b\tO*<\b0!\u0002\u0002\u0010A\u0019q\u0004[$\n\u0005%\u0004#!B!se\u0006L\b\"B6\n\u0001\u0004a\u0017aB4s_V\u0004\u0018\n\u001a\t\u0003[Rt!A\u001c:\u0011\u0005=\u0004S\"\u00019\u000b\u0005E\u001c\u0012A\u0002\u001fs_>$h(\u0003\u0002tA\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019\b\u0005C\u0003S\u0013\u0001\u00071\u000bC\u0003z\u0013\u0001\u0007!0A\tok6\u001cu.\\7jiJ+\u0017/^3tiN\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\u0011a\u0017M\\4\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001?\u0003\u000f%sG/Z4fe\"9\u0011qA\u0005A\u0002\u0005%\u0011aC8gMN,Go\u0015;beR\u00042aHA\u0006\u0013\r\ti\u0001\t\u0002\u0005\u0019>tw\rC\u0005\u0002\u0012%\u0001\n\u00111\u0001\u0002\u0014\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007cA\u0010\u0002\u0016%\u0019\u0011q\u0003\u0011\u0003\u0007%sG/\u0001\u000fd_6l\u0017\u000e^(gMN,Go\u001d\"bi\u000eDG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u!\u0006BA\n\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W\u0001\u0013AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013G>lW.\u001b;PM\u001a\u001cX\r^:Bgft7\rF\u0007H\u0003k\t9$a\u000f\u0002@\u0005M\u0013Q\f\u0005\u0006W.\u0001\r\u0001\u001c\u0005\u0007\u0003sY\u0001\u0019\u00017\u0002\u00115,WNY3s\u0013\u0012Dq!!\u0010\f\u0001\u0004\t\u0019\"\u0001\u0007hK:,'/\u0019;j_:LE\rC\u0004\u0002B-\u0001\r!a\u0011\u0002\u000f=4gm]3ugB1Q.!\u0012U\u0003\u0013J1!a\u0012w\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0017\ny%\u0004\u0002\u0002N)\u0011q+E\u0005\u0005\u0003#\niEA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006Dq!!\u0016\f\u0001\u0004\t9&A\bhe>,\b/\u00138ti\u0006t7-Z%e!\u0011y\u0012\u0011\f7\n\u0007\u0005m\u0003E\u0001\u0004PaRLwN\u001c\u0005\b\u0003#Y\u0001\u0019AA\n\u0001")
public class GroupCoordinatorBatchingOffsetsTest
extends GroupCoordinatorTest {
    private final boolean enableOffsetsBatching;

    @Override
    public boolean enableOffsetsBatching() {
        return this.enableOffsetsBatching;
    }

    @Test
    public void testCommitOffsetsInSingleBatch() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 15;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tIter -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pIter -> topicPartitions.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(new StringBuilder(5).append("topic").append(tIter).toString(), pIter)}))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        this.groupCoordinator().shutdownOffsetCommitThreads();
        Future<scala.collection.immutable.Map<TopicPartition, Errors>>[] commitOffsetFutures = this.commitOffsetsBatch(this.groupId(), (Seq<TopicPartition>)topicPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, this.commitOffsetsBatch$default$5());
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)commitRequests, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commitOffsetFutures)).size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>>)Predef$.MODULE$.wrapRefArray((Object[])commitOffsetFutures), (Seq<TopicPartition>)topicPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
        IntRef expectedOffset = IntRef.create((int)baseOffset);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsInSingleBatch$3(this, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCommitOffsetsGreaterThanMsgSize() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 15;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int maxMessageSize = 1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tIter -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pIter -> topicPartitions.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(new StringBuilder(5).append("topic").append(tIter).toString(), pIter)}))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        this.groupCoordinator().shutdownOffsetCommitThreads();
        Future<scala.collection.immutable.Map<TopicPartition, Errors>>[] commitOffsetFutures = this.commitOffsetsBatch(this.groupId(), (Seq<TopicPartition>)topicPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, maxMessageSize);
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)commitRequests, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commitOffsetFutures)).size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>>)Predef$.MODULE$.wrapRefArray((Object[])commitOffsetFutures), (Seq<TopicPartition>)topicPartitions, Errors.INVALID_COMMIT_OFFSET_SIZE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
    }

    @Test
    public void testCommitOffsetsMultipleGroupsAndMultipleBatches() {
        int topics = 3;
        .colon.colon groupIds = new .colon.colon((Object)this.groupId(), (List)new .colon.colon((Object)this.otherGroupId(), (List)Nil$.MODULE$));
        int partitions = 20;
        int commitRequests = 30;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int maxMessageSize = 10000;
        ArrayBuffer commitOffsetFutures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int otherGroupPartitionId = this.groupCoordinator().partitionFor(this.otherGroupId());
        this.groupCoordinator().groupManager().addPartitionOwnership(otherGroupPartitionId);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__consumer_offsets", otherGroupPartitionId))).thenReturn((Object)new Some((Object)this.logConfig()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tIter -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pIter -> topicPartitions.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(new StringBuilder(5).append("topic").append(tIter).toString(), pIter)}))));
        groupIds.foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$3(this, groupId);
            return BoxedUnit.UNIT;
        });
        this.groupCoordinator().shutdownOffsetCommitThreads();
        groupIds.foreach((Function1 & Serializable & scala.Serializable)groupId -> commitOffsetFutures.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.commitOffsetsBatch((String)groupId, (Seq<TopicPartition>)topicPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, maxMessageSize)))));
        this.groupCoordinator().startupOffsetCommitThreads(Predef$.MODULE$.int2Integer(this.numOffsetCommitThreads()));
        Assertions.assertEquals((int)(commitRequests * groupIds.size()), (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>>)commitOffsetFutures, (Seq<TopicPartition>)topicPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeast((int)(groupIds.size() * 2)))).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)groupIds.size()))).getMagicFromConfig(this.logConfig());
        groupIds.foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$5(this, baseOffset, topicPartitions, groupId);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCommitOffsetsExceptionRecovery() {
        int topics = 1;
        int partitions = 20;
        int commitRequests = 1;
        int baseOffset = 31;
        ArrayBuffer topicPartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tIter -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pIter -> topicPartitions.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(new StringBuilder(5).append("topic").append(tIter).toString(), pIter)}))));
        GroupCoordinator qual$1 = this.groupCoordinator();
        String x$1 = this.groupId();
        boolean x$2 = this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(x$1, x$2, x$3));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__consumer_offsets", this.groupPartitionId()))).thenThrow(new Throwable[]{new RuntimeException("Test exception")}).thenReturn((Object)new Some((Object)this.logConfig()));
        WrappedArray commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicPartition>)topicPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, this.commitOffsetsBatch$default$5()));
        Assertions.assertEquals((int)commitRequests, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>>)commitOffsetFutures, (Seq<TopicPartition>)topicPartitions, Errors.UNKNOWN_SERVER_ERROR);
        commitOffsetFutures = Predef$.MODULE$.wrapRefArray((Object[])this.commitOffsetsBatch(this.groupId(), (Seq<TopicPartition>)topicPartitions, Predef$.MODULE$.int2Integer(commitRequests), baseOffset, this.commitOffsetsBatch$default$5()));
        Assertions.assertEquals((int)commitRequests, (int)commitOffsetFutures.size());
        this.validateOffsetCommitFutures((Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>>)commitOffsetFutures, (Seq<TopicPartition>)topicPartitions, Errors.NONE);
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getMagicFromConfig(this.logConfig());
        IntRef expectedOffset = IntRef.create((int)baseOffset);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsExceptionRecovery$3(this, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void validateOffsetCommitFutures(Seq<Future<scala.collection.immutable.Map<TopicPartition, Errors>>> commitOffsetFutures, Seq<TopicPartition> topicPartitions, Errors error) {
        commitOffsetFutures.foreach((Function1 & Serializable & scala.Serializable)futureResult -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$validateOffsetCommitFutures$1(topicPartitions, error, futureResult);
            return BoxedUnit.UNIT;
        });
    }

    private Future<scala.collection.immutable.Map<TopicPartition, Errors>>[] commitOffsetsBatch(String groupId, Seq<TopicPartition> topicPartitions, Integer numCommitRequests, long offsetStart, int maxMessageSize) {
        ArrayBuffer commitOffsetFuturesList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef offsetIter = LongRef.create((long)offsetStart);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), Predef$.MODULE$.Integer2int(numCommitRequests)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            scala.collection.mutable.Map offsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
                GroupCoordinatorBatchingOffsetsTest.$anonfun$commitOffsetsBatch$2(this, offsetIter, offsets, tp);
                return BoxedUnit.UNIT;
            });
            commitOffsetFuturesList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{this.commitOffsetsAsync(groupId, "", -1, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets.toMap(Predef$.MODULE$.$conforms()), (Option<String>)None$.MODULE$, maxMessageSize)}));
        });
        return (Future[])commitOffsetFuturesList.toArray(ClassTag$.MODULE$.apply(Future.class));
    }

    private int commitOffsetsBatch$default$5() {
        return Defaults$.MODULE$.MessageMaxBytes();
    }

    /*
     * WARNING - void declaration
     */
    private Future<scala.collection.immutable.Map<TopicPartition, Errors>> commitOffsetsAsync(String groupId, String memberId, int generationId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Option<String> groupInstanceId, int maxMessageSize) {
        void var9_9;
        void var8_8;
        Tuple2<Future<scala.collection.immutable.Map<TopicPartition, Errors>>, Function1<scala.collection.immutable.Map<TopicPartition, Errors>, BoxedUnit>> tuple2 = this.setupCommitOffsetsCallback();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Future responseFuture = (Future)tuple2._1();
        Function1 responseCallback = (Function1)tuple2._2();
        void responseFuture2 = var8_8;
        void responseCallback2 = var9_9;
        ArgumentCaptor capturedRecords = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)capturedRecords.capture(), (Function1)capturedCallback.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$commitOffsetsAsync$1(capturedCallback, capturedRecords, x$5);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)BoxesRunTime.boxToByte((byte)this.replicaManager().getMagicFromConfig(this.logConfig()))).thenReturn((Object)BoxesRunTime.boxToByte((byte)1));
        Mockito.when((Object)this.logConfig().maxMessageSize()).thenReturn((Object)Predef$.MODULE$.int2Integer(maxMessageSize));
        GroupCoordinator qual$1 = this.groupCoordinator();
        RequestLocal x$7 = qual$1.handleCommitOffsets$default$7();
        qual$1.handleCommitOffsets(groupId, memberId, groupInstanceId, generationId, offsets, (Function1)responseCallback2, x$7);
        return responseFuture2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsInSingleBatch$3(GroupCoordinatorBatchingOffsetsTest $this, IntRef expectedOffset$1, TopicPartition tp) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets($this.groupId(), $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        void error2 = var4_4;
        void partitionData2 = var5_5;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)partitionData2.get((Object)tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$1.elem, (long)offset.offset);
        ++expectedOffset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$3(GroupCoordinatorBatchingOffsetsTest $this, String groupId) {
        GroupCoordinator qual$1 = $this.groupCoordinator();
        boolean x$2 = $this.requireStable();
        Option x$3 = qual$1.handleFetchOffsets$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().empty()), (Object)qual$1.handleFetchOffsets(groupId, x$2, x$3));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$6(GroupCoordinatorBatchingOffsetsTest $this, String groupId$1, IntRef expectedOffset$2, TopicPartition tp) {
        void var6_6;
        void var5_5;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets(groupId$1, $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        void error2 = var5_5;
        void partitionData2 = var6_6;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)partitionData2.get((Object)tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$2.elem, (long)offset.offset);
        ++expectedOffset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$5(GroupCoordinatorBatchingOffsetsTest $this, int baseOffset$1, ArrayBuffer topicPartitions$3, String groupId) {
        IntRef expectedOffset = IntRef.create((int)baseOffset$1);
        topicPartitions$3.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$testCommitOffsetsMultipleGroupsAndMultipleBatches$6($this, groupId, expectedOffset, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCommitOffsetsExceptionRecovery$3(GroupCoordinatorBatchingOffsetsTest $this, IntRef expectedOffset$3, TopicPartition tp) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = $this.groupCoordinator().handleFetchOffsets($this.groupId(), $this.requireStable(), (Option)new Some((Object)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map partitionData = (Map)tuple2._2();
        void error2 = var4_4;
        void partitionData2 = var5_5;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2);
        OffsetFetchResponse.PartitionData offset = (OffsetFetchResponse.PartitionData)partitionData2.get((Object)tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(29).append("Offset should be present for ").append(tp).toString());
        });
        Assertions.assertEquals((long)expectedOffset$3.elem, (long)offset.offset);
        ++expectedOffset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$validateOffsetCommitFutures$2(Errors error$1, scala.collection.immutable.Map commitOffsetResult$1, TopicPartition tp) {
        Assertions.assertEquals((Object)error$1, (Object)commitOffsetResult$1.apply((Object)tp));
    }

    public static final /* synthetic */ void $anonfun$validateOffsetCommitFutures$1(Seq topicPartitions$5, Errors error$1, Future futureResult) {
        scala.collection.immutable.Map commitOffsetResult = (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)futureResult, (Duration)Duration$.MODULE$.apply(15000L, TimeUnit.MILLISECONDS));
        topicPartitions$5.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            GroupCoordinatorBatchingOffsetsTest.$anonfun$validateOffsetCommitFutures$2(error$1, commitOffsetResult, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)topicPartitions$5.size(), (int)commitOffsetResult.size());
    }

    public static final /* synthetic */ void $anonfun$commitOffsetsBatch$2(GroupCoordinatorBatchingOffsetsTest $this, LongRef offsetIter$1, scala.collection.mutable.Map offsets$1, TopicPartition tp) {
        OffsetAndMetadata offset = $this.offsetAndMetadata(offsetIter$1.elem);
        offsets$1.update((Object)tp, (Object)offset);
        ++offsetIter$1.elem;
    }

    public static final /* synthetic */ void $anonfun$commitOffsetsAsync$1(ArgumentCaptor capturedCallback$1, ArgumentCaptor capturedRecords$1, InvocationOnMock x$5) {
        ((Function1)capturedCallback$1.getValue()).apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", ((TopicPartition)((Tuple2)((TraversableOnce)capturedRecords$1.getValue()).toList().head())._1()).partition())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
    }

    public GroupCoordinatorBatchingOffsetsTest() {
        this.enableOffsetsBatching = true;
    }
}

