/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u001b7\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002IC\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0001.\t\u0013\u0001\u0004\u0001\u0019!A!B\u0013\u0019\u0006\"C1\u0001\u0001\u0004\u0005\r\u0011\"\u0001c\u0011%1\u0007\u00011AA\u0002\u0013\u0005q\rC\u0005j\u0001\u0001\u0007\t\u0011)Q\u0005G\"I!\u000e\u0001a\u0001\u0002\u0004%\ta\u001b\u0005\ns\u0002\u0001\r\u00111A\u0005\u0002iD\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015\u00027\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bbCA\u000b\u0001\u0001\u0007\t\u0019!C\u0001\u0003/A!\"a\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0000\u0011-\ti\u0002\u0001a\u0001\u0002\u0004%\t!a\b\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\u0006\u0005\f\u0003[\u0001\u0001\u0019!A!B\u0013\t\t\u0003C\u0006\u00020\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0002bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0001\u0003wA1\"a\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024!I\u0011\u0011\t\u0001C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002F!I\u0011Q\n\u0001C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002F!I\u0011\u0011\u000b\u0001C\u0002\u0013\u0005\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002V!I\u0011Q\f\u0001C\u0002\u0013\u0005\u00111\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002V!I\u0011\u0011\r\u0001C\u0002\u0013\u0005\u00111\r\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002f!I\u0011Q\u000e\u0001C\u0002\u0013\u0005\u00111\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002f!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u00111\u000f\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002v!I\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u00111\u000f\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002v!I\u0011Q\u0012\u0001C\u0002\u0013\u0005\u00111\u000f\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002v!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAV\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003k\u0003A\u0011AAJ\u0011\u001d\tI\f\u0001C\u0001\u0003'Cq!!0\u0001\t\u0003\t\u0019\nC\u0004\u0002B\u0002!\t!a%\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005M\u0005bBAg\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003#\u0004A\u0011AAJ\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002~\u0002!I!a@\u0003)E+x\u000e^1D_>\u0014H-\u001b8bi>\u0014H+Z:u\u0015\t9\u0004(A\u0003rk>$\u0018M\u0003\u0002:u\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005Y\u0014!B6bM.\f7\u0001A\n\u0003\u0001y\u0002\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001G!\t9\u0005!D\u00017\u0003\u0019\u0019wN\u001c4jOV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002Nu\u000511/\u001a:wKJL!a\u0014'\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0003M\u0003\"\u0001V,\u000e\u0003US!A\u0016\u001e\u0002\u000bU$\u0018\u000e\\:\n\u0005a+&\u0001C'pG.$\u0016.\\3\u0002\u0011QLW.Z0%KF$\"a\u00170\u0011\u0005}b\u0016BA/A\u0005\u0011)f.\u001b;\t\u000f}+\u0011\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002\u000bQLW.\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#A2\u0011\u0005Q#\u0017BA3V\u00055iunY6TG\",G-\u001e7fe\u0006i1o\u00195fIVdWM]0%KF$\"a\u00175\t\u000f}C\u0011\u0011!a\u0001G\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002+%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5feV\tA\u000eE\u0002niZl\u0011A\u001c\u0006\u0003_B\f\u0001BZ;oGRLwN\u001c\u0006\u0003cJ\fA!\u001e;jY*\t1/\u0001\u0003kCZ\f\u0017BA;o\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bCA&x\u0013\tAHJA\u0007J]R,'O\\1m\u0003\u0012l\u0017N\\\u0001\u001aS:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0002\\w\"9qlCA\u0001\u0002\u0004a\u0017AF5oi\u0016\u0014h.\u00197BI6LgnU;qa2LWM\u001d\u0011\u00023\rdWo\u001d;fe2+g/\u001a7Rk>$\u0018mQ1mY\n\f7m[\u000b\u0002\u007fB!\u0011\u0011AA\t\u001b\t\t\u0019AC\u00028\u0003\u000bQ1!TA\u0004\u0015\rY\u0014\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001f\t1a\u001c:h\u0013\u0011\t\u0019\"a\u0001\u00033\rcWo\u001d;fe2+g/\u001a7Rk>$\u0018mQ1mY\n\f7m[\u0001\u001eG2,8\u000f^3s\u0019\u00164X\r\\)v_R\f7)\u00197mE\u0006\u001c7n\u0018\u0013fcR\u00191,!\u0007\t\u000f}s\u0011\u0011!a\u0001\u007f\u0006Q2\r\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2lA\u0005\t\u0012/^8uCN#\u0018\r^3NC:\fw-\u001a:\u0016\u0005\u0005\u0005\u0002cA$\u0002$%\u0019\u0011Q\u0005\u001c\u0003#E+x\u000e^1Ti\u0006$X-T1oC\u001e,'/A\u000brk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0007m\u000bY\u0003\u0003\u0005`#\u0005\u0005\t\u0019AA\u0011\u0003I\tXo\u001c;b'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002!E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014XCAA\u001a!\r9\u0015QG\u0005\u0004\u0003o1$\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0003Q\tXo\u001c;b\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR\u00191,!\u0010\t\u0011}#\u0012\u0011!a\u0001\u0003g\t\u0011#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:!\u0003\r)\u0005kU\u000b\u0003\u0003\u000b\u00022aPA$\u0013\r\tI\u0005\u0011\u0002\u0007\t>,(\r\\3\u0002\t\u0015\u00036\u000bI\u0001\u0017G2,8\u000f^3s)\"\u0014x.^4iaV$\u0018+^8uC\u000692\r\\;ti\u0016\u0014H\u000b\u001b:pk\u001eD\u0007/\u001e;Rk>$\u0018\rI\u0001\u0014EJ|7.\u001a:MS6LG\u000f\u0015:pIV\u001cWM]\u000b\u0003\u0003+\u00022aPA,\u0013\r\tI\u0006\u0011\u0002\u0004\u0013:$\u0018\u0001\u00062s_.,'\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\b%A\nce>\\WM\u001d'j[&$8i\u001c8tk6,'/\u0001\u000bce>\\WM\u001d'j[&$8i\u001c8tk6,'\u000fI\u0001\bK:$\u0018\u000e^=2+\t\t)\u0007E\u0002H\u0003OJ1!!\u001b7\u0005-\tVo\u001c;b\u000b:$\u0018\u000e^=\u0002\u0011\u0015tG/\u001b;zc\u0001\nq!\u001a8uSRL('\u0001\u0005f]RLG/\u001f\u001a!\u0003e)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM\u001d\u0019\u0016\u0005\u0005U\u0004CBA<\u0003{\n\t)\u0004\u0002\u0002z)\u0019\u00111\u0010!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0005e$aA*fcB\u0019q)a!\n\u0007\u0005\u0015eG\u0001\u000eRk>$\u0018-\u00128uSRL\u0018I\u001c3D_:\u001cX/\u001c9uS>t7/\u0001\u000ef]RLG/_\"p]N,X\u000e\u001d;j_:\u001c(I]8lKJ\u0004\u0004%A\rf]RLG/_\"p]N,X\u000e\u001d;j_:\u001c(I]8lKJ\f\u0014AG3oi&$\u0018pQ8ogVl\u0007\u000f^5p]N\u0014%o\\6feF\u0002\u0013!G3oi&$\u0018pQ8ogVl\u0007\u000f^5p]N\u0014%o\\6feJ\n!$\u001a8uSRL8i\u001c8tk6\u0004H/[8og\n\u0013xn[3se\u0001\nQa]3u+B$\u0012a\u0017\u0015\u0004Q\u0005]\u0005\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u0004CBL'\u0002BAQ\u0003G\u000bqA[;qSR,'O\u0003\u0003\u0002&\u00065\u0011!\u00026v]&$\u0018\u0002BAU\u00037\u0013!BQ3g_J,W)Y2i\u0003\u0011\"Xm\u001d;D_6\u0004X\u000f^3Rk>$\u0018m]%oC\u000e$\u0018N^3D_>\u0014H-\u001b8bi>\u0014\bfA\u0015\u00020B!\u0011\u0011TAY\u0013\u0011\t\u0019,a'\u0003\tQ+7\u000f^\u0001&i\u0016\u001cHoQ8naV$X-U;pi\u0006\u001c\u0018J\u001c<bY&$\u0017+^8uC\u0016sG/\u001b;jKND3AKAX\u0003\u0015\"Xm\u001d;EKN\u001c'/\u001b2f#V|G/Y:J]\u0006\u001cG/\u001b<f\u0007>|'\u000fZ5oCR|'\u000fK\u0002,\u0003_\u000bA\u0005^3ti\u0012+7o\u0019:jE\u0016\fVo\u001c;bg\u0016sG/\u001b;z\t>,7OT8u\u000bbL7\u000f\u001e\u0015\u0004Y\u0005=\u0016a\u000b;fgR\u001cu.\u001c9vi\u0016\fe\u000e\u001a#fg\u000e\u0014\u0018NY3Rk>$\u0018m],ji\"\u001c\u0015\r\u001d9fIF+x\u000e^1)\u00075\ny+\u0001\u0018uKN$8i\\7qkR,\u0017I\u001c3EKN\u001c'/\u001b2f#V|G/Y:V]\u00164XM\u001c#jgR\u0014\u0018NY;uS>t\u0007f\u0001\u0018\u00020\u0006IC/Z:u\u0007>l\u0007/\u001e;f\u0003:$G)Z:de&\u0014W-U;pi\u0006\u001cx\u000b[3o)\"\u0014x\u000e\u001e;mK\u0012D3aLAX\u0003i!Xm\u001d;FqBL'/Z)v_R\f7i\u001c8tk6\u0004H/[8oQ\r\u0001\u0014qV\u0001\u0017i\u0016\u001cH/\u00117m5\u0016\u0014xnQ8ogVl\u0007\u000f^5p]\"\u001a\u0011'a,\u0002+\r|W\u000e];uKF+x\u000e^1t\u0007\u0006dGNY1dWR\u00191,!7\t\u000f\u0005m'\u00071\u0001\u0002^\u00061!/Z:vYR\u00042aRAp\u0013\r\t\tO\u000e\u0002\u0012%\u0016\u0004xN\u001d;Rk>$\u0018MU3tk2$\u0018a\u0003<fe&4\u00170U;pi\u0006$\u0012bWAt\u0003W\fy/!?\t\u000f\u0005%8\u00071\u0001\u0002V\u00051!M]8lKJDq!!<4\u0001\u0004\t)'A\u0006rk>$\u0018-\u00128uSRL\bbBAyg\u0001\u0007\u00111_\u0001\ncV|G/\u0019+za\u0016\u0004B!!\u0001\u0002v&!\u0011q_A\u0002\u0005=\u0019E.[3oiF+x\u000e^1UsB,\u0007bBA~g\u0001\u0007\u0011QI\u0001\u000eKb\u0004Xm\u0019;fIF+x\u000e^1\u00023\u001d,G/U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:D_:4\u0017n\u001a\u000b\u0005\u0005\u0003\u00119\u0001E\u0002H\u0005\u0007I1A!\u00027\u0005Y\tVo\u001c;b\u0007>|'\u000fZ5oCR|'oQ8oM&<\u0007\"\u0002%5\u0001\u0004Q\u0005")
public class QuotaCoordinatorTest {
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private MockTime time;
    private MockScheduler scheduler;
    private Supplier<InternalAdmin> internalAdminSupplier;
    private ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private QuotaStateManager quotaStateManager;
    private QuotaCoordinator quotaCoordinator;
    private final double EPS;
    private final double clusterThroughputQuota;
    private final int brokerLimitProducer;
    private final int brokerLimitConsumer;
    private final QuotaEntity entity1 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
    private final QuotaEntity entity2 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant2")})));
    private final Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 400.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 300.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 5000.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);

    public KafkaConfig config() {
        return this.config;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(MockScheduler x$1) {
        this.scheduler = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public void internalAdminSupplier_$eq(Supplier<InternalAdmin> x$1) {
        this.internalAdminSupplier = x$1;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public void clusterLevelQuotaCallback_$eq(ClusterLevelQuotaCallback x$1) {
        this.clusterLevelQuotaCallback = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public double EPS() {
        return this.EPS;
    }

    public double clusterThroughputQuota() {
        return this.clusterThroughputQuota;
    }

    public int brokerLimitProducer() {
        return this.brokerLimitProducer;
    }

    public int brokerLimitConsumer() {
        return this.brokerLimitConsumer;
    }

    public QuotaEntity entity1() {
        return this.entity1;
    }

    public QuotaEntity entity2() {
        return this.entity2;
    }

    public Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0() {
        return this.entityConsumptionsBroker0;
    }

    public Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1() {
        return this.entityConsumptionsBroker1;
    }

    public Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2() {
        return this.entityConsumptionsBroker2;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq(new MockTime());
        this.scheduler_$eq(new MockScheduler((Time)this.time()));
        InternalAdmin internalAdmin = (InternalAdmin)EasyMock.createNiceMock(InternalAdmin.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)EasyMock.eq((Object)"_confluent-quotas"), EasyMock.anyInt(), EasyMock.anyShort(), (Properties)EasyMock.anyObject(Properties.class)))).andReturn((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.config().confluentConfig().quotasTopicPartitions()))).anyTimes();
        this.internalAdminSupplier_$eq(() -> internalAdmin);
        this.clusterLevelQuotaCallback_$eq((ClusterLevelQuotaCallback)EasyMock.createNiceMock(ClusterLevelQuotaCallback.class));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().clusterQuotaLimit((ClientQuotaType)EasyMock.anyObject(ClientQuotaType.class), (java.util.Map)EasyMock.anyObject(java.util.Map.class))).andReturn((Object)Predef$.MODULE$.double2Double(this.clusterThroughputQuota())).anyTimes();
        QuotaCoordinatorConfig quotaCoordinatorConfig = this.getQuotaCoordinatorConfig(this.config());
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getMagic((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)2)))).anyTimes();
        this.quotaStateManager_$eq(new QuotaStateManager(quotaCoordinatorConfig, (Scheduler)this.scheduler(), replicaManager, new Metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 50, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity2()));
        EasyMock.replay((Object[])new Object[]{internalAdmin, this.clusterLevelQuotaCallback(), replicaManager});
        this.quotaCoordinator_$eq(new QuotaCoordinator(this.config().brokerId(), quotaCoordinatorConfig, this.quotaStateManager(), (Scheduler)this.scheduler(), this.internalAdminSupplier(), this.clusterLevelQuotaCallback(), (Time)this.time()));
    }

    @Test
    public void testComputeQuotasInactiveCoordinator() {
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable & scala.Serializable)result -> {
            this.callback$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testComputeQuotasInvalidQuotaEntities() {
        this.quotaStateManager().removeOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addLoadingPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable & scala.Serializable)result -> {
            this.callback$2(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasInactiveCoordinator() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        void error2 = var2_2;
        void quotaDescription2 = var3_3;
        Assertions.assertEquals((Object)error2, (Object)Errors.COORDINATOR_NOT_AVAILABLE, (String)new StringBuilder(24).append("Got error ").append(error2).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)quotaDescription2, (String)new StringBuilder(32).append("Got non-empty quota description ").append(quotaDescription2).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasEntityDoesNotExist() {
        void var3_3;
        void var2_2;
        this.quotaCoordinator().isActive().set(true);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        void error2 = var2_2;
        void quotaDescription2 = var3_3;
        Assertions.assertEquals((Object)error2, (Object)Errors.QUOTA_ENTITY_NOT_FOUND, (String)new StringBuilder(24).append("Got error ").append(error2).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)quotaDescription2, (String)new StringBuilder(32).append("Got non-empty quota description ").append(quotaDescription2).toString());
    }

    @Test
    public void testComputeAndDescribeQuotasWithCappedQuota() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
    }

    @Test
    public void testComputeAndDescribeQuotasUnevenDistribution() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumptionBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumptionBroker0, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumptionBroker1, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 150.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionBroker2, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2800.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4200.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
    }

    @Test
    public void testComputeAndDescribeQuotasWhenThrottled() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionThrottled = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionThrottled, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        double broker2Quota = (double)12000 * (1.1 / 3.1);
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, broker2Quota);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaConsumption() {
        void var4_4;
        void var3_3;
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        void error2 = var3_3;
        void quotaDescription2 = var4_4;
        Assertions.assertEquals((Object)error2, (Object)Errors.NONE, (String)new StringBuilder(10).append("Got error ").append(error2).toString());
        Assertions.assertFalse((boolean)quotaDescription2.brokerQuotas().contains((Object)BoxesRunTime.boxToInteger((int)2)));
    }

    @Test
    public void testAllZeroConsumption() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon zeroConsumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 0.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        this.quotaCoordinator().computeQuotas(0, (Iterable)zeroConsumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)zeroConsumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)zeroConsumption, (Function1 & Serializable & scala.Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
    }

    private void computeQuotasCallback(ReportQuotaResult result) {
        result.entityErrors().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            QuotaCoordinatorTest.$anonfun$computeQuotasCallback$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyQuota(int broker, QuotaEntity quotaEntity, ClientQuotaType quotaType, double expectedQuota) {
        void var8_7;
        void var7_6;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        void error2 = var7_6;
        double computedQuota = BoxesRunTime.unboxToDouble((Object)((MapLike)var8_7.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)broker), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Object)quotaType.toString(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2, (String)new StringBuilder(40).append("Got error ").append(error2).append(" when describing quota entity ").append(quotaEntity).toString());
        Assertions.assertEquals((double)expectedQuota, (double)computedQuota, (double)this.EPS(), (String)new StringBuilder(53).append("Got quota ").append(computedQuota).append(" on broker ").append(broker).append(" for quota entity ").append(quotaEntity).append(" but expected ").append(expectedQuota).toString());
    }

    private QuotaCoordinatorConfig getQuotaCoordinatorConfig(KafkaConfig config) {
        return new QuotaCoordinatorConfig(Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions()), Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize()), config.confluentConfig().quotasTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs()), config.confluentConfig().quotasTopicPlacementConstraints(), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs()), Predef$.MODULE$.Integer2int(config.confluentConfig().quotasConsumptionExpirationTimeMs()), (long)this.brokerLimitProducer(), (long)this.brokerLimitConsumer(), QuotaCoordinatorConfig$.MODULE$.apply$default$13());
    }

    public static final /* synthetic */ void $anonfun$testComputeQuotasInactiveCoordinator$1(ReportQuotaResult result$1, QuotaEntityAndConsumptions entityAndConsumption) {
        Option option = result$1.entityErrors().get((Object)entityAndConsumption.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)error, (String)new StringBuilder(42).append("Got error ").append(error).append(" for quota entity ").append(entityAndConsumption.entity()).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(36).append("Did not get status for quota entity ").append(entityAndConsumption.entity()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void callback$1(ReportQuotaResult result) {
        this.entityConsumptionsBroker0().foreach((Function1 & Serializable & scala.Serializable)entityAndConsumption -> {
            QuotaCoordinatorTest.$anonfun$testComputeQuotasInactiveCoordinator$1(result, entityAndConsumption);
            return BoxedUnit.UNIT;
        });
    }

    private final void callback$2(ReportQuotaResult result) {
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)result.entityErrors().apply((Object)this.entity1()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity1())).append(" but expected ").append(Errors.COORDINATOR_LOAD_IN_PROGRESS).toString());
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)result.entityErrors().apply((Object)this.entity2()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity2())).append(" but expected ").append(Errors.NOT_COORDINATOR).toString());
    }

    public static final /* synthetic */ void $anonfun$computeQuotasCallback$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            QuotaEntity quotaEntity = (QuotaEntity)x0$1._1();
            Errors error = (Errors)x0$1._2();
            Assertions.assertEquals((Object)Errors.NONE, (Object)error, (String)new StringBuilder(49).append("Got error ").append(error).append(" when reporting usage for quota entity ").append(quotaEntity).toString());
            return;
        }
        throw new MatchError(null);
    }

    public QuotaCoordinatorTest() {
        this.EPS = 1.0E-4;
        this.clusterThroughputQuota = 12000.0;
        this.brokerLimitProducer = 5000;
        this.brokerLimitConsumer = 5000;
    }
}

