/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.util.Collections;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.MetricNames$;
import kafka.utils.MockTime;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4AAF\f\u00019!)1\u0005\u0001C\u0001I!Iq\u0005\u0001a\u0001\u0002\u0004%I\u0001\u000b\u0005\nm\u0001\u0001\r\u00111A\u0005\n]B\u0011\"\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0015\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0013y\u0004\"C#\u0001\u0001\u0004\u0005\r\u0011\"\u0003G\u0011%A\u0005\u00011A\u0001B\u0003&\u0001\tC\u0005J\u0001\u0001\u0007\t\u0019!C\u0005\u0015\"Ia\n\u0001a\u0001\u0002\u0004%Ia\u0014\u0005\n#\u0002\u0001\r\u0011!Q!\n-C\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011B*\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0006\"C.\u0001\u0001\u0004\u0005\t\u0015)\u0003U\u0011%a\u0006\u00011AA\u0002\u0013%Q\fC\u0005b\u0001\u0001\u0007\t\u0019!C\u0005E\"IA\r\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006e\u0002!\tA\u001a\u0005\u0006o\u0002!\tA\u001a\u0005\u0006s\u0002!\tA\u001a\u0005\u0006w\u0002!\tA\u001a\u0002\u001d\tV\u0014\u0018MY5mSRLX*\u001a;sS\u000e\u001cX*\u00198bO\u0016\u0014H+Z:u\u0015\tA\u0012$\u0001\u0006ekJ\f'-\u001b7jifT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003]\tA\u0001^5nKV\t\u0011\u0006\u0005\u0002+i5\t1F\u0003\u0002-[\u0005)Q\u000f^5mg*\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005i\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!N\u0016\u0003\tQKW.Z\u0001\ti&lWm\u0018\u0013fcR\u0011\u0001h\u000f\t\u0003=eJ!AO\u0010\u0003\tUs\u0017\u000e\u001e\u0005\by\r\t\t\u00111\u0001*\u0003\rAH%M\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005\u0001\u0005CA!D\u001b\u0005\u0011%B\u0001 .\u0013\t!%IA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003q\u001dCq\u0001\u0010\u0004\u0002\u0002\u0003\u0007\u0001)\u0001\u0005nKR\u0014\u0018nY:!\u0003\tiW.F\u0001L!\t1C*\u0003\u0002N/\tAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\r5lw\fJ3r)\tA\u0004\u000bC\u0004=\u0013\u0005\u0005\t\u0019A&\u0002\u00075l\u0007%\u0001\u0002uaV\tA\u000b\u0005\u0002V-6\tQ&\u0003\u0002X[\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0002;q?\u0012*\u0017\u000f\u0006\u000295\"9A\bDA\u0001\u0002\u0004!\u0016a\u0001;qA\u00059Bo\u001c;bY2{7\u000f^'fgN\fw-Z:NKR\u0014\u0018nY\u000b\u0002=B\u0011QkX\u0005\u0003A6\u0012!\"T3ue&\u001cg*Y7f\u0003m!x\u000e^1m\u0019>\u001cH/T3tg\u0006<Wm]'fiJL7m\u0018\u0013fcR\u0011\u0001h\u0019\u0005\by=\t\t\u00111\u0001_\u0003a!x\u000e^1m\u0019>\u001cH/T3tg\u0006<Wm]'fiJL7\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002q!\u0012\u0011\u0003\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f1!\u00199j\u0015\tig.A\u0004kkBLG/\u001a:\u000b\u0005=\u0014\u0014!\u00026v]&$\u0018BA9k\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001#'V\u00147)\u0019;fO>\u0014\u0018\u0010T8ti6+7o]1hKNlU\r\u001e:jGN$Vm\u001d;)\u0005I!\bCA5v\u0013\t1(N\u0001\u0003UKN$\u0018aC'fiJL7m\u001d+fgRD#a\u0005;\u0002-5+GO]5dg\u0016C\bo\\:f\t\u0016d\u0017-\u001f+fgRD#\u0001\u0006;\u0002-5+GO]5dg\"+\u0017\r\u001c;i\u0007\",7m\u001b+fgRD#!\u0006;")
public class DurabilityMetricsManagerTest {
    private Time time;
    private Metrics metrics;
    private DurabilityMetricsManager mm;
    private TopicPartition tp;
    private MetricName totalLostMessagesMetric;

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private DurabilityMetricsManager mm() {
        return this.mm;
    }

    private void mm_$eq(DurabilityMetricsManager x$1) {
        this.mm = x$1;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private void tp_$eq(TopicPartition x$1) {
        this.tp = x$1;
    }

    private MetricName totalLostMessagesMetric() {
        return this.totalLostMessagesMetric;
    }

    private void totalLostMessagesMetric_$eq(MetricName x$1) {
        this.totalLostMessagesMetric = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), this.time()));
        this.mm_$eq(DurabilityMetricsManager$.MODULE$.apply("0", this.metrics(), this.time(), DurabilityMetricsManager$.MODULE$.apply$default$4()));
        this.tp_$eq(new TopicPartition("test", 0));
        this.totalLostMessagesMetric_$eq(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalLostMessages(), this.metrics()));
    }

    @Test
    public void SubCategoryLostMessagesMetricsTest() {
        MetricName hwMetrics = DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics());
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 15L);
        Assertions.assertEquals((long)this.mm().totalLostMessages(), (long)15L, (String)"Variable totalLostMessages not set to 15");
        Assertions.assertEquals((long)((DurabilityMetricsManager.LostMessage)this.mm().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.HighWatermark())).count(), (long)15L, (String)"Variable highWatermarkLostMessages not set to 15");
        Assertions.assertEquals((Object)this.metrics().metric(hwMetrics).metricValue(), (Object)BoxesRunTime.boxToLong((long)15L), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(10);
        this.mm().totalLostMessages_$eq(0L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 1L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.StartOffset(), 10L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.EpochChange(), 100L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.NonCustomerFacing(), 1000L);
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.StartOffset().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)10L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.EpochChange().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)100L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L));
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1111L));
        Assertions.assertEquals((int)2, (int)DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().size(), (String)"Tag count for 'high_watermark_lost_messages' metrics is not 2");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_run_counter"), (Object)"10", (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_run_counter' with a value of '10'");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_lapse_type"), (Object)DurabilityLapseType$.MODULE$.HighWatermark().toString(), (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_lapse_type' with a value of 'HighWatermark'");
    }

    @Test
    public void MetricsTest() {
        Assertions.assertEquals((int)17, (int)this.metrics().metrics().size(), (String)"Expected metrics count is not 17");
        Predef$.MODULE$.println(this.metrics().metrics().keySet());
        Assertions.assertEquals((int)0, (int)DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", this.metrics()).tags().size(), (String)"Metrics 'total_lost_messages' should not have any tags");
        this.mm().reportDurabilityLoss(15L);
        Assertions.assertEquals((long)15L, (long)this.mm().totalLostMessages(), (String)"Variable totalLostMessages not set to 15");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().reportDurabilityLoss(20L);
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 1L / 4L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 15, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 3L / 4L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)35L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 35, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(5);
        Assertions.assertEquals((int)(13 + this.mm().externalLostMessageMetricsMap().size()), (int)this.metrics().metrics().size(), (String)new StringBuilder(32).append("Total registered metrics is not ").append(13 + this.mm().externalLostMessageMetricsMap().size()).toString());
        Assertions.assertEquals((int)1, (int)DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalMessages(), this.metrics()).tags().size(), (String)"Tag count for 'total_messages' metrics is not 1");
        Assertions.assertEquals((int)2, (int)DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.ExternalLostMessages(), this.metrics()).tags().size(), (String)"Tag count for 'external_lost_messages' metrics is not 2");
        this.mm().updateStats(this.tp(), new DurabilityStats(1000L, 50L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' should not be updated before job completion");
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(10);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1000L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' is not 1000");
        this.mm().resetDurabilityRunSpan(15);
        this.mm().updateStats(this.tp(), new DurabilityStats(2000L, 25L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' has not reset to 0");
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(30);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2000L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' is not 2000 after job completion.");
    }

    @Test
    public void MetricsExposeDelayTest() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 0, same as totalLostMessages");
        this.mm().reportDurabilityLoss(10L);
        this.mm().reportDurabilityLoss(20L);
        this.mm().reportDurabilityLoss(30L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 0, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)60L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 60, same as totalLostMessages");
    }

    @Test
    public void MetricsHealthCheckTest() {
        String brokerId2 = "2";
        String brokerId3 = "3";
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DurabilityMetricsManagerTest.filterHCMetrics$1(this.metrics()))).isEmpty());
        long t0 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId2, t0);
        KafkaMetric hcMetrics = this.metrics().metric(DurabilityMetricsManagerTest.filterHCMetrics$1(this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(5L);
        long t1 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId3, t1);
        hcMetrics = this.metrics().metric(DurabilityMetricsManagerTest.filterHCMetrics$1(this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(10L);
        long t2 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId3, t2);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
        this.mm().updateHealthCheck(brokerId2, t2);
        this.mm().updateHealthCheck(brokerId3, t1);
        hcMetrics = this.metrics().metric(DurabilityMetricsManagerTest.filterHCMetrics$1(this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        hcMetrics = this.metrics().metric(DurabilityMetricsManagerTest.filterHCMetrics$1(this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
    }

    public static final /* synthetic */ boolean $anonfun$MetricsHealthCheckTest$2(MetricName x$2) {
        return x$2.name().equals(MetricNames$.MODULE$.HealthCheck());
    }

    private static final MetricName[] filterHCMetrics$1(Metrics metrics) {
        return (MetricName[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> (MetricName)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MetricName.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityMetricsManagerTest.$anonfun$MetricsHealthCheckTest$2(x$2)));
    }
}

