/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditJobResult;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.UploadCompleteEvent;
import kafka.durability.utils.UploadInitiateEvent;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B&M\u0001MCQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001A\u0002\u0013\u0005q\fC\u0004i\u0001\u0001\u0007I\u0011A5\t\r=\u0004\u0001\u0015)\u0003a\u0011\u001d\u0001\b\u00011A\u0005\u0002EDq\u0001\u001f\u0001A\u0002\u0013\u0005\u0011\u0010\u0003\u0004|\u0001\u0001\u0006KA\u001d\u0005\ny\u0002\u0001\r\u00111A\u0005\u0002uD1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f!Q\u0011q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u0013\u0005E\u0001\u00011A\u0005\u0002\u0005M\u0001\"CA\u000e\u0001\u0001\u0007I\u0011AA\u000f\u0011!\t\t\u0003\u0001Q!\n\u0005U\u0001\"CA\u0012\u0001\u0001\u0007I\u0011AA\u0013\u0011%\t)\u0006\u0001a\u0001\n\u0003\t9\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0015BA\u0014\u0011%\ti\u0006\u0001a\u0001\n\u0003\ty\u0006C\u0005\u0002p\u0001\u0001\r\u0011\"\u0001\u0002r!A\u0011Q\u000f\u0001!B\u0013\t\t\u0007C\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002z!I\u00111\u0012\u0001A\u0002\u0013\u0005\u0011Q\u0012\u0005\t\u0003#\u0003\u0001\u0015)\u0003\u0002|!I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002\u0018\"Y\u0011q\u0014\u0001A\u0002\u0003\u0007I\u0011AAQ\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%\t!a,\t\u0017\u0005M\u0006\u00011A\u0001B\u0003&\u00111\u0015\u0005\f\u0003k\u0003\u0001\u0019!a\u0001\n\u0003\t9\fC\u0006\u0002@\u0002\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0007bCAc\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sC1\"a2\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002J\"Y\u00111\u001b\u0001A\u0002\u0003\u0007I\u0011AAk\u0011-\tI\u000e\u0001a\u0001\u0002\u0003\u0006K!a3\t\u0013\u0005m\u0007A1A\u0005\u0002\u0005u\u0007\u0002CA\u0000\u0001\u0001\u0006I!a8\t\u0013\t\u0005\u0001A1A\u0005\u0002\t\r\u0001\u0002\u0003B\u000b\u0001\u0001\u0006IA!\u0002\t\u0017\t]\u0001\u00011AA\u0002\u0013\u0005!\u0011\u0004\u0005\f\u00057\u0001\u0001\u0019!a\u0001\n\u0003\u0011i\u0002C\u0006\u0003\"\u0001\u0001\r\u0011!Q!\n\u0005}\u0002\"\u0003B\u0012\u0001\u0001\u0007I\u0011\u0001B\u0013\u0011%\u00119\u0003\u0001a\u0001\n\u0003\u0011I\u0003\u0003\u0005\u0003.\u0001\u0001\u000b\u0015BA5\u0011%\u0011y\u0003\u0001a\u0001\n\u0003\u0011\t\u0004C\u0005\u0003>\u0001\u0001\r\u0011\"\u0001\u0003@!A!1\t\u0001!B\u0013\u0011\u0019\u0004C\u0005\u0003F\u0001\u0001\r\u0011\"\u0001\u0003H!I!q\n\u0001A\u0002\u0013\u0005!\u0011\u000b\u0005\t\u0005+\u0002\u0001\u0015)\u0003\u0003J!9!q\u000b\u0001\u0005\u0002\te\u0003b\u0002B9\u0001\u0011\u0005!\u0011\f\u0005\b\u0005w\u0002A\u0011\u0001B-\u0011\u001d\u0011)\t\u0001C\u0001\u00053BqA!#\u0001\t\u0003\u0011I\u0006C\u0004\u0003\u000e\u0002!IAa$\t\u000f\tE\u0006\u0001\"\u0001\u0003Z!9!Q\u0017\u0001\u0005\u0002\te\u0003b\u0002B]\u0001\u0011\u0005!\u0011\f\u0005\b\u0005{\u0003A\u0011\u0001B-\u0011\u001d\u0011\t\r\u0001C\u0001\u00053BqA!2\u0001\t\u0003\u0011I\u0006C\u0004\u0003J\u0002!\tA!\u0017\t\u000f\t5\u0007\u0001\"\u0001\u0003Z!9!\u0011\u001b\u0001\u0005\u0002\te\u0003b\u0002Bk\u0001\u0011\u0005!\u0011\f\u0005\b\u00053\u0004A\u0011\u0001B-\u0011\u001d\u0011i\u000e\u0001C\u0001\u00053BqA!9\u0001\t\u0003\u0011I\u0006C\u0004\u0003f\u0002!\tA!\u0017\t\u000f\t%\b\u0001\"\u0001\u0003Z!9!Q\u001e\u0001\u0005\u0002\te\u0003b\u0002By\u0001\u0011\u0005!\u0011\f\u0005\b\u0005k\u0004A\u0011\u0001B-\u0011\u001d\u0011I\u0010\u0001C\u0001\u00053\u0012A\"Q;eSRTuN\u0019+fgRT!!\u0014(\u0002\u000b\u0005,H-\u001b;\u000b\u0005=\u0003\u0016A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t\u0011+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029B\u0011Q\fA\u0007\u0002\u0019\u00061An\\4ESJ,\u0012\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f!![8\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$\"A[7\u0011\u0005U[\u0017B\u00017W\u0005\u0011)f.\u001b;\t\u000f9\u001c\u0011\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e)\u0002\u00071|w-\u0003\u0002xi\nQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0011!N\u001f\u0005\b]\u001a\t\t\u00111\u0001s\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\tQLW.Z\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002!\u0006)Q\u000f^5mg&!\u0011qAA\u0001\u0005!iunY6US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0007)\fi\u0001C\u0004o\u0013\u0005\u0005\t\u0019\u0001@\u0002\u000bQLW.\u001a\u0011\u0002\u0011\u0005,H-\u001b;K_\n,\"!!\u0006\u0011\u0007u\u000b9\"C\u0002\u0002\u001a1\u0013\u0001\"Q;eSRTuNY\u0001\rCV$\u0017\u000e\u001e&pE~#S-\u001d\u000b\u0004U\u0006}\u0001\u0002\u00038\r\u0003\u0003\u0005\r!!\u0006\u0002\u0013\u0005,H-\u001b;K_\n\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005\u001d\u0002CBA\u0015\u0003s\tyD\u0004\u0003\u0002,\u0005Ub\u0002BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\"+\u0001\u0004=e>|GOP\u0005\u0002/&\u0019\u0011q\u0007,\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0003o1\u0006\u0003BA!\u0003#j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0007G>lWn\u001c8\u000b\u0007E\u000bIE\u0003\u0003\u0002L\u00055\u0013AB1qC\u000eDWM\u0003\u0002\u0002P\u0005\u0019qN]4\n\t\u0005M\u00131\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003M!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\rQ\u0017\u0011\f\u0005\t]>\t\t\u00111\u0001\u0002(\u0005\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\u000fa\u0006\u0014H/\u001b;j_:$V\u000f\u001d7f+\t\t\t\u0007\u0005\u0004\u0002*\u0005e\u00121\r\t\b+\u0006\u0015\u0014qHA5\u0013\r\t9G\u0016\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007U\u000bY'C\u0002\u0002nY\u0013A\u0001T8oO\u0006\u0011\u0002/\u0019:uSRLwN\u001c+va2,w\fJ3r)\rQ\u00171\u000f\u0005\t]J\t\t\u00111\u0001\u0002b\u0005y\u0001/\u0019:uSRLwN\u001c+va2,\u0007%\u0001\u0005pE*\u001cFo\u001c:f+\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u000bM$xN]3\u000b\u0007\u0005\u0015\u0005+\u0001\u0003uS\u0016\u0014\u0018\u0002BAE\u0003\u007f\u0012q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\r_\nT7\u000b^8sK~#S-\u001d\u000b\u0004U\u0006=\u0005\u0002\u00038\u0016\u0003\u0003\u0005\r!a\u001f\u0002\u0013=\u0014'n\u0015;pe\u0016\u0004\u0013!\u00026pE&#WCAAL!\r)\u0016\u0011T\u0005\u0004\u000373&aA%oi\u00061!n\u001c2JI\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002$B!\u0011QUAU\u001b\t\t9K\u0003\u0003\u0002 \u0006\r\u0013\u0002BAV\u0003O\u0013q!T3ue&\u001c7/A\u0006nKR\u0014\u0018nY:`I\u0015\fHc\u00016\u00022\"AaNGA\u0001\u0002\u0004\t\u0019+\u0001\u0005nKR\u0014\u0018nY:!\u00039\u0019\u0018.\u001c9mKJ+\u0007o\u001c:uKJ,\"!!/\u0011\u0007u\u000bY,C\u0002\u0002>2\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018AE:j[BdWMU3q_J$XM]0%KF$2A[Ab\u0011!qW$!AA\u0002\u0005e\u0016aD:j[BdWMU3q_J$XM\u001d\u0011\u0002'\u0011,(/\u00192jY&$\u00180T3ue&\u001cWj\u001a:\u0016\u0005\u0005-\u0007\u0003BAg\u0003\u001fl\u0011AT\u0005\u0004\u0003#t%\u0001\u0007#ve\u0006\u0014\u0017\u000e\\5us6+GO]5dg6\u000bg.Y4fe\u00069B-\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY'he~#S-\u001d\u000b\u0004U\u0006]\u0007\u0002\u00038!\u0003\u0003\u0005\r!a3\u0002)\u0011,(/\u00192jY&$\u00180T3ue&\u001cWj\u001a:!\u00035\tW\u000fZ5ug\u0006cGn\\<fIV\u0011\u0011q\u001c\t\u0007\u0003C\fY/a<\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005%h+\u0001\u0006d_2dWm\u0019;j_:LA!!<\u0002d\n\u00191+\u001a;\u0011\t\u0005E\u0018q\u001f\b\u0004;\u0006M\u0018bAA{\u0019\u0006!B)\u001e:bE&d\u0017\u000e^=Bk\u0012LGo\u00115fG.LA!!?\u0002|\n)a+\u00197vK&\u0019\u0011Q ,\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u000fCV$\u0017\u000e^:BY2|w/\u001a3!\u00035\tG\u000e\\8xK\u0012,e/\u001a8ugV\u0011!Q\u0001\t\u0007\u0003C\fYOa\u0002\u0011\t\t%\u0011q\u001f\b\u0005\u0005\u0017\u0011\t\"\u0004\u0002\u0003\u000e)\u0019!q\u0002(\u0002\r\u00154XM\u001c;t\u0013\u0011\u0011\u0019B!\u0004\u0002'\u0011+(/\u00192jY&$\u00180\u0012<f]R$\u0016\u0010]3\u0002\u001d\u0005dGn\\<fI\u00163XM\u001c;tA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA \u0003I!x\u000e]5d!\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0007)\u0014y\u0002\u0003\u0005oO\u0005\u0005\t\u0019AA \u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00033c\u0007>tg-[4\u0016\u0005\u0005%\u0014\u0001\u00043c\u0007>tg-[4`I\u0015\fHc\u00016\u0003,!AaNKA\u0001\u0002\u0004\tI'A\u0005eE\u000e{gNZ5hA\u0005\u0011AMY\u000b\u0003\u0005g\u0001BA!\u000e\u0003:5\u0011!q\u0007\u0006\u0004\u0005_q\u0015\u0002\u0002B\u001e\u0005o\u0011A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001\u001a2`I\u0015\fHc\u00016\u0003B!Aa.LA\u0001\u0002\u0004\u0011\u0019$A\u0002eE\u0002\n1\"Y;eSR\u001cuN\u001c4jOV\u0011!\u0011\n\t\u0004;\n-\u0013b\u0001B'\u0019\n)B)\u001e:bE&d\u0017\u000e^=Bk\u0012LGoQ8oM&<\u0017aD1vI&$8i\u001c8gS\u001e|F%Z9\u0015\u0007)\u0014\u0019\u0006\u0003\u0005oa\u0005\u0005\t\u0019\u0001B%\u00031\tW\u000fZ5u\u0007>tg-[4!\u0003\u0015\u0019X\r^+q)\u0005Q\u0007f\u0001\u001a\u0003^A!!q\fB7\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014aA1qS*!!q\rB5\u0003\u001dQW\u000f]5uKJTAAa\u001b\u0002N\u0005)!.\u001e8ji&!!q\u000eB1\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a1G!\u001e\u0011\t\t}#qO\u0005\u0005\u0005s\u0012\tGA\u0005BMR,'/R1dQ\u0006!B/Z:u'&l\u0007\u000f\\3PM\u001a\u001cX\r^*dC:D3\u0001\u000eB@!\u0011\u0011yF!!\n\t\t\r%\u0011\r\u0002\u0005)\u0016\u001cH/\u0001\u0018uKN$8+[7qY\u0016|eMZ:fiN\u001b\u0017M\\,ji\"|e/\u001a:mCB<\u0016\u000e\u001e5US\u0016\u0014\bk\u001c:uS>t\u0007fA\u001b\u0003\u0000\u0005QB/Z:u'&l\u0007\u000f\\3US\u0016\u0014X\rZ(gMN,GoU2b]\"\u001aaGa \u0002)%t\u0017\u000e^5bY&TX\rT8h\u001b\u0006t\u0017mZ3s)\u0011\u0011\tJ!,\u0011\r\tM%Q\u0014BQ\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015\u0001C:uk\n\u0014\u0017N\\4\u000b\t\tm\u0015QJ\u0001\b[>\u001c7.\u001b;p\u0013\u0011\u0011yJ!&\u0003\u001f=swm\\5oON#XO\u00192j]\u001e\u0004R!\u0016BR\u0005OK1A!*W\u0005\u0019y\u0005\u000f^5p]B\u00191O!+\n\u0007\t-FOA\u0006BEN$(/Y2u\u0019><\u0007b\u0002BXo\u0001\u0007!qU\u0001\u0005[2{w-\u0001\u000euKN$xJ\u00196fGR\u001cFo\u001c:f'\u0016<W.\u001a8u\u0019>\u001c8\u000fK\u00029\u0005\u007f\n1\u0004^3tiRKWM]\"p[B\f7\r^3e\u001f\nTWm\u0019;M_N\u001c\bfA\u001d\u0003\u0000\u0005yB/Z:u)&,'oQ8na\u0006\u001cG/\u001a3U_BL7MV1mS\u0012\fG/Z:)\u0007i\u0012y(A\u0010uKN$X*[:tS:<7+Z4nK:$\u0018J\\(cU\u0016\u001cGo\u0015;pe\u0016D3a\u000fB@\u0003u!Xm\u001d;MC\u001e<\u0017N\\4US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007f\u0001\u001f\u0003\u0000\u0005yA/Z:u\u000b:$Gk\\#oIJ+h\u000eK\u0002>\u0005\u007f\n1\u0005^3ti>3gm]3u\u000f\u0006\u0004()\u001a;xK\u0016tG+[3s\u0003:$Gj\\2bY2{w\rK\u0002?\u0005\u007f\n\u0001\u0004^3tiRKWM](gMN,GoR1q%\u0016$(/[3tQ\ry$qP\u0001\u0017i\u0016\u001cHOT8o\u00032LwM\\3e'\u0016<W.\u001a8ug\"\u001a\u0001Ia \u00027Q,7\u000f^\"p[B\f7\r^3e)>\u0004\u0018nY%t\u0003Z|\u0017\u000eZ3eQ\r\t%qP\u0001\"i\u0016\u001cHoQ8na\u0006\u001cG/\u001a3U_BL7m\u00115b]\u001e,G\rV8EK2,G/\u001a\u0015\u0004\u0005\n}\u0014!\t;fgRd\u0015\r^2i\u0007>,h\u000e\u001e3po:$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007fA\"\u0003\u0000\u0005)C/Z:u\u0003V$\u0017\u000e\u001e&pENcW-\u001a9t\r>\u0014H+[3s-\u0016\u0014\u0018NZ5dCRLwN\u001c\u0015\u0004\t\n}\u0014\u0001\u000b;fgR$\u0016.\u001a:M_\u001e\u001cVmZ7f]R\u001cuN\u001c<feNLwN\u001c$peZ\u000bG.\u001b3bi>\u0014\bfA#\u0003\u0000\u00059B/Z:u\u0007\",7m[:v[\u0012K7/\u00192mKR+7\u000f\u001e\u0015\u0004\r\n}\u0014\u0001\u0005;fgR\u001c\u0016N_3NSNl\u0017\r^2iQ\r9%qP\u0001\u001fi\u0016\u001cHoU5na2,7i\\7qC\u000e$\u0018n\u001c8WC2LG-\u0019;j_:D3\u0001\u0013B@\u0003!\"Xm\u001d;TS6\u0004H.Z\"p[B\f7\r^5p]Z\u000bG.\u001b3bi&|gnX*dK:\f'/[82Q\rI%qP\u0001\u001fi\u0016\u001cH/T5tg&twmU3h[\u0016tG/\u00138D_6\u0004\u0018m\u0019;j_:D3A\u0013B@\u0001")
public class AuditJobTest {
    private File logDir = null;
    private LogManager logManager = null;
    private MockTime time;
    private AuditJob auditJob = null;
    private Seq<TopicPartition> topicPartitions = Nil$.MODULE$;
    private Seq<Tuple2<TopicPartition, Object>> partitionTuple = Nil$.MODULE$;
    private TierObjectStore objStore = null;
    private final int jobId;
    private Metrics metrics;
    private AuditReporter simpleReporter;
    private DurabilityMetricsManager durabilityMetricMgr;
    private final Set<Enumeration.Value> auditsAllowed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    private final Set<Enumeration.Value> allowedEvents = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityEventType$.MODULE$.DeleteRecordsType(), DurabilityEventType$.MODULE$.IsrExpandType(), DurabilityEventType$.MODULE$.EpochChangeType(), DurabilityEventType$.MODULE$.RetentionChangeType(), DurabilityEventType$.MODULE$.StartOffsetChangeType(), DurabilityEventType$.MODULE$.OffsetChangeType(), DurabilityEventType$.MODULE$.DeletePartitionType(), DurabilityEventType$.MODULE$.HealthCheckType()}));
    private TopicPartition topicPartition;
    private long dbConfig = 0L;
    private DurabilityDB db = null;
    private DurabilityAuditConfig auditConfig = null;

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public AuditJob auditJob() {
        return this.auditJob;
    }

    public void auditJob_$eq(AuditJob x$1) {
        this.auditJob = x$1;
    }

    public Seq<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(Seq<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public Seq<Tuple2<TopicPartition, Object>> partitionTuple() {
        return this.partitionTuple;
    }

    public void partitionTuple_$eq(Seq<Tuple2<TopicPartition, Object>> x$1) {
        this.partitionTuple = x$1;
    }

    public TierObjectStore objStore() {
        return this.objStore;
    }

    public void objStore_$eq(TierObjectStore x$1) {
        this.objStore = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter simpleReporter() {
        return this.simpleReporter;
    }

    public void simpleReporter_$eq(AuditReporter x$1) {
        this.simpleReporter = x$1;
    }

    public DurabilityMetricsManager durabilityMetricMgr() {
        return this.durabilityMetricMgr;
    }

    public void durabilityMetricMgr_$eq(DurabilityMetricsManager x$1) {
        this.durabilityMetricMgr = x$1;
    }

    public Set<Enumeration.Value> auditsAllowed() {
        return this.auditsAllowed;
    }

    public Set<Enumeration.Value> allowedEvents() {
        return this.allowedEvents;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public long dbConfig() {
        return this.dbConfig;
    }

    public void dbConfig_$eq(long x$1) {
        this.dbConfig = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    public DurabilityAuditConfig auditConfig() {
        return this.auditConfig;
    }

    public void auditConfig_$eq(DurabilityAuditConfig x$1) {
        this.auditConfig = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.time_$eq(new MockTime());
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.metrics_$eq(new Metrics(new MetricConfig(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (Time)this.time()));
        this.durabilityMetricMgr_$eq(new DurabilityMetricsManager("0", this.metrics(), (Time)this.time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4()));
        this.simpleReporter_$eq(AuditReporter$.MODULE$.apply(this.durabilityMetricMgr()));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        this.topicPartition_$eq(new TopicPartition("some-topic", 1));
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
        this.partitionTuple_$eq((Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$));
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.auditConfig_$eq(DurabilityTestUtils$.MODULE$.durabilityAuditConfig((Time)this.time(), true, this.auditsAllowed(), this.allowedEvents(), this.logDir(), Predef$.MODULE$.Long2long(ConfluentConfigs.DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT)));
    }

    @AfterEach
    public void tearDown() {
        if (this.objStore() != null) {
            this.objStore().close();
        }
        this.logManager_$eq(null);
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testSimpleOffsetScan() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$3(), DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), segments, (Seq<TierLogSegment>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleOffsetScanWithOverlapWithTierPortion() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        TierPartitionState tierPartitionMock = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        File x$1 = this.logDir();
        long x$2 = 10L;
        int x$3 = 10;
        long x$4 = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$3();
        Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(x$1, x$2, x$4, x$3);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionMock.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        TopicPartition x$5 = (TopicPartition)this.topicPartitions().head();
        Nil$ x$7 = Nil$.MODULE$;
        Some x$8 = new Some((Object)tierPartitionMock);
        Option<Seq<TierLogSegment>> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$10 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$11 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        boolean x$12 = DurabilityTestUtils$.MODULE$.mockLog$default$7();
        boolean x$13 = DurabilityTestUtils$.MODULE$.mockLog$default$8();
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$5, segments, (Seq<TierLogSegment>)x$7, x$9, x$10, x$11, x$12, x$13, (Option<TierPartitionState>)x$8);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)22L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleTieredOffsetScan() {
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testSimpleTieredOffsetScan$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Nil$ x$2 = Nil$.MODULE$;
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Option<Seq<TierLogSegment>> x$5 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        boolean x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$7();
        boolean x$8 = DurabilityTestUtils$.MODULE$.mockLog$default$8();
        Option<TierPartitionState> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (Seq<LogSegment>)x$2, tierSegments, x$5, (Option<Object>)x$4, x$6, x$7, x$8, x$9);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    private OngoingStubbing<Option<AbstractLog>> initializeLogManager(AbstractLog mLog) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        return Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
    }

    @Test
    public void testObjectStoreSegmentLoss() {
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testObjectStoreSegmentLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedObjectLoss() {
        int localLogStartOffset = 2042;
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testTierCompactedObjectLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$4 = true;
        boolean x$5 = true;
        Option<Seq<TierLogSegment>> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$8 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        Option<TierPartitionState> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, x$6, x$7, x$8, x$4, x$5, x$9);
        this.initializeLogManager(mlog);
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedTopicValidates() {
        int localLogStartOffset = 2042;
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testTierCompactedTopicValidates$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$4 = true;
        boolean x$5 = true;
        Option<Seq<TierLogSegment>> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$8 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        Option<TierPartitionState> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, x$6, x$7, x$8, x$4, x$5, x$9);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testMissingSegmentInObjectStore() {
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata((TierLogSegment)tierSegments.head()), this.objStore());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1010L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1010L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLaggingTierPartitionState() {
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, (Option<Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)3000L)), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testEndToEndRun() {
        long expectedTotalMsgCount = 2004L;
        long expectedGapCount = 0L;
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)new .colon.colon((Object)new TopicPartition("some-topic", 2), (List)Nil$.MODULE$)));
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        Map logMap = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)topicPartition -> {
            File logDir = TestUtils$.MODULE$.tempDir();
            Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)topicPartition, this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
            tierSegments.foreach((Function1 & Serializable & scala.Serializable)tierSegment -> {
                AuditJobTest.$anonfun$testEndToEndRun$2(this, tierSegment);
                return BoxedUnit.UNIT;
            });
            Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(logDir, 0L, 2000L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
            return new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, localSegments, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9()));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)logMap));
        CountDownLatch countdown = new CountDownLatch(1);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), countdown, this.simpleReporter(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.auditJob().run();
        this.partitionTuple().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AuditJobTest.$anonfun$testEndToEndRun$3(this, expectedGapCount, expectedTotalMsgCount, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Assertions.assertEquals((long)0L, (long)countdown.getCount());
    }

    @Test
    public void testOffsetGapBetweenTierAndLocalLog() {
        int localLogStartOffset = 2042;
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testOffsetGapBetweenTierAndLocalLog$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)localLogStartOffset));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)42L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)42L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierOffsetGapRetries() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        Seq<TierLogSegment> secondaryTierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 2000L);
        ((IterableLike)tierSegments.$plus$plus(secondaryTierSegments, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testTierOffsetGapRetries$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 4000L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<Seq<TierLogSegment>>)new Some(tierSegments.$plus$plus(secondaryTierSegments, Seq$.MODULE$.canBuildFrom())), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testNonAlignedSegments() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)mLog.config()).thenReturn((Object)new LogConfig(new HashMap(), LogConfig$.MODULE$.$lessinit$greater$default$2()));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 11L, 20L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 18L, 31L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8()), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testNonAlignedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(20L, 30L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(31L, 40L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(41L, 50L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)Nil$.MODULE$)));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        LogManager qual$2 = this.logManager();
        TopicPartition x$3 = (TopicPartition)this.topicPartitions().head();
        boolean x$4 = qual$2.getLog$default$2();
        Mockito.when((Object)qual$2.getLog(x$3, x$4)).thenReturn((Object)new Some((Object)mlog));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)66L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicIsAvoided() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$3(), DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Nil$ x$3 = Nil$.MODULE$;
        boolean x$4 = true;
        Option<Seq<TierLogSegment>> x$5 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        boolean x$8 = DurabilityTestUtils$.MODULE$.mockLog$default$8();
        Option<TierPartitionState> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, segments, (Seq<TierLogSegment>)x$3, x$5, x$6, x$7, x$4, x$8, x$9);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)0L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertFalse((boolean)auditResult.errorOpt().isEmpty());
        Predef$.MODULE$.assert(auditResult.errorOpt().get() instanceof UnsupportedOperationException);
        Assertions.assertTrue((boolean)((Throwable)auditResult.errorOpt().get()).getMessage().contains("is not audited"));
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicChangedToDelete() {
        this.partitionTuple_$eq((Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)ConfigFlag$.MODULE$.OnceCompacted().id())), (List)Nil$.MODULE$));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 1000L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testCompactedTopicChangedToDelete$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 1000L, 4000L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$4());
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, true, true, DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.config().compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)mLog.tieredLogSegments()).thenReturn((Object)tierSegments.iterator());
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult2 = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult2.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult2.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult2.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLatchCountdownThrowsException() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8()), (List)Nil$.MODULE$);
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(0), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        Assertions.assertThrows(InterruptedException.class, () -> this.auditJob().doAuditSafely(mlog, this.dbConfig()), () -> "Expected InterruptedException to be thrown");
    }

    @Test
    public void testAuditJobSleepsForTierVerification() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        Seq tierSegments = (Seq)Seq$.MODULE$.fill(AuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE() + 1, (Function0 & Serializable & scala.Serializable)() -> LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8()));
        long beforeAccessTimestamp = this.time().milliseconds();
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)(AuditJob$.MODULE$.SLEEP_TIME_MS() * 2L), (long)(this.time().milliseconds() - beforeAccessTimestamp));
    }

    @Test
    public void testTierLogSegmentConversionForValidator() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        int keyBaseOffset = 44;
        int virtualBaseOffset = 43;
        int endOffset = 55;
        int maxTimestamp = 100;
        int size = 33;
        int firstBatchTimestamp = 30;
        SegmentState segmentState = new SegmentState(0, UUID.randomUUID(), (long)virtualBaseOffset, (long)keyBaseOffset, (long)endOffset, (long)maxTimestamp, (long)firstBatchTimestamp, size, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99L);
        TierLogSegment tierLogSegmentOverlapping = new TierLogSegment(topicIdPartition, segmentState);
        TierObjectMetadata overlappingMetadata = AuditJob$.MODULE$.getTierObjectMetadata(tierLogSegmentOverlapping);
        Assertions.assertEquals((long)keyBaseOffset, (long)overlappingMetadata.baseOffset(), (String)"tier log segment with virtually bounded base offset should return true key base offset in metadata");
        Assertions.assertEquals((long)55L, (long)overlappingMetadata.endOffset());
        Assertions.assertEquals((long)100L, (long)overlappingMetadata.maxTimestamp());
        Assertions.assertEquals((int)33, (int)size);
    }

    @Test
    public void testChecksumDisableTest() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testChecksumDisableTest$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().validateChecksum())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.ChecksumValidation())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSizeMismatch() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        TierObjectStore objectStoreSpy = (TierObjectStore)Mockito.spy((Object)this.objStore());
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), objectStoreSpy, 10L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testSizeMismatch$1(objectStoreSpy, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Nil$ x$2 = Nil$.MODULE$;
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Option<Seq<TierLogSegment>> x$5 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        boolean x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$7();
        boolean x$8 = DurabilityTestUtils$.MODULE$.mockLog$default$8();
        Option<TierPartitionState> x$9 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (Seq<LogSegment>)x$2, tierSegments, x$5, (Option<Object>)x$4, x$6, x$7, x$8, x$9);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        TierObjectStore.ObjectMetadata firstSegMetadata = ((TierLogSegment)tierSegments.head()).metadata();
        Mockito.when((Object)objectStoreSpy.objectExists(new TierObjectStore.ObjectMetadata(firstSegMetadata.topicIdPartition(), firstSegMetadata.objectId(), firstSegMetadata.tierEpoch(), firstSegMetadata.baseOffset(), firstSegMetadata.hasAbortedTxns(), firstSegMetadata.hasProducerState(), firstSegMetadata.hasEpochState(), firstSegMetadata.opaqueData()), TierObjectStore.FileType.SEGMENT)).thenReturn((Object)new TierObjectAttribute(false, 1L));
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)objectStoreSpy), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleCompactionValidation() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testSimpleCompactionValidation$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1, objectID2})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L);
        TierTopicEvents events = new TierTopicEvents((Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (Seq)((TraversableLike)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()), (Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario1() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario1$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 50L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L);
        TierTopicEvents events = new TierTopicEvents((Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (Seq)((TraversableLike)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()), (Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
    }

    @Test
    public void testMissingSegmentInCompaction() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testMissingSegmentInCompaction$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L);
        TierTopicEvents events = new TierTopicEvents((Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (Seq)((TraversableLike)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()), (Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new AuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), AuditJob$.MODULE$.$lessinit$greater$default$11()));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
    }

    public static final /* synthetic */ void $anonfun$testSimpleTieredOffsetScan$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreSegmentLoss$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedObjectLoss$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedTopicValidates$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$2(AuditJobTest $this, TierLogSegment tierSegment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(tierSegment), $this.objStore());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEndToEndRun$3(AuditJobTest $this, long expectedGapCount$1, long expectedTotalMsgCount$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_6;
            void var10_7;
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Tuple2 tuple2 = $this.simpleReporter().getDurabilityCounters(topicPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long total = tuple2._1$mcJ$sp();
            long gap = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)expectedGapCount$1, (long)var10_7, (String)new StringBuilder(19).append("Incorrect gap for: ").append(topicPartition).toString());
            Assertions.assertEquals((long)expectedTotalMsgCount$1, (long)var8_6, (String)new StringBuilder(21).append("Incorrect total for: ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testOffsetGapBetweenTierAndLocalLog$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierOffsetGapRetries$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testNonAlignedSegments$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testCompactedTopicChangedToDelete$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testChecksumDisableTest$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSizeMismatch$1(TierObjectStore objectStoreSpy$1, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), objectStoreSpy$1);
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario1$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testMissingSegmentInCompaction$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public AuditJobTest() {
        this.jobId = 0;
    }
}

