/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.durability.audit.AuditManager;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.DeletePartitionRequest;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.EpochChangeRequest;
import kafka.durability.audit.HealthCheckRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest$;
import kafka.durability.audit.ISRExpandRequest;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest$;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.RetentionType$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u00192\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004Q\u0001\u0001\u0006I!\u0012\u0005\b#\u0002\u0011\r\u0011\"\u0001E\u0011\u0019\u0011\u0006\u0001)A\u0005\u000b\"91\u000b\u0001b\u0001\n\u0003!\u0006B\u0002.\u0001A\u0003%Q\u000bC\u0005\\\u0001\u0001\u0007\t\u0019!C\u00019\"I1\r\u0001a\u0001\u0002\u0004%\t\u0001\u001a\u0005\nU\u0002\u0001\r\u0011!Q!\nuC\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00017\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0003!\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003n\u0011\u001d9\b\u00011A\u0005\u0002aD\u0011\"!\u0002\u0001\u0001\u0004%\t!a\u0002\t\u000f\u0005-\u0001\u0001)Q\u0005s\"Y\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011AA\b\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%\t!a\t\t\u0017\u0005\u001d\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0003\u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0003C\u0006\u00024\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0002bCA\u001d\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[A\u0011\"a\u000f\u0001\u0005\u0004%\t!!\u0010\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003\u007fA1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002h!Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011AA;\u0011-\tI\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u0017\u0005m\u0004\u00011AA\u0002\u0013\u0005\u0011Q\u0010\u0005\f\u0003\u000b\u0003\u0001\u0019!a\u0001\n\u0003\t9\tC\u0006\u0002\f\u0002\u0001\r\u0011!Q!\n\u0005}\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003O\u0003A\u0011AAH\u0011\u001d\t\t\f\u0001C\u0001\u0003\u001fCq!a/\u0001\t\u0003\ty\tC\u0004\u0002@\u0002!\t!a$\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002\u0010\"9\u0011q\u0019\u0001\u0005\u0002\u0005=\u0005bBAf\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003\u001f\u0004A\u0011AAH\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003\u001fCq!a6\u0001\t\u0003\ty\tC\u0004\u0002\\\u0002!\t!a$\t\u000f\u0005}\u0007\u0001\"\u0001\u0002\u0010\"9\u00111\u001d\u0001\u0005\u0002\u0005=\u0005bBAt\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003W\u0004A\u0011AAH\u0011\u001d\ty\u000f\u0001C\u0001\u0003\u001f\u0013\u0001#Q;eSRl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005I\u001a\u0014!B1vI&$(B\u0001\u001b6\u0003)!WO]1cS2LG/\u001f\u0006\u0002m\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011!M\u0001\u0004iB\fT#A#\u0011\u0005\u0019sU\"A$\u000b\u0005!K\u0015AB2p[6|gN\u0003\u00027\u0015*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0013\tyuI\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006!A\u000f]\u0019!\u0003\r!\bOM\u0001\u0005iB\u0014\u0004%\u0001\u0003ua&#W#A+\u0011\u0005YKV\"A,\u000b\u0005a+\u0014\u0001\u0002;jKJL!aT,\u0002\u000bQ\u0004\u0018\n\u001a\u0011\u0002\tQLW.Z\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mR\u0001\u0006kRLGn]\u0005\u0003E~\u0013A\u0001V5nK\u0006AA/[7f?\u0012*\u0017\u000f\u0006\u0002fQB\u0011!HZ\u0005\u0003On\u0012A!\u00168ji\"9\u0011.CA\u0001\u0002\u0004i\u0016a\u0001=%c\u0005)A/[7fA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A7\u0011\u00059\fX\"A8\u000b\u0005A,\u0014AB:feZ,'/\u0003\u0002s_\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"!Z;\t\u000f%d\u0011\u0011!a\u0001[\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\buS\u0016\u0014xJ\u00196Ti>\u0014Xm\u00149u+\u0005I\bc\u0001\u001e{y&\u00111p\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyx+A\u0003ti>\u0014X-C\u0002\u0002\u0004y\u0014q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0014i&,'o\u00142k'R|'/Z(qi~#S-\u001d\u000b\u0004K\u0006%\u0001bB5\u0010\u0003\u0003\u0005\r!_\u0001\u0011i&,'o\u00142k'R|'/Z(qi\u0002\na\u0001^7q\t&\u0014XCAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t!![8\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t!a)\u001b7f\u0003)!X\u000e\u001d#je~#S-\u001d\u000b\u0004K\u0006\u0015\u0002\u0002C5\u0013\u0003\u0003\u0005\r!!\u0005\u0002\u000fQl\u0007\u000fR5sA\u0005\u0001B/Z:u\u0003V$\u0017\u000e^'b]\u0006<WM]\u000b\u0003\u0003[\u00012AQA\u0018\u0013\r\t\t$\r\u0002\u0011)\u0016\u001cH/Q;eSRl\u0015M\\1hKJ\fA\u0003^3ti\u0006+H-\u001b;NC:\fw-\u001a:`I\u0015\fHcA3\u00028!A\u0011.FA\u0001\u0002\u0004\ti#A\tuKN$\u0018)\u001e3ji6\u000bg.Y4fe\u0002\nA\u0002\\8dC2|eMZ:fiN,\"!a\u0010\u0011\r\u0005\u0005\u0013\u0011KA,\u001d\u0011\t\u0019%!\u0014\u000f\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u00138\u0003\u0019a$o\\8u}%\tA(C\u0002\u0002Pm\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#aA*fc*\u0019\u0011qJ\u001e\u0011\u000fi\nI&!\u0018\u0002^%\u0019\u00111L\u001e\u0003\rQ+\b\u000f\\33!\rQ\u0014qL\u0005\u0004\u0003CZ$\u0001\u0002'p]\u001e\fQ\u0002\\8dC2|eMZ:fiN\u0004\u0013a\u00017pOV\u0011\u0011\u0011\u000e\t\u0005\u0003W\ny'\u0004\u0002\u0002n)\u0019\u0011QM\u001b\n\t\u0005E\u0014Q\u000e\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\u0007\u0015\f9\b\u0003\u0005j5\u0005\u0005\t\u0019AA5\u0003\u0011awn\u001a\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002\u0000A!\u00111NAA\u0013\u0011\t\u0019)!\u001c\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0007\u0015\fI\t\u0003\u0005j;\u0005\u0005\t\u0019AA@\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003\u0015D3aHAJ!\u0011\t)*a)\u000e\u0005\u0005]%\u0002BAM\u00037\u000b1!\u00199j\u0015\u0011\ti*a(\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\u0015'\u0002\u000b),h.\u001b;\n\t\u0005\u0015\u0016q\u0013\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0001\nY\u000b\u0005\u0003\u0002\u0016\u00065\u0016\u0002BAX\u0003/\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002E\t\u000b7/[2Bk\u0012LG/T1oC\u001e,'/\u00138ti\u0006tG/[1uS>tG+Z:uQ\r\t\u0013Q\u0017\t\u0005\u0003+\u000b9,\u0003\u0003\u0002:\u0006]%\u0001\u0002+fgR\f1DQ1tS\u000e\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u000bZ,g\u000e^:UKN$\bf\u0001\u0012\u00026\u0006QB+Z:u\u001fJ$WM\u001d#fY&4XM]=PM6+7o]1hK\"\u001a1%!.\u0002[Q+7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;SKN$xN]3NSN\u001c\u0018N\\4SK\u001eL7\u000f\u001e:bi&|g\u000eK\u0002%\u0003k\u000b!EQ1tS\u000e,e\u000e\u001a\u001aF]\u0012\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u000bZ,g\u000e^:UKN$\bfA\u0013\u00026\u000692\t\\;ti\u0016\u0014H*\u001b8l\t&\u001c\u0018M\u00197fIR+7\u000f\u001e\u0015\u0004M\u0005U\u0016AE%T%\u0016C\b/\u00198e\u000bZ,g\u000e\u001e+fgRD3aJA[\u0003QAU-\u00197uQ\u000eCWmY6Fm\u0016tG\u000fV3ti\"\u001a\u0001&!.\u0002#=3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000fK\u0002*\u0003k\u000bq\u0003^3ti\u0006cGn\\<fI\u00163XM\u001c;t\r&dG/\u001a:)\u0007)\n),\u0001\u0013uKN$\u0018)\u001e3ji*{'-R7jiNlU\r\u001e:jGN<\u0016\u000e\u001e5O_\u00163XM\u001c;tQ\rY\u0013QW\u0001)i\u0016\u001cHoU2iK\u0012,H.Z!vI&$(j\u001c2SKN\u0004Xm\u0019;t\u0013:LG/[1m\t\u0016d\u0017-\u001f\u0015\u0004Y\u0005U\u0016!\n;fgR\u001c6\r[3ek2,\u0017)\u001e3ji*{'MU3ta\u0016\u001cGo\u001d#bs>3\u0017,Z1sQ\ri\u0013QW\u0001*i\u0016\u001cHoU2iK\u0012,H.Z!vI&$(j\u001c2SKN\u0004Xm\u0019;t\u0019\u0006\u001cH\u000fR1z\u001f\u001aLV-\u0019:)\u00079\n),\u0001\bBk\u0012LG/U;fk\u0016$Vm\u001d;)\u0007=\n)\f")
public class AuditManagerTest {
    private final org.apache.kafka.common.TopicIdPartition tp1 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 1));
    private final org.apache.kafka.common.TopicIdPartition tp2 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t2", 2));
    private final TopicIdPartition tpId = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
    private Time time;
    private ReplicaManager replicaManager;
    private Option<TierObjectStore> tierObjStoreOpt = None$.MODULE$;
    private File tmpDir;
    private TestAuditManager testAuditManager;
    private final Seq<Tuple2<Object, Object>> localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    private AbstractLog log;
    private LogManager logManager;

    public org.apache.kafka.common.TopicIdPartition tp1() {
        return this.tp1;
    }

    public org.apache.kafka.common.TopicIdPartition tp2() {
        return this.tp2;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Option<TierObjectStore> tierObjStoreOpt() {
        return this.tierObjStoreOpt;
    }

    public void tierObjStoreOpt_$eq(Option<TierObjectStore> x$1) {
        this.tierObjStoreOpt = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public TestAuditManager testAuditManager() {
        return this.testAuditManager;
    }

    public void testAuditManager_$eq(TestAuditManager x$1) {
        this.testAuditManager = x$1;
    }

    public Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.tierObjStoreOpt_$eq((Option<TierObjectStore>)new Some((Object)TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig())));
        this.testAuditManager_$eq(new TestAuditManager());
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6()));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.testAuditManager().cleanUp();
        this.tierObjStoreOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerInstantiationTest() {
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, false));
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)1);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().startAuditManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, false));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerEventsTest() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeletePartitionRequest(this.tp1(), 0));
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertNotEquals((Object)this.testAuditManager().instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition reported before fetch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void TestOrderDeliveryOfMessage() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void TestDurabilityAuditRestoreMissingRegistration() {
        TestAuditManager testAuditManagerMock = new TestAuditManager(null){

            public int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
                return 1;
            }
        };
        Assertions.assertEquals((int)testAuditManagerMock.pendingRegistration().size(), (int)0);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManagerMock, this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        testAuditManagerMock.startAuditManager();
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicEnd2EndAuditManagerEventsTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().auditRequestsQueue().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), -1, 111L, 10L, RetentionType$.MODULE$.Other(), -1L, StartOffsetChangeRequest$.MODULE$.apply$default$7()));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$9(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        Assertions.assertEquals((int)1, (int)eventList.length());
        Assertions.assertEquals((Object)eventList.head(), (Object)EpochChangeEvent$.MODULE$.apply(this.tp1(), 111L, 1, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ClusterLinkDisabledTest() {
        Partition partitionMock = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partitionMock.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getPartition(this.tp1().topicPartition())).thenReturn((Object)new HostedPartition.Online(partitionMock));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ClusterLinkDisabledTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ClusterLinkDisabledTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp1(), 0, 3));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp2(), 0, 3));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ClusterLinkDisabledTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ClusterLinkDisabledTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ClusterLinkDisabledTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ClusterLinkDisabledTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ClusterLinkDisabledTest$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ClusterLinkDisabledTest$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        Assertions.assertEquals((int)1, (int)eventList.length());
        Assertions.assertEquals((Object)eventList.head(), (Object)IsrExpandEvent$.MODULE$.apply(this.tp2(), 3, 0, -1L, -1L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.testAuditManager().instance().isMirrorPartition(this.tp1().topicPartition())));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.testAuditManager().instance().isMirrorPartition(this.tp2().topicPartition())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ISRExpandEventTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ISRExpandEventTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ISRExpandEventTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp1(), 0, 3));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ISRExpandEventTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ISRExpandEventTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ISRExpandEventTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ISRExpandEventTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$ISRExpandEventTest$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$ISRExpandEventTest$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        Assertions.assertEquals((int)1, (int)eventList.length());
        Assertions.assertEquals((Object)eventList.head(), (Object)IsrExpandEvent$.MODULE$.apply(this.tp1(), 3, 0, -1L, -1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void HealthCheckEventTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        org.apache.kafka.common.TopicIdPartition tp = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("durability-health-check", 0));
        this.time().sleep(5L);
        long produceTime = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 0, produceTime));
        this.time().sleep(20L);
        long produceTimeDelayed = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 1, produceTimeDelayed));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 2, produceTimeDelayed));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (!this.testAuditManager().queue().isEmpty()) {
            ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
            Assertions.assertNotNull(events);
            events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        }
        Assertions.assertEquals((int)3, (int)eventList.length());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OffsetChangeEvent() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 10L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 1, 10L, 7L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, StartOffsetChangeRequest$.MODULE$.apply$default$7()));
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = false;
        boolean x$5 = qual$2.doWorkActual$default$1();
        boolean x$6 = qual$2.doWorkActual$default$2();
        qual$2.doWorkActual(x$5, x$6, x$4);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 8L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        AuditManager qual$3 = this.testAuditManager().instance();
        boolean x$7 = true;
        boolean x$8 = qual$3.doWorkActual$default$1();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$8, x$7, x$9);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"event received at consumer should not have changed from 1");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 8L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        AuditManager qual$4 = this.testAuditManager().instance();
        boolean x$10 = true;
        boolean x$11 = qual$4.doWorkActual$default$1();
        boolean x$12 = qual$4.doWorkActual$default$3();
        qual$4.doWorkActual(x$11, x$10, x$12);
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)0, (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 0, 8L, 4L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, StartOffsetChangeRequest$.MODULE$.apply$default$7()));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 11L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        AuditManager qual$5 = this.testAuditManager().instance();
        boolean x$13 = qual$5.doWorkActual$default$1();
        boolean x$14 = qual$5.doWorkActual$default$2();
        boolean x$15 = qual$5.doWorkActual$default$3();
        qual$5.doWorkActual(x$13, x$14, x$15);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 1");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)this.testAuditManager().queue().size(), (int)2, (String)"event not received at consumer");
        AuditManager qual$6 = this.testAuditManager().instance();
        boolean x$16 = true;
        boolean x$17 = qual$6.doWorkActual$default$1();
        boolean x$18 = qual$6.doWorkActual$default$3();
        qual$6.doWorkActual(x$17, x$16, x$18);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, false));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp2(), 1, 10L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        AuditManager qual$7 = this.testAuditManager().instance();
        boolean x$19 = true;
        boolean x$20 = qual$7.doWorkActual$default$1();
        boolean x$21 = qual$7.doWorkActual$default$3();
        qual$7.doWorkActual(x$20, x$19, x$21);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
    }

    @Test
    public void testAllowedEventsFilter() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        ReplicaManager x$3 = this.replicaManager();
        Set x$4 = Predef$.MODULE$.Set().empty();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Option<TopicPartition> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$3, x$5, x$6, x$7, (Set<Enumeration.Value>)x$4, x$8);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$9 = qual$1.doWorkActual$default$1();
        boolean x$10 = qual$1.doWorkActual$default$2();
        boolean x$11 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$9, x$10, x$11);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Assertions.assertEquals((Object)this.tp1().topicPartition(), (Object)((Tuple2)this.testAuditManager().instance().db().getTopicPartitionsForAudit().head())._1());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 110L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$12 = qual$2.doWorkActual$default$1();
        boolean x$13 = qual$2.doWorkActual$default$2();
        boolean x$14 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$12, x$13, x$14);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().queue().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuditJobEmitsMetricsWithNoEvents() {
        TopicIdPartition tpId1 = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        .colon.colon tieredOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(11L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(25L, 38L), (List)Nil$.MODULE$));
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(140L, 152L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(160L, 168L), (List)Nil$.MODULE$));
        AbstractLog tp1Log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId1, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)tieredOffsets, this.tierObjStoreOpt());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)tp1Log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Option<TierObjectStore> x$4 = this.tierObjStoreOpt();
        Set x$5 = Predef$.MODULE$.Set().empty();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Option<TopicPartition> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, replicaManager, x$4, x$6, x$7, (Set<Enumeration.Value>)x$5, x$8);
        Assertions.assertNotNull((Object)this.testAuditManager().instance());
        Metrics metrics = this.testAuditManager().instance().config().metrics();
        Assertions.assertEquals((int)17, (int)metrics.metrics().size());
        Assertions.assertEquals((long)0L, (long)this.testAuditManager().instance().metricsManager().totalLostMessages());
        MetricName name = DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)metrics.metric(name).metricValue());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$9 = qual$1.doWorkActual$default$1();
        boolean x$10 = qual$1.doWorkActual$default$2();
        boolean x$11 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$9, x$10, x$11);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$12 = true;
        boolean x$13 = qual$2.doWorkActual$default$2();
        boolean x$14 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$12, x$13, x$14);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)18, (int)metrics.metrics().size());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)11L), (Object)metrics.metric(DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics)).metricValue());
    }

    @Test
    public void testScheduleAuditJobRespectsInitialDelay() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsDayOfYear() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-01-30T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(30);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYear() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(366);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void AuditQueueTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$AuditQueueTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$AuditQueueTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxEvents = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() + 1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxEvents).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)epoch -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), epoch, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))));
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$AuditQueueTest$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$AuditQueueTest$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$AuditQueueTest$6(this, maxEvents)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$AuditQueueTest$7(this, maxEvents));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().pendingRegistration().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$2() {
        return "AuditManager didn't start within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$4() {
        return "AuditManager didn't flush within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$5(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 2;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().highWatermarkUpdateRequests().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$TestOrderDeliveryOfMessage$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$TestOrderDeliveryOfMessage$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$TestOrderDeliveryOfMessage$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().highWatermarkUpdateRequests().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$TestOrderDeliveryOfMessage$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().auditRequestsQueue().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$5(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().highWatermarkUpdateRequests().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$7(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$9(AuditManagerTest $this) {
        return $this.testAuditManager().queue().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$10() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 2;
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$3(AuditManagerTest $this) {
        return 2 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$5(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$7(AuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$3(AuditManagerTest $this) {
        return 1 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$5(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$7(AuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$1(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$3(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$5(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$1(AuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$2() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$3(AuditManagerTest $this) {
        return 2 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$4() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$5(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$6() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$testAuditJobEmitsMetricsWithNoEvents$1(AuditManagerTest $this) {
        return 0L == $this.testAuditManager().instance().auditJobCountdownLatch().getCount();
    }

    public static final /* synthetic */ String $anonfun$testAuditJobEmitsMetricsWithNoEvents$2() {
        return "AuditJob didn't complete within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$4(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$5(AuditManagerTest $this) {
        return new StringBuilder(56).append("auditRequestsQueue size expect to be: 0, but actual is: ").append($this.testAuditManager().instance().auditRequestsQueue().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$6(AuditManagerTest $this, int maxEvents$1) {
        return maxEvents$1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$7(AuditManagerTest $this, int maxEvents$1) {
        return new StringBuilder(59).append("testAuditManager queue size expect to be: ").append(maxEvents$1).append(", but actual is: ").append($this.testAuditManager().queue().size()).toString();
    }
}

