/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConfig$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtilConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicManager$;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DurabilityTestUtils$ {
    public static DurabilityTestUtils$ MODULE$;
    private int offset;
    private final Supplier<InternalAdmin> internalAdminSupplier;

    static {
        new DurabilityTestUtils$();
    }

    public int offset() {
        return this.offset;
    }

    public void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public DurabilityDB getDB(String topic, int partition) {
        void var3_3;
        DurabilityDB db = DbTestUtils$.MODULE$.getDbInstance();
        DbTestUtils$.MODULE$.addPartition(db, topic, partition);
        return var3_3;
    }

    public DurabilityTopicConfig getDurabilityConfig() {
        return new DurabilityTopicConfig(() -> Collections.singletonMap("bootstrap.servers", "localhost:80"), "test-topic", 50, 3, 2, "test-cluster", 10000L, Predef$.MODULE$.int2Integer(6000), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS());
    }

    public DurabilityTopicManager getDurabilityTopicManager(DurabilityDB db, BlockingQueue<ConsumerRecords<byte[], byte[]>> topicPartitionQueue, Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> resultQueue) {
        return new DurabilityTopicManager(db, topicPartitionQueue, resultQueue){
            private DurabilityTopicConsumer consumerProvider;
            private DurabilityTopicProducer producerProvider;
            private volatile byte bitmap$0;
            private final BlockingQueue topicPartitionQueue$1;
            private DurabilityDB db$1;
            private Option resultQueue$1;

            private DurabilityTopicConsumer consumerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.consumerProvider = DurabilityTestUtils$.MODULE$.getDurabilityConsumer(this.topicPartitionQueue$1, this.db$1, (Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>>)this.resultQueue$1);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                this.db$1 = null;
                this.resultQueue$1 = null;
                return this.consumerProvider;
            }

            public DurabilityTopicConsumer consumerProvider() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.consumerProvider$lzycompute();
                }
                return this.consumerProvider;
            }

            private DurabilityTopicProducer producerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.producerProvider = DurabilityTestUtils$.MODULE$.getDurabilityProducer(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), this.topicPartitionQueue$1);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.producerProvider;
            }

            public DurabilityTopicProducer producerProvider() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.producerProvider$lzycompute();
                }
                return this.producerProvider;
            }
            {
                this.topicPartitionQueue$1 = topicPartitionQueue$1;
                this.db$1 = db$1;
                this.resultQueue$1 = resultQueue$1;
                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$1, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class), DurabilityTestUtils$.MODULE$.internalAdminSupplier(), DurabilityTopicManager$.MODULE$.$lessinit$greater$default$5());
            }
        };
    }

    public BlockingQueue<ConsumerRecords<byte[], byte[]>> getDurabilityTopicManager$default$2() {
        return new ArrayBlockingQueue<ConsumerRecords<byte[], byte[]>>(DurabilityTestUtilConstants$.MODULE$.TEST_QUEUE_SIZE());
    }

    public Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> getDurabilityTopicManager$default$3() {
        return None$.MODULE$;
    }

    public ConsumerRecords<byte[], byte[]> kafka$durability$audit$DurabilityTestUtils$$toConsumerRecord(ProducerRecord<byte[], byte[]> record) {
        HashMap records = new HashMap();
        ConsumerRecord crecord = new ConsumerRecord(record.topic(), Predef$.MODULE$.Integer2int(record.partition()), (long)this.offset(), record.key(), record.value());
        this.offset_$eq(this.offset() + 1);
        ArrayList<ConsumerRecord> crecords = new ArrayList<ConsumerRecord>();
        crecords.add(crecord);
        records.put(new TopicPartition(record.topic(), Predef$.MODULE$.Integer2int(record.partition())), crecords);
        return new ConsumerRecords(records);
    }

    public DurabilityTopicConsumer getDurabilityConsumer(BlockingQueue<ConsumerRecords<byte[], byte[]>> topicPartitionQueue, DurabilityDB db, Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> resultQueue) {
        return new DurabilityTopicConsumer(db, topicPartitionQueue, resultQueue){
            private KafkaConsumer<byte[], byte[]> consumer;
            private volatile boolean bitmap$0;
            public final BlockingQueue topicPartitionQueue$2;
            private final Option resultQueue$2;

            private KafkaConsumer<byte[], byte[]> consumer$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.consumer = new KafkaConsumer<byte[], byte[]>(this){
                            private final /* synthetic */ anon.3 $outer;

                            public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                                return (ConsumerRecords)this.$outer.topicPartitionQueue$2.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                            }

                            public void seek(TopicPartition partition, long offset) {
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toConsumerProperties("dummy"));
                            }
                        };
                        this.bitmap$0 = true;
                    }
                }
                return this.consumer;
            }

            public KafkaConsumer<byte[], byte[]> consumer() {
                if (!this.bitmap$0) {
                    return this.consumer$lzycompute();
                }
                return this.consumer;
            }

            public void processRecords(ConsumerRecords<byte[], byte[]> records) {
                Option option = this.resultQueue$2;
                if (option instanceof Some) {
                    BlockingQueue queue = (BlockingQueue)((Some)option).value();
                    if (records != null) {
                        queue.put(records);
                        return;
                    }
                }
            }
            {
                this.topicPartitionQueue$2 = topicPartitionQueue$2;
                this.resultQueue$2 = resultQueue$2;
                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$2, (DurabilityEventsMaterialize)Mockito.mock(DurabilityEventsMaterialize.class));
            }
        };
    }

    public Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> getDurabilityConsumer$default$3() {
        return None$.MODULE$;
    }

    public DurabilityTopicProducer getDurabilityProducer(DurabilityTopicConfig config, BlockingQueue<ConsumerRecords<byte[], byte[]>> queue) {
        return new DurabilityTopicProducer(config, queue){
            private KafkaProducer<byte[], byte[]> get;
            private KafkaProducer<byte[], byte[]> producer;
            private volatile boolean bitmap$0;
            public final BlockingQueue queue$1;

            private KafkaProducer<byte[], byte[]> producer() {
                return this.producer;
            }

            private KafkaProducer<byte[], byte[]> get$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.get = this.producer();
                        this.bitmap$0 = true;
                    }
                }
                this.producer = null;
                return this.get;
            }

            public KafkaProducer<byte[], byte[]> get() {
                if (!this.bitmap$0) {
                    return this.get$lzycompute();
                }
                return this.get;
            }
            {
                this.queue$1 = queue$1;
                super(config$1);
                this.producer = new KafkaProducer<byte[], byte[]>(this){
                    private final /* synthetic */ anon.5 $outer;

                    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
                        this.$outer.queue$1.add(DurabilityTestUtils$.MODULE$.kafka$durability$audit$DurabilityTestUtils$$toConsumerRecord(record));
                        return (Future)Mockito.mock(Future.class);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toProducerProperties("dummy"));
                    }
                };
            }
        };
    }

    public DurabilityAuditConfig durabilityAuditConfig(Time time, boolean enableAuditRun, Set<Enumeration.Value> auditChecks, Set<Enumeration.Value> allowedEvents, File dbPath, long initialAuditJobDelay) {
        return new DurabilityAuditConfig(0, "test", this.internalAdminSupplier(), () -> Collections.singletonMap("bootstrap.servers", "localhost:80"), new Metrics(new MetricConfig(), Collections.emptyList(), time), enableAuditRun, auditChecks, allowedEvents, dbPath, 3, initialAuditJobDelay, DurabilityAuditConfig$.MODULE$.apply$default$12(), DurabilityAuditConfig$.MODULE$.apply$default$13(), DurabilityAuditConfig$.MODULE$.apply$default$14(), DurabilityAuditConfig$.MODULE$.apply$default$15(), DurabilityAuditConfig$.MODULE$.apply$default$16(), DurabilityAuditConfig$.MODULE$.apply$default$17(), DurabilityAuditConfig$.MODULE$.apply$default$18());
    }

    public boolean durabilityAuditConfig$default$2() {
        return true;
    }

    public Set<Enumeration.Value> durabilityAuditConfig$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Enumeration.Value> durabilityAuditConfig$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public void initializeTestAuditManager(TestAuditManager testAuditManagerTrait, Time time, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, boolean enableAuditRun, Set<Enumeration.Value> auditChecks, Set<Enumeration.Value> allowedEvents, Option<TopicPartition> initialTopicPartitionOpt) {
        File tmpDir = TestUtils$.MODULE$.tempDir();
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(tmpDir);
        testAuditManagerTrait.initialize(this.durabilityAuditConfig(time, enableAuditRun, auditChecks, allowedEvents, logDir, Predef$.MODULE$.Long2long(ConfluentConfigs.DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT)), replicaManager, tierObjectStoreOpt, time);
        initialTopicPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            DbTestUtils$.MODULE$.addPartition(testAuditManagerTrait.instance().db(), tp.topic(), tp.partition());
            return BoxedUnit.UNIT;
        });
    }

    public Time initializeTestAuditManager$default$2() {
        return new MockTime();
    }

    public ReplicaManager initializeTestAuditManager$default$3() {
        return (ReplicaManager)Mockito.mock(ReplicaManager.class);
    }

    public Option<TierObjectStore> initializeTestAuditManager$default$4() {
        return None$.MODULE$;
    }

    public boolean initializeTestAuditManager$default$5() {
        return true;
    }

    public Set<Enumeration.Value> initializeTestAuditManager$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    }

    public Set<Enumeration.Value> initializeTestAuditManager$default$7() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityEventType$.MODULE$.DeleteRecordsType(), DurabilityEventType$.MODULE$.IsrExpandType(), DurabilityEventType$.MODULE$.EpochChangeType(), DurabilityEventType$.MODULE$.RetentionChangeType(), DurabilityEventType$.MODULE$.StartOffsetChangeType(), DurabilityEventType$.MODULE$.OffsetChangeType(), DurabilityEventType$.MODULE$.DeletePartitionType(), DurabilityEventType$.MODULE$.HealthCheckType()}));
    }

    public Option<TopicPartition> initializeTestAuditManager$default$8() {
        return None$.MODULE$;
    }

    public AbstractLog mockLogWithPreLoadedData(TopicIdPartition tpId, Seq<Tuple2<Object, Object>> localOffsets, File logDir, Time time, Seq<Tuple2<Object, Object>> tierOffsets, Option<TierObjectStore> tierObjStoreOpt) {
        if (tierOffsets.nonEmpty() && tierObjStoreOpt.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(56).append("Received empty tierObjStore with non-empty tierOffsets: ").append(tierOffsets).toString());
        }
        Seq localLogs = (Seq)localOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            int x$5 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            long x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$6();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, logDir, x$5, time, x$6);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        Seq tierLogs = (Seq)tierOffsets.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var7_5;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierLogSegment tierSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, (TierObjectStore)tierObjStoreOpt.get(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8());
            TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(tierSegment), (TierObjectStore)tierObjStoreOpt.get());
            return var7_5;
        }, Seq$.MODULE$.canBuildFrom());
        long logStartOffset = BoxesRunTime.unboxToLong((Object)tierOffsets.headOption().map((Function1 & Serializable & scala.Serializable)first -> BoxesRunTime.boxToLong((long)first._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Tuple2)localOffsets.head())._1$mcJ$sp()));
        long logEndOffset = ((Tuple2)((IterableLike)localOffsets.takeRight(1)).head())._2$mcJ$sp();
        TopicPartition x$7 = tpId.topicPartition();
        Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)logStartOffset));
        Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
        Option<Seq<TierLogSegment>> x$12 = this.mockLog$default$4();
        boolean x$13 = this.mockLog$default$7();
        boolean x$14 = this.mockLog$default$8();
        Option<TierPartitionState> x$15 = this.mockLog$default$9();
        return this.mockLog(x$7, (Seq<LogSegment>)localLogs, (Seq<TierLogSegment>)tierLogs, x$12, (Option<Object>)x$10, (Option<Object>)x$11, x$13, x$14, x$15);
    }

    /*
     * WARNING - void declaration
     */
    public TierPartitionState mockTierPartitionState(Option<Seq<TierLogSegment>> onRetryTieredSegments) {
        void var2_2;
        TierPartitionState mockTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)mockTierPartitionState.metadata(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Optional optional;
            Long offset = (Long)invocation.getArgument(0, Long.class);
            if (onRetryTieredSegments instanceof Some) {
                Seq segments = (Seq)((Some)onRetryTieredSegments).value();
                optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(segments.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$mockTierPartitionState$2(offset, s)))));
            } else {
                optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)None$.MODULE$));
            }
            return optional;
        });
        return var2_2;
    }

    public Option<Seq<TierLogSegment>> mockTierPartitionState$default$1() {
        return None$.MODULE$;
    }

    public AbstractLog mockLog(TopicPartition topicPartition, Seq<LogSegment> localSegments, Seq<TierLogSegment> tieredSegments, Option<Seq<TierLogSegment>> onRetryTieredSegments, Option<Object> logStartOffsetOpt, Option<Object> logEndOffsetOpt, boolean compacted, boolean tierCompacted, Option<TierPartitionState> tierPartitionStateOpt) {
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Mockito.when((Object)mockLog.localLogSegments()).thenReturn(localSegments);
        Mockito.when((Object)mockLog.tieredLogSegments()).thenReturn((Object)tieredSegments.iterator());
        Mockito.when((Object)mockLog.topicPartition()).thenReturn((Object)topicPartition);
        Mockito.when((Object)mockLog.topicIdPartition()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)tierCompacted));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isLocallyCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((compacted && !tierCompacted ? 1 : 0) != 0));
        LogConfig mockConfig = (LogConfig)Mockito.mock(LogConfig.class);
        LogConfig.ConfluentLogConfig mockConfluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)mockConfig.confluentLogConfig()).thenReturn((Object)mockConfluentLogConfig);
        Mockito.when((Object)mockConfluentLogConfig.tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(tieredSegments.nonEmpty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)compacted));
        Mockito.when((Object)mockLog.config()).thenReturn((Object)mockConfig);
        logStartOffsetOpt.foreach((Function1 & Serializable & scala.Serializable)start -> DurabilityTestUtils$.$anonfun$mockLog$1(mockLog, BoxesRunTime.unboxToLong((Object)start)));
        logEndOffsetOpt.foreach((Function1 & Serializable & scala.Serializable)end -> DurabilityTestUtils$.$anonfun$mockLog$2(mockLog, BoxesRunTime.unboxToLong((Object)end)));
        TierPartitionState mockTPS = (TierPartitionState)tierPartitionStateOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.mockTierPartitionState(onRetryTieredSegments));
        Mockito.when((Object)mockTPS.topicPartition()).thenReturn((Object)topicPartition);
        Mockito.when((Object)mockLog.tierPartitionState()).thenReturn((Object)mockTPS);
        return mockLog;
    }

    public Option<TierObjectStore> mockLogWithPreLoadedData$default$6() {
        return None$.MODULE$;
    }

    public Option<Seq<TierLogSegment>> mockLog$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> mockLog$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> mockLog$default$6() {
        return None$.MODULE$;
    }

    public boolean mockLog$default$7() {
        return false;
    }

    public boolean mockLog$default$8() {
        return false;
    }

    public Option<TierPartitionState> mockLog$default$9() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public LogManager mockLogManager(Map<TopicPartition, AbstractLog> logMap) {
        void var2_2;
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        logMap.keys().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> Mockito.when((Object)mockLogManager.getLog(topicPartition, mockLogManager.getLog$default$2())).thenReturn((Object)new Some(logMap.apply(topicPartition))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaManager mockReplicaManager(LogManager logManager) {
        void var2_2;
        ReplicaManager mockReplicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)mockReplicaManager.logManager()).thenReturn((Object)logManager);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaManager mockReplicaManager(KafkaConfig config, LogManager logManager) {
        void var3_3;
        ReplicaManager mockReplicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)mockReplicaManager.config()).thenReturn((Object)config);
        Mockito.when((Object)mockReplicaManager.logManager()).thenReturn((Object)logManager);
        return var3_3;
    }

    public Seq<LogSegment> getLocalSegmentsWithGap(File logDir, long totalGapCount, long startOffset, int size) {
        LogSegment segment1 = LogTestUtils$.MODULE$.createLocalLogSegment(startOffset, startOffset + (long)size, logDir, LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6());
        long nextSegmentStartOffset = startOffset + (long)size + totalGapCount + 1L;
        LogSegment segment2 = LogTestUtils$.MODULE$.createLocalLogSegment(nextSegmentStartOffset, nextSegmentStartOffset + (long)size, logDir, LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6());
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getLocalSegmentsWithGap$default$3() {
        return 0L;
    }

    public int getLocalSegmentsWithGap$default$4() {
        return 1;
    }

    public Seq<TierLogSegment> getTieredSegmentsWithGap(TopicPartition topicPartition, TierObjectStore objStore, long totalGapCount, long startOffset) {
        TopicIdPartition tid = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierLogSegment segment1 = LogTestUtils$.MODULE$.createTierLogSegment(tid, startOffset, startOffset + 999L, objStore, LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8());
        long nextSegmentStartOffset = startOffset + 1000L + totalGapCount;
        TierLogSegment segment2 = LogTestUtils$.MODULE$.createTierLogSegment(tid, nextSegmentStartOffset, nextSegmentStartOffset + 999L, objStore, LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8());
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getTieredSegmentsWithGap$default$4() {
        return 0L;
    }

    public Seq<LogSegment> getLocalSegmentsWithoutGap(File logDir, long startOffset) {
        LogSegment segment1 = LogTestUtils$.MODULE$.createLocalLogSegment(startOffset, startOffset + 1L, logDir, LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6());
        long nextSegmentStartOffset = startOffset + 2L;
        LogSegment segment2 = LogTestUtils$.MODULE$.createLocalLogSegment(nextSegmentStartOffset, nextSegmentStartOffset + 1L, logDir, LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6());
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getLocalSegmentsWithoutGap$default$2() {
        return 0L;
    }

    public Seq<TierLogSegment> getTieredSegmentsWithoutGap(TopicPartition topicPartition, TierObjectStore objStore, long startOffset) {
        TopicIdPartition tid = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierLogSegment segment1 = LogTestUtils$.MODULE$.createTierLogSegment(tid, startOffset, startOffset + 999L, objStore, LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8());
        long nextSegmentStartOffset = startOffset + 1000L;
        TierLogSegment segment2 = LogTestUtils$.MODULE$.createTierLogSegment(tid, nextSegmentStartOffset, nextSegmentStartOffset + 999L, objStore, LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6(), LogTestUtils$.MODULE$.createTierLogSegment$default$7(), LogTestUtils$.MODULE$.createTierLogSegment$default$8());
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getTieredSegmentsWithoutGap$default$3() {
        return 0L;
    }

    public MetricName metricName(String name, Metrics metrics) {
        return (MetricName)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricName$1(name, x$1))))).head();
    }

    public MetricName metricNameWithTag(String name, String tag, Metrics metrics) {
        return (MetricName)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricNameWithTag$1(name, x$2))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricNameWithTag$2(tag, x$3))))).head();
    }

    public static final /* synthetic */ boolean $anonfun$mockTierPartitionState$2(Long offset$1, TierLogSegment s) {
        return s.baseOffset() <= Predef$.MODULE$.Long2long(offset$1) && s.endOffset() >= Predef$.MODULE$.Long2long(offset$1);
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$mockLog$1(MergedLog mockLog$1, long start) {
        return Mockito.when((Object)BoxesRunTime.boxToLong((long)mockLog$1.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)start));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$mockLog$2(MergedLog mockLog$1, long end) {
        return Mockito.when((Object)BoxesRunTime.boxToLong((long)mockLog$1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)end));
    }

    public static final /* synthetic */ boolean $anonfun$metricName$1(String name$1, Object x$1) {
        return ((MetricName)x$1).name().equals(name$1);
    }

    public static final /* synthetic */ boolean $anonfun$metricNameWithTag$1(String name$2, Object x$2) {
        return ((MetricName)x$2).name().equals(name$2);
    }

    public static final /* synthetic */ boolean $anonfun$metricNameWithTag$2(String tag$1, Object x$3) {
        return ((MetricName)x$3).tags().containsValue(tag$1);
    }

    private DurabilityTestUtils$() {
        MODULE$ = this;
        this.offset = 0;
        this.internalAdminSupplier = new Supplier<InternalAdmin>(){

            public InternalAdmin get() {
                return (InternalAdmin)Mockito.mock(InternalAdmin.class);
            }
        };
    }
}

