/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.AuditRunState$;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.tools.DumpDB$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00048\u0001\u0001\u0006I\u0001\f\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019A\u0005\u0001)A\u0005u!9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB*\u0001A\u0003%1\nC\u0004U\u0001\t\u0007I\u0011\u0001&\t\rU\u0003\u0001\u0015!\u0003L\u0011\u001d1\u0006A1A\u0005\u0002]Caa\u0017\u0001!\u0002\u0013A\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u000b\t\u0004A\u0011A2\t\u000bI\u0004A\u0011A2\t\u000b]\u0004A\u0011A2\t\u000be\u0004A\u0011A2\t\u000bm\u0004A\u0011A2\t\u000bu\u0004A\u0011A2\t\u000b}\u0004A\u0011A2\t\r\u0005\r\u0001\u0001\"\u0001d\u0011\u0019\t9\u0001\u0001C\u0001G\n\u0001B)\u001e:bE&d\u0017\u000e^=E\u0005R+7\u000f\u001e\u0006\u00033i\t!\u0001\u001a2\u000b\u0005ma\u0012A\u00033ve\u0006\u0014\u0017\u000e\\5us*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00021\u0005\u0011A\u000f]\u000b\u0002YA\u0011Q&N\u0007\u0002])\u0011q\u0006M\u0001\u0007G>lWn\u001c8\u000b\u0005u\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!A\u000e\u0018\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u0015\u0015\u0004xn\u00195DQ\u0006Lg.F\u0001;!\u0011Y\u0004IQ#\u000e\u0003qR!!\u0010 \u0002\u000f5,H/\u00192mK*\u0011qHI\u0001\u000bG>dG.Z2uS>t\u0017BA!=\u0005\u001dA\u0015m\u001d5NCB\u0004\"!I\"\n\u0005\u0011\u0013#aA%oiB\u0011\u0011ER\u0005\u0003\u000f\n\u0012A\u0001T8oO\u0006YQ\r]8dQ\u000eC\u0017-\u001b8!\u0003\u0019!X\u000e\u001d#jeV\t1\n\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006\u0011\u0011n\u001c\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005\u0011\u0011m]\u000b\u00021B\u0011\u0011&W\u0005\u00035b\u0011Q\"Q;eSR\u0014VO\\*uCR,\u0017aA1tA\u0005\u0011\u0001o]\u000b\u0002=B\u0011\u0011fX\u0005\u0003Ab\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X-A\u0002qg\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002IB\u0011\u0011%Z\u0005\u0003M\n\u0012A!\u00168ji\"\u0012a\u0002\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f1!\u00199j\u0015\tig.A\u0004kkBLG/\u001a:\u000b\u0005=\u001c\u0014!\u00026v]&$\u0018BA9k\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000bEkJ\f'-\u001b7jif$%)\u00138jiR+7\u000f\u001e\u0015\u0003\u001fQ\u0004\"![;\n\u0005YT'\u0001\u0002+fgR\fA\u0006R;sC\nLG.\u001b;z\t\n\u001bVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005A!\u0018!\b#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013\u0015J\\5u\u0007\",7m\u001b)pS:$\u0018N\\4)\u0005E!\u0018a\u0006#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013U)\u001c9us\u0012\u0013e)\u001b7fQ\t\u0011B/A\u0012EkJ\f'-\u001b7jif$%)T;mi&\u0004H.\u001a)beRLG/[8o+B$\u0017\r^3)\u0005M!\u0018!G!Q\u0013\u0006\u001b7-Z:t\u0013:Le.\u001b;Ti\u0006$Xo\u001d+fgRD#\u0001\u0006;\u0002\u001f\u0011+G.\u001a;f!\u0006\u0014H/\u001b;j_:D#!\u0006;\u0002\u0015\u0011+X\u000e\u001d#c)\u0016\u001cH\u000f\u000b\u0002\u0017i\u0002")
public class DurabilityDBTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final AuditRunState as = AuditRunState$.MODULE$.apply();
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L, this.as());

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public AuditRunState as() {
        return this.as;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void DurabilityDBInitTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        Assertions.assertTrue((boolean)db.header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))), (String)"Database failed to initialize");
        Assertions.assertEquals((int)db.topicStates().size(), (int)0, (String)"Database failed to initialize");
    }

    @Test
    public void DurabilityDBSerializationDeserializationTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        DurabilityDB newDB = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)newDB.header().equals((Object)db.header()), (String)"Check-pointing and recovery of db not consistent");
        Assertions.assertEquals((Object)newDB.fetchPartitionState(this.tp()).get(), (Object)this.ps(), (String)"PartitionState not preserved after recovery");
    }

    @Test
    public void DurabilityDBInitCheckPointing() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)db.header().equals((Object)newDb.header()), (String)"Inconsistent db after check pointing in empty state");
        Assertions.assertEquals((Object)newDb.topicStates(), (Object)db.topicStates(), (String)"Inconsistent db after check pointing in empty state");
    }

    @Test
    public void DurabilityDBEmptyDBFile() {
        DurabilityDB$.MODULE$.apply(this.logDir()).dbFile().createNewFile();
        Assertions.assertTrue((boolean)DurabilityDB$.MODULE$.apply(this.logDir()).header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))), (String)"Database not in empty state");
    }

    @Test
    public void DurabilityDBMultiplePartitionUpdate() {
        ObjectRef db = ObjectRef.create((Object)DurabilityDB$.MODULE$.apply(this.logDir()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4000).foreach((Function1 & Serializable & scala.Serializable)ii -> DurabilityDBTest.$anonfun$DurabilityDBMultiplePartitionUpdate$1(this, db, BoxesRunTime.unboxToInt((Object)ii)));
        ((DurabilityDB)db.elem).close();
        db.elem = DurabilityDB$.MODULE$.apply(this.logDir());
        Seq committed = ((DurabilityDB)db.elem).getDurabilityTopicPartitionOffsets();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ii -> {
            TopicPartition id = new TopicPartition(this.tp().topic(), ii);
            Assertions.assertEquals((long)((PartitionState)((DurabilityDB)db$1.elem).fetchPartitionState(id).get()).startOffset(), (long)ii, (String)new StringBuilder(45).append("Failed to get last valid state for partition ").append(ii).toString());
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)committed.apply(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT())), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()), (String)new StringBuilder(54).append("Failed to fetch latest committed offset for partition ").append(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()).toString());
        });
    }

    @Test
    public void APIAccessInInitStatusTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.status_$eq(DbStatus$.MODULE$.Init());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> db.addPartition(this.tp(), this.ps()), ClassTag$.MODULE$.apply(DurabilityDBNotReadyException.class), new Position("DurabilityDBTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    @Test
    public void DeletePartition() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        TopicPartition id = new TopicPartition(this.tp().topic(), 2);
        PartitionState ps2 = PartitionState$.MODULE$.apply(2, 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L, this.as());
        db.addPartition(id, ps2);
        Assertions.assertTrue((boolean)((PartitionState)db.fetchPartitionState(this.tp()).get()).equals((Object)this.ps()), (String)"Fetch for partition failed");
        db.deletePartition(this.tp());
        Assertions.assertEquals((Object)db.fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
        db.close();
        Assertions.assertEquals((Object)DurabilityDB$.MODULE$.apply(this.logDir()).fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
    }

    @Test
    public void DumpDbTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), this.tp().topic(), Integer.toString(this.tp().partition())).startsWith(new StringBuilder(7).append("Topic: ").append(this.tp().topic()).toString()));
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), this.tp().topic(), "123").contains("DB doesn't contain partition"));
        Assertions.assertTrue((boolean)DurabilityDBTest.dumpOutput$1(this.logDir(), "invalid-topic", "123").contains("DB doesn't contain Topic"));
    }

    public static final /* synthetic */ Option $anonfun$DurabilityDBMultiplePartitionUpdate$1(DurabilityDBTest $this, ObjectRef db$1, int ii) {
        TopicPartition id = new TopicPartition($this.tp().topic(), ii);
        PartitionState ps = PartitionState$.MODULE$.apply(id.partition(), (long)ii, 100L, 0L, 2L, 100L, 3600L, 1024L, $this.epochChain(), Uuid.randomUuid(), 0L, $this.as());
        ((DurabilityDB)db$1.elem).updateDurabilityTopicPartitionOffset(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()));
        return ((DurabilityDB)db$1.elem).addPartition(id, ps);
    }

    private static final String dumpOutput$1(File logDir, String topic, String partition) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpDB$.MODULE$.dump(logDir, topic, partition));
        return out.toString();
    }
}

