/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.AuditRunState$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.db.serdes.EpochChain;
import kafka.durability.db.serdes.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0004\b\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0003BB\u0017\u0001A\u0003%!\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\t\ry\u0002\u0001\u0015!\u00031\u0011\u001dy\u0004A1A\u0005\u0002\u0001Ca\u0001\u0012\u0001!\u0002\u0013\t\u0005bB#\u0001\u0005\u0004%\tA\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B$\t\u000b-\u0003A\u0011\u0001'\t\u000bm\u0003A\u0011\u0001'\t\u000bu\u0003A\u0011\u0001'\u0003%A\u000b'\u000f^5uS>t7\u000b^1uKR+7\u000f\u001e\u0006\u0003\u001fA\t!\u0001\u001a2\u000b\u0005E\u0011\u0012A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u001d\u0005\u0011A\u000f]\u000b\u0002EA\u00111eK\u0007\u0002I)\u0011QEJ\u0001\u0007G>lWn\u001c8\u000b\u0005M9#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u0015\u0015\u0004xn\u00195DQ\u0006Lg.F\u00011!\u0011\td\u0007O\u001e\u000e\u0003IR!a\r\u001b\u0002\u000f5,H/\u00192mK*\u0011Q\u0007G\u0001\u000bG>dG.Z2uS>t\u0017BA\u001c3\u0005\u001dA\u0015m\u001d5NCB\u0004\"aF\u001d\n\u0005iB\"aA%oiB\u0011q\u0003P\u0005\u0003{a\u0011A\u0001T8oO\u0006YQ\r]8dQ\u000eC\u0017-\u001b8!\u0003)\tW\u000fZ5u'R\fG/Z\u000b\u0002\u0003B\u0011qDQ\u0005\u0003\u0007:\u0011Q\"Q;eSR\u0014VO\\*uCR,\u0017aC1vI&$8\u000b^1uK\u0002\n!\u0001]:\u0016\u0003\u001d\u0003\"a\b%\n\u0005%s!A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013A\u0005)beRLG/[8o'R\fG/\u001a+fgR$\u0012!\u0014\t\u0003/9K!a\u0014\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0015E\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\u0007\u0005\u0004\u0018N\u0003\u0002W/\u00069!.\u001e9ji\u0016\u0014(B\u0001-*\u0003\u0015QWO\\5u\u0013\tQ6K\u0001\u0003UKN$\u0018\u0001J(mIB\u000b'\u000f^5uS>t7\u000b^1uK\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005-\t\u0016\u0001\n(foB\u000b'\u000f^5uS>t7\u000b^1uK\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u00051\t\u0006")
public class PartitionStateTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final AuditRunState auditState = AuditRunState$.MODULE$.apply(500L, 10, "audit-1", 1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{UUID.randomUUID(), UUID.randomUUID()})));
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L, this.auditState());

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public AuditRunState auditState() {
        return this.auditState;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @Test
    public void PartitionStateTest() {
        PartitionState orig = this.ps();
        Assertions.assertEquals((long)this.ps().highWatermark(), (long)orig.highWatermark());
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        builder.finish(orig.serialize(builder));
        PartitionState dup = PartitionState$.MODULE$.apply(PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer()));
        Assertions.assertEquals((Object)orig, (Object)dup, (String)"PartitionState not consistent after recovery");
    }

    @Test
    public void OldPartitionStateDeserializationTest() {
        PartitionState orig = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.ZERO_UUID, 0L, AuditRunState$.MODULE$.apply());
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        PartitionInfo.startEpochChainVector((FlatBufferBuilder)builder, (int)this.epochChain().size());
        this.epochChain().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PartitionStateTest.$anonfun$OldPartitionStateDeserializationTest$1(builder, x0$1)));
        int epochChainsOffset = builder.endVector();
        builder.startTable(10);
        PartitionInfo.addRetentionSize((FlatBufferBuilder)builder, (long)orig.retentionSz());
        PartitionInfo.addRetentionTime((FlatBufferBuilder)builder, (long)orig.retentionMs());
        PartitionInfo.addTotalMessages((FlatBufferBuilder)builder, (long)orig.totalMessages());
        PartitionInfo.addExternalLostMessages((FlatBufferBuilder)builder, (long)orig.externalLostMessages());
        PartitionInfo.addCommittedStartOffset((FlatBufferBuilder)builder, (long)orig.committedStartOffset());
        PartitionInfo.addHighWatermark((FlatBufferBuilder)builder, (long)orig.highWatermark());
        PartitionInfo.addStartOffset((FlatBufferBuilder)builder, (long)orig.startOffset());
        PartitionInfo.addEpochChain((FlatBufferBuilder)builder, (int)epochChainsOffset);
        PartitionInfo.addPartition((FlatBufferBuilder)builder, (int)orig.partition());
        builder.finish(PartitionInfo.endPartitionInfo((FlatBufferBuilder)builder));
        PartitionState dup = PartitionState$.MODULE$.apply(PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer()));
        Assertions.assertEquals((Object)orig, (Object)dup);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void NewPartitionStateDeserializationTest() {
        topicId = Uuid.randomUuid();
        orig = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), topicId, 0L, this.auditState());
        Assertions.assertEquals((long)this.ps().highWatermark(), (long)orig.highWatermark());
        builder = new FlatBufferBuilder(1024);
        builder.finish(orig.serialize(builder));
        state = PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer());
        epochChainMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), state.epochChainLength() - 1).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$NewPartitionStateDeserializationTest$1$adapted(scala.collection.mutable.HashMap kafka.durability.db.serdes.PartitionInfo java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)((HashMap)epochChainMap, (PartitionInfo)state));
        if (this.ps().partition() != state.partition() || this.ps().startOffset() != state.startOffset() || this.ps().highWatermark() != state.highWatermark() || this.ps().committedStartOffset() != state.committedStartOffset() || this.ps().externalLostMessages() != state.externalLostMessages() || this.ps().totalMessages() != state.totalMessages() || this.ps().retentionMs() != state.retentionTime() || this.ps().retentionSz() != state.retentionSize()) ** GOTO lbl-1000
        v0 = this.ps().epochChain();
        if (!(v0 != null ? v0.equals(epochChainMap) == false : epochChainMap != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
    }

    public static final /* synthetic */ int $anonfun$OldPartitionStateDeserializationTest$1(FlatBufferBuilder builder$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int k = x0$1._1$mcI$sp();
        long v = x0$1._2$mcJ$sp();
        int n = EpochChain.createEpochChain((FlatBufferBuilder)builder$1, (int)k, (long)v);
        return n;
    }

    public static final /* synthetic */ Option $anonfun$NewPartitionStateDeserializationTest$1$adapted(HashMap epochChainMap$1, PartitionInfo state$1, Object ii) {
        return epochChainMap$1.put((Object)BoxesRunTime.boxToInteger((int)state$1.epochChain(BoxesRunTime.unboxToInt((Object)ii)).epoch()), (Object)BoxesRunTime.boxToLong((long)state$1.epochChain(BoxesRunTime.unboxToInt((Object)ii)).start()));
    }
}

