/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.AuditRunState$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.materialization.Validator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001\u0002 @\u0001\u0019CQ!\u0014\u0001\u0005\u00029C\u0011\"\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002*\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0007\"\u00034\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"I!\u000f\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\t\u0013q\u0004\u0001\u0019!A!B\u0013)\b\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%I!!\u0004\t\u0015\u0005E\u0001\u00011A\u0001B\u0003&q\u0010C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0018!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0016\u0011-\ti\u0004\u0001a\u0001\u0002\u0004%I!a\u0010\t\u0017\u0005\r\u0003\u00011A\u0001B\u0003&\u0011Q\u0006\u0005\f\u0003\u000b\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0005C\u0006\u0002Z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0003bCA0\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\t\u0011\u00055\u0004\u0001)A\u0005\u0003KB\u0011\"a\u001c\u0001\u0005\u0004%I!a\u0019\t\u0011\u0005E\u0004\u0001)A\u0005\u0003KB\u0011\"a\u001d\u0001\u0005\u0004%I!!\u001e\t\u0011\u0005u\u0004\u0001)A\u0005\u0003oB\u0011\"a \u0001\u0005\u0004%I!!!\t\u0011\u0005}\u0005\u0001)A\u0005\u0003\u0007C\u0011\"!)\u0001\u0005\u0004%I!a)\t\u0011\u0005-\u0006\u0001)A\u0005\u0003KC\u0011\"!,\u0001\u0005\u0004%I!a,\t\u0011\u0005]\u0006\u0001)A\u0005\u0003cC\u0011\"!/\u0001\u0005\u0004%\t!a/\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003{C\u0011\"!2\u0001\u0005\u0004%\t!a2\t\u0011\u0005\u001d\b\u0001)A\u0005\u0003\u0013D1\"!;\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002l\"Y\u0011q\u001f\u0001A\u0002\u0003\u0007I\u0011AA}\u0011-\ti\u0010\u0001a\u0001\u0002\u0003\u0006K!!<\t\u0017\u0005}\b\u00011AA\u0002\u0013\u0005!\u0011\u0001\u0005\f\u0005\u0013\u0001\u0001\u0019!a\u0001\n\u0003\u0011Y\u0001C\u0006\u0003\u0010\u0001\u0001\r\u0011!Q!\n\t\r\u0001b\u0003B\t\u0001\u0001\u0007\t\u0019!C\u0001\u0005'A1B!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003$!Y!q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u000b\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqAa\u0011\u0001\t\u0003\u0011Y\u0003C\u0004\u0003N\u0001!\tAa\u000b\t\u000f\t]\u0003\u0001\"\u0001\u0003,!9!1\f\u0001\u0005\u0002\t-\u0002b\u0002B0\u0001\u0011\u0005!1\u0006\u0005\b\u0005G\u0002A\u0011\u0001B\u0016\u0011\u001d\u00119\u0007\u0001C\u0001\u0005WAqAa\u001b\u0001\t\u0003\u0011Y\u0003C\u0004\u0003p\u0001!\tAa\u000b\t\u000f\tM\u0004\u0001\"\u0001\u0003,!9!q\u000f\u0001\u0005\u0002\t-\u0002b\u0002B>\u0001\u0011\u0005!1\u0006\u0005\b\u0005\u007f\u0002A\u0011\u0001B\u0016\u0005}!UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{KR+7\u000f\u001e\u0006\u0003\u0001\u0006\u000bq\"\\1uKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u0005\u000e\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005!\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001P!\t\u0001\u0006!D\u0001@\u0003\u001diW\r\u001e:jGN,\u0012a\u0015\t\u0003)vk\u0011!\u0016\u0006\u0003#ZS!a\u0016-\u0002\r\r|W.\\8o\u0015\t!\u0015L\u0003\u0002[7\u00061\u0011\r]1dQ\u0016T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010V\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011\u0011\r\u001a\t\u0003\u0011\nL!aY%\u0003\tUs\u0017\u000e\u001e\u0005\bK\u000e\t\t\u00111\u0001T\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005A!/\u001a9peR,'/F\u0001j!\tQW.D\u0001l\u0015\ta\u0017)A\u0003bk\u0012LG/\u0003\u0002oW\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fAB]3q_J$XM]0%KF$\"!Y9\t\u000f\u00154\u0011\u0011!a\u0001S\u0006I!/\u001a9peR,'\u000fI\u0001\t[6\u000bg.Y4feV\tQ\u000f\u0005\u0002wo6\t\u0011)\u0003\u0002y\u0003\nAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\u00195l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005\\\bbB3\n\u0003\u0003\u0005\r!^\u0001\n[6\u000bg.Y4fe\u0002\nA\u0001^5nKV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AV\u0001\u0006kRLGn]\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0003US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0007\u0005\fy\u0001C\u0004f\u0019\u0005\u0005\t\u0019A@\u0002\u000bQLW.\u001a\u0011\u0002\u0005\u0011\u0014WCAA\f!\u0011\tI\"!\b\u000e\u0005\u0005m!bAA\n\u0003&!\u0011qDA\u000e\u00051!UO]1cS2LG/\u001f#C\u0003\u0019!'m\u0018\u0013fcR\u0019\u0011-!\n\t\u0011\u0015|\u0011\u0011!a\u0001\u0003/\t1\u0001\u001a2!\u0003\u0019!X\u000e\u001d#jeV\u0011\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\tIwN\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$!\r\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fHcA1\u0002B!AQMEA\u0001\u0002\u0004\ti#A\u0004u[B$\u0015N\u001d\u0011\u0002\u0019QLWM](cUN#xN]3\u0016\u0005\u0005%\u0003\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0006gR|'/\u001a\u0006\u0004\u0003'\u001a\u0015\u0001\u0002;jKJLA!a\u0016\u0002N\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\tuS\u0016\u0014xJ\u00196Ti>\u0014Xm\u0018\u0013fcR\u0019\u0011-!\u0018\t\u0011\u0015,\u0012\u0011!a\u0001\u0003\u0013\nQ\u0002^5fe>\u0013'n\u0015;pe\u0016\u0004\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0003\u0003K\u0002B!a\u001a\u0002j5\ta+C\u0002\u0002lY\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0006{KJ|Gk\u001c9jG&#\u0017\u0001\u0004>fe>$v\u000e]5d\u0013\u0012\u0004\u0013a\u0001;qcU\u0011\u0011q\u000f\t\u0005\u0003O\nI(C\u0002\u0002|Y\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u000bKB|7\r[\"iC&tWCAAB!!\t))a$\u0002\u0014\u0006eUBAAD\u0015\u0011\tI)a#\u0002\u000f5,H/\u00192mK*\u0019\u0011QR%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0006\u001d%a\u0002%bg\"l\u0015\r\u001d\t\u0004\u0011\u0006U\u0015bAAL\u0013\n\u0019\u0011J\u001c;\u0011\u0007!\u000bY*C\u0002\u0002\u001e&\u0013A\u0001T8oO\u0006YQ\r]8dQ\u000eC\u0017-\u001b8!\u0003\t\t7/\u0006\u0002\u0002&B!\u0011\u0011DAT\u0013\u0011\tI+a\u0007\u0003\u001b\u0005+H-\u001b;Sk:\u001cF/\u0019;f\u0003\r\t7\u000fI\u0001\u0003aN,\"!!-\u0011\t\u0005e\u00111W\u0005\u0005\u0003k\u000bYB\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\u0002\u0007A\u001c\b%\u0001\u0003ua&#WCAA_!\u0011\ty,!1\u000e\u0005\u0005E\u0013\u0002BA>\u0003#\nQ\u0001\u001e9JI\u0002\nA\u0002\\8dC2|eMZ:fiN,\"!!3\u0011\r\u0005-\u00171\\Aq\u001d\u0011\ti-a6\u000f\t\u0005=\u0017Q[\u0007\u0003\u0003#T1!a5F\u0003\u0019a$o\\8u}%\t!*C\u0002\u0002Z&\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002^\u0006}'aA*fc*\u0019\u0011\u0011\\%\u0011\u000f!\u000b\u0019/!'\u0002\u001a&\u0019\u0011Q]%\u0003\rQ+\b\u000f\\33\u00035awnY1m\u001f\u001a47/\u001a;tA\u0005\u0019An\\4\u0016\u0005\u00055\b\u0003BAx\u0003gl!!!=\u000b\u0007\u0005%8)\u0003\u0003\u0002v\u0006E(aC!cgR\u0014\u0018m\u0019;M_\u001e\fq\u0001\\8h?\u0012*\u0017\u000fF\u0002b\u0003wD\u0001\"\u001a\u0015\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0005Y><\u0007%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"Aa\u0001\u0011\t\u0005=(QA\u0005\u0005\u0005\u000f\t\tP\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002b\u0005\u001bA\u0001\"Z\u0016\u0002\u0002\u0003\u0007!1A\u0001\fY><W*\u00198bO\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\tU\u0001\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm1)\u0001\u0004tKJ4XM]\u0005\u0005\u0005?\u0011IB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0004C\n\u0015\u0002\u0002C3/\u0003\u0003\u0005\rA!\u0006\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nQa]3u+B$\u0012!\u0019\u0015\u0004a\t=\u0002\u0003\u0002B\u0019\u0005\u007fi!Aa\r\u000b\t\tU\"qG\u0001\u0004CBL'\u0002\u0002B\u001d\u0005w\tqA[;qSR,'OC\u0002\u0003>m\u000bQA[;oSRLAA!\u0011\u00034\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!\rB$!\u0011\u0011\tD!\u0013\n\t\t-#1\u0007\u0002\n\u0003\u001a$XM]#bG\"\fq\u0004^3tiNk\u0017\r\u001c7fe\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3tQ\r\u0011$\u0011\u000b\t\u0005\u0005c\u0011\u0019&\u0003\u0003\u0003V\tM\"\u0001\u0002+fgR\fa\u0004^3ti2\u000b'oZ3s\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:)\u0007M\u0012\t&A\u000euKN$(+\u001a6fGRLwN\\(g'R\fG.\u001a*fG>\u0014Hm\u001d\u0015\u0004i\tE\u0013\u0001\b;fgRD\u0015M\u001c3mKN#\u0018\r\\3EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0004k\tE\u0013a\u0005;fgR$U\r\\3uKB\u000b'\u000f^5uS>t\u0007f\u0001\u001c\u0003R\u0005\u0011C/Z:u\u001b&\u001c8/\u001b8h\t\u0016dW\r^3QCJ$\u0018\u000e^5p]J+7m\u001c<fefD3a\u000eB)\u0003a!Xm\u001d;Fa>\u001c\u0007n\u00115bS:4\u0016\r\\5eCRLwN\u001c\u0015\u0004q\tE\u0013\u0001\t;fgR$\u0016.\\3CCN,GMU3uK:$\u0018n\u001c8WC2LG-\u0019;j_:D3!\u000fB)\u0003q\"Xm\u001d;US6,')Y:fIJ+G/\u001a8uS>tg+\u00197jI\u0006$\u0018n\u001c8XSRDgj\u001c#fY\u0016$X\rZ*fO6,g\u000e^'fi\u0006$\u0017\r^1)\u0007i\u0012\t&\u0001\u0019uKN$H+[7f\u0005\u0006\u001cX\r\u001a*fi\u0016tG/[8o-\u0006d\u0017\u000eZ1uS>tw+\u001b;i+N,'\u000fR3mKRLwN\u001c\u0015\u0004w\tE\u0013A\u0007;fgRl\u0015n]:j]\u001e$U\r\\3uKB\u000b'\u000f^5uS>t\u0007f\u0001\u001f\u0003R\u0005aB/Z:u'R\fG.Z#wK:$x+\u001b;i_V$Hk\u001c9jG&#\u0007fA\u001f\u0003R\u0001")
public class DurabilityEventsMaterializeTest {
    private Metrics metrics;
    private AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    private DurabilityMetricsManager mManager;
    private Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    private DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    private File tmpDir;
    private TierObjectStore tierObjStore;
    private final Uuid topicId = Uuid.randomUuid();
    private final Uuid zeroTopicId = Uuid.ZERO_UUID;
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), new TopicPartition("t1", 1));
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))}));
    private final AuditRunState as = AuditRunState$.MODULE$.apply();
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 0L, 40L, 0L, 0L, 0L, 36000000L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L, this.as());
    private final kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
    private final Seq<Tuple2<Object, Object>> localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    private AbstractLog log;
    private LogManager logManager;
    private ReplicaManager replicaManager;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    public Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq(Time x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time = x$1;
    }

    public DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DurabilityDB x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db = x$1;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    private TierObjectStore tierObjStore() {
        return this.tierObjStore;
    }

    private void tierObjStore_$eq(TierObjectStore x$1) {
        this.tierObjStore = x$1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private Uuid zeroTopicId() {
        return this.zeroTopicId;
    }

    private TopicIdPartition tp1() {
        return this.tp1;
    }

    private HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    private AuditRunState as() {
        return this.as;
    }

    private PartitionState ps() {
        return this.ps;
    }

    public kafka.tier.TopicIdPartition tpId() {
        return this.tpId;
    }

    public Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time()));
        this.mManager_$eq(new DurabilityMetricsManager("0", this.metrics(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter$.MODULE$.apply(this.mManager()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.tierObjStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6()));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db());
        Utils.delete((File)this.tmpDir());
        this.tierObjStore().close();
    }

    @Test
    public void testSmallerHighWatermarkChanges() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$1;
            }
        };
        materialize.materializeHighWatermarkChanges(this.tp1().topicPartition(), 2, 30L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)10L, (long)lapse);
        Assertions.assertEquals((long)10L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testLargerHighWatermarkChanges() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$2;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
    }

    @Test
    public void testRejectionOfStaleRecords() {
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.topicId(), 0L, this.as());
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$3;
            }
        };
        RetentionChangeEvent event1 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 500L, -1L, 1, -1L, -1L);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        RetentionChangeEvent event2 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 2, -1L, -1L);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 200L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        RetentionChangeEvent event3 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 3, -1L, -1L);
        ConsumerRecord record3 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event3.serializeKey(), (Object)event3.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record3));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testHandleStaleDeleteRecords() {
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().partition(), 5L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.tp1().topicId(), 0L, this.as());
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$4;
            }
        };
        DeleteRecordsEvent event = DeleteRecordsEvent$.MODULE$.apply(this.tp1(), 15L, 1, 60L, 1L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        ConsumerRecord record = new ConsumerRecord(this.tp1().topic(), this.tp1().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event.serializeKey(), (Object)event.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record));
        Predef$.MODULE$.assert(ps1.committedStartOffset() == 15L);
        Predef$.MODULE$.assert(ps1.highWatermark() == 100L);
        Predef$.MODULE$.assert(ps1.latestEpoch() == 2);
        Predef$.MODULE$.assert(ps1.startOffset() == 5L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletePartition() {
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this.replicaManager(), testAuditManager.instance().db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        DeletePartitionEvent evt = DeletePartitionEvent$.MODULE$.apply(this.tp1(), 3);
        materialize.materializeDeletePartition(evt);
        Assertions.assertEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
    }

    @Test
    public void testMissingDeletePartitionRecovery() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$5;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
        EpochChangeEvent epochChangeEvent = EpochChangeEvent$.MODULE$.apply(tp, 0L, 0, 0, 0L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)epochChangeEvent, this.ps());
        materialize.materializeEpochChangeEvent(epochChangeEvent, this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 0, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeEpochChangeEvent(EpochChangeEvent$.MODULE$.apply(tp, 0L, 0, 0, 80L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)101L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testEpochChainValidation() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)props, KafkaConfig$.MODULE$.apply$default$2());
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(config, logManager);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(replicaManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        IsrExpandEvent evt = IsrExpandEvent$.MODULE$.apply(tp, 1, 3, this.ps().highWatermark(), this.ps().committedStartOffset());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException();
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = Nil$.MODULE$;
                this.file = TestUtils$.MODULE$.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp.topicPartition(), checkpoint);
        cache.assign(0, 0L);
        cache.assign(1, 11L);
        cache.assign(2, 21L);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)Option$.MODULE$.apply((Object)cache));
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        cache.assign(2, 15L);
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testTimeBasedRetentionValidation() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierObjectMetadata.State x$14 = LogTestUtils$.MODULE$.createTierLogSegment$default$8();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13, x$14);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$6;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 1L)));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)5L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 20L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple22 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapse2 = tuple22._2$mcJ$sp();
        Assertions.assertEquals((long)15L, (long)lapse2);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)20L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 21L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple23 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long lapse3 = tuple23._2$mcJ$sp();
        Assertions.assertEquals((long)16L, (long)lapse3);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)21L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 25L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        RetentionChangeEvent evt2 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, this.ps().latestEpoch(), -1L, -1L);
        materialize.materializeRetentionChangeEvent(evt2, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 30L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithNoDeletedSegmentMetadata() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierObjectMetadata.State x$14 = LogTestUtils$.MODULE$.createTierLogSegment$default$8();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13, x$14);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$7;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 221L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)221L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithUserDeletion() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierObjectMetadata.State x$14 = LogTestUtils$.MODULE$.createTierLogSegment$default$8();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13, x$14);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        DurabilityDB db = (DurabilityDB)Mockito.mock(DurabilityDB.class);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, db, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$8;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.ps().highWatermark()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        DeleteRecordsEvent delEvent = DeleteRecordsEvent$.MODULE$.apply(this.tp1(), 5L, this.ps().latestEpoch(), this.ps().highWatermark(), 0L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        materialize.materializeDeleteRecordEvent(delEvent, this.ps(), materialize.materializeDeleteRecordEvent$default$3(), materialize.materializeDeleteRecordEvent$default$4());
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 != null) {
            long lapse = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)0L, (long)lapse);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingDeletePartition() {
        Uuid exclusiveRandomUUID1 = Uuid.randomUuid();
        Uuid exclusiveRandomUUID2 = Uuid.randomUuid();
        while (true) {
            Uuid uuid = exclusiveRandomUUID1;
            if (uuid != null ? !uuid.equals(exclusiveRandomUUID2) : exclusiveRandomUUID2 != null) break;
            exclusiveRandomUUID2 = Uuid.randomUuid();
        }
        TopicIdPartition tt1 = new TopicIdPartition(exclusiveRandomUUID1, new TopicPartition("test-topic", 0));
        TopicIdPartition tt2 = new TopicIdPartition(exclusiveRandomUUID2, new TopicPartition("test-topic", 0));
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt1, 1, true));
        testAuditManager.instance().doWork();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        Option option = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            Assertions.assertEquals((int)1, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID1, (Object)value.topicId());
        } else {
            Predef$.MODULE$.assert(false);
        }
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt2, 2, true));
        testAuditManager.instance().doWork();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$3(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
        Option option2 = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option2 instanceof Some) {
            PartitionState value = (PartitionState)((Some)option2).value();
            Assertions.assertEquals((int)2, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID2, (Object)value.topicId());
            return;
        }
        Predef$.MODULE$.assert(false);
    }

    @Test
    public void testStaleEventWithoutTopicId() {
        TopicIdPartition zeroTp1 = new TopicIdPartition(this.zeroTopicId(), new TopicPartition(this.tp1().topic(), this.tp1().partition()));
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.topicId(), 0L, this.as());
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$9;
            }
        };
        RetentionChangeEvent event1 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 3, -1L, -1L);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
        RetentionChangeEvent event2 = RetentionChangeEvent$.MODULE$.apply(zeroTp1, 1000L, -1L, 4, -1L, -1L);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartition$1(TestAuditManager testAuditManager$1) {
        return testAuditManager$1.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$1(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$3(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$4() {
        return "";
    }
}

