/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEh!B+W\u0003\u0003Y\u0006\"\u00022\u0001\t\u0003\u0019\u0007b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000f=\u0004\u0001\u0019!C\u0001a\"9!\u0010\u0001a\u0001\n\u0003Y\bbBA\u0002\u0001\u0001\u0006K!\u001d\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\u0007\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t9\u0003\u0001C\u0001\u0003SA\u0011\"a\r\u0001\u0001\u0004%\t!!\u000e\t\u0013\u0005\r\u0003\u00011A\u0005\u0002\u0005\u0015\u0003\u0002CA%\u0001\u0001\u0006K!a\u000e\t\u0013\u0005-\u0003\u00011A\u0005\n\u00055\u0003\"CA(\u0001\u0001\u0007I\u0011BA)\u0011!\t)\u0006\u0001Q!\n\u0005u\u0002BBA,\u0001\u0019\u0005\u0001\u000fC\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\\!1\u0011q\f\u0001\u0005\u0002ADq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004\"CA[\u0001E\u0005I\u0011AA\\\u0011\u001d\ti\r\u0001C\t\u0003\u001fDq!!'\u0001\t#\t\t\u000fC\u0004\u0002d\u0002!\t\"!:\t\u000f\u0005e\b\u0001\"\u0005\u0002|\"9!1\u0002\u0001\u0005\u0012\u0005m\bb\u0002B\u0007\u0001\u0011E!q\u0002\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u001d\u0011)\u0005\u0001C\u0001\u00037BqAa\u0012\u0001\t\u0003\nY\u0006C\u0004\u0003R\u0001!\tAa\u0015\t\u0013\tu\u0003!%A\u0005\u0002\t}\u0003\"\u0003B2\u0001E\u0005I\u0011\u0001B0\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OB\u0011Ba\u001c\u0001#\u0003%\t!a.\t\u0013\tE\u0004!%A\u0005\u0002\tM\u0004b\u0002B<\u0001\u0011\u0005!\u0011\u0010\u0005\n\u00057\u0003\u0011\u0013!C\u0001\u0005;C\u0011B!)\u0001#\u0003%\tA!(\t\u0013\t\r\u0006!%A\u0005\u0002\tM\u0004\"\u0003BS\u0001E\u0005I\u0011AA\\\u0011%\u00119\u000bAI\u0001\n\u0003\u0011\u0019\bC\u0004\u0003*\u0002!\tAa+\t\u0013\tm\u0006!%A\u0005\u0002\u0005]\u0006b\u0002B<\u0001\u0011\u0005!Q\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011%\u0011i\rAI\u0001\n\u0003\t9\fC\u0004\u0003P\u0002!\tA!5\t\u000f\t=\u0007\u0001\"\u0001\u0004\u0006!9!q\u001a\u0001\u0005\u0002\r5\u0001bBB\t\u0001\u0011\u000511\u0003\u0005\b\u0007G\u0001A\u0011AB\u0013\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0007\u001bBqaa\u0015\u0001\t\u0003\u0019)\u0006C\u0004\u0004X\u0001!\ta!\u0017\t\u000f\ru\u0003\u0001\"\u0001\u0004`!91Q\r\u0001\u0005\u0002\r\u001d\u0004\"CB7\u0001E\u0005I\u0011\u0001B0\u0011\u001d\u0019y\u0007\u0001C\u0001\u0007cB\u0011ba\u001e\u0001#\u0003%\tAa\u0018\t\u000f\re\u0004\u0001\"\u0001\u0004|!91q\u0010\u0001\u0005\u0002\r\u0005\u0005bBBE\u0001\u0011\u0005\u00111\f\u0005\b\u0007\u0017\u0003A\u0011ABG\u0011%\u0019\t\nAI\u0001\n\u0003\u0011y\u0006C\u0004\u0004\u0014\u0002!\t!a\u0017\t\u000f\rU\u0005\u0001\"\u0001\u0002\\!91q\u0013\u0001\u0005\u0002\re\u0005bBBN\u0001\u0011\u00051Q\u0014\u0005\b\u0007K\u0003A\u0011ABT\u0011\u001d\u0019\t\f\u0001C\u0001\u0007gCqa!-\u0001\t\u0003\u0019)\rC\u0004\u0004H\u0002!\ta!3\t\u000f\r5\u0007\u0001\"\u0001\u0004P\"911\u001b\u0001\u0005\u0002\rU\u0007bBBm\u0001\u0011%11\u001c\u0005\b\u0007?\u0004A\u0011ABq\u0011\u001d\u0019)\u000f\u0001C\u0001\u0007ODqa!;\u0001\t\u0003\u0019Y\u000fC\u0004\u0004p\u0002!\t!a\u0017\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNT!a\u0016-\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u00023\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001]!\ti\u0006-D\u0001_\u0015\ty\u0006,\u0001\u0004tKJ4XM]\u0005\u0003Cz\u0013\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\r\u0005\u0002f\u00015\ta+A\u0007gSJ\u001cHO\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\n\u0019\u0011J\u001c;\u0002\u001d\u0019L'o\u001d;Ce>\\WM]%eA\u0005y\u0011N\\:uC:\u001cWmQ8oM&<7/F\u0001r!\r\u0011Xo^\u0007\u0002g*\u0011AO[\u0001\u000bG>dG.Z2uS>t\u0017B\u0001<t\u0005\r\u0019V-\u001d\t\u0003;bL!!\u001f0\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0014S:\u001cH/\u00198dK\u000e{gNZ5hg~#S-\u001d\u000b\u0003y~\u0004\"![?\n\u0005yT'\u0001B+oSRD\u0001\"!\u0001\u0006\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\n\u0014\u0001E5ogR\fgnY3D_:4\u0017nZ:!\u0003!y&M]8lKJ\u001cXCAA\u0005!\u0019\tY!!\u0005\u0002\u00165\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0019\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003'\tiAA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA/\u0002\u0018%\u0019\u0011\u0011\u00040\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\n?\n\u0014xn[3sg\u0002\nqA\u0019:pW\u0016\u00148/\u0006\u0002\u0002\"A1\u00111BA\u0012\u0003+IA!!\n\u0002\u000e\t1!)\u001e4gKJ\fqa]3sm\u0016\u00148/\u0006\u0002\u0002,A1\u00111BA\u0012\u0003[\u00012!XA\u0018\u0013\r\t\tD\u0018\u0002\f\u0017\u000647.Y*feZ,'/A\u0003bY&4X-\u0006\u0002\u00028A)\u0011.!\u000f\u0002>%\u0019\u00111\b6\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\fy$C\u0002\u0002B)\u0014qAQ8pY\u0016\fg.A\u0005bY&4Xm\u0018\u0013fcR\u0019A0a\u0012\t\u0013\u0005\u0005A\"!AA\u0002\u0005]\u0012AB1mSZ,\u0007%A\bd_:$(o\u001c7mKJ\fE.\u001b<f+\t\ti$A\nd_:$(o\u001c7mKJ\fE.\u001b<f?\u0012*\u0017\u000fF\u0002}\u0003'B\u0011\"!\u0001\u0010\u0003\u0003\u0005\r!!\u0010\u0002!\r|g\u000e\u001e:pY2,'/\u00117jm\u0016\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0002G\r|gNZ5hkJ,7+Z2ve&$\u0018PQ3g_J,7+\u001a:wKJ\u001c8\u000b^1siR\tA0\u0001\u0012d_:4\u0017nZ;sKN+7-\u001e:jif\fe\r^3s'\u0016\u0014h/\u001a:t'R\f'\u000f^\u0001\bG>tg-[4t\u0003-\u0019XM\u001d<fe\u001a{'/\u00133\u0015\t\u0005\u0015\u00141\u000e\t\u0006S\u0006\u001d\u0014QF\u0005\u0004\u0003SR'AB(qi&|g\u000e\u0003\u0004\u0002nU\u0001\r\u0001[\u0001\u0003S\u0012\f1B\u0019:pW\u0016\u0014hi\u001c:JIR!\u00111OA;!\u0015I\u0017qMA\u000b\u0011\u0019\tiG\u0006a\u0001Q\u0006I!m\\;oIB{'\u000f\u001e\u000b\u0004Q\u0006m\u0004BB0\u0018\u0001\u0004\ti#\u0001\tc_>$8\u000f\u001e:baN+'O^3sgR!\u0011\u0011QAL!\u0011\t\u0019)!%\u000f\t\u0005\u0015\u0015Q\u0012\t\u0004\u0003\u000fSWBAAE\u0015\r\tYIW\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=%.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\u000b)J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001fS\u0007\"CAM1A\u0005\t\u0019AAN\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\ti*!-\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bqA\\3uo>\u00148N\u0003\u0003\u0002&\u0006\u001d\u0016AB2p[6|gNC\u0002Z\u0003SSA!a+\u0002.\u00061\u0011\r]1dQ\u0016T!!a,\u0002\u0007=\u0014x-\u0003\u0003\u00024\u0006}%\u0001\u0004'jgR,g.\u001a:OC6,\u0017A\u00072p_R\u001cHO]1q'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\nTCAA]U\u0011\tY*a/,\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a2k\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\f\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0005\u0005E\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\u0005CV$\bN\u0003\u0003\u0002\\\u0006\r\u0016\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005}\u0017Q\u001b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\"!a'\u0002\u001dQ\u0014Xo\u001d;Ti>\u0014XMR5mKV\u0011\u0011q\u001d\t\u0006S\u0006\u001d\u0014\u0011\u001e\t\u0005\u0003W\f)0\u0004\u0002\u0002n*!\u0011q^Ay\u0003\tIwN\u0003\u0002\u0002t\u0006!!.\u0019<b\u0013\u0011\t90!<\u0003\t\u0019KG.Z\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0005\u0005u\b#B5\u0002h\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\t\t\u0015\u0011\u0011_\u0001\u0005kRLG.\u0003\u0003\u0003\n\t\r!A\u0003)s_B,'\u000f^5fg\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\f!B\u0019:pW\u0016\u0014H+[7f)\u0011\u0011\tB!\b\u0011\t\tM!\u0011D\u0007\u0003\u0005+QAAa\u0006\u0002$\u0006)Q\u000f^5mg&!!1\u0004B\u000b\u0005\u0011!\u0016.\\3\t\r\t}q\u00041\u0001i\u0003!\u0011'o\\6fe&#\u0017!B:fiV\u0003Hc\u0001?\u0003&!9!q\u0005\u0011A\u0002\t%\u0012\u0001\u0003;fgRLeNZ8\u0011\t\t-\"\u0011H\u0007\u0003\u0005[QAAa\f\u00032\u0005\u0019\u0011\r]5\u000b\t\tM\"QG\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u00119$!,\u0002\u000b),h.\u001b;\n\t\tm\"Q\u0006\u0002\t)\u0016\u001cH/\u00138g_\"\u001a\u0001Ea\u0010\u0011\t\t-\"\u0011I\u0005\u0005\u0005\u0007\u0012iC\u0001\u0006CK\u001a|'/Z#bG\"\facY8oGV\u0014(/\u001a8u'R\f'\u000f\u001e\"s_.,'o]\u0001\ti\u0016\f'\u000fR8x]\"\u001a!Ea\u0013\u0011\t\t-\"QJ\u0005\u0005\u0005\u001f\u0012iCA\u0005BMR,'/R1dQ\u0006y!/Z2sK\u0006$XM\u0011:pW\u0016\u00148\u000fF\u0003}\u0005+\u0012I\u0006C\u0005\u0003X\r\u0002\n\u00111\u0001\u0002>\u0005Y!/Z2p]\u001aLw-\u001e:f\u0011%\u0011Yf\tI\u0001\u0002\u0004\ti$A\u0004ti\u0006\u0014H/\u001e9\u00023I,7M]3bi\u0016\u0014%o\\6feN$C-\u001a4bk2$H%M\u000b\u0003\u0005CRC!!\u0010\u0002<\u0006I\"/Z2sK\u0006$XM\u0011:pW\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003I\u0019'/Z1uK>3gm]3ugR{\u0007/[2\u0015\u000bq\u0014IGa\u001b\t\u0013\u0005ee\u0005%AA\u0002\u0005m\u0005\"\u0003B7MA\u0005\t\u0019AA\u0000\u0003E\tG-\\5o\u00072LWM\u001c;D_:4\u0017nZ\u0001\u001dGJ,\u0017\r^3PM\u001a\u001cX\r^:U_BL7\r\n3fM\u0006,H\u000e\u001e\u00132\u0003q\u0019'/Z1uK>3gm]3ugR{\u0007/[2%I\u00164\u0017-\u001e7uII*\"A!\u001e+\t\u0005}\u00181X\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\b\u0003|\t\u001d%1\u0012BH\u0005'\u00139J!'\u0011\r\tu$1\u00115i\u001b\t\u0011yHC\u0002\u0003\u0002N\f\u0011\"[7nkR\f'\r\\3\n\t\t\u0015%q\u0010\u0002\u0004\u001b\u0006\u0004\bb\u0002BES\u0001\u0007\u0011\u0011Q\u0001\u0006i>\u0004\u0018n\u0019\u0005\t\u0005\u001bK\u0003\u0013!a\u0001Q\u0006ia.^7QCJ$\u0018\u000e^5p]ND\u0001B!%*!\u0003\u0005\r\u0001[\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\"\u0003BKSA\u0005\t\u0019AA\u0000\u0003-!x\u000e]5d\u0007>tg-[4\t\u0013\u0005e\u0015\u0006%AA\u0002\u0005m\u0005\"\u0003B7SA\u0005\t\u0019AA\u0000\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uII*\"Aa(+\u0007!\fY,A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000fJ\u001a\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*\u0014!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HEN\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0003|\t5&q\u0016B]\u0011\u001d\u0011Ii\fa\u0001\u0003\u0003CqA!-0\u0001\u0004\u0011\u0019,\u0001\u000eqCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0005\u0004s\u0005kC'qW\u0005\u0004\u0005\u000b\u001b\bc\u0001:vQ\"I\u0011\u0011T\u0018\u0011\u0002\u0003\u0007\u00111T\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134)!\u0011YHa0\u0003B\n\r\u0007b\u0002BEc\u0001\u0007\u0011\u0011\u0011\u0005\b\u0005c\u000b\u0004\u0019\u0001BZ\u0011\u001d\u0011)*\ra\u0001\u0003\u007f\f1\u0002Z3mKR,Gk\u001c9jGR)AP!3\u0003L\"9!\u0011\u0012\u001aA\u0002\u0005\u0005\u0005\"CAMeA\u0005\t\u0019AAN\u0003U!W\r\\3uKR{\u0007/[2%I\u00164\u0017-\u001e7uII\nAd^1jiVsG/\u001b7M_\u001e\u001c%/Z1uK\u0012|eN\u0011:pW\u0016\u00148/\u0006\u0003\u0003T\neH#\u0002?\u0003V\n\u0005\bb\u0002Bli\u0001\u0007!\u0011\\\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011YN!8\u000e\u0005\u0005\r\u0016\u0002\u0002Bp\u0003G\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u001eQ\u0002\rAa9\u0011\r\t\u0015(q\u001eB{\u001d\u0011\u00119Oa;\u000f\t\u0005\u001d%\u0011^\u0005\u0002W&\u0019!Q\u001e6\u0002\u000fA\f7m[1hK&!!\u0011\u001fBz\u0005!IE/\u001a:bE2,'b\u0001BwUB!!q\u001fB}\u0019\u0001!qAa?5\u0005\u0004\u0011iPA\u0001C#\u0011\u0011y0!\u0006\u0011\u0007%\u001c\t!C\u0002\u0004\u0004)\u0014qAT8uQ&tw\rF\u0003}\u0007\u000f\u0019I\u0001C\u0004\u0003\nV\u0002\r!!!\t\r\r-Q\u00071\u0001i\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0015\u0007q\u001cy\u0001C\u0004\u0003XZ\u0002\rA!7\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001cHCAB\u000b!\u0011\u0011Xoa\u0006\u0011\t\re1qD\u0007\u0003\u00077QAa!\b\u0002r\u0006!A.\u00198h\u0013\u0011\u0019\tca\u0007\u0003\u000f%sG/Z4fe\u0006\u0001\u0012\r\u001a3B]\u00124VM]5gs\u0006\u001bGn\u001d\u000b\u0006y\u000e\u001d2Q\b\u0005\b\u0007SA\u0004\u0019AB\u0016\u0003\u0011\t7\r\\:\u0011\r\u0005\r5QFB\u0019\u0013\u0011\u0019y#!&\u0003\u0007M+G\u000f\u0005\u0003\u00044\reRBAB\u001b\u0015\u0011\u00199$a)\u0002\u0007\u0005\u001cG.\u0003\u0003\u0004<\rU\"AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefDqaa\u00109\u0001\u0004\u0019\t%\u0001\u0005sKN|WO]2f!\u0011\u0019\u0019ea\u0012\u000e\u0005\r\u0015#\u0002BB \u0003GKAa!\u0013\u0004F\ty!+Z:pkJ\u001cW\rU1ui\u0016\u0014h.A\nsK6|g/Z!oIZ+'/\u001b4z\u0003\u000ed7\u000fF\u0003}\u0007\u001f\u001a\t\u0006C\u0004\u0004*e\u0002\raa\u000b\t\u000f\r}\u0012\b1\u0001\u0004B\u0005\u00012.\u001b7m%\u0006tGm\\7Ce>\\WM\u001d\u000b\u0002Q\u0006q1.\u001b7m\u0005J|7.\u001a:Cs&#Gc\u0001?\u0004\\!1\u0011QN\u001eA\u0002!\f!b[5mY\n\u0013xn[3s)\ra8\u0011\r\u0005\u0007\u0007Gb\u0004\u0019\u00015\u0002\u000b%tG-\u001a=\u0002#I,7\u000f^1si\u0012+\u0017\r\u001a\"s_.,'\u000fF\u0003}\u0007S\u001aY\u0007\u0003\u0004\u0004du\u0002\r\u0001\u001b\u0005\n\u0005/j\u0004\u0013!a\u0001\u0003{\t1D]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012\u0014!\u0006:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6fe\nK\u0018\n\u001a\u000b\u0006y\u000eM4Q\u000f\u0005\u0007\u0005?y\u0004\u0019\u00015\t\u0013\t]s\b%AA\u0002\u0005u\u0012a\b:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6fe\nK\u0018\n\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005a!/Z7pm\u0016\u0014%o\\6feR\u0019Ap! \t\u000f\rE\u0011\t1\u0001\u0004\u0016\u0005I\u0011\r\u001a3Ce>\\WM\u001d\u000b\u0006y\u000e\r5Q\u0011\u0005\u0007\u0007G\u0012\u0005\u0019\u00015\t\r\r\u001d%\t1\u0001x\u0003\u0019\u0019wN\u001c4jO\u0006q1.\u001b7m\u00032d'I]8lKJ\u001c\u0018A\u0005:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6feN$2\u0001`BH\u0011%\u00119\u0006\u0012I\u0001\u0002\u0004\ti$\u0001\u000fsKN$\u0018M\u001d;EK\u0006$'I]8lKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002/MDW\u000f\u001e3po:\\\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018!\u0005:fgR\f'\u000f^\"p]R\u0014x\u000e\u001c7fe\u0006iq-\u001a;D_:$(o\u001c7mKJ$\"!!\f\u0002%\u001d,Go\u0013*bMR\u001cuN\u001c;s_2dWM\u001d\u000b\u0003\u0007?\u00032!XBQ\u0013\r\u0019\u0019K\u0018\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\faf^1ji\u001a{'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2$v.\u00119qK\u0006\u0014xJ\\!mY\n\u0013xn[3sgR)Ap!+\u0004.\"911\u0016&A\u0002\u0005\u0005\u0015aD2mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\t\u000f\r=&\n1\u0001\u0002\u0002\u0006iQ.Z2iC:L7/\u001c(b[\u0016\f1bZ3u)>\u0004\u0018nY%egR!1QWB`!!\t\u0019ia.\u0002\u0002\u000ee\u0016\u0002\u0002BC\u0003+\u0003BAa7\u0004<&!1QXAR\u0005\u0011)V/\u001b3\t\u000f\r\u00057\n1\u0001\u0004D\u0006)a.Y7fgB!!/^AA)\t\u0019),A\u0007hKR$v\u000e]5d\u001d\u0006lWm\u001d\u000b\u0003\u0007\u0017\u0004\u0002\"a!\u00048\u000ee\u0016\u0011Q\u0001\u0013g\u0016\u0014h/\u001a:XSRD'I]8lKJLE\r\u0006\u0003\u0002\u0016\rE\u0007B\u0002B\u0010\u001d\u0002\u0007\u0001.A\u0007de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u0004y\u000e]\u0007b\u0002B.\u001f\u0002\u0007\u0011QH\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d$s_6\u001cuN\u001c4jOR!\u0011QCBo\u0011\u0019\u00199\t\u0015a\u0001o\u0006a!M]8lKJ<\u0016\u000e\u001e5JIR!\u0011QCBr\u0011\u0019\u0011y\"\u0015a\u0001Q\u0006yq-\u001a;SC:$w.\u001c\"s_.,'\u000f\u0006\u0002\u0002\u0016\u0005a\u0011\r\\5wK\n\u0013xn[3sgV\u00111Q\u001e\t\u0005eV\f)\"A\u000ff]N,(/Z\"p]NL7\u000f^3oi.\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0001")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private final int firstBrokerId;
    private Seq<KafkaConfig> instanceConfigs = null;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive = null;
    private boolean controllerAlive = false;

    public int firstBrokerId() {
        return this.firstBrokerId;
    }

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    private boolean controllerAlive() {
        return this.controllerAlive;
    }

    private void controllerAlive_$eq(boolean x$1) {
        this.controllerAlive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart() {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public Option<KafkaBroker> brokerForId(int id) {
        return this.brokers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart();
        this.createBrokers(true);
        this.controllerAlive_$eq(true);
        this.configureSecurityAfterServersStart();
    }

    public void concurrentStartBrokers() {
        int numBrokers = this.configs().size();
        ArrayBuffer brokerFutures = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ExecutorService executorService = Executors.newFixedThreadPool(numBrokers);
        this.alive_$eq(new boolean[numBrokers]);
        Arrays.fill(this.alive(), false);
        try {
            this.configs().foreach((Function1 & Serializable & scala.Serializable)config -> brokerFutures.$plus$eq(executorService.submit(() -> {
                void var2_2;
                KafkaBroker broker = this.createBrokerFromConfig((KafkaConfig)config);
                broker.startup();
                return var2_2;
            })));
            AtomicReference firstException = new AtomicReference();
            brokerFutures.foreach((Function1 & Serializable & scala.Serializable)future -> {
                KafkaServerTestHarness.$anonfun$concurrentStartBrokers$3(this, firstException, future);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.createOffsetsTopicWithAdmin((Admin)var5_4, this.brokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var9_8 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, (Admin)var9_8);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var6_5 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopicWithAssignment$1(this, topic, partitionReplicaAssignment, (Admin)var6_5);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaBroker>)this.servers());
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties topicConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var6_5 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopic$2(this, topic, partitionReplicaAssignment, topicConfig, (Admin)var6_5);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.deleteTopicWithAdmin((Admin)var5_4, topic, this.aliveBrokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public <B extends KafkaBroker> void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition, Iterable<B> brokers) {
        brokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$1(topicPartition, broker);
            return BoxedUnit.UNIT;
        });
    }

    public void waitUntilLogCreatedOnBrokers(String topic, int partitionId) {
        this.waitUntilLogCreatedOnBrokers(new TopicPartition(topic, partitionId));
    }

    public void waitUntilLogCreatedOnBrokers(TopicPartition topicPartition) {
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)this.brokers().head()).metadataCache().getPartitionInfo(topicPartition.topic(), topicPartition.partition()).get()).isr()).asScala();
        this.waitUntilLogCreatedOnBrokers(topicPartition, (Iterable)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> (KafkaBroker)this.brokerForId(Predef$.MODULE$.Integer2int(x$1)).get(), Buffer$.MODULE$.canBuildFrom()));
    }

    public Seq<Integer> brokerIds() {
        return (Seq)this._brokers().map((Function1 & Serializable & scala.Serializable)b -> new Integer(b.config().brokerId()), ArrayBuffer$.MODULE$.canBuildFrom());
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.removeAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBrokerById(int id) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$killBrokerById$1(id, b)));
        this.killBroker(brokerIndex);
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown();
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void restartDeadBroker(int index, boolean reconfigure) {
        if (!this.alive()[index]) {
            if (reconfigure || this.isKRaftTest()) {
                this._brokers().update(index, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(index)));
            }
            ((KafkaBroker)this._brokers().apply(index)).startup();
            this.alive()[index] = true;
        }
    }

    public boolean restartDeadBroker$default$2() {
        return false;
    }

    public void restartDeadBrokerById(int brokerId, boolean reconfigure) {
        int brokerIndex = this._brokers().indexWhere((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$restartDeadBrokerById$1(brokerId, b)));
        this.restartDeadBroker(brokerIndex, reconfigure);
    }

    public boolean restartDeadBrokerById$default$2() {
        return false;
    }

    public void removeBroker(Seq<Integer> brokerIds) {
        brokerIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            KafkaServerTestHarness.$anonfun$removeBroker$1(this, id);
            return BoxedUnit.UNIT;
        });
    }

    public void addBroker(int index, KafkaConfig config) {
        Assertions.assertTrue((index <= this._brokers().size() ? 1 : 0) != 0, (String)new StringBuilder(33).append("Can only add a broker at index 0-").append(this._brokers().size()).toString());
        KafkaBroker broker = this.createBroker(config, this.brokerTime(config.brokerId()), this.createBroker$default$3(), this.createBroker$default$4());
        if (index >= this._brokers().size()) {
            this._brokers().$plus$eq((Object)broker);
            boolean[] newAlive = new boolean[this._brokers().length()];
            new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(this.alive())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                newAlive$1[i] = this.alive()[i];
            });
            this.alive_$eq(newAlive);
        } else {
            this._brokers().update(index, (Object)broker);
        }
        this.alive()[index] = true;
    }

    public void killAllBrokers() {
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> this.restartDeadBroker(x$3, reconfigure));
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void shutdownKafkaController() {
        if (this.isKRaftTest()) {
            throw new UnsupportedOperationException("KRaft tests do not have a KafkaController instance.");
        }
        if (this.controllerAlive()) {
            this.getController().shutdown();
            this.controllerAlive_$eq(false);
        }
    }

    public void restartController() {
        if (this.isKRaftTest()) {
            this.restartControllerServer();
        } else {
            this.shutdownKafkaController();
            Assertions.assertFalse((boolean)this.controllerAlive());
            this.getController().startup();
        }
        this.controllerAlive_$eq(true);
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public ControllerServer getKRaftController() {
        this.checkIsKRaftTest();
        if (!this.controllerServer().controller().isActive()) {
            throw new KafkaException("Could not find the active controller!");
        }
        return this.controllerServer();
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(names).asJava()).get();
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.get(name).get());
                }
                return BoxedUnit.UNIT;
            });
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).entrySet().forEach(e -> result.put(e.getValue(), e.getKey()));
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap(Predef$.MODULE$.$conforms());
    }

    public KafkaBroker serverWithBrokerId(int brokerId) {
        return (KafkaBroker)this.brokers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverWithBrokerId$1(brokerId, x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    public void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
        }
        return TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, false);
    }

    public KafkaBroker brokerWithId(int brokerId) {
        return (KafkaBroker)this._brokers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$brokerWithId$1(brokerId, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    public KafkaBroker getRandomBroker() {
        void var1_1;
        KafkaBroker broker = (KafkaBroker)this._brokers().apply(TestUtils$.MODULE$.random().nextInt(this._brokers().size() - 1));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Returning Broker with ID ").append(broker.config().brokerId()).append(" as the next random broker").toString());
        return var1_1;
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((SeqLike)((TraversableLike)((TraversableLike)this._brokers().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, e)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (KafkaBroker)x$6._1(), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        if (this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$brokerForId$1(int id$2, KafkaBroker s) {
        return s.config().brokerId() == id$2;
    }

    public static final /* synthetic */ void $anonfun$concurrentStartBrokers$3(KafkaServerTestHarness $this, AtomicReference firstException$1, Future future) {
        try {
            KafkaBroker broker = (KafkaBroker)future.get(60000L, TimeUnit.MILLISECONDS);
            $this._brokers().$plus$eq((Object)broker);
            $this.alive()[$this._brokers().length() - 1] = true;
        }
        catch (Exception e) {
            firstException$1.compareAndSet(null, e);
        }
        if (firstException$1.get() != null) {
            throw (Throwable)firstException$1.get();
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(KafkaServerTestHarness $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$3 = $this.brokers();
        Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$3, numPartitions$1, replicationFactor$1, x$7, topicConfig$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopicWithAssignment$1(KafkaServerTestHarness $this, String topic$2, Map partitionReplicaAssignment$1, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$2, x$4, x$5, x$6, (Map<Object, Seq<Object>>)partitionReplicaAssignment$1, x$7);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$2(KafkaServerTestHarness $this, String topic$3, Map partitionReplicaAssignment$2, Properties topicConfig$2, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)partitionReplicaAssignment$2, topicConfig$2);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLogCreatedOnBrokers$2(KafkaBroker broker$1, TopicPartition topicPartition$1) {
        LogManager qual$1 = broker$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLogCreatedOnBrokers$3(TopicPartition topicPartition$1) {
        return new StringBuilder(16).append("Log for ").append(topicPartition$1).append(" created").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilLogCreatedOnBrokers$1(TopicPartition topicPartition$1, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$2(broker, topicPartition$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitUntilLogCreatedOnBrokers$3(topicPartition$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$killBrokerById$1(int id$3, KafkaBroker b) {
        return b.config().brokerId() == id$3;
    }

    public static final /* synthetic */ boolean $anonfun$restartDeadBrokerById$1(int brokerId$1, KafkaBroker b) {
        return b.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeBroker$2(Integer id$4, KafkaBroker x$2) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$2.config().brokerId()), (Object)id$4);
    }

    public static final /* synthetic */ void $anonfun$removeBroker$1(KafkaServerTestHarness $this, Integer id) {
        $this._brokers().$minus$eq($this._brokers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$removeBroker$2(id, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(id).append(" not found").toString());
        }));
        $this.alive()[Predef$.MODULE$.Integer2int((Integer)id)] = false;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverWithBrokerId$1(int brokerId$2, KafkaBroker x$4) {
        return x$4.config().brokerId() == brokerId$2;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithId$1(int brokerId$3, KafkaBroker x$5) {
        return x$5.config().brokerId() == brokerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, Tuple2 e) {
        return $this.alive()[e._2$mcI$sp()];
    }

    public KafkaServerTestHarness() {
        this.firstBrokerId = 0;
    }

    public static final /* synthetic */ Object $anonfun$deleteTopic$1$adapted(KafkaServerTestHarness $this, String topic$4, Admin admin) {
        TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic$4, $this.aliveBrokers());
        return BoxedUnit.UNIT;
    }
}

