/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.server.link.TopicLinkMirror$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0011%b\u0001B!C\u0001\u001dCQ\u0001\u0014\u0001\u0005\u00025Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019I\u0006\u0001)A\u0005#\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00023\u0001A\u0003%A\fC\u0004f\u0001\t\u0007I\u0011\u00014\t\rE\u0004\u0001\u0015!\u0003h\u0011\u001d\u0011\bA1A\u0005\u0002\u0019Daa\u001d\u0001!\u0002\u00139\u0007\"\u0002;\u0001\t\u0003)\bbBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!+\u0001\t\u0003\tY\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003n\u0001!\tAa\u001c\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BI\u0001\u0011\u0005!1\u0013\u0005\b\u0005;\u0003A\u0011\u0001BP\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqA!.\u0001\t\u0003\u00119\fC\u0004\u0003B\u0002!\tAa1\t\u000f\t5\u0007\u0001\"\u0001\u0003P\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011\u001d\u0011i\u0010\u0001C\t\u0005\u007fDqaa\u0001\u0001\t#\u0019)\u0001C\u0005\u0004\u0016\u0001\t\n\u0011\"\u0005\u0004\u0018!91Q\u0006\u0001\u0005\u0002\r=\u0002bBB\u001d\u0001\u0011\u000511\b\u0005\b\u0007\u000b\u0002A\u0011AB$\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqa!\u0018\u0001\t\u0003\u0019y\u0006C\u0004\u0004j\u0001!\taa\u001b\t\u000f\rU\u0004\u0001\"\u0001\u0004x!91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBG\u0001\u0011%1q\u0012\u0005\n\u0007+\u0003\u0011\u0013!C\u0005\u0007/Aqaa&\u0001\t\u0003\u0019I\nC\u0004\u0004$\u0002!\ta!*\t\u000f\r=\u0006\u0001\"\u0001\u00042\"911\u0018\u0001\u0005\u0002\ru\u0006bBBd\u0001\u0011\u00051\u0011\u001a\u0005\b\u0007'\u0004A\u0011ABk\u0011\u001d\u0019y\u000e\u0001C\u0001\u0007CDqaa;\u0001\t\u0003\u0019i\u000fC\u0004\u0005\u0010\u0001!I\u0001\"\u0005\u00035\rcWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r#\u0015\u0001\u00027j].T\u0011!R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\n\u0005\u0002J\u00156\t!)\u0003\u0002L\u0005\n\u0011\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001(\u0011\u0005%\u0003\u0011AD8gMN,G\u000fV8D_6l\u0017\u000e^\u000b\u0002#B\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n!Aj\u001c8h\u0003=ygMZ:fiR{7i\\7nSR\u0004\u0013AC:z]\u000e\u0004VM]5pI\u0006Y1/\u001f8d!\u0016\u0014\u0018n\u001c3!\u00035\u0019wN\\:v[\u0016\u0014xI]8vaV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u00039\u0019wN\\:v[\u0016\u0014xI]8va\u0002\n1\u0002^8qS\u000e4\u0015\u000e\u001c;feV\tq\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003UNk\u0011a\u001b\u0006\u0003Y\u001a\u000ba\u0001\u0010:p_Rt\u0014B\u00018T\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001d\u0006\u0003]N\u000bA\u0002^8qS\u000e4\u0015\u000e\u001c;fe\u0002\na#\u001b8dYV$W-\u00117m)>\u0004\u0018nY:GS2$XM]\u0001\u0018S:\u001cG.\u001e3f\u00032dGk\u001c9jGN4\u0015\u000e\u001c;fe\u0002\nQ\u0003^3ti\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0002wsB\u0011!k^\u0005\u0003qN\u0013A!\u00168ji\")!\u0010\u0004a\u0001O\u00061\u0011/^8sk6Dc\u0001\u0004?\u0002\u0016\u0005]\u0001cA?\u0002\u00125\taPC\u0002\u0000\u0003\u0003\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003\u0007\t)!\u0001\u0004qCJ\fWn\u001d\u0006\u0005\u0003\u000f\tI!A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0011QB\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003\u001f\t1a\u001c:h\u0013\r\t\u0019B \u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005e\u0011QD\u0011\u0003\u00037\t!A_6\"\u0005\u0005}\u0011!B6sC\u001a$\bf\u0002\u0007\u0002$\u0005-\u0012Q\u0006\t\u0005\u0003K\t9#\u0004\u0002\u0002\u0002%!\u0011\u0011FA\u0001\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u00020\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002WQ,7\u000f^\"sK\u0006$X-T5se>\u0014Hk\u001c9jG\u0006sGMV3sS\u001aL8k\\;sG\u0016$v\u000e]5d\u0013\u0012$2A^A\u001b\u0011\u0015QX\u00021\u0001hQ\u0019iA0!\u0006\u0002:1\"\u0011\u0011DA\u000fQ\u001di\u00111EA\u0016\u0003[\tq\u0004^3tiR\u0013\u0018M\\:bGRLwN\\:XSRDW*\u001b:s_J$v\u000e]5d)\r1\u0018\u0011\t\u0005\u0006u:\u0001\ra\u001a\u0015\u0007\u001dq\f)\"!\u0012-\t\u0005e\u0011Q\u0004\u0015\b\u001d\u0005\r\u00121FA\u0017\u0003\u0015\"Xm\u001d;Ti>\u0004X*\u001b:s_J$v\u000e]5d/&$\b.\u00138wC2LGMU3rk\u0016\u001cH\u000fF\u0002w\u0003\u001bBQA_\bA\u0002\u001dDca\u0004?\u0002\u0016\u0005EC\u0006BA\r\u0003;AsaDA\u0012\u0003W\ti#\u0001\buKN$8\u000b^8q\u001b&\u0014(o\u001c:\u0015\u0007Y\fI\u0006C\u0003{!\u0001\u0007q\r\u000b\u0004\u0011y\u0006U\u0011Q\f\u0017\u0005\u00033\ti\u0002K\u0004\u0011\u0003G\tY#!\f\u0002OQ,7\u000f^*u_Bl\u0015N\u001d:pe^KG\u000f[*pkJ\u001cWm\u00117vgR,'o\u00155vi\u0012|wO\u001c\u000b\u0004m\u0006\u0015\u0004\"\u0002>\u0012\u0001\u00049\u0007FB\t}\u0003+\tI\u0007\f\u0003\u0002\u001a\u0005u\u0001fB\t\u0002$\u0005-\u0012QF\u0001#i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3EK2,G/Z!oIJ+7M]3bi\u0016d\u0015N\\6\u0015\u0007Y\f\t\bC\u0003{%\u0001\u0007q\r\u000b\u0004\u0013y\u0006U\u0011Q\u000f\u0017\u0005\u00033\ti\u0002K\u0004\u0013\u0003G\tY#!\f\u0002)Q,7\u000f^'jeJ|'OT3x%\u0016\u001cwN\u001d3t)\r1\u0018Q\u0010\u0005\u0006uN\u0001\ra\u001a\u0015\u0007'q\f)\"!!-\t\u0005e\u0011Q\u0004\u0015\b'\u0005\r\u00121FA\u0017\u0003e!Xm\u001d;NSJ\u0014xN]#ySN$\u0018N\\4SK\u000e|'\u000fZ:\u0015\u0007Y\fI\tC\u0003{)\u0001\u0007q\r\u000b\u0004\u0015y\u0006U\u0011Q\u0012\u0017\u0005\u00033\ti\u0002K\u0004\u0015\u0003G\tY#!\f\u0002'Q,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2\u0015\u0007Y\f)\nC\u0003{+\u0001\u0007q\r\u000b\u0004\u0016y\u0006U\u0011\u0011\u0014\u0017\u0005\u00033\ti\u0002K\u0004\u0016\u0003G\tY#!\f\u0002-Q,7\u000f\u001e'jgR$Um]2sS\n,W*\u001b:s_J$2A^AQ\u0011\u0015Qh\u00031\u0001hQ\u00191B0!\u0006\u0002&2\"\u0011\u0011DA\u000fQ\u001d1\u00121EA\u0016\u0003[\ta\u0003^3tiN{WO]2f\u00072,8\u000f^3s#V|G/\u0019\u000b\u0004m\u00065\u0006\"\u0002>\u0018\u0001\u00049\u0007FB\f}\u0003+\t\t\f\f\u0003\u0002\u001a\u0005u\u0001fB\f\u0002$\u0005-\u0012QF\u0001 i\u0016\u001cH\u000fR3ti&t\u0017\r^5p]\u000ecWo\u001d;fe2Kgn[)v_R\fGc\u0001<\u0002:\")!\u0010\u0007a\u0001O\"2\u0001\u0004`A\u000b\u0003{cC!!\u0007\u0002\u001e!:\u0001$a\t\u0002,\u00055\u0012A\u000b;fgR$Um\u001d;j]\u0006$\u0018n\u001c8DYV\u001cH/\u001a:MS:\\'I]8lKJdUM^3m#V|G/\u0019\u000b\u0004m\u0006\u0015\u0007\"\u0002>\u001a\u0001\u00049\u0007FB\r}\u0003+\tI\r\f\u0003\u0002\u001a\u0005u\u0001fB\r\u0002$\u0005-\u0012QF\u0001\"m\u0016\u0014\u0018NZ=EKN$\u0018N\\1uS>t7\t\\;ti\u0016\u0014H*\u001b8l#V|G/\u0019\u000b\u0007\u0003#\fiNa\u0001\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6a\u0003\u0011)H/\u001b7\n\t\u0005m\u0017Q\u001b\u0002\u0005+VKE\tC\u0004\u0002`j\u0001\r!!9\u0002\u0013I,7o\\;sG\u0016\u001c\bCBAr\u0003S\fi/\u0004\u0002\u0002f*\u0019\u0011q]*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0006\u0015(aA*fcB!\u0011q^A\u0000\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018AB2p]\u001aLwM\u0003\u0003\u0002x\u0006e\u0018AB2p[6|gNC\u0002F\u0003wTA!!@\u0002\u000e\u00051\u0011\r]1dQ\u0016LAA!\u0001\u0002r\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007b\u0002B\u00035\u0001\u0007!qA\u0001\ncV|G/Y'pI\u0016\u0004BA!\u0003\u0003,9!!1\u0002B\u0013\u001d\u0011\u0011iA!\t\u000f\t\t=!q\u0004\b\u0005\u0005#\u0011iB\u0004\u0003\u0003\u0014\tma\u0002\u0002B\u000b\u00053q1A\u001bB\f\u0013\t\ty!\u0003\u0003\u0002~\u00065\u0011bA#\u0002|&!\u0011q_A}\u0013\u0011\t\u00190!>\n\t\t\r\u0012\u0011_\u0001\nS:$XM\u001d8bYNLAAa\n\u0003*\u0005\u00012i\u001c8gYV,g\u000e^\"p]\u001aLwm\u001d\u0006\u0005\u0005G\t\t0\u0003\u0003\u0003.\t=\"\u0001F\"mkN$XM\u001d'j].\fVo\u001c;b\u001b>$WM\u0003\u0003\u0003(\t%\u0012a\u0004<fe&4\u00170U;pi\u0006lu\u000eZ3\u0015\u0007Y\u0014)\u0004C\u0004\u0003\u0006m\u0001\rAa\u0002\u0002A\u0011,7\u000f^\"mkN$XM\u001d'j].\u0014V\r\u001d7jG\u0006\u001cH\u000b\u001b:piRdW\r\u001a\u000b\u0003\u0005w\u00012A\u0015B\u001f\u0013\r\u0011yd\u0015\u0002\b\u0005>|G.Z1o\u0003]1XM]5gs\u001a+Go\u00195SKN\u0004xN\\:f'&TX\rF\u0003w\u0005\u000b\u0012I\u0005C\u0004\u0003Hu\u0001\r!!5\u0002\r1Lgn[%e\u0011\u001d\u0011Y%\ba\u0001\u0005\u001b\nA\"\u001a=qK\u000e$X\rZ*ju\u0016\u0004RA\u0015B(\u0005'J1A!\u0015T\u0005\u0019y\u0005\u000f^5p]B!!Q\u000bB/\u001b\t\u00119FC\u0002D\u00053R1Aa\u0017E\u0003\u0019\u0019XM\u001d<fe&!!q\fB,\u0005E1U\r^2i%\u0016\u001c\bo\u001c8tKNK'0Z\u00011i\u0016\u001cH\u000fR3ti&t\u0017\r^5p]\u000ecWo\u001d;fe2Kgn[)v_R\fw+\u001b;i\u0005J|7.\u001a:SKN$\u0018M\u001d;\u0015\u0007Y\u0014)\u0007C\u0003{=\u0001\u0007q\r\u000b\u0004\u001fy\u0006U!\u0011\u000e\u0017\u0005\u00033\ti\u0002K\u0004\u001f\u0003G\tY#!\f\u0002KQ,7\u000f\u001e#fgRLg.\u0019;j_:d\u0015m\u001a'j].4U\r^2iKJ$\u0006N]8ui2,Gc\u0001<\u0003r!)!p\ba\u0001O\"2q\u0004`A\u000b\u0005kbC!!\u0007\u0002\u001e!:q$a\t\u0002,\u00055\u0012!\u0005;fgR\fE\r\u001a)beRLG/[8ogR\u0019aO! \t\u000bi\u0004\u0003\u0019A4)\r\u0001b\u0018Q\u0003BAY\u0011\tI\"!\b)\u000f\u0001\n\u0019#a\u000b\u0002.\u0005YB/Z:u\u00032$XM]\"mkN$XM\u001d'j].\u001cuN\u001c4jON$2A\u001eBE\u0011\u0015Q\u0018\u00051\u0001hQ\u0019\tC0!\u0006\u0003\u000e2\"\u0011\u0011DA\u000fQ\u001d\t\u00131EA\u0016\u0003[\t\u0011\u0006^3ti>3gm]3u\u001b&<'/\u0019;j_:<\u0016\u000e\u001e5BI\u0012,GmQ8ogVlWM]$s_V\u0004Hc\u0001<\u0003\u0016\")!P\ta\u0001O\"2!\u0005`A\u000b\u00053cC!!\u0007\u0002\u001e!:!%a\t\u0002,\u00055\u0012!\t;fgR|eMZ:fi6KwM]1uS>tw+\u001b;i\u0003\u0012$W\r\u001a+pa&\u001cGc\u0001<\u0003\"\")!p\ta\u0001O\"21\u0005`A\u000b\u0005KcC!!\u0007\u0002\u001e!:1%a\t\u0002,\u00055\u0012\u0001\u0005;fgR$Um\u001d;SK\u0006$wJ\u001c7z)\r1(Q\u0016\u0005\u0006u\u0012\u0002\ra\u001a\u0015\u0007Iq\f)B!--\t\u0005e\u0011Q\u0004\u0015\bI\u0005\r\u00121FA\u0017\u0003q!Xm\u001d;EK2,G/Z\"mkN$XM\u001d'j].\u001cE.Z1okB$2A\u001eB]\u0011\u0015QX\u00051\u0001hQ\u0019)C0!\u0006\u0003>2\"\u0011\u0011DA\u000fQ\u001d)\u00131EA\u0016\u0003[\t\u0001\u0005^3ti6K'O]8sK\u0012$v\u000e]5d\u001b\u0006\u00148.\u001a3G_J$U\r\\3uKR\u0019aO!2\t\u000bi4\u0003\u0019A4)\r\u0019b\u0018Q\u0003BeY\u0011\tI\"!\b)\u000f\u0019\n\u0019#a\u000b\u0002.\u0005qA/Z:u!\u0006,8/\u001a+pa&\u001cGc\u0001<\u0003R\")!p\na\u0001O\"2q\u0005`A\u000b\u0005+dC!!\u0007\u0002\u001e!:q%a\t\u0002,\u00055\u0012\u0001\u0006;fgR\u0004\u0016-^:f\u00072,8\u000f^3s\u0019&t7\u000eF\u0002w\u0005;DQA\u001f\u0015A\u0002\u001dDc\u0001\u000b?\u0002\u0016\t\u0005H\u0006BA\r\u0003;As\u0001KA\u0012\u0003W\ti#A\tuKN$(+\u001a9mS\u000e\f7\u000b^1ukN$2A\u001eBu\u0011\u0015Q\u0018\u00061\u0001hQ\u0019IC0!\u0006\u0003n2\"\u0011\u0011DA\u000fQ\u001dI\u00131EA\u0016\u0003[\t\u0011\u0003^3ti\u0006+Ho\\'jeJ|'/\u001b8h)\r1(Q\u001f\u0005\u0006u*\u0002\ra\u001a\u0015\u0007Uq\f)B!?-\t\u0005e\u0011Q\u0004\u0015\bU\u0005\r\u00121FA\u0017\u0003=\tW\u000f^8NSJ\u0014xN\u001d+pa&\u001cGc\u0001<\u0004\u0002!)\u0001l\u000ba\u0001#\u0006iB-Z:u\u0019&t7\u000e\u0015:paN4uN]!vi>l\u0015N\u001d:pe&tw\r\u0006\u0004\u0004\b\r51\u0011\u0003\t\u0005\u0003'\u001cI!\u0003\u0003\u0004\f\u0005U'A\u0003)s_B,'\u000f^5fg\"11q\u0002\u0017A\u0002\u001d\fA\u0002^8qS\u000e4\u0015\u000e\u001c;feND\u0011ba\u0005-!\u0003\u0005\rAa\u000f\u0002'\r|gNZ5hkJ,G*\u001b8l!J,g-\u001b=\u0002O\u0011,7\u000f\u001e'j].\u0004&o\u001c9t\r>\u0014\u0018)\u001e;p\u001b&\u0014(o\u001c:j]\u001e$C-\u001a4bk2$HEM\u000b\u0003\u00073QCAa\u000f\u0004\u001c-\u00121Q\u0004\t\u0005\u0007?\u0019I#\u0004\u0002\u0004\")!11EB\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0004(M\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yc!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u001auKN$H*Y:u\r\u0016$8\r[3e\u001f\u001a47/\u001a;Qe>lw\u000e^3e\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]R\u0019ao!\r\t\u000bit\u0003\u0019A4)\r9b\u0018QCB\u001bY\u0011\tI\"!\b)\u000f9\n\u0019#a\u000b\u0002.\u0005)D/Z:u\u0019\u0006\u001cHOR3uG\",Gm\u00144gg\u0016$h)Y5mK\u0012|e/\u001a:NSJ\u0014xN\u001d+pa&\u001cG)Z:de&\u0004H/[8o)\r18Q\b\u0005\u0006u>\u0002\ra\u001a\u0015\u0007_q\f)b!\u0011-\t\u0005e\u0011Q\u0004\u0015\b_\u0005\r\u00121FA\u0017\u0003)\"Xm\u001d;BkR|W*\u001b:s_JLgn\u001a(p\u001fZ,'\u000f\\1qa&tw\rV8qS\u000e4\u0015\u000e\u001c;feN$2A^B%\u0011\u0015Q\b\u00071\u0001hQ\u0019\u0001D0!\u0006\u0004N1\"\u0011\u0011DA\u000fQ\u001d\u0001\u00141EA\u0016\u0003[\tq\u0005^3ti\u0006+Ho\\'jeJ|'/\u001b8h\u00032dwn^:MS:\\7i\u001c8gS\u001e,\u0006\u000fZ1uKR\u0019ao!\u0016\t\u000bi\f\u0004\u0019A4)\rEb\u0018QCB-Y\u0011\tI\"!\b)\u000fE\n\u0019#a\u000b\u0002.\u0005!C/Z:u\u001b&\u0014(o\u001c:U_BL7mQ8v]R4uN]'vYRL\u0007\u000f\\3MS:\\7\u000fF\u0002w\u0007CBQA\u001f\u001aA\u0002\u001dDcA\r?\u0002\u0016\r\u0015D\u0006BA\r\u0003;AsAMA\u0012\u0003W\ti#A\u0012uKN$\u0018)\u001e;p\u001b&\u0014(o\u001c:j]\u001e,\u0006\u000fZ1uK\u0016C\u0018n\u001d;j]\u001ed\u0015N\\6\u0015\u0007Y\u001ci\u0007C\u0003{g\u0001\u0007q\r\u000b\u00044y\u0006U1\u0011\u000f\u0017\u0005\u00033\ti\u0002K\u00044\u0003G\tY#!\f\u0002MQ,7\u000f^!vi>l\u0015N\u001d:pe&tw-\u00113eS:<\u0017\t\u001a3ji&|g.\u00197U_BL7\rF\u0002w\u0007sBQA\u001f\u001bA\u0002\u001dDc\u0001\u000e?\u0002\u0016\ruD\u0006BA\r\u0003;As\u0001NA\u0012\u0003W\ti#\u0001\u0011uKN$\u0018)\u001e;p\u001b&\u0014(o\u001c:j]\u001etu.\u0012=jgRLgn\u001a+pa&\u001cGc\u0001<\u0004\u0006\")!0\u000ea\u0001O\"2Q\u0007`A\u000b\u0007\u0013cC!!\u0007\u0002\u001e!:Q'a\t\u0002,\u00055\u0012A\r;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3PM\u001a\u001cX\r^*u_B\u0004X\rZ'jeJ|'\u000fV8qS\u000e$Um]2sSB$\u0018n\u001c8\u0015\u0007Y\u001c\t\nC\u0005\u0004\u0014Z\u0002\n\u00111\u0001\u0003<\u00059\u0001O]8n_R,\u0017\u0001\u0010;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3PM\u001a\u001cX\r^*u_B\u0004X\rZ'jeJ|'\u000fV8qS\u000e$Um]2sSB$\u0018n\u001c8%I\u00164\u0017-\u001e7uIE\nA\u0004^3ti\u0012+G.\u001a;f\u0003V$x.T5se>\u0014X\r\u001a+pa&\u001c7\u000fF\u0002w\u00077CQA\u001f\u001dA\u0002\u001dDc\u0001\u000f?\u0002\u0016\r}E\u0006BA\r\u0003;As\u0001OA\u0012\u0003W\ti#\u0001\u0012uKN$\u0018J\u001c;feZ\fGn\u00115b]\u001e,gi\u001c:QKJLw\u000eZ5d)\u0006\u001c8n\u001d\u000b\u0004m\u000e\u001d\u0006\"\u0002>:\u0001\u00049\u0007FB\u001d}\u0003+\u0019Y\u000b\f\u0003\u0002\u001a\u0005u\u0001fB\u001d\u0002$\u0005-\u0012QF\u0001\u001fi\u0016\u001cH/\u0012=uKJt\u0017\r\\5{K\u0012\u0004\u0016m]:x_J$7i\u001c8gS\u001e$2A^BZ\u0011\u0015Q(\b1\u0001hQ\u0019QD0!\u0006\u000482\"\u0011\u0011DA\u000fQ\u001dQ\u00141EA\u0016\u0003[\t\u0011\u0006^3ti6K'O]8s\r\u0006LGn\u001c<fe^CWM\\*pkJ\u001cW-S:V]\u00064\u0018-\u001b7bE2,Gc\u0001<\u0004@\")!p\u000fa\u0001O\"21\b`A\u000b\u0007\u0007dC!!\u0007\u0002\u001e!:1(a\t\u0002,\u00055\u0012\u0001\n;fgR\u001cE.^:uKJd\u0015N\\6NKR\fG-\u0019;b)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8\u0015\u0007Y\u001cY\rC\u0003{y\u0001\u0007q\r\u000b\u0004=y\u0006U1q\u001a\u0017\u0005\u00033\ti\u0002K\u0004=\u0003G\tY#!\f\u0002/Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:MS:\\Gc\u0001<\u0004X\")!0\u0010a\u0001O\"2Q\b`A\u000b\u00077d#!!\u0007)\u000fu\n\u0019#a\u000b\u0002.\u00051C/Z:u\u00032$XM]\"mkN$XM\u001d'j].<\u0016\u000e\u001e5J]Z\fG.\u001b3D_:4\u0017nZ:\u0015\u0007Y\u001c\u0019\u000fC\u0003{}\u0001\u0007q\r\u000b\u0004?y\u0006U1q\u001d\u0017\u0003\u00033AsAPA\u0012\u0003W\ti#A\rwKJLg-\u001f#fg\u000e\u0014\u0018NY3MS:\\7OU3tk2$H#\u0002<\u0004p\u0012-\u0001bBBy\u007f\u0001\u000711_\u0001\u000eI\u0016\u001cH\u000fT5oWN#\u0018\r^3\u0011\t\rUHQ\u0001\b\u0005\u0007o$\t!\u0004\u0002\u0004z*!11`B\u007f\u0003\u0015\tG-\\5o\u0015\u0011\u0019y0!?\u0002\u000f\rd\u0017.\u001a8ug&!A1AB}\u0003Y\u0019E.^:uKJd\u0015N\\6EKN\u001c'/\u001b9uS>t\u0017\u0002\u0002C\u0004\t\u0013\u0011\u0011\u0002T5oWN#\u0018\r^3\u000b\t\u0011\r1\u0011 \u0005\b\t\u001by\u0004\u0019ABz\u0003=\u0019x.\u001e:dK2Kgn[*uCR,\u0017!\b<fe&4\u0017pU1tY*\u000b\u0017m]\"p]\u001aLw-\u00128def\u0004H/\u001a3\u0015\u0007Y$\u0019\u0002C\u0004\u0003H\u0001\u0003\r!!5)\u000f\u0001!9\u0002b\t\u0005&A!A\u0011\u0004C\u0010\u001b\t!YB\u0003\u0003\u0005\u001e\u0005\u0015\u0011aA1qS&!A\u0011\u0005C\u000e\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\tO\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClusterLinkIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long offsetToCommit;
    private final long syncPeriod;
    private final String consumerGroup;
    private final String topicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"").append(this.topic()).append("\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |").toString())).stripMargin();
    private final String includeAllTopicsFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"*\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |")).stripMargin();

    public long offsetToCommit() {
        return this.offsetToCommit;
    }

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public String topicFilter() {
        return this.topicFilter;
    }

    public String includeAllTopicsFilter() {
        return this.includeAllTopicsFilter;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateMirrorTopic(String quorum) {
        String retentionMs = "10000";
        Properties configs = new Properties();
        configs.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$22 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$22, x$3, configs, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        boolean x$9 = true;
        Option<Properties> x$10 = this.createClusterLink$default$3();
        this.createClusterLink(x$7, linkProps, x$10, x$9);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$11 = this.topic();
        short x$122 = this.replicationFactor();
        String x$13 = this.linkName();
        String x$14 = this.clusterLinkPrefix();
        Map<String, String> x$15 = qual$2.linkTopic$default$4();
        CreateTopicsResult result = qual$2.linkTopic(x$11, x$122, x$13, x$15, x$14);
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((Object)retentionMs, (Object)((Config)result.config(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Config topicConfig = this.destCluster().describeTopicConfig(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertEquals((Object)retentionMs, (Object)topicConfig.get(LogConfig$.MODULE$.RetentionMsProp()).value());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty() && quorum.equals("zk")) {
            this.verifyLinkWithClusterLinkPrefixCountMetric(1, this.linkName(), (Option<String>)None$.MODULE$);
        }
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopic$1(this, x$1)))).head()).topics().get()).asScala()).toSet());
        Seq<ClusterLinkDescription> description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopic$2(this, x$2)))).head()).topics().get()).asScala()).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateMirrorTopicAndVerifySourceTopicId(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        if (this.isKraftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.sourceCluster().controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
        Uuid sourceTopicId = this.sourceCluster().describeTopic(this.topic()).topicId();
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        boolean x$9 = true;
        Option<Properties> x$10 = this.createClusterLink$default$3();
        this.createClusterLink(x$7, linkProps, x$10, x$9);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$11 = this.topic();
        short x$12 = this.replicationFactor();
        String x$13 = this.linkName();
        String x$14 = this.clusterLinkPrefix();
        Map<String, String> x$15 = qual$2.linkTopic$default$4();
        CreateTopicsResult result = qual$2.linkTopic(x$11, x$12, x$13, x$15, x$14);
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        if (this.isKraftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.destCluster().brokers(), this.destCluster().controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
        ((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().clusterLinkMetadataManager().exists((Function1 & Serializable & scala.Serializable)manager -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopicAndVerifySourceTopicId$1(this, sourceTopicId, manager)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionsWithMirrorTopic(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        String groupId = "testGroup";
        String topic2 = "anotherTopic";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topic2, x$8, x$9, x$10, x$11, x$12);
        String x$13 = this.linkName();
        boolean x$14 = true;
        Properties x$15 = this.createClusterLink$default$2();
        Option<Properties> x$16 = this.createClusterLink$default$3();
        this.createClusterLink(x$13, x$15, x$16, x$14);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$17 = this.topic();
        short x$18 = this.replicationFactor();
        String x$19 = this.linkName();
        Map<String, String> x$20 = qual$3.linkTopic$default$4();
        String x$21 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$17, x$18, x$19, x$20, x$21);
        Properties producerProps = new Properties();
        producerProps.setProperty("transactional.id", "test_txn");
        producerProps.setProperty("acks", "all");
        ClusterLinkTestHarness qual$4 = this.destCluster();
        ByteArraySerializer x$23 = qual$4.createProducer$default$1();
        ByteArraySerializer x$24 = qual$4.createProducer$default$2();
        try (KafkaProducer producer = qual$4.createProducer(x$23, x$24, producerProps);){
            producer.initTransactions();
            Properties consumerProps = new Properties();
            consumerProps.setProperty("group.id", groupId);
            consumerProps.setProperty("isolation.level", "read_committed");
            ClusterLinkTestHarness qual$5 = this.destCluster();
            ByteArrayDeserializer x$26 = qual$5.createConsumer$default$1();
            ByteArrayDeserializer x$27 = qual$5.createConsumer$default$2();
            List<String> x$28 = qual$5.createConsumer$default$4();
            try (KafkaConsumer consumer = qual$5.createConsumer(x$26, x$27, consumerProps, x$28);){
                consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.partitions(this.partitions$default$1())).asJava());
                Seq consumedRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.producedRecords().size(), 20000L);
                java.util.Map consumedOffsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.partitions(this.partitions$default$1())).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    Long offset = (Long)x0$1._2();
                    Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new OffsetAndMetadata(Predef$.MODULE$.Long2long(offset)));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
                producer.beginTransaction();
                consumedRecords.foreach((Function1 & Serializable & scala.Serializable)record -> producer.send(new ProducerRecord(topic2, Predef$.MODULE$.int2Integer(record.partition()), Predef$.MODULE$.long2Long(record.timestamp()), record.key(), record.value())));
                producer.sendOffsetsToTransaction(consumedOffsets, new ConsumerGroupMetadata(groupId));
                producer.commitTransaction();
                Assertions.assertEquals((Object)consumedOffsets, (Object)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions(this.partitions$default$1()).toSet()).asJava()));
                producer.beginTransaction();
                ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.produceRecords((KafkaProducer<byte[], byte[]>)producer, this.topic(), 1, this.produceRecords$default$4()));
                Assertions.assertTrue((boolean)e.getMessage().matches(".*Could not add partitions to transaction due to errors.*INVALID_REQUEST.*"), (String)new StringBuilder(17).append("Unexpected error ").append(e.getMessage()).toString());
                producer.abortTransaction();
                this.producedRecords().clear();
                ClusterLinkTestHarness qual$6 = this.destCluster();
                String x$29 = this.topic();
                String x$30 = this.linkName();
                boolean x$31 = false;
                boolean x$32 = qual$6.unlinkTopic$default$3();
                qual$6.unlinkTopic(x$29, x$30, x$32, x$31);
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$4(this)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$8());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                producer.beginTransaction();
                this.produceRecords(producer, this.topic(), 10, this.produceRecords$default$4());
                producer.commitTransaction();
                this.consumeRecords(consumer, this.consumeRecords$default$2());
            }
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirrorTopicWithInvalidRequest(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().unlinkTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.linkName(), false, false));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$7, x$8, x$9, x$10, x$11, x$12);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().unlinkTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.linkName(), false, false));
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        short x$14 = this.replicationFactor();
        String x$15 = this.linkName();
        String x$16 = this.clusterLinkPrefix();
        Map<String, String> x$17 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$13, x$14, x$15, x$17, x$16);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$19 = this.linkName();
        boolean x$20 = qual$4.unlinkTopic$default$3();
        boolean x$21 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$18, x$19, x$20, x$21);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().unlinkTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.linkName(), false, false));
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.linkName();
        boolean x$23 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$24 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$22, x$23, x$24);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirror(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$14 = false;
        boolean x$15 = qual$3.unlinkTopic$default$3();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$14);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        short x$17 = this.replicationFactor();
        String x$18 = this.linkName();
        String x$19 = this.clusterLinkPrefix();
        Map<String, String> x$20 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(x$16, x$17, x$18, x$20, x$19);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$22 = this.linkName();
        boolean x$23 = qual$5.unlinkTopic$default$3();
        boolean x$24 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$21, x$22, x$23, x$24);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$25 = this.linkName();
        boolean x$26 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$27 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$25, x$26, x$27);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirrorWithSourceClusterShutdown(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$14 = false;
        boolean x$15 = qual$3.unlinkTopic$default$3();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$14);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        String x$17 = this.linkName();
        boolean x$18 = qual$4.unlinkTopic$default$3();
        boolean x$19 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$16, x$17, x$18, x$19);
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.restartSource$1();
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicPromoteMetric(this.linkName());
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$20 = this.topic();
        String x$21 = this.linkName();
        boolean x$22 = qual$5.unlinkTopic$default$3();
        boolean x$23 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$20, x$21, x$22, x$23);
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$24 = this.topic();
        String x$25 = this.linkName();
        boolean x$26 = false;
        boolean x$27 = qual$6.unlinkTopic$default$3();
        qual$6.unlinkTopic(x$24, x$25, x$27, x$26);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.verifyTimeToStopMirrorTopicFailoverMetric(this.linkName());
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$28 = this.linkName();
        boolean x$29 = qual$7.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$30 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$28, x$29, x$30);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAndDeleteAndRecreateLink(String quorum) {
        void var26_31;
        Tuple2 tuple2;
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$52 = qual$1.createTopic$default$5();
        Properties x$62 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$52, x$62);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$82 = this.replicationFactor();
        String x$92 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$82, x$92, x$10, x$11);
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$1(this, x$5)))).head()).topics().get()).asScala()).toSet());
        Seq<ClusterLinkDescription> description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$2(this, x$6)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        boolean x$13 = qual$3.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$14 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$12, x$13, x$14);
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertTrue((boolean)listing.isEmpty());
        description = this.destCluster().describeClusterLinks(true);
        Assertions.assertTrue((boolean)description.isEmpty());
        KafkaBroker broker = (KafkaBroker)this.destCluster().brokers().head();
        this.destCluster().killBrokerById(broker.config().brokerId());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$15 = qual$4.restartDeadBrokers$default$1();
        qual$4.restartDeadBrokers(x$15);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Seq computeUntilTrue_result;
            if (ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$4(computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$3(broker))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq links = (Seq)tuple2._1();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)var26_31);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$5 = this.sourceCluster();
            String x$16 = this.linkName();
            boolean x$17 = qual$5.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$18 = qual$5.deleteClusterLink$default$3();
            qual$5.deleteClusterLink(x$16, x$17, x$18);
            listing = this.sourceCluster().listClusterLinks(true);
            Assertions.assertTrue((boolean)listing.isEmpty());
            description = this.sourceCluster().describeClusterLinks(true);
            Assertions.assertTrue((boolean)description.isEmpty());
        }
        UUID newLinkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$19 = this.topic();
        short x$20 = this.replicationFactor();
        String x$21 = this.linkName();
        Map<String, String> x$22 = qual$6.linkTopic$default$4();
        String x$23 = qual$6.linkTopic$default$5();
        qual$6.linkTopic(x$19, x$20, x$21, x$22, x$23);
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$5(this, x$8)))).head()).topics().get()).asScala()).toSet());
        description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$6(this, x$9)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), newLinkId);
        this.destCluster().deleteLinkNoVerify(this.linkName(), true);
        this.destCluster().killAllBrokers();
        ClusterLinkTestHarness qual$7 = this.destCluster();
        boolean x$24 = qual$7.restartDeadBrokers$default$1();
        qual$7.restartDeadBrokers(x$24);
        this.destCluster().updateBootstrapServers();
        Option metadataManager = broker.clusterLinkManager().clusterLinkMetadataManager();
        Assertions.assertTrue((boolean)metadataManager.isDefined());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$7(metadataManager, newLinkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$8(newLinkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!this.useSourceInitiatedLink()) {
            Properties invalidLinkProps = this.destLinkProps(this.destLinkProps$default$1());
            invalidLinkProps.setProperty("sasl.jaas.config", invalidLinkProps.getProperty("sasl.jaas.config").replace(this.linkName(), new StringBuilder(6).append("wrong-").append(this.linkName()).toString()));
            this.verifyValidateLinkFailure(invalidLinkProps, SaslAuthenticationException.class, "Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256");
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorNewRecords(String quorum) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.produceToSourceCluster(numRecords);
        this.consume(this.sourceCluster(), "");
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        if (quorum.equals("zk")) {
            this.verifySaslJaasConfigEncrypted(linkId);
        }
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        boolean x$13 = qual$3.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$14 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$12, x$13, x$14);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorExistingRecords(String quorum) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicConfigSync(String quorum) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyTopicConfigChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListDescribeMirror(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        boolean x$7 = qual$2.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$2.listMirrorTopics(x$7));
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$8 = this.topic();
        short x$9 = 2;
        String x$10 = this.linkName();
        Map<String, String> x$11 = qual$3.linkTopic$default$4();
        String x$12 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$8, x$9, x$10, x$11, x$12);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$13 = qual$4.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), qual$4.listMirrorTopics(x$13));
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(this.topic());
        Assertions.assertEquals((Object)this.linkName(), (Object)desc.linkName());
        Assertions.assertEquals((Object)this.topic(), (Object)desc.sourceTopic());
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)desc.state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$14 = this.topic();
        String x$15 = this.linkName();
        boolean x$16 = qual$5.unlinkTopic$default$3();
        boolean x$17 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$14, x$15, x$16, x$17);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$18 = qual$6.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$6.listMirrorTopics(x$18));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(true));
        Assertions.assertEquals((Object)this.destCluster().describeMirrorTopic(this.topic()).state(), (Object)MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.destCluster().listMirrorTopics(true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().describeMirrorTopic(this.topic()));
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$19 = this.topic();
        short x$20 = 2;
        String x$21 = this.linkName();
        Map<String, String> x$22 = qual$7.linkTopic$default$4();
        String x$23 = qual$7.linkTopic$default$5();
        qual$7.linkTopic(x$19, x$20, x$21, x$22, x$23);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        boolean x$24 = qual$8.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), qual$8.listMirrorTopics(x$24));
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.destCluster().pauseTopic(this.topic(), true);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$25 = this.linkName();
        boolean x$26 = true;
        Seq<KafkaBroker> x$27 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$25, x$26, x$27);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSourceClusterQuota(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp()), (Object)"100")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        Properties x$12 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$3.createConfluentAdminClient(x$12);
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> this.setQuota$1(byteRate, sourceAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.throttled$1(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkQuota(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        .colon.colon resources = new .colon.colon((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (List)Nil$.MODULE$);
        UUID linkId = this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND);
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.fetch.response.total.bytes", "10000"), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)new Some((Object)new FetchResponseSize(5000, 10000)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkBrokerLevelQuota(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        Seq resources = ((SeqLike)((TraversableLike)this.destCluster().brokers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$1(x$11)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)brokerId -> ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$2(BoxesRunTime.unboxToInt((Object)brokerId)), Buffer$.MODULE$.canBuildFrom())).toSeq();
        this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY);
    }

    public UUID verifyDestinationClusterLinkQuota(Seq<ConfigResource> resources, ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$122 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$122);
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> ClusterLinkIntegrationTest.setQuota$2(byteRate, resources, destAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), true);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyQuotaMode(quotaMode);
        return linkId;
    }

    /*
     * WARNING - void declaration
     */
    public void verifyQuotaMode(ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin admin = qual$1.createConfluentAdminClient(x$1);
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        AlterConfigOp alterProduceQuotaOp = new AlterConfigOp(new ConfigEntry("producer_byte_rate", "100000"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp, alterProduceQuotaOp}))).asJavaCollection());
        admin.incrementalAlterConfigs(configs).all().get();
        KafkaBroker broker = this.sourceCluster().partitionLeader(new TopicPartition(this.topic(), 0));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$1(broker, quotaMode)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(20);
        this.verifyClusterLinkQuotaMetrics((Seq<KafkaBroker>)new .colon.colon((Object)broker, (List)Nil$.MODULE$), quotaMode.equals(ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND));
    }

    private boolean destClusterLinkReplicasThrottled() {
        return this.yammerMetricMaxValue("kafka.server:type=ReplicaManager,name=ThrottledClusterLinkReplicasPerSec", (Option<String>)None$.MODULE$) > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFetchResponseSize(UUID linkId, Option<FetchResponseSize> expectedSize) {
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)((IterableLike)((TraversableLike)this.destCluster().brokers().map((Function1 & Serializable & scala.Serializable)x$14 -> (ClusterLinkFetcherManager)x$14.clusterLinkManager().fetcherManager(linkId).get(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$2(x$15)))).head();
        LeaderEndPoint fetcherThreadLeaderEndPoint = ((ClusterLinkFetcherThread)((HashMap)TestUtils.fieldValue((Object)fetcherManager, AbstractFetcherManager.class, (String)"fetcherThreadMap")).values().head()).leader();
        Object expectedFetchSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.perPartitionSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchMaxBytes());
        Object expectedFetchResponseSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.responseSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchResponseMaxBytes());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchSize$1(fetcherThreadLeaderEndPoint);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$8(expectedFetchSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchSize$1(fetcherThreadLeaderEndPoint)));
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThreadLeaderEndPoint);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$10(expectedFetchResponseSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchResponseSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThreadLeaderEndPoint)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkQuotaWithBrokerRestart(String quorum) {
        void var26_26;
        void var25_25;
        void var27_32;
        Tuple2 tuple2;
        void var23_23;
        void var22_22;
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$12 = qual$3.createConfluentAdminClient$default$1();
        ObjectRef destAdmin = ObjectRef.create((Object)qual$3.createConfluentAdminClient(x$12));
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), "100"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection());
        ((ConfluentAdmin)destAdmin.elem).incrementalAlterConfigs(configs).all().get();
        ((ConfluentAdmin)destAdmin.elem).close();
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int oldLeaderId = tuple22._1$mcI$sp();
        int oldLeaderEpoch = tuple22._2$mcI$sp();
        Tuple2<Object, Object> tuple23 = this.destCluster().waitForLeaderChange(tp, (int)var22_22, (int)var23_23);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int newLeaderId = tuple23._1$mcI$sp();
        int newLeaderEpoch = tuple23._2$mcI$sp();
        this.destCluster().startBroker((int)var22_22);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(this, tp)).contains((Object)BoxesRunTime.boxToInteger((int)((int)var22_22)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(42).append("Broker ").append((int)var22_22).append(" is not part of ISR ").append(var27_32).append(" for partition ").append(tp).toString());
        this.destCluster().updateBootstrapServers();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        Properties x$13 = qual$4.createConfluentAdminClient$default$1();
        destAdmin.elem = qual$4.createConfluentAdminClient(x$13);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l3 = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$4(destAdmin, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Assertions.assertEquals((int)this.destCluster().waitForLeaderChange(tp, (int)var25_25, (int)var26_26)._1$mcI$sp(), (int)var22_22, (String)"Preferred leader not elected");
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        ByteArraySerializer x$14 = qual$5.createProducer$default$1();
        ByteArraySerializer x$15 = qual$5.createProducer$default$2();
        Properties x$16 = qual$5.createProducer$default$3();
        this.produceUntil(qual$5.createProducer(x$14, x$15, x$16), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), "Destination quota not applied after broker restart");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationLagLinkFetcherThrottle(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(2);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-2")}));
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = this.linkName();
        Map x$16 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-1")}));
        Seq<KafkaBroker> x$17 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$15, (Map<String, String>)x$16, x$17);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"10485760")}));
        Seq<KafkaBroker> x$20 = qual$5.alterClusterLink$default$3();
        qual$5.alterClusterLink(x$18, (Map<String, String>)x$19, x$20);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$21 = this.linkName();
        Map x$22 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"0")}));
        Seq<KafkaBroker> x$23 = qual$6.alterClusterLink$default$3();
        qual$6.alterClusterLink(x$21, (Map<String, String>)x$22, x$23);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "link-fetcher-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAddPartitions(String quorum) {
        void var17_23;
        Tuple2 tuple2;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.numPartitions_$eq(4);
        this.sourceCluster().createPartitions(this.topic(), this.numPartitions());
        this.produceToSourceCluster(8);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testAddPartitions$1(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAddPartitions$2(this, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)this.numPartitions(), (int)var17_23);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAddPartitionMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterClusterLinkConfigs(String quorum) {
        void var31_37;
        Tuple2 tuple2;
        ClusterLinkTestHarness connectingCluster;
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(8);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.sourceLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness clusterLinkTestHarness = connectingCluster = super.connectingCluster();
        ClusterLinkTestHarness clusterLinkTestHarness2 = this.destCluster();
        ClusterLinkTestHarness otherCluster = !(clusterLinkTestHarness != null ? !clusterLinkTestHarness.equals(clusterLinkTestHarness2) : clusterLinkTestHarness2 != null) ? this.sourceCluster() : this.destCluster();
        String metadataMaxAge = "60000";
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)metadataMaxAge)}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertEquals((Object)metadataMaxAge, (Object)connectingCluster.describeClusterLink(this.linkName()).get("metadata.max.age.ms").value());
        otherCluster.killAllBrokers();
        otherCluster.startAllBrokers();
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)otherCluster.bootstrapServers(otherCluster.bootstrapServers$default$1()))}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$12 = this.linkName();
            Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"SOURCE")}));
            Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
            qual$3.alterClusterLink(x$12, (Map<String, String>)x$13, x$14);
        });
        Assertions.assertThrows(InvalidConfigurationException.class, () -> connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConnectionModeProp()), (Object)"INBOUND")}))), connectingCluster.alterClusterLink$default$3()));
        Assertions.assertEquals((Object)LinkMode.Destination$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().linkMode());
        Assertions.assertEquals((Object)ConnectionMode.Outbound$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)connectingCluster.brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().connectionMode());
        String trustStoreConfigName = this.useSourceInitiatedLink() ? new StringBuilder(23).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.location").toString() : "ssl.truststore.location";
        File oldFile = new File(connectingCluster.describeClusterLink(this.linkName()).get(trustStoreConfigName).value());
        File newFile = File.createTempFile("truststore", ".jks");
        Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trustStoreConfigName), (Object)newFile.getAbsolutePath())}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        int firstDestBroker = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        java.util.Map destReassignment = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.partitions(this.partitions$default$1()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(firstDestBroker))))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.destCluster().alterPartitionAssignment(destReassignment);
        this.destCluster().ensureConsistentKRaftMetadata();
        int firstSourceBroker = ((KafkaBroker)this.sourceCluster().brokers().head()).config().brokerId();
        java.util.Map sourceReassignment = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.partitions(this.partitions$default$1()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(firstSourceBroker))))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.sourceCluster().alterPartitionAssignment(sourceReassignment);
        this.sourceCluster().ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.maxFetcherThreadCount(linkId));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = this.linkName();
        Map x$16 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"3")}));
        Seq<KafkaBroker> x$17 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$15, (Map<String, String>)x$16, x$17);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = this.maxFetcherThreadCount(linkId);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAlterClusterLinkConfigs$6(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int threads = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)3, (int)var31_37);
        this.produceToSourceCluster(8);
        this.consume(this.destCluster(), this.consume$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMigrationWithAddedConsumerGroup(String quorum) {
        long finalOffset = 20L;
        String additionalConsumerGroup = "testGroup2";
        String multiConsumerGroupFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"groupFilters\": [\n          |  {\n          |     \"name\": \"").append(this.consumerGroup()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(additionalConsumerGroup).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = 2;
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)multiConsumerGroupFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$12, (Map<String, String>)updatedProps, x$14);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, additionalConsumerGroup);
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, additionalConsumerGroup);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$16 = this.linkName();
        boolean x$17 = qual$4.unlinkTopic$default$3();
        boolean x$18 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$15, x$16, x$17, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.linkName();
        boolean x$20 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$21 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$19, x$20, x$21);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMigrationWithAddedTopic(String quorum) {
        long finalOffset = 20L;
        String additionalTopic = "linkedTopic2";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(additionalTopic, x$8, x$9, x$10, x$11, x$12);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        short x$14 = 2;
        String x$15 = this.linkName();
        String x$16 = this.clusterLinkPrefix();
        Map<String, String> x$17 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$13, x$14, x$15, x$17, x$16);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        short x$19 = 2;
        String x$20 = this.linkName();
        String x$21 = this.clusterLinkPrefix();
        Map<String, String> x$22 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(additionalTopic, x$19, x$20, x$22, x$21);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), additionalTopic, 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString(), 0, finalOffset, this.consumerGroup());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$24 = this.linkName();
        boolean x$25 = false;
        boolean x$26 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$23, x$24, x$25, x$26);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter(this.consumerGroup()).replaceAll("include", "exclude"))}))));
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", this.consumerGroup());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        ByteArrayDeserializer x$28 = qual$6.createConsumer$default$1();
        ByteArrayDeserializer x$29 = qual$6.createConsumer$default$2();
        List<String> x$30 = qual$6.createConsumer$default$4();
        KafkaConsumer destConsumer = qual$6.createConsumer(x$28, x$29, consumerProps, x$30);
        destConsumer.subscribe(Collections.singleton(additionalTopic));
        do {
            destConsumer.poll(Duration.ofMillis(10L));
        } while (destConsumer.assignment().isEmpty());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> destConsumer.poll(Duration.ofMillis(10L)));
        try {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$31 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString();
            String x$32 = this.linkName();
            boolean x$33 = qual$7.unlinkTopic$default$3();
            boolean x$34 = qual$7.unlinkTopic$default$4();
            qual$7.unlinkTopic(x$31, x$32, x$33, x$34);
            this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString());
        }
        finally {
            executor.shutdownNow();
        }
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$35 = this.linkName();
        boolean x$36 = qual$8.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$37 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$35, x$36, x$37);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestReadOnly(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ByteArraySerializer x$12 = qual$3.createProducer$default$1();
        ByteArraySerializer x$13 = qual$3.createProducer$default$2();
        Properties x$14 = qual$3.createProducer$default$3();
        KafkaProducer destProducer = qual$3.createProducer(x$12, x$13, x$14);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> destProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes())).get(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)e.getMessage().contains("Cannot append records to read-only mirror topic"), (String)new StringBuilder(17).append("Unexpected error ").append(e.getMessage()).toString());
        Assertions.assertThrows(InvalidPartitionsException.class, () -> this.destCluster().createPartitions(this.topic(), 8));
        this.destCluster().withAdmin((Function1 & Serializable & scala.Serializable)admin -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$3(this, admin);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = this.topic();
        String x$16 = this.linkName();
        boolean x$17 = qual$4.unlinkTopic$default$3();
        boolean x$18 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$15, x$16, x$17, x$18);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        this.produceRecords(destProducer, this.topic(), 10, this.produceRecords$default$4());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.linkName();
        boolean x$20 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$21 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$19, x$20, x$21);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteClusterLinkCleanup(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        scala.collection.immutable.Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkIntegrationTest.$anonfun$testDeleteClusterLinkCleanup$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ClusterLinkTestHarness qual$1 = this.sourceCluster();
            int x$2 = this.numPartitions();
            short x$3 = this.replicationFactor();
            Properties x$4 = qual$1.createTopic$default$4();
            ListenerName x$5 = qual$1.createTopic$default$5();
            Properties x$6 = qual$1.createTopic$default$6();
            qual$1.createTopic((String)topic, x$2, x$3, x$4, x$5, x$6);
            ClusterLinkTestHarness qual$2 = this.destCluster();
            short x$8 = this.replicationFactor();
            String x$9 = this.linkName();
            Map<String, String> x$10 = qual$2.linkTopic$default$4();
            String x$11 = qual$2.linkTopic$default$5();
            return qual$2.linkTopic((String)topic, x$8, x$9, x$10, x$11);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        boolean x$12 = qual$3.listMirrorTopics$default$1();
        Assertions.assertEquals((int)topics.size(), (int)qual$3.listMirrorTopics(x$12).size());
        Assertions.assertThrows(ClusterLinkInUseException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$13 = this.linkName();
            boolean x$14 = qual$4.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$15 = qual$4.deleteClusterLink$default$3();
            qual$4.deleteClusterLink(x$13, x$14, x$15);
        });
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = this.linkName();
        boolean x$17 = true;
        Seq<KafkaBroker> x$18 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$16, x$17, x$18);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$19 = qual$6.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$6.listMirrorTopics(x$19).isEmpty());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        boolean x$20 = qual$7.listClusterLinks$default$1();
        Assertions.assertTrue((boolean)qual$7.listClusterLinks(x$20).isEmpty());
        Assertions.assertThrows(ClusterLinkNotFoundException.class, () -> this.destCluster().describeClusterLink(this.linkName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirroredTopicMarkedForDelete(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        int brokerId = this.destCluster().shutdownLeader((TopicPartition)partitions.head())._1$mcI$sp();
        Seq otherBrokers = ((SeqLike)this.destCluster().brokers().filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$2(brokerId, x$27)))).toSeq();
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        otherBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$3(partitions, linkId, broker);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.linkName();
        boolean x$14 = qual$3.deleteClusterLink$default$2();
        qual$3.deleteClusterLink(x$12, x$14, (Seq<KafkaBroker>)otherBrokers);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPauseTopic(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$8 = qual$2.pauseTopic$default$2();
            qual$2.pauseTopic(x$7, x$8);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$9 = this.topic();
        short x$10 = this.replicationFactor();
        String x$11 = this.linkName();
        String x$12 = this.clusterLinkPrefix();
        Map<String, String> x$13 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$9, x$10, x$11, x$13, x$12);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$15 = qual$4.pauseTopic$default$2();
        qual$4.pauseTopic(x$14, x$15);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$17 = qual$5.pauseTopic$default$2();
        qual$5.pauseTopic(x$16, x$17);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testPauseTopic$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyMirrorTopicCountMetric("mirror-topic-count", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)"PausedMirror")}))), this.verifyMirrorTopicCountMetric$default$3(), this.verifyMirrorTopicCountMetric$default$4());
        Seq oldLeaderOffsets = this.leaderOffsets$1();
        this.produceToSourceCluster(8);
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)oldLeaderOffsets, (Object)this.leaderOffsets$1());
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$23 = qual$7.replicaStatus$default$3();
            Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)((ReplicaStatus.MirrorInfo)((ReplicaStatus)((IterableLike)qual$7.replicaStatus(x$21, partition, x$23).filter((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.isLeader()))).head()).mirrorInfo().get()).state());
        });
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$24 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$25 = this.linkName();
        boolean x$26 = qual$8.unlinkTopic$default$3();
        boolean x$27 = qual$8.unlinkTopic$default$4();
        qual$8.unlinkTopic(x$24, x$25, x$26, x$27);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$9 = this.destCluster();
            String x$28 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$29 = qual$9.pauseTopic$default$2();
            qual$9.pauseTopic(x$28, x$29);
        });
        ClusterLinkTestHarness qual$10 = this.destCluster();
        String x$30 = this.linkName();
        boolean x$31 = qual$10.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$32 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(x$30, x$31, x$32);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPauseClusterLink(String quorum) {
        void var26_38;
        Tuple2 tuple2;
        void var25_31;
        Tuple2 tuple22;
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        int oldNumPartitions = this.numPartitions();
        String oldDeleteRetentionMs = "10000";
        int oldOffset = 10;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, oldNumPartitions, x$3, x$4, x$5, x$6);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)oldDeleteRetentionMs)}))));
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty("metadata.max.age.ms", "100");
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyConsumerOffsetMigrationMetrics();
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        int newNumPartitions = oldNumPartitions + 2;
        String newDeleteRetentionMs = "20000";
        int newOffset = 20;
        this.sourceCluster().createPartitions(this.topic(), newNumPartitions);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)newDeleteRetentionMs)}))));
        this.produceToSourceCluster(8);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyPausedLinkMetrics();
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.PAUSED, ClusterLinkDescription.LinkState.PAUSED);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        boolean x$13 = qual$3.pauseTopic$default$2();
        qual$3.pauseTopic(x$12, x$13);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        Assertions.assertThrows(ClusterLinkPausedException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$14 = "paused-topic";
            short x$15 = this.replicationFactor();
            String x$16 = this.linkName();
            Map<String, String> x$17 = qual$4.linkTopic$default$4();
            String x$18 = qual$4.linkTopic$default$5();
            qual$4.linkTopic(x$14, x$15, x$16, x$17, x$18);
        });
        Thread.sleep(250L);
        Assertions.assertEquals((int)oldNumPartitions, (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Assertions.assertEquals((Object)oldDeleteRetentionMs, (Object)this.destCluster().describeTopicConfig(this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value());
        Assertions.assertEquals((long)oldOffset, (long)this.destCluster().getOffset(this.topic(), 0, this.consumerGroup()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$2(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$3(newNumPartitions, n)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)newNumPartitions, (int)var25_31);
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            String computeUntilTrue_result;
            String string;
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs, string = (computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$4(this)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String destDeleteRetentionMs = (String)tuple2._1();
        Assertions.assertEquals((Object)newDeleteRetentionMs, (Object)var26_38);
        this.verifyOffsetMigration(this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.topic();
        String x$20 = this.linkName();
        boolean x$21 = qual$5.unlinkTopic$default$3();
        boolean x$22 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$25 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$23, x$24, x$25);
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicaStatus(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        qual$1 = this.sourceCluster();
        x$1 = this.topic();
        x$2 = this.numPartitions();
        x$3 = this.replicationFactor();
        x$4 = qual$1.createTopic$default$4();
        x$5 = qual$1.createTopic$default$5();
        x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        rs1 = this.sourceCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)2, (int)rs1.size());
        leader1 = (ReplicaStatus)((IterableLike)rs1.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$1$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)leader1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)leader1.mirrorInfo());
        follower1 = (ReplicaStatus)((IterableLike)rs1.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$2$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)follower1.mirrorInfo());
        timestamp = Time.SYSTEM.milliseconds();
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        qual$2 = this.destCluster();
        x$7 = this.topic();
        x$8 = this.replicationFactor();
        x$9 = this.linkName();
        x$10 = qual$2.linkTopic$default$4();
        x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        expectedLeaderEpoch = this.destCluster().isKRaftTest() != false ? 0 : 1;
        var51_20 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var49_21 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$3(this, expectedLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs2 = this.destCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)4, (int)rs2.size());
        localLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$5$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)localLeader2.mirrorInfo().isPresent());
        mi2 = (ReplicaStatus.MirrorInfo)localLeader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi2.state());
        Assertions.assertTrue((boolean)(timestamp <= mi2.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(timestamp).append(" <= ").append(mi2.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)numRecords, (long)mi2.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        localFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$6$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)localFollower2.mirrorInfo());
        remoteLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$7$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteLeader2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteLeader2.mirrorInfo());
        remoteFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$8$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteFollower2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteFollower2.mirrorInfo());
        lastFetchTimeMs = mi2.lastFetchTimeMs();
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs3 = this.destCluster().replicaStatus(this.topic(), 0, false);
        Assertions.assertEquals((int)2, (int)rs3.size());
        leader3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$9$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader3.mirrorInfo().isPresent());
        mi3 = (ReplicaStatus.MirrorInfo)leader3.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi3.state());
        Assertions.assertTrue((boolean)(lastFetchTimeMs <= mi3.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(lastFetchTimeMs).append(" <= ").append(mi3.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)(numRecords * 2), (long)mi3.lastFetchSourceHighWatermark());
        follower3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$10$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower3.mirrorInfo());
        qual$3 = this.destCluster();
        x$12 = this.topic();
        x$13 = this.linkName();
        x$14 = qual$3.unlinkTopic$default$3();
        x$15 = qual$3.unlinkTopic$default$4();
        qual$3.unlinkTopic(x$12, x$13, x$14, x$15);
        rs4 = ObjectRef.create(null);
        var57_41 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var55_42 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$11(this, rs4)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leader4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$13$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader4.mirrorInfo().isPresent());
        mi4 = (ReplicaStatus.MirrorInfo)leader4.mirrorInfo().get();
        v0 = mi4.state();
        var42_46 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        if (!(v0 == null ? var42_46 != null : v0.equals(var42_46) == false)) ** GOTO lbl-1000
        v1 = mi4.state();
        var43_47 = ReplicaStatus.MirrorInfo.State.STOPPED;
        if (!(v1 != null ? v1.equals(var43_47) == false : var43_47 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchTimeMs());
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        follower4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$14$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower4.mirrorInfo());
        qual$4 = this.destCluster();
        x$16 = this.linkName();
        x$17 = qual$4.deleteClusterLink$default$2();
        x$18 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroring(String quorum) {
        this.autoMirrorTopic(this.syncPeriod());
        String newTopic = new StringBuilder(2).append(this.topic()).append("-2").toString();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
        qual$1.alterClusterLink(x$1, (Map<String, String>)x$2, x$3);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$4 = String.valueOf(newTopic);
        int x$5 = qual$2.createTopic$default$2();
        int x$6 = qual$2.createTopic$default$3();
        Properties x$7 = qual$2.createTopic$default$4();
        ListenerName x$8 = qual$2.createTopic$default$5();
        Properties x$9 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$4, x$5, x$6, x$7, x$8, x$9);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString());
        Thread.sleep(this.syncPeriod() * 5L);
        Assertions.assertEquals((double)0.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-create-failed-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-created-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(newTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.linkName();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter)}));
        Seq<KafkaBroker> x$12 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$10, (Map<String, String>)x$11, x$12);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString(), true);
        Thread.sleep(1000L);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$13 = qual$4.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$4.listMirrorTopics(x$13).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString()));
        String conflictingTopic = new StringBuilder(9).append(this.topic()).append("-conflict").toString();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        int x$15 = qual$5.createTopic$default$2();
        int x$16 = qual$5.createTopic$default$3();
        Properties x$17 = qual$5.createTopic$default$4();
        ListenerName x$18 = qual$5.createTopic$default$5();
        Properties x$19 = qual$5.createTopic$default$6();
        qual$5.createTopic(x$14, x$15, x$16, x$17, x$18, x$19);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        int x$21 = qual$6.createTopic$default$2();
        int x$22 = qual$6.createTopic$default$3();
        Properties x$23 = qual$6.createTopic$default$4();
        ListenerName x$24 = qual$6.createTopic$default$5();
        Properties x$25 = qual$6.createTopic$default$6();
        qual$6.createTopic(conflictingTopic, x$21, x$22, x$23, x$24, x$25);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$26 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        String x$27 = this.linkName();
        boolean x$28 = false;
        boolean x$29 = qual$7.unlinkTopic$default$4();
        qual$7.unlinkTopic(x$26, x$27, x$28, x$29);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$30 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$31 = this.linkName();
        boolean x$32 = qual$8.unlinkTopic$default$3();
        boolean x$33 = qual$8.unlinkTopic$default$4();
        qual$8.unlinkTopic(x$30, x$31, x$32, x$33);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$34 = this.linkName();
        boolean x$35 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$36 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$34, x$35, x$36);
    }

    public void autoMirrorTopic(long syncPeriod) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), Long.toString(syncPeriod * 10L));
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAutoMirroringSuccessMetric();
    }

    public Properties destLinkPropsForAutoMirroring(String topicFilters, boolean configureLinkPrefix) {
        scala.collection.mutable.Map autoMirrorOverrides = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)topicFilters);
        autoMirrorOverrides.put((Object)"metadata.max.age.ms", (Object)Long.toString(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty() && configureLinkPrefix) {
            autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), (Object)this.clusterLinkPrefix());
        }
        return this.destLinkProps((Map<String, String>)autoMirrorOverrides);
    }

    public boolean destLinkPropsForAutoMirroring$default$2() {
        return false;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedOffsetPromotedMirrorTopicDescription(String quorum) {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(this.testLastFetchedOffsetStoppedMirrorTopicDescription$default$1());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedOffsetFailedOverMirrorTopicDescription(String quorum) {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringNoOverlappingTopicFilters(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        String topicTwo = "linkedTopicTwo";
        String multipleOverlappingTopicFilters = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(335).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |    \"name\": \"").append(topicTwo).append("\",\n          |    \"patternType\": \"literal\",\n          |    \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        Properties linkProps = this.destLinkPropsForAutoMirroring(multipleOverlappingTopicFilters, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        Properties linkPropsTwo = this.destLinkPropsForAutoMirroring(this.includeAllTopicsFilter(), this.destLinkPropsForAutoMirroring$default$2());
        UUID linkIdTwo = this.createClusterLink(linkNameTwo, linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        InvalidConfigurationException exceptionTwo = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
            qual$1.alterClusterLink(linkNameTwo, (Map<String, String>)x$2, x$3);
        });
        Assertions.assertEquals((Object)"Found overlapping topic filter(s): new topic filter linkedTopic overlaps with existing topic filter from cluster link testLink.", (Object)exceptionTwo.getMessage());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$4 = this.linkName();
        boolean x$5 = qual$2.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$6 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$4, x$5, x$6);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$3 = this.sourceCluster();
            String x$7 = this.linkName();
            boolean x$8 = qual$3.deleteClusterLink$default$2();
            Seq<KafkaBroker> x$9 = qual$3.deleteClusterLink$default$3();
            qual$3.deleteClusterLink(x$7, x$8, x$9);
            ClusterLinkTestHarness qual$4 = this.sourceCluster();
            boolean x$10 = qual$4.listClusterLinks$default$1();
            Assertions.assertTrue((qual$4.listClusterLinks(x$10).size() == 1 ? 1 : 0) != 0);
            ClusterLinkTestHarness qual$5 = this.sourceCluster();
            boolean x$11 = qual$5.describeClusterLinks$default$1();
            Assertions.assertTrue((qual$5.describeClusterLinks(x$11).size() == 1 ? 1 : 0) != 0);
        }
        ClusterLinkTestHarness qual$6 = this.destCluster();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$14 = qual$6.alterClusterLink$default$3();
        qual$6.alterClusterLink(linkNameTwo, (Map<String, String>)x$13, x$14);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        Map x$16 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$17 = qual$7.alterClusterLink$default$3();
        qual$7.alterClusterLink(linkNameTwo, (Map<String, String>)x$16, x$17);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.createClusterLink(this.linkName(), linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Map x$19 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$20 = qual$8.alterClusterLink$default$3();
        qual$8.alterClusterLink(linkNameTwo, (Map<String, String>)x$19, x$20);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$21 = this.linkName();
        boolean x$22 = qual$9.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$23 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$21, x$22, x$23);
        ClusterLinkTestHarness qual$10 = this.destCluster();
        boolean x$25 = qual$10.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$26 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(linkNameTwo, x$25, x$26);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringAllowsLinkConfigUpdate(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkPropsOne = this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkPropsOne, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(this.topic());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        Map x$8 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}));
        Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$7, (Map<String, String>)x$8, x$9);
        String topicTwo = "linkedTopicTwo";
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        int x$11 = this.numPartitions();
        short x$12 = this.replicationFactor();
        Properties x$13 = qual$3.createTopic$default$4();
        ListenerName x$14 = qual$3.createTopic$default$5();
        Properties x$15 = qual$3.createTopic$default$6();
        qual$3.createTopic(topicTwo, x$11, x$12, x$13, x$14, x$15);
        this.produceToSourceCluster(numRecords);
        ObjectRef linkPropsTwo = ObjectRef.create((Object)this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2()));
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo$1.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        linkPropsTwo.elem = this.destLinkPropsForAutoMirroring(topicFilterTwo, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(this.topic());
        this.waitForAutoMirrorCreation(topicTwo);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.linkName();
        Map x$17 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        Seq<KafkaBroker> x$18 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$16, (Map<String, String>)x$17, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.topic();
        String x$20 = this.linkName();
        boolean x$21 = false;
        boolean x$22 = qual$5.unlinkTopic$default$3();
        qual$5.unlinkTopic(x$19, x$20, x$22, x$21);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$25 = false;
        boolean x$26 = qual$6.unlinkTopic$default$3();
        qual$6.unlinkTopic(topicTwo, linkNameTwo, x$26, x$25);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$27 = this.linkName();
        boolean x$28 = true;
        Seq<KafkaBroker> x$29 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$27, x$28, x$29);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        boolean x$31 = true;
        Seq<KafkaBroker> x$32 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(linkNameTwo, x$31, x$32);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorTopicCountForMultipleLinks(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        String secondLink = new StringBuilder(3).append(this.linkName()).append("Two").toString();
        String secondTopic = new StringBuilder(3).append(this.topic()).append("Two").toString();
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        int x$13 = this.numPartitions();
        short x$14 = this.replicationFactor();
        Properties x$15 = qual$3.createTopic$default$4();
        ListenerName x$16 = qual$3.createTopic$default$5();
        Properties x$17 = qual$3.createTopic$default$6();
        qual$3.createTopic(secondTopic, x$13, x$14, x$15, x$16, x$17);
        this.createClusterLink(secondLink, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        short x$19 = this.replicationFactor();
        Map<String, String> x$21 = qual$4.linkTopic$default$4();
        String x$22 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(secondTopic, x$19, secondLink, x$21, x$22);
        this.verifyMirrorTopicCount("mirror-topic-count", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), 1, this.linkName(), this.verifyMirrorTopicCount$default$5());
        this.verifyMirrorTopicCount("mirror-topic-count", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), 1, secondLink, this.verifyMirrorTopicCount$default$5());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringUpdateExistingLink(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)Long.toString(this.syncPeriod()))}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(x$7, x$8, x$9, x$10, x$11, x$12);
        scala.collection.mutable.Map autoMirrorProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)this.topicFilter());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$13 = this.linkName();
            Seq<KafkaBroker> x$15 = qual$3.alterClusterLink$default$3();
            qual$3.alterClusterLink(x$13, (Map<String, String>)autoMirrorProps, x$15);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.linkName();
        Seq<KafkaBroker> x$18 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$16, (Map<String, String>)autoMirrorProps, x$18);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$20 = this.linkName();
        boolean x$21 = false;
        boolean x$22 = qual$5.unlinkTopic$default$3();
        qual$5.unlinkTopic(x$19, x$20, x$22, x$21);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$25 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$23, x$24, x$25);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringAddingAdditionalTopic(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String topicTwo = "linkedTopic2";
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topicTwo, x$8, x$9, x$10, x$11, x$12);
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.linkName();
        Map x$14 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilterTwo)}));
        Seq<KafkaBroker> x$15 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$13, (Map<String, String>)x$14, x$15);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString());
        this.destCluster().unlinkTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), this.linkName(), false, false);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString();
        String x$17 = this.linkName();
        boolean x$18 = false;
        boolean x$19 = qual$4.unlinkTopic$default$3();
        qual$4.unlinkTopic(x$16, x$17, x$19, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$20 = this.linkName();
        boolean x$21 = true;
        Seq<KafkaBroker> x$22 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$20, x$21, x$22);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringNoExistingTopic(String quorum) {
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$2 = qual$1.createTopic$default$2();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$7 = this.linkName();
            Map x$8 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
            qual$2.alterClusterLink(x$7, (Map<String, String>)x$8, x$9);
        });
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.linkName();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$12 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$10, (Map<String, String>)x$11, x$12);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$13 = this.linkName();
        Map x$14 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$15 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$13, (Map<String, String>)x$14, x$15);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$16 = this.linkName();
        boolean x$17 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$18 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$16, x$17, x$18);
    }

    /*
     * WARNING - void declaration
     */
    private void testLastFetchedOffsetStoppedMirrorTopicDescription(boolean promote) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$13 = 0;
        boolean x$14 = qual$3.replicaStatus$default$3();
        ReplicaStatus leader = (ReplicaStatus)((IterableLike)qual$3.replicaStatus(x$12, x$13, x$14).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(rs)))).head();
        Assertions.assertTrue((boolean)leader.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi.state());
        Assertions.assertEquals((long)numRecords, (long)mi.lastFetchSourceHighWatermark());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$16 = this.linkName();
        boolean x$18 = qual$4.unlinkTopic$default$3();
        qual$4.unlinkTopic(x$15, x$16, x$18, promote);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$20 = 0;
        boolean x$21 = qual$5.replicaStatus$default$3();
        ReplicaStatus leader2 = (ReplicaStatus)((IterableLike)qual$5.replicaStatus(x$19, x$20, x$21).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(rs)))).head();
        Assertions.assertTrue((boolean)leader2.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi2 = (ReplicaStatus.MirrorInfo)leader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.STOPPED, (Object)mi2.state());
        Assertions.assertEquals((long)-1L, (long)mi2.lastFetchSourceHighWatermark());
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertEquals((Object)desc.state(), (Object)MirrorTopicDescription.State.STOPPED);
        Assertions.assertEquals((int)1, (int)desc.stoppedLogEndOffsets().size());
        Assertions.assertEquals((long)numRecords, (long)Predef$.MODULE$.Long2long((Long)desc.stoppedLogEndOffsets().get(0)));
    }

    private boolean testLastFetchedOffsetStoppedMirrorTopicDescription$default$1() {
        return true;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteAutoMirroredTopics(String quorum) {
        this.autoMirrorTopic(this.syncPeriod());
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$1.listMirrorTopics(x$1).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$2 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$3 = this.linkName();
        boolean x$4 = qual$2.unlinkTopic$default$3();
        boolean x$5 = qual$2.unlinkTopic$default$4();
        qual$2.unlinkTopic(x$2, x$3, x$4, x$5);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.FAILED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$6 = this.topic();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$3.createTopic$default$4();
        ListenerName x$10 = qual$3.createTopic$default$5();
        Properties x$11 = qual$3.createTopic$default$6();
        qual$3.createTopic(x$6, x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(20);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$12 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$12, (Map<String, String>)updatedProps, x$14);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        boolean x$15 = qual$5.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$5.listMirrorTopics(x$15).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$16 = this.linkName();
        boolean x$17 = qual$6.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$18 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$16, x$17, x$18);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIntervalChangeForPeriodicTasks(String quorum) {
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        linkProps.setProperty("metadata.max.age.ms", String.valueOf(300000));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = 2;
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyTopicConfigChangeMetrics();
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$4();
        qual$3.unlinkTopic(x$12, x$13, x$14, x$15);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}))));
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}))));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$17 = this.linkName();
        boolean x$18 = qual$4.unlinkTopic$default$3();
        boolean x$19 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$16, x$17, x$18, x$19);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$20 = this.linkName();
        boolean x$21 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$22 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$20, x$21, x$22);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExternalizedPasswordConfig(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        File propsFile = TestUtils.tempFile((String)new StringBuilder(17).append("sasl.jaas.config=").append(linkProps.getProperty("sasl.jaas.config")).toString());
        String arg$macro$1 = propsFile.getAbsolutePath();
        linkProps.put("sasl.jaas.config", new StringOps("${file:%s:sasl.jaas.config}").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        linkProps.setProperty("config.providers", "file");
        linkProps.setProperty("config.providers.file.class", FileConfigProvider.class.getName());
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifySaslJaasConfigEncrypted(linkId);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp()), (Object)"1000")}))));
        this.verifySaslJaasConfigEncrypted(linkId);
        this.produceToSourceCluster(numRecords);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
        linkProps.setProperty("sasl.jaas.config", "someprovider:link.props:sasl.jaas.config");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            String x$12 = "invalidLink1";
            boolean x$14 = true;
            Option<Properties> x$15 = this.createClusterLink$default$3();
            this.createClusterLink(x$12, linkProps, x$15, x$14);
        });
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            String x$16 = "invalidLink2";
            boolean x$18 = false;
            Option<Properties> x$19 = this.createClusterLink$default$3();
            this.createClusterLink(x$16, linkProps, x$19, x$18);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorFailoverWhenSourceIsUnavailable(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        String x$10 = this.clusterLinkPrefix();
        Map<String, String> x$11 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$7, x$8, x$9, x$11, x$10);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        this.updateCredentials(connectionTarget);
        this.waitUntilOneOfMirrorStates((scala.collection.immutable.Set<ReplicaStatus.MirrorInfo.State>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.SOURCE_AUTHENTICATION_FAILED, ReplicaStatus.MirrorInfo.State.SOURCE_UNAVAILABLE}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.UNAVAILABLE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$13 = this.linkName();
        boolean x$14 = false;
        boolean x$15 = qual$3.unlinkTopic$default$3();
        qual$3.unlinkTopic(x$12, x$13, x$15, x$14);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterLinkMetadataTopicCreation(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.destCluster().killAllBrokers();
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "2");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "1");
        this.destCluster().restartDeadBrokers(true);
        this.destCluster().updateBootstrapServers();
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.enable");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.partitions");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.replication.factor");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDescribeClusterLink(String quorum) {
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$12 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$12);
        this.waitForFailure(destAdmin, FailureType$CorruptConfigs$.MODULE$);
        destAdmin.close();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$13 = qual$4.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> describeResult = qual$4.describeClusterLinks(x$13);
        Assertions.assertEquals((int)1, (int)describeResult.size());
        Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)describeResult.head()).linkName());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.FAILED, (Object)((ClusterLinkDescription)describeResult.head()).linkState());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).linkMode());
        Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).connectionMode());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAlterClusterLinkWithInvalidConfigs(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$7 = this.linkName();
        boolean x$9 = true;
        Option<Properties> x$10 = this.createClusterLink$default$3();
        UUID linkId = this.createClusterLink(x$7, linkProps, x$10, x$9);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), "{");
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$11 = this.linkName();
        Map x$12 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.includeAllTopicsFilter().replace("topic", "group"))}));
        Seq<KafkaBroker> x$13 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$11, (Map<String, String>)x$12, x$13);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$14 = this.topic();
        short x$15 = this.replicationFactor();
        String x$16 = this.linkName();
        String x$17 = this.clusterLinkPrefix();
        Map<String, String> x$18 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$14, x$15, x$16, x$18, x$17);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$20 = this.linkName();
        boolean x$21 = qual$4.unlinkTopic$default$3();
        boolean x$22 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$5.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$25 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$23, x$24, x$25);
    }

    public void verifyDescribeLinksResult(ClusterLinkDescription.LinkState destLinkState, ClusterLinkDescription.LinkState sourceLinkState) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> sourceLinkDescription = qual$1.describeClusterLinks(x$1);
        if (this.useSourceInitiatedLink()) {
            Assertions.assertEquals((int)1, (int)sourceLinkDescription.size());
            Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkName());
            Assertions.assertEquals((Object)sourceLinkState, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkState());
            Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.SOURCE, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkMode());
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).connectionMode());
        } else {
            Assertions.assertTrue((boolean)sourceLinkDescription.isEmpty());
        }
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$2 = qual$2.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> destLinkDescription = qual$2.describeClusterLinks(x$2);
        Assertions.assertEquals((int)1, (int)destLinkDescription.size());
        Assertions.assertEquals((Object)destLinkState, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkState());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.DESTINATION, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkMode());
        if (this.useSourceInitiatedLink()) {
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.INBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
            return;
        }
        Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
    }

    private void verifySaslJaasConfigEncrypted(UUID linkId) {
        String jaasConfig = ((ClusterLinkMetadataManager)((KafkaBroker)this.connectingCluster().brokers().head()).clusterLinkManager().clusterLinkMetadataManager().get()).getClusterLinkConfigProps(linkId).getProperty("sasl.jaas.config");
        Assertions.assertNotNull((Object)jaasConfig);
        Assertions.assertFalse((boolean)jaasConfig.contains("secret-"), (String)new StringBuilder(24).append("Password not encrypted: ").append(jaasConfig).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$1) {
        String string = x$1.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$2(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$2) {
        String string = x$2.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopicAndVerifySourceTopicId$2(ClusterLinkIntegrationTest $this, Uuid sourceTopicId$1, Tuple2 keyVal) {
        Object object = keyVal._1();
        String string = new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            Uuid uuid = ((ClusterLinkTopicState)keyVal._2()).sourceTopicId();
            if (!(uuid != null ? !uuid.equals(sourceTopicId$1) : sourceTopicId$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopicAndVerifySourceTopicId$1(ClusterLinkIntegrationTest $this, Uuid sourceTopicId$1, ClusterLinkMetadataManager manager) {
        return manager.clusterLinkTopicState((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()}))).exists((Function1 & Serializable & scala.Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopicAndVerifySourceTopicId$2($this, sourceTopicId$1, keyVal)));
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionsWithMirrorTopic$4(ClusterLinkIntegrationTest $this) {
        return ((SeqLike)$this.partitions($this.partitions$default$1()).flatMap((Function1 & Serializable & scala.Serializable)tp -> (Buffer)((TraversableLike)$this.destCluster().brokers().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.replicaManager().onlinePartition(tp)), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.linkedUpdatesOnly())), Seq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionsWithMirrorTopic$8() {
        return "Mirror not stopped";
    }

    private final void restartMirrorTopic$1() {
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        short x$2 = this.replicationFactor();
        String x$3 = this.linkName();
        Map<String, String> x$4 = qual$1.linkTopic$default$4();
        String x$5 = qual$1.linkTopic$default$5();
        qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
    }

    private final void restartSource$1() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.restartDeadBrokers$default$1();
        qual$1.restartDeadBrokers(x$1);
        this.sourceCluster().updateBootstrapServers();
        if (!this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$3 = this.linkName();
            Tuple2[] tuple2Array = new Tuple2[1];
            ClusterLinkTestHarness qual$3 = this.sourceCluster();
            ListenerName x$2 = qual$3.bootstrapServers$default$1();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)qual$3.bootstrapServers(x$2));
            Map x$4 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            Seq<KafkaBroker> x$5 = qual$2.alterClusterLink$default$3();
            qual$2.alterClusterLink(x$3, (Map<String, String>)x$4, x$5);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$5) {
        String string = x$5.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$2(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$6) {
        String string = x$6.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$testCreateAndDeleteAndRecreateLink$3(KafkaBroker broker$1) {
        return broker$1.clusterLinkManager().listClusterLinks();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$4(Seq x$7) {
        Seq seq = x$7;
        Nil$ nil$ = Nil$.MODULE$;
        return !(seq != null ? !seq.equals(nil$) : nil$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$5(ClusterLinkIntegrationTest $this, ClusterLinkListing x$8) {
        String string = x$8.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$6(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$9) {
        String string = x$9.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$7(Option metadataManager$1, UUID newLinkId$1) {
        return !((ClusterLinkMetadataManager)metadataManager$1.get()).clusterLinkExists(newLinkId$1);
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteAndRecreateLink$8(UUID newLinkId$1) {
        return new StringBuilder(28).append("Cluster link ").append(newLinkId$1).append(" is not deleted").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSync$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSync$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$1(ClusterLinkIntegrationTest $this) {
        MirrorTopicDescription.State state = $this.destCluster().describeMirrorTopic($this.topic()).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$2() {
        return "Mirror took too long to stop.";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics(true).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$5() {
        return "Mirror state not removed";
    }

    private final void setQuota$1(long byteRate, ConfluentAdmin sourceAdmin$1) {
        ClientQuotaEntity quotaUser = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)this.linkUserName(this.linkName()))}))).asJava());
        ClientQuotaAlteration.Op quotaOp = new ClientQuotaAlteration.Op(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), Predef$.MODULE$.double2Double((double)byteRate));
        ClientQuotaAlteration quota = new ClientQuotaAlteration(quotaUser, Collections.singleton(quotaOp));
        sourceAdmin$1.alterClientQuotas(Collections.singleton(quota)).all().get(15L, TimeUnit.SECONDS);
    }

    private final boolean throttled$1() {
        return this.kafkaMetricMaxValue((Seq<KafkaBroker>)this.destCluster().brokers(), "fetch-throttle-time-max", "cluster-link", (Option<String>)new Some((Object)this.linkName()), this.kafkaMetricMaxValue$default$5(), this.kafkaMetricMaxValue$default$6()) > 0.0;
    }

    public static final /* synthetic */ int $anonfun$testDestinationClusterLinkBrokerLevelQuota$1(KafkaBroker x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ ConfigResource $anonfun$testDestinationClusterLinkBrokerLevelQuota$2(int brokerId) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId));
    }

    private static final void setQuota$2(long byteRate, Seq resources$1, ConfluentAdmin destAdmin$1) {
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), Long.toString(byteRate)), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources$1.map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$13), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin$1.incrementalAlterConfigs(configs).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$verifyQuotaMode$1(KafkaBroker broker$2, ConfluentConfigs.ClusterLinkQuotaMode quotaMode$1) {
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = broker$2.config().clusterLinkQuotaMode();
        return !(clusterLinkQuotaMode != null ? !clusterLinkQuotaMode.equals(quotaMode$1) : quotaMode$1 != null);
    }

    public static final /* synthetic */ String $anonfun$verifyQuotaMode$2() {
        return "Quota mode not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$2(ClusterLinkFetcherManager x$15) {
        return x$15.fetcherThreadCount() > 0;
    }

    private static final int fetchSize$1(LeaderEndPoint fetcherThreadLeaderEndPoint$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)fetcherThreadLeaderEndPoint$1, ClusterLinkLeaderEndPoint.class, (String)"fetchSize"));
    }

    private static final ClusterLinkLeaderRequestBuilder fetcherThreadLeaderRequestBuilder$1(LeaderEndPoint fetcherThreadLeaderEndPoint$1) {
        return (ClusterLinkLeaderRequestBuilder)TestUtils.fieldValue((Object)fetcherThreadLeaderEndPoint$1, ClusterLinkLeaderEndPoint.class, (String)"requestBuilder");
    }

    private static final int fetchResponseSize$1(LeaderEndPoint fetcherThreadLeaderEndPoint$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)ClusterLinkIntegrationTest.fetcherThreadLeaderRequestBuilder$1(fetcherThreadLeaderEndPoint$1), ClusterLinkLeaderRequestBuilder.class, (String)"fetchResponseSize"));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$8(Object expectedFetchSize$1, int x$18) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$18), (Object)expectedFetchSize$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$10(Object expectedFetchResponseSize$1, int x$19) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$19), (Object)expectedFetchResponseSize$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(ClusterLinkIntegrationTest $this, TopicPartition tp$2) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)$this.destCluster().describeTopic($this.topic()).partitions().get(tp$2.partition())).isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ void $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$4(ObjectRef destAdmin$2, TopicPartition tp$2) {
        try {
            ((ConfluentAdmin)destAdmin$2.elem).electLeaders(ElectionType.PREFERRED, Collections.singleton(tp$2)).all().get(15L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Preferred leader election failed");
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testAddPartitions$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitions$2(ClusterLinkIntegrationTest $this, int x$25) {
        return x$25 == $this.numPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterClusterLinkConfigs$6(int x$26) {
        return x$26 == 3;
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$4(ConfluentAdmin admin$1, ConfigResource resource$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            AlterConfigOp alterConfigOp;
            boolean expectSuccess;
            String name = (String)x0$1._1();
            Option value = (Option)x0$1._2();
            String string = name;
            String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (expectSuccess = false);
            if (value instanceof Some) {
                String v = (String)((Some)value).value();
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, v), AlterConfigOp.OpType.SET);
            } else if (None$.MODULE$.equals(value)) {
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, null), AlterConfigOp.OpType.DELETE);
            } else {
                throw new MatchError((Object)value);
            }
            try {
                java.util.Set<AlterConfigOp> ops = Collections.singleton(alterConfigOp);
                admin$1.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource$1), ops)}))).asJava()).all().get();
                Assertions.assertTrue((boolean)expectSuccess);
                return;
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidConfigurationException));
                Assertions.assertFalse((boolean)expectSuccess);
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$3(ClusterLinkIntegrationTest $this, ConfluentAdmin admin) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, $this.topic());
        try {
            admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.empty()).asJavaCollection()))}))).asJava()).all().get(20L, TimeUnit.SECONDS);
            Assertions.fail((String)"alterConfigs() on a mirror topic should fail");
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidRequestException));
        }
        new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)new Some((Object)"true")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)None$.MODULE$), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)new Some((Object)"compact")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)None$.MODULE$), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$4(admin, resource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLinkCleanup$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirroredTopicMarkedForDelete$1(ClusterLinkIntegrationTest $this, int i) {
        return new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), i);
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$2(int brokerId$1, KafkaBroker x$27) {
        return x$27.config().brokerId() != brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$4(IndexedSeq partitions$1, KafkaBroker broker$3) {
        return ((SeqLike)partitions$1.flatMap((Function1 & Serializable & scala.Serializable)tp -> Option$.MODULE$.option2Iterable(broker$3.replicaManager().onlinePartition(tp)), IndexedSeq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$6() {
        return "Partitions not offline after topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$7(KafkaBroker broker$3, UUID linkId$3) {
        return ((ClusterLinkFetcherManager)broker$3.clusterLinkManager().fetcherManager(linkId$3).get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$8() {
        return "Fetcher manager not empty after topic deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMirroredTopicMarkedForDelete$3(IndexedSeq partitions$1, UUID linkId$3, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$4(partitions$1, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$7(broker, linkId$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$5(ReplicaStatus.MirrorInfo mi) {
        ReplicaStatus.MirrorInfo.State state = mi.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PAUSED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$2(ClusterLinkIntegrationTest $this) {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.numPartitions()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$6 = $this.destCluster();
            String x$18 = new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString();
            boolean x$20 = qual$6.replicaStatus$default$3();
            return Option$.MODULE$.apply(((ReplicaStatus)((IterableLike)qual$6.replicaStatus(x$18, partition, x$20).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.isLeader()))).head()).mirrorInfo().orElse(null)).exists((Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$5(mi)));
        });
    }

    public static final /* synthetic */ String $anonfun$testPauseTopic$6() {
        return "Topic's partitions not paused";
    }

    private final Seq leaderOffsets$1() {
        return ((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$3 = qual$1.replicaStatus$default$3();
            return ((ReplicaStatus)((IterableLike)qual$1.replicaStatus(x$1, partition, x$3).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.isLeader()))).head()).logEndOffset();
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ int $anonfun$testPauseClusterLink$2(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic($this.topic()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$3(int newNumPartitions$1, int x$31) {
        return x$31 == newNumPartitions$1;
    }

    public static final /* synthetic */ String $anonfun$testPauseClusterLink$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$5(String newDeleteRetentionMs$1, String x$32) {
        String string = x$32;
        return !(string != null ? !string.equals(newDeleteRetentionMs$1) : newDeleteRetentionMs$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$3(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$1) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$4() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$5(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$6(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$7(ReplicaStatus rs) {
        return rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$8(ReplicaStatus rs) {
        return !rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$9(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$10(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$11(ClusterLinkIntegrationTest $this, ObjectRef rs4$1) {
        rs4$1.elem = $this.destCluster().replicaStatus($this.topic(), 0, true);
        return ((Seq)rs4$1.elem).size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$12() {
        return "Cluster link not removed from topic's partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$13(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$14(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$2) {
        return $this.destCluster().leaderEpoch(new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), 0)) >= expectedLeaderEpoch$2;
    }

    public static final /* synthetic */ String $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testIntervalChangeForPeriodicTasks$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testIntervalChangeForPeriodicTasks$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$3) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$3;
    }

    public static final /* synthetic */ String $anonfun$testMirrorFailoverWhenSourceIsUnavailable$2() {
        return "Destination leader epoch not updated";
    }

    public ClusterLinkIntegrationTest() {
        this.offsetToCommit = 10L;
        this.syncPeriod = 100L;
        this.consumerGroup = "testGroup";
    }

    public static final /* synthetic */ Object $anonfun$testCreateAndDeleteAndRecreateLink$4$adapted(Seq x$7) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$4(x$7));
    }

    public static final /* synthetic */ Object $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$3$adapted(int oldLeaderId$1, scala.collection.immutable.Set x$23) {
        return BoxesRunTime.boxToBoolean((boolean)x$23.contains((Object)BoxesRunTime.boxToInteger((int)oldLeaderId$1)));
    }

    public static final /* synthetic */ Object $anonfun$testPauseClusterLink$5$adapted(String newDeleteRetentionMs$1, String x$32) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs$1, x$32));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$1$adapted(ReplicaStatus x$33) {
        return BoxesRunTime.boxToBoolean((boolean)x$33.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$2$adapted(ReplicaStatus x$34) {
        return BoxesRunTime.boxToBoolean((boolean)x$34.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$5$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$5(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$6$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$6(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$7$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$7(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$8$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$8(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$9$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$9(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$10$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$10(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$13$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$13(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$14$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$14(rs));
    }
}

