/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001!4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!9Q\u0003\u0001b\u0001\n\u00032\u0002BB\u000f\u0001A\u0003%q\u0003C\u0003\u001f\u0001\u0011\u0005s\u0004C\u00036\u0001\u0011\u0005a\u0007C\u0003\\\u0001\u0011\u0005AL\u0001\nDYV\u001cH/\u001a:MS:\\\u0017j\u001d:UKN$(BA\u0005\u000b\u0003\u0011a\u0017N\\6\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005!\u0002CA\b\u0001\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t)1\u000b[8si\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u0003\u0015\u0019X\r^+q)\t\u00013\u0005\u0005\u0002\u0019C%\u0011!%\u0007\u0002\u0005+:LG\u000fC\u0003%\t\u0001\u0007Q%\u0001\u0005uKN$\u0018J\u001c4p!\t1s&D\u0001(\u0015\tA\u0013&A\u0002ba&T!AK\u0016\u0002\u000f),\b/\u001b;fe*\u0011A&L\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002]\u0005\u0019qN]4\n\u0005A:#\u0001\u0003+fgRLeNZ8)\u0005\u0011\u0011\u0004C\u0001\u00144\u0013\t!tE\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0004^3ti\u0012+7\u000f^5oCRLwN\\+oI\u0016\u0014X*\u001b8JgJ$\"\u0001I\u001c\t\u000ba*\u0001\u0019A\u001d\u0002\rE,xN];n!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(G\u0007\u0002{)\u0011a\bD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001K\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\r)\t\u0015)UJ\u0014\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u0015&\na\u0001]1sC6\u001c\u0018B\u0001'H\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012q*U\u0011\u0002!\u0006\u0011!p[\u0011\u0002%\u0006)1N]1gi\"\"Q\u0001\u0016-Z!\t)f+D\u0001J\u0013\t9\u0016JA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n!,\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\fQ\u0003^3tiJ+7\u000f^1siB\u000bWo]3e\u0019&t7\u000e\u0006\u0002!;\")\u0001H\u0002a\u0001s!\"a!R'`Y\ty\u0015\u000b\u000b\u0003\u0007)bK\u0006\u0006\u0002\u0001cK\u001a\u0004\"AJ2\n\u0005\u0011<#a\u0001+bO\u0006)a/\u00197vK\u0006\nq-A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkIsrTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor = (short)3;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$1 = SecurityProtocol.PLAINTEXT;
            int x$2 = 0;
            int x$3 = 3;
            Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$4, x$2, x$3));
            SecurityProtocol x$5 = SecurityProtocol.PLAINTEXT;
            int x$6 = 100;
            int x$7 = 3;
            Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$8, x$6, x$7));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$9 = SecurityProtocol.SASL_SSL;
            int x$10 = 0;
            int x$11 = 3;
            Option<SecurityProtocol> x$12 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$9, x$12, x$10, x$11));
            SecurityProtocol x$13 = SecurityProtocol.SASL_PLAINTEXT;
            int x$14 = 100;
            int x$15 = 3;
            Option<SecurityProtocol> x$16 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$13, x$16, x$14, x$15));
        }
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "5000");
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        super.setUp(testInfo);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationUnderMinIsr(String quorum) {
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$2, x$3, x$4, x$5, x$6);
        Properties linkProps = new Properties();
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp(), "-1");
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        ClusterLinkTestHarness x$8 = this.sourceCluster();
        long x$10 = qual$2.createDestClusterLink$default$3();
        long x$11 = qual$2.createDestClusterLink$default$4();
        long x$122 = qual$2.createDestClusterLink$default$5();
        qual$2.createDestClusterLink(x$7, x$8, x$10, x$11, x$122, linkProps);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        short x$14 = this.replicationFactor();
        String x$15 = this.linkName();
        Map<String, String> x$16 = qual$3.linkTopic$default$4();
        String x$17 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$13, x$14, x$15, x$16, x$17);
        this.produceToSourceCluster(2);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        KafkaBroker destLeader = this.destCluster().partitionLeader(tp);
        scala.collection.immutable.Map destFollowers = ((TraversableOnce)((TraversableLike)this.destCluster().brokers().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$1(destLeader, x$1)))).map((Function1 & Serializable & scala.Serializable)follower -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)follower.config().brokerId())), follower), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        destFollowers.foreach((Function1 & Serializable & scala.Serializable)follower -> {
            ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$3(this, follower);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$4(this, destLeader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(10);
        long destOffset = BoxesRunTime.unboxToLong((Object)this.logEndOffset(destLeader, tp).get());
        long sourceOffset = BoxesRunTime.unboxToLong((Object)this.logEndOffset(this.sourceCluster().partitionLeader(tp), tp).get());
        Assertions.assertTrue((sourceOffset > destOffset ? 1 : 0) != 0, (String)new StringBuilder(62).append("Records mirrored with under-min-isrs sourceOffset=").append(sourceOffset).append(" destOffset=").append(destOffset).toString());
        destFollowers.foreach((Function1 & Serializable & scala.Serializable)follower -> {
            ClusterLinkIsrTest.$anonfun$testDestinationUnderMinIsr$6(this, follower);
            return BoxedUnit.UNIT;
        });
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRestartPausedLink(String quorum) {
        void var31_43;
        Tuple2 tuple2;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$22 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$22, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        ClusterLinkTestHarness x$8 = this.sourceCluster();
        long x$9 = qual$2.createDestClusterLink$default$3();
        long x$10 = qual$2.createDestClusterLink$default$4();
        long x$11 = qual$2.createDestClusterLink$default$5();
        Properties x$12 = qual$2.createDestClusterLink$default$6();
        UUID linkId = qual$2.createDestClusterLink(x$7, x$8, x$9, x$10, x$11, x$12);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        short x$14 = this.replicationFactor();
        String x$15 = this.linkName();
        Map<String, String> x$16 = qual$3.linkTopic$default$4();
        String x$17 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$13, x$14, x$15, x$16, x$17);
        this.produceToSourceCluster(2);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ObjectRef destLeader = ObjectRef.create((Object)this.destCluster().partitionLeader(tp));
        ObjectRef destFollowers = ObjectRef.create((Object)((Buffer)this.destCluster().brokers().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$1(destLeader, x$2)))));
        this.destCluster().shutdownBroker(((KafkaBroker)((Buffer)destFollowers.elem).head()).config().brokerId());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testRestartPausedLink$2(this, destLeader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)((KafkaBroker)destLeader.elem), (List)Nil$.MODULE$), this.waitForMirror$default$2());
        Option<Object> endOffset = this.logEndOffset((KafkaBroker)destLeader.elem, tp);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))), (Seq<KafkaBroker>)new .colon.colon((Object)((KafkaBroker)destLeader.elem), (List)Nil$.MODULE$));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testRestartPausedLink$4(this, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(2);
        this.destCluster().shutdownBroker(((KafkaBroker)((Buffer)destFollowers.elem).apply(1)).config().brokerId());
        this.destCluster().shutdownBroker(((KafkaBroker)destLeader.elem).config().brokerId());
        this.destCluster().startBroker(((KafkaBroker)destLeader.elem).config().brokerId());
        destLeader.elem = this.destCluster().partitionLeader(tp);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testRestartPausedLink$8(destLeader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals(endOffset, this.logEndOffset((KafkaBroker)destLeader.elem, tp));
        destFollowers.elem = (Buffer)((Buffer)destFollowers.elem).map((Function1 & Serializable & scala.Serializable)follower -> this.destCluster().startBroker(follower.config().brokerId()), Buffer$.MODULE$.canBuildFrom());
        .colon.colon expectedOffsets = new .colon.colon(endOffset, (List)new .colon.colon(endOffset, (List)Nil$.MODULE$));
        long l7 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l8 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Buffer computeUntilTrue_result;
            Buffer buffer;
            if (ClusterLinkIsrTest.$anonfun$testRestartPausedLink$13((Seq)expectedOffsets, buffer = (computeUntilTrue_result = ClusterLinkIsrTest.$anonfun$testRestartPausedLink$11(this, destFollowers, tp)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer offsets = (Buffer)tuple2._1();
        Assertions.assertEquals((Object)expectedOffsets, (Object)var31_43);
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkIsrTest.$anonfun$testRestartPausedLink$14(destLeader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        Seq<KafkaBroker> x$20 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$18, (Map<String, String>)x$19, x$20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceToSourceCluster(2);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationUnderMinIsr$1(KafkaBroker destLeader$1, KafkaBroker x$1) {
        KafkaBroker kafkaBroker = x$1;
        return !(kafkaBroker != null ? !kafkaBroker.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testDestinationUnderMinIsr$3(ClusterLinkIsrTest $this, Tuple2 follower) {
        $this.destCluster().killBrokerById(follower._1$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationUnderMinIsr$4(ClusterLinkIsrTest $this, KafkaBroker destLeader$1, TopicPartition tp$1) {
        $this.produceToSourceCluster(2);
        return ((Partition)destLeader$1.replicaManager().onlinePartition(tp$1).get()).isUnderMinIsr();
    }

    public static final /* synthetic */ String $anonfun$testDestinationUnderMinIsr$5() {
        return "Destination not under-min-isr with two brokers down";
    }

    public static final /* synthetic */ void $anonfun$testDestinationUnderMinIsr$6(ClusterLinkIsrTest $this, Tuple2 follower) {
        ClusterLinkTestHarness qual$4 = $this.destCluster();
        int x$18 = follower._1$mcI$sp();
        boolean x$19 = qual$4.restartDeadBrokerById$default$2();
        qual$4.restartDeadBrokerById(x$18, x$19);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$1(ObjectRef destLeader$2, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        KafkaBroker kafkaBroker2 = (KafkaBroker)destLeader$2.elem;
        return !(kafkaBroker != null ? !kafkaBroker.equals(kafkaBroker2) : kafkaBroker2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$2(ClusterLinkIsrTest $this, ObjectRef destLeader$2, TopicPartition tp$2) {
        $this.produceToSourceCluster(2);
        return ((Partition)((KafkaBroker)destLeader$2.elem).replicaManager().onlinePartition(tp$2).get()).isUnderReplicated();
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$3() {
        return "Destination not under-replicated with a broker down";
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$6(ClusterLinkFactory.ConnectionManager x$4) {
        return !x$4.active();
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$5(UUID linkId$1, KafkaBroker x$3) {
        return x$3.clusterLinkManager().connectionManager(linkId$1).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$6(x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$4(ClusterLinkIsrTest $this, UUID linkId$1) {
        return $this.destCluster().aliveServers().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$5(linkId$1, x$3)));
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$7() {
        return "ClusterLink is not paused in one or more brokers.";
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$8(ObjectRef destLeader$2, TopicPartition tp$2) {
        boolean bl;
        try {
            if (((KafkaBroker)destLeader$2.elem).replicaManager().getPartitionOrException(tp$2).isBlockedOnMirrorSource()) {
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$9() {
        return "Paused partition should not be blocked on source";
    }

    public static final /* synthetic */ Buffer $anonfun$testRestartPausedLink$11(ClusterLinkIsrTest $this, ObjectRef destFollowers$1, TopicPartition tp$2) {
        return (Buffer)((Buffer)destFollowers$1.elem).map((Function1 & Serializable & scala.Serializable)x$5 -> $this.logEndOffset((KafkaBroker)x$5, tp$2), Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$13(Seq expectedOffsets$1, Buffer x$6) {
        Buffer buffer = x$6;
        return !(buffer != null ? !buffer.equals(expectedOffsets$1) : expectedOffsets$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRestartPausedLink$14(ObjectRef destLeader$2, TopicPartition tp$2) {
        return !((Partition)((KafkaBroker)destLeader$2.elem).replicaManager().onlinePartition(tp$2).get()).isUnderReplicated();
    }

    public static final /* synthetic */ String $anonfun$testRestartPausedLink$15() {
        return "Destination follower unable to join ISR with paused link";
    }

    public static final /* synthetic */ Object $anonfun$testRestartPausedLink$13$adapted(Seq expectedOffsets$1, Buffer x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIsrTest.$anonfun$testRestartPausedLink$13(expectedOffsets$1, x$6));
    }
}

