/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iA\u0011\u0002\b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b%\u0002A\u0011\t\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bu\u0003A\u0011\u00010\t\u000b\r\u0004A\u0011\u00023\t\u000f=\u0004\u0011\u0013!C\u0005a\")1\u0010\u0001C\u0005y\")Q\u0010\u0001C\u0005}\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t)\u0004\u0001C\u0005\u0003o\u0011!c\u00117vgR,'\u000fT5oWN\u001bH\u000eV3ti*\u0011\u0001#E\u0001\u0005Y&t7NC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\b\n\u0005ay!AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011a\u0003A\u0001\n?R,7\u000f^%oM>\u0004\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\t)\u0016\u001cH/\u00138g_\u0006)1/\u001a;VaR\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005+:LG\u000fC\u00033\u0007\u0001\u0007Q$\u0001\u0005uKN$\u0018J\u001c4pQ\t\u0019A\u0007\u0005\u0002\u001fk%\u0011ag\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\b;fgR\u001cE.^:uKJd\u0015N\\6XSRD\u0007+Z7Tg2\u001cFo\u001c:fgR\u00111&\u000f\u0005\u0006u\u0011\u0001\raO\u0001\u0007cV|'/^7\u0011\u0005q\u001aeBA\u001fB!\tqT&D\u0001@\u0015\t\u00015#\u0001\u0004=e>|GOP\u0005\u0003\u00056\na\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!)\f\u0015\u0005\t\u001d{\u0005\u000b\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006A\u0001O]8wS\u0012,'O\u0003\u0002MC\u00051\u0001/\u0019:b[NL!AT%\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\t6+I\u0001S\u0003\tQ8.I\u0001U\u0003\u0015Y'/\u00194uQ\u0011!aKW.\u0011\u0005]CV\"A&\n\u0005e[%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005a\u0016\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006aB/Z:u\u000b:\u001c'/\u001f9uS>t7+Z2sKR\u0014v\u000e^1uS>tGCA\u0016`\u0011\u0015QT\u00011\u0001<Q\u0011)qiT1-\u0003ECC!\u0002,[7\u0006a1o\u001d7MS:\\\u0007K]8qgR\u0011Q-\u001c\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA!\u001e;jY*\t!.\u0001\u0003kCZ\f\u0017B\u00017h\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b]\u001a\u0001\n\u00111\u0001f\u00035yg/\u001a:sS\u0012,\u0007K]8qg\u000612o\u001d7MS:\\\u0007K]8qg\u0012\"WMZ1vYR$\u0013'F\u0001rU\t)'oK\u0001t!\t!\u00180D\u0001v\u0015\t1x/A\u0005v]\u000eDWmY6fI*\u0011\u00010L\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001>v\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bm\u0016\u0014\u0018NZ=MS:\\G#A\u0016\u0002\u0017\t\u0014xn[3s!J|\u0007o]\u000b\u0002\u007fB1a-!\u0001<\u0003\u000bI1!a\u0001h\u0005\u001dA\u0015m\u001d5NCB\u00042\u0001LA\u0004\u0013\r\tI!\f\u0002\u0007\u0003:L(+\u001a4\u0002)\u0015t7m\u001c3fe^KG\u000f[(mIN+7M]3u+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005eQBAA\n\u0015\r\u0001\u0012Q\u0003\u0006\u0004\u0003/\t\u0012AB:feZ,'/\u0003\u0003\u0002\u001c\u0005M!aF*fGV\u0014X\rT5oW\u000e{gNZ5h\u000b:\u001cw\u000eZ3s\u0003A!WmY8eK2Kgn[\"p]\u001aLw\rF\u0003,\u0003C\t)\u0003C\u0004\u0002$-\u0001\r!a\u0004\u0002\u000f\u0015t7m\u001c3fe\"9\u0011qE\u0006A\u0002\u0005%\u0012A\u00027j].LE\rE\u0002g\u0003WI1!!\fh\u0005\u0011)V+\u0013#\u0002-]\f\u0017\u000e\u001e$pe>cGmU3de\u0016$H)\u001a7fi\u0016$2aKA\u001a\u0011\u001d\t9\u0003\u0004a\u0001\u0003S\t\u0001D^3sS\u001aL8i\u001c8gS\u001e\fe\r^3s%\u0016\u001cH/\u0019:u)\u0015Y\u0013\u0011HA\u001e\u0011\u001d\t9#\u0004a\u0001\u0003SAq!!\u0010\u000e\u0001\u0004\ty$A\u0005fqB,7\r^(mIB\u0019A&!\u0011\n\u0007\u0005\rSFA\u0004C_>dW-\u00198)\u000f\u0001\t9%!\u0014\u0002PA\u0019a$!\u0013\n\u0007\u0005-sDA\u0002UC\u001e\fQA^1mk\u0016\f#!!\u0015\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkSslTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this._testInfo = testInfo;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterLinkWithPemSslStores(String quorum) {
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(this.sslLinkProps$default$1());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        UUID linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        Config linkConfig = this.destCluster().describeClusterLink(this.linkName());
        scala.collection.immutable.Map linkProps = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(linkConfig.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.keystore.type"));
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.truststore.type"));
        this.verifyConfigAfterRestart(linkId, true);
        this.verifyLink();
        Properties overrideProps = new Properties();
        overrideProps.setProperty("ssl.truststore.location", this.destCluster().clientSecurityProps(this.linkName()).getProperty("ssl.truststore.location"));
        Properties invalidLinkProps = this.sslLinkProps(overrideProps);
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "SSL handshake failed");
        invalidLinkProps.remove("ssl.truststore.certificates");
        invalidLinkProps.setProperty("ssl.truststore.location", "nonexistent.pem");
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "Unable to create client using provided properties when validating the cluster link: Failed to load PEM SSL keystore nonexistent.pem, root cause: java.nio.file.NoSuchFileException: nonexistent.pem");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testEncryptionSecretRotation(String quorum) {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this.destCluster().serverConfig().put("confluent.password.encoder.old.secret.ttl.ms", "1000");
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(this.sslLinkProps$default$1());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        UUID linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.waitForOldSecretDelete(linkId);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$5 = "anotherLink";
        Properties x$6 = this.sslLinkProps(this.sslLinkProps$default$1());
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.createClusterLink$default$4();
        this.waitForOldSecretDelete(qual$2.createClusterLink(x$5, x$6, (Option<String>)x$7, x$8));
        HashMap<String, Object> encoderProps = this.brokerProps();
        encoderProps.remove("confluent.password.encoder.old.secret.ttl.ms");
        SecureLinkConfigEncoder encoder = new SecureLinkConfigEncoder(new KafkaConfig(encoderProps));
        Properties linkProps = this.destCluster().adminZkClient().fetchClusterLinkConfig(linkId);
        this.destCluster().adminZkClient().changeClusterLinkConfig(linkId, (Properties)encoder.maybeReencode(linkProps).get());
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        this.verifyConfigAfterRestart(linkId, false);
        this.verifyLink();
    }

    /*
     * WARNING - void declaration
     */
    private Properties sslLinkProps(Properties overrideProps) {
        void var2_2;
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ListenerName x$1 = qual$1.bootstrapServers$default$1();
        props.put("bootstrap.servers", qual$1.bootstrapServers(x$1));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sourceCluster().clientSecurityProps(this.linkName()));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(overrideProps);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        Assertions.assertNull((Object)props.get("ssl.keystore.location"));
        Assertions.assertNull((Object)props.get("ssl.truststore.location"));
        return var2_2;
    }

    private Properties sslLinkProps$default$1() {
        return new Properties();
    }

    private void verifyLink() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(20);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> brokerProps() {
        void var1_1;
        HashMap props = new HashMap();
        props.putAll(((KafkaBroker)this.destCluster().brokers().head()).config().originals());
        return var1_1;
    }

    private SecureLinkConfigEncoder encoderWithOldSecret() {
        HashMap<String, Object> oldEncoderProps = this.brokerProps();
        oldEncoderProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), oldEncoderProps.remove(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp()));
        return new SecureLinkConfigEncoder(new KafkaConfig(oldEncoderProps));
    }

    private void decodeLinkConfig(SecureLinkConfigEncoder encoder, UUID linkId) {
        if (!this.isKraftTest()) {
            Properties props = this.destCluster().zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
            encoder.clusterLinkConfig(props);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOldSecretDelete(UUID linkId) {
        SecureLinkConfigEncoder oldEncoder = this.encoderWithOldSecret();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$1(this, oldEncoder, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConfigAfterRestart(UUID linkId, boolean expectOld) {
        int brokerId = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        this.destCluster().shutdownBroker(brokerId);
        this.destCluster().startBroker(brokerId);
        if (expectOld) {
            this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
            return;
        }
        this.waitForOldSecretDelete(linkId);
    }

    public static final /* synthetic */ boolean $anonfun$waitForOldSecretDelete$1(ClusterLinkSslTest $this, SecureLinkConfigEncoder oldEncoder$1, UUID linkId$1) {
        try {
            $this.decodeLinkConfig(oldEncoder$1, linkId$1);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static final /* synthetic */ String $anonfun$waitForOldSecretDelete$2() {
        return "Configs encrypted with old secret not deleted";
    }

    public ClusterLinkSslTest() {
        SecurityProtocol x$1 = SecurityProtocol.SSL;
        int x$2 = 0;
        Option<SecurityProtocol> x$3 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$3, x$2, x$4));
        SecurityProtocol x$5 = SecurityProtocol.SSL;
        int x$6 = 100;
        Option<SecurityProtocol> x$7 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$7, x$6, x$8));
    }
}

