/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.lang.reflect.Method;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0015\t\u0013U\u0002\u0001\u0019!a\u0001\n\u00131\u0004\"C \u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%\u0001\u0005\u00011AA\u0002\u0013%\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\"I\u0001\n\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n\u0005C\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011B&\t\u00135\u0003\u0001\u0019!A!B\u0013\u0011\u0005\"\u0002(\u0001\t\u0003z\u0005\"\u0002,\u0001\t\u00139\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u00022\u0001\t\u0003i\u0006\"\u00023\u0001\t\u0003)\u0007bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\u0007\u0003C\u0001A\u0011A/\t\r\u0005\u0015\u0002\u0001\"\u0001^\u0011\u0019\tI\u0003\u0001C\u0001;\"1\u0011Q\u0006\u0001\u0005\u0002uCa!!\r\u0001\t\u0013i\u0006bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003g\u0001A\u0011BA!\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\u0012a\u0004T5oW\u000e{wN\u001d3j]\u0006$xN]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005ma\u0012\u0001\u00027j].T\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\t!$\u0003\u0002$5\t\u0011\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u0005\u0002\u0011!C0uKN$\u0018J\u001c4p+\u0005I\u0003C\u0001\u00164\u001b\u0005Y#B\u0001\u0017.\u0003\r\t\u0007/\u001b\u0006\u0003]=\nqA[;qSR,'O\u0003\u00021c\u0005)!.\u001e8ji*\t!'A\u0002pe\u001eL!\u0001N\u0016\u0003\u0011Q+7\u000f^%oM>\fQb\u0018;fgRLeNZ8`I\u0015\fHCA\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;\t\u000fy\u001a\u0011\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\u0002\u0015}#Xm\u001d;J]\u001a|\u0007%A\rf]\u0006\u0014G.Z*pkJ\u001cW-T3uC\u0012\fG/\u0019+pa&\u001cW#\u0001\"\u0011\u0005a\u001a\u0015B\u0001#:\u0005\u001d\u0011un\u001c7fC:\fQ$\u001a8bE2,7k\\;sG\u0016lU\r^1eCR\fGk\u001c9jG~#S-\u001d\u000b\u0003o\u001dCqA\u0010\u0004\u0002\u0002\u0003\u0007!)\u0001\u000ef]\u0006\u0014G.Z*pkJ\u001cW-T3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\ff]\u0006\u0014G.\u001a#fgRlU\r^1eCR\fGk\u001c9jG\u0006YRM\\1cY\u0016$Um\u001d;NKR\fG-\u0019;b)>\u0004\u0018nY0%KF$\"a\u000e'\t\u000fyJ\u0011\u0011!a\u0001\u0005\u0006ARM\\1cY\u0016$Um\u001d;NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002\u000bM,G/\u00169\u0015\u0005]\u0002\u0006\"B)\f\u0001\u0004I\u0013\u0001\u0003;fgRLeNZ8)\u0005-\u0019\u0006C\u0001\u0016U\u0013\t)6F\u0001\u0006CK\u001a|'/Z#bG\"\fQb]3ukB\u001cE.^:uKJ\u001cH\u0003B\u001cY5nCQ!\u0017\u0007A\u0002\t\u000bqb]8ve\u000e,\u0017J\\5uS\u0006$X\r\u001a\u0005\u0006\u00012\u0001\rA\u0011\u0005\u0006\u00132\u0001\rAQ\u0001(i\u0016\u001cH\u000fR3ti&s\u0017\u000e^5bi\u0016$7i\u001c8ue>dG.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fF\u00018Q\tiq\f\u0005\u0002+A&\u0011\u0011m\u000b\u0002\u0005)\u0016\u001cH/A\u0015uKN$8k\\;sG\u0016Le.\u001b;jCR,GmQ8oiJ|G\u000e\\3s)>\u001cuN\u001c;s_2dWM\u001d\u0015\u0003\u001d}\u000bQ\u0005^3ti\u0012+7\u000f^%oSRL\u0017\r^3e\u0019&t7nQ8pe\u0012$v\u000eT5oW\u000e{wN\u001d3\u0015\u0005]2\u0007\"B4\u0010\u0001\u0004A\u0017AB9v_J,X\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003Wfj\u0011\u0001\u001c\u0006\u0003[z\ta\u0001\u0010:p_Rt\u0014BA8:\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=L\u0004\u0006B\buyv\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0011A\u0014xN^5eKJT!!_\u0017\u0002\rA\f'/Y7t\u0013\tYhOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0004}\u0006\u0005\u0011%A@\u0002\u0005i\\\u0017EAA\u0002\u0003\u0015Y'/\u00194uQ\u001dy\u0011qAA\b\u0003#\u0001B!!\u0003\u0002\f5\t\u00010C\u0002\u0002\u000ea\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005M\u0011\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u00069C/Z:u'>,(oY3J]&$\u0018.\u0019;fI2Kgn[\"p_J$Gk\u001c'j].\u001cun\u001c:e)\r9\u0014\u0011\u0004\u0005\u0006OB\u0001\r\u0001\u001b\u0015\u0006!Qd\u0018Q\u0004\u0017\u0004}\u0006\u0005\u0001f\u0002\t\u0002\b\u0005=\u0011\u0011C\u0001'i\u0016\u001cH\u000fR3ti&s\u0017\u000e^5bi\u0016$7i\u001c8ue>dG.\u001a:U_2Kgn[\"p_J$\u0007FA\t`\u0003!\"Xm\u001d;T_V\u00148-Z%oSRL\u0017\r^3e\u0007>tGO]8mY\u0016\u0014Hk\u001c'j].\u001cun\u001c:eQ\t\u0011r,\u0001\u0014uKN$H)Z:u\u0013:LG/[1uK\u0012d\u0015N\\6D_>\u0014H\rV8D_:$(o\u001c7mKJD#aE0\u0002QQ,7\u000f^*pkJ\u001cW-\u00138ji&\fG/\u001a3MS:\\7i\\8sIR{7i\u001c8ue>dG.\u001a:)\u0005Qy\u0016a\u0006<fe&4\u0017pQ8pe\u0012Lg.\u0019;pe\u000eC\u0017M\\4f\u0003E\u0019\u0007.\u00198hK\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0004o\u0005]\u0002bBA\u001d-\u0001\u0007\u00111H\u0001\bG2,8\u000f^3s!\r\t\u0013QH\u0005\u0004\u0003\u007fQ\"AF\"mkN$XM\u001d'j].$Vm\u001d;ICJtWm]:\u0015\u000b]\n\u0019%!\u0012\t\u000f\u0005er\u00031\u0001\u0002<!1\u0011qI\fA\u0002\t\u000b1#\u001a8bE2,W*\u001a;bI\u0006$\u0018\rV8qS\u000e\fQ\u0004\\5oW:\u000bW.\u001a+p\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t\u0017\n\u001a\u000b\u0007\u0003\u001b\n\u0019&a\u0016\u0011\u0007a\ny%C\u0002\u0002Re\u00121!\u00138u\u0011\u0019\t)\u0006\u0007a\u0001Q\u0006AA.\u001b8l\u001d\u0006lW\rC\u0004\u0002Za\u0001\r!a\u0017\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004B!!\u0018\u0002f5\u0011\u0011q\f\u0006\u00047\u0005\u0005$bAA29\u000511/\u001a:wKJLA!a\u001a\u0002`\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\":\u0001!a\u001b\u0002r\u0005M\u0004c\u0001\u0016\u0002n%\u0019\u0011qN\u0016\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0002v\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public class LinkCoordinatorIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;
    private boolean enableSourceMetadataTopic;
    private boolean enableDestMetadataTopic;

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    private boolean enableSourceMetadataTopic() {
        return this.enableSourceMetadataTopic;
    }

    private void enableSourceMetadataTopic_$eq(boolean x$1) {
        this.enableSourceMetadataTopic = x$1;
    }

    private boolean enableDestMetadataTopic() {
        return this.enableDestMetadataTopic;
    }

    private void enableDestMetadataTopic_$eq(boolean x$1) {
        this.enableDestMetadataTopic = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo_$eq(testInfo);
    }

    private void setupClusters(boolean sourceInitiated, boolean enableSourceMetadataTopic, boolean enableDestMetadataTopic) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo()) && this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$1 = SecurityProtocol.PLAINTEXT;
            int x$2 = 0;
            int x$3 = 3;
            Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$4, x$2, x$3));
            SecurityProtocol x$5 = SecurityProtocol.PLAINTEXT;
            int x$6 = 100;
            int x$7 = 3;
            Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$8, x$6, x$7));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$9 = SecurityProtocol.SASL_SSL;
            int x$10 = 0;
            int x$11 = 3;
            Option<SecurityProtocol> x$12 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$9, x$12, x$10, x$11));
            SecurityProtocol x$13 = SecurityProtocol.SASL_PLAINTEXT;
            int x$14 = 100;
            int x$15 = 3;
            Option<SecurityProtocol> x$16 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$13, x$16, x$14, x$15));
        }
        this.useSourceInitiatedLink_$eq(sourceInitiated);
        this.enableSourceMetadataTopic_$eq(enableSourceMetadataTopic);
        this.enableDestMetadataTopic_$eq(enableDestMetadataTopic);
        if (enableSourceMetadataTopic) {
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        if (enableDestMetadataTopic) {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        super.setUp(this._testInfo());
    }

    @Test
    public void testDestInitiatedControllerToController() {
        this.setupClusters(false, false, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToController() {
        this.setupClusters(true, false, false);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestInitiatedLinkCoordToLinkCoord(String quorum) {
        this.setupClusters(false, true, true);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSourceInitiatedLinkCoordToLinkCoord(String quorum) {
        this.setupClusters(true, true, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedControllerToLinkCoord() {
        this.setupClusters(false, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToLinkCoord() {
        this.setupClusters(true, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedLinkCoordToController() {
        this.setupClusters(false, true, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedLinkCoordToController() {
        this.setupClusters(true, true, false);
        this.verifyCoordinatorChange();
    }

    private void verifyCoordinatorChange() {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.destCluster());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.sourceCluster());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    private void changeCoordinator(ClusterLinkTestHarness cluster) {
        if (cluster == this.sourceCluster()) {
            this.changeCoordinator(this.sourceCluster(), this.enableSourceMetadataTopic());
            return;
        }
        if (cluster == this.destCluster()) {
            this.changeCoordinator(this.destCluster(), this.enableDestMetadataTopic());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void changeCoordinator(ClusterLinkTestHarness cluster, boolean enableMetadataTopic) {
        if (enableMetadataTopic) {
            String metadataTopic = "_confluent-link-metadata";
            KafkaBroker linkCoordinator = cluster.linkCoordinator(this.linkName());
            int partition = this.linkNameToMetadataPartitionId(this.linkName(), LinkCoordinatorIntegrationTest.metadataManager$1(linkCoordinator));
            int newLeader = cluster.changeLeader(new TopicPartition(metadataTopic, partition));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!LinkCoordinatorIntegrationTest.$anonfun$changeCoordinator$1(this, cluster, newLeader)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)LinkCoordinatorIntegrationTest.$anonfun$changeCoordinator$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        cluster.changeController();
    }

    private int linkNameToMetadataPartitionId(String linkName, ClusterLinkMetadataManager metadataManager) {
        Method method = metadataManager.getClass().getSuperclass().getDeclaredMethod("linkNameToPartitionId", String.class);
        method.setAccessible(true);
        return BoxesRunTime.unboxToInt((Object)method.invoke((Object)metadataManager, linkName));
    }

    private static final ClusterLinkMetadataManager metadataManager$1(KafkaBroker server) {
        return ((ClusterLinkManager)server.clusterLinkManager()).metadataManager();
    }

    public static final /* synthetic */ boolean $anonfun$changeCoordinator$1(LinkCoordinatorIntegrationTest $this, ClusterLinkTestHarness cluster$1, int newLeader$1) {
        ClusterLinkMetadataManager qual$1 = LinkCoordinatorIntegrationTest.metadataManager$1(cluster$1.brokerWithId(newLeader$1));
        String x$1 = $this.linkName();
        boolean x$2 = qual$1.isLinkCoordinator$default$2();
        return qual$1.isLinkCoordinator(x$1, x$2);
    }

    public static final /* synthetic */ String $anonfun$changeCoordinator$2() {
        return "New link coordinator not elected";
    }
}

