/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.ClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0006\r\u0001EAQA\u0006\u0001\u0005\u0002]AQ!\u0007\u0001\u0005\u0002iAQa\u0013\u0001\u0005\u00021CQ!\u0015\u0001\u0005\nICQa\u0015\u0001\u0005\u0002QCQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQa\u001f\u0001\u0005\u0002q\u0014!eU8ve\u000e,\u0017J\\5uS\u0006$X\r\u001a'j].Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0007\u000f\u0003\u0011a\u0017N\\6\u000b\u0003=\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0019%\u0011Q\u0003\u0004\u0002\u001b\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"a\u0005\u0001\u0002UQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\\4f/&$\bNU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogR\u00111$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0005+:LG\u000fC\u0003#\u0005\u0001\u00071%\u0001\u0004rk>\u0014X/\u001c\t\u0003I-r!!J\u0015\u0011\u0005\u0019jR\"A\u0014\u000b\u0005!\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002+;\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQS\u0004\u000b\u0003\u0003_ur\u0004C\u0001\u0019<\u001b\u0005\t$B\u0001\u001a4\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u001b6\u0003\u0019\u0001\u0018M]1ng*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0014(A\u0003kk:LGOC\u0001;\u0003\ry'oZ\u0005\u0003yE\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA BC\u0005\u0001\u0015A\u0001>lC\u0005\u0011\u0015!B6sC\u001a$\b\u0006\u0002\u0002E\u0011&\u0003\"!\u0012$\u000e\u0003MJ!aR\u001a\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001&\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0\u0001\ruKN$Hk\u001c9jG\u000e{gNZ5h'ft7MU;mKN$\"aG'\t\u000b\t\u001a\u0001\u0019A\u0012)\t\rySh\u0014\u0017\u0003\u007f\u0005CCa\u0001#I\u0013\u0006qb/\u001a:jMf\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\'fiJL7m\u001d\u000b\u00027\u0005AB/Z:u'>,(oY3DYV\u001cH/\u001a:SKN$\u0018M\u001d;\u0015\u0005m)\u0006\"\u0002\u0012\u0006\u0001\u0004\u0019\u0003\u0006B\u00030{]c#aP!)\t\u0015!\u0005*S\u0001\u0019i\u0016\u001cH\u000fR3ti\u000e{g\u000e\u001e:pY2,'o\u00115b]\u001e,GCA\u000e\\\u0011\u0015\u0011c\u00011\u0001$Q\u00111q&P/-\u0005}\n\u0005\u0006\u0002\u0004E\u0011&\u000b\u0011\u0004^3ti2{7-\u00197MSN$XM\\3s\u001fZ,'O]5eKR\u00111$\u0019\u0005\u0006E\u001d\u0001\ra\t\u0015\u0005\u000f=j4\r\f\u0002@\u0003\"\"q\u0001\u0012%J\u0003!\"Xm\u001d;MS:\\g+\u00197jI\u0006$\u0018n\u001c8GC&dWO]3P]N{WO]2f\u00072,8\u000f^3s)\tYr\rC\u0003#\u0011\u0001\u00071\u0005\u000b\u0003\t_uJGFA BQ\u0011AA\tS%\u00021Q,7\u000f\u001e#fY\u0016$XmU8ve\u000e,7+\u001b3f\u0019&t7\u000e\u0006\u0002\u001c[\")!%\u0003a\u0001G!\"\u0011b\\;w!\t\u00018/D\u0001r\u0015\t\u0011X'A\u0002ba&L!\u0001^9\u0003\u0011\u0011K7/\u00192mK\u0012\fQA^1mk\u0016\f\u0013a^\u0001\u0018\u0017\u001ecuJQ!M[E:DG\r\u0011GY\u0006\\\u0017\u0010\t;fgRDC!C\u0018>s2\u0012q(\u0011\u0015\u0005\u0013\u0011C\u0015*\u0001\u0011uKN$H)Z:de&\u0014WmU8ve\u000e,7+\u001b3f\u0019&t7nQ8oM&<GCA\u000e~\u0011\u0015\u0011#\u00021\u0001$Q\u0011Qq&P@-\u0005}\n\u0005\u0006\u0002\u0006E\u0011&Cc\u0001AA\u0003k\u0006-\u0001c\u00019\u0002\b%\u0019\u0011\u0011B9\u0003\u0007Q\u000bw-\t\u0002\u0002\u000e\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public class SourceInitiatedLinkIntegrationTest
extends ClusterLinkIntegrationTest {
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testControllerChangeWithReverseConnections(String quorum) {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics();
        KafkaBroker destCoordinator = this.isKraftTest() ? this.destCluster().linkCoordinator(this.linkName()) : this.destCluster().controller();
        this.destCluster().killBroker(this.destCluster().brokers().indexOf((Object)destCoordinator));
        this.produceToSourceCluster(10);
        this.waitForMirror(this.destCluster().aliveServers(), this.waitForMirror$default$2());
        KafkaBroker sourceCoordinator = this.isKraftTest() ? this.sourceCluster().linkCoordinator(this.linkName()) : this.sourceCluster().controller();
        this.sourceCluster().killBroker(this.sourceCluster().brokers().indexOf((Object)sourceCoordinator));
        this.produceToSourceCluster(10);
        this.waitForMirror(this.destCluster().aliveServers(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics();
        this.verifyMirror(this.topic(), this.destCluster().aliveServers(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicConfigSyncRules(String quorum) {
        String topicConfigSyncIncludeOverride = ((TraversableOnce)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala()).toSet().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MinCompactionLagMsProp(), LogConfig$.MODULE$.CompressionTypeProp()}))).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MaxCompactionLagMsProp()})))).mkString(",");
        Map linkConfigsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)topicConfigSyncIncludeOverride), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)"100")}));
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = new Properties(null){
            {
                this.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), "142857");
                this.put(LogConfig$.MODULE$.CompressionTypeProp(), "snappy");
            }
        };
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$7, (Map<String, String>)linkConfigsToUpdate, x$9);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.topic();
        short x$11 = this.replicationFactor();
        String x$12 = this.linkName();
        Map<String, String> x$13 = qual$3.linkTopic$default$4();
        String x$14 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$10, x$11, x$12, x$13, x$14);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics();
        Map expect = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinCompactionLagMsProp()), (Object)"142857"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)"snappy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxCompactionLagMsProp()), (Object)Long.toString(Defaults$.MODULE$.MaxCompactionLagMs()))}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SourceInitiatedLinkIntegrationTest.$anonfun$testTopicConfigSyncRules$1(this, expect)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SourceInitiatedLinkIntegrationTest.$anonfun$testTopicConfigSyncRules$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyReverseConnectionMetrics() {
        KafkaBroker sourceCoordinator = this.isKraftTest() ? this.sourceCluster().linkCoordinator(this.linkName()) : this.sourceCluster().controller();
        KafkaBroker destCoordinator = this.isKraftTest() ? this.destCluster().linkCoordinator(this.linkName()) : this.destCluster().controller();
        this.verifyMetricRange$1((Seq)new .colon.colon((Object)sourceCoordinator, (List)Nil$.MODULE$), "controller-reverse-connection-count", "source", 1.0, 2.0);
        this.verifyMetricRange$1((Seq)new .colon.colon((Object)destCoordinator, (List)Nil$.MODULE$), "controller-reverse-connection-count", "destination", 1.0, 2.0);
        this.verifyMetricRange$1(this.sourceCluster().aliveServers(), "reverse-connection-count", "source", 2.0, 10.0);
        this.verifyMetricRange$1(this.destCluster().aliveServers(), "reverse-connection-count", "destination", 2.0, 10.0);
        this.verifyMetricRange$1(this.sourceCluster().aliveServers(), "reverse-connection-created-total", "source", 2.0, 1000.0);
        this.verifyMetricRange$1(this.destCluster().aliveServers(), "reverse-connection-created-total", "destination", 2.0, 1000.0);
        this.verifyMetricRange$1(this.sourceCluster().aliveServers(), "reverse-connection-closed-total", "source", 0.0, 1000.0);
        this.verifyMetricRange$1(this.destCluster().aliveServers(), "reverse-connection-closed-total", "destination", 0.0, 1000.0);
        String x$1 = "reverse-connection-failed-total";
        Seq<KafkaBroker> x$2 = this.sourceCluster().aliveServers();
        boolean x$3 = false;
        String x$4 = this.verifyKafkaMetric$default$2();
        Option<String> x$5 = this.verifyKafkaMetric$default$4();
        Map<String, String> x$6 = this.verifyKafkaMetric$default$5();
        boolean x$7 = this.verifyKafkaMetric$default$7();
        this.verifyKafkaMetric(x$1, x$4, x$3, x$5, x$6, x$2, x$7);
        Map sourceTag = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"source")}));
        Map dstTag = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"destination")}));
        double sourceLinks = this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "link-count", (Map<String, String>)sourceTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double sourceConns = this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "reverse-connection-count", (Map<String, String>)sourceTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double sourceCreated = this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "reverse-connection-created-total", (Map<String, String>)sourceTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double sourceClosed = this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "reverse-connection-closed-total", (Map<String, String>)sourceTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double destLinks = this.totalKafkaMetricValue(this.destCluster().aliveServers(), "link-count", (Map<String, String>)dstTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double destConns = this.totalKafkaMetricValue(this.destCluster().aliveServers(), "reverse-connection-count", (Map<String, String>)dstTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double destCreated = this.totalKafkaMetricValue(this.destCluster().aliveServers(), "reverse-connection-created-total", (Map<String, String>)dstTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        double destClosed = this.totalKafkaMetricValue(this.destCluster().aliveServers(), "reverse-connection-closed-total", (Map<String, String>)dstTag, this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5());
        SourceInitiatedLinkIntegrationTest.verifyRange$1(sourceLinks, 1.0, 0.0, "Source links vs source alive servers");
        SourceInitiatedLinkIntegrationTest.verifyRange$1(sourceConns, destConns, 2.0, "Dest vs source active connections");
        SourceInitiatedLinkIntegrationTest.verifyRange$1(sourceConns, sourceCreated - sourceClosed, 2.0, "Source active connections vs created-closed");
        SourceInitiatedLinkIntegrationTest.verifyRange$1(destLinks, 1.0, 0.0, "Dest links vs dest alive servers");
        SourceInitiatedLinkIntegrationTest.verifyRange$1(destConns, destCreated - destClosed, 2.0, "Dest active connections vs created-closed");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSourceClusterRestart(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = 2;
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.shutdownSource$1();
        this.restartSource$1();
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = 2;
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, x$13, x$14, x$15, x$16);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestControllerChange(String quorum) {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.destCluster().changeController();
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLocalListenerOverride(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        Properties sourceProps = (Properties)this.sourceLinkProps(this.sourceLinkProps$default$1()).get();
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(sourceProps.stringPropertyNames()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("local.")))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> sourceProps.remove(x$1));
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), this.sourceCluster().interBrokerListenerName().value());
        sourceProps.setProperty(new StringBuilder(23).append("local.").append("security.protocol").toString(), this.sourceCluster().interBrokerSecurityProtocol().name);
        String x$7 = this.linkName();
        Some x$8 = new Some((Object)sourceProps);
        Properties x$9 = this.createClusterLink$default$2();
        boolean x$10 = this.createClusterLink$default$4();
        this.createClusterLink(x$7, x$9, (Option<Properties>)x$8, x$10);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$11 = this.topic();
        short x$122 = this.replicationFactor();
        String x$13 = this.linkName();
        Map<String, String> x$14 = qual$2.linkTopic$default$4();
        String x$15 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$11, x$122, x$13, x$14, x$15);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLinkValidationFailureOnSourceCluster(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties sourceProps = (Properties)this.sourceLinkProps(this.sourceLinkProps$default$1()).get();
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.topicFilter());
        String link2Name = "testLink2";
        String x$7 = this.linkName();
        Some x$8 = new Some((Object)sourceProps);
        Properties x$9 = this.createClusterLink$default$2();
        boolean x$10 = this.createClusterLink$default$4();
        this.createClusterLink(x$7, x$9, (Option<Properties>)x$8, x$10);
        Some x$12 = new Some((Object)sourceProps);
        Properties x$13 = this.createClusterLink$default$2();
        boolean x$14 = this.createClusterLink$default$4();
        this.createClusterLink(link2Name, x$13, (Option<Properties>)x$12, x$14);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$15 = this.linkName();
        Map x$16 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$17 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$15, (Map<String, String>)x$16, x$17);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$20 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$18, (Map<String, String>)x$19, x$20);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$21 = this.linkName();
        Map x$22 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$23 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$21, (Map<String, String>)x$22, x$23);
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        String x$24 = this.linkName();
        Map x$25 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$26 = qual$5.alterClusterLink$default$3();
        qual$5.alterClusterLink(x$24, (Map<String, String>)x$25, x$26);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        String x$27 = this.linkName();
        Map x$28 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$29 = qual$6.alterClusterLink$default$3();
        qual$6.alterClusterLink(x$27, (Map<String, String>)x$28, x$29);
        ClusterLinkTestHarness qual$7 = this.sourceCluster();
        String x$30 = this.linkName();
        Map x$31 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$32 = qual$7.alterClusterLink$default$3();
        qual$7.alterClusterLink(x$30, (Map<String, String>)x$31, x$32);
        ClusterLinkTestHarness qual$8 = this.sourceCluster();
        Map x$34 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$35 = qual$8.alterClusterLink$default$3();
        qual$8.alterClusterLink(link2Name, (Map<String, String>)x$34, x$35);
        ClusterLinkTestHarness qual$9 = this.sourceCluster();
        Map x$37 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$38 = qual$9.alterClusterLink$default$3();
        qual$9.alterClusterLink(link2Name, (Map<String, String>)x$37, x$38);
        ClusterLinkTestHarness qual$10 = this.sourceCluster();
        Map x$40 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$41 = qual$10.alterClusterLink$default$3();
        qual$10.alterClusterLink(link2Name, (Map<String, String>)x$40, x$41);
        ClusterLinkTestHarness qual$11 = this.sourceCluster();
        Map x$43 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$44 = qual$11.alterClusterLink$default$3();
        qual$11.alterClusterLink(link2Name, (Map<String, String>)x$43, x$44);
        ClusterLinkTestHarness qual$12 = this.sourceCluster();
        Map x$46 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"false")}));
        Seq<KafkaBroker> x$47 = qual$12.alterClusterLink$default$3();
        qual$12.alterClusterLink(link2Name, (Map<String, String>)x$46, x$47);
        ClusterLinkTestHarness qual$13 = this.sourceCluster();
        Map x$49 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        Seq<KafkaBroker> x$50 = qual$13.alterClusterLink$default$3();
        qual$13.alterClusterLink(link2Name, (Map<String, String>)x$49, x$50);
        ClusterLinkTestHarness qual$14 = this.destCluster();
        boolean x$51 = qual$14.listClusterLinks$default$1();
        qual$14.listClusterLinks(x$51).foreach((Function1 & Serializable & scala.Serializable)link -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testLinkValidationFailureOnSourceCluster$1(link);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    @Disabled(value="KGLOBAL-1742 Flaky test")
    public void testDeleteSourceSideLink(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        scala.collection.immutable.Map offsetsByPartition = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToLong((long)this.nextOffset(BoxesRunTime.unboxToInt((Object)i)))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$12 = this.linkName();
        boolean x$13 = qual$3.deleteClusterLink$default$2();
        Seq<KafkaBroker> x$14 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$12, x$13, x$14);
        this.produceToSourceCluster(10);
        Thread.sleep(1000L);
        this.verifyMirrorOffsets((Map<Object, Object>)offsetsByPartition);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeSourceSideLinkConfig(String quorum) {
        Map sourcePropOverrides = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.credential"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"local.custom.credential"), (Object)"secret")}));
        String x$1 = this.linkName();
        Option<Properties> x$2 = this.sourceLinkProps((Map<String, String>)sourcePropOverrides);
        Properties x$3 = this.createClusterLink$default$2();
        boolean x$4 = this.createClusterLink$default$4();
        this.createClusterLink(x$1, x$3, x$2, x$4);
        Config linkConfig = this.sourceCluster().describeClusterLink(this.linkName());
        ((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.jaas.config", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.key", "ssl.keystore.certificate.chain", "ssl.truststore.certificates", "ssl.truststore.password", "custom.credential"}))).foreach((Function1 & Serializable & scala.Serializable)config -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$1(linkConfig, config);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"ssl.truststore.type", (List)new .colon.colon((Object)"security.protocol", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)config -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$2(linkConfig, config);
            return BoxedUnit.UNIT;
        });
        linkConfig.entries().forEach(entry -> {
            if (ClusterLinkConfig$.MODULE$.configKeys().get((Object)entry.name()).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$4(x$2)))) {
                SourceInitiatedLinkIntegrationTest.verifySensitive$1(entry.name(), linkConfig);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSyncRules$1(SourceInitiatedLinkIntegrationTest $this, Map expect$1) {
        return $this.destCluster().describeTopicConfigEquals($this.topic(), (Map<String, String>)expect$1);
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSyncRules$2() {
        return "min.compaction.lag.ms, compression.type should sync, max.compaction.lag.ms shouldn't sync";
    }

    private final void verifyMetricRange$1(Seq servers, String name, String mode, double minValue, double maxValue) {
        double value = this.kafkaMetricValue((Seq<KafkaBroker>)servers, name, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)mode)}))), this.kafkaMetricValue$default$4(), this.kafkaMetricValue$default$5());
        Assertions.assertTrue((value >= minValue ? 1 : 0) != 0, (String)new StringBuilder(22).append("Metric ").append(name).append(" too low for ").append(mode).append(": ").append(value).toString());
        Assertions.assertTrue((value <= maxValue ? 1 : 0) != 0, (String)new StringBuilder(23).append("Metric ").append(name).append(" too high for ").append(mode).append(": ").append(value).toString());
    }

    private static final void verifyRange$1(double first, double second, double maxDiff, String desc) {
        Assertions.assertTrue((Math.abs(first - second) <= maxDiff ? 1 : 0) != 0, (String)new StringBuilder(25).append(desc).append(" : (").append(first).append(", ").append(second).append(") not within ").append(maxDiff).append(" range").toString());
    }

    private final void shutdownSource$1() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.sourceCluster().brokers().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.sourceCluster().killBroker(i - this.sourceCluster().firstBrokerId()));
    }

    private final void restartSource$1() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.restartDeadBrokers$default$1();
        qual$1.restartDeadBrokers(x$1);
        this.sourceCluster().updateBootstrapServers();
    }

    public static final /* synthetic */ void $anonfun$testLinkValidationFailureOnSourceCluster$1(ClusterLinkListing link) {
        Assertions.assertTrue((boolean)link.available());
    }

    private static final void verifySensitive$1(String configName, Config linkConfig$1) {
        ConfigEntry configEntry = linkConfig$1.get(configName);
        Assertions.assertNotNull((Object)configEntry, (String)new StringBuilder(17).append("Config not found ").append(configName).toString());
        Assertions.assertNull((Object)configEntry.value(), (String)new StringBuilder(26).append("Sensitive config ").append(configName).append(" returned").toString());
        Assertions.assertTrue((boolean)configEntry.isSensitive(), (String)new StringBuilder(41).append("Sensitive config ").append(configName).append(" not marked as sensitive").toString());
    }

    private static final void verifyNotSensitive$1(String configName, Config linkConfig$1) {
        ConfigEntry configEntry = linkConfig$1.get(configName);
        Assertions.assertNotNull((Object)configEntry, (String)new StringBuilder(17).append("Config not found ").append(configName).toString());
        Assertions.assertNotNull((Object)configEntry.value(), (String)new StringBuilder(48).append("Config ").append(configName).append(" returned null, even though not sensitive").toString());
        Assertions.assertFalse((boolean)configEntry.isSensitive(), (String)new StringBuilder(36).append("Config ").append(configName).append(" marked sensitive incorrectly").toString());
    }

    public static final /* synthetic */ void $anonfun$testDescribeSourceSideLinkConfig$1(Config linkConfig$1, String config) {
        SourceInitiatedLinkIntegrationTest.verifySensitive$1(config, linkConfig$1);
        SourceInitiatedLinkIntegrationTest.verifySensitive$1(new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append(config).toString(), linkConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeSourceSideLinkConfig$2(Config linkConfig$1, String config) {
        SourceInitiatedLinkIntegrationTest.verifyNotSensitive$1(config, linkConfig$1);
        SourceInitiatedLinkIntegrationTest.verifyNotSensitive$1(new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append(config).toString(), linkConfig$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeSourceSideLinkConfig$4(ConfigDef.ConfigKey x$2) {
        ConfigDef.Type type = x$2.type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public SourceInitiatedLinkIntegrationTest() {
        this.useSourceInitiatedLink_$eq(true);
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)new Some((Object)SecurityProtocol.PLAINTEXT), 0, ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4()));
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)new Some((Object)SecurityProtocol.PLAINTEXT), 100, ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4()));
    }
}

