/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u000b\u0017\u0001mAQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00049\u0001\u0001\u0006Ia\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019\t\u0005\u0001)A\u0005w!9!\t\u0001b\u0001\n\u0003\u0019\u0005B\u0002(\u0001A\u0003%A\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003`\u0001\u0011\u0005\u0001\u000bC\u0003e\u0001\u0011%Q\rC\u0003}\u0001\u0011%Q\u0010\u0003\u0004}\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Ba!a\u0018\u0001\t\u0003\u0001\u0006BBA2\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002h\u0001!\t\u0001\u0015\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\ty\t\u0001C\u0005\u0003#Ca!a.\u0001\t\u0003\u0001&!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRT!a\u0006\r\u0002\u00071|wMC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u000f!!\tib$D\u0001\u0017\u0013\tybCA\u0011BEN$(/Y2u\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002\"I5\t!E\u0003\u0002$1\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u0013#\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\b\u0001\u0002\u000b\r|G-Z2\u0016\u0003-\u0002\"\u0001\f\u001c\u000e\u00035R!AL\u0018\u0002\rI,7m\u001c:e\u0015\t\u0001\u0014'\u0001\u0004d_6lwN\u001c\u0006\u00033IR!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO&\u0011q'\f\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u000611m\u001c3fG\u0002\nA\u0001^5nKV\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?1\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001E!\r)\u0005JS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n)\u0011I\u001d:bsB\u00111\nT\u0007\u0002_%\u0011Qj\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0004dY\u0016\fg.\u001e9\u0015\u0003E\u0003\"!\u0012*\n\u0005M3%\u0001B+oSRD#\u0001C+\u0011\u0005YkV\"A,\u000b\u0005aK\u0016aA1qS*\u0011!lW\u0001\bUV\u0004\u0018\u000e^3s\u0015\taF'A\u0003kk:LG/\u0003\u0002_/\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001;i\u0016\u001cH/T1sWN\u0004\u0016M\u001d;ji&|gn]!t\u001f\u001a4G.\u001b8f\u0003:$\u0007k\u001c9vY\u0006$Xm]+oG2,\u0017M\\1cY\u0016lU\r\u001e:jGND#!C1\u0011\u0005Y\u0013\u0017BA2X\u0005\u0011!Vm\u001d;\u0002\u0013\u001d,G/T3ue&\u001cGC\u00014r!\t9w.D\u0001i\u0015\tI'.\u0001\u0003d_J,'BA\u0012l\u0015\taW.\u0001\u0004zC6lWM\u001d\u0006\u0002]\u0006\u00191m\\7\n\u0005AD'AB'fiJL7\rC\u0003s\u0015\u0001\u00071/\u0001\u0004gS2$XM\u001d\t\u0005\u000bR4\u00180\u0003\u0002v\r\nIa)\u001e8di&|g.\r\t\u0003O^L!\u0001\u001f5\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0002Fu&\u00111P\u0012\u0002\b\u0005>|G.Z1o\u0003!9W\r^$bk\u001e,Wc\u0001@\u0002\nQ\u0019q0a\u0007\u0011\u000b\u001d\f\t!!\u0002\n\u0007\u0005\r\u0001NA\u0003HCV<W\r\u0005\u0003\u0002\b\u0005%A\u0002\u0001\u0003\b\u0003\u0017Y!\u0019AA\u0007\u0005\u0005!\u0016\u0003BA\b\u0003+\u00012!RA\t\u0013\r\t\u0019B\u0012\u0002\b\u001d>$\b.\u001b8h!\r)\u0015qC\u0005\u0004\u000331%aA!os\"9\u0011QD\u0006A\u0002\u0005}\u0011AC7fiJL7MT1nKB!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u0011\u0007\u0005\u0015b)\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\tiCR\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055b)\u0006\u0003\u00028\u0005uBCBA\u001d\u0003\u007f\t\t\u0005E\u0003h\u0003\u0003\tY\u0004\u0005\u0003\u0002\b\u0005uBaBA\u0006\u0019\t\u0007\u0011Q\u0002\u0005\b\u0003;a\u0001\u0019AA\u0010\u0011\u001d\t\u0019\u0005\u0004a\u0001\u0003?\t1\"\\3ue&\u001c7kY8qK\u0006Aq-\u001a;NKR,'\u000f\u0006\u0004\u0002J\u0005=\u0013\u0011\u000b\t\u0004O\u0006-\u0013bAA'Q\n)Q*\u001a;fe\"9\u0011QD\u0007A\u0002\u0005}\u0001bBA\"\u001b\u0001\u0007\u0011qD\u0001\rO\u0016$\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u0003/\ni\u0006E\u0002h\u00033J1!a\u0017i\u0005%A\u0015n\u001d;pOJ\fW\u000eC\u0004\u0002\u001e9\u0001\r!a\b\u0002MQ,7\u000f^\"p[B\f7\r^5p]RC'/Z1eg\u000e\u0003X/T3uKJ\u0014UM\\2i[\u0006\u00148\u000e\u000b\u0002\u0010C\u00069B/Z:u\u001b\u0006DHj\\4D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0015\u0003!\u0005\fQ\u0003^3ti\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000f\u000b\u0002\u0012C\u0006Y!/Z1e\rJ|W\u000eT8h)\u0011\ty'a\"\u0011\r\u0005E\u0014qOA>\u001b\t\t\u0019HC\u0002\u0002v\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI(a\u001d\u0003\u0011%#XM]1cY\u0016\u0004r!RA?\u0003\u0003\u000b\t)C\u0002\u0002\u0000\u0019\u0013a\u0001V;qY\u0016\u0014\u0004cA#\u0002\u0004&\u0019\u0011Q\u0011$\u0003\u0007%sG\u000f\u0003\u0004\u0018%\u0001\u0007\u0011\u0011\u0012\t\u0004;\u0005-\u0015bAAG-\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u000319(/\u001b;f\u0017\u0016LH)\u001e9t)A\t\u0019*!'\u0002\u001e\u0006\u0005\u00161UAS\u0003_\u000b\u0019\f\u0005\u0004\u0002r\u0005U\u00151P\u0005\u0005\u0003/\u000b\u0019HA\u0002TKFDq!a'\u0014\u0001\u0004\t\t)A\u0004ok6\\U-_:\t\u000f\u0005}5\u00031\u0001\u0002\u0002\u00069a.^7EkB\u001c\bBB\f\u0014\u0001\u0004\tI\tC\u0003*'\u0001\u00071\u0006C\u0004\u0002(N\u0001\r!!+\u0002\u0013QLW.Z:uC6\u0004\bcA#\u0002,&\u0019\u0011Q\u0016$\u0003\t1{gn\u001a\u0005\b\u0003c\u001b\u0002\u0019AAA\u0003)\u0019H/\u0019:u-\u0006dW/\u001a\u0005\b\u0003k\u001b\u0002\u0019AAA\u0003\u0011\u0019H/\u001a9\u0002%Q,7\u000f^%t)\"\u0014X-\u00193GC&dW\r\u001a\u0015\u0003)\u0005\u0004")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (MetricName)metricName, metric);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (MetricName)metricName, (String)eventType, (TimeUnit)timeUnit);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (MetricName)metricName);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, x$32, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$122));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        this.cleaner().logs().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(x$1);
            return BoxedUnit.UNIT;
        });
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.localLogSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.localLogSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.cleaner().logs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(x$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes.value()));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes2 = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.cleaner().logs().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes2.value()));
    }

    private Metric getMetric(Function1<MetricName, Object> filter) {
        return (Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(metricName, mName));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$2(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Meter getMeter(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMeter$1(metricName, metricScope, k));
        return (Meter)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Histogram getHistogram(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getHistogram$1(metricName, k));
        return (Histogram)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    @Test
    public void testCompactionThreadsCpuMeterBenchmark() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        this.cleaner().startup();
        new ThreadsCpuMeter(((SeqLike)this.cleaner().cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getId()), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq()).runCpuUtilizationBenchmark();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The first call to CPU stats should return 0 as we do not have reference values");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1(), log.roll$default$2());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, firstBlockCleanableSegmentOffset, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.getGauge("compaction-cpu-utilization-percent").value();
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$17 = activeSegAtT1.baseOffset();
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, x$17, x$18);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
        Assertions.assertNotEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The subsequents calls to CPU stats metric after some valid cleanup should return a non-zero value");
    }

    @Test
    public void testCompactionMetrics() {
        double eps = 1.0E-6;
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        this.writeKeyDups(100, 3, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSeg = log.activeSegment();
        this.cleaner().startup();
        Meter readBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Histogram achievedCleaningRatio = this.getHistogram("AchievedCleaningRatio");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.writeKeyDups(100, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 0);
        long expectedReadBytes = log.size();
        log.roll(log.roll$default$1(), log.roll$default$2());
        long blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, blockCleanableSegmentOffset, x$15);
        Assertions.assertEquals((long)expectedReadBytes, (long)readBytesPerSec.count(), (String)new StringBuilder(35).append("log cleaner should have read ").append(expectedReadBytes).append(" bytes").toString());
        Assertions.assertEquals((long)log.size(), (long)writeBytesPerSec.count(), (String)new StringBuilder(8).append("a ").append(log.size()).append(" bytes").toString());
        Assertions.assertEquals((double)100.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        Meter readBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Assertions.assertEquals((long)readBytesPerSec.count(), (long)readBytesPerSecForLocal.count());
        Assertions.assertEquals((long)writeBytesPerSec.count(), (long)writeBytesPerSecForLocal.count());
        log.size();
        this.writeKeyDups(75, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        activeSeg = log.activeSegment();
        log.roll(log.roll$default$1(), log.roll$default$2());
        blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs * 2);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, blockCleanableSegmentOffset, x$18);
        Assertions.assertTrue((achievedCleaningRatio.mean() < (double)100 ? 1 : 0) != 0, (String)"achieved cleaning ratio should be less than 100");
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = 100000;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$52 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$52, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = log.activeSegment().log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ void $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(Tuple2 x$1) {
        if (x$1 != null) {
            AbstractLog log = (AbstractLog)x$1._2();
            ((MergedLog)log).computeLogSizeDetails().cancel(true);
            ((MergedLog)log).updateSizeDetails();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(Tuple2 x$2) {
        return ((AbstractLog)x$2._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(Tuple2 x$3) {
        return ((AbstractLog)x$3._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$2(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeter$1(String metricName$3, String metricScope$2, MetricName k) {
        return k.getName().endsWith(metricName$3) && k.getScope().endsWith(metricScope$2);
    }

    public static final /* synthetic */ boolean $anonfun$getHistogram$1(String metricName$4, MetricName k) {
        return k.getName().endsWith(metricName$4) && k.getScope() == null;
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }

    public LogCleanerIntegrationTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

