/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogLoader$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B+W\u0001mCQ\u0001\u001b\u0001\u0005\u0002%Dq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0001n\u0011\u0019A\b\u0001)A\u0005]\"9\u0011\u0010\u0001b\u0001\n\u0003i\u0007B\u0002>\u0001A\u0003%a\u000eC\u0004|\u0001\t\u0007I\u0011A7\t\rq\u0004\u0001\u0015!\u0003o\u0011\u001di\bA1A\u0005\u0002yDq!!\u0006\u0001A\u0003%q\u0010\u0003\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\tI\u0002\u0001Q\u0001\n}D\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?A\u0011\"!\f\u0001\u0005\u0004%\t!a\f\t\u0011\u0005]\u0002\u0001)A\u0005\u0003cA\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0015\u0001\u0005\u0004%\t!a\u0015\t\u0011\u0005-\u0004\u0001)A\u0005\u0003+2a!!\u001c\u0001\u0001\u0005=\u0004\u0002DA<1\t\u0005\t\u0015!\u0003\u0002z\u0005E\u0005\u0002DAJ1\t\u0005\t\u0015!\u0003\u0002\u0016\u0006\u0005\u0006\u0002DAR1\t\u0005\t\u0015!\u0003\u0002&\u0006E\u0006B\u00025\u0019\t\u0003\t\u0019\fC\u0004\u0002@b!\t%!1\t\u000f\u0005E\u0007\u0004\"\u0011\u0002T\"I\u0011Q\u001f\r\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u001bA\u0012\u0013!C\u0001\u0005\u001fAqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0003.\u0001!IAa\f\t\u000f\t}\u0002\u0001\"\u0001\u0003\u0016!9!\u0011\n\u0001\u0005\u0002\tU\u0001b\u0002B'\u0001\u0011\u0005!Q\u0003\u0005\b\u0005#\u0002A\u0011\u0001B\u000b\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005+AqA!\u0017\u0001\t\u0003\u0011)\u0002C\u0004\u0003^\u0001!\tA!\u0006\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003\u0016!9!Q\r\u0001\u0005\u0002\tU\u0001b\u0002B5\u0001\u0011\u0005!Q\u0003\u0005\b\u0005[\u0002A\u0011\u0001B\u000b\u0011\u001d\u0011\t\b\u0001C\u0001\u0005+AqA!\u001e\u0001\t\u0003\u0011)\u0002C\u0004\u0003z\u0001!\tA!\u0006\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0016!9!\u0011\u0011\u0001\u0005\u0002\tU\u0001b\u0002BC\u0001\u0011\u0005!Q\u0003\u0005\b\u0005\u0013\u0003A\u0011\u0001B\u000b\u0011\u001d\u0011i\t\u0001C\u0001\u0005+AqA!%\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u0016\u0002!\tA!\u0006\t\u000f\te\u0005\u0001\"\u0001\u0003\u0016!9!Q\u0014\u0001\u0005\u0002\tU\u0001b\u0002BQ\u0001\u0011\u0005!Q\u0003\u0005\b\u0005K\u0003A\u0011\u0001B\u000b\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005+AqA!,\u0001\t\u0003\u0011)\u0002C\u0004\u00032\u0002!\tA!\u0006\t\u000f\tU\u0006\u0001\"\u0001\u0003\u0016!9!\u0011\u0018\u0001\u0005\u0002\tU\u0001b\u0002B_\u0001\u0011\u0005!Q\u0003\u0005\b\u0005\u0003\u0004A\u0011\u0001B\u000b\u0011\u001d\u0011)\r\u0001C\u0001\u0005+AqA!3\u0001\t\u0003\u0011)\u0002C\u0004\u0003N\u0002!\tA!\u0006\t\u000f\tE\u0007\u0001\"\u0001\u0003\u0016!9!Q\u001b\u0001\u0005\n\t]\u0007b\u0002Bk\u0001\u0011%!1\u001c\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_D\u0011ba\u0001\u0001#\u0003%Ia!\u0002\t\u0013\r%\u0001!%A\u0005\n\r-\u0001bBB\b\u0001\u0011%1\u0011\u0003\u0005\n\u0007O\u0001\u0011\u0013!C\u0005\u0007SAqa!\f\u0001\t\u0013\u0019y\u0003C\u0004\u0004@\u0001!Ia!\u0011\t\u000f\r%\u0003\u0001\"\u0003\u0004L!I11\f\u0001\u0012\u0002\u0013%11\u0002\u0005\b\u0007;\u0002A\u0011BB0\u0011\u001d\u0019I\b\u0001C\u0005\u0007w\u0012Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002X1\u0006\u0019An\\4\u000b\u0003e\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u00019\n\u0004\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013a!\u00118z%\u00164\u0007CA2g\u001b\u0005!'BA3Y\u0003\u0015)H/\u001b7t\u0013\t9GMA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0007CA6\u0001\u001b\u00051\u0016A\u0002;na\u0012K'/F\u0001o!\tyG/D\u0001q\u0015\t\t(/\u0001\u0002j_*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00059A/\u001c9ESJ\u0014\u0014\u0001\u0003;na\u0012K'O\r\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0001\\8h\t&\u0014('\u0001\u0005m_\u001e$\u0015N\u001d\u001a!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a \t\u0005\u0003\u0003\t\t\"\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0019\u0019w.\\7p]*\u0019\u0011,!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0011aA8sO&!\u00111CA\u0002\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oe\u0005\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t'\u0007I\u0001\tY><\u0007K]8qgV\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005:\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\t\u0019C\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<WCAA\u0019!\rY\u00171G\u0005\u0004\u0003k1&!\u0003'pO\u000e{gNZ5h\u0003)awnZ\"p]\u001aLw\rI\u0001\u0005i&lW-\u0006\u0002\u0002>A\u00191-a\u0010\n\u0007\u0005\u0005CM\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019ygMZ:fiV\u0011\u0011\u0011\n\t\u0004;\u0006-\u0013bAA'=\n\u0019\u0011J\u001c;\u0002\u000f=4gm]3uA\u0005\u00112\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\t)\u0006E\u0004\u0002X\u0005\u0005t0!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\nq!\\;uC\ndWMC\u0002\u0002`y\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019'!\u0017\u0003\u00075\u000b\u0007\u000fE\u0002^\u0003OJ1!!\u001b_\u0005\u0011auN\\4\u0002'\rdW-\u00198fe\u000eCWmY6q_&tGo\u001d\u0011\u0003+1{wm\u00117fC:,'/T1oC\u001e,'/T8dWN\u0019\u0001$!\u001d\u0011\u0007-\f\u0019(C\u0002\u0002vY\u0013\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0003\u001dawn\u001a#jeN\u0004R!a\u001f\u0002\f:tA!! \u0002\b:!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004j\u000ba\u0001\u0010:p_Rt\u0014\"A0\n\u0007\u0005%e,A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0015q\u0012\u0002\u0004'\u0016\f(bAAE=&!\u0011qOA:\u0003\u0011awnZ:\u0011\r\r\f9j`AN\u0013\r\tI\n\u001a\u0002\u0005!>|G\u000eE\u0002l\u0003;K1!a(W\u0005-\t%m\u001d;sC\u000e$Hj\\4\n\t\u0005M\u00151O\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SS1!a+Y\u0003\u0019\u0019XM\u001d<fe&!\u0011qVAU\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY&!\u00111UA:)!\t),!/\u0002<\u0006u\u0006cAA\\15\t\u0001\u0001C\u0004\u0002xq\u0001\r!!\u001f\t\u000f\u0005ME\u00041\u0001\u0002\u0016\"9\u00111\u0015\u000fA\u0002\u0005\u0015\u0016!F1mY\u000ecW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0003\u0007\u0004r!!2\u0002N~\f)G\u0004\u0003\u0002H\u0006%\u0007cAA@=&\u0019\u00111\u001a0\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019'a4\u000b\u0007\u0005-g,A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$\u0002\"!6\u0002\\\u0006}\u0017q\u001e\t\u0004;\u0006]\u0017bAAm=\n!QK\\5u\u0011\u0019\tiN\ba\u0001]\u00069A-\u0019;b\t&\u0014\b\"CAq=A\u0005\t\u0019AAr\u0003Y\u0001\u0018M\u001d;ji&|g\u000eV8Va\u0012\fG/Z(s\u0003\u0012$\u0007#B/\u0002f\u0006%\u0018bAAt=\n1q\n\u001d;j_:\u0004b!XAv\u007f\u0006\u0015\u0014bAAw=\n1A+\u001e9mKJB\u0011\"!=\u001f!\u0003\u0005\r!a=\u0002#A\f'\u000f^5uS>tGk\u001c*f[>4X\r\u0005\u0003^\u0003K|\u0018aG;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ug\u0012\"WMZ1vYR$#'\u0006\u0002\u0002z*\"\u00111]A~W\t\ti\u0010\u0005\u0003\u0002\u0000\n%QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0004=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-!\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aG;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ug\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0012)\"\u00111_A~\u0003!!X-\u0019:E_^tGCAAkQ\r\t#\u0011\u0004\t\u0005\u00057\u0011I#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\r\t\u0007/\u001b\u0006\u0005\u0005G\u0011)#A\u0004kkBLG/\u001a:\u000b\t\t\u001d\u0012QB\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005W\u0011iBA\u0005BMR,'/R1dQ\u0006Y2/\u001a;va&s7M]3bg&tw\r\\=GS2$\b.\u001f'pON$\u0002\"!&\u00032\t]\"1\b\u0005\b\u0005g\u0011\u0003\u0019\u0001B\u001b\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003w\nYi \u0005\b\u0005s\u0011\u0003\u0019AA%\u0003=\u0019H/\u0019:u\u001dVl')\u0019;dQ\u0016\u001c\bb\u0002B\u001fE\u0001\u0007\u0011\u0011J\u0001\u000fE\u0006$8\r[%oGJ,W.\u001a8u\u0003i\"Xm\u001d;DQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\rZ\"iK\u000e\\7OR8s\rJ|'0\u001a8M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;Ti\u0006$X\rK\u0002$\u0005\u0007\u0002BAa\u0007\u0003F%!!q\tB\u000f\u0005\u0011!Vm\u001d;\u0002cQ,7\u000f^!w_&$W*\u0019=D_6\u0004\u0018m\u0019;j_:$U\r\\1z\u0007\u0006d7-\u001e7bi&|g\u000eT1h\u001b\u0006Dh+\u00197vK\"\u001aAEa\u0011\u0002EQ,7\u000f^'bq\u000e{W\u000e]1di&|g\u000eT1h\r>\u00148-Z:M_\u001e\u001cE.Z1oQ\r)#1I\u0001-i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pORC'o\\<t\u000bb\u001cW\r\u001d;j_:D3A\nB\"\u0003i\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><w+\u001b;i)&,'oQ8na\u0006\u001cGOR3biV\u0014X-\u00128bE2,G\rK\u0002(\u0005\u0007\n\u0001\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a*fiV\u0014hn\u001d'pO^KG\u000f\u001b#jeRLWm\u001d;SCRLw\u000eK\u0002)\u0005\u0007\n\u0011\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dunZ%h]>\u0014Xm]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004S\t\r\u0013\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004U\t\r\u0013\u0001\u0016;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:C_RD\u0017J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]N\fe\u000eZ+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004W\t\r\u0013!\u000b;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;SKN,G/\u00134MCJ<WM\u001d+iC:,e\u000eZ(gMN,G\u000fK\u0002-\u0005\u0007\nA\u0006^3ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e*fg\u0016$\u0018JZ*nC2dWM\u001d+iC:\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u00075\u0012\u0019%A\u001auKN$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$H*\u0019:hKJ$\u0006.\u00198BGRLg/Z*fO6,g\u000e\u001e\"bg\u0016|eMZ:fi\"\u001aaFa\u0011\u0002aQ,7\u000f\u001e#jeRLxJ\u001a4tKRd\u0015M]4feRC\u0017M\\!di&4XmU3h[\u0016tGOQ1tK>3gm]3uQ\ry#1I\u0001Ei\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf$U\r\\3uK2{wm\u001d\u0015\u0004a\t\r\u0013\u0001\u0013;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fR3mKR,Gj\\4tQ\r\t$1I\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bf\u0001\u001a\u0003D\u0005YC/Z:u\u0019><7/\u00168eKJ\u001cE.Z1okBLe.\u001a7jO&\u0014G.\u001a$pe\u000e{W\u000e]1di&|g\u000eK\u00024\u0005\u0007\nq\u0006^3tiV\u0003H-\u0019;f\u0007\",7m\u001b9pS:$8o\u00155pk2$\u0017\t\u001a3PM\u001a\u001cX\r\u001e+p!\u0006\u0014H/\u001b;j_:D3\u0001\u000eB\"\u00039\"Xm\u001d;Va\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN\u001c\u0006n\\;mIJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:$\u0015\r^1)\u0007U\u0012\u0019%A\u0017uKN$\b*\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKNCw.\u001e7e%\u0016lwN^3ESJ\fe\u000e\u001a#bi\u0006D3A\u000eB\"\u00035\"Xm\u001d;NCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiNCw.\u001e7e)J,hnY1uK\u0012\u000bG/\u0019\u0015\u0004o\t\r\u0013\u0001\u0010;fgR\fE\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:TQ>,H\u000e\u001a*f[>4X\rR1uC&s7K]2ESJ\fe\u000eZ!eI&sg*Z<ESJD3\u0001\u000fB\"\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oI2{w\r\u0016:v]\u000e\fG/[8oQ\rI$1I\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3U_BL7\rR3mKRLwN\u001c\u0015\u0004u\t\r\u0013A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3feVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\u001a1Ha\u0011\u00021Q,7\u000f^\"p[B\f7\r^3e\u0005f$Xm]'fiJL7\rK\u0002=\u0005\u0007\n1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:O_:,\u0007fA\u001f\u0003D\u0005\tC/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN\f5\r^5wKN+w-\\3oi\"\u001aaHa\u0011\u00027Q,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u0014H+[7fQ\ry$1I\u0001!i\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J\u001c\u0006n\u001c:u)&lW\rK\u0002A\u0005\u0007\n\u0001\u0006^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001ch*Z3eg\u000eCWmY6q_&tGOU3tKRD3!\u0011B\"\u0003)\"Xm\u001d;V]\u0012,7-\u001b3fIR\u0013\u0018M\\:bGRLwN\\1m\t\u0006$\u0018MT8u\u00072,\u0017M\\1cY\u0016D3A\u0011B\"\u0003A!Xm\u001d;E_:,7\t\\3b]&tw\rK\u0002D\u0005\u0007\n\u0001\u0003^3ti\u0012{g.\u001a#fY\u0016$\u0018N\\4)\u0007\u0011\u0013\u0019%A\u0018uKN$8\t[3dWB|\u0017N\u001c;Va\u0012\fG/\u001a3G_JLeN^1mS\u0012|eMZ:fi:{7\t\\3b]&tw\rK\u0002F\u0005\u0007\n\u0001\u0007^3ti\u000eCWmY6q_&tG/\u00169eCR,GMR8s\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;O_R\u001cV\r\\3di\u0016$\u0007f\u0001$\u0003D\u0005!2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJ$B!!\u001d\u0003Z\"1qk\u0012a\u0001\u00037#B!!\u001d\u0003^\"9\u00111\u0013%A\u0002\t}\u0007CBAc\u0005C\fY*\u0003\u0003\u0003d\u0006='aA*fi\u0006A2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJlunY6\u0015\t\u0005U&\u0011\u001e\u0005\b\u0005WL\u0005\u0019AAK\u0003\u0011\u0001xn\u001c7\u0002\u0013\r\u0014X-\u0019;f\u0019><GCCAN\u0005c\u0014)Pa@\u0004\u0002!9!1\u001f&A\u0002\u0005%\u0013aC:fO6,g\u000e^*ju\u0016DqAa>K\u0001\u0004\u0011I0A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003\u000b\u0014Y0\u0003\u0003\u0003~\u0006='AB*ue&tw\rC\u0004~\u0015B\u0005\t\u0019A@\t\u000feT\u0005\u0013!a\u0001]\u0006\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u0001\u0016\u0004\u007f\u0006m\u0018aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\"TCAB\u0007U\rq\u00171`\u0001\u001cGJ,\u0017\r^3M_^\u0014V\r^3oi&|g\u000eT8h\u0007>tg-[4\u0015\u0015\u0005E21CB\u000b\u0007/\u0019\t\u0003C\u0004\u0003t6\u0003\r!!\u0013\t\u000f\t]X\n1\u0001\u0003z\"91\u0011D'A\u0002\rm\u0011A\u0003;jKJ,e.\u00192mKB\u0019Ql!\b\n\u0007\r}aLA\u0004C_>dW-\u00198\t\u0013\r\rR\n%AA\u0002\r\u0015\u0012AE7bq\u000e{W\u000e]1di&|g\u000eT1h\u001bN\u0004R!XAs\u0003K\nQe\u0019:fCR,Gj\\<SKR,g\u000e^5p]2{wmQ8oM&<G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r-\"\u0006BB\u0013\u0003w\fAb\u001e:ji\u0016\u0014VmY8sIN$\"\"!6\u00042\rM2qGB\u001e\u0011\u00199v\n1\u0001\u0002\u001c\"91QG(A\u0002\u0005%\u0013A\u00038v[\n\u000bGo\u00195fg\"91\u0011H(A\u0002\u0005%\u0013a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\t\u000f\rur\n1\u0001\u0002J\u0005\t\"-\u0019;dQ\u0016\u001c\b+\u001a:TK\u001elWM\u001c;\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)\u0019\t)na\u0011\u0004F!1q\u000b\u0015a\u0001\u00037Cqaa\u0012Q\u0001\u0004\tI%\u0001\u0006ok6\u0014VmY8sIN\fq!\\1lK2{w\r\u0006\u0004\u0004N\rM3q\u000b\t\u0004W\u000e=\u0013bAB)-\nIQ*\u001a:hK\u0012dun\u001a\u0005\t\u0007+\n\u0006\u0013!a\u0001]\u0006\u0019A-\u001b:\t\u000f\re\u0013\u000b1\u0001\u00022\u000511m\u001c8gS\u001e\f\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00132\u0003\u001d\u0011XmY8sIN$\u0002b!\u0019\u0004n\rE4Q\u000f\t\u0005\u0007G\u001aI'\u0004\u0002\u0004f)!1qMA\u0002\u0003\u0019\u0011XmY8sI&!11NB3\u00055iU-\\8ssJ+7m\u001c:eg\"91qN*A\u0002\u0005%\u0013aA6fs\"911O*A\u0002\u0005%\u0013!\u0002<bYV,\u0007bBB<'\u0002\u0007\u0011QM\u0001\ni&lWm\u001d;b[B\fQB^3sS\u001aLX*\u001a;sS\u000e\u001cH\u0003BAk\u0007{Bqaa U\u0001\u0004\t\t(\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File tmpDir2;
    private final File logDir;
    private final File logDir2;
    private final TopicPartition topicPartition;
    private final TopicPartition topicPartition2;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Pool<TopicPartition, AbstractLog> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testCheckCleaningAbortedChecksForFrozenLogStartOffsetState() {
        TopicPartition tp = new TopicPartition("test-topic", 0);
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)mockLog);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        cleanerManager.checkCleaningAborted(tp);
        Object object = cleanerManager.cleaningState(tp).get();
        LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
        Assertions.assertTrue((!(object != null ? !object.equals(logCleaningInProgress$) : logCleaningInProgress$ != null) ? 1 : 0) != 0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleanerManager.checkCleaningAborted(tp));
    }

    @Test
    public void testAvoidMaxCompactionDelayCalculationLagMaxValue() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(logSegmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), "1");
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), Long.toString(Long.MAX_VALUE));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.time());
        Metrics metrics = new Metrics();
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerStateManager, tierPartitionState){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> logSegments) {
                throw new IllegalStateException("Error!");
            }
            {
                long x$2 = 0L;
                boolean x$3 = true;
                int x$6 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
                None$ x$8 = None$.MODULE$;
                boolean x$9 = true;
                TierLogComponents x$11 = TierLogComponents$.MODULE$.EMPTY();
                ConcurrentHashMap<K, V> x$12 = new ConcurrentHashMap<K, V>();
                Option x$13 = MergedLog$.MODULE$.$lessinit$greater$default$12();
                super(localLog$1, x$2, x$3, metrics$1, leaderEpochCache$1, x$6, producerStateManager$1, (Option)x$8, x$9, tierPartitionState$1, x$11, x$13, x$12);
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertFalse((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testMaxCompactionLagForcesLogClean() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(logSegmentSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "10");
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.00");
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(localLog, 0L, true, metrics, leaderEpochCache, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), producerStateManager, (Option)None$.MODULE$, true, tierPartitionState, TierLogComponents$.MODULE$.EMPTY(), MergedLog$.MODULE$.$lessinit$greater$default$12(), MergedLog$.MODULE$.$lessinit$greater$default$13());
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
        this.verifyMetrics(cleanerManager);
        this.time().sleep(11L);
        Assertions.assertTrue((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact(), false, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerStateManager, tierPartitionState){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)log, (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogWithTierCompactFeatureEnabled() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact(), true, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.time(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        boolean tierCleanerFeatureEnabled = true;
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, tierCleanerFeatureEnabled, TierPartitionStateCleanupConfig.EMPTY), (Option)None$.MODULE$);
        MergedLog log = MergedLog$.MODULE$.apply(tpDir, config, 0L, 0L, (Scheduler)this.time().scheduler(), new BrokerTopicStats(), new Metrics(), (Time)this.time(), 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), logDirFailureChannel, tierLogComponents, true, (Option)None$.MODULE$, true, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Option)None$.MODULE$, MergedLog$.MODULE$.apply$default$19());
        log.assignTopicId(Uuid.randomUuid(), 1);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        AbstractLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, this.createLog$default$4());
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        AbstractLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, this.createLog$default$4());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> (TopicPartition)x$4._1(), Iterable$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCompactedBytesMetric() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log_1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-1", 0), this.logDir());
        AbstractLog log_2 = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), new TopicPartition("topic-2", 2), this.logDir());
        AbstractLog log_3 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-2", 5), this.logDir());
        AbstractLog log_4 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-2", 10), this.logDir2());
        AbstractLog log_5 = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), new TopicPartition("topic-1", 2), this.logDir2());
        AbstractLog log_6 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), new TopicPartition("topic-3", 2), this.logDir());
        AbstractLog log_7 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), new TopicPartition("topic-4", 2), this.logDir2());
        Set logs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log_1, log_2, log_3, log_4, log_5, log_6, log_7}));
        IntRef numBatches = IntRef.create((int)5);
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$1(this, numBatches, log);
            return BoxedUnit.UNIT;
        });
        this.createCleanerManager((Set<AbstractLog>)logs);
        long logDirSize = log_1.size() + log_2.size() + log_3.size();
        long logDir2Size = log_4.size() + log_5.size();
        Assertions.assertTrue((logDirSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDir2Size > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDirSize != logDir2Size ? 1 : 0) != 0);
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$4(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir2().getAbsolutePath()).value()));
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((AbstractLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    private LogCleanerManager createCleanerManager(AbstractLog log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManager createCleanerManager(Set<AbstractLog> logs) {
        Pool compactedLogs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> (AbstractLog)compactedLogs.put((Object)log.topicPartition(), log));
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), compactedLogs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, AbstractLog> pool) {
        return new LogCleanerManagerMock((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private AbstractLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition, File logDir) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy, false, this.createLowRetentionLogConfig$default$4());
        File partitionDir = new File(logDir, MergedLog$.MODULE$.logDirName(topicPartition));
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 300000;
        int x$10 = 3600000;
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        boolean x$14 = true;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        ConcurrentHashMap x$17 = new ConcurrentHashMap();
        LogOffsetsListener x$18 = MergedLog$.MODULE$.apply$default$17();
        Option x$19 = MergedLog$.MODULE$.apply$default$18();
        return MergedLog$.MODULE$.apply(partitionDir, config, x$3, x$4, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$15, x$16, x$18, x$19, x$17);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private File createLog$default$4() {
        return this.logDir();
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy, boolean tierEnable, Option<Object> maxCompactionLagMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(tierEnable));
        logProps.put(LogConfig$.MODULE$.TierCleanerEnableProp(), "true");
        maxCompactionLagMs.foreach((Function1 & Serializable & scala.Serializable)lag -> logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), Long.toString(BoxesRunTime.unboxToLong((Object)lag))));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private Option<Object> createLowRetentionLogConfig$default$4() {
        return None$.MODULE$;
    }

    private void writeRecords(AbstractLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1(), log.roll$default$2());
    }

    private void appendRecords(AbstractLog log, int numRecords) {
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private MergedLog makeLog(File dir, LogConfig config) {
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 300000;
        int x$10 = 3600000;
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$13 = None$.MODULE$;
        TierLogComponents x$14 = TierLogComponents$.MODULE$.EMPTY();
        boolean x$15 = true;
        boolean x$16 = true;
        LogOffsetsListener x$17 = MergedLog$.MODULE$.apply$default$17();
        Option x$18 = MergedLog$.MODULE$.apply$default$18();
        ConcurrentMap x$19 = MergedLog$.MODULE$.apply$default$19();
        return MergedLog$.MODULE$.apply(dir, config, x$3, x$4, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, x$12, x$14, x$15, (Option)x$13, x$16, x$17, x$18, x$19);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    private void verifyMetrics(LogCleanerManager cleanerManager) {
        long cleanBytes = cleanerManager.cleanBytesLast().get();
        long cleanableBytes = cleanerManager.cleanableBytesLast().get();
        long uncleanableBytes = cleanerManager.uncleanableBytesLast().get();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)cleanerManager.logs().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)LogCleanerManagerTest.$anonfun$verifyMetrics$1(cleanerManager, x0$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)(cleanBytes + cleanableBytes + uncleanableBytes));
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        AbstractLog log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, $this.createLog$default$4());
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$1(LogCleanerManagerTest $this, IntRef numBatches$2, AbstractLog log) {
        $this.writeRecords(log, numBatches$2.elem, 1, 5);
        numBatches$2.elem += 10;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$2(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    private static final Metric getMetric$1(Function1 filter) {
        return (Metric)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$testCompactedBytesMetric$2_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$testCompactedBytesMetric$2_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).head())._2();
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$3(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric$1_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$3(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$testCompactedBytesMetric$2_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$testCompactedBytesMetric$2_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).head())._2());
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$4(AbstractLog log) {
        ((MergedLog)log).computeLogSizeDetails().cancel(true);
        ((MergedLog)log).updateSizeDetails();
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, AbstractLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1(), log$2.roll$default$2());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ long $anonfun$verifyMetrics$1(LogCleanerManager cleanerManager$5, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        AbstractLog log = (AbstractLog)x0$1._2();
        long l = cleanerManager$5.isUncleanablePartition(log, topicPartition) ? 0L : log.size();
        return l;
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.tmpDir2 = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.topicPartition2 = new TopicPartition("log2", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

