/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021BQ!\u0010\u0001\u0005\u00021BQa\u0010\u0001\u0005\u00021BQ!\u0011\u0001\u0005\u00021BQa\u0011\u0001\u0005\u00021BQ!\u0012\u0001\u0005\u00021BQa\u0012\u0001\u0005\u00021BQ!\u0013\u0001\u0005\u00021BQa\u0013\u0001\u0005\u00021BQ!\u0014\u0001\u0005\u00021BQa\u0014\u0001\u0005\u00021BQ!\u0015\u0001\u0005\u00021BQa\u0015\u0001\u0005\u00021BQ!\u0016\u0001\u0005\u00021BQa\u0016\u0001\u0005\u00021BQ!\u0017\u0001\u0005\u00021BQa\u0017\u0001\u0005\nqCQ!\u001c\u0001\u0005\n9DQA\u001e\u0001\u0005\u00021BQ\u0001\u001f\u0001\u0005\u00021BQA\u001f\u0001\u0005\u00021BQ\u0001 \u0001\u0005\u00021BQA \u0001\u0005\u00021Bq!!\u0001\u0001\t\u0013\t\u0019AA\u0007M_\u001e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u00039u\t1\u0001\\8h\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u001c\u0003-*gn];sK:{7\u000b^1uS\u000eLe.\u001b;jC2L'0\u0019;j_:|%\u000fZ3s\t\u0016\u0004XM\u001c3f]\u000eLH#A\u0017\u0011\u0005\tr\u0013BA\u0018$\u0005\u0011)f.\u001b;)\u0005\t\t\u0004C\u0001\u001a<\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029s\u0005)!.\u001e8ji*\t!(A\u0002pe\u001eL!\u0001P\u001a\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cHoS1gW\u0006\u001cuN\u001c4jOR{\u0007K]8qg\"\u00121!M\u00013i\u0016\u001cH/\u00128bE2,7k\u00195f[\u00064\u0016\r\\5eCRLwN\\,ji\"|W\u000f^*dQ\u0016l\u0017MU3hSN$(/_+sY\"\u0012A!M\u00010i\u0016\u001cH/\u00128bE2,7k\u00195f[\u00064\u0016\r\\5eCRLwN\\,ji\"\u001c6\r[3nCJ+w-[:uef,&\u000f\u001c\u0015\u0003\u000bE\n\u0011\u0007^3ti\u0016s\u0017M\u00197f'\u000eDW-\\1WC2LG-\u0019;j_:<\u0016\u000e\u001e5pkRLe\u000e^3sG\u0016\u0004Ho\u001c:DY\u0006\u001c8\u000f\u000b\u0002\u0007c\u0005!D/Z:u\u000b:\f'\r\\3TG\",W.\u0019,bY&$\u0017\r^5p]^KG\u000f[\"vgR|W.\u00138uKJ\u001cW\r\u001d;pe\u000ec\u0017m]:)\u0005\u001d\t\u0014A\u0005;fgR4%o\\7Qe>\u00048/R7qifD#\u0001C\u0019\u0002)Q,7\u000f\u001e$s_6\u0004&o\u001c9t\u0013:4\u0018\r\\5eQ\tI\u0011'\u0001\u0010uKN$\u0018J\u001c<bY&$7i\\7qC\u000e$\u0018n\u001c8MC\u001e\u001cuN\u001c4jO\"\u0012!\"M\u0001&g\"|W\u000f\u001c3WC2LG-\u0019;f)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c8i\u001c8gS\u001eD#aC\u0019\u0002\u001fQ,7\u000f\u001e+p\u0011RlG\u000eV1cY\u0016D#\u0001D\u0019\u0002\u0015Q,7\u000f\u001e+p\u0011RlG\u000e\u000b\u0002\u000ec\u0005\tB/Z:u)>,eN]5dQ\u0016$'k\u001d;)\u00059\t\u0014!\u0003;fgR$vNU:uQ\ty\u0011'\u0001\nuKN$x)\u001a;D_:4\u0017n\u001a,bYV,\u0007F\u0001\t2\u0003\u0015\"Xm\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jON\f5\u000fT8hO\u0006\u0014G.Z*ue&tw\r\u000b\u0002\u0012c\u00059\u0011n\u001d,bY&$GCA/a!\t\u0011c,\u0003\u0002`G\t9!i\\8mK\u0006t\u0007\"B1\u0013\u0001\u0004\u0011\u0017aC2p]\u001aLwMV1mk\u0016\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3$\u001b\u00051'BA4 \u0003\u0019a$o\\8u}%\u0011\u0011nI\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jG\u0005)\u0012m]:feR\u0004&o\u001c9feRL\u0018J\u001c<bY&$GcA\u0017pc\")\u0001o\u0005a\u0001E\u0006!a.Y7f\u0011\u0015\u00118\u00031\u0001t\u0003\u00191\u0018\r\\;fgB\u0019!\u0005^\u0011\n\u0005U\u001c#A\u0003\u001fsKB,\u0017\r^3e}\u0005\tC/Z:u\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>tG)\u001a:jm\u0016$\u0007K]8qg\"\u0012A#M\u0001)i\u0016\u001cH\u000fT8dC2dun\u001a*fi\u0016tG/[8o\t\u0016\u0014\u0018N^3e\t\u00164\u0017-\u001e7u!J|\u0007o\u001d\u0015\u0003+E\n!\u0004^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000e\u0015:paND#AF\u0019\u0002CQ,7\u000f^%om\u0006d\u0017\u000e\u001a'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:)\u0005]\t\u0014A\u0007;fgR\u0004&/\u001a4feRKWM\u001d$fi\u000eDWj\u001d)s_B\u001c\bF\u0001\r2\u0003\r\"w\u000eV3ti&sg/\u00197jI2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000e\u0015:paN$\"\"!\u0002\u0002\u001c\u0005\u0015\u0012qFA\u001a!\u0011\t9!a\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\taaY8oM&<'\u0002BA\b\u0003#\taaY8n[>t'b\u0001\u0010\u0002\u0014)\u0019\u0011QC\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI\"!\u0003\u0003\u001f\r{gNZ5h\u000bb\u001cW\r\u001d;j_:Dq!!\b\u001a\u0001\u0004\ty\"\u0001\tm_\u000e\fGNU3uK:$\u0018n\u001c8NgB\u0019!%!\t\n\u0007\u0005\r2E\u0001\u0003M_:<\u0007bBA\u00143\u0001\u0007\u0011\u0011F\u0001\u0014Y>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u0005f$Xm\u001d\t\u0004E\u0005-\u0012bAA\u0017G\t\u0019\u0011J\u001c;\t\u000f\u0005E\u0012\u00041\u0001\u0002*\u0005q!/\u001a;f]RLwN\u001c\"zi\u0016\u001c\bbBA\u001b3\u0001\u0007\u0011qD\u0001\fe\u0016$XM\u001c;j_:l5\u000f")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableLike)LogConfig$.MODULE$.configNames().filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get(LogConfig$.MODULE$.MessageFormatVersionProp()));
    }

    @Test
    public void testEnableSchemaValidationWithoutSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            logProps.put(cfg, "true");
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> new LogConfig(logProps, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    @Test
    public void testEnableSchemaValidationWithSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithoutInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        logProps.remove("confluent.schema.validator.interceptor.class");
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithCustomInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.validator.interceptor.class", "non.existing.interceptor");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$testFromPropsEmpty$1(x$1))));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.ValueSchemaValidationStrategyProp()));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.KeySchemaValidationStrategyProp()));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig$.MODULE$.validate(props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        kafkaProps.put("confluent.ssl.keystore.password", "akeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(LogConfig$.MODULE$.RetentionBytesProp(), "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        topicOverrides.setProperty("confluent.ssl.truststore.password", "sometrustpasswrd");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig), topicOverrides);
        Assertions.assertEquals((Object)"{confluent.ssl.truststore.password=(redacted), min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)retentionMs, (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionMs(), (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionSize(), (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(2000));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Integer.toString(1000));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Integer.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    @Test
    public void testPreferTierFetchMsProps() {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.PreferTierFetchMsProp(), "100");
        props.put(LogConfig$.MODULE$.CompactedTopicPreferTierFetchMsProp(), "200");
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)100L, (Long)logConfig.confluentLogConfig().preferTierFetchMs());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        LogConfig logConfig2 = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)200L, (Long)logConfig2.confluentLogConfig().preferTierFetchMs());
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Long.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig$.MODULE$.configsWithNoServerDefaults().contains((Object)config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Option serverConfigOpt;
        boolean bl;
        String string = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
        if (!(string != null ? !string.equals(config) : config != null)) {
            bl = true;
        } else {
            String string2 = LogConfig$.MODULE$.KeySchemaValidationEnableProp();
            if (!(string2 != null ? !string2.equals(config) : config != null)) {
                bl = true;
            } else {
                String string3 = LogConfig$.MODULE$.ValueSchemaValidationEnableProp();
                if (!(string3 != null ? !string3.equals(config) : config != null)) {
                    bl = true;
                } else {
                    String string4 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                    if (!(string4 != null ? !string4.equals(config) : config != null)) {
                        bl = true;
                    } else {
                        String string5 = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                        bl = !(string5 != null ? !string5.equals(config) : config != null);
                    }
                }
            }
        }
        boolean bl2 = bl ? !LogConfig$.MODULE$.serverConfigName(config).isDefined() : (serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config)).isDefined() && serverConfigOpt.get() != null;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(Map logProps$2, String cfg) {
        logProps$2.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$2, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(Map logProps$3, String cfg) {
        logProps$3.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$3, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(Map logProps$4, String cfg) {
        logProps$4.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$4, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class non.existing.interceptor cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testFromPropsEmpty$1(Tuple2 x$1) {
        return x$1._2() == null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        block24: {
            block27: {
                String string;
                block26: {
                    block25: {
                        String string2;
                        block23: {
                            String string3 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                            if (!(string3 != null ? !string3.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                                return;
                            }
                            String string4 = LogConfig$.MODULE$.RetentionBytesProp();
                            if (!(string4 != null ? !string4.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                                return;
                            }
                            String string5 = LogConfig$.MODULE$.RetentionMsProp();
                            if (!(string5 != null ? !string5.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                                return;
                            }
                            String string6 = LogConfig$.MODULE$.CleanupPolicyProp();
                            if (!(string6 != null ? !string6.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                                return;
                            }
                            String string7 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                            if (!(string7 != null ? !string7.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string8 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                            if (!(string8 != null ? !string8.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                return;
                            }
                            String string9 = LogConfig$.MODULE$.MessageFormatVersionProp();
                            if (!(string9 != null ? !string9.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                return;
                            }
                            String string10 = LogConfig$.MODULE$.RemoteLogStorageEnableProp();
                            if (!(string10 != null ? !string10.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                                return;
                            }
                            String string11 = LogConfig$.MODULE$.LocalLogRetentionMsProp();
                            if (!(string11 != null ? !string11.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                                return;
                            }
                            String string12 = LogConfig$.MODULE$.LocalLogRetentionBytesProp();
                            if (!(string12 != null ? !string12.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                                return;
                            }
                            String string13 = LogConfig$.MODULE$.TierLocalHotsetBytesProp();
                            if (!(string13 != null ? !string13.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string14 = LogConfig$.MODULE$.TierLocalHotsetMsProp();
                            if (!(string14 != null ? !string14.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string15 = LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp();
                            if (!(string15 != null ? !string15.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string16 = LogConfig$.MODULE$.PreferTierFetchMsProp();
                            if (!(string16 != null ? !string16.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string17 = LogConfig$.MODULE$.CompactedTopicPreferTierFetchMsProp();
                            if (!(string17 != null ? !string17.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string18 = LogConfig$.MODULE$.TierCleanerEnableProp();
                            if (!(string18 != null ? !string18.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                                return;
                            }
                            String string19 = LogConfig$.MODULE$.TierCleanerCompactMinEfficiencyRatioProp();
                            if (!(string19 != null ? !string19.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string20 = LogConfig$.MODULE$.TierCleanerMinCleanableRatioProp();
                            if (!(string20 != null ? !string20.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string21 = LogConfig$.MODULE$.TierCleanerCompactSegmentMinBytesProp();
                            if (!(string21 != null ? !string21.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                                return;
                            }
                            String string22 = LogConfig$.MODULE$.TierCleanerDualCompactionProp();
                            if (!(string22 != null ? !string22.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                                return;
                            }
                            String string23 = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
                            if (!(string23 != null ? !string23.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"json only", "null"}));
                                return;
                            }
                            string2 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                            if (string2 != null) break block23;
                            if (name == null) break block24;
                            break block25;
                        }
                        if (string2.equals(name)) {
                            return;
                        }
                    }
                    string = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                    if (string != null) break block26;
                    if (name == null) break block24;
                    break block27;
                }
                if (string.equals(name)) {
                    return;
                }
            }
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        }
    }
}

