/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.CleanerConfig;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.TimeIndex;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013\u0005!\f\u0003\u0004b\u0001\u0001\u0006Ia\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0011\u00199\u0007\u0001)A\u0005I\"9\u0001\u000e\u0001b\u0001\n\u0003\u0019\u0007BB5\u0001A\u0003%A\rC\u0004k\u0001\t\u0007I\u0011A6\t\rQ\u0004\u0001\u0015!\u0003m\u0011\u001d)\bA1A\u0005\u0002YDaA\u001f\u0001!\u0002\u00139\bbB>\u0001\u0001\u0004%\t\u0001 \u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0001\u0003\u0013Aq!!\u0006\u0001A\u0003&Q\u0010C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0001\u0002\u001a!I\u0011\u0011\u0005\u0001A\u0002\u0013\u0005\u00111\u0005\u0005\t\u0003O\u0001\u0001\u0015)\u0003\u0002\u001c!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002.!I\u00111\b\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002@!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA3\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003_\u0002A\u0011AA%\u0011\u001d\tI\b\u0001C\u0001\u0003\u0013Bq!! \u0001\t\u0003\tI\u0005C\u0004\u0002\u0002\u0002!\t!!\u0013\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002J!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAI\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Bq!a3\u0001\t\u0003\tI\u0005C\u0004\u0002P\u0002!\t!!\u0013\t\u000f\u0005M\u0007\u0001\"\u0001\u0002J!9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBAz\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003o\u0004A\u0011AA%\u0011\u001d\tY\u0010\u0001C\u0001\u0003\u0013Bq!a@\u0001\t\u0003\tI\u0005C\u0004\u0003\u0004\u0001!\t!!\u0013\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002J!9!1\u0002\u0001\u0005\n\t5\u0001b\u0002B\u001e\u0001\u0011%!Q\b\u0005\n\u0005O\u0002\u0011\u0013!C\u0005\u0005SB\u0011Ba \u0001#\u0003%IA!!\t\u0013\t\u0015\u0005!%A\u0005\n\t\u001d\u0005\"\u0003BF\u0001E\u0005I\u0011\u0002BG\u0011\u001d\u0011\t\n\u0001C\u0001\u0003\u0013BqA!&\u0001\t\u0003\tI\u0005C\u0004\u0003\u001a\u0002!\t!!\u0013\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"I!\u0011\u0018\u0001\u0012\u0002\u0013%!q\u0011\u0005\b\u0005w\u0003A\u0011AA%\u0011\u001d\u0011y\f\u0001C\u0001\u0003\u0013BqAa1\u0001\t\u0003\tI\u0005C\u0004\u0003H\u0002!\t!!\u0013\t\u000f\t-\u0007\u0001\"\u0001\u0002J!9!q\u001a\u0001\u0005\u0002\u0005%\u0003b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\b\u0005?\u0004A\u0011\u0002Bq\u0011\u001d\u0011)\u000f\u0001C\u0005\u0005ODqa!\u0001\u0001\t\u0013\u0019\u0019\u0001C\u0004\u0004\u001a\u0001!Iaa\u0007\t\u000f\rU\u0002\u0001\"\u0003\u00048!911\b\u0001\u0005\u0002\u0005%\u0003bBB \u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0007\u0007\u0002A\u0011AA%\u0011\u001d\u00199\u0005\u0001C\u0001\u0003\u0013Bqaa\u0013\u0001\t\u0003\tI\u0005C\u0004\u0004P\u0001!\t!!\u0013\u0003\u001d1{w-T1oC\u001e,'\u000fV3ti*\u0011!jS\u0001\u0004Y><'\"\u0001'\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0006C\u0001-\u0001\u001b\u0005I\u0015\u0001\u0002;j[\u0016,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000bQ!\u001e;jYNL!\u0001Y/\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq\"\\1y%>dG.\u00138uKJ4\u0018\r\\\u000b\u0002IB\u0011\u0001+Z\u0005\u0003MF\u00131!\u00138u\u0003Ai\u0017\r\u001f*pY2Le\u000e^3sm\u0006d\u0007%A\u0006nCbdunZ!hK6\u001b\u0018\u0001D7bq2{w-Q4f\u001bN\u0004\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\tU$\u0018\u000e\u001c\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hN\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<W#A<\u0011\u0005aC\u0018BA=J\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\na\u0001\\8h\t&\u0014X#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001]\u0001\u0003S>L1!!\u0002\u0000\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001)\u0002\u000e%\u0019\u0011qB)\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003'i\u0011\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005m\u0001c\u0001-\u0002\u001e%\u0019\u0011qD%\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005-\u0011Q\u0005\u0005\n\u0003'\u0001\u0012\u0011!a\u0001\u00037\t1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005!a.Y7f+\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019\u0004]\u0001\u0005Y\u0006tw-\u0003\u0003\u00028\u0005E\"AB*ue&tw-A\u0003oC6,\u0007%A\rwKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006dWCAA !\r\u0001\u0016\u0011I\u0005\u0004\u0003\u0007\n&\u0001\u0002'p]\u001e\f!D^3ss2\u000b'oZ3M_\u001e4E.^:i\u0013:$XM\u001d<bY\u0002\nQa]3u+B$\"!a\u0003)\u0007Y\ti\u0005\u0005\u0003\u0002P\u0005\u0005TBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002X\u0005e\u0013a\u00026va&$XM\u001d\u0006\u0005\u00037\ni&A\u0003kk:LGO\u0003\u0002\u0002`\u0005\u0019qN]4\n\t\u0005\r\u0014\u0011\u000b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\tI\u0007\u0005\u0003\u0002P\u0005-\u0014\u0002BA7\u0003#\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001bQ,7\u000f^\"sK\u0006$X\rT8hQ\rA\u00121\u000f\t\u0005\u0003\u001f\n)(\u0003\u0003\u0002x\u0005E#\u0001\u0002+fgR\fA\u0005^3ti\"\u000bg\u000e\u001a7j]\u001e,\u0005pY3qi&|gn\u001d#ve&twm\u00155vi\u0012|wO\u001c\u0015\u00043\u0005M\u0014A\b;fgR\u001c%/Z1uK2{wmV5uQ&sg/\u00197jI2{w\rR5sQ\rQ\u00121O\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007fA\u000e\u0002t\u0005)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007f\u0001\u000f\u0002t\u0005\u0011#/Z2p]\u001aLw-\u001e:f\u001b\u0006D8+Z4nK:$H)\u001a7fi\u0016$\u0007+\u001a:Sk:$B!a\u0003\u0002\u000e\"1\u0011qR\u000fA\u0002\u0011\fA\u0004\\8h\t\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+h.A\u0018uKN$Hj\\4EK2,G/[8o\u001b\u0006D8+Z4nK:$8\u000fU3s%VtW\t\u001f9je\u0016$7+Z4nK:$8\u000fK\u0002\u001f\u0003g\na\t^3ti2{w\rR3mKRLwN\\'bqN+w-\\3oiN\u0004VM\u001d*v]\u0006cwN\\4XSRDG+[3s'\u0016<W.\u001a8u\u0011>$8/\u001a;S_2dW*\u001b8CsR,7\u000f\u0006\u0003\u0002\f\u0005e\u0005bBAN?\u0001\u0007\u0011QT\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fIB\u0019\u0001+a(\n\u0007\u0005\u0005\u0016KA\u0004C_>dW-\u00198)\u000f}\t)+!.\u00028B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005=\u0016QK\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005M\u0016\u0011\u0016\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\tI,a/\u001a\u0003\u0005I\u0012\u0001\u0001\u0015\u0004?\u0005}\u0006\u0003BAa\u0003\u0007l!!!,\n\t\u0005\u0015\u0017Q\u0016\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bf\u0001\u0011\u0002t\u0005\tC/Z:u\u00072,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{K\"\u001a\u0011%a\u001d\u0002UQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$H)\u001a7fi\u0016\u0004v\u000e\\5ds\"\u001a!%a\u001d\u0002IQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$\bk\u001c7jGfD3aIA:\u0003M!Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t)\u0011\tY!a7\t\u000f\u0005uG\u00051\u0001\u0002`\u00061\u0001o\u001c7jGf\u0004B!!9\u0002p:!\u00111]Av!\r\t)/U\u0007\u0003\u0003OT1!!;N\u0003\u0019a$o\\8u}%\u0019\u0011Q^)\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!=\u000b\u0007\u00055\u0018+\u0001\nuKN$H+[7f\u0005\u0006\u001cX\r\u001a$mkND\u0007fA\u0013\u0002t\u0005IB/Z:u\u0019\u0016\f7\u000f\u001e'pC\u0012,G-Q:tS\u001etW.\u001a8uQ\r1\u00131O\u0001$i\u0016\u001cH\u000fV<p\u0019><W*\u00198bO\u0016\u00148/V:j]\u001e\u001c\u0016-\\3ESJ4\u0015-\u001b7tQ\r9\u00131O\u0001\u001di\u0016\u001cHo\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ssB{\u0017N\u001c;tQ\rA\u00131O\u0001.i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\b\u000e\u0016:bS2LgnZ*mCND\u0007fA\u0015\u0002t\u0005\tD/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i%\u0016d\u0017\r^5wK\u0012K'/Z2u_JL\bf\u0001\u0016\u0002t\u0005Ab/\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=\u0015\u0011\u0005-!q\u0002B\u001c\u0005sAqA!\u0005,\u0001\u0004\u0011\u0019\"A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011)Ba\b\u0003&9!!q\u0003B\u000e\u001d\u0011\t)O!\u0007\n\u0003IK1A!\bR\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\t\u0003$\t\u00191+Z9\u000b\u0007\tu\u0011\u000b\u0005\u0003\u0003(\tMRB\u0001B\u0015\u0015\u0011\u0011YC!\f\u0002\r\r|W.\\8o\u0015\ra%q\u0006\u0006\u0005\u0005c\ti&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0005k\u0011IC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005]1\u00061\u0001\u0002\u001c!)1p\u000ba\u0001{\u0006\u00012M]3bi\u0016dunZ'b]\u0006<WM\u001d\u000b\u000b\u00037\u0011yD!\u0012\u0003Z\tu\u0003\"\u0003B!YA\u0005\t\u0019\u0001B\"\u0003\u001dawn\u001a#jeN\u0004RA!\u0006\u0003 uD\u0011Ba\u0012-!\u0003\u0005\rA!\u0013\u0002!\r|gNZ5h%\u0016\u0004xn]5u_JL\b\u0003\u0002B&\u0005+j!A!\u0014\u000b\t\t=#\u0011K\u0001\t[\u0016$\u0018\rZ1uC*\u0019!1K&\u0002\rM,'O^3s\u0013\u0011\u00119F!\u0014\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\b\u0002\u0003B.YA\u0005\t\u0019\u00013\u00023I,7m\u001c<fef$\u0006N]3bIN\u0004VM\u001d#bi\u0006$\u0015N\u001d\u0005\n\u0005?b\u0003\u0013!a\u0001\u0005C\n\u0011\u0003^5fe2{wmQ8na>tWM\u001c;t!\rA&1M\u0005\u0004\u0005KJ%!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006Q2M]3bi\u0016dunZ'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000e\u0016\u0005\u0005\u0007\u0012ig\u000b\u0002\u0003pA!!\u0011\u000fB>\u001b\t\u0011\u0019H\u0003\u0003\u0003v\t]\u0014!C;oG\",7m[3e\u0015\r\u0011I(U\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B?\u0005g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019I\u000b\u0003\u0003J\t5\u0014AG2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\u001aTC\u0001BEU\r!'QN\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u001fSCA!\u0019\u0003n\u0005\u0011C/Z:u\r&dWMU3gKJ,gnY3t\u0003\u001a$XM]!ts:\u001cG)\u001a7fi\u0016D3!MA:\u0003\t\"Xm\u001d;De\u0016\fG/Z!oI\u0012+G.\u001a;f\u001fZ,'\u000f\\=M_:<Gk\u001c9jG\"\u001a!'a\u001d\u0002CQ,7\u000f^\"iK\u000e\\\u0007o\\5oi\u001a{'o\u00148ms\u00063g-Z2uK\u0012dunZ:)\u0007M\n\u0019(A\u0004sK\u0006$Gj\\4\u0015\u0011\t\u0005&\u0011\u0016BY\u0005k\u0003BAa)\u0003&6\u0011!\u0011K\u0005\u0005\u0005O\u0013\tFA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\u0007\u0015R\u0002\rAa+\u0011\u0007a\u0013i+C\u0002\u00030&\u00131\"\u00112tiJ\f7\r\u001e'pO\"9!1\u0017\u001bA\u0002\u0005}\u0012AB8gMN,G\u000f\u0003\u0005\u00038R\u0002\n\u00111\u0001e\u0003%i\u0017\r\u001f'f]\u001e$\b.A\tsK\u0006$Gj\\4%I\u00164\u0017-\u001e7uIM\nQ\u0005^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<W-\u00169eCR,7\u000fT8h\u0007>tg-[4)\u0007Y\n\u0019(A\u000fuKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\u001e+Go]\"mK\u0006tW\rZ+qQ\r9\u00141O\u0001)i\u0016\u001cHO\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hK\u0012+G.\u001b<fe\u0016$Gk\\!mY2{wm\u001d\u0015\u0004q\u0005M\u0014a\r;fgR$v\u000e]5d\u0007>tg-[4DQ\u0006tw-Z*u_B\u001cE.Z1oS:<\u0017JZ\"p[B\f7\r^%t%\u0016lwN^3eQ\rI\u00141O\u0001-i\u0016\u001cHoQ8oM&<7\t[1oO\u0016\u001cx+\u001b;i\u001d>dunZ$fiRLgnZ%oSRL\u0017\r\\5{K\u0012D3AOA:\u0003y!Xm\u001d;DQ\u0016\u001c7\u000e]8j]R$\u0016.\u001a:Ti\u0006$XMR1jYV\u0014X\rK\u0002<\u0003g\na\u0005^3ti\u0012+G.\u001a;f\u0003:$G+[3s'R\fG/\u001a$mkND7i\u001c8dkJ\u0014XM\\2z)\u0011\tYAa6\t\u000f\u0005mE\b1\u0001\u0002\u001e\":A(!*\u00026\nmG\u0006BA]\u0003wC3\u0001PA`\u0003a!\u0018.\u001a:F]\u0006\u0014G.\u001a3M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u000b\u0005\u0005C\u0012\u0019\u000fC\u0004\u0002\u001cv\u0002\r!!(\u0002%\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)>dun\u001a\u000b\r\u0003\u0017\u0011IOa;\u0003p\nM(Q \u0005\u00063z\u0002\ra\u0017\u0005\u0007\u0005[t\u0004\u0019A?\u0002\u0019A\f'/\u001a8u\u0019><G)\u001b:\t\r\tEh\b1\u0001e\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\tUh\b1\u0001\u0003x\u0006\u0001\"M]8lKJ$v\u000e]5d'R\fGo\u001d\t\u0005\u0005G\u0013I0\u0003\u0003\u0003|\nE#\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0011yP\u0010a\u0001I\u00061R\r\u001f9fGR,GmU3h[\u0016tGo\u001d)fe2{w-\u0001\u0012wKJLg-\u001f*f[\u0006Lg.\u001b8h\u0019><7\u000fV8SK\u000e|g/\u001a:NKR\u0014\u0018n\u0019\u000b\u0007\u0003\u0017\u0019)a!\u0003\t\u000f\r\u001dq\b1\u0001\u0002\u001c\u0005i1\u000f]=M_\u001el\u0015M\\1hKJDqaa\u0003@\u0001\u0004\u0019i!\u0001\bfqB,7\r^3e!\u0006\u0014\u0018-\\:\u0011\u000f\r=1QCApI6\u00111\u0011\u0003\u0006\u0004\u0007'\t\u0016AC2pY2,7\r^5p]&!1qCB\t\u0005\ri\u0015\r]\u0001'm\u0016\u0014\u0018NZ=SK6\f\u0017N\\5oON+w-\\3oiN$vNU3d_Z,'/T3ue&\u001cG\u0003DA\u0006\u0007;\u0019yb!\t\u0004$\rM\u0002bBB\u0004\u0001\u0002\u0007\u00111\u0004\u0005\b\u0005\u0003\u0002\u0005\u0019\u0001B\"\u0011\u0019\u0011Y\u0006\u0011a\u0001I\"91Q\u0005!A\u0002\r\u001d\u0012aB7pG.l\u0015\r\u001d\t\b\u0007S\u0019y#a8e\u001b\t\u0019YCC\u0002\u0004.9\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0019\tda\u000b\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fC\u0004\u0004\f\u0001\u0003\ra!\u0004\u0002=Y,'/\u001b4z\u0019><'+Z2pm\u0016\u0014X*\u001a;sS\u000e\u001c(+Z7pm\u0016$G\u0003BA\u0006\u0007sAqaa\u0002B\u0001\u0004\tY\"\u0001\fuKN$Hj\\4SK\u000e|g/\u001a:z\u001b\u0016$(/[2tQ\r\u0011\u00151O\u00017i\u0016\u001cH\u000fT8h%\u0016\u001cwN^3ss6+GO]5dgNCw.\u001e7e\u0005\u0016\u0014V-\\8wK\u0012\fe\r^3s\u0019><'+Z2pm\u0016\u0014X\r\u001a\u0015\u0004\u0007\u0006M\u0014\u0001\r;fgRlU\r\u001e:jGN,\u00050[:u/\",g\u000eT8h\u0013N\u0014Vm\u0019:fCR,GMQ3g_J,G)\u001a7fi&|g\u000eK\u0002E\u0003g\n\u0011\u0007^3ti6+GO]5dg\u0006\u0013XMU3n_Z,Gm\u00165f]6{g/\u001b8h\u0007V\u0014(/\u001a8u)>4U\u000f^;sK2{w\rK\u0002F\u0003g\n\u0001\u0004^3ti^\u000b\u0017\u000e\u001e$pe\u0006cG\u000eV8D_6\u0004H.\u001a;fQ\r1\u00151O\u0001\u001ei\u0016\u001cH\u000fT8bI2{wm]'be.,GMR8s\t\u0016dW\r^5p]\"\u001aq)a\u001d")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            AbstractLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            AbstractLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$2, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        boolean x$22 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, x$22, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable & scala.Serializable containsLogFile = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    private void reconfigureMaxSegmentDeletedPerRun(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(Predef$.MODULE$.Integer2int(this.logManager().segmentDeletionThrottlerConfig().configuredDeletionMaxSegmentsPerRun()));
        KafkaConfig newConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(logDeletionMaxSegmentsPerRun);
        this.logManager().segmentDeletionThrottlerConfig().reconfigure(oldConfig, newConfig);
    }

    @Test
    public void testLogDeletionMaxSegmentsPerRunExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$32, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            byte[] x$5 = "test".getBytes();
            long x$6 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
            byte[] x$7 = TestUtils$.MODULE$.singletonRecords$default$2();
            CompressionType x$8 = TestUtils$.MODULE$.singletonRecords$default$3();
            byte x$9 = TestUtils$.MODULE$.singletonRecords$default$5();
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords(x$5, x$7, x$8, x$6, x$9);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        int numSegments = log.numberOfSegments();
        this.reconfigureMaxSegmentDeletedPerRun(0);
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(this, x$3)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"No segment should be deleted.");
        this.reconfigureMaxSegmentDeletedPerRun(log.numberOfSegments());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes(boolean checksumEnabled) {
        this.logManager().shutdown();
        int recordSize = this.createRecords$1().sizeInBytes();
        long tierLocalHotsetMs = 36000L;
        int tierSegmentHotsetRollMinBytes = 5 * recordSize;
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(10 * recordSize));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp(), Integer.toString(tierSegmentHotsetRollMinBytes));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierLocalHotsetMsProp(), Long.toString(tierLocalHotsetMs));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.SegmentMsProp(), Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        TierLogComponents x$1 = this.tierEnabledLogComponents(checksumEnabled);
        Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4, x$1));
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log1 = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        LogManager qual$2 = this.logManager();
        TopicPartition x$9 = new TopicPartition(this.name(), 1);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$2.getOrCreateLog$default$2();
        boolean x$12 = qual$2.getOrCreateLog$default$3();
        AbstractLog log2 = qual$2.getOrCreateLog(x$9, x$11, x$12, (Option)x$10);
        log1.assignTopicId(Uuid.randomUuid(), log1.assignTopicId$default$2());
        log2.assignTopicId(Uuid.randomUuid(), log2.assignTopicId$default$2());
        Assertions.assertTrue((boolean)log1.tierPartitionState().isTieringEnabled());
        Assertions.assertTrue((boolean)log2.tierPartitionState().isTieringEnabled());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)log -> {
            log.tierPartitionState().onCatchUpComplete();
            return log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader((TopicIdPartition)log.topicIdPartition().get(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 25).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(this, log1, log2, BoxesRunTime.unboxToInt((Object)_)));
        Assertions.assertTrue((log1.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        Assertions.assertTrue((log2.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        log1.updateHighWatermark(log1.logEndOffset());
        log2.updateHighWatermark(log2.logEndOffset());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)log1.tieredLogSegments().size());
        Assertions.assertEquals((int)2, (int)log2.tieredLogSegments().size());
        this.reconfigureMaxSegmentDeletedPerRun(1);
        this.time().sleep(tierLocalHotsetMs + 1L);
        this.logManager().cleanupLogsAndMaybeForceRoll();
        Assertions.assertTrue((log1.localLogSegments().size() == 3 && log2.localLogSegments().size() == 4 || log1.localLogSegments().size() == 4 && log2.localLogSegments().size() == 3 ? 1 : 0) != 0, (String)"Should have 1 segment removed from either of the 2 logs");
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$42, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        properties.put(LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        LogManager qual$1 = this.logManager();
        TopicPartition x$52 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$52, x$7, x$8, (Option)x$6);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$4.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$5)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.FlushMsProp(), "1000");
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom());
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$8 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$8, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir, TierLogComponents tierLogComponents) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$7 = TestUtils$.MODULE$.createLogManager$default$4();
        SegmentDeletionThrottlerConfig x$8 = TestUtils$.MODULE$.createLogManager$default$6();
        MetadataVersion x$9 = TestUtils$.MODULE$.createLogManager$default$7();
        return TestUtils$.MODULE$.createLogManager(logDirs, x$1, configRepository, x$7, x$4, x$8, x$9, recoveryThreadsPerDataDir, tierLogComponents);
    }

    private Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    private TierLogComponents createLogManager$default$4() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$10)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(x$5, x$6, x$7, x$8).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach(arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$5, x$6, x$7, x$8);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$13 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$13, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(AbstractLog log, long offset, int maxLength) {
        AbstractFetchDataInfo abstractFetchDataInfo = log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(abstractFetchDataInfo).toString());
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return fetchDataInfo;
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig oldLogConfig = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), oldProperties);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = spyLogManager.getOrCreateLog$default$2();
        boolean x$8 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log0 = spyLogManager.getOrCreateLog(tp0, x$7, x$8, (Option)x$6);
        log0.updateConfig(oldLogConfig);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = spyLogManager.getOrCreateLog$default$2();
        boolean x$12 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log1 = spyLogManager.getOrCreateLog(tp1, x$11, x$12, (Option)x$10);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete());
        Assertions.assertTrue((boolean)log1.config().delete());
        Assertions.assertFalse((boolean)log0.config().compact());
        Assertions.assertFalse((boolean)log1.config().compact());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testCheckpointTierStateFailure() {
        File logDir = TestUtils$.MODULE$.tempDir();
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(false);
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tierLogComponents.topicConsumerOpt().get();
        HashMap<Integer, OffsetAndEpoch> proposedPositions = new HashMap<Integer, OffsetAndEpoch>();
        proposedPositions.put(Predef$.MODULE$.int2Integer(0), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(10))));
        proposedPositions.put(Predef$.MODULE$.int2Integer(1), new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(20))));
        Mockito.when((Object)tierTopicConsumer.snapshotPositions()).thenReturn(proposedPositions);
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        int x$4 = this.createLogManager$default$3();
        LogManager logManager = (LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)x$1, configRepository, x$4, tierLogComponents));
        TierPartitionState okTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)okTierPartitionState.flush())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierPartitionState throwingTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)throwingTierPartitionState.flush())).thenThrow(new Throwable[]{new IOException("uh oh")});
        AbstractLog okLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)okLog.tierPartitionState()).thenReturn((Object)okTierPartitionState);
        AbstractLog throwingLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)throwingLog.dir()).thenReturn((Object)logDir);
        Mockito.when((Object)throwingLog.tierPartitionState()).thenReturn((Object)throwingTierPartitionState);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)new .colon.colon((Object)okLog, (List)new .colon.colon((Object)throwingLog, (List)Nil$.MODULE$)));
        ((LogManager)Mockito.doReturn((Object)new Some((Object)okLog), (Object[])new Object[]{new Some((Object)throwingLog)}).when((Object)logManager)).getLog((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        logManager.tryRunTierStateCheckpoint();
        ((TierTopicConsumer)Mockito.verify((Object)tierTopicConsumer, (VerificationMode)Mockito.never())).writePositions((java.util.Map)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeleteAndTierStateFlushConcurrency(boolean checksumEnabled) {
        File logDir = TestUtils$.MODULE$.tempDir();
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(checksumEnabled);
        Mockito.when((Object)((TierTopicConsumer)tierLogComponents.topicConsumerOpt().get()).snapshotPositions()).thenReturn(new HashMap());
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        int x$4 = this.createLogManager$default$3();
        LogManager logManager = this.createLogManager((Seq<File>)x$1, configRepository, x$4, tierLogComponents);
        VolatileBooleanRef isDone = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef exceptionOpt = VolatileObjectRef.create((Object)None$.MODULE$);
        int numPartitions = 50;
        Thread t = new Thread(null, isDone, logManager, exceptionOpt){
            private final VolatileBooleanRef isDone$1;
            private final LogManager logManager$2;
            private final VolatileObjectRef exceptionOpt$1;

            public void run() {
                try {
                    while (!this.isDone$1.elem) {
                        this.logManager$2.tryRunTierStateCheckpoint();
                    }
                }
                catch (Exception e) {
                    this.exceptionOpt$1.elem = new Some((Object)e);
                }
            }
            {
                this.isDone$1 = isDone$1;
                this.logManager$2 = logManager$2;
                this.exceptionOpt$1 = exceptionOpt$1;
            }
        };
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Uuid topicId = Uuid.randomUuid();
            TopicPartition topicPartition = new TopicPartition(this.name(), i);
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), CoreUtils$.MODULE$.toJavaUUID(topicId), topicPartition.partition());
            Some x$6 = new Some((Object)topicId);
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            AbstractLog log = logManager.getOrCreateLog(topicPartition, x$7, x$8, (Option)x$6);
            log.tierPartitionState().setTopicId(topicIdPartition.topicId());
            TierPartitionState.AppendResult result = log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
        });
        t.start();
        IndexedSeq allLogs = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> logManager.asyncDelete(new TopicPartition(this.name(), BoxesRunTime.unboxToInt((Object)i)), logManager.asyncDelete$default$2(), logManager.asyncDelete$default$3(), logManager.asyncDelete$default$4()), IndexedSeq$.MODULE$.canBuildFrom());
        isDone.elem = true;
        t.join();
        allLogs.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManagerTest.$anonfun$testDeleteAndTierStateFlushConcurrency$3(x$15);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)logDir);
        ((Option)exceptionOpt.elem).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            throw x$16;
        });
    }

    private TierLogComponents tierEnabledLogComponents(boolean checksumEnabled) {
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierPartitionStateFactory tierPartitionStateFactory = new TierPartitionStateFactory(true, checksumEnabled, true, TierPartitionStateCleanupConfig.EMPTY);
        return new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), tierPartitionStateFactory, (Option)None$.MODULE$);
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        MergedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, time.scheduler(), (Time)time, 0L, 0L, 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17());
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(spyLogManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(spyLogManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)num -> num + 1, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        Mockito.when((Object)mockBrokerTopicStats.allTopicsStats()).thenReturn(Mockito.mock(BrokerTopicMetrics.class));
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = MergedLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> this.logConfig());
            long x$7 = 0L;
            long x$8 = 0L;
            MockScheduler x$9 = mockTime.scheduler();
            Metrics x$11 = new Metrics();
            int x$12 = 300000;
            int x$13 = 300000;
            int x$14 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            TierLogComponents x$16 = this.tierEnabledLogComponents(false);
            LogDirFailureChannel x$17 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            boolean x$18 = false;
            None$ x$19 = None$.MODULE$;
            boolean x$20 = false;
            LogOffsetsListener x$22 = MergedLog$.MODULE$.apply$default$17();
            Option x$23 = MergedLog$.MODULE$.apply$default$18();
            return MergedLog$.MODULE$.apply(dir, config, x$7, x$8, (Scheduler)x$9, mockBrokerTopicStats, x$11, (Time)mockTime, x$12, x$13, x$14, x$17, x$16, x$18, (Option)x$19, x$20, x$22, x$23, (ConcurrentMap)mockMap);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        TierLogComponents x$4 = this.createLogManager$default$4();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(tp, x$6, x$7, x$8).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        boolean x$12 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$11, x$12, (Option)x$10);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assertions.assertTrue((boolean)removedLog.localLogSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3(), this.createLogManager$default$4()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, x$6, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWaitForAllToComplete() {
        void waitForAllToComplete_callback;
        void waitForAllToComplete_jobs;
        void waitForAllToComplete_callback2;
        void waitForAllToComplete_jobs2;
        void waitForAllToComplete_callback3;
        void waitForAllToComplete_jobs3;
        void waitForAllToComplete_callback4;
        void waitForAllToComplete_jobs4;
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$17 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$17)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$18 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$19 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$19);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon2 = new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl = waitForAllToComplete_jobs4.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback4, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$20 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$20);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon3 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = waitForAllToComplete_jobs3.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback3, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$21 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$21);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon4 = new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl3 = waitForAllToComplete_jobs2.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback2, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$22 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$22);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon5 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl4 = waitForAllToComplete_jobs.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    @Test
    public void testLoadLogsMarkedForDeletion() {
        File deletedLogDir = new File(new StringBuilder(66).append(this.logDir().getAbsolutePath()).append("/lkc-abc12_deletedTopic-0.a23d92df7d364958bb6dbe17829434a2-delete/").toString());
        String topicName = "deletedTopic";
        this.logManager().loadLog(deletedLogDir, false, (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), this.logConfig(), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), new ConcurrentHashMap());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted());
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$4(topicName).size());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(int logDeletionMaxSegmentsPerRun) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), Integer.toString(logDeletionMaxSegmentsPerRun));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ boolean $anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(LogManagerTest $this, LogSegment x$3) {
        return x$3.log().file().setLastModified($this.time().milliseconds());
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(LogManagerTest $this, AbstractLog log1$1, AbstractLog log2$1, int _) {
        log1$1.appendAsLeader($this.createRecords$1(), 0, log1$1.appendAsLeader$default$3(), log1$1.appendAsLeader$default$4(), log1$1.appendAsLeader$default$5());
        return log2$1.appendAsLeader($this.createRecords$1(), 0, log2$1.appendAsLeader$default$3(), log2$1.appendAsLeader$default$4(), log2$1.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(AbstractLog log$2, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(log$2.tierPartitionState(), (TopicIdPartition)log$2.topicIdPartition().get(), 0, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(AbstractLog log) {
        log.tierableLogSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(log, segment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$5) {
        return x$5.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(AbstractLog log$6, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$6.appendAsLeader(set, 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4(), log$6.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$10) {
        return x$10.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$11) {
        String string = x$11.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$11)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDeleteAndTierStateFlushConcurrency$3(Option x$15) {
        ((AbstractLog)x$15.get()).close();
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String spyLogManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingLogsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String spyLogManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$2);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingSegmentsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$3);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$3) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$3, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$3);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$17) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$19) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$20) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$21) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$22) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testLoadLogsMarkedForDeletion$1(String topicName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$3);
    }

    private static final scala.collection.mutable.Set logMetrics$4(String topicName$3) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLoadLogsMarkedForDeletion$1(topicName$3, metric)));
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

