/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.InterceptorStats;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.InterceptorUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001\u00020`\u0001\u0011DQa\u001b\u0001\u0005\u00021Dqa\u001c\u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001d\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0001\u0002\"!A\u0011\u0011\u0006\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002.!A\u0011q\u000b\u0001!\u0002\u0013\ty\u0003C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\\!9\u0011Q\u0010\u0001\u0005\u0002\u0005m\u0003bBAA\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002B\u0002!I!a1\t\u000f\u0005E\b\u0001\"\u0001\u0002\\!9\u0011Q\u001f\u0001\u0005\u0002\u0005m\u0003bBA}\u0001\u0011%\u00111 \u0005\b\u0003\u007f\u0004A\u0011AA.\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqAa\u0003\u0001\t\u0003\tY\u0006C\u0004\u0003\u0010\u0001!\t!a\u0017\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!\u0011\u0004\u0001\u0005\u0002\u0005m\u0003b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011\u001d\u00119\u0004\u0001C\u0001\u00037BqAa\u000f\u0001\t\u0003\tY\u0006C\u0004\u0003@\u0001!IA!\u0011\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002\\!9!\u0011\n\u0001\u0005\u0002\u0005m\u0003b\u0002B'\u0001\u0011%!q\n\u0005\b\u0005'\u0002A\u0011AA.\u0011\u001d\u00119\u0006\u0001C\u0001\u00037BqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0004\u0003d\u0001!\t!a\u0017\t\u000f\t\u001d\u0004\u0001\"\u0001\u0002\\!9!1\u000e\u0001\u0005\u0002\u0005m\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005k\u0002A\u0011AA.\u0011\u001d\u0011I\b\u0001C\u0001\u00037BqA! \u0001\t\u0003\tY\u0006C\u0004\u0003\u0002\u0002!\t!a\u0017\t\u000f\t\u0015\u0005\u0001\"\u0001\u0002\\!9!\u0011\u0012\u0001\u0005\u0002\u0005m\u0003b\u0002BG\u0001\u0011\u0005\u00111\f\u0005\b\u0005#\u0003A\u0011AA.\u0011\u001d\u0011)\n\u0001C\u0001\u00037BqA!'\u0001\t\u0003\tY\u0006C\u0004\u0003\u001e\u0002!\t!a\u0017\t\u000f\t\u0005\u0006\u0001\"\u0001\u0002\\!9!Q\u0015\u0001\u0005\u0002\u0005m\u0003b\u0002BU\u0001\u0011\u0005\u00111\f\u0005\b\u0005[\u0003A\u0011AA.\u0011\u001d\u0011\t\f\u0001C\u0001\u00037BqA!.\u0001\t\u0003\tY\u0006C\u0004\u0003:\u0002!\t!a\u0017\t\u000f\tu\u0006\u0001\"\u0001\u0002\\!9!\u0011\u0019\u0001\u0005\u0002\u0005m\u0003b\u0002Bc\u0001\u0011\u0005\u00111\f\u0005\b\u0005\u0013\u0004A\u0011AA.\u0011\u001d\u0011i\r\u0001C\u0001\u00037BqA!5\u0001\t\u0003\tY\u0006C\u0004\u0003V\u0002!\t!a\u0017\t\u000f\te\u0007\u0001\"\u0001\u0002\\!9!Q\u001c\u0001\u0005\u0002\u0005m\u0003b\u0002Bq\u0001\u0011\u0005\u00111\f\u0005\b\u0005K\u0004A\u0011AA.\u0011\u001d\u0011I\u000f\u0001C\u0001\u00037BqA!<\u0001\t\u0003\tY\u0006C\u0004\u0003r\u0002!\t!a\u0017\t\u000f\tU\b\u0001\"\u0001\u0002\\!9!\u0011 \u0001\u0005\u0002\u0005m\u0003b\u0002B\u007f\u0001\u0011\u0005\u00111\f\u0005\b\u0007\u0003\u0001A\u0011AA.\u0011\u001d\u0019)\u0001\u0001C\u0001\u00037Bqa!\u0003\u0001\t\u0013\u0019Y\u0001C\u0004\u0004\"\u0001!Iaa\t\t\u0013\r]\u0002!%A\u0005\n\re\u0002bBB(\u0001\u0011%1\u0011\u000b\u0005\n\u00073\u0002\u0011\u0013!C\u0005\u0007sA\u0011ba\u0017\u0001#\u0003%Ia!\u0018\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!911\u000e\u0001\u0005\u0002\r5\u0004bBB;\u0001\u0011%1q\u000f\u0005\b\u0007\u0003\u0003A\u0011BBB\u0011\u001d\u0019y\t\u0001C\u0001\u0007#Cqa!)\u0001\t\u0003\u0019\u0019\u000bC\u0004\u00040\u0002!\ta!-\u0003!1{wMV1mS\u0012\fGo\u001c:UKN$(B\u00011b\u0003\rawn\u001a\u0006\u0002E\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001f!\t1\u0017.D\u0001h\u0015\u0005A\u0017!B:dC2\f\u0017B\u00016h\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u001c\t\u0003]\u0002i\u0011aX\u0001\u0005i&lW-F\u0001r!\t\u0011H0D\u0001t\u0015\t!X/A\u0003vi&d7O\u0003\u0002wo\u000611m\\7n_:T!A\u0019=\u000b\u0005eT\u0018AB1qC\u000eDWMC\u0001|\u0003\ry'oZ\u0005\u0003{N\u0014A\u0001V5nK\u0006)A/[7fA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0002!\u0011\t)!a\u0002\u000e\u0003UL1!!\u0003v\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006b\u0003\u0019\u0019XM\u001d<fe&!\u00111DA\u000b\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002\n\u0001#\u001b8uKJ\u001cW\r\u001d;peN#\u0018\r^:\u0016\u0005\u0005\r\u0002c\u00018\u0002&%\u0019\u0011qE0\u0003!%sG/\u001a:dKB$xN]*uCR\u001c\u0018!E5oi\u0016\u00148-\u001a9u_J\u001cF/\u0019;tA\u0005iQ.\u001a;sS\u000e\u001c8*Z=TKR,\"!a\f\u0011\r\u0005E\u00121HA \u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s9\u0017AC2pY2,7\r^5p]&!\u0011QHA\u001a\u0005\r\u0019V\r\u001e\t\u0005\u0003\u0003\n\u0019&\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0011\u0019wN]3\u000b\t\u0005%\u00131J\u0001\b[\u0016$(/[2t\u0015\u0011\ti%a\u0014\u0002\re\fW.\\3s\u0015\t\t\t&A\u0002d_6LA!!\u0016\u0002D\tQQ*\u001a;sS\u000et\u0015-\\3\u0002\u001d5,GO]5dg.+\u0017pU3uA\u0005\u0001B/Z:u\u001f:d\u0017p\u00148f\u0005\u0006$8\r\u001b\u000b\u0003\u0003;\u00022AZA0\u0013\r\t\tg\u001a\u0002\u0005+:LG\u000fK\u0002\r\u0003K\u0002B!a\u001a\u0002v5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0002ba&TA!a\u001c\u0002r\u00059!.\u001e9ji\u0016\u0014(bAA:u\u0006)!.\u001e8ji&!\u0011qOA5\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f^!mY><X*\u001e7uS\n\u000bGo\u00195)\u00075\t)'\u0001\u001buKN$h+\u00197jI\u0006$\u0018n\u001c8PM\n\u000bGo\u00195fg^KG\u000f\u001b(p]N+\u0017/^3oi&\fG.\u00138oKJ|eMZ:fiND3ADA3\u0003E!Xm\u001d;NSNl\u0015\r^2i\u001b\u0006<\u0017n\u0019\u0015\u0004\u001f\u0005\u0015\u0014!E2iK\u000e\\wJ\u001c7z\u001f:,')\u0019;dQRA\u0011QLAE\u0003'\u000b\u0019\u000bC\u0004\u0002\fB\u0001\r!!$\u0002\u000b5\fw-[2\u0011\u0007\u0019\fy)C\u0002\u0002\u0012\u001e\u0014AAQ=uK\"9\u0011Q\u0013\tA\u0002\u0005]\u0015!F:pkJ\u001cWmQ8naJ,7o]5p]RK\b/\u001a\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011QT;\u0002\rI,7m\u001c:e\u0013\u0011\t\t+a'\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016Dq!!*\u0011\u0001\u0004\t9*A\u000buCJ<W\r^\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002)\rDWmY6BY2|w/T;mi&\u0014\u0015\r^2i)!\ti&a+\u0002.\u0006=\u0006bBAF#\u0001\u0007\u0011Q\u0012\u0005\b\u0003+\u000b\u0002\u0019AAL\u0011\u001d\t)+\u0005a\u0001\u0003/\u000b!c\u00195fG.l\u0015n]7bi\u000eDW*Y4jGRA\u0011QLA[\u0003s\u000bi\fC\u0004\u00028J\u0001\r!!$\u0002\u0015\t\fGo\u00195NC\u001eL7\rC\u0004\u0002<J\u0001\r!!$\u0002\u0017I,7m\u001c:e\u001b\u0006<\u0017n\u0019\u0005\b\u0003\u007f\u0013\u0002\u0019AAL\u0003=\u0019w.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017\u0001\u0005<bY&$\u0017\r^3NKN\u001c\u0018mZ3t))\t)-!9\u0002l\u00065\u0018q\u001e\t\u0005\u0003\u000f\fYN\u0004\u0003\u0002J\u0006]g\u0002BAf\u0003+tA!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#\u001c\u0017A\u0002\u001fs_>$h(C\u0001c\u0013\t\u0001\u0017-C\u0002\u0002Z~\u000bA\u0002T8h-\u0006d\u0017\u000eZ1u_JLA!!8\u0002`\nyb+\u00197jI\u0006$\u0018n\u001c8B]\u0012|eMZ:fi\u0006\u001b8/[4o%\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005ew\fC\u0004\u0002dN\u0001\r!!:\u0002\u000fI,7m\u001c:egB!\u0011\u0011TAt\u0013\u0011\tI/a'\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\tYi\u0005a\u0001\u0003\u001bCq!!&\u0014\u0001\u0004\t9\nC\u0004\u0002&N\u0001\r!a&\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004)\u0005\u0015\u0014\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-JB3!FA3\u0003}\u0019\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003;\ni\u0010C\u0004\u0002\fZ\u0001\r!!$\u0002IQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWmV5uQJ+7m\\7qe\u0016\u001c8/[8o-FB3aFA3\u0003\r\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:$B!!\u0018\u0003\b!9!\u0011\u0002\rA\u0002\u00055\u0015a\u0003;be\u001e,G/T1hS\u000e\fA\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tgK\r\u0015\u00043\u0005\u0015\u0014a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-FB3AGA3\u0003\u0019\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRDw.\u001e;SK\u000e|W\u000e\u001d:fgNLwN\u001c\u000b\u0005\u0003;\u00129\u0002C\u0004\u0002\fn\u0001\r!!$\u0002IQ,7\u000f^%om\u0006d\u0017\u000eZ(gMN,GOU1oO\u0016\fe\u000e\u001a*fG>\u0014HmQ8v]RD3\u0001HA3\u0003\u0001\n7o]3si&sg/\u00197jI\n\u000bGo\u00195D_VtGo\u0014<feJLG-Z:\u0015\r\u0005u#\u0011\u0005B\u0016\u0011\u001d\u0011\u0019#\ba\u0001\u0005K\tq\u0002\\1ti>3gm]3u\t\u0016dG/\u0019\t\u0004M\n\u001d\u0012b\u0001B\u0015O\n\u0019\u0011J\u001c;\t\u000f\t5R\u00041\u0001\u0003&\u0005)1m\\;oi\u0006)c/\u00197jI\u0006$XMU3d_J$')\u0019;dQ^KG\u000f[\"pk:$xJ^3se&$Wm\u001d\u000b\u0007\u0003;\u0012\u0019D!\u000e\t\u000f\t\rb\u00041\u0001\u0003&!9!Q\u0006\u0010A\u0002\t\u0015\u0012a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-JB3aHA3\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\r\u0001\u0013QM\u0001\u0013G\",7m\u001b(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002^\t\r\u0003bBAFC\u0001\u0007\u0011QR\u0001\u0014i\u0016\u001cHOT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004E\u0005\u0015\u0014a\u0005;fgR\u0014VmY8naJ,7o]5p]Z\u000b\u0004fA\u0012\u0002f\u0005\u00112\r[3dWJ+7m\\7qe\u0016\u001c8/[8o)\u0011\tiF!\u0015\t\u000f\u0005-E\u00051\u0001\u0002\u000e\u0006\u0019B/Z:u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001aQ%!\u001a\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{g+\r\u0015\u0004M\u0005\u0015\u0014!I2iK\u000e\\7I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0012:p[Z\u0003D\u0003BA/\u0005?BqA!\u0019(\u0001\u0004\ti)A\u0004u_6\u000bw-[2\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gK\r\u0015\u0004Q\u0005\u0015\u0014\u0001\t;fgR\u001c%/Z1uKRKW.Z+q\u0007>tg/\u001a:tS>tg+\r+p-JB3!KA3\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002+\u0003K\nqb\u00195fG.\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003;\u0012\u0019\bC\u0004\u0002\f.\u0002\r!!$\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0001\u0017\u0002f\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002.\u0003K\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004]\u0005\u0015\u0014!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0018\u0002f\u0005\tC/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,7i\\7qe\u0016\u001c8/\u001a3We!\u001a\u0001'!\u001a\u0002SQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi:{gnQ8naJ,7o]3eQ\r\t\u0014QM\u0001'i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001a\u0002f\u0005YC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u00024\u0003K\n1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004i\u0005\u0015\u0014\u0001\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e^\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u001b\u0002f\u0005AC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3We!\u001aa'!\u001a\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-FruN\\\"p[B\u0014Xm]:fI\"\u001aq'!\u001a\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001a\u0001(!\u001a\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-F\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004s\u0005\u0015\u0014!\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-B\"vN\u0016\u001aD_6\u0004(/Z:tK\u0012D3AOA3\u0003\u001d\"Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u00124%o\\7DY&,g\u000e^:)\u0007m\n)'A\u0010uKN$8i\u001c8ue>d'+Z2pe\u0012\u001chj\u001c;D_6\u0004(/Z:tK\u0012D3\u0001PA3\u0003i\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WcQ{g\u000b\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002>\u0003K\nq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u000bDk\u001c,1\u0007>l\u0007O]3tg\u0016$\u0007f\u0001 \u0002f\u0005AD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,2)>4&GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA \u0002f\u0005)D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,2)>4&gQ8naJ,7o]3eQ\r\u0001\u0015QM\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3!QA3\u0003]\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g+M\"p[B\u0014Xm]:fI\"\u001a!)!\u001a\u0002iQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\\(g)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\rK\u0002D\u0003K\n\u0011\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3\u0017\nZ3na>$XM\u001c;SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\rK\u0002E\u0003K\n!\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,1\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\u0015\u000b)'A\u001cuKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tgK\r+p-B\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004\r\u0006\u0015\u0014A\r;fgRtuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eS1t\u001b\u0016$(/[2t\u0019><w-\u001a3)\u0007\u001d\u000b)'A\u0016uKN$8i\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\rA\u0015QM\u0001,i\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GmV5uQVs\u0017M^1jY\u0006\u0014G.Z%C!Z+'o]5p]\"\u001a\u0011*!\u001a\u0002[Q,7\u000f^+oG>l\u0007O]3tg\u0016$')\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rK\u0002K\u0003K\nQ\u0006^3tiJ+7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\rY\u0015QM\u0001+i\u0016\u001cH/\u00138wC2LG\rV5nKN$\u0018-\u001c9Fq\u000e,\u0007\u000f^5p]\"\u000b7OQ1uG\"Le\u000eZ3yQ\ra\u0015QM\u0001(i\u0016\u001cH/\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c%bg\n\u000bGo\u00195J]\u0012,\u0007\u0010K\u0002N\u0003K\na\u0006^3ti\n\u000bGo\u00195XSRD\u0017J\u001c<bY&$'+Z2pe\u0012\u001c\u0018I\u001c3J]Z\fG.\u001b3US6,7\u000f^1na\"\u001aa*!\u001a\u0002sQ,7\u000f\u001e\"bi\u000eDw+\u001b;i\u0013:4\u0018\r\\5e)&lWm\u001d;b[BLe\u000e^3sG\u0016\u0004H/\u001a3B]\u0012LeN^1mS\u0012\u0014VmY8sIND3aTA3\u0003%\"Xm\u001d;CCR\u001c\u0007nV5uQ&sG/\u001a:dKB$X\rZ!oI&sg/\u00197jIJ+7m\u001c:eg\"\u001a\u0001+!\u001a\u0002CQ,7\u000f\u001e\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3\u0015\r\u0005u3QBB\u000f\u0011\u001d\u0019y!\u0015a\u0001\u0007#\t1b]8ve\u000e,7i\u001c3fGB!11CB\r\u001b\t\u0019)BC\u0002\u0004\u0018\u0005\fq!\\3tg\u0006<W-\u0003\u0003\u0004\u001c\rU!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u001d\u0019y\"\u0015a\u0001\u0007#\t1\u0002^1sO\u0016$8i\u001c3fG\u0006i1M]3bi\u0016\u0014VmY8sIN$\u0002\"!:\u0004&\r%21\u0007\u0005\b\u0007O\u0011\u0006\u0019AAG\u0003)i\u0017mZ5d-\u0006dW/\u001a\u0005\n\u0007W\u0011\u0006\u0013!a\u0001\u0007[\t\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u0019\u001cy#C\u0002\u00042\u001d\u0014A\u0001T8oO\"91Q\u0007*A\u0002\u0005]\u0015!B2pI\u0016\u001c\u0017aF2sK\u0006$XMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YD\u000b\u0003\u0004.\ru2FAB !\u0011\u0019\tea\u0013\u000e\u0005\r\r#\u0002BB#\u0007\u000f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r%s-\u0001\u0006b]:|G/\u0019;j_:LAa!\u0014\u0004D\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002A\r\u0014X-\u0019;f\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u000b\t\u0003K\u001c\u0019f!\u0016\u0004X!91q\u0005+A\u0002\u00055\u0005\"CB\u0016)B\u0005\t\u0019AB\u0017\u0011%\u0019)\u0004\u0016I\u0001\u0002\u0004\t9*\u0001\u0016de\u0016\fG/\u001a(p]&s7M]3bg&twm\u00144gg\u0016$(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002U\r\u0014X-\u0019;f\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\f\u0016\u0005\u0003/\u001bi$A\fde\u0016\fG/\u001a+x_\n\u000bGo\u00195fIJ+7m\u001c:egRA\u0011Q]B3\u0007O\u001aI\u0007C\u0004\u0004(]\u0003\r!!$\t\u000f\r-r\u000b1\u0001\u0004.!91QG,A\u0002\u0005]\u0015\u0001D2iK\u000e\\wJ\u001a4tKR\u001cHCBA/\u0007_\u001a\t\bC\u0004\u0002db\u0003\r!!:\t\u000f\rM\u0004\f1\u0001\u0004.\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0002II,7m\u001c:eg^KG\u000f\u001b(p]N+\u0017/^3oi&\fG.\u00138oKJ|eMZ:fiN$\u0002\"!:\u0004z\rm4Q\u0010\u0005\b\u0007OI\u0006\u0019AAG\u0011\u001d\u0019)$\u0017a\u0001\u0003/Cqaa Z\u0001\u0004\u0011)#\u0001\u0006ok6\u0014VmY8sIN\fAD]3d_J$7oV5uQ&sg/\u00197jI&sg.\u001a:NC\u001eL7\r\u0006\u0005\u0002f\u000e\u00155\u0011RBG\u0011\u001d\u00199I\u0017a\u0001\u0003\u001b\u000bqBY1uG\"l\u0015mZ5d-\u0006dW/\u001a\u0005\b\u0007\u0017S\u0006\u0019AAG\u0003A\u0011XmY8sI6\u000bw-[2WC2,X\rC\u0004\u00046i\u0003\r!a&\u0002/5\f\u0017PY3DQ\u0016\u001c7NQ1tKRKW.Z:uC6\u0004HCBA/\u0007'\u001b9\nC\u0004\u0004\u0016n\u0003\ra!\f\u0002\u0011\u0015D\b/Z2uK\u0012Dqa!'\\\u0001\u0004\u0019Y*A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\u001a\u000eu\u0015\u0002BBP\u00037\u00131BU3d_J$')\u0019;dQ\u0006)b/\u00197jI\u0006$X\rT8h\u0003B\u0004XM\u001c3US6,G\u0003CA/\u0007K\u001bIk!,\t\u000f\r\u001dF\f1\u0001\u0004.\u0005)R\r\u001f9fGR,G\rT8h\u0003B\u0004XM\u001c3US6,\u0007bBBV9\u0002\u00071QF\u0001\u0016Kb\u0004Xm\u0019;fI\n\u000b7/\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\u0019I\n\u0018a\u0001\u00077\u000b1D^3sS\u001aL(+Z2pe\u0012\u001cuN\u001c<feNLwN\\*uCR\u001cHCCA/\u0007g\u001bil!1\u0004D\"91QW/A\u0002\r]\u0016!B:uCR\u001c\b\u0003BAM\u0007sKAaa/\u0002\u001c\n)\"+Z2pe\u0012\u001cuN\u001c<feNLwN\\*uCR\u001c\bbBB`;\u0002\u0007!QE\u0001\u0014]Vl7i\u001c8wKJ$X\r\u001a*fG>\u0014Hm\u001d\u0005\b\u0003Gl\u0006\u0019AAs\u0011\u001d\u0019)-\u0018a\u0001\u0007\u000f\f!bY8naJ,7o]3e!\r17\u0011Z\u0005\u0004\u0007\u0017<'a\u0002\"p_2,\u0017M\u001c")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final InterceptorStats interceptorStats = new InterceptorStats();
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public InterceptorStats interceptorStats() {
        return this.interceptorStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values())).foreach((Function1 & Serializable & scala.Serializable)version -> {
            this.testMessageValidation$1(version.value);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationAndOffsetAssignResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)new .colon.colon((Object)new InterceptorUtils.MockRecordInterceptor(), (List)Nil$.MODULE$), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.IBP_2_3_IV1, this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        int expectedMaxTimestampOffset = magic >= 2 ? 2 : 0;
        Assertions.assertEquals((long)expectedMaxTimestampOffset, (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(expectedMaxTimestampOffset).toString());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size may have been changed");
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), n3, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, bl2, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp(), (String)"Offset of max timestamp should be 1");
        Assertions.assertFalse((boolean)validatingResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), n3, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp(), (String)"Offset of max timestamp should be 2");
        Assertions.assertTrue((boolean)validatingResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        Buffer x$15 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$16 = this.interceptorStats();
        int x$17 = -1;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = MetadataVersion.latest();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        RequestLocal x$21 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, toMagic, x$13, x$14, (Iterable)x$15, x$16, x$17, (AppendOrigin)x$18, x$19, x$20, x$21);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)validatedResults.maxTimestamp(), (long)-1L, (String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        MemoryRecords records = this.createRecords(x$1, timestamp, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        byte x$11 = 2;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        Buffer x$15 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$16 = this.interceptorStats();
        int x$17 = -1;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = MetadataVersion.latest();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        RequestLocal x$21 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, (Iterable)x$15, x$16, x$17, (AppendOrigin)x$18, x$19, x$20, x$21);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        Buffer x$12 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$13 = this.interceptorStats();
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$16 = MetadataVersion.latest();
        BrokerTopicStats x$17 = this.brokerTopicStats();
        RequestLocal x$18 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, magic, x$10, x$11, (Iterable)x$12, x$13, n3, (AppendOrigin)x$15, x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            Buffer x$12 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
            InterceptorStats x$13 = this.interceptorStats();
            int x$14 = -1;
            AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
            MetadataVersion x$16 = MetadataVersion.latest();
            BrokerTopicStats x$17 = this.brokerTopicStats();
            RequestLocal x$18 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, (Iterable)x$12, x$13, x$14, (AppendOrigin)x$15, x$16, x$17, x$18);
        });
    }

    @Test
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            Buffer x$12 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
            InterceptorStats x$13 = this.interceptorStats();
            int x$14 = -1;
            AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
            MetadataVersion x$16 = MetadataVersion.latest();
            BrokerTopicStats x$17 = this.brokerTopicStats();
            RequestLocal x$18 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, (Iterable)x$12, x$13, x$14, (AppendOrigin)x$15, x$16, x$17, x$18);
        });
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        byte x$11 = 0;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        Buffer x$15 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$16 = this.interceptorStats();
        int x$17 = -1;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = MetadataVersion.latest();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        RequestLocal x$21 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, (Iterable)x$15, x$16, x$17, (AppendOrigin)x$18, x$19, x$20, x$21).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        java.util.List batches = TestUtils.toList((java.lang.Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords().batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        Assertions.assertThrows(UnsupportedCompressionTypeException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.IBP_2_0_IV1, this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    @Test
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            Buffer x$12 = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
            InterceptorStats x$13 = this.interceptorStats();
            int x$14 = -1;
            AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
            MetadataVersion x$16 = MetadataVersion.latest();
            BrokerTopicStats x$17 = this.brokerTopicStats();
            RequestLocal x$18 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, (Iterable)x$12, x$13, x$14, (AppendOrigin)x$15, x$16, x$17, x$18);
        });
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)20);
        e.recordErrors().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
    }

    @Test
    public void testBatchWithInvalidTimestampInterceptedAndInvalidRecords() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidTimestampInterceptedAndInvalidRecords$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        ++offset.elem;
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)0L, null, (byte[])"reject me".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidTimestampInterceptedAndInvalidRecords$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)7, (int)e.recordErrors().size());
        Assertions.assertTrue((boolean)((ProduceResponse.RecordError)e.recordErrors().apply((int)1)).message.endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
    }

    @Test
    public void testBatchWithInterceptedAndInvalidRecords() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInterceptedAndInvalidRecords$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)0L, null, (byte[])"reject me".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInterceptedAndInvalidRecords$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertTrue((boolean)e.invalidException().getMessage().startsWith("One or more records have been rejected due to 6 record errors in total"));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
        Assertions.assertTrue((boolean)((ProduceResponse.RecordError)e.recordErrors().head()).message.endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        void var4_8;
        int offset = 1234567;
        int n = 40;
        boolean bl = true;
        int n2 = 984;
        short s = (short)10;
        long producerId = 1324L;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)var4_8, (short)s, (int)n2, (long)0L, (long)5L, (int)n, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), this.brokerTopicStats(), RequestLocal$.MODULE$.withThreadConfinedCaching()));
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assertions.assertTrue((boolean)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty(), (String)"Message set should not be empty");
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType codec, int numRecords) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assertions.assertEquals((long)expected, (long)defaultRecordBatch.baseTimestamp(), (String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assertions.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((long)expectedLogAppendTime, (long)batch.maxTimestamp(), (String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assertions.assertNotNull((Object)stats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numConvertedRecords, (int)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assertions.assertTrue((stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString());
            Assertions.assertTrue((stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0, (String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString());
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assertions.assertTrue((tempBytes > (long)originalSize ? 1 : 0) != 0, (String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString());
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assertions.assertTrue((tempBytes > 0L ? 1 : 0) != 0, (String)"Temp bytes not updated");
            return;
        }
        Assertions.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP));
            return;
        }
        LogValidator.ValidationAndOffsetAssignResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords), (Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(result.validatedRecords().records()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()), Iterable$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$1, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$1, (int)batch.baseSequence());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assertions.assertEquals((int)partitionLeaderEpoch$1, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$2, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$2, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$2, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$2, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assertions.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assertions.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$3, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$3, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$3, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$3, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assertions.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$4, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$4.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$4.elem, record);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidTimestampInterceptedAndInvalidRecords$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidTimestampInterceptedAndInvalidRecords$2(IntRef offset$5, MemoryRecordsBuilder builder$2, LegacyRecord record) {
        offset$5.elem += 30;
        builder$2.appendUncheckedWithOffset((long)offset$5.elem, record);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInterceptedAndInvalidRecords$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInterceptedAndInvalidRecords$2(IntRef offset$6, MemoryRecordsBuilder builder$3, LegacyRecord record) {
        offset$6.elem += 30;
        builder$3.appendUncheckedWithOffset((long)offset$6.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$8, Record entry) {
        Assertions.assertEquals((long)offset$8.elem, (long)entry.offset(), (String)"Unexpected offset in message set iterator");
        ++offset$8.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        return LegacyRecord.create((byte)recordMagicValue$1, (long)-1L, (byte[])Integer.toString(id).getBytes(), (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$5, IntRef offset$9, LegacyRecord record) {
        builder$5.appendUncheckedWithOffset((long)offset$9.elem, record);
        ++offset$9.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)expectedLogAppendTime$1, (long)record.timestamp(), (String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString());
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

