/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.Cleaner;
import kafka.log.FaultInjectedTierObjectStoreWrapper;
import kafka.log.HarnessParams;
import kafka.log.LogCleanerManager$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.MergedLogStateSnapshot;
import kafka.log.OffsetsToClean;
import kafka.log.RecordState;
import kafka.log.RecordState$;
import kafka.log.SegmentFields;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.server.TierFetchDataInfo;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.mockito.Mockito;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r-r!\u0002$H\u0011\u0003ae!\u0002(H\u0011\u0003y\u0005\"\u0002/\u0002\t\u0003i\u0006b\u00020\u0002\u0005\u0004%\ta\u0018\u0005\u0007G\u0006\u0001\u000b\u0011\u00021\t\u000f\u0011\f!\u0019!C\u0001?\"1Q-\u0001Q\u0001\n\u0001DqAZ\u0001C\u0002\u0013\u0005q\f\u0003\u0004h\u0003\u0001\u0006I\u0001\u0019\u0005\u0006Q\u0006!\t!\u001b\u0005\b\u0003C\nA\u0011AA2\u0011\u001d\u0019\u0019\"\u0001C\u0001\u0007+1QAT$\u0001\u0003OB\u0011\u0002\u0013\u0007\u0003\u0002\u0004%\t!!\u001b\t\u0015\u0005-DB!a\u0001\n\u0003\ti\u0007\u0003\u0006\u0002z1\u0011\t\u0011)Q\u0005\u0003\u0007B\u0011\"a\u001f\r\u0005\u0003\u0007I\u0011A0\t\u0015\u0005uDB!a\u0001\n\u0003\ty\bC\u0005\u0002\u00042\u0011\t\u0011)Q\u0005A\"Q\u0011Q\u000b\u0007\u0003\u0006\u0004%\t!!\"\t\u0015\u0005\u001dEB!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002L1\u0011)\u0019!C\u0001\u0003\u0013C!\"a#\r\u0005\u0003\u0005\u000b\u0011BA'\u0011)\ti\t\u0004BA\u0002\u0013\u0005\u0011q\u0012\u0005\u000b\u0003#c!\u00111A\u0005\u0002\u0005M\u0005BCAL\u0019\t\u0005\t\u0015)\u0003\u0002<!Q\u0011\u0011\u0014\u0007\u0003\u0002\u0004%\t!a'\t\u0015\u0005\rFB!a\u0001\n\u0003\t)\u000b\u0003\u0006\u0002*2\u0011\t\u0011)Q\u0005\u0003;C!\"a+\r\u0005\u0003\u0007I\u0011AAW\u0011)\ty\u000b\u0004BA\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003kc!\u0011!Q!\n5D!\"a.\r\u0005\u0003\u0007I\u0011AA]\u0011)\tY\f\u0004BA\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0003d!\u0011!Q!\nUD!\"a1\r\u0005\u0003\u0007I\u0011AAc\u0011)\t9\r\u0004BA\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003\u001bd!\u0011!Q!\nmD!\"a4\r\u0005\u0003\u0007I\u0011AAi\u0011)\t\u0019\u000e\u0004BA\u0002\u0013\u0005\u0011Q\u001b\u0005\u000b\u00033d!\u0011!Q!\n\u0005\r\u0001BCAn\u0019\t\u0015\r\u0011\"\u0001\u0002^\"Q\u0011Q\u001d\u0007\u0003\u0002\u0003\u0006I!a8\t\u0015\u0005\u001dHB!a\u0001\n\u0003\tI\u000f\u0003\u0006\u0002l2\u0011\t\u0019!C\u0001\u0003[D!\"!=\r\u0005\u0003\u0005\u000b\u0015BA\b\u0011)\t\u0019\u0010\u0004BA\u0002\u0013\u0005\u0011Q\u001f\u0005\u000b\u0003od!\u00111A\u0005\u0002\u0005e\bBCA\u007f\u0019\t\u0005\t\u0015)\u0003\u00020!1A\f\u0004C\u0001\u0003\u007fD\u0011Ba\u0007\r\u0005\u0004%\tA!\b\t\u0011\t]B\u0002)A\u0005\u0005?AqA!\u000f\r\t\u0003\u0011Y\u0004C\u0004\u0003>1!\tAa\u000f\t\u000f\t}B\u0002\"\u0001\u0003B!9!q\t\u0007\u0005\u0002\t%\u0003b\u0002B$\u0019\u0011\u0005!\u0011\u000e\u0005\b\u0005kbA\u0011\u0001B<\u0011\u001d\u0011I\u000b\u0004C\u0001\u0005WCqA!-\r\t\u0003\u0011\u0019\fC\u0004\u0003<2!IA!0\t\u000f\t}F\u0002\"\u0001\u0003B\"9!1\u0019\u0007\u0005\u0002\t\u0015\u0007b\u0002Bd\u0019\u0011\u0005!\u0011\u001a\u0005\n\u0005#d\u0011\u0013!C\u0001\u0005'DqAa2\r\t\u0003\u0011I\u000fC\u0004\u0003v2!IA!0\t\u000f\t]H\u0002\"\u0003\u0003z\"9!Q \u0007\u0005\u0002\tm\u0002b\u0002B\u0000\u0019\u0011%!1H\u0001\u0011\u001b\u0016\u0014x-\u001a3M_\u001eD\u0015M\u001d8fgNT!\u0001S%\u0002\u00071|wMC\u0001K\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!T\u0001\u000e\u0003\u001d\u0013\u0001#T3sO\u0016$Gj\\4ICJtWm]:\u0014\u0007\u0005\u0001f\u000b\u0005\u0002R)6\t!KC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)&K\u0001\u0004B]f\u0014VM\u001a\t\u0003/jk\u0011\u0001\u0017\u0006\u00033&\u000bQ!\u001e;jYNL!a\u0017-\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001T\u0001\u0018\u001b\u0006DHK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012\u0001\u0019\t\u0003#\u0006L!A\u0019*\u0003\u0007%sG/\u0001\rNCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\n\u0011$T1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006QR*\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005A!I]8lKJLE-A\u0005Ce>\\WM]%eA\u0005!\u0012N\\5uS\u0006d\u0017N_3D_6\u0004xN\\3oiN$\u0012B[A!\u0003\u0013\n\u0019&!\u0018\u0011\u001bE[W.^>\u0002\u0004\u0005=\u0011qFA\u001e\u0013\ta'K\u0001\u0004UkBdWm\u000e\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fQ\u0001^1tWNT!A]%\u0002\tQLWM]\u0005\u0003i>\u0014q\u0002V5feR\u000b7o[:D_:4\u0017n\u001a\t\u0003mfl\u0011a\u001e\u0006\u0003q>\fq!\u0019:dQ&4X-\u0003\u0002{o\nY\u0011I]2iSZ,G+Y:l!\tax0D\u0001~\u0015\tqx.\u0001\u0006d_6\u0004\u0018m\u0019;j_:L1!!\u0001~\u00059\u0019u.\u001c9bGRLwN\u001c+bg.\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\t\u0018!\u0002;pa&\u001c\u0017\u0002BA\u0007\u0003\u000f\u0011\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s!\u0019\t\t\"a\b\u0002$5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0007\u0002\u001c\u0005!Q\u000f^5m\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003'\u0011AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\b\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\u0012/\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003[\t9C\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/\u0019\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG%\u0002\rM,'O^3s\u0013\u0011\tI$a\r\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4feB\u0019Q*!\u0010\n\u0007\u0005}rIA\u0004DY\u0016\fg.\u001a:\t\r!K\u0001\u0019AA\"!\ri\u0015QI\u0005\u0004\u0003\u000f:%!C'fe\u001e,G\rT8h\u0011\u001d\tY%\u0003a\u0001\u0003\u001b\n\u0011\u0002\u001e5s_R$H.\u001a:\u0011\u0007]\u000by%C\u0002\u0002Ra\u0013\u0011\u0002\u00165s_R$H.\u001a:\t\u000f\u0005U\u0013\u00021\u0001\u0002X\u00051\u0001/\u0019:b[N\u00042!TA-\u0013\r\tYf\u0012\u0002\u000e\u0011\u0006\u0014h.Z:t!\u0006\u0014\u0018-\\:\t\r\u0005}\u0013\u00021\u0001a\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005\u00154\u0011AB\u0007\u0007#\u0001\"!\u0014\u0007\u0014\u00071\u0001f+\u0006\u0002\u0002D\u00059An\\4`I\u0015\fH\u0003BA8\u0003k\u00022!UA9\u0013\r\t\u0019H\u0015\u0002\u0005+:LG\u000fC\u0005\u0002x9\t\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\u0002\t1|w\rI\u0001\u0006KB|7\r[\u0001\nKB|7\r[0%KF$B!a\u001c\u0002\u0002\"A\u0011qO\t\u0002\u0002\u0003\u0007\u0001-\u0001\u0004fa>\u001c\u0007\u000eI\u000b\u0003\u0003/\nq\u0001]1sC6\u001c\b%\u0006\u0002\u0002N\u0005QA\u000f\u001b:piRdWM\u001d\u0011\u0002\u000f\rdW-\u00198feV\u0011\u00111H\u0001\fG2,\u0017M\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005U\u0005\"CA<1\u0005\u0005\t\u0019AA\u001e\u0003!\u0019G.Z1oKJ\u0004\u0013!D3wKJ\u001cu.\u001c9bGR,G-\u0006\u0002\u0002\u001eB\u0019\u0011+a(\n\u0007\u0005\u0005&KA\u0004C_>dW-\u00198\u0002#\u00154XM]\"p[B\f7\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005\u001d\u0006\"CA<7\u0005\u0005\t\u0019AAO\u00039)g/\u001a:D_6\u0004\u0018m\u0019;fI\u0002\nq\u0002^5feR\u000b7o[:D_:4\u0017nZ\u000b\u0002[\u0006\u0019B/[3s)\u0006\u001c8n]\"p]\u001aLwm\u0018\u0013fcR!\u0011qNAZ\u0011!\t9HHA\u0001\u0002\u0004i\u0017\u0001\u0005;jKJ$\u0016m]6t\u0007>tg-[4!\u0003-\t'o\u00195jm\u0016$\u0016m]6\u0016\u0003U\fq\"\u0019:dQ&4X\rV1tW~#S-\u001d\u000b\u0005\u0003_\ny\f\u0003\u0005\u0002x\u0005\n\t\u00111\u0001v\u00031\t'o\u00195jm\u0016$\u0016m]6!\u00039\u0019w.\u001c9bGRLwN\u001c+bg.,\u0012a_\u0001\u0013G>l\u0007/Y2uS>tG+Y:l?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005-\u0007\u0002CA<I\u0005\u0005\t\u0019A>\u0002\u001f\r|W\u000e]1di&|g\u000eV1tW\u0002\n\u0001\"\u00199qK:$WM]\u000b\u0003\u0003\u0007\tA\"\u00199qK:$WM]0%KF$B!a\u001c\u0002X\"I\u0011qO\u0014\u0002\u0002\u0003\u0007\u00111A\u0001\nCB\u0004XM\u001c3fe\u0002\n1b\u001c2kK\u000e$8\u000b^8sKV\u0011\u0011q\u001c\t\u0004\u001b\u0006\u0005\u0018bAAr\u000f\n\u0019c)Y;mi&s'.Z2uK\u0012$\u0016.\u001a:PE*,7\r^*u_J,wK]1qa\u0016\u0014\u0018\u0001D8cU\u0016\u001cGo\u0015;pe\u0016\u0004\u0013\u0001E1qa\u0016tG-\u001a3NKR\fG-\u0019;b+\t\ty!\u0001\u000bbaB,g\u000eZ3e\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0005\u0003_\ny\u000fC\u0005\u0002x1\n\t\u00111\u0001\u0002\u0010\u0005\t\u0012\r\u001d9f]\u0012,G-T3uC\u0012\fG/\u0019\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011qF\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005m\b\"CA<_\u0005\u0005\t\u0019AA\u0018\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004C\u0003HA3\u0005\u0003\u0011\u0019A!\u0002\u0003\b\t%!1\u0002B\u0007\u0005\u001f\u0011\tBa\u0005\u0003\u0016\t]!\u0011\u0004\u0005\u0007\u0011F\u0002\r!a\u0011\t\r\u0005m\u0014\u00071\u0001a\u0011\u001d\t)&\ra\u0001\u0003/Bq!a\u00132\u0001\u0004\ti\u0005C\u0004\u0002\u000eF\u0002\r!a\u000f\t\u000f\u0005e\u0015\u00071\u0001\u0002\u001e\"1\u00111V\u0019A\u00025Da!a.2\u0001\u0004)\bBBAbc\u0001\u00071\u0010C\u0004\u0002PF\u0002\r!a\u0001\t\u000f\u0005m\u0017\u00071\u0001\u0002`\"9\u0011q]\u0019A\u0002\u0005=\u0001bBAzc\u0001\u0007\u0011qF\u0001\b[\u0016$(/[2t+\t\u0011y\u0002\u0005\u0003\u0003\"\tMRB\u0001B\u0012\u0015\u0011\u0011YB!\n\u000b\t\t\u001d\"\u0011F\u0001\u0007G>lWn\u001c8\u000b\u0007)\u0013YC\u0003\u0003\u0003.\t=\u0012AB1qC\u000eDWM\u0003\u0002\u00032\u0005\u0019qN]4\n\t\tU\"1\u0005\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013a\u00023fgR\u0014x.\u001f\u000b\u0003\u0003_\nqC^1mS\u0012\fG/\u001a)beRLG/[8o\t\u0016dW\r^3\u0002\rI,w\u000e]3o)\u0011\tyGa\u0011\t\u000f\t\u0015c\u00071\u0001\u0002\u001e\u0006IQO\u001c4mkNDW\rZ\u0001\rkB$\u0017\r^3D_:4\u0017n\u001a\u000b\u0007\u0003_\u0012YE!\u001a\t\u000f\t5s\u00071\u0001\u0003P\u0005\u00191.Z=\u0011\t\tE#q\f\b\u0005\u0005'\u0012Y\u0006E\u0002\u0003VIk!Aa\u0016\u000b\u0007\te3*\u0001\u0004=e>|GOP\u0005\u0004\u0005;\u0012\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003b\t\r$AB*ue&twMC\u0002\u0003^ICqAa\u001a8\u0001\u0004\u0011y%A\u0003wC2,X\r\u0006\u0003\u0002p\t-\u0004b\u0002B7q\u0001\u0007!qN\u0001\n]\u0016<8i\u001c8gS\u001e\u00042!\u0014B9\u0013\r\u0011\u0019h\u0012\u0002\n\u0019><7i\u001c8gS\u001e\f!C]3bI.+\u0017p]!oI>3gm]3ugR\u0011!\u0011\u0010\t\b#\nm$q\u0010BJ\u0013\r\u0011iH\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0011\t\u0005%1\u0011BD\u0005\u001bk!!a\u0006\n\t\t\u0015\u0015q\u0003\u0002\b\u0011\u0006\u001c\b.T1q!\u0015\t&\u0011\u0012B(\u0013\r\u0011YI\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007E\u0013y)C\u0002\u0003\u0012J\u0013A\u0001T8oOB1!Q\u0013BP\u0005Gk!Aa&\u000b\t\te%1T\u0001\b[V$\u0018M\u00197f\u0015\r\u0011iJU\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BQ\u0005/\u0013!\u0002T5ti\n+hMZ3s!\ri%QU\u0005\u0004\u0005O;%a\u0003*fG>\u0014Hm\u0015;bi\u0016\fA\"\u00193wC:\u001cWm\u00117pG.$B!a\u001c\u0003.\"9!q\u0016\u001eA\u0002\t5\u0015AA7t\u0003E!\u0018m[3Ti\u0006$Xm\u00158baNDw\u000e\u001e\u000b\u0003\u0005k\u00032!\u0014B\\\u0013\r\u0011Il\u0012\u0002\u0017\u001b\u0016\u0014x-\u001a3M_\u001e\u001cF/\u0019;f':\f\u0007o\u001d5pi\u0006aq-\u001a;M_N\u001c8i\\;oiV\u0011!QR\u0001\u0011[\u0006L(-\u001a+jKJ\u001cVmZ7f]R$\"!!(\u0002\u001bQLWM\u001d*fi\u0016tG/[8o)\u0005\u0001\u0017AC7bs\n,7\t\\3b]R!!1\u001aBg!\u001d\t&1\u0010BG\u0005\u001bC\u0011Ba4@!\u0003\u0005\r!!(\u0002)\u0015D\b/Z2u-\u0006d\u0017\u000eZ1uS>t\u0007+Y:t\u0003Qi\u0017-\u001f2f\u00072,\u0017M\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u001b\u0016\u0005\u0003;\u00139n\u000b\u0002\u0003ZB!!1\u001cBs\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!C;oG\",7m[3e\u0015\r\u0011\u0019OU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bt\u0005;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)!\u0011YMa;\u0003p\nM\bb\u0002Bw\u0003\u0002\u0007\u0011QT\u0001\u0006Y>\u001c\u0017\r\u001c\u0005\b\u0005c\f\u0005\u0019AAO\u0003\u0019!\u0018.\u001a:fI\"9!qZ!A\u0002\u0005u\u0015aD7bs\n,Gj\\2bY\u000ecW-\u00198\u0002\u001d5\f\u0017PY3US\u0016\u00148\t\\3b]R!!Q\u0012B~\u0011\u001d\u0011ym\u0011a\u0001\u0003;\u000b\u0001c]5nk2\fG/\u001a#bi\u0006dun]:\u00021\u0011,G.\u001a;f\r&\u00148\u000f\u001e+jKJ,GmU3h[\u0016tG\u000fC\u0004\u0004\u0004)\u0001\ra!\u0002\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1qAB\u0005\u001b\t\u0011)#\u0003\u0003\u0004\f\t\u0015\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0007\u001fQ\u0001\u0019\u0001B8\u0003\u0019\u0019wN\u001c4jO\"9\u0011Q\u000b\u0006A\u0002\u0005]\u0013A\u00073s_B4\u0015N]:u%\u0016\u001cwN\u001d3Ge>l7+Z4nK:$HCBA8\u0007/\u00199\u0003C\u0004\u0004\u001a-\u0001\raa\u0007\u0002!%t\u0007/\u001e;GS2,'+Z2pe\u0012\u001c\b\u0003BB\u000f\u0007Gi!aa\b\u000b\t\r\u0005\"QE\u0001\u0007e\u0016\u001cwN\u001d3\n\t\r\u00152q\u0004\u0002\f\r&dWMU3d_J$7\u000fC\u0004\u0004*-\u0001\raa\u0007\u0002#=,H\u000f];u\r&dWMU3d_J$7\u000f")
public class MergedLogHarness
implements Logging {
    private MergedLog log;
    private int epoch;
    private final HarnessParams params;
    private final Throttler throttler;
    private Cleaner cleaner;
    private boolean everCompacted;
    private TierTasksConfig tierTasksConfig;
    private ArchiveTask archiveTask;
    private CompactionTask compactionTask;
    private TierTopicAppender appender;
    private final FaultInjectedTierObjectStoreWrapper objectStore;
    private CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata;
    private ReplicaManager replicaManager;
    private final Metrics metrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void dropFirstRecordFromSegment(FileRecords fileRecords, FileRecords fileRecords2) {
        MergedLogHarness$.MODULE$.dropFirstRecordFromSegment(fileRecords, fileRecords2);
    }

    public static MergedLogHarness apply(TopicPartition topicPartition, LogConfig logConfig, HarnessParams harnessParams) {
        return MergedLogHarness$.MODULE$.apply(topicPartition, logConfig, harnessParams);
    }

    public static Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> initializeComponents(MergedLog mergedLog, Throttler throttler, HarnessParams harnessParams, int n) {
        return MergedLogHarness$.MODULE$.initializeComponents(mergedLog, throttler, harnessParams, n);
    }

    public static int BrokerId() {
        return MergedLogHarness$.MODULE$.BrokerId();
    }

    public static int MaxProducerIdExpirationMs() {
        return MergedLogHarness$.MODULE$.MaxProducerIdExpirationMs();
    }

    public static int MaxTransactionTimeoutMs() {
        return MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MergedLog log() {
        return this.log;
    }

    public void log_$eq(MergedLog x$1) {
        this.log = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public HarnessParams params() {
        return this.params;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(Cleaner x$1) {
        this.cleaner = x$1;
    }

    public boolean everCompacted() {
        return this.everCompacted;
    }

    public void everCompacted_$eq(boolean x$1) {
        this.everCompacted = x$1;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public void tierTasksConfig_$eq(TierTasksConfig x$1) {
        this.tierTasksConfig = x$1;
    }

    public ArchiveTask archiveTask() {
        return this.archiveTask;
    }

    public void archiveTask_$eq(ArchiveTask x$1) {
        this.archiveTask = x$1;
    }

    public CompactionTask compactionTask() {
        return this.compactionTask;
    }

    public void compactionTask_$eq(CompactionTask x$1) {
        this.compactionTask = x$1;
    }

    public TierTopicAppender appender() {
        return this.appender;
    }

    public void appender_$eq(TierTopicAppender x$1) {
        this.appender = x$1;
    }

    public FaultInjectedTierObjectStoreWrapper objectStore() {
        return this.objectStore;
    }

    public CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata() {
        return this.appendedMetadata;
    }

    public void appendedMetadata_$eq(CopyOnWriteArrayList<AbstractTierMetadata> x$1) {
        this.appendedMetadata = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void destroy() {
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Final log at destroy time: ").append(this.log()).toString());
        this.validatePartitionDelete();
        this.log().time().sleep(10000L);
        this.log().close();
        Utils.delete((File)this.log().dir().getParentFile());
        this.objectStore().close();
        Mockito.framework().clearInlineMocks();
        this.log_$eq(null);
    }

    public void validatePartitionDelete() {
        this.log().topicIdPartition().foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$1(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void reopen(boolean unflushed) {
        void var33_30;
        void var32_29;
        void var31_28;
        void var30_27;
        void var29_26;
        void var28_25;
        void var27_24;
        MockTime time = (MockTime)this.log().localLog().time();
        MockScheduler scheduler = time.scheduler();
        long recoveryPoint = unflushed ? this.log().recoveryPoint() : 0L;
        File logDir = this.log().localLog().dir();
        long logStartOffset = this.log().logStartOffset();
        long hwm = this.log().highWatermark();
        LogConfig logConfig = this.log().config();
        TierLogComponents tierLogComponents = this.log().tierLogComponents();
        LogDirFailureChannel logDirFailureChannel = this.log().localLog().logDirFailureChannel();
        int nextEpoch = this.epoch() + 1;
        this.log().close();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = this.metrics();
        int x$9 = MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs();
        int x$10 = MergedLogHarness$.MODULE$.MaxProducerIdExpirationMs();
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        ConcurrentHashMap x$17 = new ConcurrentHashMap();
        LogOffsetsListener x$18 = MergedLog$.MODULE$.apply$default$17();
        Option x$19 = MergedLog$.MODULE$.apply$default$18();
        MergedLog newLog = MergedLog$.MODULE$.apply(logDir, logConfig, logStartOffset, recoveryPoint, (Scheduler)scheduler, x$6, x$7, (Time)time, x$9, x$10, x$11, logDirFailureChannel, tierLogComponents, unflushed, (Option)x$15, x$16, x$18, x$19, x$17);
        if (Predef$.MODULE$.Boolean2boolean(newLog.config().confluentLogConfig().tierEnable())) {
            newLog.tierPartitionState().setTieringEnabled();
            MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(newLog);
        }
        newLog.updateHighWatermark(hwm);
        Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> tuple7 = MergedLogHarness$.MODULE$.initializeComponents(newLog, this.throttler(), this.params(), nextEpoch);
        if (tuple7 == null) {
            throw new MatchError(null);
        }
        TierTasksConfig newTierTasksConfig = (TierTasksConfig)tuple7._1();
        ArchiveTask newArchiveTask = (ArchiveTask)tuple7._2();
        CompactionTask newCompactionTask = (CompactionTask)tuple7._3();
        TierTopicAppender newAppender = (TierTopicAppender)tuple7._4();
        CopyOnWriteArrayList newAppendedMetadata = (CopyOnWriteArrayList)tuple7._5();
        ReplicaManager newReplicaManager = (ReplicaManager)tuple7._6();
        Cleaner newCleaner = (Cleaner)tuple7._7();
        void newTierTasksConfig2 = var27_24;
        void newArchiveTask2 = var28_25;
        void newCompactionTask2 = var29_26;
        void newAppender2 = var30_27;
        void newAppendedMetadata2 = var31_28;
        void newReplicaManager2 = var32_29;
        void newCleaner2 = var33_30;
        newAppendedMetadata2.addAll(this.appendedMetadata());
        this.log_$eq(newLog);
        this.tierTasksConfig_$eq((TierTasksConfig)newTierTasksConfig2);
        this.archiveTask_$eq((ArchiveTask)newArchiveTask2);
        this.compactionTask_$eq((CompactionTask)newCompactionTask2);
        this.appender_$eq((TierTopicAppender)newAppender2);
        this.appendedMetadata_$eq((CopyOnWriteArrayList<AbstractTierMetadata>)newAppendedMetadata2);
        this.replicaManager_$eq((ReplicaManager)newReplicaManager2);
        this.cleaner_$eq((Cleaner)newCleaner2);
        this.epoch_$eq(nextEpoch);
    }

    public void updateConfig(String key, String value) {
        Map map = this.log().config().originals();
        map.put(key, value);
        this.log().updateConfig(new LogConfig(map, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public void updateConfig(LogConfig newConfig) {
        this.log().updateConfig(newConfig);
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> readKeysAndOffsets() {
        LongRef fetchOffset = LongRef.create((long)this.log().logStartOffset());
        FetchOffsetCache fetchOffsetCache = new FetchOffsetCache(this.log().localLog().time(), 1000, 1000);
        MemoryTracker memoryTracker = new MemoryTracker(this.log().localLog().time(), Long.MAX_VALUE);
        ArrayList ignored = new ArrayList(0);
        HashMap offsetMap = new HashMap();
        ListBuffer records = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Consumer<DelayedOperationKey> callback = new Consumer<DelayedOperationKey>(null){

            public Consumer<DelayedOperationKey> andThen(Consumer<? super DelayedOperationKey> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(DelayedOperationKey t) {
            }
        };
        ObjectRef priorOffsetRead = ObjectRef.create((Object)None$.MODULE$);
        while (fetchOffset.elem < this.log().logEndOffset()) {
            long startFetchOffset = fetchOffset.elem;
            AbstractFetchDataInfo fetchInfo = this.log().read(fetchOffset.elem, this.params().readSize(), (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
            if (fetchInfo instanceof FetchDataInfo) {
                FetchDataInfo fetchDataInfo = (FetchDataInfo)fetchInfo;
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    this.process$1(batch, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                if (fetchDataInfo.fetchOffsetMetadata().messageOffset() == this.log().logEndOffset() && ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty() && this.log().activeSegment().size() == 0) {
                    fetchOffset.elem = fetchDataInfo.fetchOffsetMetadata().messageOffset();
                }
            } else if (fetchInfo instanceof TierFetchDataInfo) {
                TierFetchDataInfo tierFetchDataInfo = (TierFetchDataInfo)fetchInfo;
                PendingFetch fetch = new PendingFetch(CancellationContext.newContext(), ((FaultInjectedTierObjectStoreWrapper)this.log().tierLogComponents().objectStoreOpt().get()).innerTierObjectStore(), fetchOffsetCache, Optional.empty(), tierFetchDataInfo.fetchMetadata().segmentMetadata(), (Consumer)callback, fetchOffset.elem, this.params().readSize(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, memoryTracker, ignored, this.log().localLog().time());
                fetch.run();
                TierFetchResult result = (TierFetchResult)fetch.finish().get(this.log().topicPartition());
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(result.records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    this.process$1(batch, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)fetchInfo);
            }
            Predef$.MODULE$.assert(fetchOffset.elem != startFetchOffset || fetchOffset.elem == this.log().logEndOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("fetch offset didn't advance after ").append(fetchOffset$1.elem).toString());
        }
        return new Tuple2(offsetMap, (Object)records);
    }

    public void advanceClock(long ms) {
        this.log().localLog().time().sleep(ms);
    }

    /*
     * WARNING - void declaration
     */
    public MergedLogStateSnapshot takeStateSnapshot() {
        void var3_3;
        void var2_2;
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var2_2;
        void records2 = var3_3;
        Predef$.MODULE$.assert(!this.log().localLogSegments().exists((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$takeStateSnapshot$1(seg))), (Function0 & Serializable & scala.Serializable)() -> "Next offset caching resulted in incorrect next offset");
        long lossCount = this.getLossCount();
        Predef$.MODULE$.assert(lossCount == 0L, (Function0 & Serializable & scala.Serializable)() -> "lossCount was > 0");
        return new MergedLogStateSnapshot(this.log().topicPartition(), this.log().time().milliseconds(), this.log().logStartOffset(), this.log().localLogStartOffset(), this.log().logEndOffset(), this.log().size(), this.log().tierPartitionState().totalSize(), this.log().highWatermark(), (Vector<SegmentFields>)((TraversableOnce)this.log().localLogSegments().map((Function1 & Serializable & scala.Serializable)seg -> new SegmentFields(seg.baseOffset(), seg.readNextOffset(), seg.getFirstBatchTimestamp(), seg.largestTimestamp(), seg.size()), Iterable$.MODULE$.canBuildFrom())).toVector(), (List<TierLogSegment>)this.log().tieredLogSegments().toList(), Predef$.MODULE$.Long2long(this.log().tierPartitionState().startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), this.log().tierPartitionState().endOffset(), this.log().tierPartitionState().committedEndOffset(), this.log().tierPartitionState().status(), (HashMap<Option<String>, Object>)offsetMap2, (ListBuffer<RecordState>)records2);
    }

    /*
     * WARNING - void declaration
     */
    private long getLossCount() {
        void var7_7;
        MockTime durabilityMockTime = new MockTime(this.log().time().milliseconds(), 0L);
        DurabilityMetricsManager metricsManager = (DurabilityMetricsManager)Mockito.mock(DurabilityMetricsManager.class);
        AuditReporter simpleReporter = AuditReporter$.MODULE$.apply(metricsManager);
        DurabilityDB db = DurabilityDB$.MODULE$.apply(TestUtils$.MODULE$.tempDir());
        DurabilityAuditConfig durabilityAuditConfig = (DurabilityAuditConfig)Mockito.mock(DurabilityAuditConfig.class);
        new AuditJob((Seq)new .colon.colon((Object)new Tuple2((Object)this.log().topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$), this.replicaManager().logManager(), new CountDownLatch(1), simpleReporter, 0, (Option)new Some((Object)this.objectStore()), (Time)durabilityMockTime, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), durabilityAuditConfig, db, AuditJob$.MODULE$.$lessinit$greater$default$11()).run();
        Tuple2 tuple2 = simpleReporter.getDurabilityCounters(this.log().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lossCount = tuple2._2$mcJ$sp();
        return (long)var7_7;
    }

    public boolean maybeTierSegment() {
        if (this.log().tierPartitionState().isTieringEnabled()) {
            boolean bl;
            if (this.archiveTask().state() instanceof BeforeLeader) {
                ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result.state() instanceof BeforeUpload);
            }
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            long initialTierEndOffset = this.log().tierPartitionState().endOffset();
            if (((ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).state() instanceof Upload) {
                ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result2.state() instanceof AfterUpload);
                ArchiveTask result3 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result3.state() instanceof BeforeUpload);
                this.log().tierPartitionState().flush();
                Predef$.MODULE$.assert(initialTierEndOffset != this.log().tierPartitionState().endOffset(), (Function0 & Serializable & scala.Serializable)() -> "tier end offset should have changed after upload");
                bl = true;
            } else {
                bl = false;
            }
            boolean uploaded = bl;
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            return uploaded;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int tierRetention() {
        void var1_1;
        int deleted = 0;
        if (this.log().tierPartitionState().isTieringEnabled()) {
            try {
                DeletionTask.CollectDeletableSegments state = new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), this.log().tierPartitionState().tierEpoch()));
                DeletionTask.State currState = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                while (currState instanceof DeletionTask.InitiateDelete) {
                    DeletionTask.State state3 = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)currState.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(state3 instanceof DeletionTask.Delete);
                    DeletionTask.State completeDelete = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state3.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(completeDelete instanceof DeletionTask.CompleteDelete);
                    ++deleted;
                    Future nextIteration = (Future)Await$.MODULE$.ready((Awaitable)completeDelete.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    nextIteration.value().get();
                    currState = (DeletionTask.State)((Try)nextIteration.value().get()).get();
                }
                Predef$.MODULE$.assert(currState instanceof DeletionTask.CollectDeletableSegments);
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
        }
        return (int)var1_1;
    }

    public Tuple2<Object, Object> maybeClean(boolean expectValidationPass) {
        return this.maybeClean(true, true, expectValidationPass);
    }

    public Tuple2<Object, Object> maybeClean(boolean local, boolean tiered, boolean expectValidationPass) {
        long localDirtyOffset = local ? this.maybeLocalClean() : -1L;
        long tierDirtyOffset = tiered ? this.maybeTierClean(expectValidationPass) : -1L;
        return new Tuple2.mcJJ.sp(localDirtyOffset, tierDirtyOffset);
    }

    public boolean maybeClean$default$1() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private long maybeLocalClean() {
        if (this.log().isLocallyCompactable()) {
            OffsetsToClean cleaningPoint = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)this.log(), (Option)None$.MODULE$, this.log().localLog().time().milliseconds());
            LogToClean logToClean = new LogToClean(this.log().topicPartition(), (AbstractLog)this.log(), cleaningPoint.firstDirtyOffset(), cleaningPoint.firstUncleanableDirtyOffset(), true);
            if (logToClean.cleanableBytes() > 0L) {
                void var4_4;
                Tuple2 tuple2 = this.cleaner().clean((CleanParams)logToClean);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                long cleanedEndOffset = tuple2._1$mcJ$sp();
                this.everCompacted_$eq(true);
                return (long)var4_4;
            }
            return cleaningPoint.firstDirtyOffset();
        }
        return -1L;
    }

    private long maybeTierClean(boolean expectValidationPass) {
        if (this.log().isTierCompactable()) {
            try {
                if (((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.log().tierPartitionState().segments()).asScala()).nonEmpty()) {
                    long prevValidationFailedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count();
                    long prevValidationAbortedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count();
                    Await$.MODULE$.result((Awaitable)this.compactionTask().state().transition(this.compactionTask().ctx(), (TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.throttler(), this.compactionTask().tierCompactionMetrics(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    if (expectValidationPass) {
                        Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count() == prevValidationFailedCount, (Function0 & Serializable & scala.Serializable)() -> "dual compaction validation is expected to pass");
                    } else {
                        Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count() > prevValidationFailedCount, (Function0 & Serializable & scala.Serializable)() -> "dual compaction validation is expected to fail");
                    }
                    Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count() == prevValidationAbortedCount, (Function0 & Serializable & scala.Serializable)() -> "dual compaction validation aborted");
                }
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
            this.everCompacted_$eq(true);
            return this.log().tierPartitionState().compactDirtyStartOffset();
        }
        return -1L;
    }

    public void simulateDataLoss() {
        this.deleteFirstTieredSegment();
    }

    private void deleteFirstTieredSegment() {
        TierLogSegment firstSegment = (TierLogSegment)this.log().tierPartitionState().segments().next();
        TierSegmentDeleteInitiate deleteInitiate = new TierSegmentDeleteInitiate(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch());
        this.appender().addMetadata((AbstractTierMetadata)deleteInitiate);
        this.objectStore().deleteSegment(firstSegment.metadata());
        TierSegmentDeleteComplete deleteComplete = new TierSegmentDeleteComplete(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), this.log().time().milliseconds());
        this.appender().addMetadata((AbstractTierMetadata)deleteComplete);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$9(MergedLogHarness $this, TierObjectStore.ObjectMetadata seg) {
        $this.objectStore().innerTierObjectStore().deleteSegment(seg);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$1(MergedLogHarness $this, TopicIdPartition topicIdPartition) {
        InProgressDeletion inProgress = new InProgressDeletion(0, topicIdPartition, 0L, null, InProgressDeletion$.MODULE$.$lessinit$greater$default$5(), InProgressDeletion$.MODULE$.$lessinit$greater$default$6(), InProgressDeletion$.MODULE$.$lessinit$greater$default$7());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter($this.appendedMetadata()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metadata -> inProgress.process(metadata, OffsetAndEpoch.EMPTY));
        Set collectedIds = ((TraversableOnce)inProgress.allTieredObjects().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.objectId(), List$.MODULE$.canBuildFrom())).toSet();
        Set stateObjectIds = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter($this.log().tierPartitionState().segments()).asScala()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.log().tierPartitionState().fencedSegments()).asScala()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.log().tierPartitionState().compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.objectId()).toSet();
        Predef$.MODULE$.assert(stateObjectIds.diff((GenSet)collectedIds).isEmpty());
        String objectStorePrefix = new StringBuilder(1).append(((TopicIdPartition)$this.log().topicIdPartition().get()).toString()).append("/").toString();
        Set segmentsInObjectStore = ((TraversableOnce)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala()).toList().filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)k.endsWith(TierObjectStore.FileType.SEGMENT.suffix())))).toSet();
        Set toDeleteSegmentKeys = ((TraversableOnce)inProgress.allTieredObjects().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toPath(objectStorePrefix, TierObjectStore.FileType.SEGMENT), List$.MODULE$.canBuildFrom())).toSet();
        Predef$.MODULE$.assert(segmentsInObjectStore.diff((GenSet)toDeleteSegmentKeys).isEmpty());
        inProgress.allTieredObjects().foreach((Function1 & Serializable & scala.Serializable)seg -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$9($this, seg);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala()).isEmpty());
    }

    public static final /* synthetic */ void $anonfun$readKeysAndOffsets$1(MergedLogHarness $this, RecordBatch batch$1, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1, Record rec) {
        RecordState recordState = RecordState$.MODULE$.apply(batch$1, rec);
        if (!batch$1.isControlBatch()) {
            offsetMap$1.put(recordState.key(), BoxesRunTime.boxToLong((long)recordState.offset()));
        }
        records$1.$plus$eq((Object)recordState);
        if (!$this.log().config().compact()) {
            if (((Option)priorOffsetRead$1.elem).isEmpty()) {
                if (rec.offset() > fetchOffset$1.elem) {
                    throw new IllegalThreadStateException("First read offset should never skip forward from the first fetch offset.");
                }
            } else if (BoxesRunTime.unboxToLong((Object)((Option)priorOffsetRead$1.elem).get()) + 1L != rec.offset()) {
                throw new IllegalThreadStateException(new StringBuilder(53).append("Next read offset ").append(rec.offset()).append(" is not equal to prior offset + 1 (").append(fetchOffset$1.elem).append(")").toString());
            }
        }
        priorOffsetRead$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)rec.offset()));
    }

    private final void process$1(RecordBatch batch, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)rec -> {
            MergedLogHarness.$anonfun$readKeysAndOffsets$1(this, batch, offsetMap$1, records$1, priorOffsetRead$1, fetchOffset$1, rec);
            return BoxedUnit.UNIT;
        });
        fetchOffset$1.elem = batch.lastOffset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$takeStateSnapshot$1(LogSegment seg) {
        return seg.readNextOffset() != seg.scanNextOffset();
    }

    public MergedLogHarness(MergedLog log, int epoch, HarnessParams params, Throttler throttler, Cleaner cleaner, boolean everCompacted, TierTasksConfig tierTasksConfig, ArchiveTask archiveTask, CompactionTask compactionTask, TierTopicAppender appender, FaultInjectedTierObjectStoreWrapper objectStore, CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata, ReplicaManager replicaManager) {
        this.log = log;
        this.epoch = epoch;
        this.params = params;
        this.throttler = throttler;
        this.cleaner = cleaner;
        this.everCompacted = everCompacted;
        this.tierTasksConfig = tierTasksConfig;
        this.archiveTask = archiveTask;
        this.compactionTask = compactionTask;
        this.appender = appender;
        this.objectStore = objectStore;
        this.appendedMetadata = appendedMetadata;
        this.replicaManager = replicaManager;
        Logging.$init$((Logging)this);
        this.metrics = new Metrics();
    }
}

