/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001A\u0002\u0013\u0005A\u0006C\u00041\u0001\u0001\u0007I\u0011A\u0019\t\r]\u0002\u0001\u0015)\u0003.\u0011\u001dA\u0004A1A\u0005\u0002eBa!\u0010\u0001!\u0002\u0013Q\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002!\t\u000b\u0011\u0003A\u0011A#\t\u000bM\u0003A\u0011A#\t\u000ba\u0003A\u0011A#\t\u000bu\u0003A\u0011A#\t\u000b}\u0003A\u0011A#\t\u000b\u0005\u0004A\u0011A#\t\u000b\r\u0004A\u0011A#\t\u000b\u0015\u0004A\u0011A#\t\u000b\u001d\u0004A\u0011A#\t\u000b%\u0004A\u0011A#\t\u000b-\u0004A\u0011A#\t\u000b5\u0004A\u0011A#\t\u000b=\u0004A\u0011A#\t\u000bE\u0004A\u0011A#\t\u000bM\u0004A\u0011\u0001;\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d#aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005qi\u0012a\u00017pO*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005\u0019\u0011\u000e\u001a=\u0016\u00035\u0002\"A\u000b\u0018\n\u0005=Z\"aC(gMN,G/\u00138eKb\fq!\u001b3y?\u0012*\u0017\u000f\u0006\u00023kA\u0011!eM\u0005\u0003i\r\u0012A!\u00168ji\"9agAA\u0001\u0002\u0004i\u0013a\u0001=%c\u0005!\u0011\u000e\u001a=!\u0003)i\u0017\r_#oiJLWm]\u000b\u0002uA\u0011!eO\u0005\u0003y\r\u00121!\u00138u\u0003-i\u0017\r_#oiJLWm\u001d\u0011\u0002\u0015\t\f7/Z(gMN,G/F\u0001A!\t\u0011\u0013)\u0003\u0002CG\t!Aj\u001c8h\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\u0002\u000bM,G/\u001e9\u0015\u0003IB#!C$\u0011\u0005!\u000bV\"A%\u000b\u0005)[\u0015aA1qS*\u0011A*T\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqu*A\u0003kk:LGOC\u0001Q\u0003\ry'oZ\u0005\u0003%&\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006V!\tAe+\u0003\u0002X\u0013\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011e\u0006tGm\\7M_>\\W\u000f\u001d+fgRD#a\u0003.\u0011\u0005![\u0016B\u0001/J\u0005\u0011!Vm\u001d;\u0002%1|wn[;q\u000bb$(/Z7f\u0007\u0006\u001cXm\u001d\u0015\u0003\u0019i\u000b\u0011\u0002^3ti\u0016sGO]=)\u00055Q\u0016!\u0005;fgR,e\u000e\u001e:z\u001fZ,'O\u001a7po\"\u0012aBW\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u0005=Q\u0016\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\t\u0001\",A\ruKN$h)\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$\bFA\t[\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003%i\u000b1\u0005^3tiJ+w\u000e]3o\r\u0006LGn\u00165f]\u001aKG.Z!me\u0016\fG-_#ySN$8\u000f\u000b\u0002\u00145\u0006AAO];oG\u0006$X\r\u000b\u0002\u00155\u0006qam\u001c:dKVsW.\u00199UKN$\bFA\u000b[\u0003\u0015\"Xm\u001d;TC:LG/\u001f'bgR|eMZ:fi\u0016\u000bX/\u00197U_\n\u000b7/Z(gMN,G\u000f\u000b\u0002\u00175\u0006\u0001\u0012m]:feR<&/\u001b;f\r\u0006LGn]\u000b\u0004k\u0006mA\u0003\u0003\u001aw\u0003\u000f\tI!!\u0004\t\u000b]<\u0002\u0019\u0001=\u0002\u000f5,7o]1hKB\u0019\u00110!\u0001\u000f\u0005it\bCA>$\u001b\u0005a(BA? \u0003\u0019a$o\\8u}%\u0011qpI\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}\u001c\u0003\"B\u0016\u0018\u0001\u0004i\u0003BBA\u0006/\u0001\u0007!(\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u001f9\u0002\u0019AA\t\u0003\u0015YG.Y:t!\u0015I\u00181CA\f\u0013\u0011\t)\"!\u0002\u0003\u000b\rc\u0017m]:\u0011\t\u0005e\u00111\u0004\u0007\u0001\t\u001d\tib\u0006b\u0001\u0003?\u0011\u0011\u0001V\t\u0005\u0003C\t9\u0003E\u0002#\u0003GI1!!\n$\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AIA\u0015\u0013\r\tYc\t\u0002\u0004\u0003:L\u0018\u0001D7p]>$xN\\5d'\u0016\fHCBA\u0019\u0003{\t\t\u0005E\u0003\u00024\u0005e\"(\u0004\u0002\u00026)\u0019\u0011qG\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005U\"aA*fc\"1\u0011q\b\rA\u0002i\nAAY1tK\"1\u00111\t\rA\u0002i\n1\u0001\\3o\u0003MqwN\\#ySN$XM\u001c;UK6\u0004h)\u001b7f)\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0005%|'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\u0005\r&dW\r")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4(), OffsetIndex$.MODULE$.$lessinit$greater$default$5()));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L), (String)"Not present value should return physical offset 0.");
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> Assertions.assertEquals((Object)(offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp())), (Object)this.idx().lookup(offset), (String)"The index should give the same answer as the sorted map"));
    }

    @Test
    public void lookupExtremeCases() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()), (String)"Lookup on empty file");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)i + 1L, i), (Object)this.idx().entry(i)));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().append(50L, 1));
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assertions.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assertions.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assertions.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assertions.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        File x$1 = this.idx().file();
        long x$2 = this.idx().baseOffset();
        boolean x$3 = true;
        int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
        boolean x$5 = OffsetIndex$.MODULE$.$lessinit$greater$default$5();
        OffsetIndex idxRo = new OffsetIndex(x$1, x$2, x$4, x$3, x$5);
        Assertions.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assertions.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assertions.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assertions.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        OffsetPosition entry = new OffsetPosition(51L, 0);
        this.idx().append(entry.offset(), entry.position());
        this.idx().close();
        Assertions.assertThrows(IllegalStateException.class, () -> {
            File x$1 = this.idx().file();
            long x$2 = this.idx().baseOffset();
            boolean x$3 = false;
            int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            boolean x$5 = OffsetIndex$.MODULE$.$lessinit$greater$default$5();
            new OffsetIndex(x$1, x$2, x$4, x$3, x$5);
        });
        File x$6 = this.idx().file();
        long x$7 = this.idx().baseOffset();
        boolean x$8 = true;
        int x$9 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
        boolean x$10 = OffsetIndex$.MODULE$.$lessinit$greater$default$5();
        this.idx_$eq(new OffsetIndex(x$6, x$7, x$9, x$8, x$10));
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4(), OffsetIndex$.MODULE$.$lessinit$greater$default$5());
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate past the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate at the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assertions.assertEquals((Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L), (String)"Index should truncate off last entry");
        Assertions.assertEquals((long)8L, (long)idx.lastOffset(), (String)"8 should be the last entry in the index");
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assertions.assertEquals((Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L), (String)"4 should be the last entry in the index");
        Assertions.assertEquals((long)4L, (long)idx.lastOffset(), (String)"4 should be the last entry in the index");
        idx.append(5L, 5);
        idx.truncate();
        Assertions.assertEquals((int)0, (int)idx.entries(), (String)"Full truncation should leave no entries");
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4(), OffsetIndex$.MODULE$.$lessinit$greater$default$5());
        idx.forceUnmap();
        Assertions.assertThrows(NullPointerException.class, () -> idx.lookup(1L));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4(), OffsetIndex$.MODULE$.$lessinit$greater$default$5());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> idx.append((long)offset, 1), () -> message);
        Assertions.assertEquals(klass, e.getClass(), (String)"Got an unexpected exception.");
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)_ -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)_)));
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assertions.assertEquals((Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical), (String)"Should be able to find values that are present.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

