/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.MergedLog$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001\u0002*T\u0001aCQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001A\u0002\u0013%A\rC\u0004n\u0001\u0001\u0007I\u0011\u00028\t\rQ\u0004\u0001\u0015)\u0003f\u0011\u001d)\b\u00011A\u0005\nYDqA\u001f\u0001A\u0002\u0013%1\u0010\u0003\u0004~\u0001\u0001\u0006Ka\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u0005\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\ty\u0003\u0001Q\u0001\n\u0005%\u0002\"CA\u0019\u0001\t\u0007I\u0011BA\u0014\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005%\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u0014\u0011!\t9\u0004\u0001Q\u0001\n\u0005%\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\tI\u0005\u0001Q\u0001\n\u0005u\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003K\u0002A\u0011AA'\u0011\u001d\ty\u0007\u0001C\u0001\u0003\u001bBq!!\u001f\u0001\t\u0003\ti\u0005C\u0004\u0002~\u0001!\t!!\u0014\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002N!9\u0011Q\u0011\u0001\u0005\u0002\u00055\u0003bBAE\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u001b\u0003A\u0011AA'\u0011\u001d\t\t\n\u0001C\u0001\u0003\u001bBq!!&\u0001\t\u0003\ti\u0005C\u0004\u0002\u001a\u0002!\t!!\u0014\t\u000f\u0005u\u0005\u0001\"\u0001\u0002N!9\u0011\u0011\u0015\u0001\u0005\u0002\u00055\u0003bBAS\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003S\u0003A\u0011AA'\u0011\u001d\ti\u000b\u0001C\u0001\u0003\u001bBq!!-\u0001\t\u0003\ti\u0005C\u0004\u00026\u0002!\t!!\u0014\t\u000f\u0005e\u0006\u0001\"\u0001\u0002N!9\u0011Q\u0018\u0001\u0005\u0002\u00055\u0003bBAa\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u000b\u0004A\u0011AA'\u0011\u001d\tI\r\u0001C\u0001\u0003\u001bBq!!4\u0001\t\u0003\ti\u0005C\u0004\u0002R\u0002!\t!!\u0014\t\u000f\u0005U\u0007\u0001\"\u0001\u0002N!9\u0011\u0011\u001c\u0001\u0005\u0002\u00055\u0003bBAo\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003C\u0004A\u0011AA'\u0011\u001d\t)\u000f\u0001C\u0001\u0003\u001bBq!!;\u0001\t\u0003\ti\u0005C\u0004\u0002n\u0002!\t!!\u0014\t\u000f\u0005E\b\u0001\"\u0001\u0002N!9\u0011Q\u001f\u0001\u0005\u0002\u00055\u0003bBA}\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003{\u0004A\u0011AA'\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u001bBqA!\u0002\u0001\t\u0003\ti\u0005C\u0004\u0003\n\u0001!\t!!\u0014\t\u000f\t5\u0001\u0001\"\u0001\u0002N!9!\u0011\u0003\u0001\u0005\u0002\u00055\u0003b\u0002B\u000b\u0001\u0011\u0005\u0011Q\n\u0005\b\u00053\u0001A\u0011AA'\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u001bBqA!\t\u0001\t\u0003\ti\u0005C\u0004\u0003&\u0001!\t!!\u0014\t\u000f\t%\u0002\u0001\"\u0001\u0002N!9!Q\u0006\u0001\u0005\u0002\u00055\u0003b\u0002B\u0018\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005g\u0001A\u0011AA'\u0011\u001d\u00119\u0004\u0001C\u0001\u0003\u001bBqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003Z\u0001!IAa\u0017\t\u0013\tU\u0005!%A\u0005\n\t]\u0005\"\u0003BW\u0001E\u0005I\u0011\u0002BX\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kC\u0011B!7\u0001#\u0003%IAa,\t\u0013\tm\u0007!%A\u0005\n\tu\u0007\"\u0003Bq\u0001E\u0005I\u0011\u0002Br\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005ODqAa?\u0001\t\u0013\u0011iP\u0001\rQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d+fgRT!\u0001V+\u0002\u00071|wMC\u0001W\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A-\u0011\u0005ikV\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\r\u0005\u0002c\u00015\t1+\u0001\u0004m_\u001e$\u0015N]\u000b\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0003S>T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003_J\u0004\"A\u00179\n\u0005E\\&\u0001B+oSRDqa]\u0002\u0002\u0002\u0003\u0007Q-A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0007ti\u0006$X-T1oC\u001e,'/F\u0001x!\t\u0011\u00070\u0003\u0002z'\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0005=d\bbB:\u0007\u0003\u0003\u0005\ra^\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\u0001!\u0011\t\u0019!a\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\taaY8n[>t'b\u0001,\u0002\f)!\u0011QBA\b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011C\u0001\u0004_J<\u0017\u0002BA\u000b\u0003\u000b\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\n!\u0002\u001d:pIV\u001cWM]%e+\t\ti\u0002E\u0002[\u0003?I1!!\t\\\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u0018[\u0006DHK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\"!!\u000b\u0011\u0007i\u000bY#C\u0002\u0002.m\u00131!\u00138u\u0003ai\u0017\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fI\u0001\u001a[\u0006D\bK]8ek\u000e,'/\u00133FqBL'/\u0019;j_:l5/\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\rmCR,GK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\f\u0011\u0004\\1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005!A/[7f+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\u0011\t\u0019%!\u0002\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u001d\u0013\u0011\t\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005)1/\u001a;VaR\tq\u000eK\u0002\u0015\u0003#\u0002B!a\u0015\u0002b5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0002ba&TA!a\u0017\u0002^\u00059!.\u001e9ji\u0016\u0014(\u0002BA0\u0003\u001f\tQA[;oSRLA!a\u0019\u0002V\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!FA5!\u0011\t\u0019&a\u001b\n\t\u00055\u0014Q\u000b\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti\n\u000b7/[2JI6\u000b\u0007\u000f]5oO\"\u001aa#a\u001d\u0011\t\u0005M\u0013QO\u0005\u0005\u0003o\n)F\u0001\u0003UKN$\u0018A\n;fgR\f\u0005\u000f]3oIRCh.T1sW\u0016\u0014x+\u001b;i\u001d>\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\"\u001aq#a\u001d\u0002=Q,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f/J\f\u0007/\u0011:pk:$\u0007f\u0001\r\u0002t\u0005iC/Z:u!J|G-^2feN+\u0017/^3oG\u0016<\u0016\u000e\u001e5Xe\u0006\u0004\u0018I]8v]\u0012\u0014\u0015\r^2i%\u0016\u001cwN\u001d3)\u0007e\t\u0019(A\u0013uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z%om\u0006d\u0017\u000eZ,sCB\f%o\\;oI\"\u001a!$a\u001d\u0002UQ,7\u000f\u001e(p-\u0006d\u0017\u000eZ1uS>twJ\u001c$jeN$XI\u001c;ss^CWM\u001c'pC\u0012Lgn\u001a'pO\"\u001a1$a\u001d\u0002GQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014HMQ;naN\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\"\u001aA$a\u001d\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u0004;\u0005M\u0014a\u0005;fgRd5o\u001c\"bi\u000eD\u0017\t\u001d9f]\u0012\u001c\bf\u0001\u0010\u0002t\u0005IB/Z:u'.L\u0007/R7qif$&/\u00198tC\u000e$\u0018n\u001c8tQ\ry\u00121O\u0001\u0017i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]\"\u001a\u0001%a\u001d\u0002YQ,7\u000f\u001e%bg2\u000bG/\u001a+sC:\u001c\u0018m\u0019;j_:Le.\u001b;jC2L'0\u001a3BMR,'OU3m_\u0006$\u0007fA\u0011\u0002t\u0005\u0019D/Z:u\u0011\u0006\u001cH*\u0019;f)J\fgn]1di&|g.\u00169eCR,G-\u00114uKJ\u0004\u0016M\u001d;jC2$&/\u001e8dCRLwN\u001c\u0015\u0004E\u0005M\u0014\u0001\r;fgRD\u0015m\u001d'bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8Va\u0012\fG/\u001a3BMR,'OR;mYR\u0013XO\\2bi&|g\u000eK\u0002$\u0003g\n\u0001\u0005^3ti2\u000b7\u000f^*uC\ndWm\u00144gg\u0016$8i\\7qY\u0016$X\r\u001a+y]\"\u001aA%a\u001d\u0002=Q,7\u000f\u001e)sKB\f'/Z+qI\u0006$X\rR8fg:{G/T;uCR,\u0007fA\u0013\u0002t\u0005qR\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0015\u0004M\u0005M\u0014\u0001\f;fgR|U\u000f^(g'\u0016\fX/\u001a8dK\u00063G/\u001a:D_:$(o\u001c7SK\u000e|'\u000fZ#q_\u000eD')^7qQ\r9\u00131O\u00011i\u0016\u001cHOT8o)J\fgn]1di&|g.\u00197BaB,g\u000eZ,ji\"|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8)\u0007!\n\u0019(A\u0018uKN$HK];oG\u0006$X-\u00118e%\u0016dw.\u00193SK6|g/Z:PkR|eMU1oO\u0016\u001cf.\u00199tQ>$8\u000fK\u0002*\u0003g\n\u0001\u0003^3tiR\u000b7.Z*oCB\u001c\bn\u001c;)\u0007)\n\u0019(\u0001\u0017uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5piVsg-\u001b8jg\",G\r\u0016:b]N\f7\r^5p]\"\u001a1&a\u001d\u0002UQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$h)\u001b8jg\",G\r\u0016:b]N\f7\r^5p]\"\u001aA&a\u001d\u0002OQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$X)\u001c9usR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004[\u0005M\u0014\u0001\u000b;fgR\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\u00063G/\u001a:GK:\u001c\u0017N\\4BE>\u0014H/T1sW\u0016\u0014\bf\u0001\u0018\u0002t\u0005iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\rK\u00020\u0003g\nQ\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRDw.\u001e;Qe>$WoY3s'R\fG/Z(o%\u0016\u0004H.[2bQ\r\u0001\u00141O\u0001*i\u0016\u001cH/Q2dKB$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5TKF,XM\\2f\u000f\u0006\u00048o\u00148SKBd\u0017nY1)\u0007E\n\u0019(A\ruKN$H)\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,\u0007f\u0001\u001a\u0002t\u0005YB/Z:u)J,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003RD3aMA:\u0003\u0019\"Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0004i\u0005M\u0014A\f;fgRdu.\u00193Ge>l7K\\1qg\"|GOU3uC&t7OT8o\u000bb\u0004\u0018N]3e!J|G-^2feND3!NA:\u0003\u0005\"Xm\u001d;TW&\u00048K\\1qg\"|G/\u00134PM\u001a\u001cX\r^+oG\"\fgnZ3eQ\r1\u00141O\u0001\u0019i\u0016\u001cH\u000fU5e\u000bb\u0004\u0018N]1uS>tG+[7f_V$\bfA\u001c\u0002t\u00059B/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004q\u0005M\u0014A\f;fgR\u0004&o\u001c3vG\u0016\u00148oV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\\:E_:$X\t\u001f9je\u0016D3!OA:\u00035\"Xm\u001d;TKF,XM\\2f\u001d>$h+\u00197jI\u0006$X\r\u001a$pe\u001e\u0013x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0015\u0004u\u0005M\u0014\u0001\b;fgR|E\u000eZ#q_\u000eDgi\u001c:D_:$(o\u001c7SK\u000e|'\u000f\u001a\u0015\u0004w\u0005M\u0014A\u0006;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001c\u0017N\\4)\u0007q\n\u0019(\u0001\u0011uKN$8i\\8sI&t\u0017\r^8s\r\u0016t7-\u001a3BMR,'OU3m_\u0006$\u0007fA\u001f\u0002t\u0005iB/Z:u\u0019>\fGM\u0012:p[\u0016k\u0007\u000f^=T]\u0006\u00048\u000f[8u\r&dW\rK\u0002?\u0003g\n\u0011\u0005^3ti2{\u0017\r\u001a$s_6$&/\u001e8dCR,Gm\u00158baNDw\u000e\u001e$jY\u0016D3aPA:\u0003}!Xm\u001d;M_\u0006$gI]8n\u0007>\u0014(/\u001e9u':\f\u0007o\u001d5pi\u001aKG.\u001a\u0015\u0004\u0001\u0006M\u0014a\u0007;fgR\f\u0005\u000f]3oI\u0016k\u0007\u000f^=D_:$(o\u001c7CCR\u001c\u0007\u000eK\u0002B\u0003g\nA\u0004^3tiJ+Gn\\1e\rJ|W\u000eV5fe\u0016$7K\\1qg\"|G\u000fK\u0002C\u0003g\n\u0011\u0004^3tiNs\u0017\r]:i_R4\u0015\u000e\\3G_J|eMZ:fi\"\u001a1)a\u001d\u0002cQ,7\u000f\u001e*f[>4Xm\u0015;sCf\u001cf.\u00199tQ>$8oS3fa\u000ecW-\u00198TQV$Hm\\<o':\f\u0007o\u001d5pi\u0006YB/Z:u%\u0016lwN^3BY2\u001cFO]1z':\f\u0007o\u001d5piND3!RA:\u0003\u0011\"Xm\u001d;SK6|g/Z!oI6\u000b'o[*oCB\u001c\bn\u001c;G_J$U\r\\3uS>t\u0007f\u0001$\u0002t\u0005\u0011D/Z:u%\u0016lwN^3B]\u0012l\u0015M]6T]\u0006\u00048\u000f[8u\r>\u0014H)\u001a7fi&|g.\u00117sK\u0006$\u0017\u0010R3mKR,G\rK\u0002H\u0003g\n1\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$HcA8\u0003@!9!\u0011\t%A\u0002\t\r\u0013aD7bW\u00164\u0015\u000e\\3D_J\u0014X\u000f\u001d;\u0011\ri\u0013)E!\u0013p\u0013\r\u00119e\u0017\u0002\n\rVt7\r^5p]F\u0002BAa\u0013\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t&\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011\u0019&[\u0001\u0004]&|\u0017\u0002\u0002B,\u0005\u001b\u00121BR5mK\u000eC\u0017M\u001c8fY\u0006\u0011\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3s)A\u0011iF!\u001b\u0003n\t=$\u0011\u0010BE\u0005\u001b\u0013\t\nE\u0003[\u0005?\u0012\u0019'C\u0002\u0003bm\u0013aa\u00149uS>t\u0007c\u00012\u0003f%\u0019!qM*\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\r\t-\u0014\n1\u0001x\u0003\u001di\u0017\r\u001d9j]\u001eDq!!\u0007J\u0001\u0004\ti\u0002C\u0004\u0003r%\u0003\rAa\u001d\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\rQ&QO\u0005\u0004\u0005oZ&!B*i_J$\bb\u0002B>\u0013\u0002\u0007!QP\u0001\fG>tGO]8m)f\u0004X\r\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\u0011\u0011\u0019)!\u0002\u0002\rI,7m\u001c:e\u0013\u0011\u00119I!!\u0003#\r{g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\rC\u0004\u0003\f&\u0003\r!!\b\u0002\r=4gm]3u\u0011%\u0011y)\u0013I\u0001\u0002\u0004\tI#\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"I!1S%\u0011\u0002\u0003\u0007\u0011QD\u0001\ni&lWm\u001d;b[B\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u001a*\"\u0011\u0011\u0006BNW\t\u0011i\n\u0005\u0003\u0003 \n%VB\u0001BQ\u0015\u0011\u0011\u0019K!*\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BT7\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-&\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001H1qa\u0016tG-\u00128e)btW*\u0019:lKJ$C-\u001a4bk2$HeN\u000b\u0003\u0005cSC!!\b\u0003\u001c\u00061\u0011\r\u001d9f]\u0012$\u0012c\u001cB\\\u0005s\u0013YL!0\u0003B\n\r'Q\u0019Bh\u0011\u0015)H\n1\u0001x\u0011\u001d\tI\u0002\u0014a\u0001\u0003;AqA!\u001dM\u0001\u0004\u0011\u0019\bC\u0004\u0003@2\u0003\r!!\u000b\u0002\u0007M,\u0017\u000fC\u0004\u0003\f2\u0003\r!!\b\t\u0013\tME\n%AA\u0002\u0005u\u0001\"\u0003Bd\u0019B\u0005\t\u0019\u0001Be\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007c\u0001.\u0003L&\u0019!QZ.\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u001b'\u0011\u0002\u0003\u0007!1[\u0001\u0007_JLw-\u001b8\u0011\u0007\t\u0014).C\u0002\u0003XN\u0013A\"\u00119qK:$wJ]5hS:\f\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001c\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012:TC\u0001BpU\u0011\u0011IMa'\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012BTC\u0001BsU\u0011\u0011\u0019Na'\u0015\u0017=\u0014IOa;\u0003n\n=(\u0011 \u0005\u0006kB\u0003\ra\u001e\u0005\b\u00033\u0001\u0006\u0019AA\u000f\u0011\u001d\u0011Y\t\u0015a\u0001\u0003;AqA!=Q\u0001\u0004\u0011\u00190A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0003\u0000\tU\u0018\u0002\u0002B|\u0005\u0003\u00131BU3d_J$')\u0019;dQ\"9!\u0011\u001b)A\u0002\tM\u0017AF2veJ,g\u000e^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^:\u0016\u0005\t}\bCBB\u0001\u0007\u001f\tiB\u0004\u0003\u0004\u0004\r-\u0001cAB\u000376\u00111q\u0001\u0006\u0004\u0007\u00139\u0016A\u0002\u001fs_>$h(C\u0002\u0004\u000em\u000ba\u0001\u0015:fI\u00164\u0017\u0002BB\t\u0007'\u00111aU3u\u0015\r\u0019ia\u0017")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final int maxProducerIdExpirationMs;
    private final int lateTransactionTimeoutMs = this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private int lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$, this.time().milliseconds());
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLsoBatchAppends() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo append = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        this.appendData$1(24L, 27L, append, producerEpoch, seq);
        Option firstTxnAbort = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, append, coordinatorEpoch, producerEpoch);
        this.appendData$1(29L, 31L, append, producerEpoch, seq);
        Option secondTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 32L, append, coordinatorEpoch, producerEpoch);
        ProducerAppendInfo appendDiffProdId = this.stateManager().prepareUpdate(2L, (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        this.appendData$1(33L, 34L, appendDiffProdId, producerEpoch, seq);
        Option thirdTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 35L, appendDiffProdId, coordinatorEpoch, producerEpoch);
        this.stateManager().update(append);
        this.stateManager().update(appendDiffProdId);
        Assertions.assertEquals((long)((CompletedTxn)secondTxnComplete.get()).firstOffset(), (long)this.stateManager().proposedLastStableOffset((CompletedTxn)firstTxnAbort.get()));
        this.stateManager().completeTxn((CompletedTxn)firstTxnAbort.get());
        Assertions.assertEquals((long)((CompletedTxn)thirdTxnComplete.get()).firstOffset(), (long)this.stateManager().proposedLastStableOffset((CompletedTxn)secondTxnComplete.get()));
        this.stateManager().completeTxn((CompletedTxn)secondTxnComplete.get());
        this.stateManager().onHighWatermarkUpdated(35L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(33L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        long firstAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, firstAppendTimeMs);
        this.appendData$2(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L, firstAppendTimeMs), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
        long secondAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, secondAppendTimeMs);
        Option firstCompletedTxn = this.appendEndTxn$2(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$2(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), secondAppendTimeMs, TxnMetadata$.MODULE$.apply$default$4()), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), secondAppendTimeMs, TxnMetadata$.MODULE$.apply$default$4()), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        long loadTimeMs = this.time().milliseconds();
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), loadTimeMs);
        Assertions.assertFalse((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)this.lateTransactionTimeoutMs());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().proposedLastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$, appendTimeMs);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L, appendTimeMs), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L, appendTimeMs), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L, appendTimeMs), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            int x$12 = 1;
            long x$13 = 1L;
            boolean x$14 = false;
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = this.append$default$8();
            this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head())).nonEmpty(), (String)"Snapshot file is empty");
        Option snapshotFileOpt = this.stateManager().snapshotFileForOffset(2L);
        Assertions.assertTrue((boolean)snapshotFileOpt.isDefined());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileOpt.get()).isOpenForWrite());
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        Map snapshots = ((TraversableOnce)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).map((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$1(this, BoxesRunTime.unboxToInt((Object)offset)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        Assertions.assertFalse((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)2))).isOpenForWrite());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)3))).isOpenForWrite());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        snapshots.values().foreach((Function1 & Serializable & scala.Serializable)s -> {
            ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$2(s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$52, x$72, x$62, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxProducerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$82 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$132 = 105L;
        boolean x$142 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$92, anotherPid, epoch, sequence, x$132, x$15, x$142, x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxProducerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testReloadFromTieredSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option maybeFile = this.stateManager().snapshotFileForOffset(3L).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.file());
        Assertions.assertTrue((boolean)maybeFile.isDefined(), (String)"expected to find snapshot file at offset 3");
        File snapshotFile = (File)maybeFile.get();
        ByteBuffer buf = ByteBuffer.allocate((int)snapshotFile.length());
        try (FileChannel fc = FileChannel.open(snapshotFile.toPath(), new OpenOption[0]);){
            Utils.readFully((FileChannel)fc, (ByteBuffer)buf, (long)0L);
        }
        buf.flip();
        long originalLastDataOffset = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastDataOffset();
        int originalLastOffsetDelta = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastOffsetDelta();
        int originalLastSeq = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq();
        long originalLastTimestamp = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastTimestamp();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateFullyAndStartAt(0L);
        this.stateManager().reloadFromTieredSnapshot(0L, this.time().milliseconds(), buf, 3L);
        this.stateManager().takeSnapshot();
        Assertions.assertTrue((boolean)this.stateManager().snapshotFileForOffset(3L).isDefined(), (String)"expected a snapshot file to exist for the restored snapshot");
        Assertions.assertEquals((int)this.logDir().listFiles().length, (int)1, (String)"expected all other snapshot files to be cleared, leaving only the restored snapshot file");
        ProducerStateEntry reloadedLastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((long)originalLastDataOffset, (long)reloadedLastEntry.lastDataOffset(), (String)"expected lastDataOffset to be restored");
        Assertions.assertEquals((int)originalLastOffsetDelta, (int)reloadedLastEntry.lastOffsetDelta(), (String)"expected lastOffsetDelta to be restored");
        Assertions.assertEquals((int)originalLastSeq, (int)reloadedLastEntry.lastSeq(), (String)"expected lastSeq to be restored");
        Assertions.assertEquals((long)originalLastTimestamp, (long)reloadedLastEntry.lastTimestamp(), (String)"expected lastTimestamp to be restored");
    }

    @Test
    public void testSnapshotFileForOffset() {
        Assertions.assertTrue((boolean)Paths.get(this.logDir().getAbsolutePath(), "00000000000000000020.snapshot").toFile().createNewFile());
        TopicPartition tp = new TopicPartition("test_topic", 0);
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        File foundFile = ((SnapshotFile)producerStateManager.snapshotFileForOffset(20L).get()).file();
        Assertions.assertEquals((Object)"00000000000000000020.snapshot", (Object)foundFile.getName());
        Assertions.assertTrue((boolean)foundFile.exists());
        Assertions.assertFalse((boolean)producerStateManager.snapshotFileForOffset(19L).isDefined());
    }

    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(MergedLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L);
        file.createNewFile();
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Files.delete(file.toPath());
        Assertions.assertTrue((boolean)manager.removeAndMarkSnapshotForDeletion(5L).isEmpty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = MergedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, appendTimeMs);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)MergedLog$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final Option appendEndTxn$2(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$2, short producerEpoch$3) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$2), producerEpoch$3, offset, this.time().milliseconds());
    }

    private final void appendData$2(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$3, AtomicInteger seq$2) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$3, seq$2.get(), seq$2.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$2.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$4) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$, this.time().milliseconds());
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$4, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteSnapshotsBefore$1(ProducerStateManagerTest $this, int offset) {
        SnapshotFile snapshot = (SnapshotFile)$this.stateManager().snapshotFileForOffset((long)offset).get();
        Assertions.assertTrue((boolean)snapshot.isOpenForWrite());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)snapshot);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshotsBefore$2(SnapshotFile s) {
        Assertions.assertFalse((boolean)s.isOpenForWrite());
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
        this.maxProducerIdExpirationMs = 3600000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

