/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.HarnessParams;
import kafka.log.HarnessParams$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.RecordState;
import kafka.log.TierLogSegment;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u0013&\u0001)BQ!\r\u0001\u0005\u0002IB\u0011\"\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001\u001c\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u00038\u0011%\u0011\u0005\u00011AA\u0002\u0013\u00051\tC\u0005M\u0001\u0001\u0007\t\u0019!C\u0001\u001b\"Iq\n\u0001a\u0001\u0002\u0003\u0006K\u0001\u0012\u0005\n!\u0002\u0001\r\u00111A\u0005\u0002EC\u0011\"\u0018\u0001A\u0002\u0003\u0007I\u0011\u00010\t\u0013\u0001\u0004\u0001\u0019!A!B\u0013\u0011\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00028\u0001\t\u0003\u0011\u0007\"B:\u0001\t\u0003\u0011\u0007\"\u0002=\u0001\t\u0003\u0011\u0007\"\u0002>\u0001\t\u0003\u0011\u0007\"\u0002?\u0001\t\u0003\u0011\u0007\"\u0002@\u0001\t\u0003\u0011\u0007BBA\u0001\u0001\u0011\u0005!\r\u0003\u0004\u0002\u0006\u0001!\tA\u0019\u0005\u0007\u0003\u0013\u0001A\u0011\u00012\t\r\u00055\u0001\u0001\"\u0001c\u0011\u0019\t\t\u0002\u0001C\u0001E\"1\u0011Q\u0003\u0001\u0005\u0002\tDq!!\u0007\u0001\t\u0013\tY\u0002\u0003\u0004\u0002(\u0001!\tA\u0019\u0005\u0007\u0003W\u0001A\u0011\u00012\t\r\u0005=\u0002\u0001\"\u0001c\u0011\u0019\t\u0019\u0004\u0001C\u0001E\"1\u0011q\u0007\u0001\u0005\u0002\tDq!a\u000f\u0001\t\u0013\ti\u0004C\u0005\u0002~\u0001\t\n\u0011\"\u0003\u0002\u0000!I\u0011Q\u0013\u0001\u0012\u0002\u0013%\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0013!C\u0005\u0003;C\u0011\"!)\u0001#\u0003%I!!(\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\n\u0011B+[3s\u0007>l\u0007/Y2u\u0019><G+Z:u\u0015\t1s%A\u0002m_\u001eT\u0011\u0001K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0002\"\u0001\u000e\u0001\u000e\u0003\u0015\nq\u0001[1s]\u0016\u001c8/F\u00018!\t!\u0004(\u0003\u0002:K\t\u0001R*\u001a:hK\u0012dun\u001a%be:,7o]\u0001\fQ\u0006\u0014h.Z:t?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011A&P\u0005\u0003}5\u0012A!\u00168ji\"9\u0001iAA\u0001\u0002\u00049\u0014a\u0001=%c\u0005A\u0001.\u0019:oKN\u001c\b%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0003S>T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003y9Cq\u0001\u0011\u0004\u0002\u0002\u0003\u0007A)A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t!\u000b\u0005\u0002T76\tAK\u0003\u0002V-\u000611m\\7n_:T!\u0001K,\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0005\u00039R\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\nu_BL7\rU1si&$\u0018n\u001c8`I\u0015\fHC\u0001\u001f`\u0011\u001d\u0001\u0015\"!AA\u0002I\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002y!\u00121\u0002\u001a\t\u0003K2l\u0011A\u001a\u0006\u0003O\"\f1!\u00199j\u0015\tI'.A\u0004kkBLG/\u001a:\u000b\u0005-L\u0016!\u00026v]&$\u0018BA7g\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012A\u0002\u001d\t\u0003KFL!A\u001d4\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u000f;fgR\u001cu.\u001c9mKR,G.\u001f#fY\u0016$X\rZ\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:$U\r\\3uKN\fE\u000e\\*fO6,g\u000e^:)\u00055)\bCA3w\u0013\t9hM\u0001\u0003UKN$\u0018!\t;fgRTVM]8TSj,GmU3h[\u0016tG/S:O_R\f%o\u00195jm\u0016$\u0007F\u0001\bv\u0003]\"Xm\u001d;SK\u0006$g*\u001a=u\u001f\u001a47/\u001a;Ue\u0006\u001c7.\u001a3D_J\u0014Xm\u0019;ms\u001a{'oQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]\"\u0012q\"^\u0001\u001bi\u0016\u001cHo\u0012:po\u0006\u0014G.Z\"p[B\f7\r\u001e\"vM\u001a,'o\u001d\u0015\u0003!U\fA\u0002^3tiRC'o\u001c;uY\u0016D#!E;\u0002CQ,7\u000f\u001e(p\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d*fi\u0006Lg.\u001a3)\u0005I)\u0018\u0001\u000b;fgR\u001cu.\u001c9mKR,G-\u00112peR,G\r\u0016:b]N\f7\r^5p]N\u0014V\r^1j]\u0016$\u0007FA\nv\u0003\u0019\"Xm\u001d;P]\u001e|\u0017N\\4BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7OU3uC&tW\r\u001a\u0015\u0003)U\f!\u0007^3ti\u000e{W\u000e\u001d7fi\u0016$\u0017I\u001c3P]\u001e|\u0017N\\4BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7OU3uC&tW\r\u001a\u0015\u0003+U\fq\u0006^3ti6KgnQ8na\u0006\u001cG/[8o\u0019\u0006<WI\\1cY\u0016$w+\u001b;i\rV$XO]3US6,7\u000f^1naND#AF;\u0002aQ,7\u000f^'j]\u000e{W\u000e]1di&|g\u000eT1h\t&\u001c\u0018M\u00197fI^KG\u000f\u001b$viV\u0014X\rV5nKN$\u0018-\u001c9tQ\t9R/\u0001\u0015uKN$X*\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015mZ,ji\"4U\u000f^;sKRKW.Z:uC6\u00048\u000fF\u0002=\u0003;Aq!a\b\u0019\u0001\u0004\t\t#A\fnS:\u001cu.\u001c9bGRLwN\u001c'bO\u0016s\u0017M\u00197fIB\u0019A&a\t\n\u0007\u0005\u0015RFA\u0004C_>dW-\u00198\u0002)Q,7\u000f^\"p[B\f7\r^!oI\u0012+G.\u001a;fQ\tIR/A\ruKN$(+\u001a;f]RLwN\u001c)pY&\u001c\u0017p\u00115b]\u001e,\u0007F\u0001\u000ev\u0003-\"Xm\u001d;I_R\u001cX\r^*ju\u0016\u0014V\r^3oi&|gNR8s\u0007>l\u0007/Y2uK\u0012\u001cVmZ7f]R\u001c\bFA\u000ev\u0003\u001d\"Xm\u001d;I_R\u001cX\r\u001e*fi\u0016tG/[8o\r>\u00148i\\7qC\u000e$X\rZ*fO6,g\u000e^:)\u0005q)\u0018\u0001\b;fgR$U/\u00197D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\u001c\u0015\u0003;U\faA]3d_J$G\u0003EA \u0003\u0013\nI&!\u0018\u0002h\u0005-\u0014QOA=!\u0011\t\t%!\u0012\u000e\u0005\u0005\r#bAA\u001e)&!\u0011qIA\"\u00055iU-\\8ssJ+7m\u001c:eg\"9\u00111\n\u0010A\u0002\u00055\u0013aA6fsB)A&a\u0014\u0002T%\u0019\u0011\u0011K\u0017\u0003\r=\u0003H/[8o!\ra\u0013QK\u0005\u0004\u0003/j#aA%oi\"9\u00111\f\u0010A\u0002\u00055\u0013!\u0002<bYV,\u0007bBA0=\u0001\u0007\u0011\u0011M\u0001\ni&lWm\u001d;b[B\u00042\u0001LA2\u0013\r\t)'\f\u0002\u0005\u0019>tw\rC\u0005\u0002jy\u0001\n\u00111\u0001\u0002b\u0005Q\u0001O]8ek\u000e,'/\u00133\t\u0013\u00055d\u0004%AA\u0002\u0005=\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002-\u0003cJ1!a\u001d.\u0005\u0015\u0019\u0006n\u001c:u\u0011%\t9H\bI\u0001\u0002\u0004\t\u0019&\u0001\u0005tKF,XM\\2f\u0011%\tYH\bI\u0001\u0002\u0004\t\u0019&\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r[\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIQ*\"!!!+\t\u0005\u0005\u00141Q\u0016\u0003\u0003\u000b\u0003B!a\"\u0002\u00126\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)A\u0005v]\u000eDWmY6fI*\u0019\u0011qR\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0006%%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"/Z2pe\u0012$C-\u001a4bk2$H%N\u000b\u0003\u00033SC!a\u001c\u0002\u0004\u0006\u0001\"/Z2pe\u0012$C-\u001a4bk2$HEN\u000b\u0003\u0003?SC!a\u0015\u0002\u0004\u0006\u0001\"/Z2pe\u0012$C-\u001a4bk2$HeN\u0001\fC\n|'\u000f^'be.,'\u000f\u0006\u0006\u0002@\u0005\u001d\u0016\u0011VAV\u0003[Cq!a\u0018$\u0001\u0004\t\t\u0007C\u0004\u0002j\r\u0002\r!!\u0019\t\u000f\u000554\u00051\u0001\u0002p!9\u00111P\u0012A\u0002\u0005M\u0003")
public class TierCompactLogTest {
    private MergedLogHarness harness;
    private File logDir;
    private TopicPartition topicPartition;

    public MergedLogHarness harness() {
        return this.harness;
    }

    public void harness_$eq(MergedLogHarness x$1) {
        this.harness = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    @BeforeEach
    public void setUp() {
        File tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(tmpDir));
    }

    @AfterEach
    public void tearDown() {
        this.harness().destroy();
        this.harness_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletelyDeletedCompactedPartitionDeletesAllSegments() {
        void var39_36;
        void var38_35;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().advanceClock(10L);
        this.harness().log().flush(false);
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 2L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().flush(false);
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        Assertions.assertTrue((boolean)this.harness().takeStateSnapshot().tieredSegments().isEmpty());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer recordRead = (ListBuffer)tuple2._2();
        void offsetMap2 = var38_35;
        void recordRead2 = var39_36;
        Assertions.assertTrue((boolean)offsetMap2.isEmpty());
        Assertions.assertTrue((boolean)recordRead2.isEmpty());
        Assertions.assertFalse((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"there should be compacted segments ready for deletion");
        Assertions.assertTrue((this.harness().tierRetention() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"compacted segments should now be deleted");
    }

    @Test
    public void testZeroSizedSegmentIsNotArchived() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$1(seg))));
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        this.harness().advanceClock(10L);
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$2(seg))));
        Assertions.assertEquals((long)0L, (long)this.harness().log().size());
        this.harness().updateConfig(LogConfig$.MODULE$.TierEnableProp(), "true");
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)3)), 2L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).baseOffset());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).endOffset());
        Assertions.assertTrue((((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadNextOffsetTrackedCorrectlyForCompactedPartition() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertEquals((long)2L, (long)((LogSegment)this.harness().log().localLog().segments().values().head()).readNextOffset());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> read = this.harness().readKeysAndOffsets();
        this.harness().updateConfig(LogConfig$.MODULE$.TierEnableProp(), "true");
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(this.harness().readKeysAndOffsets(), read);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGrowableCompactBuffers() {
        void var35_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 2000, 86400000L, 0L, true, true, "compact", 2000, MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        int initialCompactBufferSize = 100;
        int maxCompactBufferSize = 10000;
        HarnessParams params = new HarnessParams(10000, -1, initialCompactBufferSize, maxCompactBufferSize, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        String longKey = new StringOps(Predef$.MODULE$.augmentString("f")).$times(1000);
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$22 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$22, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(2).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$6 = this.harness();
        boolean x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)var35_33.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset()), ListBuffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testThrottle() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        int throttleRateBytesPerSec = 100;
        int x$1 = 10000;
        int x$2 = -1;
        int x$3 = 10000;
        int x$4 = 10000;
        double x$5 = throttleRateBytesPerSec;
        int x$6 = -1;
        int x$7 = HarnessParams$.MODULE$.apply$default$6();
        HarnessParams params = new HarnessParams(x$1, x$2, x$3, x$4, x$5, x$7, x$6);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$1.appendAsLeader$default$4();
        RequestLocal x$12 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(2).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$16 = qual$2.appendAsLeader$default$4();
        RequestLocal x$17 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$3 = this.harness().log();
        Option x$18 = qual$3.roll$default$1();
        long x$19 = qual$3.roll$default$2();
        qual$3.roll(x$18, x$19);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$20 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$21 = 0;
        AppendOrigin.Client$ x$22 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$23 = qual$4.appendAsLeader$default$4();
        RequestLocal x$24 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$20, x$21, (AppendOrigin)x$22, x$23, x$24);
        MergedLog qual$5 = this.harness().log();
        Option x$25 = qual$5.roll$default$1();
        long x$26 = qual$5.roll$default$2();
        qual$5.roll(x$25, x$26);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        long bytesToRead = this.harness().log().tierPartitionState().totalSize() * 2L;
        long beforeTime = this.harness().log().localLog().time().milliseconds();
        MergedLogHarness qual$6 = this.harness();
        boolean x$27 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$27);
        long wroteBytes = this.harness().log().tierPartitionState().totalSize();
        long afterTime = this.harness().log().localLog().time().milliseconds();
        long shouldTake = (bytesToRead + wroteBytes) * 1000L / (long)throttleRateBytesPerSec;
        long took = afterTime - beforeTime;
        Assertions.assertTrue(((double)Math.abs(shouldTake - took) / (double)took < 0.01 ? 1 : 0) != 0, (String)"should have throttled within 1% ");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoAbortedTransactionsRetained() {
        void var58_56;
        void var57_55;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)4, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(5L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$18 = this.abortMarker(6L, 1L, (short)0, -1);
        int x$19 = 0;
        AppendOrigin.Coordinator$ x$20 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$21 = qual$5.appendAsLeader$default$4();
        RequestLocal x$22 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$18, x$19, (AppendOrigin)x$20, x$21, x$22);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$23 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)6, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(7L, Integer.toString(7).getBytes(), Integer.toString(7).getBytes()), new SimpleRecord(8L, Integer.toString(8).getBytes(), Integer.toString(8).getBytes())});
        int x$24 = 0;
        AppendOrigin.Client$ x$25 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$26 = qual$6.appendAsLeader$default$4();
        RequestLocal x$27 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$23, x$24, (AppendOrigin)x$25, x$26, x$27);
        MergedLog qual$7 = this.harness().log();
        Option x$28 = qual$7.roll$default$1();
        long x$29 = qual$7.roll$default$2();
        qual$7.roll(x$28, x$29);
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$30 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)8, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(9).getBytes(), Integer.toString(9).getBytes()), new SimpleRecord(10L, Integer.toString(10).getBytes(), Integer.toString(10).getBytes())});
        int x$31 = 0;
        AppendOrigin.Client$ x$32 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$33 = qual$8.appendAsLeader$default$4();
        RequestLocal x$34 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$30, x$31, (AppendOrigin)x$32, x$33, x$34);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$35 = this.abortMarker(11L, 1L, (short)0, -1);
        int x$36 = 0;
        AppendOrigin.Coordinator$ x$37 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$38 = qual$9.appendAsLeader$default$4();
        RequestLocal x$39 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$35, x$36, (AppendOrigin)x$37, x$38, x$39);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        boolean x$40 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$40);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var57_55;
        void records2 = var58_56;
        Assertions.assertEquals((int)4, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)offsetMap2.size());
        Assertions.assertEquals((long)9L, (long)BoxesRunTime.unboxToLong(offsetMap2.get(new Some((Object)Integer.toString(9)))));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong(offsetMap2.get(new Some((Object)Integer.toString(10)))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAbortedTransactionsRetained() {
        void var30_29;
        void var29_28;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$11 = this.abortMarker(4L, 1L, (short)0, -1);
        int x$12 = 0;
        AppendOrigin.Coordinator$ x$13 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        Option x$16 = qual$4.roll$default$1();
        long x$17 = qual$4.roll$default$2();
        qual$4.roll(x$16, x$17);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$5 = this.harness();
        boolean x$18 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$18);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var29_28;
        void records2 = var30_29;
        Assertions.assertEquals((int)1, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOngoingAbortedTransactionsRetained() {
        void var34_32;
        void var33_31;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = this.abortMarker(4L, 1L, (short)0, -1);
        int x$14 = 0;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().log().maybeUpdateHighWatermarkAndRecoveryPoint(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$6 = this.harness();
        boolean x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var33_31;
        void records2 = var34_32;
        Assertions.assertEquals((int)1, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAndOngoingAbortedTransactionsRetained() {
        void var60_59;
        void var59_58;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)2L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(3L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$11 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)2L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(5L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$12 = 0;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$16 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(6L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(7L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$21 = this.abortMarker(8L, 2L, (short)0, -1);
        int x$22 = 0;
        AppendOrigin.Coordinator$ x$23 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, x$22, (AppendOrigin)x$23, x$24, x$25);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$26 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)3L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(10L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())});
        int x$27 = 0;
        AppendOrigin.Client$ x$28 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, x$27, (AppendOrigin)x$28, x$29, x$30);
        MergedLog qual$7 = this.harness().log();
        Option x$31 = qual$7.roll$default$1();
        long x$32 = qual$7.roll$default$2();
        qual$7.roll(x$31, x$32);
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$33 = this.abortMarker(8L, 3L, (short)0, -1);
        int x$34 = 0;
        AppendOrigin.Coordinator$ x$35 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$36 = qual$8.appendAsLeader$default$4();
        RequestLocal x$37 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$33, x$34, (AppendOrigin)x$35, x$36, x$37);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$38 = this.abortMarker(8L, 1L, (short)0, -1);
        int x$39 = 0;
        AppendOrigin.Coordinator$ x$40 = AppendOrigin.Coordinator$.MODULE$;
        MetadataVersion x$41 = qual$9.appendAsLeader$default$4();
        RequestLocal x$42 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$38, x$39, (AppendOrigin)x$40, x$41, x$42);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        boolean x$43 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$43);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var59_58;
        void records2 = var60_59;
        Assertions.assertEquals((int)3, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    @Test
    public void testMinCompactionLagEnabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(true);
    }

    @Test
    public void testMinCompactionLagDisabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testMinCompactionLagWithFutureTimestamps(boolean minCompactionLagEnabled) {
        void var64_53;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        int minCompactionLagMs = minCompactionLagEnabled ? 1 : 0;
        long x$1 = -1L;
        long x$2 = 1L;
        long x$3 = -1L;
        long x$4 = 0L;
        int x$5 = 100;
        long x$6 = 86400000L;
        long x$72 = 0L;
        boolean x$82 = true;
        boolean x$92 = true;
        String x$102 = "compact";
        long x$11 = minCompactionLagMs;
        int x$12 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$11();
        int x$13 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$12();
        int x$14 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$13();
        long x$15 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$14();
        boolean x$16 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$15();
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$72, x$82, x$92, x$102, x$12, x$13, x$14, x$15, x$16, x$11);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$17 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(10L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(10L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$18 = 0;
        AppendOrigin.Client$ x$19 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, x$18, (AppendOrigin)x$19, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$24 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(20L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(20L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$25 = 0;
        AppendOrigin.Client$ x$26 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, x$25, (AppendOrigin)x$26, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$31 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(30L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(30L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$32 = 0;
        AppendOrigin.Client$ x$33 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, x$32, (AppendOrigin)x$33, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(25L);
        MergedLogHarness qual$7 = this.harness();
        boolean x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        if (minCompactionLagEnabled) {
            void var62_51;
            Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
            Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer records = (ListBuffer)tuple2._2();
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "2", "3"})), (Object)var62_51.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "20", "200", "300"})), (Object)var62_51.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
            return;
        }
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var64_53.map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var64_53.map((Function1 & Serializable & scala.Serializable)x$10 -> (String)x$10.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompactAndDelete() {
        void var36_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact,delete", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$112 = qual$3.appendAsLeader$default$4();
        RequestLocal x$122 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$112, x$122);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$15 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$16 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, x$16, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().log().deleteOldSegments();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$12 -> (String)x$12.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetentionPolicyChange() {
        void var38_35;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "delete", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$132 = qual$4.roll$default$1();
        long x$142 = qual$4.roll$default$2();
        qual$4.roll(x$132, x$142);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$15 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$16 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, x$16, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().updateConfig(LogConfig$.MODULE$.CleanupPolicyProp(), "delete,compact");
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        this.harness().log().deleteOldSegments();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var38_35.map((Function1 & Serializable & scala.Serializable)x$13 -> (String)x$13.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var38_35.map((Function1 & Serializable & scala.Serializable)x$14 -> (String)x$14.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHotsetSizeRetentionForCompactedSegments() {
        void var36_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, -1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$152 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(0).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(0).getBytes(), Integer.toString(300).getBytes())});
        int x$162 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$152, x$162, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().log().deleteOldSegments();
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"300"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$16 -> (String)x$16.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHotsetRetentionForCompactedSegments() {
        void var36_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, -1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$15 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$16 = 0;
        AppendOrigin.Client$ x$172 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$182 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, x$16, (AppendOrigin)x$172, x$182, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)1, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)3, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$17 -> (String)x$17.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$18 -> (String)x$18.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDualCompactionValidation() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        long x$1 = -1L;
        long x$2 = 1L;
        long x$3 = -1L;
        long x$4 = -1L;
        int x$5 = 100;
        long x$6 = 86400000L;
        long x$7 = 0L;
        boolean x$8 = true;
        boolean x$9 = true;
        String x$10 = "compact";
        boolean x$11 = true;
        int x$12 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$11();
        int x$13 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$12();
        int x$14 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$13();
        long x$15 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$14();
        long x$16 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$16();
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$12, x$13, x$14, x$15, x$11, x$16);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$17 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$18 = 0;
        AppendOrigin.Client$ x$19 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, x$18, (AppendOrigin)x$19, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$24 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$25 = 0;
        AppendOrigin.Client$ x$26 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, x$25, (AppendOrigin)x$26, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$31 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$32 = 0;
        AppendOrigin.Client$ x$33 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, x$32, (AppendOrigin)x$33, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)0, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        boolean x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationPassedPerSec().meanRate());
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().meanRate());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        LogToClean logToClean = new LogToClean(this.topicPartition(), (AbstractLog)this.harness().log(), 0L, this.harness().log().tierPartitionState().committedEndOffset() + 1L, LogToClean$.MODULE$.apply$default$5());
        Assertions.assertEquals((long)0L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)this.harness().log().tierPartitionState().totalSize(), (long)logToClean.cleanableBytes());
        Assertions.assertEquals((long)this.harness().log().sizeDetails().localSize(), (long)(logToClean.cleanBytes() + logToClean.cleanableBytes() + logToClean.uncleanableBytes()));
        MergedLogHarness qual$8 = this.harness();
        boolean x$39 = qual$8.maybeClean$default$1();
        Tuple2<Object, Object> dirtyOffsets = qual$8.maybeClean(x$39);
        Assertions.assertTrue((this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationPassedPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().meanRate());
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$40 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(3).getBytes(), Integer.toString(3000).getBytes()), new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4000).getBytes())});
        int x$41 = 0;
        AppendOrigin.Client$ x$42 = AppendOrigin.Client$.MODULE$;
        MetadataVersion x$43 = qual$9.appendAsLeader$default$4();
        RequestLocal x$44 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$40, x$41, (AppendOrigin)x$42, x$43, x$44);
        MergedLog qual$10 = this.harness().log();
        Option x$45 = qual$10.roll$default$1();
        long x$46 = qual$10.roll$default$2();
        qual$10.roll(x$45, x$46);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().simulateDataLoss();
        LogToClean logToClean2 = new LogToClean(this.topicPartition(), (AbstractLog)this.harness().log(), dirtyOffsets._1$mcJ$sp(), this.harness().log().tierPartitionState().committedEndOffset() + 1L, LogToClean$.MODULE$.apply$default$5());
        Assertions.assertEquals((long)this.harness().log().sizeDetails().localSize(), (long)(logToClean2.cleanBytes() + logToClean2.cleanableBytes() + logToClean2.uncleanableBytes()));
        this.harness().maybeClean(false);
    }

    private MemoryRecords record(Option<Object> key, Option<Object> value, long timestamp, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, (byte[])key.map((Function1 & Serializable & scala.Serializable)x$19 -> TierCompactLogTest.$anonfun$record$1(BoxesRunTime.unboxToInt((Object)x$19))).orNull(Predef$.MODULE$.$conforms()), (byte[])value.map((Function1 & Serializable & scala.Serializable)x$20 -> TierCompactLogTest.$anonfun$record$2(BoxesRunTime.unboxToInt((Object)x$20))).orNull(Predef$.MODULE$.$conforms()))});
    }

    private long record$default$4() {
        return -1L;
    }

    private short record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private int record$default$7() {
        return -1;
    }

    private MemoryRecords abortMarker(long timestamp, long producerId, short producerEpoch, int partitionLeaderEpoch) {
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
        return MemoryRecords.withEndTransactionMarker((long)0L, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$1(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$2(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 6L;
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 8L && rec.producerId() == 2L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L && rec.producerId() == 3L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 12L && rec.producerId() == 1L;
    }

    public static final /* synthetic */ byte[] $anonfun$record$1(int x$19) {
        return Integer.toString(x$19).getBytes();
    }

    public static final /* synthetic */ byte[] $anonfun$record$2(int x$20) {
        return Integer.toString(x$20).getBytes();
    }
}

