/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.CorruptIndexException;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4A\u0001F\u000b\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001a\u0001\n\u00031\u0003b\u0002\u0016\u0001\u0001\u0004%\ta\u000b\u0005\u0007c\u0001\u0001\u000b\u0015B\u0014\t\u000fI\u0002!\u0019!C\u0001g!1q\u0007\u0001Q\u0001\nQBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\u0006\u001b\u0002!\ta\u0010\u0005\u0006%\u0002!\ta\u0010\u0005\u0006/\u0002!\ta\u0010\u0005\u00063\u0002!\ta\u0010\u0005\u00067\u0002!\ta\u0010\u0005\u0006;\u0002!\ta\u0010\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006[\u0002!\ta\u0010\u0005\u0006_\u0002!\ta\u0010\u0002\u000e)&lW-\u00138eKb$Vm\u001d;\u000b\u0005Y9\u0012a\u00017pO*\t\u0001$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002+\u0005\u0019\u0011\u000e\u001a=\u0016\u0003\u001d\u0002\"\u0001\n\u0015\n\u0005%*\"!\u0003+j[\u0016Le\u000eZ3y\u0003\u001dIG\r_0%KF$\"\u0001L\u0018\u0011\u0005qi\u0013B\u0001\u0018\u001e\u0005\u0011)f.\u001b;\t\u000fA\u001a\u0011\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\u0002\t%$\u0007\u0010I\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#\u0001\u001b\u0011\u0005q)\u0014B\u0001\u001c\u001e\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006cCN,wJ\u001a4tKR,\u0012A\u000f\t\u00039mJ!\u0001P\u000f\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%A\u0003tKR,\b\u000fF\u0001-Q\tI\u0011\t\u0005\u0002C\u00176\t1I\u0003\u0002E\u000b\u0006\u0019\u0011\r]5\u000b\u0005\u0019;\u0015a\u00026va&$XM\u001d\u0006\u0003\u0011&\u000bQA[;oSRT\u0011AS\u0001\u0004_J<\u0017B\u0001'D\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u0012!b\u0014\t\u0003\u0005BK!!U\"\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0003;fgRdun\\6Va\"\u00121\u0002\u0016\t\u0003\u0005VK!AV\"\u0003\tQ+7\u000f^\u0001\ni\u0016\u001cH/\u00128uefD#\u0001\u0004+\u0002#Q,7\u000f^#oiJLxJ^3sM2|w\u000f\u000b\u0002\u000e)\u0006aA/Z:u)J,hnY1uK\"\u0012a\u0002V\u0001\u000bi\u0016\u001cH/\u00119qK:$\u0007FA\bU\u00035\t\u0007\u000f]3oI\u0016sGO]5fgR\u0011A&\u0019\u0005\u0006EB\u0001\r\u0001N\u0001\u000b]VlWI\u001c;sS\u0016\u001c\u0018a\u00058p]\u0016C\u0018n\u001d;b]R$V-\u001c9GS2,G#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017AA5p\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\t\u0019KG.Z\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\u0012!\u0003V\u0001\u000bi\u0016\u001cHOU3pa\u0016t\u0007FA\nU\u0001")
public class TimeIndexTest {
    private TimeIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistantTempFile(), this.baseOffset(), this.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4(), TimeIndex$.MODULE$.$lessinit$greater$default$5()));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void testLookUp() {
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testEntry() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(10L, 55L), (Object)this.idx().entry(0));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().entry(1));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().entry(2));
        Assertions.assertEquals((Object)new TimestampOffset(40L, 85L), (Object)this.idx().entry(3));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assertions.assertEquals((int)0, (int)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assertions.assertEquals((int)0, (int)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = 10000L;
            long x$2 = 1000L;
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        });
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().maybeAppend(10000L, (long)((this.maxEntries() - 2) * 10), true));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = i * 10;
            long x$2 = (long)(i * 10) + this.baseOffset();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        });
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, shouldCorruptOffset, shouldCorruptTimestamp, firstEntry, shouldCorruptLength){
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset();
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp() - 1L : superLastEntry.timestamp();
                return new TimestampOffset(timestamp, offset);
            }

            /*
             * WARNING - void declaration
             */
            public long length() {
                void var1_1;
                long superLength = super.length();
                if (this.shouldCorruptLength$1.elem) {
                    return superLength - 1L;
                }
                return (long)var1_1;
            }
            {
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, true, TimeIndex$.MODULE$.$lessinit$greater$default$5());
            }
        });
        shouldCorruptOffset.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    @Test
    public void testReopen() {
        this.appendEntries(5);
        Assertions.assertEquals((int)5, (int)this.idx().entries());
        this.idx().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new TimeIndex(this.idx().file(), this.baseOffset(), this.maxEntries() * 12, false, TimeIndex$.MODULE$.$lessinit$greater$default$5()));
        this.idx_$eq(new TimeIndex(this.idx().file(), this.baseOffset(), this.maxEntries() * 12, true, TimeIndex$.MODULE$.$lessinit$greater$default$5()));
        Assertions.assertEquals((int)5, (int)this.idx().entries());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            int timestamp = i * 10;
            long offset = (long)(i * 10) + this.baseOffset();
            Assertions.assertEquals((Object)new TimestampOffset((long)timestamp, offset), (Object)this.idx().lookup((long)timestamp));
        });
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

