/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.metrics.BrokerWithMember;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterIntegrationTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tms!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002\u001a\u0002\t\u0013\u0019\u0004\"\u0002\u001a\u0002\t\u0003!f\u0001\u0002\u0015\"\u0001}CQ\u0001M\u0003\u0005\u00021DqA\\\u0003C\u0002\u0013\u0005q\u000e\u0003\u0004t\u000b\u0001\u0006I\u0001\u001d\u0005\bi\u0016\u0011\r\u0011\"\u0001p\u0011\u0019)X\u0001)A\u0005a\"9a/\u0002b\u0001\n\u00039\bBB>\u0006A\u0003%\u0001\u0010C\u0004}\u000b\u0001\u0007I\u0011A?\t\u0013\u0005%R\u00011A\u0005\u0002\u0005-\u0002bBA\u001c\u000b\u0001\u0006KA \u0005\n\u0003s)\u0001\u0019!C\u0001\u0003wA\u0011\"a\u0013\u0006\u0001\u0004%\t!!\u0014\t\u0011\u0005ES\u0001)Q\u0005\u0003{Aq!a\u0015\u0006\t\u0003\t)\u0006C\u0004\u0002f\u0015!\t!a\u001a\t\u000f\u0005}T\u0001\"\u0001\u0002h!9\u0011\u0011R\u0003\u0005\u0002\u0005-\u0005bBA]\u000b\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b,A\u0011BAd\u0011\u001d\t\t/\u0002C\u0005\u0003GDq!a:\u0006\t\u0013\tI\u000fC\u0005\u0003\u0012\u0015\t\n\u0011\"\u0003\u0003\u0014!I!\u0011F\u0003\u0012\u0002\u0013%!1\u0003\u0005\b\u0005W)A\u0011\u0002B\u0017\u0011%\u0011i$BI\u0001\n\u0013\u0011y\u0004C\u0004\u0003D\u0015!IA!\u0012\u0002C\r{gn];nKJd\u0015mZ#nSR$XM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\t\u001a\u0013aB7fiJL7m\u001d\u0006\u0002I\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005\t#!I\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$8CA\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AJ\u0001\u0015M&tGM\u0011:pW\u0016\u0014x+\u001b;i\u001b\u0016l'-\u001a:\u0015\u0007Q:t\t\u0005\u0002(k%\u0011a'\t\u0002\u0011\u0005J|7.\u001a:XSRDW*Z7cKJDQ\u0001O\u0002A\u0002e\nqA\u0019:pW\u0016\u00148\u000fE\u0002;\u007f\u0005k\u0011a\u000f\u0006\u0003yu\nq!\\;uC\ndWM\u0003\u0002?Y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001[$A\u0002\"vM\u001a,'\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002EG\u000511/\u001a:wKJL!AR\"\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u0005\u0006\u0011\u000e\u0001\r!S\u0001\u0006OJ|W\u000f\u001d\t\u0003\u0015Fs!aS(\u0011\u00051cS\"A'\u000b\u00059+\u0013A\u0002\u001fs_>$h(\u0003\u0002QY\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001F\u0006F\u00025+zCQ\u0001\u000f\u0003A\u0002Y\u00032a\u0016/B\u001b\u0005A&BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0005\u0019&\u001cH\u000fC\u0003I\t\u0001\u0007\u0011jE\u0002\u0006A\u001a\u0004\"!\u00193\u000e\u0003\tT!aY\u0012\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003K\n\u0014acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u000e\nQ!\u001e;jYNL!a\u001b5\u0003\u000f1{wmZ5oOR\tQ\u000e\u0005\u0002(\u000b\u0005Aa.^7O_\u0012,7/F\u0001q!\tY\u0013/\u0003\u0002sY\t\u0019\u0011J\u001c;\u0002\u00139,XNT8eKN\u0004\u0013\u0001\u00038v[B\u000b'\u000f^:\u0002\u00139,X\u000eU1siN\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003a\u0004\"aV=\n\u0005iD&A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\nG>t7/^7feN,\u0012A \t\u0005u}\f\u0019!C\u0002\u0002\u0002m\u00121aU3u!!\t)!!\u0007\u0002\u001e\u0005uQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0011\r|gn];nKJTA!!\u0004\u0002\u0010\u000591\r\\5f]R\u001c(b\u0001\u0013\u0002\u0012)!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u000f\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#B\u0016\u0002 \u0005\r\u0012bAA\u0011Y\t)\u0011I\u001d:bsB\u00191&!\n\n\u0007\u0005\u001dBF\u0001\u0003CsR,\u0017!D2p]N,X.\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005M\u0002cA\u0016\u00020%\u0019\u0011\u0011\u0007\u0017\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003kq\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u0015\r|gn];nKJ\u001c\b%\u0001\u0004bI6Lgn]\u000b\u0003\u0003{\u0001BAO@\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005-\u0011!B1e[&t\u0017\u0002BA%\u0003\u0007\u0012Q!\u00113nS:\f!\"\u00193nS:\u001cx\fJ3r)\u0011\ti#a\u0014\t\u0013\u0005U\u0012#!AA\u0002\u0005u\u0012aB1e[&t7\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\u0011\u0011q\u000b\t\u0007\u00033\nY&a\u0018\u000e\u0003uJ1!!\u0018>\u0005\r\u0019V-\u001d\t\u0004\u0005\u0006\u0005\u0014bAA2\u0007\nY1*\u00194lC\u000e{gNZ5h\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003\u0003[A3\u0001FA6!\u0011\ti'a\u001f\u000e\u0005\u0005=$\u0002BA9\u0003g\n1!\u00199j\u0015\u0011\t)(a\u001e\u0002\u000f),\b/\u001b;fe*!\u0011\u0011PA\u000b\u0003\u0015QWO\\5u\u0013\u0011\ti(a\u001c\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005tQV$Hm\\<oQ\r)\u00121\u0011\t\u0005\u0003[\n))\u0003\u0003\u0002\b\u0006=$!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;D_:\u001cX/\\3s\u0019\u0006<W*\u001a;sS\u000e\u001cH\u0003BA\u0017\u0003\u001bCa!a$\u0017\u0001\u0004I\u0015AB9v_J,X\u000eK\u0004\u0017\u0003'\u000b\u0019+!*\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002\u001e\u0006M\u0014A\u00029be\u0006l7/\u0003\u0003\u0002\"\u0006]%a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002(\u0006-\u0016EAAU\u0003\tQ8.\t\u0002\u0002.\u0006)1N]1gi\"\u001aa#!-\u0011\t\u0005M\u0016QW\u0007\u0003\u00037KA!a.\u0002\u001c\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u00021Q,7\u000f\u001e%b]\u0012dWm\u0012:pkBl\u0015n\u001a:bi&|g\u000e\u0006\u0003\u0002.\u0005u\u0006BBAH/\u0001\u0007\u0011\nK\u0004\u0018\u0003'\u000b\u0019+!1-\t\u0005\u001d\u00161\u0016\u0015\u0004/\u0005E\u0016!\u0005<fe&4\u0017pQ8ogVlWM\u001d'bORA\u0011QFAe\u0003\u001b\f9\u000e\u0003\u0004\u0002Lb\u0001\r\u0001N\u0001\u0011EJ|7.\u001a:XSRDW*Z7cKJDq!a4\u0019\u0001\u0004\t\t.\u0001\u0003uC\u001e\u001c\b#\u0002\u001e\u0002T&K\u0015bAAkw\t\u0019Q*\u00199\t\u000f\u0005e\u0007\u00041\u0001\u0002\\\u0006\u0019R\r\u001f9fGR,GmQ8ogVlWM\u001d'bOB\u00191&!8\n\u0007\u0005}GF\u0001\u0003M_:<\u0017a\b<fe&4\u0017pQ8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;fe2\u000bG/\u001a8dsR!\u0011QFAs\u0011\u0019\tY-\u0007a\u0001i\u0005!\u0012n]'fiJL7MV1mk\u0016LeNU1oO\u0016$\u0002\"a;\u0002r\n%!Q\u0002\t\u0004W\u00055\u0018bAAxY\t9!i\\8mK\u0006t\u0007bBAz5\u0001\u0007\u0011Q_\u0001\fW\u000647.Y'fiJL7\rE\u0003,\u0003o\fY0C\u0002\u0002z2\u0012aa\u00149uS>t\u0007\u0003BA\u007f\u0005\u000bi!!a@\u000b\u0007\t\u0012\tA\u0003\u0003\u0003\u0004\u0005=\u0011AB2p[6|g.\u0003\u0003\u0003\b\u0005}(aC&bM.\fW*\u001a;sS\u000eD\u0011Ba\u0003\u001b!\u0003\u0005\r!a7\u0002\u00151|w/\u001a:C_VtG\rC\u0005\u0003\u0010i\u0001\n\u00111\u0001\u0002\\\u0006QQ\u000f\u001d9fe\n{WO\u001c3\u0002=%\u001cX*\u001a;sS\u000e4\u0016\r\\;f\u0013:\u0014\u0016M\\4fI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u000bU\u0011\tYNa\u0006,\u0005\te\u0001\u0003\u0002B\u000e\u0005Ki!A!\b\u000b\t\t}!\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\t-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005O\u0011iBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa$[:NKR\u0014\u0018n\u0019,bYV,\u0017J\u001c*b]\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r\u0014X-\u0019;f\u0007>t7/^7feRA\u00111\u0001B\u0018\u0005g\u00119\u0004\u0003\u0004\u00032u\u0001\r!S\u0001\u000bEJ|7.\u001a:MSN$\bB\u0002B\u001b;\u0001\u0007\u0011*A\u0004he>,\b/\u00133\t\u0013\teR\u0004%AA\u0002\tm\u0012aD4s_V\u0004\u0018J\\:uC:\u001cW-\u00133\u0011\t-\n90S\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B!U\u0011\u0011YDa\u0006\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0003\u0002@\t\u001d\u0003b\u0002B%?\u0001\u0007!1J\u0001\u000bC\u0012l\u0017N\u001c)s_B\u001c\bC\u0002&\u0003N%\u0013y%C\u0002\u0002VN\u0003BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0004\u0005+R\u0016\u0001\u00027b]\u001eLAA!\u0017\u0003T\t1qJ\u00196fGR\u0004")
public class ConsumerLagEmitterIntegrationTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private scala.collection.mutable.Set<KafkaConsumer<byte[], byte[]>> consumers;
    private scala.collection.mutable.Set<Admin> admins;

    public static BrokerWithMember findBrokerWithMember(java.util.List<KafkaBroker> list, String string) {
        return ConsumerLagEmitterIntegrationTest$.MODULE$.findBrokerWithMember(list, string);
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public scala.collection.mutable.Set<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public void consumers_$eq(scala.collection.mutable.Set<KafkaConsumer<byte[], byte[]>> x$1) {
        this.consumers = x$1;
    }

    public scala.collection.mutable.Set<Admin> admins() {
        return this.admins;
    }

    public void admins_$eq(scala.collection.mutable.Set<Admin> x$1) {
        this.admins = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$2 -> KafkaConfig$.MODULE$.fromProps(x$2, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @BeforeEach
    public void initialize() {
        this.consumers_$eq((scala.collection.mutable.Set<KafkaConsumer<byte[], byte[]>>)Set$.MODULE$.empty());
        this.admins_$eq((scala.collection.mutable.Set<Admin>)Set$.MODULE$.empty());
    }

    @AfterEach
    public void shutdown() {
        this.consumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.admins().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConsumerLagMetrics(String quorum) {
        .colon.colon tenants = new .colon.colon((Object)"lkc-xxxxx", (List)new .colon.colon((Object)"lkc-yyyyy", (List)Nil$.MODULE$));
        List topics = (List)tenants.map((Function1 & Serializable & scala.Serializable)tenant -> new StringBuilder(20).append((String)tenant).append("_external.test.topic").toString(), List$.MODULE$.canBuildFrom());
        List groups = (List)tenants.map((Function1 & Serializable & scala.Serializable)tenant -> new StringBuilder(11).append((String)tenant).append("_test-group").toString(), List$.MODULE$.canBuildFrom());
        List groupInstances = (List)tenants.map((Function1 & Serializable & scala.Serializable)tenant -> new StringBuilder(15).append("group-instance-").append((String)tenant).toString(), List$.MODULE$.canBuildFrom());
        List numMessagesList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{300, 600}));
        List expectedConsumerLags = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{500, 1000}));
        int numPartitions = 1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach((Function1 & Serializable & scala.Serializable)index -> ConsumerLagEmitterIntegrationTest.$anonfun$testConsumerLagMetrics$4(this, topics, numPartitions, numMessagesList, BoxesRunTime.unboxToInt((Object)index)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.bootstrapServers(this.bootstrapServers$default$1()), (String)groups.apply(index), (Option<String>)new Some(groupInstances.apply(index)));
            consumer.subscribe(Collections.singleton(topics.apply(index)));
            TestUtils$.MODULE$.consumeRecords(consumer, BoxesRunTime.unboxToInt((Object)numMessagesList.apply(index)), TestUtils$.MODULE$.consumeRecords$default$3());
            consumer.commitSync();
        });
        ArrayBuffer brokersWithMembers = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach((Function1 & Serializable & scala.Serializable)index -> brokersWithMembers.$plus$eq((Object)ConsumerLagEmitterIntegrationTest$.MODULE$.kafka$metrics$ConsumerLagEmitterIntegrationTest$$findBrokerWithMember(this.brokers(), (String)groups.apply(BoxesRunTime.unboxToInt((Object)index)))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ConsumerLagEmitterIntegrationTest.$anonfun$testConsumerLagMetrics$7(this, (List)tenants, groupInstances, brokersWithMembers, topics, expectedConsumerLags, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testHandleGroupMigration(String quorum) {
        String topic = "test-topic";
        String group = "test-group";
        int numMessages = 1000;
        int expectedConsumerLag = 1500;
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.bootstrapServers(this.bootstrapServers$default$1()), group, this.createConsumer$default$3());
        Admin admin = this.createAdminClient((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))));
        consumer.subscribe(Collections.singleton(topic));
        TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3());
        consumer.commitSync();
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, expectedConsumerLag, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        BrokerWithMember brokerWithMember = ConsumerLagEmitterIntegrationTest$.MODULE$.kafka$metrics$ConsumerLagEmitterIntegrationTest$$findBrokerWithMember(this.brokers(), group);
        scala.collection.mutable.Map tags = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"test-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)brokerWithMember.member().memberId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)brokerWithMember.member().clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"0")}));
        this.verifyConsumerLag(brokerWithMember, (scala.collection.mutable.Map<String, String>)tags, expectedConsumerLag);
        this.verifyConsumerLagEmitterLatency(brokerWithMember);
        scala.collection.mutable.Map describedTopics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)admin.describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"__consumer_offsets", (List)Nil$.MODULE$)).asJava()).allTopicNames().get()).asScala();
        Assertions.assertEquals((int)1, (int)describedTopics.keySet().size());
        java.util.List topicPartitionInfoList = (java.util.List)((IterableLike)describedTopics.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            java.util.List list = ((TopicDescription)x0$1._2()).partitions();
            return list;
        }, Iterable$.MODULE$.canBuildFrom())).head();
        java.util.Map reversedReplicasReassignment = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPartitionInfoList).asScala()).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            java.util.List reversedReplicas = (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionInfo.replicas()).asScala()).reverse()).map((Function1 & Serializable & scala.Serializable)node -> node.id(), Buffer$.MODULE$.canBuildFrom())).asJava();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", partitionInfo.partition())), Optional.of(new NewPartitionReassignment(reversedReplicas)));
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        admin.alterPartitionReassignments(reversedReplicasReassignment).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerLagEmitterIntegrationTest.$anonfun$testHandleGroupMigration$4(admin)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerLagEmitterIntegrationTest.$anonfun$testHandleGroupMigration$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.Set topicPartitions = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPartitionInfoList).asScala()).map((Function1 & Serializable & scala.Serializable)partitionInfo -> new TopicPartition("__consumer_offsets", partitionInfo.partition()), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava();
        admin.electLeaders(ElectionType.PREFERRED, topicPartitions).all().get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerLagEmitterIntegrationTest.$anonfun$testHandleGroupMigration$7(brokerWithMember, tags)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerLagEmitterIntegrationTest.$anonfun$testHandleGroupMigration$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, expectedConsumerLag, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        BrokerWithMember brokerWithMigratedMember = ConsumerLagEmitterIntegrationTest$.MODULE$.kafka$metrics$ConsumerLagEmitterIntegrationTest$$findBrokerWithMember(this.brokers(), group);
        Assertions.assertNotEquals((int)brokerWithMember.broker().config().brokerId(), (int)brokerWithMigratedMember.broker().config().brokerId());
        tags.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)brokerWithMigratedMember.member().memberId()));
        tags.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)brokerWithMigratedMember.member().clientId()));
        this.verifyConsumerLag(brokerWithMigratedMember, (scala.collection.mutable.Map<String, String>)tags, 2 * expectedConsumerLag);
        this.verifyConsumerLagEmitterLatency(brokerWithMigratedMember);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConsumerLag(BrokerWithMember brokerWithMember, scala.collection.mutable.Map<String, String> tags, long expectedConsumerLag) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerLagEmitterIntegrationTest.$anonfun$verifyConsumerLag$1(brokerWithMember, tags, expectedConsumerLag)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerLagEmitterIntegrationTest.$anonfun$verifyConsumerLag$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConsumerLagEmitterLatency(BrokerWithMember brokerWithMember) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerLagEmitterIntegrationTest.$anonfun$verifyConsumerLagEmitterLatency$1(this, brokerWithMember)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerLagEmitterIntegrationTest.$anonfun$verifyConsumerLagEmitterLatency$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Metrics metrics = brokerWithMember.broker().metrics();
        Option kafkaMetric = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).get((Object)metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        Assertions.assertTrue((boolean)this.isMetricValueInRange((Option<KafkaMetric>)kafkaMetric, this.isMetricValueInRange$default$2(), this.isMetricValueInRange$default$3()));
    }

    private boolean isMetricValueInRange(Option<KafkaMetric> kafkaMetric, long lowerBound, long upperBound) {
        return kafkaMetric.exists((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)ConsumerLagEmitterIntegrationTest.$anonfun$isMetricValueInRange$1(lowerBound, upperBound, metric)));
    }

    private long isMetricValueInRange$default$2() {
        return 0L;
    }

    private long isMetricValueInRange$default$3() {
        return 1000L;
    }

    private KafkaConsumer<byte[], byte[]> createConsumer(String brokerList, String groupId, Option<String> groupInstanceId) {
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, groupId, groupInstanceId, TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11(), TestUtils$.MODULE$.createConsumer$default$12());
        this.consumers().$plus$eq(consumer);
        return consumer;
    }

    private Option<String> createConsumer$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Admin createAdminClient(scala.collection.immutable.Map<String, Object> adminProps) {
        void var2_2;
        Admin admin = Admin.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(adminProps).asJava()));
        this.admins().$plus$eq((Object)admin);
        return var2_2;
    }

    public static final /* synthetic */ Seq $anonfun$testConsumerLagMetrics$4(ConsumerLagEmitterIntegrationTest $this, List topics$1, int numPartitions$1, List numMessagesList$1, int index) {
        $this.createTopic((String)topics$1.apply(index), numPartitions$1, $this.createTopic$default$3(), $this.createTopic$default$4(), $this.createTopic$default$5(), $this.createTopic$default$6());
        return TestUtils$.MODULE$.generateAndProduceMessages($this.brokers(), (String)topics$1.apply(index), BoxesRunTime.unboxToInt((Object)numMessagesList$1.apply(index)), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
    }

    public static final /* synthetic */ void $anonfun$testConsumerLagMetrics$7(ConsumerLagEmitterIntegrationTest $this, List tenants$1, List groupInstances$1, ArrayBuffer brokersWithMembers$1, List topics$1, List expectedConsumerLags$1, int index) {
        scala.collection.mutable.Map tags = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), tenants$1.apply(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"test-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-instance-id"), groupInstances$1.apply(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)((BrokerWithMember)brokersWithMembers$1.apply(index)).member().memberId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)((BrokerWithMember)brokersWithMembers$1.apply(index)).member().clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"external.test.topic"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"0")}));
        $this.verifyConsumerLag((BrokerWithMember)brokersWithMembers$1.apply(index), (scala.collection.mutable.Map<String, String>)tags, 0L);
        $this.verifyConsumerLagEmitterLatency((BrokerWithMember)brokersWithMembers$1.apply(index));
        TestUtils$.MODULE$.generateAndProduceMessages($this.brokers(), (String)topics$1.apply(index), BoxesRunTime.unboxToInt((Object)expectedConsumerLags$1.apply(index)), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        $this.verifyConsumerLag((BrokerWithMember)brokersWithMembers$1.apply(index), (scala.collection.mutable.Map<String, String>)tags, BoxesRunTime.unboxToInt((Object)expectedConsumerLags$1.apply(index)));
        $this.verifyConsumerLagEmitterLatency((BrokerWithMember)brokersWithMembers$1.apply(index));
    }

    public static final /* synthetic */ boolean $anonfun$testHandleGroupMigration$4(Admin admin$1) {
        return ((java.util.Map)admin$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testHandleGroupMigration$5() {
        return "reassignment did not complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testHandleGroupMigration$7(BrokerWithMember brokerWithMember$2, scala.collection.mutable.Map tags$1) {
        Metrics metrics = brokerWithMember$2.broker().metrics();
        return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).get((Object)metrics.metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(tags$1).asJava())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testHandleGroupMigration$8() {
        return "consumer lag metrics for the test group should no longer exist.";
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerLag$1(BrokerWithMember brokerWithMember$3, scala.collection.mutable.Map tags$2, long expectedConsumerLag$1) {
        Metrics metrics = brokerWithMember$3.broker().metrics();
        Option kafkaMetric = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).get((Object)metrics.metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(tags$2).asJava()));
        return kafkaMetric.isDefined() && BoxesRunTime.equals((Object)((KafkaMetric)kafkaMetric.get()).metricValue(), (Object)BoxesRunTime.boxToLong((long)expectedConsumerLag$1));
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerLag$2() {
        return "consumer lag metric should exist";
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerLagEmitterLatency$1(ConsumerLagEmitterIntegrationTest $this, BrokerWithMember brokerWithMember$4) {
        Metrics metrics = brokerWithMember$4.broker().metrics();
        Option kafkaMetric = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).get((Object)metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        return $this.isMetricValueInRange((Option<KafkaMetric>)kafkaMetric, $this.isMetricValueInRange$default$2(), $this.isMetricValueInRange$default$3());
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerLagEmitterLatency$2() {
        return "consumer lag emitter should take 0 - 1 seconds.";
    }

    public static final /* synthetic */ boolean $anonfun$isMetricValueInRange$1(long lowerBound$1, long upperBound$1, KafkaMetric metric) {
        return BoxesRunTime.unboxToLong((Object)metric.metricValue()) > lowerBound$1 && BoxesRunTime.unboxToLong((Object)metric.metricValue()) < upperBound$1;
    }

    public ConsumerLagEmitterIntegrationTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.numNodes()));
        this.overridingProps().put("confluent.consumer.lag.emitter.enabled", "true");
        this.overridingProps().put("confluent.consumer.lag.emitter.interval.ms", "1000");
        this.consumers = null;
        this.admins = null;
    }
}

