/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0001}3A!\u0004\b\u0001'!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001a\u0001\n\u0003)\u0003b\u0002\u0018\u0001\u0001\u0004%\ta\f\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\u0014\t\u000bY\u0002A\u0011A\u001c\t\u000b\u0015\u0003A\u0011A\u001c\t\u000b)\u0003A\u0011A\u001c\t\u000b=\u0003A\u0011A\u001c\t\u000bE\u0003A\u0011A\u001c\t\u000bM\u0003A\u0011A\u001c\t\u000bU\u0003A\u0011A\u001c\t\u000b]\u0003A\u0011A\u001c\u000391Kg.\u001e=DaVlU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fV3ti*\u0011q\u0002E\u0001\b[\u0016$(/[2t\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e!\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\ta\"A\u0004cCN,G)\u001b:\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u0005%|'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012AAR5mK\u0006Y!-Y:f\t&\u0014x\fJ3r)\t\u00014\u0007\u0005\u0002\u0016c%\u0011!G\u0006\u0002\u0005+:LG\u000fC\u00045\u0007\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013'\u0001\u0005cCN,G)\u001b:!\u0003\u0015\u0019X\r^+q)\u0005\u0001\u0004FA\u0003:!\tQ4)D\u0001<\u0015\taT(A\u0002ba&T!AP \u0002\u000f),\b/\u001b;fe*\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$A\u0003\"fM>\u0014X-R1dQ\u000691\r\\3b]V\u0003\bF\u0001\u0004H!\tQ\u0004*\u0003\u0002Jw\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0019i\u0016\u001cHoU=ti\u0016l7\t];Vi&d\u0017N_1uS>t\u0007FA\u0004M!\tQT*\u0003\u0002Ow\t!A+Z:u\u0003)!Xm\u001d;Vg\u0006\u0014G.\u001a\u0015\u0003\u00111\u000bq\u0002^3tiJ+\u0017\r\u001a'pC\u0012\feo\u001a\u0015\u0003\u00131\u000b1\u0005^3tiVs\u0017M\u00197f)>\u0014V-\u00193O_:,\u00070[:uK:$\bK]8d\r&dW\r\u000b\u0002\u000b\u0019\u0006IB/Z:u!J|7-Z:t\u0007B,X\u000b^5mSj\fG/[8oQ\tYA*\u0001\ruKN$8)\u001e:sK:$8+_:uK6T\u0015N\u001a4jKND#\u0001\u0004')\t\u0001QVL\u0018\t\u0003umK!\u0001X\u001e\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\u0019\u0011\u00016a")
public class LinuxCpuMetricsCollectorTest
implements Logging {
    private File baseDir;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.baseDir_$eq(TestUtils.tempDirectory());
    }

    @AfterEach
    public void cleanUp() {
        Utils.delete((File)this.baseDir());
    }

    @Test
    public void testSystemCpuUtilization() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying());
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 120000 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.0, (double)collector.systemCpuUtilization(), (double)0.0);
        cpuStat = "cpu  10711892 409 4188649 124938617 516537 0 2369826 126200 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.95, (double)collector.systemCpuUtilization(), (double)0.01);
        cpuStat = "cpu  10754158 411 4204810 126043403 516852 0 2371170 126600 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.16, (double)collector.systemCpuUtilization(), (double)0.01);
    }

    @Test
    public void testUsable() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying());
        String loadStr = new StringOps(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 1260 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertTrue((boolean)collector.usable());
    }

    @Test
    public void testReadLoadAvg() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying());
        String loadStr = new StringOps(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.11, (double)collector.oneMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.22, (double)collector.fiveMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.33, (double)collector.fifteenMinLoadAvg(), (double)0.0);
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        MockTime time = new MockTime(100L, 1000L);
        Assertions.assertFalse((boolean)new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying()).usable());
    }

    @Test
    public void testProcessCpuUtilization() {
        String processCpuStatTemplate = "1 (java -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.authenticate=false) S 0 1 1 0 -1 1077952768 1330953 251903 2308 0 %s %s 625 162 20 0 194 0 112096471 19638837248 1238367 18446744073709551615 93983261564928 93983261568680 140721374129216 0 0 0 0 0 16800975 0 0 0 17 7 0 0 0 0 0 93983261576440 93983261577240 93983283015680 140721374145345 140721374165341 140721374165341 140721374228443 0";
        this.baseDir().toPath().resolve("1").toFile().mkdir();
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying());
        String cpuStat = "cpu  100 100 100 100 100 0 100 0 0 0";
        this.writeProcessStat$1(20L, 30L, processCpuStatTemplate);
        this.writeSystemStat$1(cpuStat);
        Assertions.assertEquals((double)0.0, (double)collector.processCpuUtilization(), (double)0.0);
        cpuStat = "cpu  120 130 105 104 106 0 110 0 0 0";
        this.writeSystemStat$1(cpuStat);
        this.writeProcessStat$1(35L, 40L, processCpuStatTemplate);
        Assertions.assertEquals((double)33.33, (double)collector.processCpuUtilization(), (double)1.0);
        cpuStat = "cpu  150 160 112 115 109 0 125 0 0 0";
        this.writeSystemStat$1(cpuStat);
        this.writeProcessStat$1(57L, 67L, processCpuStatTemplate);
        Assertions.assertEquals((double)51.04, (double)collector.processCpuUtilization(), (double)1.0);
    }

    @Test
    public void testCurrentSystemJiffies() {
        String cpuStat = "cpu  100 100 100 100 100 50 100 60 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying());
        Assertions.assertEquals((long)710L, (long)collector.currentSystemJiffies().total());
        cpuStat = "cpu  200 100 300 100 100 50 300 100 50 70";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((long)1250L, (long)collector.currentSystemJiffies().total());
    }

    private final void writeProcessStat$1(long userMode, long kernelMode, String processCpuStatTemplate$1) {
        String stat = String.format(processCpuStatTemplate$1, Long.toString(userMode), Long.toString(kernelMode));
        Files.write(this.baseDir().toPath().resolve("1").resolve("stat"), stat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private final void writeSystemStat$1(String stat) {
        Files.write(this.baseDir().toPath().resolve("stat"), stat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public LinuxCpuMetricsCollectorTest() {
        Logging.$init$((Logging)this);
        this.baseDir = null;
    }
}

