/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.network.RequestMetrics;
import kafka.server.EnvelopeUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\f\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019I\u0004\u0001)A\u0005m!)\u0011\u000b\u0001C\u0001%\")\u0011\r\u0001C\u0001%\")1\r\u0001C\u0001%\")Q\r\u0001C\u0001%\")q\r\u0001C\u0001%\")\u0011\u000e\u0001C\u0001%\")1\u000e\u0001C\u0001%\")Q\u000e\u0001C\u0001]\"9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!\u001f\u0001\t\u0003\tY\bC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"9\u00111\r\u0001\u0005\u0002\u0005\u001d\u0006bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\t)\r\u0001C\u0005\u0003wDqAa\u0005\u0001\t\u0013\u0011)B\u0001\nSKF,Xm\u001d;DQ\u0006tg.\u001a7UKN$(BA\u000e\u001d\u0003\u001dqW\r^<pe.T\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003i\tQC]3rk\u0016\u001cHo\u00115b]:,G.T3ue&\u001c7/F\u0001-!\ti\u0003G\u0004\u0002*]%\u0011qFG\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\t\t$GA\u0004NKR\u0014\u0018nY:\u000b\u0005=R\u0012A\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m\u001d\u0011\u0002\u001dA\u0014\u0018N\\2ja\u0006d7+\u001a:eKV\taGE\u00028u\t3A\u0001O\u0003\u0001m\taAH]3gS:,W.\u001a8u}\u0005y\u0001O]5oG&\u0004\u0018\r\\*fe\u0012,\u0007\u0005\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\r=\u0013'.Z2u!\t\u0019u*D\u0001E\u0015\t)e)\u0001\u0003bkRD'BA$I\u0003!\u0019XmY;sSRL(BA%K\u0003\u0019\u0019w.\\7p]*\u0011Qd\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\t\n\u00192*\u00194lCB\u0013\u0018N\\2ja\u0006d7+\u001a:eK\u0006!B/Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014V-];fgR$\u0012a\u0015\t\u0003CQK!!\u0016\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\r]\u0003\"\u0001W0\u000e\u0003eS!AW.\u0002\u0007\u0005\u0004\u0018N\u0003\u0002];\u00069!.\u001e9ji\u0016\u0014(B\u00010N\u0003\u0015QWO\\5u\u0013\t\u0001\u0017L\u0001\u0003UKN$\u0018!\u0005;fgR\fE\u000e^3s%\u0016\fX/Z:ug\"\u0012qaV\u0001\u0016i\u0016\u001cHo\u00157po2{wMR8s!J|G-^2fQ\tAq+\u0001\u000fuKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM\u001d*fcV,7\u000f^:)\u0005%9\u0016A\u0006;fgR\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:)\u0005)9\u0016A\t;fgRtuN\\!mi\u0016\u0014(+Z9vKN$8OT8u)J\fgn\u001d4pe6,G\r\u000b\u0002\f/\u0006\u0001B/Z:u\u0015N|gNU3rk\u0016\u001cHo\u001d\u0015\u0003\u0019]\u000b\u0011\u0004^3ti\n+\u0018\u000e\u001c3F]Z,Gn\u001c9f%\u0016\u001c\bo\u001c8tKR\u00111k\u001c\u0005\u0006a6\u0001\r!]\u0001\u0006KJ\u0014xN\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i\"\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003mN\u0014a!\u0012:s_J\u001c\bFC\u0007y\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\taJ|g/\u001b3fe*\u0011QpW\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005}T(AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\n\u0011/A\u0003oC6,7\u000f\f\u0004\u0002\n\u00055\u0011\u0011C\u0011\u0003\u0003\u0017\tAAT(O\u000b\u0006\u0012\u0011qB\u0001\u001d\u00072+6\u000bV#S?\u0006+F\u000bS(S\u0013j\u000bE+S(O?\u001a\u000b\u0015\nT#EC\t\t\u0019\"\u0001\bO\u001fR{6i\u0014(U%>cE*\u0012*)\u00075\t9\u0002\u0005\u0003\u0002\u001a\u0005mQ\"\u0001?\n\u0007\u0005uAPA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fqCY;jY\u0012\u001c%/Z1uKR{\u0007/[2SKF,Xm\u001d;\u0015\t\u0005\r\u0012q\u0006\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006%\u0002\u0011I,\u0017/^3tiNLA!!\f\u0002(\t\u00192I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\"9\u0011\u0011\u0007\bA\u0002\u0005M\u0012!\u0002;pa&\u001c\u0007\u0003BA\u001b\u0003\u0007rA!a\u000e\u0002@A\u0019\u0011\u0011\b\u0012\u000e\u0005\u0005m\"bAA\u001f=\u00051AH]8pizJ1!!\u0011#\u0003\u0019\u0001&/\u001a3fM&!\u0011QIA$\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\t\u0012\u00021\t,\u0018\u000e\u001c3De\u0016\fG/\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0004\u0002N\u0005M\u0013Q\u000b\t\u0005\u0003K\ty%\u0003\u0003\u0002R\u0005\u001d\"\u0001F\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rC\u0004\u00022=\u0001\r!a\r\t\u000bA|\u0001\u0019A9\u0002;\t,\u0018\u000e\u001c3V]^\u0014\u0018\r\u001d9fI\u0016sg/\u001a7pa\u0016\u0014V-];fgR$B!a\u0017\u0002bA\u0019Q&!\u0018\n\u0007\u0005}#GA\u0004SKF,Xm\u001d;\t\u000f\u0005\r\u0004\u00031\u0001\u0002f\u00059!/Z9vKN$\b\u0003BA\u0013\u0003OJA!!\u001b\u0002(\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH/A\u0006jgZ\u000bG.\u001b3Kg>tG\u0003BA8\u0003k\u00022!IA9\u0013\r\t\u0019H\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t9(\u0005a\u0001\u0003g\t1a\u001d;s\u0003I\u0011X-];fgR<\u0016\u000e\u001e5NKR\u0014\u0018nY:\u0015\u0011\u0005m\u0013QPAA\u0003\u000bCq!a \u0013\u0001\u0004\t)'A\u0002sKFDa!a!\u0013\u0001\u0004a\u0013aB7fiJL7m\u001d\u0005\n\u0003\u000f\u0013\u0002\u0013!a\u0001\u0003\u0013\u000bab\u001d;beR$\u0016.\\3OC:|7\u000fE\u0002\"\u0003\u0017K1!!$#\u0005\u0011auN\\4\u00029I,\u0017/^3ti^KG\u000f['fiJL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0013\u0016\u0005\u0003\u0013\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tKI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0011\tY&!+\t\u000f\u0005}D\u00031\u0001\u0002f\u0005\tb.Z<SKF,Xm\u001d;D_:$X\r\u001f;\u0015\t\u0005=\u0016Q\u0017\t\u0005\u0003K\t\t,\u0003\u0003\u00024\u0006\u001d\"A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0003o+\u0002\u0019AA]\u0003\u0019\u0011WO\u001a4feB!\u00111XAa\u001b\t\tiLC\u0002\u0002@z\n1A\\5p\u0013\u0011\t\u0019-!0\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0002J\u0006U\u0007\u0003CAf\u0003#\f\u0019$a\r\u000e\u0005\u00055'bAAhE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0017Q\u001a\u0002\u0004\u001b\u0006\u0004\bbBAl-\u0001\u0007\u0011\u0011\\\u0001\u0007G>tg-[4\u0011\t\u0005m\u0017Q\u001f\b\u0005\u0003;\f\tP\u0004\u0003\u0002`\u0006=h\u0002BAq\u0003[tA!a9\u0002l:!\u0011Q]Au\u001d\u0011\tI$a:\n\u00039K!\u0001T'\n\u0005uY\u0015BA%K\u0013\r\tI\u0003S\u0005\u0005\u0003g\f9#A\nBYR,'oQ8oM&<7OU3rk\u0016\u001cH/\u0003\u0003\u0002x\u0006e(AB\"p]\u001aLwM\u0003\u0003\u0002t\u0006\u001dB\u0003BAe\u0003{Dq!a6\u0018\u0001\u0004\ty\u0010\u0005\u0003\u0003\u0002\t5a\u0002\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\u0007\t\u001d\u0001*A\u0004nKN\u001c\u0018mZ3\n\t\t-!QA\u0001#\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\n\t\t=!\u0011\u0003\u0002\u001a\u00032$XM]1cY\u0016\u001cuN\u001c4jO\u000e{G\u000e\\3di&|gN\u0003\u0003\u0003\f\t\u0015\u0011!\u00062vS2$WI\u001c<fY>\u0004XMU3ta>t7/\u001a\u000b\u0007\u0005/\u0011iB!\t\u0011\t\u0005\u0015\"\u0011D\u0005\u0005\u00057\t9C\u0001\tF]Z,Gn\u001c9f%\u0016\u001c\bo\u001c8tK\"9!q\u0004\rA\u0002\u0005m\u0013!C;ooJ\f\u0007\u000f]3e\u0011\u001d\u0011\u0019\u0003\u0007a\u0001\u0005K\t\u0001B]3ta>t7/\u001a\t\u0005\u0003K\u00119#\u0003\u0003\u0003*\u0005\u001d\"\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0001")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return Utils.utf8((String)principal.toString());
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
        }
    };

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    @Test
    public void testSerializeRequest() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(brokerResource, new AlterConfigsRequest.Config((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)).asJava())), true).build());
        ByteBuffer serialized = alterConfigs.serialize();
        Assertions.assertEquals((Object)alterConfigs.buffer().rewind(), (Object)serialized.rewind());
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testSlowLogForProduce() {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(256), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(9).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        RequestChannel.Metrics requestMetrics = new RequestChannel.Metrics(ApiMessageType.ListenerType.BROKER);
        RequestChannel.Request produceRequest = this.requestWithMetrics(requestBuilder.build(), requestMetrics, 100L);
        RequestChannel.Request.SlowLogCheckResponse produceRequestSlowResponse = produceRequest.shouldLogSlowRequests(100.0, 200L, produceRequest.header());
        Assertions.assertTrue((boolean)produceRequestSlowResponse.shouldLog());
        Assertions.assertEquals((double)0.0, (double)produceRequestSlowResponse.slowLogThreshold());
        RequestMetrics m = requestMetrics.apply(ApiKeys.PRODUCE.name);
        RequestChannel.Request pr2 = this.requestWithMetrics(requestBuilder.build(), requestMetrics, TimeUnit.SECONDS.toNanos(65L));
        m.totalTimeHist().update(1000);
        RequestChannel.Request.SlowLogCheckResponse pr2CheckResponse = pr2.shouldLogSlowRequests(100.0, TimeUnit.SECONDS.toNanos(70L), produceRequest.header());
        Assertions.assertFalse((boolean)pr2CheckResponse.shouldLog());
        Assertions.assertEquals((double)1000.0, (double)pr2CheckResponse.slowLogThreshold());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource linkResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link1");
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map linkJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, linkJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testCreateClusterLinks() {
        String sensitiveValue = "secret";
        Map keystorePassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfigs$1(keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfigs$1(keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(plainJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED", "NOT_CONTROLLER"})
    public void testBuildEnvelopeResponse(Errors error) {
        String topic = "foo";
        CreateTopicsRequest createTopicRequest = this.buildCreateTopicRequest(topic);
        RequestChannel.Request unwrapped = this.buildUnwrappedEnvelopeRequest((AbstractRequest)createTopicRequest);
        CreateTopicsResponse createTopicResponse = this.buildCreateTopicResponse(topic, error);
        EnvelopeResponse envelopeResponse = this.buildEnvelopeResponse(unwrapped, (AbstractResponse)createTopicResponse);
        if (Errors.NOT_CONTROLLER.equals(error)) {
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)envelopeResponse.error());
            Assertions.assertNull((Object)envelopeResponse.responseData());
            return;
        }
        Assertions.assertEquals((Object)Errors.NONE, (Object)envelopeResponse.error());
        AbstractResponse unwrappedResponse = AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)unwrapped.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)createTopicResponse.data(), (Object)unwrappedResponse.data());
    }

    private CreateTopicsRequest buildCreateTopicRequest(String topic) {
        CreateTopicsRequestData requestData = new CreateTopicsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)-1).setNumPartitions(-1));
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(requestData).build();
    }

    private CreateTopicsResponse buildCreateTopicResponse(String topic, Errors error) {
        CreateTopicsResponseData responseData = new CreateTopicsResponseData();
        responseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(error.code()));
        return new CreateTopicsResponse(responseData);
    }

    private RequestChannel.Request buildUnwrappedEnvelopeRequest(AbstractRequest request2) {
        RequestChannel.Request wrappedRequest = TestUtils$.MODULE$.buildEnvelopeRequest(request2, this.principalSerde(), this.requestChannelMetrics(), System.nanoTime(), TestUtils$.MODULE$.buildEnvelopeRequest$default$5(), TestUtils$.MODULE$.buildEnvelopeRequest$default$6());
        AtomicReference unwrappedRequest = new AtomicReference();
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(wrappedRequest, this.requestChannelMetrics(), (Function1 & Serializable & scala.Serializable)request -> {
            unwrappedRequest.set(request);
            return BoxedUnit.UNIT;
        });
        return (RequestChannel.Request)unwrappedRequest.get();
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request requestWithMetrics(AbstractRequest req, RequestChannel.Metrics metrics, long startTimeNanos) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, startTimeNanos, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, metrics, RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$9(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$10());
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$9(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$10());
    }

    public long requestWithMetrics$default$3() {
        return 0L;
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)config).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private EnvelopeResponse buildEnvelopeResponse(RequestChannel.Request unwrapped, AbstractResponse response) {
        Assertions.assertTrue((boolean)unwrapped.envelope().isDefined());
        RequestChannel.Request envelope = (RequestChannel.Request)unwrapped.envelope().get();
        ByteBuffer sendBytes = TestUtils.toBuffer((Send)unwrapped.buildResponseSend(response));
        Assertions.assertEquals((int)sendBytes.getInt(), (int)sendBytes.remaining());
        AbstractResponse envelopeResponse = AbstractResponse.parseResponse((ByteBuffer)sendBytes, (RequestHeader)envelope.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertTrue((boolean)(envelopeResponse instanceof EnvelopeResponse));
        return (EnvelopeResponse)envelopeResponse;
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String name = (String)x0$1._1();
        String value = (String)x0$1._2();
        boolean bl = alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        return bl;
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    private final void verifyConfigs$1(Map requestConfigs, Map expectedLoggedConfigs, String sensitiveValue$3) {
        Set<NewClusterLink> link = Collections.singleton(new NewClusterLink("linkName", "clusterId", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(requestConfigs).asJava()));
        CreateClusterLinksRequest createRequest = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(link, false, false, 10000).build();
        RequestChannel.Request createLinks = this.request((AbstractRequest)createRequest);
        CreateClusterLinksRequest loggableRequest = (CreateClusterLinksRequest)createLinks.loggableRequest();
        scala.collection.mutable.Map loggedConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((NewClusterLink)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(loggableRequest.newClusterLinks()).asScala()).head()).configs()).asScala();
        Assertions.assertEquals((Object)expectedLoggedConfigs, (Object)loggedConfigs);
        String createLinksDesc = RequestConvertToJson$.MODULE$.requestDesc(createLinks.header(), createLinks.requestLog(), true).toString();
        Assertions.assertFalse((boolean)createLinksDesc.contains(sensitiveValue$3), (String)new StringBuilder(24).append("Sensitive config logged ").append(createLinksDesc).toString());
    }
}

