/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLSession;
import javax.security.auth.login.Configuration;
import javax.security.sasl.SaslServer;
import kafka.cluster.EndPoint;
import kafka.network.LinkComponents;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TestInterceptor;
import kafka.network.TestInterceptor$;
import kafka.network.TestPrincipal;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ReverseConnectionRequest;
import org.apache.kafka.common.requests.ReverseConnectionResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011mc\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004b\u0001\u0001\u0006Ia\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019\t\b\u0001)A\u0005I\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB@\u0001A\u0003%A\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0005\u0001!\u0002\u0013\t)\u0001C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\t\u0001!\u0002\u0013\tI\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u00111\u000b\u0001!\u0002\u0013\t9\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011Q\r\u0001!\u0002\u0013\tI\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005M\u0005\u0001\"\u0001\u0002v!9\u0011Q\u0014\u0001\u0005\u0002\u0005U\u0004bBAT\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003W\u0003A\u0011AA;\u0011\u001d\ty\u000b\u0001C\u0001\u0003kBq!a-\u0001\t\u0003\t)\bC\u0004\u00028\u0002!\t!!\u001e\t\u000f\u0005m\u0006\u0001\"\u0001\u0002v!9\u0011q\u0018\u0001\u0005\u0002\u0005U\u0004bBAb\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u000f\u0004A\u0011AA;\u0011\u001d\tY\r\u0001C\u0001\u0003kBq!a4\u0001\t\u0003\t)\bC\u0004\u0002T\u0002!\t!!\u001e\t\u000f\u0005]\u0007\u0001\"\u0001\u0002v!9\u00111\u001c\u0001\u0005\n\u0005u\u0007bBAn\u0001\u0011%\u00111\u001f\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001bAqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0002\\\u0002!IAa\b\t\u0013\t%\u0003!%A\u0005\n\t-\u0003\"\u0003B1\u0001E\u0005I\u0011\u0002B2\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SB\u0011Ba(\u0001#\u0003%IA!)\t\u0013\t\u0015\u0006!%A\u0005\n\t\u001d\u0006b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqA!1\u0001\t\u0013\u0011\u0019\rC\u0004\u0003R\u0002!IAa5\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!Q\u001d\u0001\u0005\n\t\u001d\bbBB\"\u0001\u0011%1Q\t\u0005\n\u0007S\u0002\u0011\u0013!C\u0005\u0007WBqaa\u001c\u0001\t\u0013\u0019\t\bC\u0005\u0004\n\u0002\t\n\u0011\"\u0003\u0003L!911\u0012\u0001\u0005\n\r5\u0005bBBN\u0001\u0011%1Q\u0014\u0005\b\u0007O\u0003A\u0011BBU\u0011\u001d\u0019Y\f\u0001C\u0005\u0007{Cqaa4\u0001\t\u0013\u0019\t\u000eC\u0004\u0004Z\u0002!Iaa7\t\u000f\r%\b\u0001\"\u0003\u0004l\"IA1\u0001\u0001\u0012\u0002\u0013%AQ\u0001\u0005\n\t\u001f\u0001\u0011\u0013!C\u0005\u0005\u0017Bq\u0001\"\u0005\u0001\t\u0013!\u0019\u0002C\u0004\u0005&\u0001!I\u0001b\n\t\u000f\u0011E\u0002\u0001\"\u0003\u00054!9Aq\u0007\u0001\u0005\n\u0011e\u0002b\u0002C\"\u0001\u0011%AQ\t\u0005\b\t\u001f\u0002A\u0011\u0002C)\u0011\u001d!)\u0006\u0001C\u0005\t/\u0012QCU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o)\u0016\u001cHO\u0003\u0002K\u0017\u00069a.\u001a;x_J\\'\"\u0001'\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0006C\u0001-\u0001\u001b\u0005I\u0015AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000b\u0001b]3dkJLG/_\u0005\u0003Av\u0013!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\u0006\u00192M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3sA\u0005!A/[7f+\u0005!\u0007CA3p\u001b\u00051'BA4i\u0003\u0015)H/\u001b7t\u0015\tI'.\u0001\u0004d_6lwN\u001c\u0006\u0003\u0019.T!\u0001\\7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0017aA8sO&\u0011\u0001O\u001a\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0004tKJ4XM]:\u0016\u0003Q\u00042!\u001e>}\u001b\u00051(BA<y\u0003\u001diW\u000f^1cY\u0016T!!_)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|m\n1!)\u001e4gKJ\u0004\"\u0001W?\n\u0005yL%\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001C:feZ,'o\u001d\u0011\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8ugV\u0011\u0011Q\u0001\t\bk\u0006\u001d\u00111BA\f\u0013\r\tIA\u001e\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E!.A\u0004dY&,g\u000e^:\n\t\u0005U\u0011q\u0002\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\bi\u0003\u001diW\r\u001e:jGNLA!!\t\u0002\u001c\t9Q*\u001a;sS\u000e\u001c\u0018a\u00048fi^|'o[\"mS\u0016tGo\u001d\u0011\u0002\u000b1Lgn[:\u0016\u0005\u0005%\u0002cB;\u0002\b\u0005-\u00121\b\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u0011)H/\u001b7\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006LA!!\u000f\u00020\t!Q+V%E!\rA\u0016QH\u0005\u0004\u0003\u007fI%A\u0004'j].\u001cu.\u001c9p]\u0016tGo]\u0001\u0007Y&t7n\u001d\u0011\u0002+I,g/\u001a:tKN{WO]2f\u0007\"\fgN\\3mgV\u0011\u0011q\t\t\u0005kj\fI\u0005\u0005\u0003\u0002L\u0005=SBAA'\u0015\tQ\u0005.\u0003\u0003\u0002R\u00055#\u0001D&bM.\f7\t[1o]\u0016d\u0017A\u0006:fm\u0016\u00148/Z*pkJ\u001cWm\u00115b]:,Gn\u001d\u0011\u0002\u0017-\fgm[1M_\u001e<WM]\u000b\u0003\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?Z\u0017!\u00027pORR\u0017\u0002BA2\u0003;\u0012a\u0001T8hO\u0016\u0014\u0018\u0001D6bM.\fGj\\4hKJ\u0004\u0013!\u00057pO2+g/\u001a7U_J+7\u000f^8sKV\u0011\u00111\u000e\t\u0005\u00037\ni'\u0003\u0003\u0002p\u0005u#!\u0002'fm\u0016d\u0017A\u00057pO2+g/\u001a7U_J+7\u000f^8sK\u0002\nQa]3u+B$\"!a\u001e\u0011\u0007A\u000bI(C\u0002\u0002|E\u0013A!\u00168ji\"\u001a!#a \u0011\t\u0005\u0005\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006\u0019\u0011\r]5\u000b\t\u0005%\u00151R\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti)\\\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\u000b\u0019I\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004'\u0005]\u0005\u0003BAA\u00033KA!a'\u0002\u0004\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHOT3uo>\u00148n\u00117jK:$\bf\u0001\u000b\u0002\"B!\u0011\u0011QAR\u0013\u0011\t)+a!\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cHOU3wKJ\u001cX\r\u00157bS:$X\r\u001f;D_:tWm\u0019;j_:D3!FAQ\u0003a!Xm\u001d;SKZ,'o]3Tg2\u001cuN\u001c8fGRLwN\u001c\u0015\u0004-\u0005\u0005\u0016A\t;fgR\u0014VM^3sg\u0016\u001c\u0016m\u001d7QY\u0006Lg\u000e^3yi\u000e{gN\\3di&|g\u000eK\u0002\u0018\u0003C\u000bA\u0004^3tiJ+g/\u001a:tKN\u000b7\u000f\\*tY\u000e{gN\\3di&|g\u000eK\u0002\u0019\u0003C\u000b1\u0006^3tiJ+g/\u001a:tK\u000e{gN\\3di&|gnV5uQ\u000e{gN\u001a7vK:$\bK]5oG&\u0004\u0018\r\u001c\u0015\u00043\u0005\u0005\u0016a\f;fgR\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\,ji\"\u0004F.Y5oi\u0016DHoU8ve\u000e,7k\u001d7EKN$\bf\u0001\u000e\u0002\"\u0006\u0001D/Z:u%\u00164XM]:f\u0007>tg.Z2uS>tw+\u001b;i\t&4g-\u001a:f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[ND3aGAQ\u0003e!Xm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007q\t\t+A\u000buKN$(I]8lKJLe\u000e^3sG\u0016\u0004Ho\u001c:)\u0007u\t\t+A\u0014uKN$(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t)>lU\u000f\u001c;ja2,7+\u001a:wKJ\u001c\bf\u0001\u0010\u0002\"\u0006IC/Z:u%\u00164XM]:f\u0007>tg.Z2uS>t7O\u0012:p[6+H\u000e^5qY\u0016\u001cVM\u001d<feND3aHAQ\u0003A\"Xm\u001d;Nk2$\u0018\u000e\u001d7f%\u00164XM]:f\u0007>tg.Z2uS>t7OQ3uo\u0016,gnU1nKN+'O^3sg\"\u001a\u0001%!)\u0002'Q,7\u000f^\"p]:,7\r^5p]2KW.\u001b;)\u0007\u0005\n\t+A\fwKJLg-\u001f*fm\u0016\u00148/Z\"p]:,7\r^5p]R1\u0011qOAp\u0003_Dq!!9#\u0001\u0004\t\u0019/\u0001\nt_V\u00148-Z*feZ,'oQ8oM&<\u0007\u0003BAs\u0003Wl!!a:\u000b\u0007\u0005%8*\u0001\u0004tKJ4XM]\u0005\u0005\u0003[\f9OA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBAyE\u0001\u0007\u00111]\u0001\u0011I\u0016\u001cHoU3sm\u0016\u00148i\u001c8gS\u001e$\u0002\"a\u001e\u0002v\u0006]\u0018\u0011 \u0005\b\u0003C\u001c\u0003\u0019AAr\u0011\u001d\t\tp\ta\u0001\u0003GDq!a?$\u0001\u0004\ti0\u0001\tdY>\u001cXm\u00117jK:$h)\u001b:tiB\u0019\u0001+a@\n\u0007\t\u0005\u0011KA\u0004C_>dW-\u00198\u0002MY,'/\u001b4z\u00072|7/Z\"mS\u0016tGoU5eKJ+g/\u001a:tK\u000e{gN\\3di&|g\u000e\u0006\u0003\u0002x\t\u001d\u0001B\u0002B\u0005I\u0001\u0007A0\u0001\u0007t_V\u00148-Z*feZ,'/\u0001\u0014wKJLg-_\"m_N,7+\u001a:wKJ\u001c\u0016\u000eZ3SKZ,'o]3D_:tWm\u0019;j_:$B!a\u001e\u0003\u0010!1!\u0011B\u0013A\u0002q\f\u0011c\u0019:fCR,G*\u001b8l\u00072LWM\u001c;t)!\tYD!\u0006\u0003\u001a\tm\u0001b\u0002B\fM\u0001\u0007\u00111F\u0001\u0007Y&t7.\u00133\t\r\t%a\u00051\u0001}\u0011\u0019\u0011iB\na\u0001y\u0006QA-Z:u'\u0016\u0014h/\u001a:\u0015\u0019\u0005]$\u0011\u0005B\u0012\u0005K\u00119Ca\u0010\t\u000f\t]q\u00051\u0001\u0002,!1!\u0011B\u0014A\u0002qDaA!\b(\u0001\u0004a\b\"\u0003B\u0015OA\u0005\t\u0019\u0001B\u0016\u00031\u0001(/\u001b8dSB\fGn\u00149u!\u0015\u0001&Q\u0006B\u0019\u0013\r\u0011y#\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tM\"1H\u0007\u0003\u0005kQAAa\u000e\u0003:\u0005!\u0011-\u001e;i\u0015\tq\u0006.\u0003\u0003\u0003>\tU\"AD&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\n\u0005\u0003:\u0003\u0013!a\u0001\u0005\u0007\n1B\\;n%\u0016\fX/Z:ugB\u0019\u0001K!\u0012\n\u0007\t\u001d\u0013KA\u0002J]R\f\u0011E^3sS\u001aL(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ*\"A!\u0014+\t\t-\"qJ\u0016\u0003\u0005#\u0002BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&A\u0005v]\u000eDWmY6fI*\u0019!1L)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003`\tU#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tc/\u001a:jMf\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\r\u0016\u0005\u0005\u0007\u0012y%A\u0006lC\u001a\\\u0017mQ8oM&<GCCAr\u0005W\u0012yG!\u001f\u0003\u0016\"9!Q\u000e\u0016A\u0002\t\r\u0013\u0001\u00032s_.,'/\u00133\t\u000f\tE$\u00061\u0001\u0003t\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u0005g\u0011)(\u0003\u0003\u0003x\tU\"\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0011%\u0011YH\u000bI\u0001\u0002\u0004\u0011i(A\u0007tCNdW*Z2iC:L7/\u001c\t\u0006!\n5\"q\u0010\t\u0005\u0005\u0003\u0013yI\u0004\u0003\u0003\u0004\n-\u0005c\u0001BC#6\u0011!q\u0011\u0006\u0004\u0005\u0013k\u0015A\u0002\u001fs_>$h(C\u0002\u0003\u000eF\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002BI\u0005'\u0013aa\u0015;sS:<'b\u0001BG#\"I!q\u0013\u0016\u0011\u0002\u0003\u0007!\u0011T\u0001\u000bKb$(/\u0019)s_B\u001c\b\u0003BA\u0017\u00057KAA!(\u00020\tQ\u0001K]8qKJ$\u0018.Z:\u0002+-\fgm[1D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0015\u0016\u0005\u0005{\u0012y%A\u000blC\u001a\\\u0017mQ8oM&<G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%&\u0006\u0002BM\u0005\u001f\nA\u0003\u001d7bS:$X\r\u001f;TKJ4XM\u001d)s_B\u001cH\u0003\u0002BM\u0005_CqA!\u001c.\u0001\u0004\u0011\u0019%\u0001\btg2\u001cVM\u001d<feB\u0013x\u000e]:\u0015\t\te%Q\u0017\u0005\b\u0005[r\u0003\u0019\u0001B\"\u0003=\u0019\u0018m\u001d7TKJ4XM\u001d)s_B\u001cH\u0003\u0003BM\u0005w\u0013iLa0\t\u000f\t5t\u00061\u0001\u0003D!9!\u0011O\u0018A\u0002\tM\u0004b\u0002B>_\u0001\u0007!QP\u0001\rC\u0012$7k\u0019:b[V\u001bXM\u001d\u000b\t\u0003o\u0012)M!3\u0003N\"9!q\u0019\u0019A\u0002\t}\u0014!C7fG\"\fg.[:n\u0011\u001d\u0011Y\r\ra\u0001\u0005\u007f\n\u0001\"^:fe:\fW.\u001a\u0005\b\u0005\u001f\u0004\u0004\u0019\u0001B@\u0003!\u0001\u0018m]:x_J$\u0017\u0001\u00047jgR,g.\u001a:OC6,G\u0003\u0002Bk\u00057\u0004B!a\u0013\u0003X&!!\u0011\\A'\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\u0011i.\ra\u0001\u0003G\faaY8oM&<\u0017a\u00048foN{7m[3u'\u0016\u0014h/\u001a:\u0015\u0007q\u0014\u0019\u000fC\u0004\u0003^J\u0002\r!a9\u0002!9,wo\u00117jK:$(+Z9vKN$HC\u0003Bu\u0005_\u0014\u0019Pa>\u0004(A!\u0011Q\u0002Bv\u0013\u0011\u0011i/a\u0004\u0003\u001b\rc\u0017.\u001a8u%\u0016\fX/Z:u\u0011\u001d\u0011\tp\ra\u0001\u0003\u0017\tQB\\3uo>\u00148n\u00117jK:$\bb\u0002B{g\u0001\u0007!qP\u0001\u0007]>$W-\u00133\t\u000f\te8\u00071\u0001\u0003|\u00069!-^5mI\u0016\u0014\b\u0007\u0002B\u007f\u0007+\u0001bAa@\u0004\f\rEa\u0002BB\u0001\u0007\u000fi!aa\u0001\u000b\u0007\r\u0015\u0001.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019Iaa\u0001\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLAa!\u0004\u0004\u0010\t9!)^5mI\u0016\u0014(\u0002BB\u0005\u0007\u0007\u0001Baa\u0005\u0004\u00161\u0001A\u0001DB\f\u0005o\f\t\u0011!A\u0003\u0002\re!aA0%cE!11DB\u0011!\r\u00016QD\u0005\u0004\u0007?\t&a\u0002(pi\"Lgn\u001a\t\u0004!\u000e\r\u0012bAB\u0013#\n\u0019\u0011I\\=\t\u000f\r%2\u00071\u0001\u0004,\u00051a-\u001e;ve\u0016\u0004ba!\f\u00044\r]RBAB\u0018\u0015\u0011\u0019\t$a\f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00046\r=\"!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!1\u0011HB \u001b\t\u0019YD\u0003\u0003\u0004>\u0005M\u0012\u0001\u00027b]\u001eLAa!\u0011\u0004<\t!ak\\5e\u00039\u0011XmY3jm\u0016\u0014V-];fgR$baa\u0012\u0004V\r}\u0003\u0003BB%\u0007\u001fr1\u0001WB&\u0013\r\u0019i%S\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\u0019\tfa\u0015\u0003\u000fI+\u0017/^3ti*\u00191QJ%\t\u000f\r]C\u00071\u0001\u0004Z\u000591\r[1o]\u0016d\u0007c\u0001-\u0004\\%\u00191QL%\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\"I1\u0011\r\u001b\u0011\u0002\u0003\u000711M\u0001\bi&lWm\\;u!\r\u00016QM\u0005\u0004\u0007O\n&\u0001\u0002'p]\u001e\f\u0001D]3dK&4XMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iG\u000b\u0003\u0004d\t=\u0013A\u00059s_\u000e,7o\u001d(fqR\u0014V-];fgR$\"\"a\u001e\u0004t\rU4\u0011PBC\u0011\u0019\tIO\u000ea\u0001y\"91q\u000f\u001cA\u0002\u0005-\u0011AB2mS\u0016tG\u000fC\u0004\u0004|Y\u0002\ra! \u0002\t9|G-\u001a\t\u0005\u0007\u007f\u001a\t)D\u0001i\u0013\r\u0019\u0019\t\u001b\u0002\u0005\u001d>$W\rC\u0005\u0004\bZ\u0002\n\u00111\u0001\u0003,\u0005\tR\r\u001f9fGR,G\r\u0015:j]\u000eL\u0007/\u00197\u00029A\u0014xnY3tg:+\u0007\u0010\u001e*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u00051R.\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHOQ;jY\u0012,'/\u0006\u0002\u0004\u0010B!1\u0011SBL\u001d\u0011\u0019\taa%\n\t\rU51A\u0001\u0010\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti&!1QBBM\u0015\u0011\u0019)ja\u0001\u0002\u001f5,G/\u00193bi\u0006,\u0006\u000fZ1uKJ$Baa(\u0004&B!\u0011QBBQ\u0013\u0011\u0019\u0019+a\u0004\u0003+5\u000bg.^1m\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;fe\"911P\u001dA\u0002\ru\u0014\u0001\u00058fo:+Go^8sW\u000ec\u0017.\u001a8u)!\tYaa+\u00040\u000eM\u0006BBBWu\u0001\u0007A0\u0001\u0007sK6|G/Z*feZ,'\u000f\u0003\u0004\u00042j\u0002\r\u0001`\u0001\fY>\u001c\u0017\r\\*feZ,'\u000fC\u0004\u0004\u001cj\u0002\ra!.\u0011\t\u000551qW\u0005\u0005\u0007s\u000byAA\bNKR\fG-\u0019;b+B$\u0017\r^3s\u000359\u0018-\u001b;G_J\u001cE.[3oiRA\u0011qOB`\u0007\u0003\u001cY\rC\u0004\u0004xm\u0002\r!a\u0003\t\u000f\r\r7\b1\u0001\u0004F\u0006I\u0001O]3eS\u000e\fG/\u001a\t\b!\u000e\u001d\u00171BA\u007f\u0013\r\u0019I-\u0015\u0002\n\rVt7\r^5p]FBqa!4<\u0001\u0004\u0011y(\u0001\u0007feJ|'/T3tg\u0006<W-\u0001\u0007xC&$hi\u001c:SK\u0006$\u0017\u0010\u0006\u0005\u0002x\rM7Q[Bl\u0011\u001d\u00199\b\u0010a\u0001\u0003\u0017Aa!!;=\u0001\u0004a\bbBB>y\u0001\u00071QP\u0001\u0010o\u0006LGOR8s%\u00164XM]:bYRA\u0011qOBo\u0007?\u001c\t\u000fC\u0004\u0004xu\u0002\r!a\u0003\t\r\u0005%X\b1\u0001}\u0011\u001d\u0019Y(\u0010a\u0001\u0007G\u0004B!a\u0013\u0004f&!1q]A'\u0005-\u0011VM^3sg\u0016tu\u000eZ3\u0002\u001dM,g\u000eZ!oIJ+7-Z5wKRa\u0011qOBw\u0007_\u001c\tpa=\u0005\u0002!91q\u000f A\u0002\u0005-\u0001BBAu}\u0001\u0007A\u0010C\u0004\u0004|y\u0002\ra! \t\u0013\rUh\b%AA\u0002\r]\u0018A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\u0019\u0005\u0007s\u001ci\u0010\u0005\u0004\u0003\u0000\u000e-11 \t\u0005\u0007'\u0019i\u0010\u0002\u0007\u0004\u0000\u000eM\u0018\u0011!A\u0001\u0006\u0003\u0019IBA\u0002`IIB\u0011ba\"?!\u0003\u0005\rAa\u000b\u00021M,g\u000eZ!oIJ+7-Z5wK\u0012\"WMZ1vYR$C'\u0006\u0002\u0005\bA\"A\u0011\u0002C\u0007!\u0019\u0011ypa\u0003\u0005\fA!11\u0003C\u0007\t-\u0019ypPA\u0001\u0002\u0003\u0015\ta!\u0007\u00021M,g\u000eZ!oIJ+7-Z5wK\u0012\"WMZ1vYR$S'\u0001\u0007sKZ,'o]1m\t\u0006$\u0018\r\u0006\u0004\u0005\u0016\u0011\u0005B1\u0005\t\u0005\t/!i\"\u0004\u0002\u0005\u001a)\u0019A1\u00045\u0002\u000f5,7o]1hK&!Aq\u0004C\r\u0005q\u0011VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c*fcV,7\u000f\u001e#bi\u0006DqAa\u0006B\u0001\u0004\tY\u0003\u0003\u0004\u0003\n\u0005\u0003\r\u0001`\u0001\u001a_:\u0014VM^3sg\u0016\u001cE.[3oi\u000e{gN\\3di&|g\u000e\u0006\u0004\u0002x\u0011%BQ\u0006\u0005\b\tW\u0011\u0005\u0019AA%\u00035\u0019x.\u001e:dK\u000eC\u0017M\u001c8fY\"9Aq\u0006\"A\u0002\r\r\u0018a\u0003:fm\u0016\u00148/\u001a(pI\u0016\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0015\t\tEBQ\u0007\u0005\u0007\u0003S\u001c\u0005\u0019\u0001?\u0002!A,(\r\\5d\u0007J,G-\u001a8uS\u0006dG\u0003\u0002C\u001e\t\u0003\u0002B!a\u0013\u0005>%!AqHA'\u0005A\u0001VO\u00197jG\u000e\u0013X\rZ3oi&\fG\u000e\u0003\u0004\u0002j\u0012\u0003\r\u0001`\u0001\u0016CV$\b.\u001a8uS\u000e\fG/[8o\u0007>tG/\u001a=u)\u0011!9\u0005\"\u0014\u0011\t\tMB\u0011J\u0005\u0005\t\u0017\u0012)DA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\r\u0005%X\t1\u0001}\u0003a\u0019\b.\u001e;e_^t7+\u001a:wKJ\fe\u000eZ'fiJL7m\u001d\u000b\u0005\u0003o\"\u0019\u0006\u0003\u0004\u0002j\u001a\u0003\r\u0001`\u0001\u0019m\u0016\u0014\u0018NZ=OKR<xN]6DY&,g\u000e^#naRLH\u0003BA<\t3Bqaa\u001eH\u0001\u0004\tY\u0001")
public class ReverseConnectionTest {
    private final CredentialProvider credentialProvider = new CredentialProvider(ScramMechanism.mechanismNames(), null);
    private final Time time = Time.SYSTEM;
    private final Buffer<SocketServer> servers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.mutable.Map<NetworkClient, Metrics> networkClients = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.mutable.Map<UUID, LinkComponents> kafka$network$ReverseConnectionTest$$links = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaChannel> reverseSourceChannels = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Logger kafkaLogger = LogManager.getLogger((String)"kafka");
    private final Level logLevelToRestore = this.kafkaLogger().getLevel();

    private CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private Time time() {
        return this.time;
    }

    private Buffer<SocketServer> servers() {
        return this.servers;
    }

    private scala.collection.mutable.Map<NetworkClient, Metrics> networkClients() {
        return this.networkClients;
    }

    public scala.collection.mutable.Map<UUID, LinkComponents> kafka$network$ReverseConnectionTest$$links() {
        return this.kafka$network$ReverseConnectionTest$$links;
    }

    private Buffer<KafkaChannel> reverseSourceChannels() {
        return this.reverseSourceChannels;
    }

    private Logger kafkaLogger() {
        return this.kafkaLogger;
    }

    private Level logLevelToRestore() {
        return this.logLevelToRestore;
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.kafkaLogger().setLevel(Level.TRACE);
    }

    @AfterEach
    public void tearDown() {
        this.networkClients().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReverseConnectionTest.$anonfun$tearDown$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServerAndMetrics(server);
            return BoxedUnit.UNIT;
        });
        this.kafkaLogger().setLevel(this.logLevelToRestore());
        LoginManager.closeAll();
        Configuration.setConfiguration(null);
    }

    @Test
    public void testNetworkClient() {
        int nodeId = 1;
        KafkaConfig config = this.kafkaConfig(nodeId, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        SocketServer server = this.newSocketServer(config);
        Node node = new Node(nodeId, "localhost", server.boundPort(this.listenerName(config)));
        NetworkClient client = this.newNetworkClient(server, server, (MetadataUpdater)this.metadataUpdater(node));
        client.enableDestinationClusterLink(UUID.randomUUID(), null, null);
        this.waitForReady(client, server, node);
        this.sendAndReceive(client, server, node, this.sendAndReceive$default$4(), this.sendAndReceive$default$5());
        client.close(Integer.toString(nodeId));
        this.verifyNetworkClientEmpty(client);
    }

    @Test
    public void testReversePlaintextConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSslConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSaslPlaintextConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSaslSslConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithConfluentPrincipal() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, (Option<String>)new Some((Object)"PLAIN"), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)new Some((Object)"PLAIN"), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithPlaintextSourceSslDest() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithDifferentSaslMechanisms() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"PLAIN"), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"SCRAM-SHA-256"), this.kafkaConfig$default$4());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthenticationFailure() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"PLAIN"), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"SCRAM-SHA-256"), this.kafkaConfig$default$4());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        this.credentialProvider().credentialCache().cache("SCRAM-SHA-256", ScramCredential.class).remove(JaasTestUtils$.MODULE$.KafkaScramUser());
        this.credentialProvider().credentialCache().cache("SCRAM-SHA-256", ScramCredential.class).remove(JaasTestUtils$.MODULE$.KafkaScramUser2());
        LinkComponents link = this.createLinkClients(UUID.randomUUID(), sourceServer, destServer);
        ListenerName sourceListenerName = ((EndPoint)sourceServer.config().effectiveAdvertisedListeners().head()).listenerName();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable & scala.Serializable)i -> ReverseConnectionTest.$anonfun$testAuthenticationFailure$1(this, link, destServer, sourceListenerName, sourceServer, BoxesRunTime.unboxToInt((Object)i)));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ReverseConnectionTest.$anonfun$testAuthenticationFailure$2(this, link);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testBrokerInterceptor() {
        Properties extraProps = new Properties();
        TestInterceptor$.MODULE$.reset();
        extraProps.setProperty(KafkaConfig$.MODULE$.BrokerInterceptorClassProp(), TestInterceptor.class.getName());
        int x$1 = 1;
        SecurityProtocol x$2 = SecurityProtocol.SASL_SSL;
        Option<String> x$4 = this.kafkaConfig$default$3();
        KafkaConfig sourceConfig = this.kafkaConfig(x$1, x$2, x$4, extraProps);
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        int numRequests = 10;
        TestPrincipal testPrincipal = new TestPrincipal(this.principal(sourceServer));
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer, (Option<KafkaPrincipal>)new Some((Object)testPrincipal), numRequests);
        TestInterceptor$.MODULE$.verify(numRequests + 1, testPrincipal);
    }

    @Test
    public void testReverseConnectionsToMultipleServers() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig1 = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig2 = this.kafkaConfig(3, SecurityProtocol.SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer1 = this.newSocketServer(destConfig1);
        SocketServer destServer2 = this.newSocketServer(destConfig2);
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer1, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer2, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
    }

    @Test
    public void testReverseConnectionsFromMultipleServers() {
        KafkaConfig config1 = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig config2 = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig config3 = this.kafkaConfig(3, SecurityProtocol.SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        SocketServer server1 = this.newSocketServer(config1);
        SocketServer server2 = this.newSocketServer(config2);
        SocketServer server3 = this.newSocketServer(config3);
        this.verifyReverseConnection(UUID.randomUUID(), server1, server2, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
        this.verifyReverseConnection(UUID.randomUUID(), server3, server2, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
        this.verifyReverseConnection(UUID.randomUUID(), server3, server1, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
    }

    @Test
    public void testMultipleReverseConnectionsBetweenSameServers() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, this.kafkaConfig$default$3(), this.kafkaConfig$default$4());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConnectionLimit() {
        Properties extraProps = new Properties();
        extraProps.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "1");
        int x$1 = 1;
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        Option<String> x$4 = this.kafkaConfig$default$3();
        KafkaConfig sourceConfig = this.kafkaConfig(x$1, x$2, x$4, extraProps);
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        try (Socket socket = new Socket("localhost", sourceServer.boundPort(listenerName), null, 0);){
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ReverseConnectionTest.$anonfun$testConnectionLimit$1(sourceServer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ReverseConnectionTest.$anonfun$testConnectionLimit$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
            Mockito.when((Object)channel.socketAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
            Mockito.when((Object)channel.socketDescription()).thenReturn((Object)"socket description");
            ReverseNode reverseNode = new ReverseNode(1, 1, "localhost", 0, UUID.randomUUID(), -1, listenerName, KafkaPrincipal.ANONYMOUS, Optional.empty(), null);
            Assertions.assertThrows(TooManyConnectionsException.class, () -> sourceServer.reverseAndAdd(listenerName, new ReverseChannel(channel, reverseNode, x$1 -> {})));
        }
    }

    private void verifyReverseConnection(KafkaConfig sourceServerConfig, KafkaConfig destServerConfig) {
        this.verifyReverseConnection(sourceServerConfig, destServerConfig, true);
        this.verifyReverseConnection(sourceServerConfig, destServerConfig, false);
    }

    private void verifyReverseConnection(KafkaConfig sourceServerConfig, KafkaConfig destServerConfig, boolean closeClientFirst) {
        SocketServer sourceServer = this.newSocketServer(sourceServerConfig);
        SocketServer destServer = this.newSocketServer(destServerConfig);
        this.verifyReverseConnection(UUID.randomUUID(), sourceServer, destServer, this.verifyReverseConnection$default$4(), this.verifyReverseConnection$default$5());
        Assertions.assertEquals((int)1, (int)sourceServer.connectionCount(InetAddress.getLoopbackAddress()));
        Assertions.assertEquals((int)0, (int)destServer.connectionCount(InetAddress.getLoopbackAddress()));
        if (closeClientFirst) {
            this.verifyCloseClientSideReverseConnection(sourceServer);
            return;
        }
        this.verifyCloseServerSideReverseConnection(sourceServer);
    }

    private void verifyCloseClientSideReverseConnection(SocketServer sourceServer) {
        this.kafka$network$ReverseConnectionTest$$links().values().foreach((Function1 & Serializable & scala.Serializable)link -> {
            ReverseConnectionTest.$anonfun$verifyCloseClientSideReverseConnection$1(this, sourceServer, link);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCloseServerSideReverseConnection(SocketServer sourceServer) {
        PublicCredential credential = this.publicCredential(sourceServer);
        sourceServer.closeConnectionsWithCredential(credential);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$verifyCloseServerSideReverseConnection$1(sourceServer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReverseConnectionTest.$anonfun$verifyCloseServerSideReverseConnection$2(credential));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$network$ReverseConnectionTest$$links().values().foreach((Function1 & Serializable & scala.Serializable)link -> {
            ReverseConnectionTest.$anonfun$verifyCloseServerSideReverseConnection$3(this, link);
            return BoxedUnit.UNIT;
        });
    }

    private LinkComponents createLinkClients(UUID linkId, SocketServer sourceServer, SocketServer destServer) {
        Node sourceNode = new Node(sourceServer.config().brokerId(), "localhost", sourceServer.boundPort(this.listenerName(sourceServer.config())));
        Node destNode = new Node(destServer.config().brokerId(), "localhost", destServer.boundPort(this.listenerName(destServer.config())));
        NetworkClient clientFromSource = this.newNetworkClient(destServer, sourceServer, (MetadataUpdater)this.metadataUpdater(destNode));
        clientFromSource.enableSourceClusterLink(linkId, null, this.reversalData(linkId, sourceServer), (sourceChannel, reverseNode) -> this.onReverseClientConnection(sourceChannel, reverseNode));
        NetworkClient clientFromDest = this.newNetworkClient(sourceServer, destServer, (MetadataUpdater)this.metadataUpdater(sourceNode));
        UUID id = new UUID(linkId.getMostSignificantBits(), linkId.getLeastSignificantBits());
        clientFromDest.enableDestinationClusterLink(id, null, x$2 -> {});
        LinkComponents linkComponents = new LinkComponents(sourceServer, destServer, clientFromSource, clientFromDest);
        this.kafka$network$ReverseConnectionTest$$links().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)linkComponents));
        return linkComponents;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReverseConnection(UUID linkId, SocketServer sourceServer, SocketServer destServer, Option<KafkaPrincipal> principalOpt, int numRequests) {
        void waitForClient_predicate;
        void waitForClient_predicate2;
        LinkComponents link = this.createLinkClients(linkId, sourceServer, destServer);
        KafkaPrincipal sourcePrincipal = (KafkaPrincipal)principalOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.principal(sourceServer));
        ListenerName sourceListenerName = ((EndPoint)sourceServer.config().effectiveAdvertisedListeners().head()).listenerName();
        ReverseNode reverseDestNode = link.clientFromSource().reverseConnectionManager().createReversibleConnection(123, destServer.config().brokerId(), sourceListenerName, sourcePrincipal, Optional.empty(), this.authenticationContext(sourceServer), this.time().milliseconds());
        Node sourceNode = new Node(sourceServer.config().brokerId(), "localhost", sourceServer.boundPort(this.listenerName(sourceServer.config())));
        this.waitForReversal(link.clientFromSource(), destServer, reverseDestNode);
        String string = "Reversed node did not send ApiVersions request in destination client";
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReverseConnectionTest.$anonfun$verifyReverseConnection$2(link, sourceNode, x$3));
        NetworkClient waitForClient_client = link.clientFromDest();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, waitForClient_client, (Function1)waitForClient_predicate2)) {
            void waitForClient_waitUntilTrue_pause;
            void waitForClient_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)((String)waitForClient_errorMessage));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
        this.processNextRequest(sourceServer, link.clientFromDest(), sourceNode, (Option<KafkaPrincipal>)new Some((Object)sourcePrincipal));
        String string2 = "Reversed node not ready in destination client";
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReverseConnectionTest.$anonfun$verifyReverseConnection$3(link, sourceNode, x$4));
        NetworkClient waitForClient_client2 = link.clientFromDest();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitForClient_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, waitForClient_client2, (Function1)waitForClient_predicate)) {
            void waitForClient_waitUntilTrue_pause;
            void waitForClient_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime2 + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)((String)waitForClient_errorMessage));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> {
            NetworkClient x$1 = link.clientFromDest();
            Some x$4 = new Some((Object)sourcePrincipal);
            AbstractRequest.Builder<?> x$52 = this.sendAndReceive$default$4();
            this.sendAndReceive(x$1, sourceServer, sourceNode, x$52, (Option<KafkaPrincipal>)x$4);
        });
    }

    private Option<KafkaPrincipal> verifyReverseConnection$default$4() {
        return None$.MODULE$;
    }

    private int verifyReverseConnection$default$5() {
        return 5;
    }

    private KafkaConfig kafkaConfig(int brokerId, SecurityProtocol securityProtocol, Option<String> saslMechanism, Properties extraProps) {
        Properties properties;
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            properties = this.plaintextServerProps(brokerId);
        } else if (SecurityProtocol.SSL.equals(securityProtocol)) {
            properties = this.sslServerProps(brokerId);
        } else {
            boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol);
            if (bl) {
                properties = this.saslServerProps(brokerId, securityProtocol, saslMechanism);
            } else {
                throw new MatchError((Object)securityProtocol);
            }
        }
        properties.setProperty(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.QueuedMaxRequestsProp(), "50");
        properties.setProperty(KafkaConfig$.MODULE$.SocketRequestMaxBytesProp(), "1000");
        properties.setProperty(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "5");
        properties.setProperty(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), "60000");
        properties.putAll((java.util.Map<?, ?>)extraProps);
        return KafkaConfig$.MODULE$.fromProps(properties);
    }

    private Option<String> kafkaConfig$default$3() {
        return None$.MODULE$;
    }

    private Properties kafkaConfig$default$4() {
        return new Properties();
    }

    private Properties plaintextServerProps(int brokerId) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 0;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private Properties sslServerProps(int brokerId) {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)SecurityProtocol.SSL);
        Some x$4 = new Some((Object)trustStoreFile);
        boolean x$5 = false;
        boolean x$6 = true;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$9 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$7, x$8, x$9, (Option<SecurityProtocol>)x$3, (Option<File>)x$4, x$10, x$5, x$11, x$12, x$6, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private Properties saslServerProps(int brokerId, SecurityProtocol securityProtocol, Option<String> saslMechanism) {
        String mechanism = (String)saslMechanism.getOrElse((Function0 & Serializable & scala.Serializable)() -> "SCRAM-SHA-256");
        Properties saslProps = JaasTestUtils$.MODULE$.saslConfigs((Option<Properties>)None$.MODULE$);
        saslProps.setProperty(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), mechanism);
        saslProps.setProperty("sasl.enabled.mechanisms", mechanism);
        saslProps.setProperty(new StringBuilder(16).append(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix(mechanism)).append("sasl.jaas.config").toString(), ((JaasTestUtils.JaasModule)JaasTestUtils$.MODULE$.kafkaServerSection("KafkaServer", (Seq<String>)new .colon.colon((Object)mechanism, (List)Nil$.MODULE$), (Option<File>)None$.MODULE$).modules().head()).toString());
        if (ScramMechanism.isScram((String)mechanism)) {
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
        }
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)securityProtocol);
        SecurityProtocol securityProtocol2 = securityProtocol;
        SecurityProtocol securityProtocol3 = SecurityProtocol.SASL_SSL;
        None$ x$4 = !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null) ? new Some((Object)File.createTempFile("truststore", ".jks")) : None$.MODULE$;
        Some x$5 = new Some((Object)saslProps);
        boolean x$6 = false;
        SecurityProtocol securityProtocol4 = securityProtocol;
        SecurityProtocol securityProtocol5 = SecurityProtocol.SASL_PLAINTEXT;
        boolean x$7 = !(securityProtocol4 != null ? !securityProtocol4.equals(securityProtocol5) : securityProtocol5 != null);
        SecurityProtocol securityProtocol6 = securityProtocol;
        SecurityProtocol securityProtocol7 = SecurityProtocol.SASL_SSL;
        boolean x$8 = !(securityProtocol6 != null ? !securityProtocol6.equals(securityProtocol7) : securityProtocol7 != null);
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$9, x$10, x$11, (Option<SecurityProtocol>)x$3, (Option<File>)x$4, (Option<Properties>)x$5, x$6, x$7, x$12, x$13, x$14, x$8, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private void addScramUser(String mechanism, String username, String password) {
        if (this.credentialProvider().credentialCache().cache(mechanism, ScramCredential.class) == null) {
            ScramCredentialUtils.createCache((CredentialCache)this.credentialProvider().credentialCache(), Collections.singletonList(mechanism));
        }
        ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
        ScramCredential credential = new ScramFormatter(scramMechanism).generateCredential(password, 4096);
        this.credentialProvider().credentialCache().cache(scramMechanism.mechanismName(), ScramCredential.class).put(username, (Object)credential);
    }

    private ListenerName listenerName(KafkaConfig config) {
        return ((EndPoint)config.listeners().head()).listenerName();
    }

    private SocketServer newSocketServer(KafkaConfig config) {
        ReverseNode.ReverseCallback reverseCallback = new ReverseNode.ReverseCallback(this){
            private final /* synthetic */ ReverseConnectionTest $outer;

            public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
                ((LinkComponents)this.$outer.kafka$network$ReverseConnectionTest$$links().apply((Object)reverseNode.linkId())).clientFromDest().reverseAndAdd(new ReverseChannel(channel, reverseNode, x$6 -> {}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER);
        Metrics x$2 = new Metrics();
        Time x$3 = this.time();
        CredentialProvider x$4 = this.credentialProvider();
        Some x$6 = new Some((Object)reverseCallback);
        RequestCallback x$7 = SocketServer$.MODULE$.$lessinit$greater$default$6();
        AuditLogProvider x$8 = SocketServer$.MODULE$.$lessinit$greater$default$7();
        Option x$9 = SocketServer$.MODULE$.$lessinit$greater$default$9();
        SocketServer server = new SocketServer(config, x$2, x$3, x$4, (ApiVersionManager)apiVersionManager, x$7, x$8, (Option)x$6, x$9);
        server.enableRequestProcessing((Map)Predef$.MODULE$.Map().empty());
        this.servers().$plus$eq((Object)server);
        return server;
    }

    private ClientRequest newClientRequest(NetworkClient networkClient, String nodeId, AbstractRequest.Builder<?> builder, CompletableFuture<Void> future) {
        RequestCompletionHandler handler = new RequestCompletionHandler(null, future){
            private final CompletableFuture future$1;

            public void onComplete(ClientResponse response) {
                this.future$1.complete(null);
            }
            {
                this.future$1 = future$1;
            }
        };
        return networkClient.newClientRequest(nodeId, builder, this.time().milliseconds(), true, 10000, handler);
    }

    private RequestChannel.Request receiveRequest(RequestChannel channel, long timeout) {
        RequestChannel.BaseRequest baseRequest = channel.receiveRequest(timeout);
        if (!(baseRequest instanceof RequestChannel.Request)) {
            if (RequestChannel.ShutdownRequest$.MODULE$.equals(baseRequest)) {
                throw Assertions$.MODULE$.fail("Unexpected shutdown received", new Position("ReverseConnectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
            }
            if (baseRequest == null) {
                throw Assertions$.MODULE$.fail("receiveRequest timed out", new Position("ReverseConnectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
            }
            throw new MatchError((Object)baseRequest);
        }
        RequestChannel.Request request = (RequestChannel.Request)baseRequest;
        return request;
    }

    private long receiveRequest$default$2() {
        return 2000L;
    }

    /*
     * WARNING - void declaration
     */
    private void processNextRequest(SocketServer server, NetworkClient client, Node node, Option<KafkaPrincipal> expectedPrincipal) {
        void var11_16;
        void var10_15;
        ApiVersionsResponse apiVersionsResponse;
        None$ none$;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$processNextRequest$1(this, client, node, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReverseConnectionTest.$anonfun$processNextRequest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        RequestChannel.Request request = this.receiveRequest(server.dataPlaneRequestChannel(), this.receiveRequest$default$2());
        expectedPrincipal.foreach((Function1 & Serializable & scala.Serializable)principal -> {
            ReverseConnectionTest.$anonfun$processNextRequest$3(request, principal);
            return BoxedUnit.UNIT;
        });
        ApiKeys apiKeys = request.header().apiKey();
        if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            none$ = None$.MODULE$;
            apiVersionsResponse = ApiVersionsResponse.defaultApiVersionsResponse((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(new MetadataResponseData.MetadataResponseTopicCollection()).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
            none$ = None$.MODULE$;
            apiVersionsResponse = new MetadataResponse(data, 0);
        } else if (ApiKeys.REVERSE_CONNECTION.equals(apiKeys)) {
            ReverseConnectionRequestData data = ((ReverseConnectionRequest)request.body(ClassTag$.MODULE$.apply(ReverseConnectionRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).data();
            ReverseNode node2 = new ReverseNode(data.sourceBrokerId(), data.sourceBrokerId(), data.sourceHost(), data.sourcePort(), new UUID(data.clusterLinkId().getMostSignificantBits(), data.clusterLinkId().getLeastSignificantBits()), data.initiateRequestId(), request.context().listenerName, request.context().principal, request.context().principalSerde, request.context().authenticationContext);
            none$ = new Some((Object)node2);
            apiVersionsResponse = new ReverseConnectionResponse(Errors.NONE, null, 0);
        } else {
            throw new IllegalArgumentException(new StringBuilder(14).append(apiKeys).append(" not supported").toString());
        }
        AbstractResponse response = (AbstractResponse)apiVersionsResponse;
        Option reverseNode = (Option)none$;
        void response2 = var10_15;
        void reverseNode2 = var11_16;
        ByteBuffer byteBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)response2, (short)request.header().apiVersion(), (int)request.header().correlationId());
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.context().connectionId, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)byteBuffer));
        RequestChannel.SendResponse responseData = reverseNode2.isEmpty() ? new RequestChannel.SendResponse(request, (Send)send, (Option)None$.MODULE$) : new RequestChannel.SendResponseAndReverse(request, (Send)send, (Option)None$.MODULE$, (ReverseNode)reverseNode2.get());
        server.dataPlaneRequestChannel().sendResponse((RequestChannel.Response)responseData);
    }

    private Option<KafkaPrincipal> processNextRequest$default$4() {
        return None$.MODULE$;
    }

    private MetadataRequest.Builder metadataRequestBuilder() {
        return MetadataRequest.Builder.allTopics();
    }

    /*
     * WARNING - void declaration
     */
    private ManualMetadataUpdater metadataUpdater(Node node) {
        void var2_2;
        ManualMetadataUpdater metadataUpdater = new ManualMetadataUpdater();
        metadataUpdater.setNodes(Collections.singletonList(node));
        return var2_2;
    }

    private NetworkClient newNetworkClient(SocketServer remoteServer, SocketServer localServer, MetadataUpdater metadataUpdater) {
        SecurityProtocol securityProtocol;
        HashMap<String, String> clientProps;
        String clientId;
        LogContext logContext;
        block3: {
            KafkaConfig serverConfig;
            block2: {
                logContext = new LogContext();
                serverConfig = remoteServer.config();
                clientId = new StringBuilder(8).append("client-").append(localServer.config().brokerId()).append("-").append(this.networkClients().size()).toString();
                clientProps = new HashMap<String, String>();
                serverConfig.originals().forEach((k, v) -> clientProps.put((String)k, (String)v));
                EndPoint endpoint = (EndPoint)serverConfig.listeners().head();
                securityProtocol = endpoint.securityProtocol();
                clientProps.put("bootstrap.servers", endpoint.connectionString());
                clientProps.put("security.protocol", securityProtocol.name);
                if (securityProtocol.equals(SecurityProtocol.SASL_PLAINTEXT)) break block2;
                SecurityProtocol securityProtocol2 = securityProtocol;
                SecurityProtocol securityProtocol3 = SecurityProtocol.SASL_SSL;
                if (securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null) break block3;
            }
            String saslMechanism = serverConfig.saslMechanismInterBrokerProtocol();
            clientProps.put("sasl.mechanism", saslMechanism);
            clientProps.put("sasl.jaas.config", ((JaasTestUtils.JaasModule)JaasTestUtils$.MODULE$.kafkaClientSection((Option<String>)new Some((Object)saslMechanism), (Option<File>)None$.MODULE$).modules().head()).toString());
        }
        AdminClientConfig clientConfig = new AdminClientConfig(clientProps);
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)clientConfig, null, (String)clientConfig.getString("sasl.mechanism"), (Time)this.time(), (boolean)true, (LogContext)logContext);
        Metrics metrics = new Metrics();
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(clientConfig.getLong("connections.max.idle.ms")), metrics, this.time(), clientId, Collections.emptyMap(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient(metadataUpdater, null, (Selectable)selector, clientId, 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(clientConfig.getInt("receive.buffer.bytes")), Predef$.MODULE$.Integer2int(clientConfig.getInt("request.timeout.ms")), Predef$.MODULE$.Long2long(clientConfig.getLong("socket.connection.setup.timeout.ms")), Predef$.MODULE$.Long2long(clientConfig.getLong("socket.connection.setup.timeout.max.ms")), this.time(), true, new ApiVersions(), null, new LogContext());
        this.networkClients().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)networkClient), (Object)metrics));
        return networkClient;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForClient(NetworkClient client, Function1<NetworkClient, Object> predicate, String errorMessage) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, client, predicate)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReady(NetworkClient client, SocketServer server, Node node) {
        Assertions.assertFalse((boolean)client.ready(node, this.time().milliseconds()), (String)"Client ready before poll");
        this.processNextRequest(server, client, node, this.processNextRequest$default$4());
        String string = "Node not ready";
        Function1 & Serializable & scala.Serializable waitForClient_predicate = (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.ready(node, this.time().milliseconds()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, client, waitForClient_predicate)) {
            void waitForClient_waitUntilTrue_pause;
            void waitForClient_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)((String)waitForClient_errorMessage));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReversal(NetworkClient client, SocketServer server, ReverseNode node) {
        Assertions.assertFalse((boolean)client.ready((Node)node, this.time().milliseconds()), (String)"Client ready before poll");
        this.processNextRequest(server, client, (Node)node, this.processNextRequest$default$4());
        this.processNextRequest(server, client, (Node)node, this.processNextRequest$default$4());
        CompletableFuture future = node.future();
        String string = "Reversal not complete";
        Function1 & Serializable & scala.Serializable waitForClient_predicate = (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)future.isDone());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, client, waitForClient_predicate)) {
            void waitForClient_waitUntilTrue_pause;
            void waitForClient_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)((String)waitForClient_errorMessage));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
        future.get();
    }

    /*
     * WARNING - void declaration
     */
    private void sendAndReceive(NetworkClient client, SocketServer server, Node node, AbstractRequest.Builder<?> requestBuilder, Option<KafkaPrincipal> expectedPrincipal) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ClientRequest request = this.newClientRequest(client, node.idString(), requestBuilder, future);
        client.send(request, this.time().milliseconds());
        this.processNextRequest(server, client, node, expectedPrincipal);
        String string = "Response not processed";
        Function1 & Serializable & scala.Serializable waitForClient_predicate = (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)future.isDone());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$waitForClient$1(this, client, waitForClient_predicate)) {
            void waitForClient_waitUntilTrue_pause;
            void waitForClient_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)((String)waitForClient_errorMessage));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
    }

    private AbstractRequest.Builder<?> sendAndReceive$default$4() {
        return this.metadataRequestBuilder();
    }

    private Option<KafkaPrincipal> sendAndReceive$default$5() {
        return None$.MODULE$;
    }

    private ReverseConnectionRequestData reversalData(UUID linkId, SocketServer sourceServer) {
        EndPoint endpoint = (EndPoint)sourceServer.config().listeners().head();
        return new ReverseConnectionRequestData().setClusterLinkId(new Uuid(linkId.getMostSignificantBits(), linkId.getLeastSignificantBits())).setTargetClusterId("destClusterId").setSourceClusterId("sourceClusterId").setSourceBrokerId(sourceServer.config().brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void onReverseClientConnection(KafkaChannel sourceChannel, ReverseNode reverseNode) {
        ((LinkComponents)this.kafka$network$ReverseConnectionTest$$links().apply((Object)reverseNode.linkId())).sourceServer().reverseAndAdd(reverseNode.localListenerName(), new ReverseChannel(sourceChannel, reverseNode, x$11 -> {}));
        this.reverseSourceChannels().$plus$eq((Object)sourceChannel);
    }

    private KafkaPrincipal principal(SocketServer server) {
        KafkaPrincipal kafkaPrincipal;
        SecurityProtocol securityProtocol = ((EndPoint)server.config().listeners().head()).securityProtocol();
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            kafkaPrincipal = KafkaPrincipal.ANONYMOUS;
        } else if (SecurityProtocol.SSL.equals(securityProtocol)) {
            kafkaPrincipal = new KafkaPrincipal("User", "CN=test");
        } else {
            String string = server.config().saslMechanismInterBrokerProtocol();
            String string2 = "PLAIN";
            kafkaPrincipal = string != null && string.equals(string2) ? new ConfluentPrincipal("TenantUser", JaasTestUtils$.MODULE$.KafkaPlainUser(), new StringBuilder(7).append(JaasTestUtils$.MODULE$.KafkaPlainUser()).append("-apikey").toString()) : new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser());
        }
        return kafkaPrincipal;
    }

    /*
     * Unable to fully structure code
     */
    private PublicCredential publicCredential(SocketServer server) {
        v0 = securityProtocol = ((EndPoint)server.config().listeners().head()).securityProtocol();
        var5_3 = SecurityProtocol.SASL_PLAINTEXT;
        if (!(v0 == null ? var5_3 != null : v0.equals(var5_3) == false)) ** GOTO lbl-1000
        v1 = securityProtocol;
        var6_4 = SecurityProtocol.SASL_SSL;
        if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = server.config().saslMechanismInterBrokerProtocol();
        } else {
            v2 = null;
        }
        saslMechanism = v2;
        var7_6 = this.principal(server);
        if (var7_6 instanceof ConfluentPrincipal) {
            var2_7 = ((ConfluentPrincipal)var7_6).authenticationId();
        } else if (var7_6 != null) {
            var2_7 = var7_6.getName();
        } else {
            throw new MatchError(null);
        }
        return PublicCredential.authenticatedCredential((String)var2_7, (SecurityProtocol)securityProtocol, (String)saslMechanism);
    }

    private AuthenticationContext authenticationContext(SocketServer server) {
        PlaintextAuthenticationContext plaintextAuthenticationContext;
        String listenerName = ((EndPoint)server.config().listeners().head()).listenerName().value();
        InetAddress clientAddress = InetAddress.getLoopbackAddress();
        SecurityProtocol securityProtocol = ((EndPoint)server.config().listeners().head()).securityProtocol();
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            plaintextAuthenticationContext = new PlaintextAuthenticationContext(clientAddress, listenerName);
        } else if (SecurityProtocol.SSL.equals(securityProtocol)) {
            plaintextAuthenticationContext = new SslAuthenticationContext((SSLSession)Mockito.mock(SSLSession.class), clientAddress, listenerName);
        } else {
            SaslServer saslServer = (SaslServer)Mockito.mock(SaslServer.class);
            Mockito.when((Object)saslServer.getMechanismName()).thenReturn((Object)server.config().saslMechanismInterBrokerProtocol());
            plaintextAuthenticationContext = new SaslAuthenticationContext(saslServer, securityProtocol, clientAddress, listenerName);
        }
        return plaintextAuthenticationContext;
    }

    private void shutdownServerAndMetrics(SocketServer server) {
        server.shutdown();
        server.metrics().close();
    }

    private void verifyNetworkClientEmpty(NetworkClient client) {
        client.poll(0L, this.time().milliseconds());
        TestUtils.verifyEmptyFields((Object)client, (int)1, (String[])new String[]{"metadataUpdater"});
        TestUtils.verifyEmptyFields((Object)((Selectable)TestUtils.fieldValue((Object)client, NetworkClient.class, (String)"selector")), (int)1, (String[])new String[0]);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            NetworkClient client = (NetworkClient)x0$1._1();
            Metrics metrics = (Metrics)x0$1._2();
            client.close();
            metrics.close();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ReverseNode $anonfun$testAuthenticationFailure$1(ReverseConnectionTest $this, LinkComponents link$1, SocketServer destServer$1, ListenerName sourceListenerName$1, SocketServer sourceServer$1, int i) {
        return link$1.clientFromSource().reverseConnectionManager().createReversibleConnection(i, destServer$1.config().brokerId(), sourceListenerName$1, $this.principal(sourceServer$1), Optional.empty(), null, $this.time().milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testAuthenticationFailure$2(ReverseConnectionTest $this, LinkComponents link$1) {
        link$1.clientFromSource().poll(1L, $this.time().milliseconds());
        $this.verifyNetworkClientEmpty(link$1.clientFromSource());
    }

    public static final /* synthetic */ boolean $anonfun$testConnectionLimit$1(SocketServer sourceServer$2) {
        return sourceServer$2.connectionCount(InetAddress.getLoopbackAddress()) > 0;
    }

    public static final /* synthetic */ String $anonfun$testConnectionLimit$2() {
        return "Connection not created";
    }

    public static final /* synthetic */ boolean $anonfun$verifyCloseClientSideReverseConnection$2(SocketServer sourceServer$3) {
        return sourceServer$3.connectionCount(InetAddress.getLoopbackAddress()) == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyCloseClientSideReverseConnection$3() {
        return "Source server-side connection not closed";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyCloseClientSideReverseConnection$1(ReverseConnectionTest $this, SocketServer sourceServer$3, LinkComponents link) {
        $this.verifyNetworkClientEmpty(link.clientFromSource());
        link.clientFromDest().close(link.clientFromDest().leastLoadedNode($this.time().milliseconds()).idString());
        $this.verifyNetworkClientEmpty(link.clientFromDest());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$verifyCloseClientSideReverseConnection$2(sourceServer$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReverseConnectionTest.$anonfun$verifyCloseClientSideReverseConnection$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyCloseServerSideReverseConnection$1(SocketServer sourceServer$4) {
        return sourceServer$4.connectionCount(InetAddress.getLoopbackAddress()) == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyCloseServerSideReverseConnection$2(PublicCredential credential$1) {
        return new StringBuilder(45).append("Connection with public credential ").append(credential$1).append(" not closed").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyCloseServerSideReverseConnection$3(ReverseConnectionTest $this, LinkComponents link) {
        $this.verifyNetworkClientEmpty(link.clientFromSource());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                $this.verifyNetworkClientEmpty(link.clientFromDest());
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyReverseConnection$2(LinkComponents link$3, Node sourceNode$1, NetworkClient x$3) {
        return link$3.clientFromDest().inFlightRequestCount(sourceNode$1.idString()) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyReverseConnection$3(LinkComponents link$3, Node sourceNode$1, NetworkClient x$4) {
        return link$3.clientFromDest().isReady(sourceNode$1, System.currentTimeMillis());
    }

    public static final /* synthetic */ boolean $anonfun$processNextRequest$1(ReverseConnectionTest $this, NetworkClient client$1, Node node$1, SocketServer server$1) {
        client$1.poll(1L, $this.time().milliseconds());
        Assertions.assertNull((Object)client$1.authenticationException(node$1));
        return server$1.dataPlaneRequestChannel().requestQueueSize() > 0;
    }

    public static final /* synthetic */ String $anonfun$processNextRequest$2() {
        return "Request did not arrive on server";
    }

    public static final /* synthetic */ void $anonfun$processNextRequest$3(RequestChannel.Request request$1, KafkaPrincipal principal) {
        Assertions.assertEquals((Object)principal, (Object)request$1.session().principal());
    }

    public static final /* synthetic */ boolean $anonfun$waitForClient$1(ReverseConnectionTest $this, NetworkClient client$2, Function1 predicate$1) {
        client$2.poll(1000L, $this.time().milliseconds());
        return BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)client$2));
    }
}

