/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.MergedLog$;
import kafka.log.SegmentDeletion$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\"E\u0005%CQ\u0001\u0015\u0001\u0005\u0002EC\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011A+\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0003y\u0006\"C3\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaA\u001c\u0001!\u0002\u0013A\u0007bB8\u0001\u0005\u0004%\t\u0001\u001d\u0005\u0007{\u0002\u0001\u000b\u0011B9\t\u000by\u0004A\u0011A@\t\r\u0005]\u0001\u0001\"\u0001\u0000\u0011\u0019\t\t\u0003\u0001C\u0001\u007f\"1\u00111\u0006\u0001\u0005\u0002}Da!a\f\u0001\t\u0003y\bBBA\u001a\u0001\u0011\u0005q\u0010\u0003\u0004\u00028\u0001!\ta \u0005\u0007\u0003w\u0001A\u0011A@\t\r\u0005}\u0002\u0001\"\u0001\u0000\u0011\u0019\t\u0019\u0005\u0001C\u0001\u007f\"1\u0011q\t\u0001\u0005\u0002}Da!a\u0013\u0001\t\u0003y\bBBA(\u0001\u0011\u0005q\u0010\u0003\u0004\u0002T\u0001!\ta \u0005\u0007\u0003/\u0002A\u0011A@\t\r\u0005m\u0003\u0001\"\u0001\u0000\u0011\u0019\ty\u0006\u0001C\u0001\u007f\"1\u00111\r\u0001\u0005\u0002}Da!a\u001a\u0001\t\u0003y\bBBA6\u0001\u0011\u0005q\u0010C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!1\u0011Q\u0012\u0001\u0005\u0002}Da!!%\u0001\t\u0003y\bBBAK\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\u001a\u0002!\ta \u0005\u0007\u0003;\u0003A\u0011A@\t\r\u0005\u0005\u0006\u0001\"\u0001\u0000\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCa!a2\u0001\t\u0003y\bBBAf\u0001\u0011\u0005q\u0010\u0003\u0004\u0002P\u0002!\ta \u0005\u0007\u0003'\u0004A\u0011A@\t\r\u0005]\u0007\u0001\"\u0001\u0000\u0011\u0019\tY\u000e\u0001C\u0001\u007f\"1\u0011q\u001c\u0001\u0005\u0002}Da!a9\u0001\t\u0003y\bBBAt\u0001\u0011\u0005q\u0010\u0003\u0004\u0002l\u0002!\ta \u0005\u0007\u0003_\u0004A\u0011A@\t\r\u0005M\b\u0001\"\u0001\u0000\u0011\u0019\t9\u0010\u0001C\u0001\u007f\u001a1\u00111 \u0001\u0001\u0003{Da\u0001U\u001a\u0005\u0002\t%\u0002bBAag\u0011\u0005#q\u0006\u0005\b\u0005\u000b\u001aD\u0011\tB$\u0011\u001d\u00119f\rC!\u00053B\u0011B!\u001b\u0001\u0005\u0004%\tAa\u001b\t\u0011\tM\u0004\u0001)A\u0005\u0005[BqA!\u001e\u0001\t\u0003\u00119\bC\u0005\u0003\"\u0002\t\n\u0011\"\u0001\u0003$\"I!\u0011\u0018\u0001\u0012\u0002\u0013\u0005!1\u0018\u0005\b\u0005\u007f\u0003A\u0011\u0001Ba\u0011%\u0011Y\rAI\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0003N\u0002\t\n\u0011\"\u0001\u0003<\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bh\u0001\u0011\u0005!1\u001e\u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0005QY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rV3ti*\u0011QIR\u0001\u0005e\u00064GOC\u0001H\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u000b\u0005\u0002T\u00015\tA)A\u0004uK6\u0004H)\u001b:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0005%|'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013AAR5mK\u0006YA/Z7q\t&\u0014x\fJ3r)\t\u00017\r\u0005\u0002LC&\u0011!\r\u0014\u0002\u0005+:LG\u000fC\u0004e\u0007\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0013'\u0001\u0005uK6\u0004H)\u001b:!\u0003!iwnY6US6,W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-4\u0015!B;uS2\u001c\u0018BA7k\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u001diW\r\u001e:jGN,\u0012!\u001d\t\u0003enl\u0011a\u001d\u0006\u0003_RT!!\u001e<\u0002\r\r|W.\\8o\u0015\t9uO\u0003\u0002ys\u00061\u0011\r]1dQ\u0016T\u0011A_\u0001\u0004_J<\u0017B\u0001?t\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002A\"\u001a\u0011\"a\u0001\u0011\t\u0005\u0015\u00111C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005\u0019\u0011\r]5\u000b\t\u00055\u0011qB\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\t\"_\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003+\t9A\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u0015\u0005m\u0001\u0003BA\u0003\u0003;IA!a\b\u0002\b\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cHoQ8oM&<\u0007fA\u0006\u0002&A!\u0011QAA\u0014\u0013\u0011\tI#a\u0002\u0003\tQ+7\u000f^\u0001\u001bi\u0016\u001cH/\u00168fqB,7\r^3e\u0003B\u0004XM\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004\u0019\u0005\u0015\u0012A\u0005;fgR\u001c%/Z1uKNs\u0017\r]:i_RD3!DA\u0013\u0003}!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;Ge>lWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004\u001d\u0005\u0015\u0012\u0001\u000b;fgR\u001c%/Z1uKNs\u0017\r]:i_Rd\u0015\r^3s)\"\fg\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0007fA\b\u0002&\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u001bV\u001c\u0007\u000eT1uKJ,\u0005o\\2iQ\r\u0001\u0012QE\u0001'i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GOQ3g_J,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\t\u0002&\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\t&4XM]4j]\u001e,\u0005o\\2iQ\r\u0011\u0012QE\u0001\u001di\u0016\u001cHo\u0011:fCR,7K\\1qg\"|Go\u00147eKJ,\u0005o\\2iQ\r\u0019\u0012QE\u0001#i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GoV5uQ6K7o]5oO\u0016\u0003xn\u00195)\u0007Q\t)#\u0001\u000euKN$8I]3bi\u0016,\u00050[:uS:<7K\\1qg\"|G\u000fK\u0002\u0016\u0003K\t1\u0002^3tiR{\u0007/[2JI\"\u001aa#!\n\u0002/Q,7\u000f\u001e*fC\u0012l\u0015n]:j]\u001e\u001cf.\u00199tQ>$\bfA\f\u0002&\u0005iB/Z:u\t\u0016dW\r^3O_:,\u00050[:uK:$8K\\1qg\"|G\u000fK\u0002\u0019\u0003K\t\u0011\u0005^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z)>d\u0015\r^3tiNs\u0017\r]:i_RD3!GA\u0013\u0003\r\"Xm\u001d;UeVt7-\u0019;f/&dGNU3n_Z,w\n\u001c3feNs\u0017\r]:i_RD3AGA\u0013\u0003\r\"Xm\u001d;Ti\u0006\u0014H/\u001e9XSRD\u0017J\u001c<bY&$7K\\1qg\"|Go\u0015;bi\u0016D3aGA\u0013\u00031\"Xm\u001d;T]\u0006\u00048\u000f[8u\t\u0016dW\r^5p]^KG\u000f[%om\u0006d\u0017\u000eZ*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002\u001d\u0003K\ta\"\\3uC\u0012\fG/\u0019'pO\u0012K'\u000fF\u0002W\u0003gBa!!\u001e\u001e\u0001\u00041\u0016A\u00027pO\u0012K'/\u0001\nxe&$X-R7qif\u001cf.\u00199tQ>$H#\u00021\u0002|\u0005}\u0004BBA?=\u0001\u0007a+A\u0006nKR\fG-\u0019;b\t&\u0014\bbBAA=\u0001\u0007\u00111Q\u0001\u000bg:\f\u0007o\u001d5pi&#\u0007\u0003BAC\u0003\u0013k!!a\"\u000b\u0005\u00153\u0018\u0002BAF\u0003\u000f\u0013ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.A\fuKN$Hi\\3t]R$&/\u001e8dCR,g)\u001e7ms\"\u001aq$!\n\u00027Q,7\u000f^\"mK\u0006tW\u000f\u001d)beRL\u0017\r\\*oCB\u001c\bn\u001c;tQ\r\u0001\u0013QE\u0001\u001ai\u0016\u001cHo\u00117fC:,\bo\u00147eKJ\u001cf.\u00199tQ>$8\u000fK\u0002\"\u0003K\tQ\u0005^3ti\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bi\u0016$Gj\\4UeVt7-\u0019;fg\u001a+H\u000e\\=)\u0007\t\n)#\u0001\tuKN$X*\u0019=CCR\u001c\u0007nU5{K\"\u001a1%!\n\u0002=Q,7\u000f\u001e+sk:\u001c\u0017\r^3CK2|w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007f\u0001\u0013\u0002&\u0005q!-^5mI\u001a+H\u000e\u001c\"bi\u000eDG\u0003CAU\u0003k\u000by,a1\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,u\u0003\u0019\u0011XmY8sI&!\u00111WAW\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011qW\u0013A\u0002\u0005e\u0016a\u00037fC\u0012,'/\u00129pG\"\u00042aSA^\u0013\r\ti\f\u0014\u0002\u0004\u0013:$\bbBAaK\u0001\u0007\u0011\u0011X\u0001\u000be\u0016\u001cwN\u001d3TSj,\u0007bBAcK\u0001\u0007\u0011\u0011X\u0001\u0014[\u0006D()\u0019;dQNK'0Z%o\u0005f$Xm]\u0001+i\u0016\u001cHOV1mS\u0012\fG/Z#q_\u000eDwI]3bi\u0016\u0014H\u000b[1o\u0019\u0006\u001cHo\u00138po:,\u0005o\\2iQ\r1\u0013QE\u0001-i\u0016\u001cHOV1mS\u0012\fG/Z#q_\u000eDG*Z:t)\"\fgn\u00147eKN$8K\\1qg\"|G/\u00129pG\"D3aJA\u0013\u00039\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;MKN\u001cH\u000b[1o\u001f2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;)\u0007!\n)#A\u0017uKN$h+\u00197jI\u0006$Xm\u00144gg\u0016$X)];bYR{w\n\u001c3fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD3!KA\u0013\u0003\t#Xm\u001d;WC2LG-\u0019;f+:\\gn\\<o\u000bB|7\r\u001b'fgN$\u0006.\u00198MCN$8J\\8x]\u001e\u0013X-\u0019;feRC\u0017M\\(mI\u0016\u001cHo\u00158baNDw\u000e\u001e\u0015\u0004U\u0005\u0015\u0012\u0001\u000b;fgR4\u0016\r\\5eCR,W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r[%o\u0019><\u0007fA\u0016\u0002&\u0005!C/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u000fJ,\u0017\r\u001e+iC:,e\u000eZ(gMN,G\u000fK\u0002-\u0003K\tQ\u0004^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi2+7o\u001d+iC:dUi\u0014\u0015\u0004[\u0005\u0015\u0012a\b;fgR4\u0016\r\\5eCR,g+\u00197jI\u0016\u0003xn\u00195B]\u0012|eMZ:fi\"\u001aa&!\n\u0002MQ,7\u000f^!em\u0006t7-\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u00148\t\\3b]&tw\rK\u00020\u0003K\t1\u0003^3ti\u0012+G.\u001a;f':\f\u0007o\u001d5piND3\u0001MA\u0013\u0003Y!Xm\u001d;T_\u001a$(+\u001a;f]RLwN\u001c'j[&$\bfA\u0019\u0002&\u0005\u0011C/Z:u'\u0016<W.\u001a8ug2+7o\u001d+iC:d\u0015\r^3tiNs\u0017\r]:i_RD3AMA\u0013\u00059\u0011\u0015\u0010^3BeJ\f\u0017pU3sI\u0016\u001cRaMA\u0000\u0005\u0017\u0001BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000bQ\u0016\u0001\u00027b]\u001eLAA!\u0003\u0003\u0004\t1qJ\u00196fGR\u0004bA!\u0004\u0003\u001a\tuQB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r)(Q\u0003\u0006\u0004\u0005/1\u0018AB:feZ,'/\u0003\u0003\u0003\u001c\t=!a\u0003*fG>\u0014HmU3sI\u0016\u0004Ra\u0013B\u0010\u0005GI1A!\tM\u0005\u0015\t%O]1z!\rY%QE\u0005\u0004\u0005Oa%\u0001\u0002\"zi\u0016$\"Aa\u000b\u0011\u0007\t52'D\u0001\u0001)\u0019\tIL!\r\u00036!9!1G\u001bA\u0002\tu\u0011\u0001\u00023bi\u0006DqAa\u000e6\u0001\u0004\u0011I$\u0001\ntKJL\u0017\r\\5{CRLwN\\\"bG\",\u0007\u0003\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}B/\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\u0019E!\u0010\u00031=\u0013'.Z2u'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8DC\u000eDW-A\u0003xe&$X\rF\u0004a\u0005\u0013\u0012YE!\u0014\t\u000f\tMb\u00071\u0001\u0003\u001e!9!q\u0007\u001cA\u0002\te\u0002b\u0002B(m\u0001\u0007!\u0011K\u0001\u0004_V$\b\u0003\u0002B\u001e\u0005'JAA!\u0016\u0003>\tAqK]5uC\ndW-\u0001\u0003sK\u0006$GC\u0002B\u000f\u00057\u0012)\u0007C\u0004\u0003^]\u0002\rAa\u0018\u0002\u000b%t\u0007/\u001e;\u0011\t\tm\"\u0011M\u0005\u0005\u0005G\u0012iD\u0001\u0005SK\u0006$\u0017M\u00197f\u0011\u001d\u00119g\u000ea\u0001\u0003s\u000bAa]5{K\u0006AB)\u001a4bk2$X*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u0016\u0005\t5\u0004cA*\u0003p%\u0019!\u0011\u000f#\u0003#5+G/\u00193bi\u0006dunZ\"p]\u001aLw-A\rEK\u001a\fW\u000f\u001c;NKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\u0004\u0013A\u00062vS2$W*\u001a;bI\u0006$\u0018\rT8h\u0003:$G)\u001b:\u0015\u0015\te$Q\u0013BL\u00057\u0013y\nE\u0005L\u0005w\u0012yHa$\u0003n%\u0019!Q\u0010'\u0003\rQ+\b\u000f\\34!\u0011\u0011\tIa#\u000e\u0005\t\r%\u0002\u0002BC\u0005\u000f\u000bAAZ5mK*\u0019!\u0011\u0012.\u0002\u00079Lw.\u0003\u0003\u0003\u000e\n\r%\u0001\u0002)bi\"\u00042a\u0015BI\u0013\r\u0011\u0019\n\u0012\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001eDQ\u0001\u0016\u001eA\u0002YCaA!';\u0001\u0004A\u0017\u0001\u0002;j[\u0016D\u0011B!(;!\u0003\u0005\rA!\u001c\u0002#5,G/\u00193bi\u0006dunZ\"p]\u001aLw\rC\u0004puA\u0005\t\u0019A9\u0002A\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><\u0017I\u001c3ESJ$C-\u001a4bk2$HeM\u000b\u0003\u0005KSCA!\u001c\u0003(.\u0012!\u0011\u0016\t\u0005\u0005W\u0013),\u0004\u0002\u0003.*!!q\u0016BY\u0003%)hn\u00195fG.,GMC\u0002\u000342\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119L!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0011ck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5sI\u0011,g-Y;mi\u0012\"TC\u0001B_U\r\t(qU\u0001\u0011EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$\"Ba$\u0003D\n\u0015'q\u0019Be\u0011\u0015!V\b1\u0001W\u0011\u0019\u0011I*\u0010a\u0001Q\"I!QT\u001f\u0011\u0002\u0003\u0007!Q\u000e\u0005\b_v\u0002\n\u00111\u0001r\u0003i\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\n3fM\u0006,H\u000e\u001e\u00134\u0003i\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0019\t\u0007\u000f]3oIRA!1\u001bBm\u0005G\u00149\u000f\u0005\u0003\u0002\u0006\nU\u0017\u0002\u0002Bl\u0003\u000f\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002Bn\u0001\u0002\u0007!Q\\\u0001\u0004Y><\u0007\u0003BAC\u0005?LAA!9\u0002\b\ni!+\u001a9mS\u000e\fG/\u001a3M_\u001eDqA!:A\u0001\u0004\tI,A\bok6\u0014WM](g%\u0016\u001cwN\u001d3t\u0011\u001d\u0011I\u000f\u0011a\u0001\u0003s\u000bQ!\u001a9pG\"$R\u0001\u0019Bw\u0005{DqAa<B\u0001\u0004\u0011\t0\u0001\bt]\u0006\u00048\u000f[8u/JLG/\u001a:\u0011\t\tM(\u0011`\u0007\u0003\u0005kT1Aa>w\u0003!\u0019h.\u00199tQ>$\u0018\u0002\u0002B~\u0005k\u0014\u0011CU1x':\f\u0007o\u001d5pi^\u0013\u0018\u000e^3s\u0011\u001d\u0011)/\u0011a\u0001\u0003s\u000b!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR)aka\u0001\u0004\u0006!1\u0011Q\u000f\"A\u0002YCqaa\u0002C\u0001\u0004\u0019I!\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\u0004Baa\u0003\u0004\u001a9!1QBB\u000b!\r\u0019y\u0001T\u0007\u0003\u0007#Q1aa\u0005I\u0003\u0019a$o\\8u}%\u00191q\u0003'\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019Yb!\b\u0003\rM#(/\u001b8h\u0015\r\u00199\u0002\u0014")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private final MetadataLogConfig DefaultMetadataLogConfig = new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, Defaults$.MODULE$.FileDeleteDelayMs(), 1);

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
        this.metrics().close();
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList((Object[])new String[]{"broker"}));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.buildMetadataLog$default$4());
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.buildMetadataLog$default$4());
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        this.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset(snapshotId.offset - 1L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset - 2L, snapshotId.epoch)));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$1.offset, snapshotId$1.epoch - 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotOlderEpoch() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$2.offset, snapshotId$2.epoch - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        this.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateExistingSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 10;
        int epoch = 0;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateFullyToLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        this.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        this.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertNotEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        Assertions.assertTrue((boolean)log2.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        log2.close();
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)log2, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.log().truncateFullyAndStartAt(100L);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.log().truncateFullyAndStartAt(200L);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.log().truncateFullyAndStartAt(100L);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        return new File(logDir.getAbsolutePath(), MergedLog$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition()));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        FileRawSnapshotWriter writer = FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId, Optional.empty());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            writer.freeze();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDoesntTruncateFully() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void resource_resource;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig cfr_ignored_0 = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.flush(false);
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$5 -> x$5.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        this.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        this.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$7 -> x$7.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch, (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = this.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = this.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = this.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = this.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = this.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = this.DefaultMetadataLogConfig().copy$default$7();
        int x$8 = this.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = this.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9), this.buildMetadataLog$default$4());
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numRecords = 10;
        int epoch = 5;
        this.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset((long)offset, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 1);
        this.append((ReplicatedLog)log, numOfRecords, 2);
        this.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 5;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, this.DefaultMetadataLogConfig().maxFetchSizeInBytes(), Defaults$.MODULE$.FileDeleteDelayMs(), 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource2;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(this, rawSnapshotWriter);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(this, rawSnapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            void resource_resource;
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(this, rawSnapshotWriter);
            }
            finally {
                resource_resource.close();
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource2;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(this, rawSnapshotWriter);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(this, rawSnapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 200, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableLike)log.log().localLogSegments().drop(1)).head()).baseOffset(), 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableLike)log.log().localLogSegments().drop(2)).head()).baseOffset(), 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        long defaultLogRetentionMs = Defaults$.MODULE$.RetentionMs() * 2L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset;
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public MetadataLogConfig DefaultMetadataLogConfig() {
        return this.DefaultMetadataLogConfig;
    }

    public Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        File logDir = this.createLogDirectory(tempDir, MergedLog$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition()));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), logDir, (Time)time, metrics, (Scheduler)time.scheduler(), metadataLogConfig);
        return new Tuple3((Object)logDir.toPath(), (Object)metadataLog, (Object)metadataLogConfig);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        void var6_6;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(tempDir, time, metadataLogConfig, metrics);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        return var6_6;
    }

    public MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLogAndDir$default$4() {
        return this.metrics();
    }

    public MetadataLogConfig buildMetadataLog$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLog$default$4() {
        return this.metrics();
    }

    public LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return log.appendAsLeader((Records)MemoryRecords.withRecords((long)log.endOffset().offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(epoch), (SimpleRecord[])((SimpleRecord[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable & scala.Serializable)number -> KafkaMetadataLogTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)number)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), epoch);
    }

    public void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        snapshotWriter.append(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable & scala.Serializable)number -> KafkaMetadataLogTest.$anonfun$append$2(BoxesRunTime.unboxToInt((Object)number)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private File createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        if (!Files.exists(dir.toPath(), new LinkOption[0])) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        return dir;
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset, (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$2(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeEmptySnapshot$1$adapted(FileRawSnapshotWriter x$3) {
        x$3.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }

        public /* synthetic */ KafkaMetadataLogTest kafka$raft$KafkaMetadataLogTest$ByteArraySerde$$$outer() {
            return KafkaMetadataLogTest.this;
        }

        public ByteArraySerde() {
            if (KafkaMetadataLogTest.this == null) {
                throw null;
            }
        }
    }
}

