/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kafka.restore.RestoreMetricsManager;
import kafka.utils.MockTime;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RestoreMetricsManagerTest {
    private MockTime time;
    private Metrics metrics;
    private RestoreMetricsManager rm;

    @BeforeEach
    public void before() {
        this.time = new MockTime();
        this.metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time);
        this.rm = new RestoreMetricsManager(this.metrics, "test_cluster");
    }

    @Test
    public void testGauge() {
        this.rm.update("RestoreStarted", 5L);
        Assertions.assertEquals((Object)5L, (Object)this.metrics.metric(this.metricName("RestoreStarted", this.metrics)).metricValue());
        this.rm.update("RestoreStarted", 10L);
        Assertions.assertEquals((Object)15L, (Object)this.metrics.metric(this.metricName("RestoreStarted", this.metrics)).metricValue());
        this.rm.record("RestoreStarted", 3L);
        Assertions.assertEquals((Object)3L, (Object)this.metrics.metric(this.metricName("RestoreStarted", this.metrics)).metricValue());
    }

    private MetricName metricName(String name, Metrics metrics) {
        List metricNames = metrics.metrics().keySet().stream().filter(metricName -> metricName.name().equals(name)).collect(Collectors.toList());
        if (metricNames.size() > 0) {
            return (MetricName)metricNames.get(0);
        }
        return null;
    }
}

