/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.log.LogConfig;
import kafka.log.MergedLog;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.OperatorTestUtil;
import kafka.restore.operators.ReconcilePartitionOperator;
import kafka.server.Defaults;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.store.TierObjectStore;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ReconcilePartitionOperatorTest {
    File parentDir = TestUtils.tempDir();
    File dir = TestUtils.randomPartitionLogDir(this.parentDir);
    TopicPartition tp = MergedLog.parseTopicPartitionName((File)this.dir);
    TopicIdPartition tpid = new TopicIdPartition(this.tp.topic(), UUID.randomUUID(), this.tp.partition());
    LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
    MockTime time = new MockTime();
    TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(this.isFtpsCleanupEnabled(), Defaults.TierPartitionStateCleanupDelayMs(), 0L);
    FileTierPartitionState state = new FileTierPartitionState(this.dir, this.logDirFailureChannel, this.tp, true, (Scheduler)this.time.scheduler(), false, this.isLogCleanerFeatureEnabled(), (Time)this.time, this.cleanupConfig);
    LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
    List<UUID> objectIds = new ArrayList<UUID>();

    boolean isFtpsCleanupEnabled() {
        return false;
    }

    boolean isLogCleanerFeatureEnabled() {
        return false;
    }

    @BeforeEach
    public void setup() throws IOException {
        this.state.setTopicId(this.tpid.topicId());
        this.state.beginCatchup();
        this.state.onCatchUpComplete();
        TierTestUtils.initTierTopicOffset();
        for (int i = 0; i < 10; ++i) {
            this.objectIds.add(UUID.randomUUID());
        }
    }

    @AfterEach
    public void teardown() throws IOException {
        this.state.close();
        this.dir.delete();
        this.parentDir.delete();
        this.objectIds.clear();
    }

    @Test
    public void testReconcile() throws Exception {
        this.prepareFtps();
        ReconcilePartitionOperator reconcileOperator = new ReconcilePartitionOperator(this.tp, OperatorTestUtil.getTierStateFile(this.dir), 0L);
        FtpsSegmentView operaterConext = reconcileOperator.getOperatorContext();
        long headerSize = operaterConext.header().size();
        Assertions.assertFalse((boolean)operaterConext.segmentStateMap().containsKey(this.objectIds.get(1)));
        Assertions.assertEquals((long)0L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((int)3, (int)operaterConext.segmentStateMap().size());
        Assertions.assertEquals((int)0, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        SegmentState segmentState = (SegmentState)Mockito.mock(SegmentState.class);
        Mockito.when((Object)segmentState.tierEpoch()).thenReturn((Object)1);
        Mockito.when((Object)segmentState.endOffset()).thenReturn((Object)149L);
        Mockito.when((Object)segmentState.objectId()).thenReturn((Object)this.objectIds.get(2));
        HashMap<UUID, SegmentState> segmentStateMap = new HashMap<UUID, SegmentState>();
        segmentStateMap.put(this.objectIds.get(2), segmentState);
        Map pathMap = reconcileOperator.reconcile(segmentStateMap);
        Assertions.assertEquals((long)headerSize, (long)operaterConext.header().size());
        Assertions.assertEquals((int)2, (int)pathMap.size());
        Assertions.assertTrue((boolean)pathMap.containsKey(this.objectIds.get(0)));
        Assertions.assertFalse((boolean)pathMap.containsKey(this.objectIds.get(1)));
        Assertions.assertTrue((boolean)pathMap.containsKey(this.objectIds.get(2)));
        reconcileOperator = new ReconcilePartitionOperator(this.tp, OperatorTestUtil.getTierStateFile(this.dir), 0L);
        operaterConext = reconcileOperator.getOperatorContext();
        Assertions.assertEquals((long)headerSize, (long)operaterConext.header().size());
        Assertions.assertEquals((long)150L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((int)2, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_FENCED));
        Assertions.assertEquals((int)1, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir, this.logDirFailureChannel, this.tp, true, (Scheduler)this.time.scheduler(), false, this.isLogCleanerFeatureEnabled(), (Time)this.time, this.cleanupConfig);
        TierTestUtils.verifyFtpsEntries(reopenedState, null, null, this.isFtpsCleanupEnabled(), this.time.milliseconds());
        reopenedState.close();
    }

    @Test
    public void testLoadSegmentsWithOverlapSegments() throws IOException {
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        long timestamp = 1000L;
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 0, this.objectIds.get(0), 0L, 99L, 100, timestamp);
        OperatorTestUtil.deleteInitiateAndComplete(this.state, this.tpid, 0, this.objectIds.get(0), this.time.milliseconds());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 0, this.objectIds.get(1), 100L, 199L, 100, timestamp + 1000L);
        OperatorTestUtil.deleteInitiateAndComplete(this.state, this.tpid, 0, this.objectIds.get(1), this.time.milliseconds());
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 1, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(2), 180L, 299L, 120, timestamp + 2000L);
        OperatorTestUtil.deleteInitiateAndComplete(this.state, this.tpid, 1, this.objectIds.get(2), this.time.milliseconds());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(3), 300L, 399L, 100, timestamp + 3000L);
        this.state.close();
        FtpsSegmentView operaterConext = new FtpsSegmentView(this.tp, new File(OperatorTestUtil.getTierStateFile(this.dir)), 0L);
        Assertions.assertEquals((long)300L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((int)4, (int)operaterConext.segmentStateMap().size());
        Assertions.assertEquals((int)3, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
    }

    private void prepareFtps() throws IOException {
        long timestamp = 1000L;
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 0, this.objectIds.get(0), 0L, 99L, 100, timestamp);
        OffsetAndEpoch stateOffset = this.state.lastLocalMaterializedSrcOffsetAndEpoch();
        this.state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid, 0, this.objectIds.get(1), 100L, 199L, timestamp + 1000L, timestamp + 1000L, 100, false, false, false, TierUploadType.Archive, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils.nextTierTopicOffsetAndEpoch());
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 1, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(2), 100L, 149L, 50, timestamp + 2000L);
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(3), 150L, 200L, 50, timestamp + 3000L);
        this.state.close();
    }
}

