/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rpo;

import java.util.UUID;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.restore.rpo.PartitionRpo;
import kafka.restore.rpo.RpoMetricsManager;
import kafka.tier.TopicIdPartition;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Option;
import scala.collection.immutable.List$;

public class PartitionRpoTest {
    MockTime mocktime;
    TopicIdPartition topicIdPartition;
    PartitionRpo partitionRPO;

    @BeforeEach
    public void setup() {
        this.mocktime = new MockTime();
        this.topicIdPartition = new TopicIdPartition("test", UUID.randomUUID(), 0);
        this.partitionRPO = new PartitionRpo(this.topicIdPartition, (Time)this.mocktime);
        this.partitionRPO.isLoaded = true;
    }

    @Test
    public void testPartitionRPO() {
        this.partitionRPO.mayAddSegmentAndCreateTime(0L, this.mocktime.milliseconds());
        this.mocktime.sleep(1000L);
        Assertions.assertEquals((long)this.partitionRPO.rpo(), (long)1000L);
        this.partitionRPO.mayAddSegmentAndCreateTime(10L, this.mocktime.milliseconds());
        this.mocktime.sleep(1000L);
        Assertions.assertEquals((long)this.partitionRPO.rpo(), (long)2000L);
        this.mocktime.sleep(1000L);
        Assertions.assertEquals((long)this.partitionRPO.rpo(), (long)3000L);
        this.partitionRPO.removeSegmentByFirstUntieredOffset(10L);
        Assertions.assertEquals((long)this.partitionRPO.rpo(), (long)2000L);
        this.mocktime.sleep(5000L);
        Assertions.assertEquals((long)this.partitionRPO.rpo(), (long)7000L);
    }

    @Test
    public void testRpoCalculation() {
        MockTime mocktime = new MockTime();
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        MergedLog mergeLog = (MergedLog)Mockito.mock(MergedLog.class);
        Mockito.when((Object)mergeLog.logEndOffset()).thenReturn((Object)2000L);
        Mockito.when((Object)mergeLog.tierableLogSegments()).thenReturn((Object)List$.MODULE$.empty());
        Option log = (Option)Mockito.mock(Option.class);
        Mockito.when((Object)log.get()).thenReturn((Object)mergeLog);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)log);
        RpoMetricsManager rpoMetricsManager = new RpoMetricsManager((Time)mocktime);
        for (int i = 0; i < 100; ++i) {
            TopicIdPartition tp = new TopicIdPartition("test", UUID.randomUUID(), i);
            rpoMetricsManager.registerTopicIdPartition(tp);
            rpoMetricsManager.partitionRpo(tp).mayLoadPartitionRpo(mergeLog);
            rpoMetricsManager.addNewSegment(tp, 1000L);
            mocktime.sleep(1000L);
        }
        rpoMetricsManager.updateRpoValues(logManager);
        Assertions.assertEquals((Object)rpoMetricsManager.rpoMax.value(), (Object)100000L);
        Assertions.assertEquals((Object)rpoMetricsManager.rpoP99.value(), (Object)99000L);
        Assertions.assertEquals((Object)rpoMetricsManager.rpoP50.value(), (Object)50000L);
    }
}

