/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rpo;

import java.io.File;
import java.util.UUID;
import kafka.log.AppendOrigin;
import kafka.log.Defaults;
import kafka.log.HarnessParams;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarnessHelpers;
import kafka.restore.rpo.PartitionRpo;
import kafka.restore.rpo.RpoMetricsManager;
import kafka.restore.rpo.RpoValue;
import kafka.restore.rpo.SegmentAndCreateTime;
import kafka.tier.TopicIdPartition;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Option;

public class RpoMetricsManagerTest {
    @Test
    public void testGetValue() {
        RpoValue[] values = new RpoValue[]{};
        Assertions.assertEquals((long)0L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)0.9));
        values = new RpoValue[]{new RpoValue(null, 1L)};
        Assertions.assertEquals((long)1L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)0.9));
        values = new RpoValue[1000];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new RpoValue(null, (long)(i + 1));
        }
        Assertions.assertEquals((long)500L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)0.5));
        Assertions.assertEquals((long)990L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)0.99));
        Assertions.assertEquals((long)1000L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)1.0));
        Assertions.assertEquals((long)999L, (long)RpoMetricsManager.getValue((RpoValue[])values, (double)0.999));
    }

    @Test
    public void testRegisterTopicIdPartition() {
        File logDir = TestUtils.randomPartitionLogDir(TestUtils.tempDir());
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName((File)logDir);
        LogConfig logConfig = MergedLogHarnessHelpers.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", Defaults.MaxMessageSize(), Defaults.IndexInterval(), Defaults.MaxIndexSize(), Defaults.PreferTierFetchMs(), Defaults.TierCleanerDualCompaction(), Defaults.MinCompactionLagMs());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        MergedLogHarness harness = MergedLogHarness.apply(topicPartition, logConfig, params);
        harness.log().appendAsLeader(this.record(0, 0, 0L), 0, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), null);
        harness.log().roll(Option.apply((Object)1L), 0L);
        harness.log().updateHighWatermark(harness.log().logEndOffset());
        harness.log().appendAsLeader(this.record(0, 0, 1L), 0, (AppendOrigin)AppendOrigin.Client$.MODULE$, MetadataVersion.latest(), null);
        harness.log().roll(Option.apply((Object)2L), 2L);
        harness.log().updateHighWatermark(harness.log().logEndOffset());
        harness.advanceClock(10L);
        harness.log().flush(false);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)Option.apply((Object)harness.log()));
        MockTime mocktime = new MockTime();
        RpoMetricsManager rpoMetricsManager = new RpoMetricsManager((Time)mocktime);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        rpoMetricsManager.registerTopicIdPartition(topicIdPartition);
        rpoMetricsManager.updateRpoValues(logManager);
        PartitionRpo partitionRpo = rpoMetricsManager.partitionRpo(topicIdPartition);
        Assertions.assertEquals((int)3, (int)partitionRpo.segmentCreateTimeList.size());
        Assertions.assertEquals((long)0L, (long)((SegmentAndCreateTime)partitionRpo.segmentCreateTimeList.get((int)0)).baseOffset);
    }

    private MemoryRecords record(Integer key, Integer value, long timestamp) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, key.toString().getBytes(), value.toString().getBytes())});
    }
}

