/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.restore.schedulers.CompletableFutureRetryer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class CompletableFutureRetryerTest {
    private static final Duration WAIT_BETWEEN = Duration.ofMillis(20L);
    private Supplier<String> operation;
    private Supplier<CompletableFuture<String>> attempter;
    private ThreadPoolExecutor threadPool;
    private CompletableFutureRetryer retries;

    @BeforeEach
    void beforeEach() {
        this.operation = (Supplier)Mockito.mock(Supplier.class);
        this.attempter = () -> CompletableFuture.supplyAsync(this.operation);
        this.threadPool = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.retries = new CompletableFutureRetryer(this.threadPool, WAIT_BETWEEN);
    }

    @AfterEach
    void afterEach() {
        this.threadPool.shutdownNow();
    }

    @Test
    void givenAWorkingAttempterThenTheResultIsProvided() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willReturn((Object)"yes!!");
        String result = (String)this.retries.withRetries(this.attempter, t -> false, 3).get();
        Assertions.assertEquals((Object)result, (Object)"yes!!");
    }

    @Test
    void givenAContinuouslyFailingAttempterThenTheResultIsError() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")});
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)this.retries.withRetries(this.attempter, t -> true, 3).get();
        });
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)3))).get();
    }

    @Test
    void givenAFailingThenSucceedingAttempterThenThereAreMultipleAttempts() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")}).willThrow(new Throwable[]{new RuntimeException("boom!")}).willReturn((Object)"yes!!");
        String result = (String)this.retries.withRetries(this.attempter, t -> true, 3).get();
        Assertions.assertEquals((Object)result, (Object)"yes!!");
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)3))).get();
    }

    @Test
    void givenAnOperationWhichFailsWithAnUnhandleableExceptionThenFailsAtUnhandled() {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")}).willThrow(new Throwable[]{new IllegalStateException("boom!")}).willReturn((Object)"yes!!");
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)this.retries.withRetries(this.attempter, t -> t.getClass().equals(RuntimeException.class), 3).get();
        });
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)2))).get();
    }
}

