/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.Kafka$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEf\u0001B/_\u0001\u0015DQ\u0001\u001d\u0001\u0005\u0002EDqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B;\t\u0011\u0005\u001d\u0001A1A\u0005\nQDq!!\u0003\u0001A\u0003%Q\u000f\u0003\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003u\u0011\u001d\ti\u0001\u0001Q\u0001\nUD\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005}\u0001\u0001)A\u0005\u0003'A\u0011\"!\t\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003'A\u0011\"!\n\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003'A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005m\u0002\u0001)A\u0005\u0003[A\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u0003B\u0011\"!\u0013\u0001\u0005\u0004%I!a\u0010\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u00032a!!\u0014\u0001\u0001\u0005=\u0003BCA))\t\u0005\t\u0015!\u0003\u0002T!Q\u0011Q\u000e\u000b\u0003\u0002\u0003\u0006I!a\u0015\t\rA$B\u0011AA8\u0011\u001d\tI\b\u0006C!\u0003wBaa\u0018\u0001\u0005B\u0005=\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003\u000f\u0004A\u0011IAe\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003\u0013Dq!!8\u0001\t\u0003\tI\rC\u0004\u0002b\u0002!\t!!3\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002J\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005%\u0007bBAw\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003c\u0004A\u0011AAe\u0011\u001d\t)\u0010\u0001C\u0001\u0003\u0013Dq!!?\u0001\t\u0003\tI\rC\u0004\u0002~\u0002!\t!!3\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002J\"9!Q\u0001\u0001\u0005\u0002\u0005%\u0007b\u0002B\u0005\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005\u001b\u0001A\u0011AAe\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003\u0013DqA!\u0006\u0001\t\u0003\tI\rC\u0004\u0003\u001a\u0001!\t!!3\t\u000f\tu\u0001\u0001\"\u0001\u0002J\"9!\u0011\u0005\u0001\u0005\u0002\u0005%\u0007b\u0002B\u0013\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqAa\u0013\u0001\t\u0003\tI\rC\u0004\u0003P\u0001!\t!!3\t\u000f\tM\u0003\u0001\"\u0001\u0002J\"9!q\u000b\u0001\u0005\u0002\u0005%\u0007b\u0002B.\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005?\u0002A\u0011AAe\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0003\u0013DqAa\u001a\u0001\t\u0003\tI\rC\u0004\u0003l\u0001!\t!!3\t\u000f\t=\u0004\u0001\"\u0001\u0002J\"9!1\u000f\u0001\u0005\u0002\u0005%\u0007b\u0002B<\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005w\u0002A\u0011AAe\u0011\u001d\u0011y\b\u0001C\u0001\u0003\u0013DqAa!\u0001\t\u0003\tI\rC\u0004\u0003\b\u0002!\t!!3\t\u000f\t-\u0005\u0001\"\u0001\u0002J\"9!q\u0012\u0001\u0005\u0002\u0005%\u0007b\u0002BJ\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005/\u0003A\u0011AAe\u0011\u001d\u0011Y\n\u0001C\u0001\u0003\u0013DqAa(\u0001\t\u0003\tI\rC\u0004\u0003$\u0002!\t!!3\t\u000f\t\u001d\u0006\u0001\"\u0001\u0002J\"9!1\u0016\u0001\u0005\u0002\u0005%\u0007b\u0002BX\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005g\u0003A\u0011AAe\u0011\u001d\u00119\f\u0001C\u0001\u0003\u0013DqAa/\u0001\t\u0003\tI\rC\u0004\u0003@\u0002!IA!1\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\"9!1\u001f\u0001\u0005\n\tU\b\"CB\u0004\u0001E\u0005I\u0011BB\u0005\u0011\u001d\u0019y\u0002\u0001C\u0005\u0007CAqaa\u000f\u0001\t\u0013\u0019i\u0004C\u0004\u0004<\u0001!Ia!\u0012\t\u000f\rm\u0002\u0001\"\u0003\u0004V!91\u0011\f\u0001\u0005\n\rm\u0003bBB1\u0001\u0011%11\r\u0005\b\u0007K\u0002A\u0011BB4\u0011\u001d\u0019\u0019\b\u0001C\u0005\u0007kBqa!)\u0001\t\u0013\u0019\u0019\u000bC\u0004\u00040\u0002!\t!a\u0010\u0003#\u0005\u001bG.Q;uQ>\u0014\u0018N_3s)\u0016\u001cHO\u0003\u0002`A\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005\u0005\u0014\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\r\fQa[1gW\u0006\u001c\u0001aE\u0002\u0001M2\u0004\"a\u001a6\u000e\u0003!T!!\u001b2\u0002\rM,'O^3s\u0013\tY\u0007NA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\u0004\"!\u001c8\u000e\u0003yK!a\u001c0\u0003%\t\u000b7/Z!vi\"|'/\u001b>feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0004\"!\u001c\u0001\u0002\u0019\u0005dGn\\<SK\u0006$\u0017i\u00197\u0016\u0003U\u00042A^A\u0001\u001b\u00059(B\u0001=z\u0003\r\t7\r\u001c\u0006\u0003un\faaY8n[>t'BA2}\u0015\tih0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\rqO\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\u0018!D1mY><(+Z1e\u0003\u000ed\u0007%A\u0007bY2|wo\u0016:ji\u0016\f5\r\\\u0001\u000fC2dwn^,sSR,\u0017i\u00197!\u0003-!WM\\=SK\u0006$\u0017i\u00197\u0002\u0019\u0011,g.\u001f*fC\u0012\f5\r\u001c\u0011\u0002!]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,WCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rs\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0002\u001e\u0005]!a\u0004*fg>,(oY3QCR$XM\u001d8\u0002#]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002#]LG\u000eZ2be\u0012\u0004&/\u001b8dSB\fG.\u0006\u0002\u0002.A!\u0011qFA\u001c\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001B1vi\"T!!Y=\n\t\u0005e\u0012\u0011\u0007\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003I9\u0018\u000e\u001c3dCJ$\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001b\u0005\u001cG.Q;uQ>\u0014\u0018N_3s+\t\t\t\u0005E\u0002n\u0003\u0007J1!!\u0012_\u00055\t5\r\\!vi\"|'/\u001b>fe\u0006q\u0011m\u00197BkRDwN]5{KJ\u0004\u0013AD1dY\u0006+H\u000f[8sSj,'OM\u0001\u0010C\u000ed\u0017)\u001e;i_JL'0\u001a:3A\ty1)^:u_6\u0004&/\u001b8dSB\fGnE\u0002\u0015\u0003[\tQ\u0002\u001d:j]\u000eL\u0007/\u00197UsB,\u0007\u0003BA+\u0003OrA!a\u0016\u0002dA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0011\fa\u0001\u0010:p_Rt$BAA1\u0003\u0015\u00198-\u00197b\u0013\u0011\t)'a\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\u0011\t)'a\u0018\u0002\t9\fW.\u001a\u000b\u0007\u0003c\n)(a\u001e\u0011\u0007\u0005MD#D\u0001\u0001\u0011\u001d\t\tf\u0006a\u0001\u0003'Bq!!\u001c\u0018\u0001\u0004\t\u0019&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003{\n)\t\u0005\u0003\u0002\u0000\u0005\u0005UBAA0\u0013\u0011\t\u0019)a\u0018\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0011\rA\u0002\u0005%\u0015!A8\u0011\t\u0005}\u00141R\u0005\u0005\u0003\u001b\u000byFA\u0002B]f,\"!!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1aXAL\u0015\tI70\u0003\u0003\u0002\u001c\u0006U%AC!vi\"|'/\u001b>fe\u0006)1/\u001a;VaR!\u0011\u0011UAT!\u0011\ty(a)\n\t\u0005\u0015\u0016q\f\u0002\u0005+:LG\u000fC\u0004\u0002*j\u0001\r!a+\u0002\u0011Q,7\u000f^%oM>\u0004B!!,\u0002<6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0002ba&TA!!.\u00028\u00069!.\u001e9ji\u0016\u0014(bAA]}\u0006)!.\u001e8ji&!\u0011QXAX\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u000e\u0002BB!\u0011QVAb\u0013\u0011\t)-a,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\t\t\u000bK\u0002\u001c\u0003\u001b\u0004B!!,\u0002P&!\u0011\u0011[AX\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0014uKN$\u0018)\u001e;i_JL'0\u001a+ie><8o\u00148O_:d\u0015\u000e^3sC2\u0014Vm]8ve\u000e,\u0007f\u0001\u000f\u0002XB!\u0011QVAm\u0013\u0011\tY.a,\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRDW)\u001c9usJ+7o\\;sG\u0016t\u0015-\\3)\u0007u\t9.A\u000euKN$X)\u001c9us\u0006\u001bG\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004=\u0005]\u0017\u0001\u0004;fgR$v\u000e]5d\u0003\u000ed\u0007fA\u0010\u0002X\u0006\u0011C/Z:u\u00032dwn^!dG\u0016\u001c8oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D3\u0001IAl\u0003]!Xm\u001d;EK:LH+Y6fgB\u0013XmY3eK:\u001cW\rK\u0002\"\u0003/\f!\u0003^3ti\u0006cGn\\<BY2\f5mY3tg\"\u001a!%a6\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgND3aIAl\u0003%\"Xm\u001d;TkB,'/V:fe^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197ICN\f5mY3tg\"\u001aA%a6\u0002?Q,7\u000f\u001e(p/&dGmY1sI6\u000bGo\u00195G_J\u001cV\u000f]3s+N,'\u000fK\u0002&\u0003/\f\u0001\u0003^3ti^KG\u000eZ\"be\u0012\f5\r\\:)\u0007\u0019\n9.\u0001\buKN$hj\\!dY\u001a{WO\u001c3)\u0007\u001d\n9.\u0001\fuKN$hj\\!dY\u001a{WO\u001c3Pm\u0016\u0014(/\u001b3fQ\rA\u0013q[\u0001\u0016i\u0016\u001cH/Q2m\u001b\u0006t\u0017mZ3nK:$\u0018\tU%tQ\rI\u0013q[\u0001\u000ei\u0016\u001cH\u000fT8bI\u000e\u000b7\r[3)\u0007)\n9.\u0001\ruKN$8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H+[7j]\u001eD3aKAl\u00035\"Xm\u001d;M_\u000e\fGnQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004Y\u0005]\u0017a\r;fgR$\u0015n\u001d;sS\n,H/\u001a3D_:\u001cWO\u001d:f]Rlu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ri\u0013q[\u0001.i\u0016\u001cH\u000fS5hQ\u000e{gnY;se\u0016t7-_'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bf\u0001\u0018\u0002X\u0006\u0011B/Z:u\u0003\u000ed\u0017J\u001c5fe&$\u0018M\\2fQ\ry\u0013q[\u0001\u0018i\u0016\u001cH/S7qY&\u001c\u0017\r^5p]N|e-\u00117m_^$b!!)\u0003.\t]\u0002b\u0002B\u0018a\u0001\u0007!\u0011G\u0001\ta\u0006\u0014XM\u001c;PaB\u0019aOa\r\n\u0007\tUrO\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003:A\u0002\rAa\u000f\u0002\u0015\u0005dGn\\<fI>\u00038\u000f\u0005\u0004\u0002V\tu\"\u0011G\u0005\u0005\u0005\u007f\tYGA\u0002TKR\fa\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0012+g.\u001f\u000b\u0007\u0003C\u0013)Ea\u0012\t\u000f\t=\u0012\u00071\u0001\u00032!9!\u0011J\u0019A\u0002\tm\u0012!\u00033f]&,Gm\u00149t\u0003%\"Xm\u001d;IS\u001eD7i\u001c8dkJ\u0014XM\\2z\t\u0016dW\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a!'a6\u0002gQ,7\u000f^!dG\u0016\u001c8/\u00117m_^,G-\u00134BY2|w/Q2m\u000bbL7\u000f^:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA\u001a\u0002X\u0006yB/Z:u\t\u0016dW\r^3BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007Q\n9.\u0001\u0012uKN$H)\u001a7fi\u0016\fE\u000e\\!dY>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004k\u0005]\u0017a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r1\u0014q[\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007fA\u001c\u0002X\u0006\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o!J,g-\u001b=fIJ+7o\\;sG\u0016D3\u0001OAl\u0003q!Xm\u001d;BI\u0012\f5\r\\:P]2KG/\u001a:bYJ+7o\\;sG\u0016D3!OAl\u0003u!Xm\u001d;BI\u0012\f5\r\\:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007f\u0001\u001e\u0002X\u0006iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002<\u0003/\f\u0011\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i!J,g-\u001b=fIJ+7o\\;sG\u0016D3\u0001PAl\u0003}!Xm\u001d;TS:<G.Z\"iCJ\f7\r^3s%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004{\u0005]\u0017\u0001\u0006;fgR<U\r^!dYN\u0004&/\u001b8dSB\fG\u000eK\u0002?\u0003/\fQ\u0004^3ti\u0006#G\rR3mKR,\u0017i\u00197t\r>\u0014\bK]5oG&\u0004\u0018\r\u001c\u0015\u0004\u007f\u0005]\u0017A\u0004;fgR\f5\r\\:GS2$XM\u001d\u0015\u0004\u0001\u0006]\u0017\u0001\u0010;fgR$\u0006N]8xg>s\u0017\t\u001a3Qe\u00164\u0017\u000e_3e\u0003\u000ed\u0017JZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>tGk\\8M_^D3!QAl\u0003\u0011\"Xm\u001d;De\u0016\fG/Z!dY^KG\u000f[%om\u0006d\u0017\u000e\u001a*fg>,(oY3OC6,\u0007f\u0001\"\u0002X\u0006YD/Z:u/JLG/Z:FqR,g\u000eZ3e\u0003\u000ed7\t[1oO\u0016,e/\u001a8u\u0013\u001aLe\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001a;)\u0007\r\u000b9.A#uKN$xK]5uKN,\u0005\u0010^3oI\u0016$\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\\!u\u0019\u0016\f7\u000f^&bM.\fgK\r\u0015\u0004\t\u0006]\u0017\u0001\u001f;fgR<&/\u001b;fg2KG/\u001a:bY^\u0013\u0018\u000e^3t\u0019&$XM]1m\u0003\u000ed7\t[1oO\u0016,e/\u001a8u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2dUm]:UQ\u0006t7*\u00194lCZ\u0013TM]1m\u0003\u000ed7\t[1oO\u0016\u001chi\u001c:PY\u0012,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\:)\u0007\u0015\u000b9.A uKN$xK]5uKNd\u0015\u000e^3sC2\f5\r\\\"iC:<W-\u0012<f]R<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G.S:LC\u001a\\\u0017M\u0016\u001a)\u0007\u0019\u000b9.\u0001\ruKN$\u0018)\u001e;i_JL'0\u001a:O_j[7i\u001c8gS\u001eD3aRAl\u0003E\"Xm\u001d;BkRDwN]5{KJT6nQ8oM&<gI]8n\u0017\u000647.Y\"p]\u001aLwmV5uQ\u0012+g-Y;miND3\u0001SAl\u0003\u0015\"Xm\u001d;BkRDwN]5{KJT6nQ8oM&<gI]8n\u0017\u000647.Y\"p]\u001aLw\rK\u0002J\u0003/\f\u0011\u0006^3ti\u0006+H\u000f[8sSj,'OW6D_:4\u0017n\u001a$s_6\u0004&/\u001a4jq>3XM\u001d:jI\u0016\u001c\bf\u0001&\u0002X\u00061B/Z:u\u0007J,\u0017\r^3EK2,G/\u001a+j[&tw\rK\u0002L\u0003/\fQ\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,gj\\!dY\u001a{WO\u001c3Pm\u0016\u0014(/\u001b3fQ\ra\u0015q[\u0001\u0013i\u0016\u001cHo\u00117vgR,'\u000fT5oW&#7\u000fK\u0002N\u0003/\f!\u0003^3ti\u0006\u001bGnQ8v]RlU\r\u001e:jG\"\u001aa*a6\u0002E\u001dLg/\u001a8BkRDwN]5{KJ<\u0016\u000e\u001e5Qe>$xnY8m-\u0016\u00148/[8o)\u0011\t\tKa1\t\u000f\t\u0015w\n1\u0001\u0003H\u0006y\u0001O]8u_\u000e|GNV3sg&|g\u000e\u0005\u0004\u0002\u0000\t%'QZ\u0005\u0005\u0005\u0017\fyF\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u001f\u0014\u0019.\u0004\u0002\u0003R*\u0019!0a&\n\t\tU'\u0011\u001b\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006Ir-\u001a;BG2\u001c\u0005.\u00198hK\u00163XM\u001c;BgN#(/\u001b8h)\u0011\u0011YN!;\u0011\t\tu'q]\u0007\u0003\u0005?TAA!9\u0003d\u0006!A.\u00198h\u0015\t\u0011)/\u0001\u0003kCZ\f\u0017\u0002BA5\u0005?DqAa;Q\u0001\u0004\u0011i/A\u0006qCR$XM\u001d8UsB,\u0007\u0003BA\u000b\u0005_LAA!=\u0002\u0018\tY\u0001+\u0019;uKJtG+\u001f9f\u0003I\u0019\u0007.\u00198hK\u0006\u001bG.\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\t](\u0011 B\u007f\u0007\u0003\u0019)\u0001E\u0003\u0002V\tuR\u000fC\u0004\u0003|F\u0003\rAa>\u0002\u0019=\u0014\u0018nZ5oC2\f5\r\\:\t\u000f\t}\u0018\u000b1\u0001\u0003x\u0006I\u0011\r\u001a3fI\u0006\u001bGn\u001d\u0005\b\u0007\u0007\t\u0006\u0019\u0001B|\u0003-\u0011X-\\8wK\u0012\f5\r\\:\t\u0013\u0005e\u0011\u000b%AA\u0002\u0005M\u0011\u0001H2iC:<W-Q2m\u0003:$g+\u001a:jMf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u0017QC!a\u0005\u0004\u000e-\u00121q\u0002\t\u0005\u0007#\u0019Y\"\u0004\u0002\u0004\u0014)!1QCB\f\u0003%)hn\u00195fG.,GM\u0003\u0003\u0004\u001a\u0005}\u0013AC1o]>$\u0018\r^5p]&!1QDB\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nCV$\bn\u001c:ju\u0016$\"\"! \u0004$\r\u00152QGB\u001d\u0011\u0019y6\u000b1\u0001\u0002B!91qE*A\u0002\r%\u0012A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007W\u0019\t$\u0004\u0002\u0004.)\u00191qF=\u0002\u0011I,\u0017/^3tiNLAaa\r\u0004.\tq!+Z9vKN$8i\u001c8uKb$\bbBB\u001c'\u0002\u0007!\u0011G\u0001\n_B,'/\u0019;j_:Dq!!\u0007T\u0001\u0004\t\u0019\"A\u0004hKR\f5\r\\:\u0015\r\t]8qHB!\u0011\u0019yF\u000b1\u0001\u0002B!911\t+A\u0002\u0005M\u0011a\u0004:fg>,(oY3QCR$XM\u001d8\u0015\r\r\u001d3qJB)!\u0019\t)F!\u0010\u0004JA\u0019aoa\u0013\n\u0007\r5sO\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDaaX+A\u0002\u0005\u0005\u0003bBB*+\u0002\u0007\u0011QF\u0001\naJLgnY5qC2$Baa\u0012\u0004X!1qL\u0016a\u0001\u0003\u0003\nqA^1mS\u0012|\u0005\u000f\u0006\u0003\u0002~\ru\u0003bBB0/\u0002\u0007!\u0011G\u0001\u0003_B\fA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<WCAA*\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u00111KB5\u0011\u001d\u0019Y'\u0017a\u0001\u0007[\nQ\u0001\\5oKN\u0004b!a \u0004p\u0005M\u0013\u0002BB9\u0003?\u0012Q!\u0011:sCf\f\u0011C^3sS\u001aLX*\u001a;sS\u000e4\u0016\r\\;f)!\t\tka\u001e\u0004\u0014\u000e]\u0005bBB=5\u0002\u000711P\u0001\u0010[\u0016$(/[2t%\u0016<\u0017n\u001d;ssB!1QPBH\u001b\t\u0019yH\u0003\u0003\u0004\u0002\u000e\r\u0015\u0001B2pe\u0016TAa!\"\u0004\b\u00069Q.\u001a;sS\u000e\u001c(\u0002BBE\u0007\u0017\u000ba!_1n[\u0016\u0014(BABG\u0003\r\u0019w.\\\u0005\u0005\u0007#\u001byHA\bNKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0011\u001d\u0019)J\u0017a\u0001\u0003'\n\u0001#\\3ue&\u001c7+[7qY\u0016t\u0015-\\3\t\u000f\re%\f1\u0001\u0004\u001c\u0006iQ\r\u001f9fGR,GMV1mk\u0016\u0004BA!8\u0004\u001e&!1q\u0014Bp\u0005\u001dIe\u000e^3hKJ\fa!\\3ue&\u001cGCBBS\u0007W\u001bi\u000b\u0005\u0003\u0004~\r\u001d\u0016\u0002BBU\u0007\u007f\u0012a!T3ue&\u001c\u0007bBB=7\u0002\u000711\u0010\u0005\b\u0007+[\u0006\u0019AA*\u0003M\u0019'/Z1uK\u0006\u001bG.Q;uQ>\u0014\u0018N_3s\u0001")
public class AclAuthorizerTest
extends QuorumTestHarness
implements BaseAuthorizerTest {
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private final String superUsers;
    private final String username;
    private final String username2;
    private final KafkaPrincipal principal;
    private final KafkaPrincipal principal2;
    private final RequestContext requestContext;
    private final String superUserName;
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorzeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, scala.collection.immutable.Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, scala.collection.immutable.Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String username2() {
        return this.username2;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public KafkaPrincipal principal2() {
        return this.principal2;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    @Override
    public void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username2_$eq(String x$1) {
        this.username2 = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal2_$eq(KafkaPrincipal x$1) {
        this.principal2 = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    @Override
    public Authorizer authorizer() {
        return this.aclAuthorizer();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest", new ZKClientConfig(), "AclAuthorizerTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testNoWildcardMatchForSuperUser() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:*");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = this.createAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            RequestContext requestContext1 = this.newRequestContext(new KafkaPrincipal("User", "*"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, requestContext1, AclOperation.READ, this.resource()));
            RequestContext requestContext2 = this.newRequestContext(new KafkaPrincipal("User", "test"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, requestContext2, AclOperation.READ, this.resource()));
        }
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        scala.collection.immutable.Set<AccessControlEntry> acls = this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = this.createAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
            ResourcePattern sensitiveTopic = new ResourcePattern(ResourceType.TOPIC, "sensitiveTopic", PatternType.LITERAL);
            ResourcePattern generalTopic = new ResourcePattern(ResourceType.TOPIC, "generalTopic", PatternType.LITERAL);
            ResourcePattern prefixedTopic = this.resource();
            KafkaPrincipal adminPrincipal = new KafkaPrincipal("User", "admin");
            AccessControlEntry ace = new AccessControlEntry(adminPrincipal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
            this.addAcls((Authorizer)testAuthorizer, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace}))), sensitiveTopic);
            this.addAcls((Authorizer)testAuthorizer, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace}))), this.prefixedResource());
            InetAddress clientAddress = InetAddress.getByName("127.0.0.1");
            RequestContext adminContext = this.newRequestContext(adminPrincipal, clientAddress, ApiKeys.FETCH);
            RequestContext aliceContext = this.newRequestContext(this.principal(), clientAddress, ApiKeys.FETCH);
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, sensitiveTopic));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, prefixedTopic));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, generalTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, sensitiveTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, prefixedTopic));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, generalTopic));
            this.addAcls((Authorizer)testAuthorizer, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace}))), this.wildCardResource());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, sensitiveTopic));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, prefixedTopic));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.READ, generalTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, sensitiveTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, prefixedTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.READ, generalTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.WRITE, sensitiveTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.WRITE, prefixedTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.WRITE, generalTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.WRITE, sensitiveTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.WRITE, prefixedTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.WRITE, generalTopic));
            AccessControlEntry writeAce = new AccessControlEntry(adminPrincipal.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
            this.addAcls((Authorizer)testAuthorizer, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAce}))), generalTopic);
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, adminContext, AclOperation.WRITE, generalTopic));
            Assertions.assertFalse((boolean)this.authorize(testAuthorizer, aliceContext, AclOperation.WRITE, generalTopic));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        scala.collection.immutable.Set<AccessControlEntry> acls = this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePattern key = (ResourcePattern)x0$1._1();
            scala.collection.immutable.Set value = (scala.collection.immutable.Set)x0$1._2();
            scala.collection.immutable.Set<AccessControlEntry> set = this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)value, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        scala.collection.immutable.Set expectedAcls = ((TraversableOnce)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)x0$2._2()).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(res, acl), Set$.MODULE$.canBuildFrom());
            return set;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testAclManagementAPIs$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.changeAclAndVerify(acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        acls = null;
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
        acls = this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify(acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.changeAclAndVerify$default$4());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        scala.collection.immutable.Set acls1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = this.createAclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assertions.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assertions.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
            Assertions.assertEquals((int)2, (int)authorizer.aclCount());
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer2(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource), (String)"The authorizer should see a value that needs to be deleted");
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertEquals((int)2, (int)this.aclAuthorizer().aclCount());
        Assertions.assertEquals((int)2, (int)this.aclAuthorizer2().aclCount());
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls((Authorizer)this.aclAuthorizer2(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                if (aclId % 10 == 0) {
                    return BoxesRunTime.boxToBoolean((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource));
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set expectedAcls = ((TraversableOnce)((TraversableLike)acls.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (AccessControlEntry)x$1._1(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertEquals((int)45, (int)this.aclAuthorizer().aclCount());
        Assertions.assertEquals((int)45, (int)this.aclAuthorizer2().aclCount());
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfAllow(AclOperation.READ, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, scala.collection.immutable.Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, scala.collection.immutable.Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)acls, this.clusterResource());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).filter((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op))))).foreach((Function1 & Serializable & scala.Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertEquals((int)0, (int)this.aclAuthorizer().aclCount());
        Assertions.assertEquals((int)0, (int)this.aclAuthorizer2().aclCount());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(Uuid.randomUuid()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testAddDeleteAclsForPrincipal() {
        AccessControlEntry allowAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry allowAcl2 = new AccessControlEntry(this.principal2().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl2 = new AccessControlEntry(this.principal2().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAcl, denyAcl, allowAcl2, denyAcl2}))), this.resource());
        Assertions.assertEquals((int)2, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)2, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAcl}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)2, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAcl}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)2, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAcl}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)2, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAcl, allowAcl2}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAcl2}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal2()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertTrue((boolean)this.aclAuthorizer().validateAclCaches());
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)deleteResults.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.aclBinding(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV0));
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedVersionException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testCreateAclWithInvalidResourceName() {
        Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "test/1", PatternType.LITERAL)));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV1));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV0));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV1));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{this.prepareDefaultConfig()}));
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)noTlsProps).asScala());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)propName -> {
            AclAuthorizerTest.$anonfun$testAuthorizerNoZkConfig$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue)}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value);
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false")}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString()), (Object)"true")}));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            new .colon.colon((Object)literalResource, (List)new .colon.colon((Object)prefixedResource, (List)new .colon.colon((Object)wildcardResource, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resource);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testAuthorizeByResourceTypeNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer aclAuthorizer = new AclAuthorizer();){
            aclAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    @Test
    public void testClusterLinkIds() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Uuid link1 = Uuid.randomUuid();
        Uuid link2 = Uuid.randomUuid();
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry localAcl1 = AclAuthorizerTest.acl$3(acl1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID}));
        AccessControlEntry localAcl2 = AclAuthorizerTest.acl$3(acl2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID}));
        AccessControlEntry localAcl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID}));
        AccessControlEntry link1Acl1 = AclAuthorizerTest.acl$3(acl1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1}));
        AccessControlEntry link2Acl2 = AclAuthorizerTest.acl$3(acl2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link2}));
        AccessControlEntry link12Acl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1, link2}));
        AccessControlEntry link1Acl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1}));
        AccessControlEntry link2Acl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link2}));
        AccessControlEntry link1AndLocalAcl1 = AclAuthorizerTest.acl$3(acl1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1, Uuid.ZERO_UUID}));
        AccessControlEntry link2AndLocalAcl2 = AclAuthorizerTest.acl$3(acl2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link2, Uuid.ZERO_UUID}));
        AccessControlEntry link12AndLocalAcl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1, link2, Uuid.ZERO_UUID}));
        AccessControlEntry link2AndLocalAcl3 = AclAuthorizerTest.acl$3(acl3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{link2, Uuid.ZERO_UUID}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl1, localAcl2, localAcl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl1}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl2, acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, link2Acl2, link12Acl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1AndLocalAcl1, link2AndLocalAcl2, link12AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1AndLocalAcl1, link2AndLocalAcl2, link2AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1AndLocalAcl1, link2AndLocalAcl2, link2AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2AndLocalAcl2, link2AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12Acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2AndLocalAcl2, acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2AndLocalAcl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2AndLocalAcl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl2}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2Acl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl2}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2Acl2}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1AndLocalAcl1, link2Acl2, link12AndLocalAcl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1AndLocalAcl1, link2Acl2, link12AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1, link2Acl2, link12Acl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1, link2Acl2, link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2Acl2}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1, link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl1}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl1, link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link1Acl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertFalse((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{localAcl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12Acl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), this.resource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.addAcls((Authorizer)this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, link2Acl2, link12AndLocalAcl3}))), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, link2Acl2, link12AndLocalAcl3}))), (Authorizer)this.aclAuthorizer(), this.resource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        this.verifyAcls$1(AccessControlEntryFilter.ANY, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, link2Acl2, link12AndLocalAcl3})));
        this.verifyAcls$1(acl1.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1})));
        this.verifyAcls$1(localAcl1.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1})));
        this.verifyAcls$1(acl2.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link2Acl2})));
        this.verifyAcls$1(localAcl2.toFilter(), Predef$.MODULE$.Set().empty());
        this.verifyAcls$1(acl3.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12AndLocalAcl3})));
        this.verifyAcls$1(localAcl3.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12AndLocalAcl3})));
        this.verifyAcls$1(link1Acl3.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12AndLocalAcl3})));
        this.verifyAcls$1(link2Acl3.toFilter(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{link12AndLocalAcl3})));
    }

    @Test
    public void testAclCountMetric() {
        this.verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "AclCount", Predef$.MODULE$.int2Integer(0));
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()}));
        scala.collection.immutable.Set<AccessControlEntry> currentAcls = this.changeAclAndVerify((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)acls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assertions.assertEquals((int)3, (int)this.aclAuthorizer().aclCount());
        this.verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "AclCount", Predef$.MODULE$.int2Integer(3));
        currentAcls = this.changeAclAndVerify(currentAcls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.changeAclAndVerify$default$4());
        Assertions.assertEquals((int)2, (int)this.aclAuthorizer().aclCount());
        this.verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "AclCount", Predef$.MODULE$.int2Integer(2));
        this.changeAclAndVerify(currentAcls, (scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.changeAclAndVerify$default$4());
        currentAcls = null;
        Assertions.assertEquals((int)0, (int)this.aclAuthorizer().aclCount());
        this.verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "AclCount", Predef$.MODULE$.int2Integer(0));
    }

    private void givenAuthorizerWithProtocolVersion(Option<MetadataVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        children.maybeThrow();
        Assertions.assertEquals((int)1, (int)children.children().size(), (String)"Expecting 1 change event");
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private scala.collection.immutable.Set<AccessControlEntry> changeAclAndVerify(scala.collection.immutable.Set<AccessControlEntry> originalAcls, scala.collection.immutable.Set<AccessControlEntry> addedAcls, scala.collection.immutable.Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        scala.collection.immutable.Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls((Authorizer)this.aclAuthorizer(), addedAcls, resource);
            acls = (scala.collection.immutable.Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls((Authorizer)this.aclAuthorizer(), removedAcls, resource);
            acls = (scala.collection.immutable.Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)acls, (Authorizer)this.aclAuthorizer(), resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private scala.collection.immutable.Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (scala.collection.immutable.Set)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.entry(), Set$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    private scala.collection.immutable.Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    private void verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.security.authorizer", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    public AclAuthorizer createAclAuthorizer() {
        return new AclAuthorizer();
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding($this.resource(), acl), Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, scala.collection.immutable.Set expectedAcls$1) {
        scala.collection.immutable.Set set = expectedAcls$1;
        scala.collection.immutable.Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, scala.collection.immutable.Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString());
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString());
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, scala.collection.immutable.Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString());
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString());
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.addAcls((Authorizer)$this.aclAuthorizer(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls((Authorizer)$this.aclAuthorizer2(), (scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerNoZkConfig$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(ZKClientConfig zkClientConfig$2, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"TLSv1.2", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(ZKClientConfig zkClientConfig$3, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$2, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(ZKClientConfig zkClientConfig$4, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)prefixedValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<None>"));
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(15L, TimeUnit.SECONDS), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(x$12.aclBindingDeleteResults()).asScala(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aclBinding(), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assertions.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)deleted);
        } else {
            Assertions.assertEquals((Object)List$.MODULE$.empty(), (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)AclAuthorizerTest.$anonfun$testCreateDeleteTiming$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AclAuthorizerTest.$anonfun$testCreateDeleteTiming$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    private static final AccessControlEntry acl$3(AccessControlEntry ace, Seq linkIds) {
        return SecurityUtils.aceWithClusterLinkIds((AccessControlEntry)ace, (Collection)((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)linkIds.toSet()).asJava()));
    }

    private final void verifyAcls$1(AccessControlEntryFilter filter, scala.collection.immutable.Set expectedAcls) {
        Assertions.assertEquals((Object)expectedAcls.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(this.resource(), ace), Set$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.authorizer().acls(new AclBindingFilter(this.resource().toFilter(), filter))).asScala()).toSet());
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(AclAuthorizerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public AclAuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        this.aclAuthorizer = this.createAclAuthorizer();
        this.aclAuthorizer2 = this.createAclAuthorizer();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

