/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherPool;
import kafka.server.FetcherStats;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.TierOffsetInfo;
import kafka.server.TierState;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019!\u0006\u0001)A\u0005#\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB/\u0001A\u0003%q\u000bC\u0003_\u0001\u0011\u0005q\fC\u0003q\u0001\u0011%\u0011\u000f\u0003\u0004\u0002\u0006\u0001!\ta\u0018\u0005\u0007\u0003\u001f\u0001A\u0011A0\t\r\u0005M\u0001\u0001\"\u0001`\u0011\u0019\t9\u0002\u0001C\u0001?\"1\u00111\u0004\u0001\u0005\u0002}Ca!a\b\u0001\t\u0003y\u0006BBA\u0012\u0001\u0011\u0005q\f\u0003\u0004\u0002(\u0001!\ta\u0018\u0005\u0007\u0003W\u0001A\u0011A0\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!I\u0011q\b\u0001\u0012\u0002\u0013%\u0011\u0011\t\u0005\b\u0003/\u0002A\u0011BA-\u0011%\t)\tAI\u0001\n\u0013\t9\tC\u0004\u0002\f\u0002!I!!$\u0007\r\u0005U\u0005\u0001BAL\u0011%\ty\n\u0007B\u0001B\u0003%q\u000b\u0003\u0004F1\u0011\u0005\u0011\u0011\u0015\u0005\u0007\u0003SCB\u0011I0\t\r\u0005-\u0006\u0004\"\u0011`\u0011\u0019)\u0006\u0004\"\u0011\u0002.\"9\u0011q\u0016\r\u0005B\u0005E\u0006bBAs1\u0011\u0005\u0013q\u001d\u0005\b\u0003cDB\u0011IAz\u0011\u001d\u0011Y\u0003\u0007C!\u0005[AqA!\u0010\u0019\t\u0003\u0012y\u0004C\u0004\u0003ba!\tEa\u0019\t\u000f\t%\u0004\u0004\"\u0011\u0003l!I!\u0011\u000f\rC\u0002\u0013\u0005#1\u000f\u0005\t\u0005kB\u0002\u0015!\u0003\u0002j\u001a1!q\u000f\u0001\u0005\u0005sB!B!!(\u0005\u0003\u0005\u000b\u0011BAR\u0011)\u0011\u0019i\nB\u0001B\u0003%!Q\u0011\u0005\u0007\u000b\u001e\"\tAa#\t\u000f\tMu\u0005\"\u0015\u0003\u0016\"9!1W\u0014\u0005R\tU\u0006b\u0002BbO\u0011E#Q\u0019\u0005\b\u0005\u001b<C\u0011\u000bBh\u0011\u001d\u0011)n\nC)\u0005/DqAa7(\t#\u0012i\u000eC\u0004\u0003b\u001e\"\tFa9\t\u0013\tMxE1A\u0005R\tM\u0004\u0002\u0003B{O\u0001\u0006I!!;\t\u000f\t]x\u0005\"\u0015\u0003z\"91\u0011E\u0014\u0005R\r\r\u0002bBB\u0018O\u0011E3\u0011\u0007\u0005\b\u0007w9C\u0011KB\u001f\u0005i\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\tQ4(\u0001\u0004tKJ4XM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011!O\u0001\fM\u0016$8\r[(gMN,G/F\u0001L!\t\u0001E*\u0003\u0002N\u0003\n!Aj\u001c8h\u000311W\r^2i\u001f\u001a47/\u001a;!\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0016\u0003E\u0003\"\u0001\u0011*\n\u0005M\u000b%aA%oi\u0006aA.Z1eKJ,\u0005o\\2iA\u0005q!M]8lKJ,e\u000e\u001a)pS:$X#A,\u0011\u0005a[V\"A-\u000b\u0005i[\u0014aB2mkN$XM]\u0005\u00039f\u0013aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\bce>\\WM]#oIB{\u0017N\u001c;!\u0003M\u0019G.Z1o\u001b\u0016$(/[2SK\u001eL7\u000f\u001e:z)\u0005\u0001\u0007C\u0001!b\u0013\t\u0011\u0017I\u0001\u0003V]&$\bF\u0001\u0005e!\t)g.D\u0001g\u0015\t9\u0007.A\u0002ba&T!!\u001b6\u0002\u000f),\b/\u001b;fe*\u00111\u000e\\\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002[\u0006\u0019qN]4\n\u0005=4'A\u0003\"fM>\u0014X-R1dQ\u0006qq-\u001a;NKR\u0014\u0018n\u0019,bYV,GC\u0001:v!\t\u00015/\u0003\u0002u\u0003\n\u0019\u0011I\\=\t\u000bYL\u0001\u0019A<\u0002\t9\fW.\u001a\t\u0003q~t!!_?\u0011\u0005i\fU\"A>\u000b\u0005ql\u0014A\u0002\u001fs_>$h(\u0003\u0002\u007f\u0003\u00061\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A`!\u00023Q,7\u000f^!eI\u0006sGMU3n_Z,\u0007+\u0019:uSRLwN\u001c\u0015\u0004\u0015\u0005%\u0001cA3\u0002\f%\u0019\u0011Q\u00024\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cH/T3ue&\u001cg)Y5mK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD3aCA\u0005\u0003e!Xm\u001d;EK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u\u001b\u0016$(/[2)\u00071\tI!A\nuKN$h)\u001a;dQJ\u000bG/Z'fiJL7\rK\u0002\u000e\u0003\u0013\t!\u0003^3tiR{G/\u00197MC\u001elU\r\u001e:jG\"\u001aa\"!\u0003\u00027Q,7\u000f^'jOJ\fG/Z%o'ft7\rU1si&$\u0018n\u001c8tQ\ry\u0011\u0011B\u0001\u0018i\u0016\u001cH/T1zE\u0016,\u0006\u000fZ1uKR{\u0007/[2JIND3\u0001EA\u0005\u0003Q!Xm\u001d;FqB\fg\u000e\u001a+ie\u0016\fG\rU8pY\"\u001a\u0011#!\u0003\u0002)Q,7\u000f^*ie&t7\u000e\u00165sK\u0006$\u0007k\\8mQ\r\u0011\u0012\u0011B\u0001\u0015i\u0016\u001cHOU3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0015\u000f\u0001\f\u0019$a\u000e\u0002<!1\u0011QG\nA\u0002E\u000b!cY;se\u0016tGOR3uG\",'oU5{K\"1\u0011\u0011H\nA\u0002E\u000baB\\3x\r\u0016$8\r[3s'&TX\r\u0003\u0005\u0002>M\u0001\n\u00111\u0001R\u0003%\u0011'o\\6fe:+X.\u0001\u0010uKN$(+Z:ju\u0016$\u0006N]3bIB{w\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\t\u0016\u0004#\u0006\u00153FAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E\u0013)\u0001\u0006b]:|G/\u0019;j_:LA!!\u0016\u0002L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%5\f7.\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\t\u00037\nI(! \u0002\u0002B1\u0011QLA2\u0003Oj!!a\u0018\u000b\u0007\u0005\u0005\u0014)\u0001\u0006d_2dWm\u0019;j_:LA!!\u001a\u0002`\t\u00191+\u001a;\u0011\t\u0005%\u0014QO\u0007\u0003\u0003WRA!!\u001c\u0002p\u000511m\\7n_:T1\u0001PA9\u0015\r\t\u0019\b\\\u0001\u0007CB\f7\r[3\n\t\u0005]\u00141\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tY(\u0006a\u0001#\u0006AAo\u001c9jG:+X\u000e\u0003\u0004\u0002\u0000U\u0001\r!U\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\t\u0003\u0007+\u0002\u0013!a\u0001o\u0006YAo\u001c9jGB\u0013XMZ5y\u0003qi\u0017m[3U_BL7\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"!!#+\u0007]\f)%A\u0006hKR\u0014%o\\6fe&#G#B)\u0002\u0010\u0006M\u0005bBAI/\u0001\u0007\u0011qM\u0001\u0003iBDa!!\u0010\u0018\u0001\u0004\t&aH'pG.\u0014Vm]5{K\u001a+Go\u00195fe2+\u0017\rZ3s\u000b:$\u0007k\\5oiN!\u0001dPAM!\rA\u00151T\u0005\u0004\u0003;K$A\u0004'fC\u0012,'/\u00128e!>Lg\u000e^\u0001\rg>,(oY3Ce>\\WM\u001d\u000b\u0005\u0003G\u000b9\u000bE\u0002\u0002&bi\u0011\u0001\u0001\u0005\u0007\u0003?S\u0002\u0019A,\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f\u0003\u0015\u0019Gn\\:f)\u00059\u0016A\u00032vS2$g)\u001a;dQR!\u00111WAk!\u0019\t),a1\u0002J:!\u0011qWA`\u001d\u0011\tI,!0\u000f\u0007i\fY,C\u0001=\u0013\tQ4(C\u0002\u0002Bf\nQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0002F\u0006\u001d'\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0002Bf\u0002R\u0001QAf\u0003\u001fL1!!4B\u0005\u0019y\u0005\u000f^5p]B!\u0011QWAi\u0013\u0011\t\u0019.a2\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\u0005]g\u00041\u0001\u0002Z\u0006a\u0001/\u0019:uSRLwN\\'baBA\u0011QLAn\u0003O\ny.\u0003\u0003\u0002^\u0006}#aA'baB\u0019\u0001*!9\n\u0007\u0005\r\u0018HA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-A\bjgJ+\u0017\rZ=G_J4U\r^2i)\u0011\tI/a<\u0011\u0007\u0001\u000bY/C\u0002\u0002n\u0006\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0012~\u0001\r!a\u001a\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\t)P!\b\u0011\u0011\u0005u\u00131\\A4\u0003o\u0004B!!?\u0003\u00189!\u00111 B\t\u001d\u0011\tiP!\u0004\u000f\t\u0005}(1\u0002\b\u0005\u0005\u0003\u0011IA\u0004\u0003\u0003\u0004\t\u001dab\u0001>\u0003\u0006%\tQ.C\u0002\u0002t1L1\u0001PA9\u0013\u0011\ti'a\u001c\n\t\t=\u00111N\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011\u0019B!\u0006\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0005\u001f\tY'\u0003\u0003\u0003\u001a\tm!AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0006\u0005\u0005'\u0011)\u0002C\u0004\u0003 \u0001\u0002\rA!\t\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0005\u0002^\u0005m\u0017q\rB\u0012!\u0011\u0011)Ca\n\u000e\u0003aIAA!\u000b\u0002\u001c\nIQ\t]8dQ\u0012\u000bG/Y\u0001\u001fM\u0016$8\r\u001b+jKJl\u0015\r^3sS\u0006d\u0017N_1uS>tG+\u0019:hKR$bAa\f\u00036\te\u0002c\u0001%\u00032%\u0019!1G\u001d\u0003\u001dQKWM](gMN,G/\u00138g_\"9!qG\u0011A\u0002\u0005\u001d\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0005w\t\u0003\u0019A)\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0005\u0003\u0012I\u0005\u0005\u0005\u0002^\u0005m\u0017q\rB\"!\u0011\u0011)C!\u0012\n\t\t\u001d\u00131\u0014\u0002\n\r\u0016$8\r\u001b#bi\u0006DqAa\u0013#\u0001\u0004\u0011i%\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003P\tmc\u0002\u0002B)\u0005/j!Aa\u0015\u000b\t\tU\u00131N\u0001\te\u0016\fX/Z:ug&!!\u0011\fB*\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011iFa\u0018\u0003\u000f\t+\u0018\u000e\u001c3fe*!!\u0011\fB*\u0003M1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u)\u0015Y%Q\rB4\u0011\u001d\u00119d\ta\u0001\u0003OBaAa\u000f$\u0001\u0004\t\u0016!\u00054fi\u000eDG*\u0019;fgR|eMZ:fiR)1J!\u001c\u0003p!9!q\u0007\u0013A\u0002\u0005\u001d\u0004B\u0002B\u001eI\u0001\u0007\u0011+\u0001\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005%\u0018!H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\r\u001a\u0011\u0003/Q+7\u000f\u001e*fg&TXMR3uG\",'\u000f\u00165sK\u0006$7cA\u0014\u0003|A\u0019\u0001J! \n\u0007\t}\u0014HA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\r1,\u0017\rZ3s\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002I\u0005\u000fK1A!#:\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0003\u000e\n=%\u0011\u0013\t\u0004\u0003K;\u0003b\u0002BAU\u0001\u0007\u00111\u0015\u0005\b\u0005\u0007S\u0003\u0019\u0001BC\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!q\u0013BS\u0005O\u0013I\u000bE\u0003A\u0003\u0017\u0014I\n\u0005\u0003\u0003\u001c\n\u0005VB\u0001BO\u0015\r\u0011yjO\u0001\u0004Y><\u0017\u0002\u0002BR\u0005;\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002B\u001cW\u0001\u0007\u0011q\r\u0005\u0006\u0013.\u0002\ra\u0013\u0005\b\u0005W[\u0003\u0019\u0001BW\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!q\u0016BY\u001b\u00059\u0013\u0002\u0002B$\u0005{\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0006A\n]&\u0011\u0018\u0005\b\u0005oa\u0003\u0019AA4\u0011\u001d\u0011Y\f\fa\u0001\u0005{\u000bq\u0002\u001e:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004\u0011\n}\u0016b\u0001Bas\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0015\u0001'q\u0019Be\u0011\u001d\u00119$\fa\u0001\u0003OBaAa3.\u0001\u0004Y\u0015AB8gMN,G/A\u0006mCR,7\u000f^#q_\u000eDG\u0003\u0002Bi\u0005'\u0004B\u0001QAf#\"9!q\u0007\u0018A\u0002\u0005\u001d\u0014A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0004\u0017\ne\u0007b\u0002B\u001c_\u0001\u0007\u0011qM\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0004\u0017\n}\u0007b\u0002B\u001ca\u0001\u0007\u0011qM\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGC\u0002Bs\u0005[\u0014y\u000fE\u0003A\u0003\u0017\u00149\u000fE\u0002I\u0005SL1Aa;:\u00059yeMZ:fi\u0006sG-\u00129pG\"DqAa\u000e2\u0001\u0004\t9\u0007\u0003\u0004\u0003rF\u0002\r!U\u0001\u0006KB|7\r[\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$\u0017\u0001I5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0002\naBZ3uG\"$\u0016.\u001a:Ti\u0006$X\r\u0006\u0004\u0003|\u000eU1q\u0003\t\u0007\u0005{\u001cYaa\u0004\u000e\u0005\t}(\u0002BB\u0001\u0007\u0007\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0019)aa\u0002\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0007\u0013\tAA[1wC&!1Q\u0002B\u0000\u0005\u00191U\u000f^;sKB\u0019\u0001j!\u0005\n\u0007\rM\u0011HA\u0005US\u0016\u00148\u000b^1uK\"9!q\u0007\u001bA\u0002\u0005\u001d\u0004bBB\ri\u0001\u000711D\u0001\fi&,'oU3h[\u0016tG\u000f\u0005\u0003\u0003\u001c\u000eu\u0011\u0002BB\u0010\u0005;\u0013a\u0002V5fe2{wmU3h[\u0016tG/\u0001\np]J+7\u000f^8sKRKWM]*uCR,Gc\u00021\u0004&\r\u001d21\u0006\u0005\b\u0005o)\u0004\u0019AA4\u0011\u0019\u0019I#\u000ea\u0001\u0017\u0006)\u0002O]8q_N,G\rT8dC2dunZ*uCJ$\bbBB\u0017k\u0001\u00071qB\u0001\ni&,'o\u0015;bi\u0016\fq$\\1uKJL\u0017\r\\5{KRKWM]*uCR,WK\u001c;jY>3gm]3u)\u0019\u0019\u0019d!\u000e\u00048A1!Q`B\u0006\u00077AqAa\u000e7\u0001\u0004\t9\u0007\u0003\u0004\u0004:Y\u0002\raS\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r^\u0001\"[\u0006$XM]5bY&TX\rV5feN#\u0018\r^3V]RLGn\u00142kK\u000e$\u0018\n\u001a\u000b\u000b\u0007g\u0019yd!\u0011\u0004D\r=\u0003b\u0002B\u001co\u0001\u0007\u0011q\r\u0005\u0007\u0007s9\u0004\u0019A&\t\u000f\r\u0015s\u00071\u0001\u0004H\u0005qA/\u0019:hKR|%M[3di&#\u0007\u0003BB%\u0007\u0017j!aa\u0001\n\t\r531\u0001\u0002\u0005+VKE\t\u0003\u0004\u0004R]\u0002\r!U\u0001\u0013i\u0006\u0014x-\u001a;SKN$xN]3Fa>\u001c\u0007\u000e")
public class AbstractFetcherManagerTest {
    private final long fetchOffset;
    private final int leaderEpoch;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 9092);

    public long fetchOffset() {
        return this.fetchOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId, this.fetchOffset(), (Option)None$.MODULE$, this.leaderEpoch(), (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn((Object)Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$1;
            private final AbstractFetcherThread fetcher2$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$1;
                }
                return this.fetcher2$1;
            }
            {
                this.fetcher1$1 = fetcher1$1;
                this.fetcher2$1 = fetcher2$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.leader().brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)2, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{false}));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testFetchRateMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$2;
            private final AbstractFetcherThread fetcher2$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$2;
                }
                return this.fetcher2$2;
            }
            {
                this.fetcher1$2 = fetcher1$2;
                this.fetcher2$2 = fetcher2$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Meter requestRate1 = (Meter)Mockito.mock(Meter.class);
        Meter requestRate2 = (Meter)Mockito.mock(Meter.class);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate1.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)10.0));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate2.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)5.0));
        FetcherStats fetcherStats1 = (FetcherStats)Mockito.mock(FetcherStats.class);
        FetcherStats fetcherStats2 = (FetcherStats)Mockito.mock(FetcherStats.class);
        Mockito.when((Object)fetcherStats1.requestRate()).thenReturn((Object)requestRate1);
        Mockito.when((Object)fetcherStats2.requestRate()).thenReturn((Object)requestRate2);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.fetcherStats()).thenReturn((Object)fetcherStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.fetcherStats()).thenReturn((Object)fetcherStats2);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$1(x0$1)))).values().headOption().get()).value()));
        Assertions.assertEquals((int)0, (int)((TraversableOnce)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$2(x0$2)))).keys().filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$3(k)))).size());
        Assertions.assertEquals((double)15.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$4(x0$3)))).values().headOption().get()).value()));
        fetcherManager.createSeparateFetcherMetrics();
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$5(x0$4)))).values().headOption().get()).value()));
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$6(x0$5)))).values().headOption().get()).value()));
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        ((Thread)Mockito.verify((Object)fetcher2)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
    }

    @Test
    public void testTotalLagMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$3;
            private final AbstractFetcherThread fetcher2$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$3;
                }
                return this.fetcher2$3;
            }
            {
                this.fetcher1$3 = fetcher1$3;
                this.fetcher2$3 = fetcher2$3;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        IndexedSeq tps = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> AbstractFetcherManagerTest.$anonfun$testTotalLagMetric$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq fetcher1Partitions = (IndexedSeq)tps.slice(0, 2);
        IndexedSeq fetcher2Partitions = (IndexedSeq)tps.slice(2, 4);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        scala.collection.immutable.Map fetcher1FetchState = ((TraversableOnce)fetcher1Partitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map fetcher2FetchState = ((TraversableOnce)fetcher2Partitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ClientIdAndBroker metricId = new ClientIdAndBroker("0", "localhost", 9092);
        FetcherLagStats fetcherLagStats1 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Function1 & Serializable & scala.Serializable valueFactory = (Function1 & Serializable & scala.Serializable)k -> new FetcherLagMetrics(new ClientIdTopicPartition(metricId.clientId(), k), (Map)Map$.MODULE$.empty());
        Pool lagStats1 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(0))).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(1))).lag_$eq(2L);
        Pool lagStats2 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(0))).lag_$eq(1L);
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(1))).lag_$eq(3L);
        FetcherLagStats fetcherLagStats2 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats1.stats()).thenReturn((Object)lagStats1);
        Mockito.when((Object)fetcherLagStats2.stats()).thenReturn((Object)lagStats2);
        Mockito.when((Object)fetcher1.addPartitions((Map)fetcher1FetchState)).thenReturn((Object)fetcher1Partitions.toSet());
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)fetcher2FetchState)).thenReturn((Object)fetcher2Partitions.toSet());
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats2);
        fetcherManager.addFetcherForPartitions((Map)fetcher1FetchState, (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), (Object)this.getMetricValue("TotalLag"));
        fetcherManager.addFetcherForPartitions((Map)fetcher2FetchState, (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)6L), (Object)this.getMetricValue("TotalLag"));
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
    }

    @Test
    public void testMigrateInSyncPartitions() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$4;
            private final AbstractFetcherThread fetcher2$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$4;
                }
                return this.fetcher2$4;
            }
            {
                this.fetcher1$4 = fetcher1$4;
                this.fetcher2$4 = fetcher2$4;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$1.scheduler()), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp_0 = new TopicPartition("topic", 0);
        TopicPartition tp_1 = new TopicPartition("topic", 1);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState_0 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        InitialFetchState initialFetchState_1 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        PartitionFetchState partitionFetchState_0 = new PartitionFetchState((Option)topicId, this.fetchOffset(), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), this.leaderEpoch(), (Option)None$.MODULE$, (ReplicaState)Mockito.mock(ReplicaState.class), (Option)None$.MODULE$, PartitionFetchState$.MODULE$.$lessinit$greater$default$8());
        Function1 & Serializable & scala.Serializable valueFactory = arg_0 -> AbstractFetcherManagerTest.$anonfun$testMigrateInSyncPartitions$1(new ClientIdAndBroker("0", "localhost", 9092), arg_0);
        Pool lagStats = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_0)).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_1)).lag_$eq(1L);
        FetcherLagStats fetcherLagStats = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats.stats()).thenReturn((Object)lagStats);
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_1})));
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)fetcher1.removePartitions((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})))).thenReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)partitionFetchState_0)})));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher1.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_1)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher2.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.fetchState(tp_0)).thenReturn((Object)new Some((Object)partitionFetchState_0));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)1, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertTrue((boolean)fetcherManager.fetcherThreadMap().contains((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        time.sleep(1001L);
        Assertions.assertEquals((int)2, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertEquals((Object)fetcher1, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        Assertions.assertEquals((Object)fetcher2, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.InSync$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$2.scheduler()), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId1, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0)));
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId2, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$, 0)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, this.testResizeThreadPool$default$3());
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, this.testResizeThreadPool$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, this.makeTopicPartition$default$3());
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.$outer.new TestResizeFetcherThread(new MockResizeFetcherLeaderEndPoint(this.$outer, sourceBroker), this.failedPartitions());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        try {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            fetcherManager.addFetcherForPartitions((Map)((TraversableOnce)fetchingTopicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            }, scala.collection.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
            ((IterableLike)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = Set$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1);
            Map map = Implicits$.MODULE$.MapExtensionMethods((Map)fetcherManager.fetcherThreadMap());
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable & scala.Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$3(MetricName k) {
        return k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name()) || k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$3._1()).getName();
        String string2 = "TotalFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$5(Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$4._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$6(Tuple2 x0$5) {
        if (x0$5 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$5._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTotalLagMetric$1(int i) {
        return new TopicPartition("topic", i);
    }

    public static final /* synthetic */ FetcherLagMetrics $anonfun$testMigrateInSyncPartitions$1(ClientIdAndBroker metricId$2, TopicPartition k) {
        return new FetcherLagMetrics(new ClientIdTopicPartition(metricId$2.clientId(), k), (Map)Map$.MODULE$.empty());
    }

    private static final void verifyFetchState$1(AbstractFetcherThread fetcher, TopicPartition tp, Option expectedTopicId) {
        Option fetchState = fetcher.fetchState(tp);
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    private static final void verifyFetchState$2(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public AbstractFetcherManagerTest() {
        this.fetchOffset = 10L;
        this.leaderEpoch = 15;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockResizeFetcherLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Map)Map$.MODULE$.empty());
        }

        public boolean isReadyForFetch(TopicPartition tp) {
            return true;
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return Map$.MODULE$.empty();
        }

        public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
            throw new UnsupportedOperationException("fetchTierMaterializationTargetFromLeader is not supported in this test");
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return Map$.MODULE$.empty();
        }

        public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockResizeFetcherLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
            throw new UnsupportedOperationException("fetchTierState is not supported in this test");
        }

        public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
            throw new UnsupportedOperationException("onRestoreTierState is not supported in this test");
        }

        public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
            throw new UnsupportedOperationException("materializeTierStateUntilOffset is not supported in this test");
        }

        public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
            throw new UnsupportedOperationException("materializeTierStateUntilObjectId is not supported in this test");
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(MockResizeFetcherLeaderEndPoint leader, FailedPartitions failedPartitions) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            String x$1 = "test-resize-fetcher";
            String x$2 = "mock-fetcher";
            ExponentialBackoff x$5 = new ExponentialBackoff(0L, 2, 1000L, 0.0);
            BrokerTopicStats x$6 = new BrokerTopicStats();
            boolean x$7 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
            Map x$8 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$8();
            super(x$1, x$2, (LeaderEndPoint)leader, failedPartitions, x$5, x$7, x$6, x$8);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

