/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-e\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0011\u00199\u0007\u0001)A\u00059\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007B\u00029\u0001A\u0003%!\u000eC\u0004r\u0001\t\u0007I\u0011\u0001:\t\ra\u0004\u0001\u0015!\u0003t\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0002!Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0006\u0011-\t9\u0002\u0001a\u0001\u0002\u0003\u0006K!a\u0001\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\b\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0006I!!\b\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a.\u0001\t\u0003\ty\u0003C\u0004\u0002B\u0002!\t!a\f\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u00020!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005=\u0002bBAg\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003#\u0004A\u0011AA\u0018\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!;\u0001\t\u0013\tY\u000fC\u0004\u0002~\u0002!\t!a\f\t\u000f\t\u0005\u0001\u0001\"\u0001\u00020!9!Q\u0001\u0001\u0005\u0002\u0005=\u0002b\u0002B\u0005\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!q\t\u0001\u0005\n\t%\u0003b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011\u0019\u000e\u0001C\u0005\u0005+Dqa!\u0001\u0001\t\u0013\u0019\u0019\u0001C\u0004\u0004\f\u0001!\t!a\f\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!911\u0004\u0001\u0005\n\ru\u0001\"CB\u001d\u0001E\u0005I\u0011BB\u001e\u0011%\u0019\t\u0006AI\u0001\n\u0013\u0019\u0019\u0006C\u0005\u0004X\u0001\t\n\u0011\"\u0003\u0004Z!I1Q\f\u0001\u0012\u0002\u0013%1\u0011\f\u0005\n\u0007?\u0002\u0011\u0013!C\u0005\u00073B\u0011b!\u0019\u0001#\u0003%Iaa\u0019\b\u000f\r\u001dt\b#\u0001\u0004j\u00191ah\u0010E\u0001\u0007WBaa\u0013\u001e\u0005\u0002\r5\u0004bBA:u\u0011\u00051q\u000e\u0005\b\u00037SD\u0011ABA\u0005e\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\u0001\u000b\u0015AB:feZ,'OC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A#\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0005\u0002O\u00015\tq(A\u0003u_BL7-F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003mC:<'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0004u_BL7-\u00133\u0016\u0003q\u0003\"!X3\u000e\u0003yS!a\u00181\u0002\r\r|W.\\8o\u0015\t\u0011\u0015M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014_\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\nA\u0001^5nKV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n\u0003\u0006)Q\u000f^5mg&\u0011q\u000e\u001c\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A:\u0011\u0005Q4X\"A;\u000b\u0005Et\u0016BA<v\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tEJ|7.\u001a:JIV\t1\u0010\u0005\u0002Gy&\u0011Qp\u0012\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005\r\u0001c\u0001(\u0002\u0006%\u0019\u0011qA \u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0017EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u0011QBA\n!\r1\u0015qB\u0005\u0004\u0003#9%\u0001B+oSRD\u0011\"!\u0006\u000e\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'A\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014\b%A\u0002uaB*\"!!\b\u0011\u0007u\u000by\"C\u0002\u0002\"y\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\b\u0007I\u0001\u0004iB\f\u0014\u0001\u0002;qc\u0001\n1\u0001\u001e93\u0003\u0011!\bO\r\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u00055\u0001fA\u000b\u00024A!\u0011QGA\"\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012aA1qS*!\u0011QHA \u0003\u001dQW\u000f]5uKJT1!!\u0011d\u0003\u0015QWO\\5u\u0013\u0011\t)%a\u000e\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005uKN$()Y:jGR!\u0011QBA&\u0011\u001d\tiE\u0006a\u0001\u0003\u001f\nq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019q,!\u0016\u000b\u0005\u0001\u0003\u0017\u0002BA-\u0003'\u0012q\"T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\b-\u0005u\u0013QNA8!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003O\nY$\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\n\tG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002r\u0005\u0012\u00111O\u0001\u0018aJ|g/\u001b3f\u001b\u0016$\u0018\rZ1uCZ+'o]5p]ND3AFA<!\u0011\tI(a\u001f\u000e\u0005\u0005\u0015\u0014\u0002BA?\u0003K\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0001\"Xm\u001d;CCNL7mU3oi2+\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3\u0015\r\u00055\u00111QAC\u0011\u001d\tie\u0006a\u0001\u0003\u001fBq!a\"\u0018\u0001\u0004\tI)A\nmK\u0006$WM\u001d*fG>4XM]=Ti\u0006$X\r\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty\tY\u0001\t[\u0016$\u0018\rZ1uC&!\u00111SAG\u0005MaU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;fQ\u001d9\u0012QLA7\u0003/c#!!'\"\u0005\u0005m\u0015A\u00079s_ZLG-\u001a'fC\u0012,'OU3d_Z,'/_*uCR,\u0007fA\f\u0002x\u0005AB/Z:u\u001fZ,'o\u001e:ji\u0016<\u0016\u000e\u001e5j]\n\u000bGo\u00195\u0015\t\u00055\u00111\u0015\u0005\b\u0003\u001bB\u0002\u0019AA(Q\u001dA\u0012QLA7\u0003Oc#!!\u001d)\u0007a\t9(A\buKN$8+\u001b8hY\u0016\u0014\u0015\r^2i)\u0011\ti!a,\t\u000f\u00055\u0013\u00041\u0001\u0002P!:\u0011$!\u0018\u0002n\u0005MFFAA9Q\rI\u0012qO\u0001\u0017i\u0016\u001cHoU;c[&$hI]8n\u0007\u0006dGNY1dW\"\u001a!$a/\u0011\t\u0005U\u0012QX\u0005\u0005\u0003\u007f\u000b9D\u0001\u0003UKN$\u0018a\u0006;fgR\fU\u000f\u001e5pe&T\u0018\r^5p]\u001a\u000b\u0017\u000e\\3eQ\rY\u00121X\u0001\u0015i\u0016\u001cHo\u0015;bY\u0016\u0014%o\\6fe\u0016\u0003xn\u00195)\u0007q\tY,A\tuKN$XK\\6o_^t7+\u001a:wKJD3!HA^\u0003\u0001\"Xm\u001d;SKR\u0014\u0018p\u00148BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007y\tY,\u0001\u0012uKN$(+\u001a;ss>sWK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bJ\u0014xN\u001d\u0015\u0004?\u0005m\u0016\u0001\u0007;fgR\u0014V\r\u001e:z\u001f:$v\u000e\u001d'fm\u0016dWI\u001d:peR!\u0011QBAm\u0011\u001d\tY\u000e\ta\u0001\u0003;\fQ!\u001a:s_J\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gt\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0007\u000bJ\u0014xN]:\u00021Q,7\u000f\u001e*fiJLxJ\\#se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0002\u000e\u00055\bbBAxC\u0001\u0007\u0011\u0011_\u0001\te\u0016\u001c\bo\u001c8tKB!\u00111_A}\u001b\t\t)PC\u0002\u0002x\u0002\fqa\u00197jK:$8/\u0003\u0003\u0002|\u0006U(AD\"mS\u0016tGOU3ta>t7/Z\u0001\u0019i\u0016\u001cH/\u00138wC2LG-\u00169eCR,g+\u001a:tS>t\u0007f\u0001\u0012\u0002<\u0006IB/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8oQ\r\u0019\u00131X\u0001\u0018i\u0016\u001cHOT8u\u0019\u0016\fG-\u001a:Pe\u001a{G\u000e\\8xKJD3\u0001JA^\u0003I!Xm\u001d;J]Z\fG.\u001b3SKF,Xm\u001d;)\u0007\u0015\nY,A\ndQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8FeJ|'\u000f\u0006\u0003\u0002\u000e\tE\u0001bBAnM\u0001\u0007\u0011Q\\\u0001\u0013i\u0016\u001cH\u000fU1si&$\u0018n\u001c8FeJ|'\u000f\u0006\u0004\u0003\u0018\tu!\u0011\u0005\t\u0004\u001d\ne\u0011b\u0001B\u000e\u007f\t)\u0012\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\bb\u0002B\u0010O\u0001\u0007\u0011QD\u0001\u0003iBDq!a7(\u0001\u0004\ti.A\buKN$xJ\\3J]\u001ac\u0017n\u001a5u)\u0011\tiAa\n\t\u000f\u00055\u0003\u00061\u0001\u0002P!:\u0001&!\u0018\u0002n\t-BFAA9Q\rA\u0013qO\u0001\u001fi\u0016\u001cH\u000fU1si&$\u0018n\u001c8NSN\u001c\u0018N\\4J]J+7\u000f]8og\u0016$B!!\u0004\u00034!9\u0011QJ\u0015A\u0002\u0005=\u0003fB\u0015\u0002^\u00055$q\u0007\u0017\u0003\u0003cB3!KA<\u0003M!Xm\u001d;QCJ$\u0018.\u00197U_BL7-\u00133t)\u0011\tiAa\u0010\t\u000f\u00055#\u00061\u0001\u0002P!:!&!\u0018\u0002n\t\rCFAA9Q\rQ\u0013qO\u0001\u0012m\u0016\u0014\u0018NZ=TK:$'+Z9vKN$HC\u0002B&\u0005#\u0012\u0019\u0006E\u0002O\u0005\u001bJ1Aa\u0014@\u0005\t\u001auN\u001c;s_2dWM\u001d*fcV,7\u000f^\"p[BdW\r^5p]\"\u000bg\u000e\u001a7fe\"1qp\u000ba\u0001\u0003\u0007AqA!\u0016,\u0001\u0004\u00119&A\bfqB,7\r^3e%\u0016\fX/Z:u!\u0019\u0011IFa\u0018\u0003d5\u0011!1\f\u0006\u0004\u0005;\u001a\u0017aB7pG.LGo\\\u0005\u0005\u0005C\u0012YFA\bBe\u001e,X.\u001a8u\u001b\u0006$8\r[3sa\u0011\u0011)G! \u0011\r\t\u001d$1\u000fB=\u001d\u0011\u0011IGa\u001c\u000e\u0005\t-$b\u0001B7=\u0006A!/Z9vKN$8/\u0003\u0003\u0003r\t-\u0014aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\t\tU$q\u000f\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\u0011\tHa\u001b\u0011\t\tm$Q\u0010\u0007\u0001\t1\u0011yHa\u0015\u0002\u0002\u0003\u0005)\u0011\u0001BA\u0005\ryF%M\t\u0005\u0005\u0007\u0013I\tE\u0002G\u0005\u000bK1Aa\"H\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BA!\u001b\u0003\f&!!Q\u0012B6\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0001H1mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fcV,7\u000f^'bi\u000eDWM\u001d\u000b\u0007\u0005'\u0013yJ!/\u0011\r\te#q\fBKa\u0011\u00119Ja'\u0011\r\t\u001d$1\u000fBM!\u0011\u0011YHa'\u0005\u0017\tuE&!A\u0001\u0002\u000b\u0005!\u0011\u0011\u0002\u0004?\u0012\u0012\u0004b\u0002BQY\u0001\u0007!1U\u0001\u0018Kb\u0004Xm\u0019;fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!*\u00034\u0006ua\u0002\u0002BT\u0005_\u00032A!+H\u001b\t\u0011YKC\u0002\u0003.\u000e\u000ba\u0001\u0010:p_Rt\u0014b\u0001BY\u000f\u00061\u0001K]3eK\u001aLAA!.\u00038\n\u00191+\u001a;\u000b\u0007\tEv\tC\u0004\u0003<2\u0002\rA!0\u0002\u001f\u0015D\b/Z2uK\u00124VM]:j_:\u00042A\u0012B`\u0013\r\u0011\tm\u0012\u0002\u0006'\"|'\u000f^\u0001\u0013[\u0006\\Wm\u00117jK:$(+Z:q_:\u001cX\r\u0006\u0004\u0002r\n\u001d'q\u001a\u0005\b\u0003_l\u0003\u0019\u0001Be!\u0011\u0011IGa3\n\t\t5'1\u000e\u0002\u0017\u00032$XM\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK\"9!\u0011[\u0017A\u0002\tu\u0016a\u0002<feNLwN\\\u0001\u0013[\u0006\\W-\u00117uKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003J\n]\u0007b\u0002Bm]\u0001\u0007!1\\\u0001\u0007i>\u0004\u0018nY:\u0011\r\tu'q\u001dBw\u001d\u0011\u0011yNa9\u000f\t\t%&\u0011]\u0005\u0002\u0011&\u0019!Q]$\u0002\u000fA\f7m[1hK&!!\u0011\u001eBv\u0005\r\u0019V-\u001d\u0006\u0004\u0005K<\u0005\u0003\u0002Bx\u0005wtAA!=\u0003x6\u0011!1\u001f\u0006\u0004\u0005kt\u0016aB7fgN\fw-Z\u0005\u0005\u0005s\u0014\u00190\u0001\u000eBYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0003~\n}(!\u0003+pa&\u001cG)\u0019;b\u0015\u0011\u0011IPa=\u000275\f7.Z!mi\u0016\u0014\b+\u0019:uSRLwN\u001c+pa&\u001cG)\u0019;b)\u0019\u0011io!\u0002\u0004\n!91qA\u0018A\u0002\u0005u\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tYn\fa\u0001\u0003;\f1\u0002^3tij[')Y:jG\"\u001a\u0001'a/\u00023Q,7\u000f^\"b]N+(-\\5u\rJ|WnQ1mY\n\f7m\u001b\u000b\u0005\u0003\u001b\u0019\u0019\u0002C\u0004\u0002NE\u0002\r!a\u0014)\u000fE\ni&!\u001c\u0004\u00181\u0012\u0011\u0011\u000f\u0015\u0004c\u0005]\u0014!\u00059beRLG/[8o%\u0016\u001c\bo\u001c8tKRq!\u0011ZB\u0010\u0007C\u0019\u0019ca\n\u0004,\r=\u0002\"\u0003B\u0010eA\u0005\t\u0019AA\u000f\u0011%\tYN\rI\u0001\u0002\u0004\ti\u000e\u0003\u0005\u0004&I\u0002\n\u00111\u0001|\u00039\u0001\u0018M\u001d;ji&|g.\u00129pG\"D\u0001b!\u000b3!\u0003\u0005\ra_\u0001\tY\u0016\fG-\u001a:JI\"A1Q\u0006\u001a\u0011\u0002\u0003\u000710A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CB\u0019eA\u0005\t\u0019AB\u001a\u0003\rI7O\u001d\t\u0006\u0005;\u001c)d_\u0005\u0005\u0007o\u0011YO\u0001\u0003MSN$\u0018a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004>)\"\u0011QDB W\t\u0019\t\u0005\u0005\u0003\u0004D\r5SBAB#\u0015\u0011\u00199e!\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAB&\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r=3Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0004V)\"\u0011Q\\B \u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\f\u0016\u0004w\u000e}\u0012a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$C'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H%N\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r\u0015$\u0006BB\u001a\u0007\u007f\t\u0011$\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'\u000fV3tiB\u0011aJO\n\u0003u\u0015#\"a!\u001b\u0015\u0005\rE\u0004CBB:\u0007{\ny%\u0004\u0002\u0004v)!1qOB=\u0003\u0019\u0019HO]3b[*\u001911P+\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007\u007f\u001a)H\u0001\u0004TiJ,\u0017-\u001c\u000b\u0003\u0007\u0007\u0003baa\u001d\u0004~\r\u0015\u0005\u0003BA0\u0007\u000fKAa!#\u0002b\tI\u0011I]4v[\u0016tGo\u001d")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        LeaderRecoveryState expectedLeaderRecoveryState = metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED;
        AlterPartitionRequestData.PartitionData partitionReq = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((byte)expectedLeaderRecoveryState.value(), (byte)partitionReq.leaderRecoveryState());
        LeaderRecoveryState leaderRecoveryState2 = leaderRecoveryState;
        LeaderRecoveryState leaderRecoveryState3 = LeaderRecoveryState.RECOVERING;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(leaderRecoveryState2 != null ? !leaderRecoveryState2.equals(leaderRecoveryState3) : leaderRecoveryState3 != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)partitionReq.isUnclean()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable & scala.Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$1, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(zar, Errors.NONE), (List)Nil$.MODULE$)), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(foo, Errors.NONE), (List)new .colon.colon((Object)this.makeAlterPartitionTopicData(bar, Errors.NONE), (List)Nil$.MODULE$))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(BrokerToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(alterPartitionRequest.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topicData -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicData.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version, (MessageContext)MessageContext.IDENTITY));
    }

    private AlterPartitionResponse makeAlterPartition(Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2, (Option)None$.MODULE$), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testCanSubmitFromCallback(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterIsrManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterIsrManager.start();
        CompletableFuture future = this.submitAndVerify$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), alterIsrManager);
        future.whenComplete((x$4, x$5) -> this.submitAndVerify$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), alterIsrManager));
        AlterPartitionResponse alterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        Assertions.assertEquals((int)1, (int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size());
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isr.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return List$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture submitAndVerify$1(List isr, DefaultAlterPartitionManager alterIsrManager$1) {
        void var3_3;
        CompletableFuture future = alterIsrManager$1.submit(this.tp0(), new LeaderAndIsr(1, 1, isr, LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertFalse((boolean)future.isDone());
        return var3_3;
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

