/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DefaultApiVersionManager;
import kafka.server.ForwardingManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002BB\u0011\u0001A\u0003%a\u0004C\u0004#\u0001\t\u0007I\u0011B\u0012\t\r)\u0002\u0001\u0015!\u0003%\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015a\u0007\u0001\"\u0001e\u0011\u0015q\u0007\u0001\"\u0001e\u0011\u00151\b\u0001\"\u0001e\u0005U\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d+fgRT!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\r\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN,\u0012A\b\t\u00037}I!\u0001\t\u0007\u0003\u001d\t\u0013xn[3s\r\u0016\fG/\u001e:fg\u0006y!M]8lKJ4U-\u0019;ve\u0016\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005D\u0001\t[\u0016$\u0018\rZ1uC&\u0011\u0011F\n\u0002\u00105.lU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013\u0001\u0004;fgR\f\u0005/[*d_B,GCA\u00171!\t\u0019b&\u0003\u00020)\t!QK\\5u\u0011\u0015\td\u00011\u00013\u0003!\t\u0007/[*d_B,\u0007CA\u001aM\u001d\t!\u0014J\u0004\u00026\r:\u0011ag\u0011\b\u0003o\u0005s!\u0001\u000f \u000f\u0005ebT\"\u0001\u001e\u000b\u0005m\u0002\u0012A\u0002\u001fs_>$h(C\u0001>\u0003\ry'oZ\u0005\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A\u001f\n\u0005=\u0011%BA A\u0013\t!U)\u0001\u0004d_6lwN\u001c\u0006\u0003\u001f\tK!a\u0012%\u0002\u000f5,7o]1hK*\u0011A)R\u0005\u0003\u0015.\u000ba\"\u00119j\u001b\u0016\u001c8/Y4f)f\u0004XM\u0003\u0002H\u0011&\u0011QJ\u0014\u0002\r\u0019&\u001cH/\u001a8feRK\b/\u001a\u0006\u0003\u0015.CCA\u0002)];B\u0011\u0011KW\u0007\u0002%*\u00111\u000bV\u0001\taJ|g/\u001b3fe*\u0011QKV\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005]C\u0016a\u00026va&$XM\u001d\u0006\u00033\u0002\u000bQA[;oSRL!a\u0017*\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,XmI\u00013Q\t1q\f\u0005\u0002aC6\tA+\u0003\u0002c)\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002;Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018.\u00138uKJ\u001cXm\u0019;j_:$\u0012!\f\u0015\u0003\u000f\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b,\u0002\u0007\u0005\u0004\u0018.\u0003\u0002lQ\n!A+Z:u\u0003\t\"Xm\u001d;F]Z,Gn\u001c9f\t&\u001c\u0018M\u00197fI\u001a{'o\u0013*bMR\u0014%o\\6fe\"\u0012\u0001BZ\u00010i\u0016\u001cH/\u00128wK2|\u0007/Z#oC\ndW\rZ,iK:4uN]<be\u0012LgnZ'b]\u0006<WM\u001d)sKN,g\u000e\u001e\u0015\u0003\u0013\u0019DC!C9]iB\u0011qM]\u0005\u0003g\"\u0014\u0001\u0002R5tC\ndW\rZ\u0011\u0002k\u0006)TI\\1cY\u0016\u0004\u0013M\u001a;fe\u0002*g.\u00192mK\u0002Z\u0015\nU\u00176sA\u0002cm\u001c:xCJ$\u0017N\\4!S:\u00043*\u0011$L\u00036\n$\u0007\u000f\u001d7\u00039\"Xm\u001d;F]Z,Gn\u001c9f\t&\u001c\u0018M\u00197fI^CWM\u001c$pe^\f'\u000fZ5oO6\u000bg.Y4fe\u0016k\u0007\u000f^=)\u0005)1\u0007")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(1, MetadataVersion.latest(), this.brokerFeatures(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala()).forall((Function1 & Serializable & scala.Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)versionManager.isApiEnabled(apiKey))));
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 1;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache()).apiVersionResponse(0).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledForKRaftBroker() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        new .colon.colon((Object)new Some((Object)forwardingManager), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)forwardingManagerOpt -> {
            ApiVersionManagerTest.$anonfun$testEnvelopeDisabledForKRaftBroker$1(this, forwardingManagerOpt);
            return BoxedUnit.UNIT;
        });
    }

    @Disabled(value="Enable after enable KIP-590 forwarding in KAFKA-12886")
    @Test
    public void testEnvelopeEnabledWhenForwardingManagerPresent() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache());
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        ApiVersionsResponseData.ApiVersion envelopeVersion = versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id);
        Assertions.assertNotNull((Object)envelopeVersion);
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.oldestVersion(), (short)envelopeVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.latestVersion(), (short)envelopeVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledWhenForwardingManagerEmpty() {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }

    public static final /* synthetic */ void $anonfun$testEnvelopeDisabledForKRaftBroker$1(ApiVersionManagerTest $this, Option forwardingManagerOpt) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, forwardingManagerOpt, $this.brokerFeatures(), (MetadataCache)$this.metadataCache());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }
}

